<?php 
$cs = Yii::app()->getClientScript();
$cs->registerScript("getTotal", " function getTotal() 
{ 
var qty = $('#FixedAssetRegister_quantity').val();
var rate = $('#FixedAssetRegister_rate').val();
var tot= Number(qty).toFixed(2)*Number(rate).toFixed(2);
tot=Number(tot).toFixed(2);
$('#FixedAssetRegister_total_value').val(tot);
$('#FixedAssetRegister_current_book_value').val(tot);
$('#FixedAssetRegister_total_value').val(tot);
$('#FixedAssetRegister_current_book_value').addClass('filled');
var master_id= $('#FixedAssetRegister_master_id').val();
jQuery.ajax({
    'dataType':'json',
    'data': {'master_id':master_id}  ,
    'type':'post',
    'url': '" . Yii::app()->createUrl('fixedasset/register/getDepreciation') . "',
    'cache': false,
    'success': function(data) {
      if(data.status=='success'){
        var month=data.val;
        if(month>0)
        {
        var depreciation_val=Number(tot/month).toFixed(2);
        $('#FixedAssetRegister_monthly_depreciation').val(depreciation_val);
        $('#FixedAssetRegister_monthly_depreciation').addClass('filled');
        }
    }
}
  });
}", CClientScript::POS_HEAD); 

$cs->registerScript("getDetails", " function getDetails(val) 
{ 
    jQuery.ajax({
        'dataType':'json',
        'data': {'master_id':val},
        'type':'post',
        'url': '" . Yii::app()->createUrl('fixedasset/register/getMasterDetails') . "',
        'cache': false,
        'success': function(data) {
            if(data.status=='success'){
                var no = data.val;
                // Set part no
                $('#FixedAssetRegister_part_no').val(no);
                $('#FixedAssetRegister_part_no').addClass('filled');

                // Set serial no also
                $('#FixedAssetRegister_serial_no').val(no);
                $('#FixedAssetRegister_serial_no').addClass('filled');
            }
        }
    });
}", CClientScript::POS_HEAD);


?>

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'bank-form',
    'enableAjaxValidation' => false,
    'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
            <?php echo $form->hiddenField($model, 'id'); ?>             
            <?php echo $form->dropdownlist($model, 'master_id',FixedAssetMaster::getAllMaster(),array('class' => 'tooltipster','data-label' => 'Type <span style="color:red">*</span>','prompt'=>'--select--', 'onchange'=>'getDetails(this.value)')); ?>
            </li>
            <li class="col-sm-3">
            <?php 
            if($model->purchase_date!='')
            {
            $purchase_date=date('d/m/Y', strtotime($model->purchase_date));
            }
            else {
            $purchase_date=date('d/m/Y');
            }
            echo $form->textField($model,'purchase_date',array('data-label'=>'Purchase Date *', 'class' => 'datepicker','value'=>$purchase_date)); ?>
            </li>
            <li class="col-sm-3">
            <?php
            if($model->depreciation_start_date!='')
            {
            $start_date= date('d/m/Y', strtotime($model->depreciation_start_date));
            }
            else {
            $start_date= date('d/m/Y');
            } 
            echo $form->textField($model,'depreciation_start_date',array('data-label'=>'Depreciation Start Date *', 'class' => 'datepicker','value'=>$start_date)); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->textField($model, 'part_no', array('data-label' => 'Fixed Asset No *','readonly'=>true)); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->textField($model, 'description', array('data-label' => 'Description *')); ?>
            </li>
            <!-- <li class="col-sm-3">
            <?php //echo $form->textField($model, 'fixed_asset_no', array('data-label' => 'Fixed Asset No')); ?>
            </li> -->
            <li class="col-sm-3">
            <?php echo $form->textField($model, 'serial_no', array('data-label' => 'Serial No')); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->hiddenField($model, 'quantity', array('data-label' => 'Quantity *','class' => 'text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup'=>'getTotal()','value'=>1)); ?>
            <?php echo $form->textField($model, 'rate', array('data-label' => 'Rate','class' => 'text-right', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup'=>'getTotal()')); ?>
            <?php echo $form->hiddenField($model, 'total_value', array('data-label' => 'Value','readonly'=>true,'class' => 'text-right', 'onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->textField($model, 'current_book_value', array('data-label' => 'Current Book Value','class' => 'text-right', 'onkeypress' => 'return isNumberKey(event)')); ?>
            </li>
            <li class="col-sm-3">
            <?php // echo $form->textField($model, 'monthly_depreciation', array('data-label' => 'Monthly Depreciation','class' => 'text-right', 'onkeypress' => 'return isNumberKey(event)','readonly'=>true)); ?>
            </li>
            <li class="col-sm-3">
            <?php echo $form->textField($model, 'location', array('data-label' => 'Location')); ?>
            </li>
            
            <li class="col-sm-3">
            <?php echo $form->textArea($model, 'notes', array('data-label' => 'Notes')); ?>
            </li>
              <li class="col-sm-3">
            <?php 
            if($model->depr_date!='')
            {
            $depr_date=date('d/m/Y', strtotime($model->depr_date));
        
            }
            else {
            $depr_date=date('d/m/Y');
            }
            echo $form->textField($model,'depr_date',array('data-label'=>'Depreciation Date ', 'class' => 'datepicker','value'=>$depr_date)); ?>
            <?php echo $form->hiddenField($model, 'depr_last_date'); ?> 
            </li>
        </ul>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-default " id="bank_close" data-dismiss="modal">Close</button>
<?php
if(!isset($type) && $type!="V")
{
$url = Yii::app()->createUrl('fixedasset/Register/Save');
echo CHtml::ajaxsubmitButton('Save', $url, array(
    'dataType' => 'json',
    'type' => 'post',
    'success' => 'function(data) {
            $("#loader").hide();
            if(data.status=="success"){  
                 t8.success("Asset Saved Successfully!");
                 $("#bank_close").click();
                reloadTable("#tbl_register_fixed_asset_details");

            } else { 
                $("#bank-form .bank-save-btn").prop("disabled", false);
                $("#bank-form .bank-save-btn").addClass("btn-theme").removeClass("btn_loding");
                $.each(data, function(key, val) {
                        t8.error(""+val+""); 
                }); 
            } 
    }',
    'beforeSend' => 'function(){
                                $("#loader").show();
                                $(".toast8-error").hide(); 
                                $("#bank-form .bank-save-btn").prop("disabled", true);
                                $("#bank-form .bank-save-btn").addClass("btn_loding").removeClass("btn-theme");
                            }'
        ), array('id' => 'mybtn' . rand(), 'class' => 'bank-save-btn btn btn-theme'));
}
?>


</div>


    <?php $this->endWidget(); 
    ?>










