<?php
class Depreciate extends CActiveRecord {
    public function tableName() {
        return '{{fixed_asset_depreciation}}';
    }   
    public function rules()
    {
    return array(
    array('depreciation_amount', 'numerical'), 
    array('fixed_asset_register', 'numerical', 'integerOnly' => true),   
    array('id,depreciation_amount,fixed_asset_register', 'safe', 'on' => 'search'),
    );
    }

    public function relations()
	{
	return array(
	'register' => array(self::BELONGS_TO, 'FixedAssetRegister', 'fixed_asset_register'),
	);
    }

    public function search()
	{
		$criteria = new CDbCriteria;
		$criteria->compare('id', $this->id);

		return new CActiveDataProvider($this, array(
			'criteria' => $criteria,
		));
    }

    public static function model($className=__CLASS__)
	{
	return parent::model($className);
    }
}
?>