<?php

class ReportsController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'FixedAssetDetailReport', 'FixedAssetDetail_html', 'FixedAssetDetail_excel', 'GL_pdf'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionFixedAssetDetailReport()
    {
    $this->render('fixed_asset_detail_report');
    }
    public function actionFixedAssetDetail_html()
    {
            $type = (int) $_POST['type'];
            $sold = $_POST['status'];
            $search = trim($_POST['search']);
            $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
            $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');
            $sold_col='';
            $condition = 'H.purchase_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
    
            if ($type > 0) {
            $condition .= ' AND H.master_id=' . $type;
            }
            if ($sold!='') {
            $condition .= ' AND H.active="'.$sold.'"';
            if($sold=='SO')
            {
            $sold_col.='<th style="width:5%" >Sold Amt</th>';
            }
            }
            if ($search!='') {
            $condition .= ' AND (H.part_no like "%'.$search.'%" OR H.description like "%'.$search.'%" OR H.serial_no like "%'.$search.'%")';
            }
            $total_monthly = 0;
            $total_value = 0;
            $total_cbv = 0;
            $total_current_book_value = 0;
            $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                      <thead>
                          <tr>
                            <th style="width:3%" >No</th>
                            <th style="width:7%" >Purch.Date</th>
                            <th style="width:7%" >Depr.St.Dt</th>
                            <th style="width:5%" >Type</th>
                            <th style="width:10%" >Part No</th>
                            <th style="width:20%" >Description</th>
                            <th style="width:10%" >Serial No</th>
                            <th style="width:5%" >Status</th>'.$sold_col.'
                            <th style="width:5%" >Tot. mths</th>
                            <th style="width:5%" >Rem. mths</th>
                            <th style="width:5%;text-align:right !important;" class="text-right">Monthly Depr.</th>
                            <th style="width:5%;text-align:right !important;" class="text-right">Purch. Val</th>
                            <th style="width:5%;text-align:right !important;" class="text-right">Total Depr.</th>
                            <th style="width:5%;text-align:right !important;" class="text-right">C.B.V</th>
                          </tr>
                      </thead> <tbody>';
            // $items = FixedAssetRegister::model()->findAll(array('condition' => $condition, 'order' => 'purchase_date ASC'));
            // $condition.=' AND D.depreciated_date<=CURRENT_DATE()';
            Yii::app()->db->createCommand('CREATE OR REPLACE VIEW fixed_asset_depreciation AS 
            select H.id,H.purchase_date,H.depreciation_start_date,M.fixed_asset_name,H.part_no,H.description,H.serial_no,H.active,H.monthly_depreciation,H.total_value,D.depreciated_date,H.current_book_value,D.depreciation_amount AS cbv,M.depreciation_period,H.sold_amount
            from erp_fixed_asset_register H 
            LEFT JOIN erp_fixed_asset_master M ON H.master_id=M.id 
            LEFT JOIN erp_fixed_asset_depreciation D ON H.id=D.fixed_asset_register
            where '.$condition)->execute();
            $query='select * from fixed_asset_depreciation group by id';

            $items=Yii::app()->db->createCommand($query)->queryAll();
            foreach ($items as $i=>$each) {
                switch($each['active'])
                {
                case "Y" :
                $status="Active";  
                break;
                case "SO" :
                $status="Sold";  
                break;
                case "SC" :
                $status="Scrap";  
                break; 
                }
                $cbv=Yii::app()->db->createCommand("select SUM(cbv) from fixed_asset_depreciation where id=".$each['id'].' AND depreciated_date<=CURRENT_DATE()')->queryScalar();
                $current_book_value=$each['current_book_value'];
                $completed_months=Yii::app()->db->createCommand("select count(*) from fixed_asset_depreciation where id=".$each['id'].' AND depreciated_date<=CURRENT_DATE()')->queryScalar();
                if($sold=='SO')
                {
                $sold_col='<td>'.$each["sold_amount"].'</td>';
                }
                if($each['active']=="Y")
                {
                $current_book=$current_book_value-$cbv;
                }
                else {
                $current_book=0;    
                }
                $table .= '<tr>
                <td>'.($i+1).'</td>
                <td>' . date("d/m/Y", strtotime($each["purchase_date"])) . '</td>
                <td>' . date("d/m/Y", strtotime($each["depreciation_start_date"])) . '</td>
                <td>'.$each["fixed_asset_name"].'</td>
                <td>'.$each["part_no"].'</td>
                <td>'.$each["description"].'</td>
                <td>'.$each["serial_no"].'</td>
                <td>'.$status.'</td>'.$sold_col.'
                <td>'.$each['depreciation_period'].'</td>
                <td>'.($each['depreciation_period']-$completed_months).'</td>
                <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each["monthly_depreciation"], " ") . '</td>
                <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each["total_value"], " ") . '</td>
                <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($cbv, " ") .'</td>
                <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($current_book, " ") .'</td>
                </tr>';
            $total_monthly+=$each["monthly_depreciation"];
            $total_value+=$each["total_value"];
            $total_cbv+=$cbv;
            $total_current_book_value+=$current_book;
            }
            if($sold=='SO')
            {
            $colspan=11;
            }
            else {
            $colspan=10;    
            }
            $table .= '<tr>
                          <td colspan="'.$colspan.'" style="text-align:right !important;"><b>Total</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_monthly), " ") . '</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_value), " ") . '</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_cbv), " ") . '</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_current_book_value), " ") . '</b></td>
                      </tr>';
            $table .= '</tbody>
                  </table>';
            echo $table;
    }
    public function actionFixedAssetDetail_excel()
    { 
        $type = (int) $_REQUEST['type'];
        $sold = $_REQUEST['status'];
        $search = trim($_REQUEST['search']);
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');
        $sold_col='';
        $condition = 'H.purchase_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

        if ($type > 0) {
        $condition .= ' AND H.master_id=' . $type;
        }
        if ($sold!='') {
        $condition .= ' AND H.active="'.$sold.'"';
        if($sold=='SO')
        {
        $sold_col.='<th style="width:5%" >Sold Amt</th>';
        }
        }
        if ($search!='') {
        $condition .= ' AND (H.part_no like "%'.$search.'%" OR H.description like "%'.$search.'%" OR H.serial_no like "%'.$search.'%")';
        }
        $total_monthly = 0;
        $total_value = 0;
        $total_cbv = 0;
        $total_current_book_value = 0;
        Yii::app()->db->createCommand('CREATE OR REPLACE VIEW fixed_asset_depreciation AS 
            select H.id,H.purchase_date,H.depreciation_start_date,M.fixed_asset_name,H.part_no,H.description,H.serial_no,H.active,H.monthly_depreciation,H.total_value,D.depreciated_date,H.current_book_value,D.depreciation_amount AS cbv,M.depreciation_period,H.sold_amount
            from erp_fixed_asset_register H 
            LEFT JOIN erp_fixed_asset_master M ON H.master_id=M.id 
            LEFT JOIN erp_fixed_asset_depreciation D ON H.id=D.fixed_asset_register
            where '.$condition)->execute();
            $query='select * from fixed_asset_depreciation group by id';

            $items=Yii::app()->db->createCommand($query)->queryAll();
    
            Yii::import('ext.PHPExcel.PHPExcel');
    
            $excel = new PHPExcel();
    
            // Set document properties
            $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
            $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
            $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
            $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
    
            $excel->getProperties()->setCreator("Bluesky ERP")
                ->setLastModifiedBy("Bluesky ERP")
                ->setTitle("Fixed Asset Report")
                ->setSubject("Fixed Asset Report")
                ->setDescription("Fixed Asset Report Generated on " . date('d/m/Y'))
                ->setKeywords("Fixed Asset Report")
                ->setCategory("Fixed Asset Report");
    
            // Add some data
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A1', 'Purchase Date')
                ->setCellValue('B1', 'Depreciation Start Date')
                ->setCellValue('C1', 'Type')
                ->setCellValue('D1', 'Part No')
                ->setCellValue('E1', 'Description')
                ->setCellValue('F1', 'Serial No')
                ->setCellValue('G1', 'Status')
                ->setCellValue('H1', 'Total Months')
                ->setCellValue('I1', 'Remaining Months')
                ->setCellValue('J1', 'Monthly Depreciation')
                ->setCellValue('K1', 'Purchase Value')
                ->setCellValue('L1', 'Total Depreciation')
                ->setCellValue('M1', 'CBV');
    
            $border = array(
                'borders' => array(
                    'bottom' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '#1E1F20'),
                    ),
                ),
            );
    
            $excel->getActiveSheet(0)->getStyle('A1:M1')->applyFromArray($border);
    
            $excel->getActiveSheet()->getStyle('A1:M1')->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => 'd9d9d9',
                ),
            ));
    
            $excel->getActiveSheet()->getStyle('A1:M1')->getFont()->setBold(true)->setSize(12);
    
            $rowId = 2;
            $total_monthly = 0;
            $total_value = 0;
            $total_cbv = 0;
            $total_current_book_value = 0;
            foreach ($items as $each) {

                switch($each['active'])
                {
                case "Y" :
                $status="Active";  
                break;
                case "SO" :
                $status="Sold";  
                break;
                case "SC" :
                $status="Scrap";  
                break; 
                }

                $cbv=Yii::app()->db->createCommand("select SUM(cbv) from fixed_asset_depreciation where id=".$each['id'].' AND depreciated_date<=CURRENT_DATE()')->queryScalar();
                $current_book_value=$each['current_book_value'];
                $completed_months=Yii::app()->db->createCommand("select count(*) from fixed_asset_depreciation where id=".$each['id'].' AND depreciated_date<=CURRENT_DATE()')->queryScalar();
                if($sold=='SO')
                {
                $sold_col='<td>'.$each["sold_amount"].'</td>';
                }
                if($each['active']=="Y")
                {
                $current_book=$current_book_value-$cbv;
                }
                else {
                $current_book=0;    
                }    
    
                $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, date("d/m/Y", strtotime($each["purchase_date"])))
                    ->setCellValue('B' . $rowId, date("d/m/Y", strtotime($each["depreciation_start_date"])))
                    ->setCellValue('C' . $rowId, $each["fixed_asset_name"])
                    ->setCellValue('D' . $rowId, $each["part_no"])
                    ->setCellValue('E' . $rowId, $each["description"])
                    ->setCellValue('F' . $rowId, $each["serial_no"])
                    ->setCellValue('G' . $rowId, $status)
                    ->setCellValue('H' . $rowId, $each['depreciation_period'])
                    ->setCellValue('I' . $rowId, ($each['depreciation_period']-$completed_months))
                    ->setCellValue('J' . $rowId, Yii::app()->numberFormatter->formatCurrency($each["monthly_depreciation"], " "))
                    ->setCellValue('K' . $rowId, Yii::app()->numberFormatter->formatCurrency($each["total_value"], " "))
                    ->setCellValue('L' . $rowId, Yii::app()->numberFormatter->formatCurrency($cbv, " "))
                    ->setCellValue('M' . $rowId, Yii::app()->numberFormatter->formatCurrency($current_book, " "));
            $total_monthly+=$each["monthly_depreciation"];
            $total_value+=$each["total_value"];
            $total_cbv+=$cbv;
            $total_current_book_value+=$current_book;
                $rowId++;
            }
    
            $excel->getActiveSheet(0)->getStyle('A' . ($rowId - 1) . ':M' . ($rowId - 1))->applyFromArray($border);
            $excel->getActiveSheet(0)->getStyle('A' . $rowId . ':M' . $rowId)->applyFromArray($border);
    
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, 'Total')
                ->setCellValue('J' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_monthly, " "))
                ->setCellValue('K' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_value, " "))
                ->setCellValue('L' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_cbv, " "))
                ->setCellValue('M' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_current_book_value, " "));
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':M' . $rowId)->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':I' . $rowId);
        
            // Rename worksheet
            $excel->getActiveSheet()->setTitle("Fixed Asset Report");
    
            // $excel->getActiveSheet()
            //     ->getStyle('C2:D' . $rowId)
            //     ->getAlignment()
            //     ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
    
            // Redirect output to a client’s web browser (Excel2007)
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="Fixed Asset Report.xlsx"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
    
            // If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
    
            $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
            $objWriter->save('php://output');
            exit;
    }
}
?>