
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("loadPage", "function loadPage(){
            if( $('#employee').val() > 0 ){
                    $('#loader').show();
                    jQuery.ajax({
                        'type': 'post',
                        'url': '" . Yii::app()->createUrl('finance/reports/Employeewise_report_html') . "',
                        'data' : { 'employee' : $('#employee').val(), 'from' : $('#fn_report_from').val(), 'to' : $('#fn_report_to').val() },
                        'success': function(data) {
                            $('#data_div').show();
                            $('.main-li-data').html(data);
                            $('#loader').hide();
                        }
                    });
                }else{
                    t8.error('Choose employee!');
                }
        }", CClientScript::POS_HEAD);

        $cs->registerScript("getSublegders", "function getSublegders(field_id, type)
        {
   
           $('#subledger_id').val(0);

                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist_all') . "';
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#subledger_name').val(ui.item.label);
                        $('#subledger_id').val(ui.item.value);
                    }
                })
        }", CClientScript::POS_HEAD); 
        $cs->registerScript("load_details", "function load_details(from_date, to_date, subledger_id){
            $('#loader').show();
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/reports/pl_emp_detailed') . "',
                'data' : { 'subledger_id' : subledger_id, 'to' : to_date, 'from' : from_date },
                'success': function(data) {
                    $('#pl_emp_li').removeClass('active');
                    $('#pl_emp_tab').removeClass('active');
                    $('#pl_emp_detailed_li').show();
                    $('#pl_emp_detailed_li').addClass('active');
                    $('#pl_emp_detailed_tab').addClass('active');
                    $('#pl_emp_detailed_tab').html(data);
                    $('#loader').hide();
                }
            });
        }", CClientScript::POS_HEAD);

?>

<style>
table {
  font-family: arial, sans-serif !important;
  border-collapse: collapse !important;
  width: 100% !important;
}

td, th {
  border: 1px solid #dddddd !important;
  text-align: left !important;
  padding: 8px !important;
}

table th{
	padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #1f67b2;
    color: white;
}

tr:nth-child(even) {
  background-color: #f2f2f2 !important;
}
</style>
<div class="row">
    <div class="col-sm-12">
        <section class="panel">
            <header class="panel-heading clearfix">
                <ul class="clearfix form-ul material">
                    <li class="col-sm-2">
                        <?php echo CHtml::textField('fn_report_from', date('01/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'From Date')); ?>
                    </li>
                    <li class="col-sm-2">
                    <?php echo CHtml::textField('fn_report_to', date('t/m/Y'), array('class' => 'datepicker tooltipster', 'data-label' => 'To Date')); ?>
                    </li>
                    <li class="col-sm-4">
                    <?php echo CHtml::dropDownList("employee", '',FinanceSubledger::getEmployeeSubledgers(), array('data-label' => 'Employee', 'class' => 'tooltipster', 'data-search' => true)); ?>
                    </li>
                    <div class="btn-wrap text-center">
                        <a type="button" class="btn btn-sm btn-theme" onclick="loadPage();">HTML</a>
                         <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/Employeewise_report_pdf&from_date='+$('#fn_report_from').val()+'&to_date='+$('#fn_report_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val()+'&brand='+$('#brand').val()+'&employee='+$('#employee').val(), '_blank'); ">PDF</a>
                        <a type="button" class="btn btn-sm btn-theme" onclick="window.open($('#liveSite').val()+'index.php?r=finance/reports/Employeewise_report_excel&from_date='+$('#fn_report_from').val()+'&to_date='+$('#fn_report_to').val()+'&ledger='+$('#ledger_id').val()+'&subledger='+$('#subledger_id').val()+'&brand='+$('#brand').val()+'&employee='+$('#employee').val(), '_blank');">XLS</a> 
                    </div>
                </ul>
            </header>
            <div class="panel-body" id="data_div" style="display:none;" >
                <div class="tab-content">
                    <div class="tab-pane main-li-data active" id="pl_emp_tab">
                    </div>
            </div>
        </section>
    </div>
</div>
