<?php 

    $secure =  FinanceVoucherType::isSecure( (int) $voucher );

  

    if( $secure ){

        $voucherModel = FinanceVoucherType::model()->findBypk( $voucher );

        $itemModel = $voucherModel->header_table;

        $dateField = $voucherModel->date_field;

        $currencyField = $voucherModel->currency_field;

        $exchangeRate = $voucherModel->exchange_rate_field;

        $grandTotal = $voucherModel->grand_total_value;

        $totalSales = $voucherModel->sales_value;

        $totalSaleswotax = $voucherModel->sales_wo_tax;

        $vat = $voucherModel->vat_value;

        $costValue = $voucherModel->cost_value;

        $updateField = $voucherModel->status_field;

        $voucherReference = $voucherModel->voucher_reference;

        $debtor_creditor_label = $voucherModel->label_field;

        $code = $voucherModel->code;

        $status = ( $status == 'NEW' ) ? 'N' : 'Y';

        $fetchingModel = $itemModel::model()->findAll( array( 'condition' => $dateField.' BETWEEN "'.$from_date.'" AND "'.$to_date.'" AND '.$updateField.'="'.$status.'"') );

    }

?>



<table class="table table-hover table-bordered" id="table_post" >        

    <tr>

        <th><?php echo CHtml::CheckBox('checkAll',false,array('class'=>'checkall','id'=>'all','onclick'=>' $("#table_post input:checkbox").prop("checked", $(this).prop("checked"));')); ?> </th>   

        <th>Reference</th>            

        <th>Date</th>

        <th>Debtor/Creditor</th>   

        <th>Currency</th>           

        <th>Total</th>           

        <th>Total (BC)</th>        
        
        <th>Export</th>     

    </tr>

    <?php if( $secure ) { ?>

        <?php if( !empty($fetchingModel) ){ ?>

            <?php foreach( $fetchingModel as $each ) : 
            if($voucherModel->code!='SI' || ($voucherModel->code=='SI' && $each->invoice_status=='Y') ) 
            {
                $haveVat = false;
                    if( $each->$vat > 0 )
                        $haveVat = true;
                $hire=false;
                if($voucherModel->code=='SI')
                {
                if($each->invoice_nature=='H')
                {
                $hire=true;    
                }
                }
                ?>

                <tr>

                    <td><?php echo CHtml::CheckBox('ids[]','',array('value' => $each->id)); ?></td>

                    <td><?php echo $each->$voucherReference; ?></td>

                    <td><?php echo date('d/m/Y', strtotime($each->$dateField)); ?></td>

                    <td><?php echo $each->$debtor_creditor_label; ?></td>

                    <td><?php echo $each->$currencyField; ?></td>

                    <td><?php  
                    switch($voucherModel->code)
                    {
                    case 'SI' :
                    $total=$each->grand_total;
                    break; 
                    case 'PI' :
                    $total=$each->grand_total;
                    break; 
                    case 'CN' :
                    $total=$each->credited_amount;
                    break; 
                    case 'DN' :
                    $total=$each->debited_amount;
                    break; 
                    case 'GI' :
                    $total=$each->$grandTotal;
                    break; 
                    case 'GR' :
                    $total=$each->$grandTotal;
                    break; 
                    }
                    echo  round($total, 2); ?></td>

                    <td><?php echo round( ($total), 2); ?></td>

                    <td><a href="#" title="export PDF" onclick="<?php echo FinanceVoucherHead::generateUrl($code, $each->id, $haveVat,$hire) ?>" class="btn btn-xs btn-theme"><i class="fa fa-file-pdf-o"></i></a></td>

                </tr>
            <?php } ?>
            <?php endforeach; ?>

            <?php } else {  ?>

                <tr>

                    <td colspan="8" class="text-center">No Items</td>

                </tr>

            <?php } ?>

    <?php } else {  ?>

            <tr>

                <td colspan="8" class="text-center">Not properly mapped</td>

            </tr>

    <?php } ?>

</table>