<?php 
    $cs = Yii::app()->getClientScript();
    $cs->registerScript("reloadPage", "function reloadPage(){
        var from_date = $('#from_date').val();
        var to_date = $('#to_date').val();
        var voucher = $('#voucher_selection').val();
        var status = $('#status').val();
        $('#loader').show();

        jQuery.ajax({
            'type': 'post',
            'url': '" . Yii::app()->createUrl('finance/core/getimportvouchers') . "',
            'data' : {'from_date' : from_date,'to_date' : to_date, 'voucher' : voucher, 'status' : status},
            'success': function(data) { 
                $('#loader').hide();
                $('#table_dis_div').show();
                $('#table_dis_div').html(data);
            }
        });
    }", CClientScript::POS_HEAD);
    $form = $this->beginWidget('CActiveForm', array(
        'id' => 'ledger-form',
        'enableAjaxValidation' => false,
        'enableClientValidation' => false,
    ));
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-3">
                <?php
                $fvoucher=new FinanceVoucherType();
                ?>
                <?php echo CHtml::dropdownlist('voucher_selection', '', $fvoucher->importable(), array('data-label'=>'Voucher', 'onchange' => '$("#table_dis_div").empty();')); ?>
           </li>
            <li class="col-sm-2">
                <?php echo CHtml::textField('from_date', date('01/m/Y'),array('data-label'=>'From <span style="color:red">*</span>', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-2">
                <?php echo CHtml::textField('to_date', date('t/m/Y'),array('data-label'=>'To <span style="color:red">*</span>', 'class' => 'datepicker')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::dropdownlist('status', '', array( 'NEW' => 'Post', 'EXISTING' => 'Unpost'), array('data-label'=>'Operation', 'onchange' => '$("#table_dis_div").empty();')); ?>
           </li>
           <li class="col-sm-2">
                <a class="btn btn-sm btn-theme" onclick="reloadPage();"><i class="fa fa-retweet"></i> Refresh</a>
           </li>
        </ul>
        <div class="table-responsive" id="table_dis_div" >
         </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger"  data-dismiss="modal">Close</button>
    <?php
        
        echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('finance/core/savemodulevouchers'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                            $("#loader").hide();
                            if(data.status=="success"){  
                                t8.success("Done!");
                                loadPopupModal("finance/core/importvouchers","Import","xl");
                                reloadTable("#fin_voucher_table");
                            }else{ 
                                $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                                }); 
                            } 
                        }',
                        'beforeSend' => 'function(){
                            $("#loader").show();
                        }',
            ), array('id' => 'mybtn' . rand(), 'class' => 'btn btn-theme'));
           
    ?>
</div>
<?php $this->endWidget(); ?>
<script>
    $('#from_date').on('dp.change', function(e){ 
        $("#table_dis_div").empty();
        return false;
    });
    $('#to_date').on('dp.change', function(e){ 
        $("#table_dis_div").empty();
        return false;
    });
</script>
<script>
    // $(function (){
    //     <?php // $accouning_year = FinanceVoucherType::accountingPeriod('d/m/Y'); ?>
    //     var date_value = "<?php //echo $accouning_year['from'] ?>";
    //     date_value = date_value.split("/");
    //     var current = new Date(date_value[2], date_value[1] - 1, date_value[0]);
    //     $('#from_date').datetimepicker({  
    //         minDate:current,
    //         format: 'DD/MM/YYYY'
    //     });
    // });
   
</script>
