
<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript("deleteReconciliation",  "function deleteReconciliation(id){
    var r = confirm('Are you sure to delete this?');
    if(r==true)
        jQuery.ajax({
            'type'  : 'post',
            'data'  : {'id' : id},
            'url'  : $('#liveSite').val()+'index.php?r=finance/core/deletereconciliation',
            'cache': false,
            'success':function(data){
                if(data=='success'){
                    t8.success('Done!');
                    reloadTable('#fin_table_reconciliation');
                }else{
                    t8.error(data);
                }
            }
        });
};", CClientScript::POS_HEAD);

$cs->registerScript("load", 
                '$(document).ready(function() {
                    var table_id ="#fin_table_reconciliation";
                    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.from_date = $("#start_date").val();
                        data.to_date = $("#end_date").val();
                        return data;
                    }).DataTable({
                    scrollY         : "450px",
                    pageLength      : 100,
                    columns: [
                        {className: "sl col-max-2"},
                        {className: "sl col-max-3"},
                        {className: "sl col-max-4"},
                        {className: "sl col-max-4"},
                        {className: "sl col-max-3"},
                        {className: "sl col-max-3"},
                    ],
                    ajax: {
                        url: "' . Yii::app()->createUrl('finance/core/get_reconciliation_history') . '",
                        type: "POST",
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
                    processing: true,
                    order: [[ 1, "desc" ]],
                });
                $(".dataTables_scrollFoot").hide();
            });', CClientScript::POS_HEAD);

  ?>
    <section class="panel" style="background-color:#F6F3EE;">
        <header class="panel-heading clearfix panel-theame">
            <i class="fa fa-check"></i> Reconciliation History
            <div class="pull-right" style="display: flex;">
                <?php echo CHtml::textfield('start_date',date('01/01/Y'),array('class' => 'datepicker form-control', 'style' => 'margin-right:10px; width:120px;')); ?>
                <?php echo CHtml::textfield('end_date',date('t/m/Y'),array('class' => 'datepicker form-control', 'style' => 'margin-right:10px; width:120px;')); ?>
                <button class="btn btn-sm btn-theme" style="margin-right: 10px;" title="Reload" onclick="reloadTable('#fin_table_reconciliation');"><i class="fa fa-retweet"></i></button>
                <button class="btn btn-sm btn-theme" title= "Reconciliation" onclick="loadPopupModal('finance/core/chequemanagementnew','Reconciliation','xl')"><i class="fa fa-check"></i></button>
                <!-- <button class="btn btn-sm btn-theme" title= "Reconciliation" onclick="loadPopupModal('finance/core/reconciliation','Reconciliation','xl')"><i class="fa fa-check"></i></button> -->
            </div>
        </header>
        <div class="panel-body">
            <div class="custom-data-table">
                <table class="table table-hover table-bordered personal-task" id="fin_table_reconciliation" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Statement Date</th>
                            <th>Ledger</th>
                            <th>Subledger</th>
                            <th>Vouchers</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                   
                </table>
            </div>
        </div>
    </section>
