<style>
.table>tbody>tr>td{
  padding: 3px 8px;
}
.form-control {
    width: 100% !important;
}
@media screen (min-width: 1920px) and (max-width: 1080px) {
   .table>thead:first-child>tr:first-child>th {
    
}
}
</style>
<?php 
        $cs = Yii::app()->getClientScript();
        $cs->registerScript("getBalances", "function getBalances(){
            jQuery.ajax({
                'type': 'post',
                'dataType' : 'json',
                'url': '" . Yii::app()->createUrl('finance/core/getbalances') . "',
                'data' : {'ledger' :  $('#ledger_id').val(), 'subledger' : $('#subledger_id').val(), 'date' : $('#statement_date').val() },
                'success': function(data) { 
                    $('#current_balance').val(data.current_balance).addClass('filled');
                    $('#opening_balance').val(data.opening_balance).addClass('filled');
                }
            });
        }", CClientScript::POS_HEAD);
        $cs->registerScript("updatetextfield", "function updatetextfield(value){
            
            $('#subledger_name').val('');
            $('#subledger_id').val('');
            $('#table_one').hide();
            $('#table_two').hide();
            $('#funds_in').empty();
            $('#funds_out').empty();
            $('#footer_values_table_1').hide();
            $('#footer_values_table_2').hide();
            $('#current_balance').val(0);
            $('#opening_balance').val(0);
            // $('.recon-btn').hide();

            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('finance/core/havesubledger') . "',
                'data' : {'account' : value},
                'success': function(data) { 
                    if( data == 'true' ){
                        $('#subledger_name').attr( 'disabled', false );
                        $('#subledger_id').val('');
                        $('#have_subledger').val('Y');
                    }else{
                        $('#subledger_name').attr( 'disabled', true );
                        $('#subledger_name').val('');
                        $('#subledger_id').val('');
                        $('#have_subledger').val('N');
                        getBalances();
                    }
                }
            });
        }", CClientScript::POS_HEAD);
        $cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
            var account_id = $('#ledger_id').val();
           
            $('#table_one').hide();
            $('#table_two').hide();
            $('#funds_in').empty();
            $('#funds_out').empty();
            $('#footer_values_table_1').hide();
            $('#footer_values_table_2').hide();
            $('#current_balance').val(0);
            $('#opening_balance').val(0);
            $('#subledger_id').val(0);
            $('.recon-btn').hide();

            if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('finance/vouchers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#subledger_name').val(ui.item.label);
                        $('#subledger_id').val(ui.item.value);
                        getBalances();
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD); 
        $cs->registerScript("reloadPage", "function reloadPage(){
            var subledger = $('#subledger_id').val();
            var ledger = $('#ledger_id').val();
            var from = $('#from_date').val();
            var to = $('#to_date').val();
            var have_subledger = $('#have_subledger').val();
            if( ( have_subledger == 'Y' && subledger > 0 ) && ledger > 0 ) {
                $('#loader').show();
                jQuery.ajax({
                    'type': 'post',
                    'dataType' : 'json',
                    'url': '" . Yii::app()->createUrl('finance/core/get_unreconciled_vouchers') . "',
                    'data' : {'ledger' : ledger, 'subledger' : subledger, 'from_date' : from, 'to_date' : to },
                    'success': function(data) { 
                        $('#loader').hide();
                        $('#table_one').show();
                        $('#table_two').show();
                        $('#funds_in').html(data.funds_in);
                        $('#funds_out').html(data.funds_out);
                        $('#funds_in_foot').html(data.funds_in_foot);
                        $('#funds_out_foot').html(data.funds_out_foot);
                        $('#footer_values_table_1').show();
                        $('#footer_values_table_2').show();
                        getBalances();
                        calculateValue();
                    }
                });
            }else{
                t8.error('Choose all fields!');
            }
        }", CClientScript::POS_HEAD);
        $cs->registerScript("calculateValue", "function calculateValue()
        {
            var opening_balance = Number($('#opening_balance').val());
            var closing_balance = Number($('#current_balance').val());

            var total_funds_in = 0;
            $('#fund_in_table').find('tr:gt(0)').each(function() {
                if( $(this).find('[id $=_check]').prop('checked') )
                    total_funds_in += parseFloat($(this).find('[id $=_value]').val());
            });
            $('#total_funds_in').val(Number(total_funds_in).toFixed(2));

            var total_funds_out = 0;
            $('#fund_out_table').find('tr:gt(0)').each(function() {
                if( $(this).find('[id $=_check]').prop('checked') )
                    total_funds_out += parseFloat($(this).find('[id $=_value]').val());
            });
            $('#total_funds_out').val(Number(total_funds_out).toFixed(2));
            
            var reconciled = opening_balance + total_funds_in - total_funds_out;
            $('.reconciled_total').text(Number(reconciled).toFixed(2));

            var diff = closing_balance - reconciled;
            $('.difference_div').text(Number(diff).toFixed(2));

            if( diff == 0  && ( total_funds_in > 0 || total_funds_out > 0 ) )
                $('.recon-btn').show();
            else
                $('.recon-btn').hide();

        }", CClientScript::POS_HEAD); 

        $form = $this->beginWidget('CActiveForm', array(
            'id' => 'voucher-form',
            'enableAjaxValidation' => false,
            'enableClientValidation' => false,
        ));
        
?>
<div class="tab-content">
    <div class="tab-pane active">
        <ul class="clearfix form-ul material">
            <li class="col-sm-2">
            <?php echo CHtml::textField("from_date",date('d/m/Y'),array('data-label'=>'From Date', 'class' => 'datepicker tooltipster')); ?>
            </li>
            <li class="col-sm-2">
            <?php echo CHtml::textField("to_date",date('d/m/Y'),array('data-label'=>'To Date', 'class' => 'datepicker tooltipster')); ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::dropdownlist("ledger_id", '', FinanceLegder::getChilds(), array('class'=>'tooltipster', 'data-label' => 'Ledgers' ,'prompt' => '-select-', 'data-search' => true, 'onChange' => 'js:updatetextfield(this.value)')); //getAll ?>
            </li>
            <li class="col-sm-3">
                <?php echo CHtml::hiddenField("subledger_id"); ?>
                <?php echo CHtml::hiddenField("have_subledger"); ?>
                <?php echo CHtml::textField("subledger_name",'',array('data-label'=>'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id);', 'data-label' => 'Sub ledger' )); ?>
            </li>
            <!-- <li class="col-sm-2">
                <?php //echo CHtml::textField("opening_balance",'',array('data-label'=>'Opening Balance', 'class' => 'tooltipster', 'readonly' => true)); ?>
            </li> -->
            <!-- <li class="col-sm-2">
                <?php //echo CHtml::textField("statement_date",date('d/m/Y'),array('data-label'=>'Statement Date', 'class' => 'datepicker tooltipster')); ?>
            </li> -->
            <!-- <li class="col-sm-2">
                <?php //echo CHtml::textField("current_balance",'',array('data-label'=>'Closing Balance', 'class' => 'tooltipster', 'onkeypress' => 'return isNumberKey(event)', 'onkeyup' => 'calculateValue();', 'onBlur' => 'return isNumberKey(event); calculateValue();')); ?>
            </li> -->
            <div class="btn-wrap text-center">
                <a class="btn btn-sm btn-theme" onclick="reloadPage();"><i class="fa fa-retweet"></i> Refresh</a>
            </div>
        </ul>
        <div class="row">
            <div class="col-sm-6">
                <div class="table-responsive" style="height:500px; max-height:500px; display:none" id="table_one">
                    <u><b>Funds In</b></u>
                    <table class="table table-bordered" id="fund_in_table" style="width:auto;">        
                        <thead style="position: relative;display: block;width:auto;overflow: hidden;">
                            <tr>
                                <th style="padding: 3px 34px;">Date</th>
                                <th style="padding: 3px 17px;">Voucher</th>
                                <th style="padding: 3px 20.5px;">Type</th>      
                                <th style="padding: 3px 116px;">Description</th>
                                <th class="text-right" style="padding: 3px 36px;">Value</th>     
                            </tr>   
                        </thead>
                        <tbody id="funds_in" style="position: relative;display: block;width: 100%;height: 340px;overflow-x: scroll;">
                        </tbody>
                        <!-- <tfoot id="funds_in_foot" style="display: block;position: relative;display: block;width: auto;overflow: visible;">
                        </tfoot> -->
                    </table>
                </div>
            </div>
            <div class="col-sm-6">
                <div class="table-responsive" style="height:500px; max-height:500px; display:none" id="table_two">
                    <u><b>Funds Out</b></u>
                    <table class="table table-bordered" id="fund_out_table" style="width:auto;">        
                        <thead style="position: relative;display: block;width:auto;overflow: hidden;">
                        <tr>
                                <th style="padding: 3px 34px;">Date</th>
                                <th style="padding: 3px 17px;">Voucher</th>
                                <th style="padding: 3px 20.5px;">Type</th>      
                                <th style="padding: 3px 116px;">Description</th>
                                <th class="text-right" style="padding: 3px 36px;">Value</th>     
                            </tr> 
                        </thead>
                        <tbody id="funds_out" style="position: relative;display: block;width: 100%;height: 340px;overflow-x: scroll;">
                        </tbody>
                        <!-- <tfoot id="funds_out_foot" style="display: block;position: relative;display: block;width: auto;overflow: visible;">
                        </tfoot> -->
                    </table>
                </div>
            </div>
            <!-- <div class="col-sm-12" id="footer_values_table_1" style="display:none;">
                <table class="table table-hover table-bordered table-nexted order_total">
                    <tr class="bg-total" height="20px" >
                        <td width="60%" class="text-right table_total_title">
                            <h4>Reconciled</h4>
                        </td>
                        <td width="40%" class="text-right table_total">
                            <h4 class="reconciled_total"  class="text-right"><?php //echo Yii::app()->numberFormatter->formatCurrency(0, " "); ?></h4>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="col-sm-12" id="footer_values_table_2" style="display:none;">
                <table class="table table-hover table-bordered table-nexted order_total">
                    <tr class="bg-total" height="20px" >
                        <td width="60%" class="text-right table_total_title">
                            <h4>Difference</h4>
                        </td>
                        <td width="40%" class="text-right table_total">
                            <h4 class="difference_div" class="text-right"><?php //echo Yii::app()->numberFormatter->formatCurrency(0, " "); ?></h4>
                        </td>
                    </tr>
                </table>
            </div> -->
        </div>
    </div>
</div>
<div class="modal-footer">
    <button type="button" class="btn btn-danger" id="cust_close" data-dismiss="modal">Close</button>
    <?php
        
        echo CHtml::ajaxSubmitButton('Save', Yii::app()->createUrl('finance/core/savereconciliation'), array(
            'dataType' => 'json',
            'type' => 'post',
            'success' => 'function(data) {
                            $("#loader").hide();
                            if(data.status=="success"){  
                                t8.success("Done!");
                                $(".x.close").click();
                                reloadTable("#fin_table_reconciliation");
                            }else{ 
                                $.each(data, function(key, val) {
                                    t8.error(""+val+""); 
                                }); 
                            } 
                        }',
                        'beforeSend' => 'function(){
                            $("#loader").show();
                        }',
            ), array('id' => 'mybtn' . rand(), 'class' => 'recon1-btn btn btn-theme'));
           
    ?>
    </div>
<?php $this->endWidget(); ?>

<script>
    $("#statement_date").on("dp.change", function (e) {
        if( $('#have_subledger').val() == 'N' && $('#ledger_id').val() > 0 ){
            reloadPage();
        }else if( $('#have_subledger').val() == 'Y' && $('#ledger_id').val() > 0 && $('#subledger_id').val() > 0 ){
            reloadPage();
        }
    });
</script>