<?php

/**
 * This is the model class for table "{{finance_voucher_type}}".
 *
 * The followings are the available columns in table '{{finance_voucher_type}}':
 * @property integer $id
 * @property string $code
 * @property string $description
 * @property string $system_generated
 * @property string $have_mappings
 * @property string $starting_series
 * @property string $last_voucher_no
 * @property string $isActive
 * @property string $header_table
 * @property string $date_field
 * @property string $sales_value
 * @property string $sales_wo_tax
 * @property string $vat_value
 * @property string $cost_value
 * @property string $status_field
 */
class FinanceVoucherType extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{finance_voucher_type}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('code, description', 'required'),
			array('starting_series', 'required', 'on' => 'noMapping'),
			array('header_table, date_field, status_field, label_field, voucher_reference, currency_field, exchange_rate_field', 'required', 'on' => 'haveMapping'),
			array('code', 'length', 'max'=>45),
			array('description, header_table, date_field, sales_value, sales_wo_tax, vat_value, cost_value, status_field, grand_total_value, footer_addition_items, footer_addition_type, footer_deduction_items, footer_deduction_type, footer_id_field, footer_value_field, rcm_compare_field, rcm_true_value', 'length', 'max'=>255),
			array('system_generated, have_mappings, isActive', 'length', 'max'=>1),
			array('starting_series, last_voucher_no', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, code, description, system_generated, have_mappings, starting_series, last_voucher_no, isActive, header_table, date_field, sales_value, sales_wo_tax, vat_value, cost_value, status_field', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'items' => array(self::HAS_MANY, 'FinanceVoucherTypeMappings', 'voucher_type', 'order' => 'items.id asc'),
			'rcm_items' => array(self::HAS_MANY, 'FinanceVoucherTypeMappings', 'voucher_type', 'condition' => 'rcm_comparison IN ("NORMAL", "RTRUE")', 'order' => 'rcm_items.id asc'),
			'non_rcm_items' => array(self::HAS_MANY, 'FinanceVoucherTypeMappings', 'voucher_type', 'condition' => 'rcm_comparison IN ("NORMAL", "RFALSE")', 'order' => 'non_rcm_items.id asc'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'code' => 'Code',
			'description' => 'Description',
			'system_generated' => 'System Generated',
			'have_mappings' => 'Have Mappings',
			'starting_series' => 'Starting Series',
			'last_voucher_no' => 'Last Voucher No',
			'isActive' => 'Is Active',
			'header_table' => 'Header Table',
			'date_field' => 'Date Field',
			'sales_value' => 'Sales Value',
			'sales_wo_tax' => 'Sales Wo Tax',
			'vat_value' => 'Vat Value',
			'cost_value' => 'Cost Value',
			'status_field' => 'Status Field',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('code',$this->code,true);
		$criteria->compare('description',$this->description,true);
		$criteria->compare('system_generated',$this->system_generated,true);
		$criteria->compare('have_mappings',$this->have_mappings,true);
		$criteria->compare('starting_series',$this->starting_series,true);
		$criteria->compare('last_voucher_no',$this->last_voucher_no,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('header_table',$this->header_table,true);
		$criteria->compare('date_field',$this->date_field,true);
		$criteria->compare('sales_value',$this->sales_value,true);
		$criteria->compare('sales_wo_tax',$this->sales_wo_tax,true);
		$criteria->compare('vat_value',$this->vat_value,true);
		$criteria->compare('cost_value',$this->cost_value,true);
		$criteria->compare('status_field',$this->status_field,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceVoucherType the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function getTypes( $boolean ){
		$condition = ( $boolean ) ? 'isActive="Y"' : 'isActive="Y" AND have_mappings="N"';
		return CHtml::listData(self::model()->findAll( array( 'condition' => $condition, 'order' => 'description' ) ), 'id', 'description');
	}

	public static function editable( $id ){
		$returnValue = true;
		if( $id > 0 ){
			$exist = FinanceVoucherHead::model()->find( array( 'condition' => 'voucher_type='.$id ) );
			if( $exist->id > 0 )
				$returnValue = false;
		}
		return $returnValue;
	}

	public static function importable(){
		$condition = 'have_mappings="Y"';
		return CHtml::listData(self::model()->findAll( array( 'condition' => $condition, 'order' => 'description' ) ), 'id', 'description');
	}

	public static function isSecure( $voucher_no ){
		$returnvalue = false;
		if( (int) $voucher_no > 0 ){
			$voucherModel = self::model()->findbypk( $voucher_no );
			if( $voucherModel->header_table != '' && $voucherModel->date_field != '' && $voucherModel->currency_field != '' && 
				$voucherModel->exchange_rate_field != '' && $voucherModel->grand_total_value != '' && $voucherModel->sales_value != '' && 
				$voucherModel->sales_wo_tax != '' && $voucherModel->vat_value != '' && $voucherModel->cost_value != '' && $voucherModel->status_field != '' &&
				$voucherModel->voucher_reference != '' && $voucherModel->label_field != '' ){
					$returnvalue = true;
			} ;
		}
		return $returnvalue;
	}

	public static function getVoucherno( $voucher, $savetype){
		$voucherModel = self::model()->findBypk( $voucher );
		$nextVoucher = ( $voucherModel->last_voucher_no > 0  ) ? $voucherModel->last_voucher_no+1 : $voucherModel->starting_series;
		if( $savetype ){
			$voucherModel->last_voucher_no = $nextVoucher;
			$voucherModel->save(false);
		}
		return $nextVoucher;
	}
	
	public function getVoucherId($code){
		$voucherModel = self::model()->find(array('condition'=>'code="'.$code.'"'));
		return $voucherModel->id;
	}

	public static function accountingPeriod($format){
		return ( $format == 'Y-m-d') ? array( 'from' => date('Y-01-01'), 'to' => date('Y-12-31') ) : array( 'from' => date('01/01/Y'), 'to' => date('01/12/Y') );
	}
	
	public static function generateAccountingperiod($date){ //Y-m-d format
		return array( 'from' => date('Y-01-01', strtotime($date)), 'to' => date('Y-12-31', strtotime($date))  ) ;
	}

	public static function loadtemplate($voucher_type, $payment_method){
		//$voucher_type 1 = Payment 2 - Receipt
		//$payment_method 1 = cash, 2 -cheque, 3-bank, 4-card
		$responseArray =array();
		if( $voucher_type == 1 ){
			$responseArray[0] = new FinanceVoucherItems;
			$responseArray[0]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('creditors'); //creditors
			$responseArray[0]->haveSubledger = FinanceLegder::is_subledger_account( $responseArray[0]->ledger_id );
			if( $payment_method == 1 ){
				$responseArray[1] = new FinanceVoucherItems;
				$responseArray[1]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('cash_account'); //cash_account
				$responseArray[1]->haveSubledger =  FinanceLegder::is_subledger_account( $responseArray[1]->ledger_id );
			}else if( $payment_method == 2 ){
				$responseArray[1] = new FinanceVoucherItems;
				$responseArray[1]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('pdc_i'); //pdc_i
				$responseArray[1]->haveSubledger =  FinanceLegder::is_subledger_account( $responseArray[1]->ledger_id );
			}
		}else if( $voucher_type == 13 ){
			if( $payment_method == 1 ){
				$responseArray[0] = new FinanceVoucherItems;
				$responseArray[0]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('cash_account'); //cash_account
				$responseArray[0]->haveSubledger =  FinanceLegder::is_subledger_account( $responseArray[0]->ledger_id );
			}else if( $payment_method == 2 ){
				$responseArray[0] = new FinanceVoucherItems;
				$responseArray[0]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('pdc_r'); //pdc_i
				$responseArray[0]->haveSubledger =  FinanceLegder::is_subledger_account( $responseArray[0]->ledger_id );
			}
			$responseArray[1] = new FinanceVoucherItems;
			$responseArray[1]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('debtors'); //debtors
			$responseArray[1]->haveSubledger =  FinanceLegder::is_subledger_account( $responseArray[1]->ledger_id );
		}else if( $voucher_type == 2 ){
			
			$responseArray[0] = new FinanceVoucherItems;
			$responseArray[0]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('pdc_r'); //pdc_i
			$responseArray[0]->haveSubledger =  FinanceLegder::is_subledger_account( $responseArray[0]->ledger_id );
		
		$responseArray[1] = new FinanceVoucherItems;
		$responseArray[1]->ledger_id = FinanceSystemAccountsMapping::getSystemdefault('debtors'); //debtors
		$responseArray[1]->haveSubledger =  FinanceLegder::is_subledger_account( $responseArray[1]->ledger_id );
		}else{
			$responseArray = array(new FinanceVoucherItems);
		}
		
		return $responseArray;
	}

	public static function get_voucher_id( $type ){
		return self::model()->find( array(  'condition' => 'code="'.$type.'"' ) )->id;
	}
}
