<?php

/**
 * This is the model class for table "{{finance_voucher_items}}".
 *
 * The followings are the available columns in table '{{finance_voucher_items}}':
 * @property integer $id
 * @property integer $header_id
 * @property integer $ledger_id
 * @property integer $subledger_id
 * @property string $narration
 * @property string $amount
 */
class FinanceVoucherItems extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	
	public $debit;
	public $credit;
	public $ledger_name;
	public $subledger_name;
	public $haveSubledger;
	public $is_readonly;
	
	public function tableName()
	{
		return '{{finance_voucher_items}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('header_id, ledger_id, currency_id, exchange_rate, amount', 'required'),
			array('subledger_id', 'required', 'on' => 'havesubledger'),
			array('ledger_id', 'subledgerCheck'),
			array('header_id, ledger_id, subledger_id,employee_id', 'numerical', 'integerOnly'=>true),
			array('amount, currency_code', 'length', 'max'=>20),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, header_id, ledger_id, subledger_id, narration, amount', 'safe', 'on'=>'search'),
		);
	}

	public function subledgerCheck($attribute,$params)
    {
        if( $this->ledger_id > 0 && FinanceLegder::is_subledger_account($this->ledger_id) && (int) $this->subledger_id == 0 )
        {
			$this->addError('subledger_id','Subledger Cannot be blank');
		}   
    } 

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
			'ledger' => array(self::BELONGS_TO, 'FinanceLegder', 'ledger_id'),
			'subledger' => array(self::BELONGS_TO, 'FinanceSubledger', 'subledger_id'),
			'parent' => array(self::BELONGS_TO, 'FinanceVoucherHead', 'header_id'),
                                                               'brand' => array(self::BELONGS_TO, 'ProductClass', 'brand_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'header_id' => 'Header',
			'ledger_id' => 'Ledger',
			'subledger_id' => 'Subledger',
			'narration' => 'Narration',
			'amount' => 'Amount',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('header_id',$this->header_id);
		$criteria->compare('ledger_id',$this->ledger_id);
		$criteria->compare('subledger_id',$this->subledger_id);
		$criteria->compare('narration',$this->narration,true);
		$criteria->compare('amount',$this->amount,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return FinanceVoucherItems the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	public static function no_of_entries($id=0){
		$count = self::model()->count(array('condition' => 'ledger_id='.$id));
		return (int) $count;
	}

	public static function no_of_subledger_entries($id=0){
		$count = self::model()->count(array('condition' => 'subledger_id='.$id));
		return (int) $count;
	}

	public static function no_of_childs( $id ){
		$query = 'SELECT COUNT(lv) AS child FROM (
			SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM erp_finance_legder 
			WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM erp_finance_legder 
			JOIN
			(SELECT @pv:='.$id.') tmp
			) a';
		return (float) Yii::app()->db->createCommand($query)->queryScalar();
	
	}

	public static function get_any_subledger(){
		$subledger_name = 'N/A';
		if( $this->parent->vtype->code == 'SI' || $this->parent->vtype->code == 'CN' ){
			$condition = $this->parent->vtype->code == 'SI' ? 'amount > 0 AND ' : 'amount < 0 AND ';
			$model = self::model()->find( array( 'condition' => $condition.'subledger_id > 0 AND header_id='.$this->header_id ) );
			if( $model->id > 0 )
				$subledger_name = $model->subledger->description;
		}
		return $subledger_name;
	}

	public static function haveSublegder(){
		return FinanceLegder::is_subledger_account($this->ledger_id);
	}

	public static function get_sales_value(){
		$sales = 0;
		if( $this->parent->vtype->code == 'SI' || $this->parent->vtype->code == 'CN'  ){
			$sales = (float) self::model()->find( array( 'condition' => 'ledger_id='.FinanceSystemAccountsMapping::getSystemdefault('sales').' AND header_id='.$this->header_id ) )->amount;
			$sales *= (float) $this->exchange_rate;
		}else{
			$sales = (float) $this->exchange_rate * (float) $this->amount;
		}
		return round($sales, 4);
	}

	public static function get_purchase_value(){
		$purchase = 0;
		if( $this->parent->vtype->code == 'PI' || $this->parent->vtype->code == 'DN'  ){
			$purchase = (float) self::model()->find( array( 'condition' => 'ledger_id='.FinanceSystemAccountsMapping::getSystemdefault('inventory').' AND header_id='.$this->header_id ) )->amount;
			$purchase *= (float) $this->parent->exchange_rate;
		}else{
			$purchase = (float) $this->parent->exchange_rate * (float) $this->amount;
		}
		return round($purchase, 4);
	}

	public static function update_currency_code(){
		if( $this->currency_id > 0 ){
			$this->currency_code = MasCurrency::model()->findBypk( $this->currency_id )->currency_code;
			$this->update();
		}
	}
}
