<?php

class ReportsController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'GL_report', 'GL_html', 'GL_excel', 'GL_pdf',
                    'Gl_summary_report', 'Gl_summary_html', 'Gl_summary_excel', 'Gl_summary_pdf',
                    'Tb_report', 'Tb_html', 'Tb_excel', 'Tb_pdf_level', 'Tb_pdf',
                    'Bs_report', 'Bs_html', 'Bs_excel', 'Bs_pdf_level', 'Bs_pdf',
                    'Pl_report', 'Pl_html', 'Pl_excel', 'Pl_pdf_level', 'Pl_pdf',
                    'Aging_report', 'Aging_html', 'Aging_vouchers_html', 'Aging_pdf', 'Aging_excel',
                    'Vat_report', 'Vat_html', 'Vat_pdf', 'Vat_pdf_extras', 'Vat_excel',
                    'Statement_report', 'Statement_html', 'Statement_pdf', 'Statement_pdf_filter', 'Statement_excel',
                    'Reconciliation_report', 'Rec_gl_html', 'Rec_gL_excel', 'Rec_gL_pdf',
                    'Cus_pl_report', 'Cus_pl_html', 'cus_pl_excel', 'Pl_cus_detailed', 'Emp_pl_report', 'Emp_pl_html', 'Pl_emp_detailed',
                    'Sales_cg_report', 'Sales_cg_html', 'Subledger_report', 'Subledger_report_html', 'Cus_pl_pdf', 'Emp_pl_pdf','Emp_pl_excel', 'Sales_cg_pdf','Sales_cg_excel',
                    'Cashflow_report','Cashflow_report_html','Cashflow_finance_report','Cashflow_finance_report_html','Cashflow_finance_report_excel','Sales_finance_report',
                    'Sales_finance_report_html','Sales_finance_report_excel','Purchase_finance_report','Purchase_finance_report_html','Purchase_finance_report_excel', 'Subledgerwise_report', 
                    'Subledgerwise_report_html','Subledgerwise_report_pdf','Subledgerwise_report_excel', 'Brandwise_report', 'Brandwise_report_html','Brandwise_report_pdf','Brandwise_report_excel',
                    'Employeewise_report', 'Employeewise_report_html','Employeewise_report_pdf','Employeewise_report_excel','Statement_report_new', 'Statement_html_new', 'Statement_pdf_new', 
                    'Statement_pdf_filter_new', 'Statement_excel_new','Employeewise_summary_report', 'Employeewise_summary_report_html','Employeewise_summary_report_pdf',
                    'Employeewise_summary_report_excel','Tb_new_html','Pl_new_html','Bs_new_html', 'Subledger_detail_report', 'Subledger_detail_report_html','statement_sales_pdf', 'Vehicle_report',
                    'Vehicle_report_html','Customer_aging_report','Customer_aging_html','Parentaccountlist','Customer_aging_pdf','Customer_aging_excel','GL_report_cash', 'GL_cash_html', 'GL_cash_excel',
                    'GL_cash_pdf','Bs_report_new','Bs_html_new','Pdf_bs_report_new','Pl_report_new','Pl_html_new','Pdf_pl_report_new','Pl_excel_new','Bs_excel_new','Cashflow_finance_report_pdf',
                    'Vehicle_report_pdf','Subledger_detail_report_pdf','Subledger_report_pdf','Vehicle_report_excel','Subledger_detail_report_excel','Subledger_report_excel','Gl_cost_summary_html',
                    'Gl_cost_html','GL_cost_excel','Gl_summary_new_html','GL_cash_pl_excel','Gl_cash_pl_html','Tb_report_new','Tb_html_new','Expense_report','Expense_html','Pdf_tb_report_new','Tb_excel_new'
                ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function addVoucherhead($arr_items)
    {
        $model = new FinanceVoucherHead;
        $model->voucher_type = $arr_items['voucher_type'];
        $model->voucher_no = $arr_items['voucher_no'];
        $model->voucher_date = $arr_items['voucher_date'];
        $model->due_date = $model->voucher_date;
        $model->header_table_id = $arr_items['header_table_id'];
        $model->reference_no = $arr_items['reference_no'];
        $model->is_posted = (isset($arr_items['is_posted'])) ? $arr_items['is_posted'] : 'Y';
        $model->created_by = Yii::app()->user->id;
        $model->created_datetime = date('Y-m-d h:i:s');
        return ($model->save(false)) ? $model->id : 0; //exception
    }

    public function addVoucheritems($headerId, $arr_items)
    {
        $model = new FinanceVoucherItems;
        $model->header_id = $headerId;
        $model->ledger_id = $arr_items['ledger_id'];
        $model->subledger_id = $arr_items['subledger_id'];
        $model->narration = $arr_items['narration'];
        $model->currency_id = $arr_items['currency'];
        $model->exchange_rate = $arr_items['exchange_rate'];
        $model->amount = $arr_items['amount'];
        $model->save(false);
        $model->update_currency_code();
    }

    public function actionGl_report()
    {
        $this->render('gl_report');
    }

    public function actionGl_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $employee = (int) $_POST['employee'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 't.amount != 0 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:20%" >Subledger</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="4" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
                      <td></td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            if($each->amount!=0)
            {
            $table .= ' <tr  data-id="' . $parent . '" data-parent="">
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td>' . $subledgerName . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';

            $eachItem = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.header_id="' . (int) $each->header_id . '" AND t.id != "' . (int) $each->id . '"', 'order' => 'parent.voucher_date ASC'));
            $child = $parent + 1;
            foreach ($eachItem as $eachLine) {

                $debit = ($eachLine->amount > 0) ? round(($eachLine->amount * $eachLine->exchange_rate), 2) : '';
                $credit = ($eachLine->amount < 0) ? round(abs($eachLine->amount * $eachLine->exchange_rate), 2) : '';

                $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
                $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

                $subledgerName = ($eachLine->subledger_id > 0) ? $eachLine->subledger->description : '';

                $table .= ' <tr data-id="' . $child . '" data-parent="' . $parent . '">
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df">' . $eachLine->ledger->description . '</td>
                                    <td style="background-color:#d8f5df">' . $subledgerName . '</td>
                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df"><small>' . $eachLine->narration . '</small></td>
                            </tr>';
                $child++;
            }
            $parent = $child;
        }
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }

    public function actionGL_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = (int) $_GET['currency'];
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        if((int)$currency==0)
        {
        $currency=1;    
        }
        
        $cur=MasCurrency::model()->findByPk($currency);
       
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger . ')';
            $ledger_details=FinanceLegder::model()->findByPk($ledger);
            $title=$ledger_details->description;
        }
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
            $subledger_details=FinanceSubledger::model()->findByPk($subledger);
            $title=$subledger_details->description;
        }
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;
         //echo "gggg";
        //exit;
        
        

        // Create new PHPExcel object
        $excel = new PHPExcel();
        
       
        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("General Transaction Ledger Report")
            ->setSubject("General Transaction Ledger Report")
            ->setDescription("General Transaction Ledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("General Transaction Ledger Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('C11', 'Opening Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 12;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            $particular=$each->ledger->description;
            if($each->subledger_id>0)
            {
            $particular.='-'.$each->subledger->description;
            }
            $particular=$title;
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="general_ledger.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionGL_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        $brand = (int) Yii::app()->request->getParam('brand');
        $employee = (int) Yii::app()->request->getParam('employee');
        $currency = (int) Yii::app()->request->getParam('currency');
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'currency_code' => $currency_code,
            'exchange_rate' => $exchange_rate,
            'currency' => $currency,
            'brand' => $brand,
            'employee' => $employee
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_gl_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("GLReport" . date("d-m-Y"), 'I');
    }

    public function actionGl_summary_report()
    {
        $this->render('gl_summary_report');
    }

    public function actionGl_summary_html()
    {
        $ledger = (int) $_POST['ledger_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $brand = (int) $_POST['brand'];
        $condition = 'VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '"';
        if ($brand > 0) {
            $condition .= ' AND VI.brand_id=' . $brand;
        }

        $glSummaryquery = 'CREATE OR REPLACE VIEW {{finance_gl_summary}} AS SELECT
                                SL.id AS subledger_id,
								SL.account_no AS subledger_no,
								IFNULL(SL.description, "No Subledger") AS subledger_name,
                                ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                L.id AS ledger_id,VI.subledger_id AS voucher_sub_id
							FROM {{finance_voucher_items}} VI
							LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
							LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
							LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
							WHERE ' . $condition . '
							GROUP BY  VI.ledger_id, VI.subledger_id';
        Yii::app()->db->createCommand($glSummaryquery)->execute();

        $summaryItems = Yii::app()->db->createCommand('SELECT * FROM {{finance_gl_summary}} WHERE balance != 0 ORDER BY subledger_name')->queryAll();

        $table = '<table class="table table-hover table-fixed table-bordered" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th style="width:10%" >#</th>
                            <th style="width:30%" >Particular</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Debit</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Credit</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Balance</th>
                        </tr>
                    </thead>
                    <tbody>';

        $totalDebit = $totalCredit = 0;
        $fvouchertype=new FinanceVoucherType();
        $accountingPeriod = $fvouchertype->generateAccountingperiod($to_date);

        foreach ($summaryItems as $each) {
            // $debit = ($each['balance'] > 0) ? $each['balance'] : '';
            // $credit = ($each['balance'] < 0) ? abs($each['balance']) : '';

            $debit = $each['debit'];
            $credit = $each['credit'];

            $totalDebit += $debit;
            $totalCredit += $credit;
            $count=Yii::app()->db->createCommand("SELECT count(*) FROM `erp_finance_voucher_items` as ledger INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE ledger.ledger_id='".$each['ledger_id']."' AND ledger.subledger_id='".$each['subledger_id']."' AND head.is_posted ='Y' AND head.voucher_date>='".$from_date."' AND head.voucher_date<='".$to_date."'")->queryScalar();
            if($count<50)
            {
            $subledgerName = '<a href="#" onclick="js:load_gl_report(' . $each['ledger_id'] . ', ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';
            }
            else {
            $subledgerName = '<a href="#" onclick="js:load_gl_report_excel(' . $each['ledger_id'] . ', ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';  
            }
            $balance=$debit-$credit;
            if($balance>0)
            {
            $Symbol='DR';
            }
            else {
            $Symbol='CR';    
            }
            $table .= '  <tr>
                            <td>' . $each['subledger_no'] . '</td>
                            <td>' . $subledgerName . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") .' '.$Symbol. ' </td>
                        </tr>';
        }
        $tot_balance=$totalDebit-$totalCredit;
            if($tot_balance>0)
            {
            $Symbol='DR';
            }
            else {
            $Symbol='CR';    
            }
        $table .= ' <tr>
                        <td colspan="2" style="text-align:right !important;"><b>Total</b></td>
                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($totalDebit, " ") . '</b></td>
                        <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($totalCredit, " ") . '</b></td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($tot_balance), " ") .' '.$Symbol. ' </td>
                    </tr>';

        $balance = $totalDebit - $totalCredit;
        $debitBalance = ($balance > 0) ? $balance : 0;
        $creditBalance = ($balance <= 0) ? abs($balance) : 0;

        $table .= '<tr>
                        <td colspan="2"style="text-align:right !important;"><b>Balance</b></td>
                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($debitBalance, " ") . '</b></td>
                        <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($creditBalance, " ") . '</b></td>
                        <td style="text-align:right !important;"></td>
                    </tr>';
        $table .= '</tbody>
            </table>';
        echo $table;
    }

    public function actionGl_summary_pdf()
    {

        $ledger = (int) $_GET['ledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $brand = (int) $_GET['brand'];

        $glSummaryquery = 'CREATE OR REPLACE VIEW {{finance_gl_summary}} AS SELECT
                                SL.id AS subledger_id,
								SL.account_no AS subledger_no,
								IFNULL(SL.description, "No Subledger") AS subledger_name,
                                ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                L.id AS ledger_id
							FROM {{finance_voucher_items}} VI
							LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
							LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
							LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
							WHERE VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date >= "' . $from_date . '"  AND V.voucher_date <= "' . $to_date . '"
							GROUP BY  VI.ledger_id, VI.subledger_id';

        Yii::app()->db->createCommand($glSummaryquery)->execute();

        $param = array(
            'to_date' => $to_date,
            'ledger' => $ledger,
        );

        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('pdf_gl_summary_report', $param, true));

        $mpdf->Output("gl_summary" . date("d-m-Y"), 'I');
    }

    public function actionGl_summary_excel()
    {
        $ledger = (int) $_GET['ledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $brand = (int) $_GET['brand'];

        $ledgerModel = FinanceLegder::model()->findBypk($ledger);

        $glSummaryquery = 'CREATE OR REPLACE VIEW {{finance_gl_summary}} AS SELECT
                                SL.id AS subledger_id,
								SL.account_no AS subledger_no,
								IFNULL(SL.description, "No Subledger") AS subledger_name,
                                ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                L.id AS ledger_id
							FROM {{finance_voucher_items}} VI
							LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
							LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
							LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
							WHERE VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date >= "' . $from_date . '"  AND V.voucher_date <= "' . $to_date . '"
							GROUP BY  VI.ledger_id, VI.subledger_id';

        Yii::app()->db->createCommand($glSummaryquery)->execute();

        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Ledger Summary Report")
            ->setSubject("Ledger Summary Report")
            ->setDescription("Ledger Summary Report Generated on " . date('d/m/Y'))
            ->setKeywords("Ledger Summary Report")
            ->setCategory("Financial Report");

        // Add some data
         $fledger=new FinanceLegder();
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', '#')
            ->setCellValue('B1', 'Particular')
            ->setCellValue('C1', 'Debit (' . $fledger->baseCurrency() . ')')
            ->setCellValue('D1', 'Credit (' . $fledger->baseCurrency() . ')');

        $border = array(
            'borders' => array(
                'bottom' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THICK,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:D1')->applyFromArray($border);

        $excel->getActiveSheet()->getStyle('A1:D1')->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));

        $excel->getActiveSheet()->getStyle('A1:D1')->getFont()->setBold(true)->setSize(12);

        $summaryItems = Yii::app()->db->createCommand('SELECT * FROM {{finance_gl_summary}} WHERE balance != 0 ORDER BY subledger_name')->queryAll();
        $totalDebit = $totalCredit = 0;

        $rowId = 2;
        foreach ($summaryItems as $each) {

            // $debit = ($each['balance'] > 0) ? $each['balance'] : '';
            // $credit = ($each['balance'] < 0) ? abs($each['balance']) : '';

            $debit = $each['debit'];
            $credit = $each['credit'];

            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $each['subledger_no'])
                ->setCellValue('B' . $rowId, $each['subledger_name'])
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency($credit, " "));

            $totalDebit += $debit;
            $totalCredit += $credit;
            $rowId++;
        }

        $excel->getActiveSheet(0)->getStyle('A' . ($rowId - 1) . ':D' . ($rowId - 1))->applyFromArray($border);
        $excel->getActiveSheet(0)->getStyle('A' . $rowId . ':D' . $rowId)->applyFromArray($border);

        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Total')
            ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($totalDebit, " "))
            ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency($totalCredit, " "));
        $excel->getActiveSheet()->getStyle('A' . $rowId . ':D' . $rowId)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':B' . $rowId);

        $balance = $totalDebit - $totalCredit;
        $debitBalance = ($balance > 0) ? $balance : 0;
        $creditBalance = ($balance <= 0) ? abs($balance) : 0;

        $rowId++;
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Balance')
            ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($debitBalance, " "))
            ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency($creditBalance, " "));
        $excel->getActiveSheet()->getStyle('A' . $rowId . ':D' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':B' . $rowId);

        $excel->getActiveSheet()->getStyle('A' . $rowId . ':D' . $rowId)->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));

        // Rename worksheet
        if(strlen($ledgerModel->description)>30)
        {
        $description=substr($ledgerModel->description,0,30);    
        }
        else {
        $description=$ledgerModel->description;    
        }
        $excel->getActiveSheet()->setTitle($description);

        $excel->getActiveSheet()
            ->getStyle('C2:D' . $rowId)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . $description . '.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;

    }

    public function actionTB_report()
    {
        $this->render('tb_report');
    }

//    public function actionTb_html()
//    {
//        $brand = (int) $_POST['brand'];
//        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
//        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
//
//        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
//        $accountingPeriod = $from_date;
//        $query = 'CREATE OR REPLACE VIEW {{finance_trialbalance}} AS SELECT
//                            L.id AS ledger_id,
//                            L.account_no AS ledger_no,
//                            L.description AS ledger_name,
//                            L.level AS level,
//                            L.parent_account AS parent,
//                            IFNULL(S.description, "N/A") AS subledger,
//                            IFNULL(S.id, 0) AS subledger_id,
//                            ROUND((SUM(CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS debit,
//                            ROUND((SUM(CASE WHEN VI.amount < 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS credit,
//                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
//                        FROM {{finance_legder}} L
//                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
//                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
//                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
//                        WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("B", "P")
//                        GROUP BY L.id, S.id';
//        Yii::app()->db->createCommand($query)->execute();
//
//        $table = '<table class="table table-hover table-fixed table-bordered" id="tb_table">
//                    <thead>
//                        <tr>
//                            <th style="width:10%" >#</th>
//                            <th style="width:30%" >Particular</th>
//                            <th style="width:15%;text-align:right !important;" >Opening Balance</th>
//                            <th style="width:15%;text-align:right !important;" class="text-right">Debit (' . FinanceLegder::baseCurrency() . ')</th>
//                            <th style="width:15%;text-align:right !important;" class="text-right">Credit (' . FinanceLegder::baseCurrency() . ')</th>
//                            <th style="width:15%;text-align:right !important;" class="text-right">Balance (' . FinanceLegder::baseCurrency() . ')</th>
//                        </tr>
//                    </thead>
//                    <tbody>';
//
//        function get_symbol($value)
//        {
//            return ($value) > 0 ? ' Dr' : ' Cr';
//        }
//
//        function getClick($model, $accountingPeriod, $to_date)
//        {
//            return ($model->haveSubledger == 'Y') ? 'js:load_summary(' . $model->id . ', \'' . date('d/m/Y', strtotime($accountingPeriod['from'])) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');' : 'js:load_gl_report(' . $model->id . ', 0, \'' . date('d/m/Y', strtotime($accountingPeriod['from'])) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
//        }
//
//        //We have 5 levels
//        $total_debit = $total_credit = 0;
//        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
//        foreach ($levelOne as $eachOne) {
//
//            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                JOIN
//                (SELECT @pv:=' . $eachOne->id . ') tmp
//                ) a';
//            $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//            $debit = $credit = $balance = $opening = 0;
//            $accountName = $eachOne->description;
//
//            if ($ids[0]['child'] != '') {
//                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE  H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                $balance += $opening;
//            }
//
//            $table .= '<tr data-id="' . $eachOne->id . '" data-parent="" >
//                            <td><b>' . $eachOne->account_no . '</b></td>
//                            <td><b>' . $accountName . '</b></td>
//                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . '</b></td>
//                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . '</b></td>
//                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . '</b></td>
//                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . '</b></td>
//                        </tr>';
//
//            $total_debit += $debit;
//            $total_credit += $credit;
//            //LEVEL 2
//            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachOne->id));
//            foreach ($levelTwo as $eachTwo) {
//
//                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                    JOIN
//                    (SELECT @pv:=' . $eachTwo->id . ') tmp
//                    ) a';
//                $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                $debit = $credit = $balance = $opening = 0;
//                $bo = $bc = '';
//                $accountName = $eachTwo->description;
//
//                if ($ids[0]['child'] != '') {
//                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                    $balance += $opening;
//                    $bo = '<b>';
//                    $bc = '</b>';
//                } else {
//                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachTwo->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
//                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
//                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
//
//                    $balance += $opening;
//
//                    $accountName = '<a href="#" onclick="' . getClick($eachTwo, $accountingPeriod, $to_date) . '">' . $eachTwo->description . '</a>';
//                }
//                $table .= '<tr data-id="' . $eachTwo->id . '" data-parent="' . $eachOne->id . '" >
//                                <td>' . $bo . $eachTwo->account_no . $bc . '</td>
//                                <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . '</td>
//                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                            </tr>';
//                //LEVEL 3
//                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachTwo->id));
//                foreach ($levelThree as $eachThree) {
//
//                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                        JOIN
//                        (SELECT @pv:=' . $eachThree->id . ') tmp
//                        ) a';
//                    $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                    $debit = $credit = $balance = $opening = 0;
//                    $bo = $bc = '';
//                    $accountName = $eachThree->description;
//
//                    if ($ids[0]['child'] != '') {
//                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                        $balance += $opening;
//                        $bo = '<b>';
//                        $bc = '</b>';
//                    } else {
//                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachThree->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
//                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
//                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
//
//                        $balance += $opening;
//
//                        $accountName = '<a href="#" onclick="' . getClick($eachThree, $accountingPeriod, $to_date) . '">' . $eachThree->description . '</a>';
//                    }
//                    $table .= '<tr data-id="' . $eachThree->id . '" data-parent="' . $eachTwo->id . '" >
//                                    <td>' . $bo . $eachThree->account_no . $bc . '</td>
//                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                                </tr>';
//                    //LEVEL 4
//                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachThree->id));
//                    foreach ($levelFour as $eachFour) {
//
//                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                                JOIN
//                                (SELECT @pv:=' . $eachFour->id . ') tmp
//                                ) a';
//                        $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                        $debit = $credit = $balance = $opening = 0;
//                        $bo = $bc = '';
//                        $accountName = $eachFour->description;
//
//                        if ($ids[0]['child'] != '') {
//                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                            $balance += $opening;
//                            $bo = '<b>';
//                            $bc = '</b>';
//                        } else {
//                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFour->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
//                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
//                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
//
//                            $balance += $opening;
//
//                            $accountName = '<a href="#" onclick="' . getClick($eachFour, $accountingPeriod, $to_date) . '">' . $eachFour->description . '</a>';
//                        }
//                        $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
//                                            <td>' . $bo . $eachFour->account_no . $bc . '</td>
//                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
//                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                                        </tr>';
//
//                        //LEVEL 4
//                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachFour->id));
//                        foreach ($levelFive as $eachFive) {
//
//                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                                    JOIN
//                                    (SELECT @pv:=' . $eachFive->id . ') tmp
//                                    ) a';
//                            $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                            $debit = $credit = $balance = $opening = 0;
//                            $bo = $bc = '';
//                            $accountName = $eachFive->description;
//
//                            if ($ids[0]['child'] != '') {
//                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                                $balance += $opening;
//                                $bo = '<b>';
//                                $bc = '</b>';
//                            } else {
//                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFive->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
//                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
//                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
//
//                                $balance += $opening;
//
//                                $accountName = '<a href="#" onclick="' . getClick($eachFive, $accountingPeriod, $to_date) . '">' . $eachFive->description . '</a>';
//                            }
//                            $table .= '<tr data-id="' . $eachFive->id . '" data-parent="' . $eachFour->id . '" >
//                                                <td>' . $bo . $eachFive->account_no . $bc . '</td>
//                                                <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                                            </tr>';
//                        }
//                    }
//                }
//            }
//        }
//        $table .= '<tr data-id="1000" data-parent="" >
//                        <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
//                        <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
//                        <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
//                        <td></td>
//                </tr>';
//        $table .= '</tbody>
//                </table>';
//        echo $table;
//
//    }
        public function actionTb_html()
    {
        $brand = (int) $_POST['brand'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
        $accountingPeriod = $from_date;
        $query = 'CREATE OR REPLACE VIEW {{finance_trialbalance}} AS SELECT
                            L.id AS ledger_id,
                            L.account_no AS ledger_no,
                            L.description AS ledger_name,
                            L.level AS level,
                            L.parent_account AS parent,
                            IFNULL(S.description, "N/A") AS subledger,
                            IFNULL(S.id, 0) AS subledger_id,
                            ROUND((SUM(CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS debit,
                            ROUND((SUM(CASE WHEN VI.amount < 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS credit,
                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                        FROM {{finance_legder}} L
                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("B", "P")
                        GROUP BY L.id, S.id';
        Yii::app()->db->createCommand($query)->execute();

        $table = '<table class="table table-hover table-fixed table-bordered" id="tb_table">
                    <thead>
                        <tr>
                            <th style="width:10%" >#</th>
                            <th style="width:30%" >Particular</th>
                            <th style="width:15%;text-align:right !important;" >Opening Balance</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Debit (' . FinanceLegder::baseCurrency() . ')</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Credit (' . FinanceLegder::baseCurrency() . ')</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Balance (' . FinanceLegder::baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>';

        function get_symbol($value)
        {
            return ($value) > 0 ? ' Dr' : ' Cr';
        }

        function getClick($model, $accountingPeriod, $to_date)
        {
            return ($model->haveSubledger == 'Y') ? 'js:load_summary(' . $model->id . ', \'' . date('d/m/Y', strtotime($accountingPeriod['from'])) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');' : 'js:load_gl_report(' . $model->id . ', 0, \'' . date('d/m/Y', strtotime($accountingPeriod['from'])) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
        }

        //We have 5 levels
        $total_debit = $total_credit = 0;
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
        foreach ($levelOne as $eachOne) {

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                JOIN
                (SELECT @pv:=' . $eachOne->id . ') tmp
                ) a';
            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $debit = $credit = $balance = $opening = 0;
            $accountName = $eachOne->description;

            if ($ids[0]['child'] != '') {
                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE  H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                $balance += $opening;
            }

            $table .= '<tr data-id="' . $eachOne->id . '" data-parent="" >
                            <td><b>' . $eachOne->account_no . '</b></td>
                            <td><b>' . $accountName . '</b></td>
                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . '</b></td>
                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . '</b></td>
                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . '</b></td>
                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . '</b></td>
                        </tr>';

            $total_debit += $debit;
            $total_credit += $credit;
            //LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                    JOIN
                    (SELECT @pv:=' . $eachTwo->id . ') tmp
                    ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $debit = $credit = $balance = $opening = 0;
                $bo = $bc = '';
                $accountName = $eachTwo->description;

                if ($ids[0]['child'] != '') {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                    $balance += $opening;
                    $bo = '<b>';
                    $bc = '</b>';
                } else {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachTwo->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();

                    $balance += $opening;

                    $accountName = '<a href="#" onclick="' . getClick($eachTwo, $accountingPeriod, $to_date) . '">' . $eachTwo->description . '</a>';
                }
                $table .= '<tr data-id="' . $eachTwo->id . '" data-parent="' . $eachOne->id . '" >
                                <td>' . $bo . $eachTwo->account_no . $bc . '</td>
                                <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . '</td>
                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                            </tr>';
                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachThree->id . ') tmp
                        ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $debit = $credit = $balance = $opening = 0;
                    $bo = $bc = '';
                    $accountName = $eachThree->description;

                    if ($ids[0]['child'] != '') {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                        $balance += $opening;
                        $bo = '<b>';
                        $bc = '</b>';
                    } else {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachThree->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();

                        $balance += $opening;

                        $accountName = '<a href="#" onclick="' . getClick($eachThree, $accountingPeriod, $to_date) . '">' . $eachThree->description . '</a>';
                    }
                    $table .= '<tr data-id="' . $eachThree->id . '" data-parent="' . $eachTwo->id . '" >
                                    <td>' . $bo . $eachThree->account_no . $bc . '</td>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                </tr>';
                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachFour->id . ') tmp
                                ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $debit = $credit = $balance = $opening = 0;
                        $bo = $bc = '';
                        $accountName = $eachFour->description;

                        if ($ids[0]['child'] != '') {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                            $balance += $opening;
                            $bo = '<b>';
                            $bc = '</b>';
                        } else {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFour->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();

                            $balance += $opening;

                            $accountName = '<a href="#" onclick="' . getClick($eachFour, $accountingPeriod, $to_date) . '">' . $eachFour->description . '</a>';
                        }
                        $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
                                            <td>' . $bo . $eachFour->account_no . $bc . '</td>
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                        </tr>';

                        //LEVEL 4
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFive->id . ') tmp
                                    ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $debit = $credit = $balance = $opening = 0;
                            $bo = $bc = '';
                            $accountName = $eachFive->description;

                            if ($ids[0]['child'] != '') {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                                $balance += $opening;
                                $bo = '<b>';
                                $bc = '</b>';
                            } else {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFive->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();

                                $balance += $opening;

                                $accountName = '<a href="#" onclick="' . getClick($eachFive, $accountingPeriod, $to_date) . '">' . $eachFive->description . '</a>';
                            }
                            $table .= '<tr data-id="' . $eachFive->id . '" data-parent="' . $eachFour->id . '" >
                                                <td>' . $bo . $eachFive->account_no . $bc . '</td>
                                                <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                                <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                            </tr>';
                        }
                    }
                }
            }
        }
        $table .= '<tr data-id="1000" data-parent="" >
                        <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
                        <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                        <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                        <td></td>
                </tr>';
        $table .= '</tbody>
                </table>';
        echo $table;

    }
    
    public function actionTb_excel()
    {
        $brand = (int) $_GET['brand'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');

        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
        $accountingPeriod = $from_date;
        $query = 'CREATE OR REPLACE VIEW {{finance_trialbalance}} AS SELECT
                            L.id AS ledger_id,
                            L.account_no AS ledger_no,
                            L.description AS ledger_name,
                            L.level AS level,
                            L.parent_account AS parent,
                            IFNULL(S.description, "N/A") AS subledger,
                            S.id AS subledger_id,
                            ROUND((SUM(CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS debit,
                            ROUND((SUM(CASE WHEN VI.amount < 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS credit,
                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                        FROM {{finance_legder}} L
                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("B", "P")
                        GROUP BY L.id, S.id';

        Yii::app()->db->createCommand($query)->execute();

        // Create new PHPExcel object
        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Trial Balance")
            ->setSubject("Trial Balance")
            ->setDescription("Trial Balance as From " . $from_date . " to " . $to_date)
            ->setKeywords("Trial Balance")
            ->setCategory("Financial Report");

        // Add some data
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', '#')
            ->setCellValue('B1', 'Particular')
            ->setCellValue('C1', 'Beginning Balance (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('D1', 'Debit (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('E1', 'Credit (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('F1', 'Closing Balance');

        $excel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(12);

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);

        function get_symbol($value)
        {
            return ($value) > 0 ? ' Dr' : ' Cr';
        }

        //We have 5 levels
        $total_debit = $total_credit = 0;
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
        $rowId = 2;
        foreach ($levelOne as $eachOne) {

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachOne->id . ') tmp
                        ) a';
            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $debit = $credit = $balance = $opening = 0;
            $accountName = $eachOne->description;
            $subledgerCount = 0;

            if ($ids[0]['child'] != '') {
                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE  H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                $balance += $opening;

                $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true);
            }

            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $eachOne->account_no)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($debit), " "))
                ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($credit), " "))
                ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance));

            $total_debit += $debit;
            $total_credit += $credit;
            $rowId++;
            //LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                            SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                            WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                            JOIN
                            (SELECT @pv:=' . $eachTwo->id . ') tmp
                            ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $debit = $credit = $balance = $opening = 0;
                $accountName = $eachTwo->description;
                $subledgerCount = 0;

                if ($ids[0]['child'] != '') {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                    $balance += $opening;

                    $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true);
                } else {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachTwo->id . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();

                    $balance += $opening;

                    $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                }

                $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, $eachTwo->account_no)
                    ->setCellValue('B' . $rowId, $accountName)
                    ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                    ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($debit), " "))
                    ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($credit), " "))
                    ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance));

                if (abs($balance) == 0) {
                    $excel->getActiveSheet()->getRowDimension($rowId)->setVisible(false);
                }

                $rowId++;

                if ($subledgerCount > 0) {
                    foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_trialbalance}} WHERE ledger_id=' . $eachTwo->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id=' . $eachTwo->id . ' AND I.subledger_id=' . (int) $eachSub['subledger_id'] . ' AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                        $excel->setActiveSheetIndex(0)
                            ->setCellValue('B' . $rowId, $eachSub['subledger'])
                            ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                            ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "))
                            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['balance']), " ") . get_symbol($eachSub['balance']));

                        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setItalic(true)->setSize(9);
                        $rowId++;
                    }
                }
                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachThree->id . ') tmp
                                ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $debit = $credit = $balance = $opening = 0;
                    $accountName = $eachThree->description;
                    $subledgerCount = 0;

                    if ($ids[0]['child'] != '') {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                        $balance += $opening;

                        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true);
                    } else {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachThree->id . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();

                        $balance += $opening;

                        $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                    }

                    $excel->setActiveSheetIndex(0)
                        ->setCellValue('A' . $rowId, $eachThree->account_no)
                        ->setCellValue('B' . $rowId, $accountName)
                        ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                        ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($debit), " "))
                        ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($credit), " "))
                        ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance));

                    if (abs($balance) == 0) {
                        $excel->getActiveSheet()->getRowDimension($rowId)->setVisible(false);
                    }

                    $rowId++;

                    if ($subledgerCount > 0) {
                        foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_trialbalance}} WHERE ledger_id=' . $eachThree->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id=' . $eachThree->id . ' AND I.subledger_id=' . (int) $eachSub['subledger_id'] . ' AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                            $excel->setActiveSheetIndex(0)
                                ->setCellValue('B' . $rowId, $eachSub['subledger'])
                                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                                ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                                ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "))
                                ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['balance']), " ") . get_symbol($eachSub['balance']));

                            $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setItalic(true)->setSize(9);
                            $rowId++;
                        }
                    }
                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFour->id . ') tmp
                                    ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $debit = $credit = $balance = $opening = 0;
                        $accountName = $eachFour->description;
                        $subledgerCount = 0;

                        if ($ids[0]['child'] != '') {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                            $balance += $opening;

                            $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true);
                        } else {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFour->id . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();

                            $balance += $opening;

                            $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                        }

                        $excel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $rowId, $eachFour->account_no)
                            ->setCellValue('B' . $rowId, $accountName)
                            ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                            ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($debit), " "))
                            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($credit), " "))
                            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance));

                        if (abs($balance) == 0) {
                            $excel->getActiveSheet()->getRowDimension($rowId)->setVisible(false);
                        }

                        $rowId++;

                        if ($subledgerCount > 0) {
                            foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_trialbalance}} WHERE ledger_id=' . $eachFour->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id=' . $eachFour->id . ' AND I.subledger_id=' . (int) $eachSub['subledger_id'] . ' AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                                $excel->setActiveSheetIndex(0)
                                    ->setCellValue('B' . $rowId, $eachSub['subledger'])
                                    ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                                    ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                                    ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "))
                                    ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['balance']), " ") . get_symbol($eachSub['balance']));

                                $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setItalic(true)->setSize(9);
                                $rowId++;
                            }
                        }

                        //LEVEL 5
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                        JOIN
                                        (SELECT @pv:=' . $eachFive->id . ') tmp
                                        ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $debit = $credit = $balance = $opening = 0;
                            $accountName = $eachFive->description;
                            $subledgerCount = 0;

                            if ($ids[0]['child'] != '') {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                                $balance += $opening;

                                $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true);

                            } else {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFive->id . ') AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();

                                $balance += $opening;

                                $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                            }

                            $excel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $rowId, $eachFive->account_no)
                                ->setCellValue('B' . $rowId, $accountName)
                                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                                ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($debit), " "))
                                ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($credit), " "))
                                ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance));

                            if (abs($balance) == 0) {
                                $excel->getActiveSheet()->getRowDimension($rowId)->setVisible(false);
                            }

                            $rowId++;

                            if ($subledgerCount > 0) {
                                foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_trialbalance}} WHERE ledger_id=' . $eachFive->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {
                                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id=' . $eachFive->id . ' AND I.subledger_id=' . (int) $eachSub['subledger_id'] . ' AND H.voucher_date < "' . $from_date . '" ')->queryScalar();
                                    $excel->setActiveSheetIndex(0)
                                        ->setCellValue('B' . $rowId, $eachSub['subledger'])
                                        ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening))
                                        ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                                        ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "))
                                        ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['balance']), " ") . get_symbol($eachSub['balance']));

                                    $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setItalic(true)->setSize(9);
                                    $rowId++;
                                }
                            }
                        }
                    }
                }
            }
        }

        $excel->getActiveSheet()->getStyle('A' . $rowId . ':E' . $rowId)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':C' . $rowId);

        $excel->getActiveSheet()->getStyle('C2:C' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()->getStyle('D2:D' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()->getStyle('E2:E' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()->getStyle('F2:F' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Total')
            ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('Trial Balance');

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="trial_balance.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionTb_pdf_level()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('tb_level_filter', array('from_date' => $_GET['from_date'],'to_date' => $_GET['to_date'], 'brand' => (int) $_GET['brand']));
    }

//    public function actionTb_pdf()
//    {
//        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
//        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
//        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
//        $accountingPeriod = $from;
//        $level = in_array((int) $_GET['level'], array(1, 2, 3, 4, 5)) ? (int) $_GET['level'] : 5;
//
//        $query = 'CREATE OR REPLACE VIEW {{finance_trialbalance}} AS SELECT
//                    L.id AS ledger_id,
//                    L.account_no AS ledger_no,
//                    L.description AS ledger_name,
//                    L.level AS level,
//                    L.parent_account AS parent,
//                    IFNULL(S.description, "N/A") AS subledger,
//                    IFNULL(S.id, 0) AS subledger_id,
//                    ROUND((SUM(CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS debit,
//                    ROUND((SUM(CASE WHEN VI.amount < 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS credit,
//                    ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
//                FROM {{finance_legder}} L
//                LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
//                LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
//                LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
//                WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("B", "P")
//                GROUP BY L.id, S.id';
//
//        Yii::app()->db->createCommand($query)->execute();
//
//        $table = '<table class="table table-hover table-fixed table-bordered" id="tb_table">
//                    <thead>
//                        <tr>
//                            <th style="width:5%" >#</th>
//                            <th style="width:45%" >Particular</th>
//                            <th style="width:17%;" >Opening Balance</th>
//                            <th style="width:17%;" class="text-right">Debit (' . FinanceLegder::baseCurrency() . ')</th>
//                            <th style="width:17%;" class="text-right">Credit (' . FinanceLegder::baseCurrency() . ')</th>
//                            <th style="width:17%;" class="text-right">Balance (' . FinanceLegder::baseCurrency() . ')</th>
//                        </tr>
//                    </thead>
//                    <tbody>';
//
//        function get_symbol($value)
//        {
//            return ($value) > 0 ? ' Dr' : ' Cr';
//        }
//
//        //We have 5 levels
//        $total_debit = $total_credit = 0;
//        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
//        foreach ($levelOne as $eachOne) {
//
//            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                JOIN
//                (SELECT @pv:=' . $eachOne->id . ') tmp
//                ) a';
//            $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//            $debit = $credit = $balance = $opening = 0;
//            $accountName = $eachOne->description;
//
//            if ($ids[0]['child'] != '') {
//                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE  H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                $balance += $opening;
//            }
//
//            if (abs($balance) > 0 && $level >= 1) {
//                $table .= '<tr>
//                            <td><b>' . $eachOne->account_no . '</b></td>
//                            <td><b>' . $accountName . '</b></td>
//                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . '</b></td>
//                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . '</b></td>
//                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . '</b></td>
//                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . '</b></td>
//                        </tr>';
//            }
//
//            $total_debit += $debit;
//            $total_credit += $credit;
////LEVEL 2
//            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachOne->id));
//            foreach ($levelTwo as $eachTwo) {
//
//                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                            SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                            WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                            JOIN
//                            (SELECT @pv:=' . $eachTwo->id . ') tmp
//                            ) a';
//                $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                $debit = $credit = $balance = $opening = 0;
//                $bo = $bc = '';
//                $accountName = $eachTwo->description;
//
//                if ($ids[0]['child'] != '') {
//                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                    $balance += $opening;
//                    $bo = '<b>';
//                    $bc = '</b>';
//                } else {
//                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachTwo->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
//                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
//                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
//
//                    $balance += $opening;
//                }
//                if (abs($balance) > 0 && $level >= 2) {
//                    $table .= '<tr>
//                                    <td>' . $bo . $eachTwo->account_no . $bc . '</td>
//                                    <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                                </tr>';
//                }
//
//                //LEVEL 3
//                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachTwo->id));
//                foreach ($levelThree as $eachThree) {
//
//                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                                JOIN
//                                (SELECT @pv:=' . $eachThree->id . ') tmp
//                                ) a';
//                    $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                    $debit = $credit = $balance = $opening = 0;
//                    $bo = $bc = '';
//                    $accountName = $eachThree->description;
//
//                    if ($ids[0]['child'] != '') {
//                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                        $balance += $opening;
//                        $bo = '<b>';
//                        $bc = '</b>';
//                    } else {
//                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachThree->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
//                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
//                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
//
//                        $balance += $opening;
//                    }
//                    if (abs($balance) > 0 && $level >= 3) {
//                        $table .= '<tr>
//                                        <td>' . $bo . $eachThree->account_no . $bc . '</td>
//                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                                    </tr>';
//                    }
//
//                    //LEVEL 4
//                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachThree->id));
//                    foreach ($levelFour as $eachFour) {
//
//                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                                    JOIN
//                                    (SELECT @pv:=' . $eachFour->id . ') tmp
//                                    ) a';
//                        $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                        $debit = $credit = $balance = $opening = 0;
//                        $bo = $bc = '';
//                        $accountName = $eachFour->description;
//
//                        if ($ids[0]['child'] != '') {
//                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                            $balance += $opening;
//                            $bo = '<b>';
//                            $bc = '</b>';
//                        } else {
//                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFour->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
//                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
//                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
//
//                            $balance += $opening;
//                        }
//                        if (abs($balance) > 0 && $level >= 4) {
//                            $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
//                                    <td>' . $bo . $eachFour->account_no . $bc . '</td>
//                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                                </tr>';
//                        }
//
//                        //LEVEL 4
//                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachFour->id));
//                        foreach ($levelFive as $eachFive) {
//
//                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                                        JOIN
//                                        (SELECT @pv:=' . $eachFive->id . ') tmp
//                                        ) a';
//                            $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                            $debit = $credit = $balance = $opening = 0;
//                            $bo = $bc = '';
//                            $accountName = $eachFive->description;
//
//                            if ($ids[0]['child'] != '') {
//                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//
//                                $bo = '<b>';
//                                $bc = '</b>';
//                            } else {
//                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFive->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
//                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
//                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
//                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
//
//                                $balance += $opening;
//                            }
//                            if (abs($balance) > 0 && $level >= 5) {
//                                $table .= '<tr>
//                                            <td>' . $bo . $eachFive->account_no . $bc . '</td>
//                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($opening), " ") . get_symbol($opening) . $bc . '</td>
//                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
//                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
//                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
//                                        </tr>';
//                            }
//
//                        }
//                    }
//                }
//            }
//        }
//        $table .= '<tr>
//                        <td colspan="3" class="text-right"><b>Total</b></td>
//                        <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
//                        <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
//                        <td></td>
//                </tr>';
//        $table .= '</tbody>
//            </table>';
//
//        $param = array('table' => $table, 'from_date' => date('d/m/Y', strtotime($accountingPeriod['from'])), 'to_date' => date('d/m/Y', strtotime($to_date)));
//        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
//        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
//        $mpdf->WriteHTML($stylesheet, 1);
//        $mpdf->WriteHTML($this->renderPartial('pdf_tb_report', $param, true));
//        $mpdf->Output("trialbalance" . date("d-m-Y"), 'I');
//    }
    public function actionTb_pdf()
    {
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
        $accountingPeriod = $from;
        $level = in_array((int) $_GET['level'], array(1, 2, 3, 4, 5)) ? (int) $_GET['level'] : 5;

        $query = 'CREATE OR REPLACE VIEW {{finance_trialbalance}} AS SELECT
                    L.id AS ledger_id,
                    L.account_no AS ledger_no,
                    L.description AS ledger_name,
                    L.level AS level,
                    L.parent_account AS parent,
                    IFNULL(S.description, "N/A") AS subledger,
                    IFNULL(S.id, 0) AS subledger_id,
                    ROUND((SUM(CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS debit,
                    ROUND((SUM(CASE WHEN VI.amount < 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS credit,
                    ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                FROM {{finance_legder}} L
                LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("B", "P")
                GROUP BY L.id, S.id';

        Yii::app()->db->createCommand($query)->execute();

        $table = '<table class="table table-hover table-fixed table-bordered" id="tb_table">
                    <thead>
                        <tr>
                            <th style="width:5%" >#</th>
                            <th style="width:45%" >Particular</th>
                            <th style="width:17%;" class="text-right">Debit (' . FinanceLegder::baseCurrency() . ')</th>
                            <th style="width:17%;" class="text-right">Credit (' . FinanceLegder::baseCurrency() . ')</th>
                            <th style="width:17%;" class="text-right">Balance (' . FinanceLegder::baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>';

        function get_symbol($value)
        {
            return ($value) > 0 ? ' Dr' : ' Cr';
        }

        //We have 5 levels
        $total_debit = $total_credit = 0;
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
        foreach ($levelOne as $eachOne) {

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                JOIN
                (SELECT @pv:=' . $eachOne->id . ') tmp
                ) a';
            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $debit = $credit = $balance = $opening = 0;
            $accountName = $eachOne->description;

            if ($ids[0]['child'] != '') {
                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE  H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                $balance += $opening;
            }

            if (abs($balance) > 0 && $level >= 1) {
                $table .= '<tr>
                            <td><b>' . $eachOne->account_no . '</b></td>
                            <td><b>' . $accountName . '</b></td>
                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . '</b></td>
                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . '</b></td>
                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . '</b></td>
                        </tr>';
            }

            $total_debit += $debit;
            $total_credit += $credit;
//LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                            SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                            WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                            JOIN
                            (SELECT @pv:=' . $eachTwo->id . ') tmp
                            ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $debit = $credit = $balance = $opening = 0;
                $bo = $bc = '';
                $accountName = $eachTwo->description;

                if ($ids[0]['child'] != '') {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                    $balance += $opening;
                    $bo = '<b>';
                    $bc = '</b>';
                } else {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachTwo->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();

                    $balance += $opening;
                }
                if (abs($balance) > 0 && $level >= 2) {
                    $table .= '<tr>
                                    <td>' . $bo . $eachTwo->account_no . $bc . '</td>
                                    <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                </tr>';
                }

                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachThree->id . ') tmp
                                ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $debit = $credit = $balance = $opening = 0;
                    $bo = $bc = '';
                    $accountName = $eachThree->description;

                    if ($ids[0]['child'] != '') {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                        $balance += $opening;
                        $bo = '<b>';
                        $bc = '</b>';
                    } else {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachThree->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();

                        $balance += $opening;
                    }
                    if (abs($balance) > 0 && $level >= 3) {
                        $table .= '<tr>
                                        <td>' . $bo . $eachThree->account_no . $bc . '</td>
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                    </tr>';
                    }

                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFour->id . ') tmp
                                    ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $debit = $credit = $balance = $opening = 0;
                        $bo = $bc = '';
                        $accountName = $eachFour->description;

                        if ($ids[0]['child'] != '') {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                            $balance += $opening;
                            $bo = '<b>';
                            $bc = '</b>';
                        } else {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFour->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();

                            $balance += $opening;
                        }
                        if (abs($balance) > 0 && $level >= 4) {
                            $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
                                    <td>' . $bo . $eachFour->account_no . $bc . '</td>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                </tr>';
                        }

                        //LEVEL 4
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                        JOIN
                                        (SELECT @pv:=' . $eachFive->id . ') tmp
                                        ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $debit = $credit = $balance = $opening = 0;
                            $bo = $bc = '';
                            $accountName = $eachFive->description;

                            if ($ids[0]['child'] != '') {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                                $bo = '<b>';
                                $bc = '</b>';
                            } else {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFive->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();

                                $balance += $opening;
                            }
                            if (abs($balance) > 0 && $level >= 5) {
                                $table .= '<tr>
                                            <td>' . $bo . $eachFive->account_no . $bc . '</td>
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                        </tr>';
                            }

                        }
                    }
                }
            }
        }
        $table .= '<tr>
                        <td colspan="2" class="text-right"><b>Total</b></td>
                        <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                        <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                        <td></td>
                </tr>';
        $table .= '</tbody>
            </table>';

        $param = array('table' => $table, 'from_date' => date('d/m/Y', strtotime($from_date)), 'to_date' => date('d/m/Y', strtotime($to_date)));
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('pdf_tb_report', $param, true));
        $mpdf->Output("trialbalance" . date("d-m-Y"), 'I');
    }
    public function actionBs_report()
    {
        $this->render('bs_report');
    }

//    public function actionBs_html()
//    {
//        $brand = (int) $_POST['brand'];
////        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
//        $from_date = date('2010-01-01');
//        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
//        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
//        $accountingPeriod = $from_date;
//
//        $balanceQuery = 'SELECT ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id WHERE  V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $to_date . '"';
//        $grossProfitorloss = Yii::app()->db->createCommand($balanceQuery)->queryScalar();
//
////        $voucherHead = array();
////        $voucherHead['voucher_type'] = 11; //Year Closing
////        $voucherHead['voucher_no'] = date('Y', strtotime($to_date));
////        $voucherHead['voucher_date'] = $to_date;
////        $voucherHead['header_table_id'] = 0;
////        $voucherHead['reference_no'] = 'System generated voucher';
////        $voucherHead['is_posted'] = 'Y';
////        $voucherHead['created_by'] = Yii::app()->user->id;
////        $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
////
////        $lastSavedid = $this->addVoucherhead($voucherHead);
////        if ($lastSavedid > 0) {
////            $this->addVoucheritems($lastSavedid, array('narration' => 'Current Year Profit', 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('current_year_profit'), 'currency' => MasCurrency::base_currency_id(), 'exchange_rate' => 1));
////        }
//
//        $query = 'CREATE OR REPLACE VIEW {{finance_balance_sheet}} AS SELECT
//                            L.id AS ledger_id,
//                            L.account_no AS ledger_no,
//                            L.description AS ledger_name,
//                            L.level AS level,
//                            L.parent_account AS parent,
//                            IFNULL(S.description, "N/A") AS subledger,
//                            IFNULL(S.id, 0) AS subledger_id,
//                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
//                        FROM {{finance_legder}} L
//                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
//                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
//                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
//                        WHERE V.is_posted="Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '" AND L.type_of_account IN ("B")
//                        GROUP BY L.id, S.id';
//        Yii::app()->db->createCommand($query)->execute();
//
//        function get_symbol($value)
//        {
//            return $value >= 0 ? 'Dr' : 'Cr';
//        }
//
//        function addSpace($value)
//        {
//            $space = '';
//            for ($i = 0; $i <= $value; $i++) {
//                $space .= '&nbsp;';
//            }
//
//            return $space;
//        }
//
//        function getClick($model, $from_date, $to_date)
//        {
//            return ($model->haveSubledger == 'Y') ? 'js:load_summary(' . $model->id . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');' : 'js:load_gl_report(' . $model->id . ', 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
//        }
//
//        //We have 5 levels
//        $table = '';
//        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B") '));
//        foreach ($levelOne as $p => $eachOne) {
//            $grandTotal = 0;
//            $table .= '<div class="col-6"><table class="table table-hover table-fixed table-bordered" id="bs_table_' . ($p + 1) . '">
//                        <thead>
//                            <tr>
//                                <th style="width:40%">' . $eachOne->description . '</th>
//                                <th style="width:60%">Balance</th>
//                            </tr>
//                        </thead>
//                    <tbody>';
//
//            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                        JOIN
//                        (SELECT @pv:=' . $eachOne->id . ') tmp
//                     ) a';
//
//            $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//            $balance = 0;
//            $accountName = $eachOne->description;
//
//            if ($ids[0]['child'] != '') {
//                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//            }
//
//            $table .= '<tr data-id="' . $eachOne->id . '" data-parent="" >
//                            <td><b>' . $accountName . '</b></td>
//                            <td style="text-align:right !important;" ><b>' .  Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . '</b></td>
//                        </tr>';
//
//            $grandTotal += $balance;
//            //LEVEL 2
//            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachOne->id));
//            foreach ($levelTwo as $eachTwo) {
//
//                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                    JOIN
//                    (SELECT @pv:=' . $eachTwo->id . ') tmp
//                    ) a';
//                $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                $balance = 0;
//                $bo = $bc = '';
//                $accountName = $eachTwo->description;
//
//                if ($ids[0]['child'] != '') {
//                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                    $bo = '<b>';
//                    $bc = '</b>';
//                } else {
//                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
//                    $accountName = '<a href="#" onclick="' . getClick($eachTwo, $accountingPeriod, $to_date) . '">' . $eachTwo->description . '</a>';
//                }
//
//                if (abs($balance) != 0) {
//                    $table .= '<tr data-id="' . $eachTwo->id . '" data-parent="' . $eachOne->id . '" >
//                                <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                <td style="text-align:right !important;" >' . $bo  . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance). $bc . addSpace(30) . '</td>
//                            </tr>';
//                }
//
//                //LEVEL 3
//                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachTwo->id));
//                foreach ($levelThree as $eachThree) {
//
//                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                        JOIN
//                        (SELECT @pv:=' . $eachThree->id . ') tmp
//                        ) a';
//                    $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                    $balance = 0;
//                    $bo = $bc = '';
//                    $accountName = $eachThree->description;
//
//                    if ($ids[0]['child'] != '') {
//                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                        $bo = '<b>';
//                        $bc = '</b>';
//                    } else {
//                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
//                        $accountName = '<a href="#" onclick="' . getClick($eachThree, $accountingPeriod, $to_date) . '">' . $eachThree->description . '</a>';
//                    }
//
//                    if (abs($balance) != 0) {
//                        $table .= '<tr data-id="' . $eachThree->id . '" data-parent="' . $eachTwo->id . '" >
//                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(60) . '</td>
//                                </tr>';
//                    }
//
//                    //LEVEL 4
//                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachThree->id));
//                    foreach ($levelFour as $eachFour) {
//
//                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                                JOIN
//                                (SELECT @pv:=' . $eachFour->id . ') tmp
//                                ) a';
//                        $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                        $balance = 0;
//                        $bo = $bc = '';
//                        $accountName = $eachFour->description;
//
//                        if ($ids[0]['child'] != '') {
//                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                            $bo = '<b>';
//                            $bc = '</b>';
//                        } else {
//                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
//
//                            $accountName = '<a href="#" onclick="' . getClick($eachFour, $accountingPeriod, $to_date) . '">' . $eachFour->description . '</a>';
//                        }
//
//                        if (abs($balance) != 0) {
//                            $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
//                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
//                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance)  . $bc . addSpace(90) . '</td>
//                                        </tr>';
//                        }
//
//                        //LEVEL 5
//                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachFour->id));
//                        foreach ($levelFive as $eachFive) {
//
//                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
//                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
//                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
//                                    JOIN
//                                    (SELECT @pv:=' . $eachFive->id . ') tmp
//                                    ) a';
//                            $ids = Yii::app()->db->createCommand($query)->queryAll();
//
//                            $balance = 0;
//                            $bo = $bc = '';
//                            $accountName = $eachFive->description;
//
//                            if ($ids[0]['child'] != '') {
//                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
//                                $bo = '<b>';
//                                $bc = '</b>';
//                            } else {
//                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
//
//                                $accountName = '<a href="#" onclick="' . getClick($eachFive, $accountingPeriod, $to_date) . '">' . $eachFive->description . '</a>';
//                            }
//
//                            if (abs($balance) != 0) {
//                                $table .= '<tr data-id="' . $eachFive->id . '" data-parent="' . $eachFour->id . '" >
//                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
//                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(120) . '</td>
//                                        </tr>';
//                            }
//
//                        }
//                    }
//                }
//            }
//
//            $table .= '<tr data-id="1000" data-parent="" >
//                            <td style="text-align:right !important;"><b>Total</b></td>
//                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grandTotal), " "). get_symbol($grandTotal) . '</b></td>
//
//                    </tr>';
//            $table .= '</tbody>
//                </table></div>';
//        }
//
//        if ($lastSavedid > 0) {
//            FinanceVoucherHead::model()->deletebypk($lastSavedid);
//            FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $lastSavedid));
//        }
//        echo $table;
//
//    }
    public function actionBs_html()
    {
        $brand = (int) $_POST['brand'];
//        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $from_date = date('2010-01-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
        $accountingPeriod = $from_date;

        $balanceQuery = 'SELECT ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id WHERE  V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $to_date . '"';
        $grossProfitorloss = Yii::app()->db->createCommand($balanceQuery)->queryScalar();

//        $voucherHead = array();
//        $voucherHead['voucher_type'] = 11; //Year Closing
//        $voucherHead['voucher_no'] = date('Y', strtotime($to_date));
//        $voucherHead['voucher_date'] = $to_date;
//        $voucherHead['header_table_id'] = 0;
//        $voucherHead['reference_no'] = 'System generated voucher';
//        $voucherHead['is_posted'] = 'Y';
//        $voucherHead['created_by'] = Yii::app()->user->id;
//        $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
//
//        $lastSavedid = $this->addVoucherhead($voucherHead);
//        if ($lastSavedid > 0) {
//            $this->addVoucheritems($lastSavedid, array('narration' => 'Current Year Profit', 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('current_year_profit'), 'currency' => MasCurrency::base_currency_id(), 'exchange_rate' => 1));
//        }

        $query = 'CREATE OR REPLACE VIEW {{finance_balance_sheet}} AS SELECT
                            L.id AS ledger_id,
                            L.account_no AS ledger_no,
                            L.description AS ledger_name,
                            L.level AS level,
                            L.parent_account AS parent,
                            IFNULL(S.description, "N/A") AS subledger,
                            IFNULL(S.id, 0) AS subledger_id,
                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                        FROM {{finance_legder}} L
                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        WHERE V.is_posted="Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '" AND L.type_of_account IN ("B")
                        GROUP BY L.id, S.id';
        Yii::app()->db->createCommand($query)->execute();

        function get_symbol($value)
        {
            return $value >= 0 ? 'Dr' : 'Cr';
        }

        function addSpace($value)
        {
            $space = '';
            for ($i = 0; $i <= $value; $i++) {
                $space .= '&nbsp;';
            }

            return $space;
        }

        function getClick($model, $from_date, $to_date)
        {
            return ($model->haveSubledger == 'Y') ? 'js:load_summary(' . $model->id . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');' : 'js:load_gl_report(' . $model->id . ', 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
        }

        //We have 5 levels
        $table = '';
        $tot=0;
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B") '));
        foreach ($levelOne as $p => $eachOne) {
            $grandTotal = 0;
            $table .= '<div class="col-6"><table class="table table-hover table-fixed table-bordered" id="bs_table_' . ($p + 1) . '">
                        <thead>
                            <tr>
                                <th style="width:40%">' . $eachOne->description . '</th>
                                <th style="width:60%">Balance</th>
                            </tr>
                        </thead>
                    <tbody>';

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachOne->id . ') tmp
                     ) a';

            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $balance = 0;
            $accountName = $eachOne->description;

            if ($ids[0]['child'] != '') {
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
            }

            $table .= '<tr data-id="' . $eachOne->id . '" data-parent="" >
                            <td><b>' . $accountName . '</b></td>
                            <td style="text-align:right !important;" ><b>' .  Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . '</b></td>
                        </tr>';

            $grandTotal += $balance;
            //LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                    JOIN
                    (SELECT @pv:=' . $eachTwo->id . ') tmp
                    ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $balance = 0;
                $bo = $bc = '';
                $accountName = $eachTwo->description;

                if ($ids[0]['child'] != '') {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $bo = '<b>';
                    $bc = '</b>';
                } else {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $accountName = '<a href="#" onclick="' . getClick($eachTwo, $accountingPeriod, $to_date) . '">' . $eachTwo->description . '</a>';
                }

                if (abs($balance) != 0) {
                    $table .= '<tr data-id="' . $eachTwo->id . '" data-parent="' . $eachOne->id . '" >
                                <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                <td style="text-align:right !important;" >' . $bo  . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance). $bc . addSpace(30) . '</td>
                            </tr>';
                }

                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachThree->id . ') tmp
                        ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $balance = 0;
                    $bo = $bc = '';
                    $accountName = $eachThree->description;

                    if ($ids[0]['child'] != '') {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $bo = '<b>';
                        $bc = '</b>';
                    } else {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $accountName = '<a href="#" onclick="' . getClick($eachThree, $accountingPeriod, $to_date) . '">' . $eachThree->description . '</a>';
                    }

                    if (abs($balance) != 0) {
                        $table .= '<tr data-id="' . $eachThree->id . '" data-parent="' . $eachTwo->id . '" >
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(60) . '</td>
                                </tr>';
                    }

                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachFour->id . ') tmp
                                ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $balance = 0;
                        $bo = $bc = '';
                        $accountName = $eachFour->description;

                        if ($ids[0]['child'] != '') {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $bo = '<b>';
                            $bc = '</b>';
                        } else {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();

                            $accountName = '<a href="#" onclick="' . getClick($eachFour, $accountingPeriod, $to_date) . '">' . $eachFour->description . '</a>';
                        }

                        if (abs($balance) != 0) {
                            $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance)  . $bc . addSpace(90) . '</td>
                                        </tr>';
                        }

                        //LEVEL 5
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFive->id . ') tmp
                                    ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $balance = 0;
                            $bo = $bc = '';
                            $accountName = $eachFive->description;

                            if ($ids[0]['child'] != '') {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $bo = '<b>';
                                $bc = '</b>';
                            } else {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();

                                $accountName = '<a href="#" onclick="' . getClick($eachFive, $accountingPeriod, $to_date) . '">' . $eachFive->description . '</a>';
                            }

                            if (abs($balance) != 0) {
                                $table .= '<tr data-id="' . $eachFive->id . '" data-parent="' . $eachFour->id . '" >
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(120) . '</td>
                                        </tr>';
                            }

                        }
                    }
                }
            }

            $tot+=$grandTotal;
            $table .= '<tr data-id="1000" data-parent="" >
                            <td style="text-align:right !important;"><b>Total</b></td>
                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grandTotal), " "). get_symbol($grandTotal) . '</b></td>
                    </tr>';
            
            $table .= '</tbody>
                </table></div>';
        }
        
//        if($tot>0)
//        {
//                        $table .= '<div class="col-6"><table class="table table-hover table-fixed table-bordered">
//                        <thead>
//                            <tr>
//                                <th  style="text-align:right !important;width:70%">Profit</th>
//                                <th style="text-align:right !important;width:30%">' . Yii::app()->numberFormatter->formatCurrency(abs($tot), " ").'</th>
//                            </tr>
//                        </thead>';
//        }
//        else {
//                        $table .= '<div class="col-6"><table class="table table-hover table-fixed table-bordered">
//                        <thead>
//                            <tr>
//                                <th  style="text-align:right !important;width:70%">Loss</th>
//                                <th style="text-align:right !important;width:30%">' . Yii::app()->numberFormatter->formatCurrency(abs($tot), " ").'</th>
//                            </tr>
//                        </thead>';    
//        }
                        
        if ($lastSavedid > 0) {
            FinanceVoucherHead::model()->deletebypk($lastSavedid);
            FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $lastSavedid));
        }
        echo $table;

    }
    
    public function actionPl_report()
    {
        $this->render('pl_report');
    }

    public function actionPl_html()
    {
        $brand = (int) $_POST['brand'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $condition = 'V.is_posted="Y" AND V.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("P")';
        
        $accountingPeriod = $from_date;

        $balanceQuery = 'SELECT ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id WHERE  V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $to_date . '"';
        $grossProfitorloss = Yii::app()->db->createCommand($balanceQuery)->queryScalar();

//        $voucherHead = array();
//        $voucherHead['voucher_type'] = 11; //Year Closing
//        $voucherHead['voucher_no'] = date('Y', strtotime($to_date));
//        $voucherHead['voucher_date'] = $to_date;
//        $voucherHead['header_table_id'] = 0;
//        $voucherHead['reference_no'] = 'System generated voucher';
//        $voucherHead['is_posted'] = 'Y';
//        $voucherHead['created_by'] = Yii::app()->user->id;
//        $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
//
//        $lastSavedid = $this->addVoucherhead($voucherHead);
//        if ($lastSavedid > 0) {
//            $this->addVoucheritems($lastSavedid, array('narration' => 'Current Year Profit', 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('current_year_profit'), 'currency' => MasCurrency::base_currency_id(), 'exchange_rate' => 1));
//        }

        $query = 'CREATE OR REPLACE VIEW {{finance_balance_sheet}} AS SELECT
                            L.id AS ledger_id,
                            L.account_no AS ledger_no,
                            L.description AS ledger_name,
                            L.level AS level,
                            L.parent_account AS parent,
                            IFNULL(S.description, "N/A") AS subledger,
                            IFNULL(S.id, 0) AS subledger_id,
                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                        FROM {{finance_legder}} L
                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        WHERE V.is_posted="Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '" AND L.type_of_account IN ("P")
                        GROUP BY L.id, S.id';
        Yii::app()->db->createCommand($query)->execute();

        function get_symbol($value)
        {
            return $value >= 0 ? 'Dr' : 'Cr';
        }

        function addSpace($value)
        {
            $space = '';
            for ($i = 0; $i <= $value; $i++) {
                $space .= '&nbsp;';
            }

            return $space;
        }

        function getClick($model, $from_date, $to_date)
        {
            return ($model->haveSubledger == 'Y') ? 'js:load_summary(' . $model->id . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');' : 'js:load_gl_report(' . $model->id . ', 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
        }

        //We have 5 levels
        $table = '';
        $tot=0;
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("P") '));
        foreach ($levelOne as $p => $eachOne) {
            $grandTotal = 0;
            $table .= '<div class="col-6"><table class="table table-hover table-fixed table-bordered" id="bs_table_' . ($p + 1) . '">
                        <thead>
                            <tr>
                                <th style="width:40%">' . $eachOne->description . '</th>
                                <th style="width:60%">Balance</th>
                            </tr>
                        </thead>
                    <tbody>';

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachOne->id . ') tmp
                     ) a';

            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $balance = 0;
            $accountName = $eachOne->description;

            if ($ids[0]['child'] != '') {
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
            }

            $table .= '<tr data-id="' . $eachOne->id . '" data-parent="" >
                            <td><b>' . $accountName . '</b></td>
                            <td style="text-align:right !important;" ><b>' .  Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . '</b></td>
                        </tr>';

            $grandTotal += $balance;
            //LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                    JOIN
                    (SELECT @pv:=' . $eachTwo->id . ') tmp
                    ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $balance = 0;
                $bo = $bc = '';
                $accountName = $eachTwo->description;

                if ($ids[0]['child'] != '') {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $bo = '<b>';
                    $bc = '</b>';
                } else {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $accountName = '<a href="#" onclick="' . getClick($eachTwo, $accountingPeriod, $to_date) . '">' . $eachTwo->description . '</a>';
                }

                if (abs($balance) != 0) {
                    $table .= '<tr data-id="' . $eachTwo->id . '" data-parent="' . $eachOne->id . '" >
                                <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                <td style="text-align:right !important;" >' . $bo  . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance). $bc . addSpace(30) . '</td>
                            </tr>';
                }

                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachThree->id . ') tmp
                        ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $balance = 0;
                    $bo = $bc = '';
                    $accountName = $eachThree->description;

                    if ($ids[0]['child'] != '') {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $bo = '<b>';
                        $bc = '</b>';
                    } else {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $accountName = '<a href="#" onclick="' . getClick($eachThree, $accountingPeriod, $to_date) . '">' . $eachThree->description . '</a>';
                    }

                    if (abs($balance) != 0) {
                        $table .= '<tr data-id="' . $eachThree->id . '" data-parent="' . $eachTwo->id . '" >
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                    <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(60) . '</td>
                                </tr>';
                    }

                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachFour->id . ') tmp
                                ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $balance = 0;
                        $bo = $bc = '';
                        $accountName = $eachFour->description;

                        if ($ids[0]['child'] != '') {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $bo = '<b>';
                            $bc = '</b>';
                        } else {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();

                            $accountName = '<a href="#" onclick="' . getClick($eachFour, $accountingPeriod, $to_date) . '">' . $eachFour->description . '</a>';
                        }

                        if (abs($balance) != 0) {
                            $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance)  . $bc . addSpace(90) . '</td>
                                        </tr>';
                        }

                        //LEVEL 5
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFive->id . ') tmp
                                    ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $balance = 0;
                            $bo = $bc = '';
                            $accountName = $eachFive->description;

                            if ($ids[0]['child'] != '') {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $bo = '<b>';
                                $bc = '</b>';
                            } else {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();

                                $accountName = '<a href="#" onclick="' . getClick($eachFive, $accountingPeriod, $to_date) . '">' . $eachFive->description . '</a>';
                            }

                            if (abs($balance) != 0) {
                                $table .= '<tr data-id="' . $eachFive->id . '" data-parent="' . $eachFour->id . '" >
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(120) . '</td>
                                        </tr>';
                            }

                        }
                    }
                }
            }

            $tot+=-1*$grandTotal;
            $table .= '<tr data-id="1000" data-parent="" >
                            <td style="text-align:right !important;"><b>Total</b></td>
                            <td style="text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grandTotal), " "). get_symbol($grandTotal) . '</b></td>
                    </tr>';
            
            $table .= '</tbody>
                </table></div>';
        }
        if($tot>0)
        {
                        $table .= '<div class="col-6"><table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th  style="text-align:right !important;width:70%">Profit</th>
                                <th style="text-align:right !important;width:30%">' . Yii::app()->numberFormatter->formatCurrency(abs($tot), " ").'</th>
                            </tr>
                        </thead>';
        }
        else {
                        $table .= '<div class="col-6"><table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th  style="text-align:right !important;width:70%">Loss</th>
                                <th style="text-align:right !important;width:30%">' . Yii::app()->numberFormatter->formatCurrency(abs($tot), " ").'</th>
                            </tr>
                        </thead>';    
        }
                        
        if ($lastSavedid > 0) {
            FinanceVoucherHead::model()->deletebypk($lastSavedid);
            FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $lastSavedid));
        }
        echo $table;

    }
    public function actionPl_excel()
    {
        $brand = (int) $_GET['brand'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $condition = 'V.is_posted="Y" AND V.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("P")';
        if ($brand > 0) {
            $condition .= ' AND VI.brand_id=' . $brand;
        }

        $brandModel = ProductClass::model()->findbypk($brand);

        $query = 'CREATE OR REPLACE VIEW {{finance_profit_and_loss}} AS SELECT
                            L.id AS ledger_id,
                            L.account_no AS ledger_no,
                            L.description AS ledger_name,
                            L.level AS level,
                            L.parent_account AS parent,
                            IFNULL(S.description, "N/A") AS subledger,
                            S.id AS subledger_id,
                            ROUND((SUM(CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS debit,
                            ROUND((SUM(CASE WHEN VI.amount < 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS credit,
                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                        FROM {{finance_legder}} L
                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        WHERE ' . $condition . '
                        GROUP BY L.id, S.id';
        Yii::app()->db->createCommand($query)->execute();

        function addSpace($value)
        {
            $space = '';
            for ($i = 0; $i <= $value; $i++) {
                $space .= ' ';
            }

            return $space;
        }
        function getSymbol($value, $item)
        {
            return (($value <= 0 && $item == 'I') || ($value > 0 && $item == 'E')) ? '' : '(-)';
        }

        //We have 5 levels
        $table = '';
        $totals = array();
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("P") ', 'order' => 'id ASC'));
        $rowId = 2;

        // Create new PHPExcel object
        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Profit and Loss")
            ->setSubject("Profit and Loss")
            ->setDescription("Profit and Loss as on date" . $to_date)
            ->setKeywords("Profit and Loss")
            ->setCategory("Financial Report");

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);

        $content = $brand > 0 ? 'Profit and Loss for the Period ' . date('d/m/Y', strtotime($from_date)) . ' to ' . date('d/m/Y', strtotime($to_date)) . ' for Brand ' . $brandModel->description : 'Profit and Loss for the Period ' . date('d/m/Y', strtotime($from_date)) . ' to ' . date('d/m/Y', strtotime($to_date));
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', $content);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:C1');
        $excel->getActiveSheet()->getStyle('A1:C1')->getFont()->setBold(true)->setSize(15);

        foreach ($levelOne as $p => $eachOne) {
            $grandTotal = 0;
            $totalDebit = $totalCredit = 0;

            $headingOne = ($eachOne->main_account_type == 'I') ? 'Funds Out' : 'Funds In';
            $headingTwo = ($eachOne->main_account_type == 'I') ? 'Funds In' : 'Funds Out';
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);

            $excel->getActiveSheet(0)->getStyle('A' . $rowId . ':C' . $rowId)->applyFromArray(array(
                'borders' => array(
                    'bottom' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '#1E1F20'),
                    ),
                ),
            ));

            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, 'Particular')
                ->setCellValue('B' . $rowId, $headingOne)
                ->setCellValue('C' . $rowId, $headingTwo);
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => 'd9d9d9',
                ),
            ));
            $rowId++;

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachOne->id . ') tmp
                     ) a';

            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $balance = 0;
            $accountName = $eachOne->description;

            if ($ids[0]['child'] != '') {
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $totalDebit = $debit;
                $totalCredit = $credit;
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
                $totals[] = $balance;
            }

            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountName)
                ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($credit, " "));
            $rowId++;

            $grandTotal += $balance;
            //LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                    JOIN
                    (SELECT @pv:=' . $eachTwo->id . ') tmp
                    ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $balance = 0;
                $bo = $bc = '';
                $accountName = $eachTwo->description;
                $subledgerCount = 0;

                if ($ids[0]['child'] != '') {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
                } else {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                }

                if (abs($balance) != 0) {
                    $excel->setActiveSheetIndex(0)
                        ->setCellValue('A' . $rowId, addSpace(5) . $accountName)
                        ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                        ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($credit, " "));
                    $rowId++;
                }

                if ($subledgerCount > 0) {
                    foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_profit_and_loss}} WHERE ledger_id=' . $eachTwo->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {

                        $excel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $rowId, addSpace(8) . $eachSub['subledger'])
                            ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                            ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "));

                        $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setItalic(true)->setSize(9);
                        $rowId++;
                    }
                }

                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachThree->id . ') tmp
                        ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $balance = 0;
                    $accountName = $eachThree->description;
                    $subledgerCount = 0;

                    if ($ids[0]['child'] != '') {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(12);
                    } else {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                    }

                    if (abs($balance) != 0) {
                        $excel->setActiveSheetIndex(0)
                            ->setCellValue('A' . $rowId, addSpace(10) . $accountName)
                            ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                            ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($credit, " "));
                        $rowId++;
                    }

                    if ($subledgerCount > 0) {
                        foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_profit_and_loss}} WHERE ledger_id=' . $eachThree->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {

                            $excel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $rowId, addSpace(13) . $eachSub['subledger'])
                                ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "));

                            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setItalic(true)->setSize(9);
                            $rowId++;
                        }
                    }

                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachFour->id . ') tmp
                                ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $balance = 0;
                        $accountName = $eachFour->description;
                        $subledgerCount = 0;

                        if ($ids[0]['child'] != '') {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(10);
                        } else {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                        }

                        if (abs($balance) != 0) {
                            $excel->setActiveSheetIndex(0)
                                ->setCellValue('A' . $rowId, addSpace(15) . $accountName)
                                ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($credit, " "));
                            $rowId++;
                        }

                        if ($subledgerCount > 0) {
                            foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_profit_and_loss}} WHERE ledger_id=' . $eachFour->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {

                                $excel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $rowId, addSpace(18) . $eachSub['subledger'])
                                    ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                                    ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "));

                                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setItalic(true)->setSize(9);
                                $rowId++;
                            }
                        }

                        //LEVEL 5
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFive->id . ') tmp
                                    ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $balance = 0;
                            $accountName = $eachFive->description;
                            $subledgerCount = 0;

                            if ($ids[0]['child'] != '') {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                            } else {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT ABS(SUM(credit)) AS credit FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $subledgerCount = Yii::app()->db->createCommand('SELECT COUNT(subledger_id) AS count FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                            }

                            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(10);
                            if (abs($balance) != 0) {
                                $excel->setActiveSheetIndex(0)
                                    ->setCellValue('A' . $rowId, addSpace(20) . $accountName)
                                    ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                                    ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency($credit, " "));
                                $rowId++;
                            }

                            if ($subledgerCount > 0) {
                                foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_profit_and_loss}} WHERE ledger_id=' . $eachFive->id . ' AND balance != 0 ORDER BY subledger ASC')->queryAll() as $eachSub) {

                                    $excel->setActiveSheetIndex(0)
                                        ->setCellValue('A' . $rowId, addSpace(23) . $eachSub['subledger'])
                                        ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['debit']), " "))
                                        ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($eachSub['credit']), " "));

                                    $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setItalic(true)->setSize(9);
                                    $rowId++;
                                }
                            }

                        }
                    }
                }
            }

            $excel->getActiveSheet(0)->getStyle('C' . $rowId)->applyFromArray(array(
                'borders' => array(
                    'bottom' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '#1E1F20'),
                    ),

                    'top' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '#1E1F20'),
                    ),

                ),
            ));

            $excel->getActiveSheet(0)->getStyle('B' . $rowId . ':C' . $rowId)->applyFromArray(array(
                'borders' => array(
                    'top' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '#1E1F20'),
                    ),

                ),
            ));
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => 'bbbbc1',
                ),
            ));

            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, 'Total')
                ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($totalDebit), " "))
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($totalCredit), " "));
            $rowId++;
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => 'bbbbc1',
                ),
            ));
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, 'Total ' . $eachOne->description)
                ->setCellValue('C' . $rowId, getSymbol($grandTotal, $eachOne->main_account_type) . Yii::app()->numberFormatter->formatCurrency(abs($grandTotal), " "));
            $rowId++;

            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, '')
                ->setCellValue('C' . $rowId, '');
            $rowId++;

            if ($eachOne->main_account_type == 'E') {
                $cost_of_goods_sold = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale') . ')')->queryScalar();
                $grossProfit = $totals[0] + $cost_of_goods_sold;
                $symbol = ($grossProfit < 0) ? '' : '(-)';

                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                        'rgb' => 'd1d6ff',
                    ),
                ));
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
                // $excel->setActiveSheetIndex(0)
                //     ->setCellValue('A' . $rowId, 'Gross Profit (' . FinanceLegder::baseCurrency() . ')')
                //     ->setCellValue('C' . $rowId, $symbol . Yii::app()->numberFormatter->formatCurrency(abs($grossProfit), " "));
                $rowId++;
                $netProfit = $totals[0] + $totals[1];
                $symbol = ($netProfit < 0) ? '' : '(-)';

                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'startcolor' => array(
                        'rgb' => 'd1ebff',
                    ),
                ));
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
                // $excel->setActiveSheetIndex(0)
                //     ->setCellValue('A' . $rowId, 'Net Profit (' . FinanceLegder::baseCurrency() . ')')
                //     ->setCellValue('C' . $rowId, $symbol . Yii::app()->numberFormatter->formatCurrency(abs($netProfit), " "));

            }
        }

        $excel->getActiveSheet()->getStyle('B2:C' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="profit_and_loss.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionPl_pdf_level()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('pl_level_filter', array('from_date' => $_GET['from_date'], 'to_date' => $_GET['to_date'], 'brand' => (int) $_GET['brand']));
    }

    public function actionPl_pdf()
    {
        $brand = (int) $_REQUEST['brand'];
        $from_date = (count(explode('/', $_REQUEST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-d');
        $condition = 'V.is_posted="Y" AND V.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("P")';
        
        $accountingPeriod = $from_date;

        $balanceQuery = 'SELECT ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} VI LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id WHERE  V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $to_date . '"';
        $grossProfitorloss = Yii::app()->db->createCommand($balanceQuery)->queryScalar();

        $query = 'CREATE OR REPLACE VIEW {{finance_balance_sheet}} AS SELECT
                            L.id AS ledger_id,
                            L.account_no AS ledger_no,
                            L.description AS ledger_name,
                            L.level AS level,
                            L.parent_account AS parent,
                            IFNULL(S.description, "N/A") AS subledger,
                            IFNULL(S.id, 0) AS subledger_id,
                            ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                        FROM {{finance_legder}} L
                        LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                        LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        WHERE V.is_posted="Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '" AND L.type_of_account IN ("P")
                        GROUP BY L.id, S.id';
        Yii::app()->db->createCommand($query)->execute();

        function get_symbol($value)
        {
            return $value >= 0 ? 'Dr' : 'Cr';
        }

        function addSpace($value)
        {
            $space = '';
            for ($i = 0; $i <= $value; $i++) {
                $space .= '&nbsp;';
            }

            return $space;
        }

        function getClick($model, $from_date, $to_date)
        {
            return ($model->haveSubledger == 'Y') ? 'js:load_summary(' . $model->id . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');' : 'js:load_gl_report(' . $model->id . ', 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
        }

        //We have 5 levels
        $table = '';
        $tot=0;
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("P") '));
        foreach ($levelOne as $p => $eachOne) {
            $grandTotal = 0;
            $table .= '<div class="col-12"><table class="table table-hover table-fixed table-bordered" id="bs_table_' . ($p + 1) . '">
                        <thead>
                            <tr>
                                <th style="width:40%">' . $eachOne->description . '</th>
                                <th style="width:60%">Balance</th>
                            </tr>
                        </thead>
                    <tbody>';

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachOne->id . ') tmp
                     ) a';

            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $balance = 0;
            $accountName = $eachOne->description;

            if ($ids[0]['child'] != '') {
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
            }

            $table .= '<tr data-id="' . $eachOne->id . '" data-parent="" >
                            <td><b>' . $accountName . '</b></td>
                            <td  class="text-right"><b>' .  Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . '</b></td>
                        </tr>';

            $grandTotal += $balance;
            //LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                    JOIN
                    (SELECT @pv:=' . $eachTwo->id . ') tmp
                    ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $balance = 0;
                $bo = $bc = '';
                $accountName = $eachTwo->description;

                if ($ids[0]['child'] != '') {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $bo = '<b>';
                    $bc = '</b>';
                } else {
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $accountName = $eachTwo->description;
                }

                if (abs($balance) != 0) {
                    $table .= '<tr data-id="' . $eachTwo->id . '" data-parent="' . $eachOne->id . '" >
                                <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                <td  class="text-right">' . $bo  . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance). $bc . addSpace(30) . '</td>
                            </tr>';
                }

                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                        JOIN
                        (SELECT @pv:=' . $eachThree->id . ') tmp
                        ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $balance = 0;
                    $bo = $bc = '';
                    $accountName = $eachThree->description;

                    if ($ids[0]['child'] != '') {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $bo = '<b>';
                        $bc = '</b>';
                    } else {
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $accountName = $eachThree->description;
                    }

                    if (abs($balance) != 0) {
                        $table .= '<tr data-id="' . $eachThree->id . '" data-parent="' . $eachTwo->id . '" >
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                    <td class="text-right">' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(60) . '</td>
                                </tr>';
                    }

                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachFour->id . ') tmp
                                ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $balance = 0;
                        $bo = $bc = '';
                        $accountName = $eachFour->description;

                        if ($ids[0]['child'] != '') {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $bo = '<b>';
                            $bc = '</b>';
                        } else {
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();

                            $accountName = $eachFour->description;
                        }

                        if (abs($balance) != 0) {
                            $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
                                            <td style="text-align:right !important;" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance)  . $bc . addSpace(90) . '</td>
                                        </tr>';
                        }

                        //LEVEL 5
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("P")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFive->id . ') tmp
                                    ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $balance = 0;
                            $bo = $bc = '';
                            $accountName = $eachFive->description;

                            if ($ids[0]['child'] != '') {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $bo = '<b>';
                                $bc = '</b>';
                            } else {
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_balance_sheet}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();

                                $accountName = $eachFive->description;
                            }

                            if (abs($balance) != 0) {
                                $table .= '<tr data-id="' . $eachFive->id . '" data-parent="' . $eachFour->id . '" >
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                            <td  class="text-right">' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " "). get_symbol($balance) . $bc . addSpace(120) . '</td>
                                        </tr>';
                            }

                        }
                    }
                }
            }

            $tot+=-1*$grandTotal;
            $table .= '<tr data-id="1000" data-parent="" >
                            <td class="text-right"><b>Total</b></td>
                            <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($grandTotal), " "). get_symbol($grandTotal) . '</b></td>
                    </tr>';
            
            $table .= '</tbody>
                </table></div>';
        }
        if($tot>0)
        {
                        $table .= '<div class="col-12"><table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th  class="text-right">Profit</th>
                                <th class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($tot), " ").'</th>
                            </tr>
                        </thead></table></div>';
        }
        else {
                        $table .= '<div class="col-12"><table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th class="text-right">Loss</th>
                                <th class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($tot), " ").'</th>
                            </tr>
                        </thead></table></div>';    
        }

        $param = array('brandModel' => $brandModel, 'table' => $table, 'from_date' => date('d/m/Y', strtotime($from_date)), 'to_date' => date('d/m/Y', strtotime($to_date)));
        $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $mpdf->WriteHTML($this->renderPartial('pdf_pl_report', $param, true));
        $mpdf->Output("profit_or_loss" . date("d-m-Y"), 'I');

    }
    public function getCategories($category)
    {
        return CHtml::listData(FinanceLegder::model()->findAll(array('condition' => 'isParent="N" AND classification="' . $category . '"', 'order' => 'description ASC')), 'id', 'description');
    }

    public function actionAging_report()
    {
        $category = ((int) $_GET['type'] == 1) ? 'RECEIVABLE' : 'PAYABLE';
        $this->render('aging_report', array('filter_array' => $this->getCategories($category), 'category' => $category));
    }

    public function actionAging_html()
    {
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $ledger = (int) $_POST['ledger_id'];
        $brand = (int) $_POST['brand'];
        $category = ($_POST['category'] == 'RECEIVABLE') ? 'RECEIVABLE' : 'PAYABLE';

        $dates_array = array(
            '0_to_30' => array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date),
            '31_to_60' => array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days'))),
            '61_to_90' => array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days'))),
            '91_to_120' => array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days'))),
            'greaterthan_120' => array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days'))),
        );

        function getSymbol($value)
        {
            return $value >= 0 ? '' : '(-)';
        }

        function generateUrl($ledger_id, $subledger_id, $tail, $mode)
        {
            return 'loadVouchers(' . $ledger_id . ', ' . (int) $subledger_id . ', \'' . $tail . '\', ' . $mode . ');';
        }

        foreach ($dates_array as $key => $each_date_pair) {

            $query = 'CREATE OR REPLACE VIEW {{finance_ageing_' . $key . '}} AS SELECT
                            VI.ledger_id AS ledger_id,
                            VI.subledger_id AS subledger_id,
                            IFNULL(S.description, "No Subledger") AS subledger,
                            V.id AS voucher_id,
                            V.voucher_date AS voucher_date,
                            V.due_date AS due_date,
                            V.reference_no AS reference_no,
                            VI.narration AS narration,
                            VI.id AS voucher_item_id,
                            CONCAT(VT.code,"/",V.voucher_no) AS voucher_no,
                            ROUND((VI.amount*VI.exchange_rate), 4) AS total_amount,
                            IFNULL(ABS(ROUND( SUM(AI.amount), 4)), 0) AS allocated,
                            ROUND((VI.amount*VI.exchange_rate), 4) - IFNULL(ROUND( SUM(AI.amount), 4), 0) AS amount
                        FROM {{finance_voucher_items}} VI
                        LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                        LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        LEFT JOIN {{finance_voucher_type}} VT ON VT.id=V.voucher_type
                        WHERE V.voucher_date >= "'.$from_date.'" AND V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '" AND
                        V.is_posted="Y" AND VI.ledger_id = "' . (int) $ledger . '"
                        GROUP BY VI.id, VI.subledger_id';

            $selectQuery = 'SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM(0_30_receivable) AS 0_30_receivable,
                        SUM(0_30_unallocated) AS 0_30_unallocated,
                        SUM(31_60_receivable) AS 31_60_receivable,
                        SUM(31_60_unallocated) AS 31_60_unallocated,
                        SUM(61_90_receivable) AS 61_90_receivable,
                        SUM(61_90_unallocated) AS 61_90_unallocated,
                        SUM(91_120_receivable) AS 91_120_receivable,
                        SUM(91_120_unallocated) AS 91_120_unallocated,
                        SUM(greater_120_receivable) AS greater_120_receivable,
                        SUM(greater_120_unallocated) AS greater_120_unallocated
                    FROM ( SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 0_30_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_0_to_30}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 31_60_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_31_to_60}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 61_90_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_61_to_90}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 91_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_91_to_120}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS greater_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS greater_120_unallocated
                    FROM {{finance_ageing_greaterthan_120}} GROUP BY subledger_id ) AS A GROUP BY A.subledger_id ORDER BY A.subledger ASC';

            Yii::app()->db->createCommand($query)->execute();
        }

        $aging_report = Yii::app()->db->createCommand($selectQuery)->queryAll();

        $data = '<table class="table table-hover table-fixed table-bordered" id="tb_table" style="font-size:13px;">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Subledger</th>
                        <th>Type</th>
                        <th>0-30</th>
                        <th>31-60</th>
                        <th>61-90</th>
                        <th>91-120</th>
                        <th> > 120</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>';
        $grand_total = 0;
        $one = 0;
        $two = 0;
        $three = 0;
        $four = 0;
        $five = 0;
        $labelOne = ($category == 'RECEIVABLE') ? 'Receivable' : 'Unallocated';
        $labelTwo = ($category == 'RECEIVABLE') ? 'Unallocated' : 'Payable';
        $z=0;
        foreach ($aging_report as $i => $each):
            $total_receivable = $each['0_30_receivable'] + $each['31_60_receivable'] + $each['61_90_receivable'] + $each['91_120_receivable'] + $each['greater_120_receivable'];
            $total_unallocated = $each['0_30_unallocated'] + $each['31_60_unallocated'] + $each['61_90_unallocated'] + $each['91_120_unallocated'] + $each['greater_120_unallocated'];

            $one_receivable += $each['0_30_receivable'];
            $two_receivable += $each['31_60_receivable'];
            $three_receivable += $each['61_90_receivable'];
            $four_receivable += $each['91_120_receivable'];
            $five_receivable += $each['greater_120_receivable'];
            $grand_total_receivable += $total_receivable;

            $one_unallocated += $each['0_30_unallocated'];
            $two_unallocated += $each['31_60_unallocated'];
            $three_unallocated += $each['61_90_unallocated'];
            $four_unallocated += $each['91_120_unallocated'];
            $five_unallocated += $each['greater_120_unallocated'];
            $grand_total_unallocated += $total_unallocated;

            if ($total_receivable > 0 || $total_unallocated > 0):
            $z++;
                $data .= '<tr>
																																									<td rowspan="2"  title="No.">' . ($z) . '</td>
																																		                            <td rowspan="2" title="Subledger" >' . $each['subledger'] . '</td>
																																		                            <td title="Type">' . $labelOne . '</td>
																																									<td style="text-align:right !important;" title="0-30"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '0_to_30', 1) . '">' . Yii::app()->numberFormatter->formatCurrency($each['0_30_receivable'], " ") . '</a></td>
																																									<td style="text-align:right !important;" title="30-60"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '31_to_60', 1) . '">' . Yii::app()->numberFormatter->formatCurrency($each['31_60_receivable'], " ") . '</a></td>
																																									<td style="text-align:right !important;" title="60-90"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '61_to_90', 1) . '">' . Yii::app()->numberFormatter->formatCurrency($each['61_90_receivable'], " ") . '</a></td>
																																									<td style="text-align:right !important;" title="90-120"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '91_to_120', 1) . '">' . Yii::app()->numberFormatter->formatCurrency($each['91_120_receivable'], " ") . '</a></td>
																																									<td style="text-align:right !important;" title=">120"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], 'greaterthan_120', 1) . '">' . Yii::app()->numberFormatter->formatCurrency($each['greater_120_receivable'], " ") . '</a></td>
																																									<td style="text-align:right !important;" title="Total">' . Yii::app()->numberFormatter->formatCurrency($total_receivable, " ") . '</td>
																																						        </tr>';
                $data .= '<tr>
																																		                            <td title="Type">' . $labelTwo . '</td>
																																		                            <td style="text-align:right !important;" title="0-30"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '0_to_30', 0) . '">' . Yii::app()->numberFormatter->formatCurrency($each['0_30_unallocated'], " ") . '</a></td>
																																						            <td style="text-align:right !important;" title="30-60"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '31_to_60', 0) . '">' . Yii::app()->numberFormatter->formatCurrency($each['31_60_unallocated'], " ") . '</a></td>
																																						            <td style="text-align:right !important;" title="60-90"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '61_to_90', 0) . '">' . Yii::app()->numberFormatter->formatCurrency($each['61_90_unallocated'], " ") . '</a></td>
																																						            <td style="text-align:right !important;" title="90-120"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], '91_to_120', 0) . '">' . Yii::app()->numberFormatter->formatCurrency($each['91_120_unallocated'], " ") . '</a></td>
																																						            <td style="text-align:right !important;" title=">120"><a href="#" onclick="' . generateUrl($each['ledger_id'], $each['subledger_id'], 'greaterthan_120', 0) . '">' . Yii::app()->numberFormatter->formatCurrency($each['greater_120_unallocated'], " ") . '</a></td>
																																						            <td style="text-align:right !important;" title="Total">' . Yii::app()->numberFormatter->formatCurrency($total_unallocated, " ") . '</td>
																																						        </tr>';
            endif;
        endforeach;
        
        $fledger=new FinanceLegder();

        $data .= '<tr>
                        <td colspan="2" rowspan="2" style="text-align:right !important;"><b>Total</b></td>
                        <td title="Type">' . $labelOne . '</td>
                        <td title="0-30" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($one_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="30-60" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($two_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="60-90" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($three_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="90-120" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($four_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title=">120" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($five_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="Total" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($grand_total_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                    </tr>';

        $data .= '<tr>
                        <td title="Type">' . $labelTwo . '</td>
                        <td title="0-30" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($one_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="30-60" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($two_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="60-90" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($three_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="90-120" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($four_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title=">120" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($five_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td title="Total" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($grand_total_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                    </tr>';
        $data .= ' </tbody>
            </table>';

        echo $data;

    }

    public function actionAging_vouchers_html()
    {
        $ledger = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $tail = $_POST['tail'];
        $mode = $_POST['mode'] == 1 ? 1 : 0;

        function generateUrl($parentModel)
        {
            $url = '#';
            $code = $parentModel->vtype->code;
            if ($code == 'SI') {
                $headModel = $parentModel->vtype->header_table;
                $vat_field = $parentModel->vtype->vat_value;
                $tax = $headModel::model()->findBypk($parentModel->header_table_id)->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $parentModel->header_table_id . "&frm=" . $taxType . "', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $parentModel->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $parentModel->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $parentModel->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $parentModel->id . "', '_blank');";
            }
            return $url;
        }

        $condition = 'ledger_id=' . $ledger . ' AND subledger_id=' . $subledger;
        if ($mode == 1) {
            $condition .= ' AND amount > 0';
        } else {
            $condition .= ' AND amount < 0';
        }

        $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_ageing_' . $tail . '}} WHERE ' . $condition . ' ORDER BY voucher_date')->queryAll();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Voucher No</th>
                            <th>Ref No</th>
                            <th>Description</th>
                            <th>Total</th>
                            <th>Allocated</th>
                            <th>Balance</th>
                        </tr>
                    <tbody>';
        if (!empty($items)) {
            foreach ($items as $each) {
                $table .= '<tr>
                                <td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
                                <td><a href="#" onclick="' . generateUrl(FinanceVoucherHead::model()->findBypk((int) $each['voucher_id'])) . '">' . $each['voucher_no'] . '</a></td>
                                <td>' . $each['reference_no'] . '</td>
                                <td>' . $each['narration'] . '</td>
                                <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($each['total_amount']), " ") . '</td>
                                <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($each['allocated']), " ") . '</td>
                                <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($each['amount']), " ") . '</td>
                            </tr>';
            }
        } else {
            $table .= '<tr>
                            <td style="text-align:center !important;" colspan="7"> No data</td>
                      </tr>';
        }

        $table .= '</tbody>
                      </table>';
        echo $table;
    }

    public function actionAging_pdf()
    {
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $ledger = (int) $_GET['ledger'];
        $brand = (int) $_GET['brand'];
        $category = ($_GET['category'] == 'RECEIVABLE') ? 'RECEIVABLE' : 'PAYABLE';

        $dates_array = array(
            '0_to_30' => array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date),
            '31_to_60' => array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days'))),
            '61_to_90' => array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days'))),
            '91_to_120' => array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days'))),
            'greaterthan_120' => array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days'))),
        );

        foreach ($dates_array as $key => $each_date_pair) {

            $query = 'CREATE OR REPLACE VIEW {{finance_ageing_' . $key . '}} AS SELECT
                            VI.ledger_id AS ledger_id,
                            VI.subledger_id AS subledger_id,
                            IFNULL(S.description, "No Subledger") AS subledger,
                            V.id AS voucher_id,
                            V.voucher_date AS voucher_date,
                            V.due_date AS due_date,
                            V.reference_no AS reference_no,
                            VI.narration AS narration,
                            VI.id AS voucher_item_id,
                            CONCAT(VT.code,"/",V.voucher_no) AS voucher_no,
                            ROUND((VI.amount*VI.exchange_rate), 4) AS total_amount,
                            IFNULL(ABS(ROUND( SUM(AI.amount), 4)), 0) AS allocated,
                            ROUND((VI.amount*VI.exchange_rate), 4) - IFNULL(ROUND( SUM(AI.amount), 4), 0) AS amount
                        FROM {{finance_voucher_items}} VI
                        LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                        LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        LEFT JOIN {{finance_voucher_type}} VT ON VT.id=V.voucher_type
                        WHERE V.voucher_date >= "'.$from_date.'" AND V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '" AND
                        V.is_posted="Y" AND VI.ledger_id = "' . (int) $ledger . '"
                        GROUP BY VI.id, VI.subledger_id';

            $selectQuery = 'SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM(0_30_receivable) AS 0_30_receivable,
                        SUM(0_30_unallocated) AS 0_30_unallocated,
                        SUM(31_60_receivable) AS 31_60_receivable,
                        SUM(31_60_unallocated) AS 31_60_unallocated,
                        SUM(61_90_receivable) AS 61_90_receivable,
                        SUM(61_90_unallocated) AS 61_90_unallocated,
                        SUM(91_120_receivable) AS 91_120_receivable,
                        SUM(91_120_unallocated) AS 91_120_unallocated,
                        SUM(greater_120_receivable) AS greater_120_receivable,
                        SUM(greater_120_unallocated) AS greater_120_unallocated
                    FROM ( SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 0_30_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_0_to_30}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 31_60_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_31_to_60}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 61_90_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_61_to_90}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 91_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_91_to_120}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS greater_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS greater_120_unallocated
                    FROM {{finance_ageing_greaterthan_120}} GROUP BY subledger_id ) AS A GROUP BY A.subledger_id ORDER BY A.subledger ASC';

            Yii::app()->db->createCommand($query)->execute();
        }

        $aging_report = Yii::app()->db->createCommand($selectQuery)->queryAll();

        $data = '<table class="table table-hover table-fixed table-bordered" id="tb_table">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Subledger</th>
                        <th>Type</th>
                        <th>0-30</th>
                        <th>31-60</th>
                        <th>61-90</th>
                        <th>91-120</th>
                        <th> > 120</th>
                        <th>Total</th>
                    </tr>
                </thead>
                <tbody>';
        $grand_total = 0;
        $one = 0;
        $two = 0;
        $three = 0;
        $four = 0;
        $five = 0;
        $labelOne = ($category == 'RECEIVABLE') ? 'Receivable' : 'Unallocated';
        $labelTwo = ($category == 'RECEIVABLE') ? 'Unallocated' : 'Payable';
        $z=0;
        foreach ($aging_report as $i => $each):
            $total_receivable = $each['0_30_receivable'] + $each['31_60_receivable'] + $each['61_90_receivable'] + $each['91_120_receivable'] + $each['greater_120_receivable'];
            $total_unallocated = $each['0_30_unallocated'] + $each['31_60_unallocated'] + $each['61_90_unallocated'] + $each['91_120_unallocated'] + $each['greater_120_unallocated'];

            $one_receivable += $each['0_30_receivable'];
            $two_receivable += $each['31_60_receivable'];
            $three_receivable += $each['61_90_receivable'];
            $four_receivable += $each['91_120_receivable'];
            $five_receivable += $each['greater_120_receivable'];
            $grand_total_receivable += $total_receivable;

            $one_unallocated += $each['0_30_unallocated'];
            $two_unallocated += $each['31_60_unallocated'];
            $three_unallocated += $each['61_90_unallocated'];
            $four_unallocated += $each['91_120_unallocated'];
            $five_unallocated += $each['greater_120_unallocated'];
            $grand_total_unallocated += $total_unallocated;

            if ($total_receivable > 0 || $total_unallocated > 0):
                $z++;
                $data .= '<tr>
																																									<td rowspan="2" >' . ($z) . '</td>
																																		                            <td rowspan="2" >' . $each['subledger'] . '</td>
																																		                            <td>' . $labelOne . '</td>
																																									<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['0_30_receivable'], " ") . '</td>
																																									<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['31_60_receivable'], " ") . '</td>
																																									<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['61_90_receivable'], " ") . '</td>
																																									<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['91_120_receivable'], " ") . '</td>
																																									<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['greater_120_receivable'], " ") . '</td>
																																									<td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($total_receivable, " ") . '</td>
																																						        </tr>';
                $data .= '<tr>
																																		                            <td>' . $labelTwo . '</td>
																																		                            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['0_30_unallocated'], " ") . '</td>
																																						            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['31_60_unallocated'], " ") . '</td>
																																						            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['61_90_unallocated'], " ") . '</td>
																																						            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['91_120_unallocated'], " ") . '</td>
																																						            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each['greater_120_unallocated'], " ") . '</td>
																																						            <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($total_unallocated, " ") . '</td>
																																						        </tr>';
            endif;
        endforeach;
        
         $fledger=new FinanceLegder();

        $data .= '<tr>
                        <td colspan="2" rowspan="2" class="text-right"><b>Total</b></td>
                        <td>' . $labelOne . '</td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($one_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($two_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($three_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($four_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($five_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($grand_total_receivable, " ") . " " . $fledger->baseCurrency() . '</b></td>
                    </tr>';

        $data .= '<tr>
                        <td>' . $labelTwo . '</td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($one_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($two_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($three_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($four_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($five_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                        <td class="text-right"><b>' . Yii::app()->numberFormatter->formatCurrency($grand_total_unallocated, " ") . " " . $fledger->baseCurrency() . '</b></td>
                    </tr>';
        $data .= ' </tbody>
            </table>';

        $param = array(
            'to_date' => $to_date,
            'ledger' => $ledger,
            'table' => $data,
            'head' => $category == 'RECEIVABLE' ? 'Receivable Aging Report' : 'Payable Aging Report',
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_aging_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("aging" . date("d-m-Y"), 'I');

    }

    public function actionAging_excel()
    {
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
        $ledger = (int) $_GET['ledger'];
        $brand = (int) $_GET['brand'];
        $category = ($_GET['category'] == 'RECEIVABLE') ? 'RECEIVABLE' : 'PAYABLE';

        $dates_array = array(
            '0_to_30' => array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date),
            '31_to_60' => array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days'))),
            '61_to_90' => array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days'))),
            '91_to_120' => array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days'))),
            'greaterthan_120' => array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days'))),
        );

        foreach ($dates_array as $key => $each_date_pair) {

            $query = 'CREATE OR REPLACE VIEW {{finance_ageing_' . $key . '}} AS SELECT
                            VI.ledger_id AS ledger_id,
                            VI.subledger_id AS subledger_id,
                            IFNULL(S.description, "No Subledger") AS subledger,
                            V.id AS voucher_id,
                            V.voucher_date AS voucher_date,
                            V.due_date AS due_date,
                            V.reference_no AS reference_no,
                            VI.narration AS narration,
                            VI.id AS voucher_item_id,
                            CONCAT(VT.code,"/",V.voucher_no) AS voucher_no,
                            ROUND((VI.amount*VI.exchange_rate), 4) AS total_amount,
                            IFNULL(ABS(ROUND( SUM(AI.amount), 4)), 0) AS allocated,
                            ROUND((VI.amount*VI.exchange_rate), 4) - IFNULL(ROUND( SUM(AI.amount), 4), 0) AS amount
                        FROM {{finance_voucher_items}} VI
                        LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                        LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                        LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                        LEFT JOIN {{finance_voucher_type}} VT ON VT.id=V.voucher_type
                        WHERE V.voucher_date >= "'.$from_date.'" AND V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '" AND
                        V.is_posted="Y" AND VI.ledger_id = "' . (int) $ledger . '"
                        GROUP BY VI.id, VI.subledger_id';

            $selectQuery = 'SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM(0_30_receivable) AS 0_30_receivable,
                        SUM(0_30_unallocated) AS 0_30_unallocated,
                        SUM(31_60_receivable) AS 31_60_receivable,
                        SUM(31_60_unallocated) AS 31_60_unallocated,
                        SUM(61_90_receivable) AS 61_90_receivable,
                        SUM(61_90_unallocated) AS 61_90_unallocated,
                        SUM(91_120_receivable) AS 91_120_receivable,
                        SUM(91_120_unallocated) AS 91_120_unallocated,
                        SUM(greater_120_receivable) AS greater_120_receivable,
                        SUM(greater_120_unallocated) AS greater_120_unallocated
                    FROM ( SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 0_30_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_0_to_30}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 31_60_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_31_to_60}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 61_90_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_61_to_90}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS 91_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS 91_120_unallocated,
                        0 AS greater_120_receivable,
                        0 AS greater_120_unallocated
                    FROM {{finance_ageing_91_to_120}} GROUP BY subledger_id
                    UNION
                    SELECT
                        ledger_id,
                        subledger_id,
                        subledger,
                        0 AS 0_30_receivable,
                        0 AS 0_30_unallocated,
                        0 AS 31_60_receivable,
                        0 AS 31_60_unallocated,
                        0 AS 61_90_receivable,
                        0 AS 61_90_unallocated,
                        0 AS 91_120_receivable,
                        0 AS 91_120_unallocated,
                        SUM( CASE WHEN amount > 0 THEN amount ELSE 0 END) AS greater_120_receivable,
                        SUM( CASE WHEN amount < 0 THEN ABS(amount) ELSE 0 END) AS greater_120_unallocated
                    FROM {{finance_ageing_greaterthan_120}} GROUP BY subledger_id ) AS A GROUP BY A.subledger_id ORDER BY A.subledger ASC';

            Yii::app()->db->createCommand($query)->execute();
        }

        $aging_report = Yii::app()->db->createCommand($selectQuery)->queryAll();

        // Create new PHPExcel object
        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Aging Report")
            ->setSubject("Aging Report")
            ->setDescription("Aging Report as on date" . $to_date)
            ->setKeywords("Aging Report")
            ->setCategory("Financial Report");

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(8)->setAutoSize(true);

        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', '#')
            ->setCellValue('B1', 'Subledger')
            ->setCellValue('C1', 'Type')
            ->setCellValue('D1', '0-30')
            ->setCellValue('E1', '31-60')
            ->setCellValue('F1', '61-90')
            ->setCellValue('G1', '91-120')
            ->setCellValue('H1', ' > 120')
            ->setCellValue('I1', 'Total');

        $excel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true)->setSize(14);
        $excel->getActiveSheet()->getStyle('A1:I1')->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));

        $grand_total = 0;
        $one = 0;
        $two = 0;
        $three = 0;
        $four = 0;
        $five = 0;
        $labelOne = ($category == 'RECEIVABLE') ? 'Receivable' : 'Unallocated';
        $labelTwo = ($category == 'RECEIVABLE') ? 'Unallocated' : 'Payable';
        $rowId = 2;
        $number = 1;
        foreach ($aging_report as $i => $each):
            $total_receivable = $each['0_30_receivable'] + $each['31_60_receivable'] + $each['61_90_receivable'] + $each['91_120_receivable'] + $each['greater_120_receivable'];
            $total_unallocated = $each['0_30_unallocated'] + $each['31_60_unallocated'] + $each['61_90_unallocated'] + $each['91_120_unallocated'] + $each['greater_120_unallocated'];

            $one_receivable += $each['0_30_receivable'];
            $two_receivable += $each['31_60_receivable'];
            $three_receivable += $each['61_90_receivable'];
            $four_receivable += $each['91_120_receivable'];
            $five_receivable += $each['greater_120_receivable'];
            $grand_total_receivable += $total_receivable;

            $one_unallocated += $each['0_30_unallocated'];
            $two_unallocated += $each['31_60_unallocated'];
            $three_unallocated += $each['61_90_unallocated'];
            $four_unallocated += $each['91_120_unallocated'];
            $five_unallocated += $each['greater_120_unallocated'];
            $grand_total_unallocated += $total_unallocated;

            if ($total_receivable > 0 || $total_unallocated > 0):

                $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, $number)
                    ->setCellValue('B' . $rowId, $each['subledger'])
                    ->setCellValue('C' . $rowId, $labelOne)
                    ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['0_30_receivable'], " "))
                    ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['31_60_receivable'], " "))
                    ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['61_90_receivable'], " "))
                    ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['91_120_receivable'], " "))
                    ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['greater_120_receivable'], " "))
                    ->setCellValue('I' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_receivable, " "));

                $rowId++;
                $excel->setActiveSheetIndex(0)->mergeCells('A' . ($rowId - 1) . ':A' . $rowId);
                $excel->setActiveSheetIndex(0)->mergeCells('B' . ($rowId - 1) . ':B' . $rowId);
                $excel->setActiveSheetIndex(0)
                    ->setCellValue('C' . $rowId, $labelTwo)
                    ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['0_30_unallocated'], " "))
                    ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['31_60_unallocated'], " "))
                    ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['61_90_unallocated'], " "))
                    ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['91_120_unallocated'], " "))
                    ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['greater_120_unallocated'], " "))
                    ->setCellValue('I' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_unallocated, " "));
                $rowId++;
                $number++;
            endif;
        endforeach;
         $fledger=new FinanceLegder();
        $excel->setActiveSheetIndex(0)
            ->setCellValue('B' . $rowId, 'Total')
            ->setCellValue('C' . $rowId, $labelOne)
            ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency($one_receivable, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($two_receivable, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($three_receivable, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($four_receivable, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency($five_receivable, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('I' . $rowId, Yii::app()->numberFormatter->formatCurrency($grand_total_receivable, " ") . " " . $fledger->baseCurrency());

        $rowId++;
        $excel->getActiveSheet()->getStyle('A' . ($rowId - 1) . ':I' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->getActiveSheet()->getStyle('A' . ($rowId - 1) . ':I' . $rowId)->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . ($rowId - 1) . ':A' . $rowId);
        $excel->setActiveSheetIndex(0)->mergeCells('B' . ($rowId - 1) . ':B' . $rowId);
        $excel->getActiveSheet(0)->getStyle('A1:I' . $rowId)->applyFromArray(array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        ));

        $excel->setActiveSheetIndex(0)
            ->setCellValue('C' . $rowId, $labelTwo)
            ->setCellValue('D' . $rowId, Yii::app()->numberFormatter->formatCurrency($one_unallocated, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($two_unallocated, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($three_unallocated, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($four_unallocated, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency($five_unallocated, " ") . " " . $fledger->baseCurrency())
            ->setCellValue('I' . $rowId, Yii::app()->numberFormatter->formatCurrency($grand_total_unallocated, " ") . " " . $fledger->baseCurrency());
        $rowId++;

        $excel->getActiveSheet()->getStyle('D2:I' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()->setTitle('Aging Report');

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="aging.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;

    }

    public function actionVat_report()
    {
        $this->render('vat_report');
    }

    public function actionVat_html()
    {
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $emirates_id=$_POST['emirates_id'];
        $type=$_POST['type'];
        $items = FinanceVoucherItems::model()->with('parent', 'ledger')->findAll(array('condition' => 'ledger.main_account_type="L" AND ledger.classification="VAT" AND parent.voucher_type NOT IN(7,8,9,10) AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"', 'order' => 'parent.voucher_date ASC'));
        $taxable_sales_amount=0;
        $sales_vat=0;
        $taxable_purchase_amount=0;
        $purchase_vat=0;
        function generateUrl($parentModel)
        {
            $url = '#';
            $code = $parentModel->vtype->code;
            if ($code == 'SI') {
                $headModel = $parentModel->vtype->header_table;
                $vat_field = $parentModel->vtype->vat_value;
                $tax = $headModel::model()->findBypk($parentModel->header_table_id)->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $parentModel->header_table_id . "&frm=" . $taxType . "', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $parentModel->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $parentModel->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $parentModel->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $parentModel->id . "', '_blank');";
            }
            return $url;
        }
        function SalesUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $id . "&frm=" . $taxType . "', '_blank');";
            return $url;
        }
        function CreditnoteUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $id . "&frm=" . $taxType . "', '_blank');";
            return $url;
        }
        function PurchaseUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $id . "', '_blank');";
            return $url;
        }
        function DebitnoteUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $id . "', '_blank');";
            return $url;
        }

        function getSymbol($value, $reverse)
        {
            if (!$reverse) {
                $result = ($value <= 0) ? '' : '(-)';
            } else {
                $result = ($value < 0) ? '(-)' : '';
            }

            return $result;
        }

        function getVendor($code, $header_id)
        {
            return $code == 'PI' || $code == 'DN' ? FinanceVoucherItems::model()->find(array('condition' => 'ledger_id=' . FinanceSystemAccountsMapping::getSystemdefault('creditors') . ' AND header_id=' . $header_id))->subledger->description : 'N/A';
        }
 $fledger=new FinanceLegder();
        $table = '<br><table class="table table-hover table-fixed table-bordered" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th colspan="6">VAT on Sales (Outwards)</th>
                        </tr>
                        <tr>
                            <th style="width:5%">No.</th>
                            <th style="width:5%">Date</th>
                            <th style="width:8%">Invoice No</th>
                            <th style="width:20%">Customer</th>
                            <th style="width:15%">Taxable Amount</th>
                            <th style="width:15%">VAT (' . $fledger->baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>';

        $total_amount = 0;
        $total_vat = 0;
        $condition='1=1';
        $condition1='1=1';
        if($emirates_id>0)
        {
        $condition.=" AND C.customer_emirates_name=".$emirates_id;    
        }
        if($type==1)
        {
        $condition.=" AND IT.tax_vat_amount>0";    
        $condition1.=" AND IT.tax_amount>0";   
        }
        else {
        $condition.=" AND IT.tax_vat_amount=0";  
        $condition1.=" AND IT.tax_amount=0";           
        }
        $sales=Yii::app()->db->createCommand("select I.invoice_date,I.id,C.customer_name,SUM(IT.net_amount) AS net,SUM(tax_vat_amount) AS tax from erp_invoice I INNER JOIN erp_invoice_item IT ON I.id=IT.invoice_id INNER JOIN erp_customer C ON C.id=I.customer_id where $condition AND I.invoice_date>='".$from_date."' AND I.invoice_date<='".$to_date."' group by I.id order by I.invoice_date,I.id")->queryAll();
        $i=0;
        foreach ($sales as $each) {
            $table .= '<tr>
                                            <td>' . ($i+1) . '</td>
                                            <td>' . date("d/m/Y", strtotime($each['invoice_date'])) . '</td>
                                            <td><a href="#" onclick="' . SalesUrl($each['id']) . '">' . $each['id'] . '</a></td>
                                            <td><small>' . $each['customer_name'] . '</small></td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['net'], " ") . '</td>
                                            <td style="text-align:right !important;">' .  Yii::app()->numberFormatter->formatCurrency($each['tax'], " ") . '</td> 
                                        </tr>';
            $i++;
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
                $table .= '<tr>
                                    <td colspan="4" style="text-align:right !important;"><b>Total VAT (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_amount, " ") . '</b></td>
                                    <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($total_vat, " ") . '</b></td>
                                </tr>';
                $taxable_sales_amount+=$total_amount;
                $sales_vat+=$total_vat;
                $total_amount=$total_vat=0;
        $table.='<tr><th colspan="6">Credit note(Inwards)</th></tr>';
        $table.='<tr>
                            <th style="width:5%">No.</th>
                            <th style="width:5%">Date</th>
                            <th style="width:8%">Credit note No</th>
                            <th style="width:20%">Customer</th>
                            <th style="width:15%">Taxable Amount</th>
                            <th style="width:15%">VAT (' . $fledger->baseCurrency() . ')</th>
                        </tr>';
        $sales_return=Yii::app()->db->createCommand("select I.credited_date,I.id,C.customer_name,SUM(IT.net_amount) AS net,SUM(tax_vat_amount) AS tax from erp_creditnote I INNER JOIN erp_creditnote_item IT ON I.id=IT.creditnote_id INNER JOIN erp_customer C ON C.id=I.customer_id where $condition AND I.credited_date>='".$from_date."' AND I.credited_date<='".$to_date."' group by I.id order by I.credited_date,I.id")->queryAll();
        $total_amount=$total_vat=0;
        $i=0;
        foreach ($sales_return as $each) {
        if($each['net']>0)
        {
        $table .= '<tr>
                                            <td>' . ($i+1) . '</td>
                                            <td>' . date("d/m/Y", strtotime($each['credited_date'])) . '</td>
                                            <td><a href="#" onclick="' . CreditnoteUrl($each['id']) . '">' . $each['id'] . '</a></td>
                                            <td><small>' . $each['customer_name'] . '</small></td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['net'], " ") . '</td>
                                            <td style="text-align:right !important;">' .  Yii::app()->numberFormatter->formatCurrency($each['tax'], " ") . '</td> 
                                        </tr>';
            $i++;
        }
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
        $table .= '<tr>
                                    <td colspan="4" style="text-align:right !important;"><b>Total VAT (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_amount, " ") . '</b></td>
                                    <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($total_vat, " ") . '</b></td>
                                </tr></table>';
                $taxable_sales_amount-=$total_amount;
                $sales_vat-=$total_vat;
                $total_amount=$total_vat=0;
        if( (int)$emirates_id==0)
        {
        $table.='<br><table class="table table-hover table-fixed table-bordered" style="font-size:13px;"><tr><th colspan="6">Purchase (Inwards)</th></tr>';
        $table.='<tr>
                            <th style="width:5%">No.</th>
                            <th style="width:5%">Date</th>
                            <th style="width:8%">Purchase Invoice No</th>
                            <th style="width:20%">Vendor</th>
                            <th style="width:15%">Taxable Amount</th>
                            <th style="width:15%">VAT (' . $fledger->baseCurrency() . ')</th>
                        </tr>';
        $purchase=Yii::app()->db->createCommand("select I.invoice_date,I.id,C.vendor_name,SUM(IT.net_amount) AS net,SUM(tax_amount) AS tax from erp_purchasinginvoice I INNER JOIN erp_purchasinginvoice_item IT ON I.id=IT.purchasing_invoice_id INNER JOIN erp_vendor C ON C.id=I.vendor_id where $condition1 AND I.invoice_date>='".$from_date."' AND I.invoice_date<='".$to_date."' group by I.id order by I.invoice_date,I.id")->queryAll();
        $total_amount=$total_vat=0;
        $i=0;
        foreach ($purchase as $each) {
        $table .= '<tr>
                                            <td>' . ($i+1) . '</td>
                                            <td>' . date("d/m/Y", strtotime($each['invoice_date'])) . '</td>
                                            <td><a href="#" onclick="' . PurchaseUrl($each['id']) . '">' . $each['id'] . '</a></td>
                                            <td><small>' . $each['vendor_name'] . '</small></td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['net'], " ") . '</td>
                                            <td style="text-align:right !important;">' .  Yii::app()->numberFormatter->formatCurrency($each['tax'], " ") . '</td> 
                                        </tr>';
            $i++;
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
        $table .= '<tr>
                                    <td colspan="4" style="text-align:right !important;"><b>Total VAT (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_amount, " ") . '</b></td>
                                    <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($total_vat, " ") . '</b></td>
                                </tr></table>';
        
                $taxable_purchase_amount+=$total_amount;
                $purchase_vat+=$total_vat;
                $table.='<br><table class="table table-hover table-fixed table-bordered" style="font-size:13px;"><tr><th colspan="6">Debit note (Outwards)</th></tr>';
        $table.='<tr>
                            <th style="width:5%">No.</th>
                            <th style="width:5%">Date</th>
                            <th style="width:8%">Debit note No</th>
                            <th style="width:20%">Vendor</th>
                            <th style="width:15%">Taxable Amount</th>
                            <th style="width:15%">VAT (' . $fledger->baseCurrency() . ')</th>
                        </tr>';
        $purchase=Yii::app()->db->createCommand("select I.debited_date,I.id,C.vendor_name,SUM(IT.net_amount) AS net,SUM(tax_vat_amount) AS tax from erp_purchasing_debit_note I INNER JOIN erp_purchasing_debit_note_item IT ON I.id=IT.purchasing_debitnote_id INNER JOIN erp_vendor C ON C.id=I.vendor_id where $condition AND I.debited_date>='".$from_date."' AND I.debited_date<='".$to_date."' group by I.id order by I.debited_date,I.id")->queryAll();
        $total_amount=$total_vat=0;
        $i=0;
        foreach ($purchase as $each) {
        $table .= '<tr>
                                            <td>' . ($i+1) . '</td>
                                            <td>' . date("d/m/Y", strtotime($each['debited_date'])) . '</td>
                                            <td><a href="#" onclick="' . DebitnoteUrl($each['id']) . '">' . $each['id'] . '</a></td>
                                            <td><small>' . $each['vendor_name'] . '</small></td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['net'], " ") . '</td>
                                            <td style="text-align:right !important;">' .  Yii::app()->numberFormatter->formatCurrency($each['tax'], " ") . '</td> 
                                        </tr>';
            $i++;
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
        
                $taxable_purchase_amount-=$total_amount;
                $purchase_vat-=$total_vat;
        $table .= '<tr>
                                    <td colspan="4" style="text-align:right !important;"><b>Total VAT (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_amount, " ") . '</b></td>
                                    <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($total_vat, " ") . '</b></td>
                                </tr></table>';
        $total_amount=$total_vat=0;
        }
        if($type==1 && (int)$emirates_id==0)
        {   
        
       $table.='<br><table class="table table-hover table-fixed table-bordered" style="font-size:13px;"><tr><th colspan="7">Income (Outwards)</th></tr>';
        $table.='<tr>
                            <th style="width:5%">No.</th>
                            <th style="width:5%">Date</th>
                            <th style="width:8%">Voucher No</th>
                            <th style="width:8%">Reference</th>
                            <th style="width:8%">Narration</th>
                            <th style="width:15%">Taxable Amount</th>
                            <th style="width:15%">VAT (' . $fledger->baseCurrency() . ')</th>
                        </tr>';
        foreach ($items as $i=>$each) {
            
           $vat = 1*round(($each->amount * $each->exchange_rate), 4);
//            $total = $each->get_sales_value();
            $total = round($vat / 0.05, 4);
            $table .= '<tr>
                <td>' .($i+1) . '</td>
                                            <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                            <td><a href="#" onclick="' . generateUrl($each->parent) . '">' . $each->parent->fullvoucher . '</a></td>
                                            <td>' . $each->parent->reference_no . '</td>
                                            <td>' . $each->narration . '</td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '</td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($vat, " ") . '</td>
                                        </tr>';

           $total_amount += $total;
            $total_vat += $vat;
        }

        $table .= '<tr>
                                    <td colspan="5" style="text-align:right !important;"><b>Total VAT (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_amount, " ") . '</b></td>
                                    <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($total_vat, " ") . '</b></td>
                                </tr>';
        $table .= '</tbody>
                        <table>';

                $taxable_sales_amount+=$total_amount;
                $sales_vat+=$total_vat;
        $query = 'SELECT
                        VH.voucher_date,
                        VH.id AS voucher_id,
                        T.code AS voucher_code,
                        CONCAT(T.code,"/", VH.voucher_no) AS voucher_no,
                        VH.reference_no AS reference_no,
                        GROUP_CONCAT(DISTINCT VI.narration SEPARATOR "\n") AS narration,
                        COUNT(VI.id) AS count_of_items,
                        VI.id AS voucher_item_id,
                        ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS vat_amount
                        FROM {{finance_voucher_items}} VI
                        LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                        LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
                        LEFT JOIN {{finance_voucher_type}} T ON T.id = VH.voucher_type
                        WHERE L.main_account_type="A" AND L.classification="VAT" AND VH.voucher_type NOT IN(7,8,9,10) AND VH.is_posted = "Y" AND VH.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"
                        GROUP BY VH.id
                        ORDER BY VH.voucher_date ASC';
        $items = Yii::app()->db->createCommand($query)->queryAll();
        $table .= '<br><table class="table table-hover table-fixed table-bordered" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th colspan="7">VAT on Purchases/Expenses (Inwards)</th>
                        </tr>
                        <tr>
                            <th style="width:5%">No.</th>
                            <th style="width:5%">Date</th>
                            <th style="width:8%">Voucher No</th>
                            <th style="width:8%">Voucher Ref</th>
                            <th style="width:20%">Narration</th>
                            <th style="width:15%">Voucher Amount</th>
                            <th style="width:15%">VAT (' . $fledger->baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>';

        $total_amount_expense = 0;
        $total_vat_expense = 0;
        $total_amount=$total_vat=0;
        foreach ($items as $i=>$each) {
            $model = FinanceVoucherHead::model()->findBypk($each['voucher_id']);
            $vat = $each['vat_amount'];
            // $total = $model->debit_total;
            $total = round($each['vat_amount'] / 0.05, 4);
            $table .= '<tr>
                                            <td>' . ($i+1) . '</td>
                                            <td>' . date("d/m/Y", strtotime($model->voucher_date)) . '</td>
                                            <td><a href="#" onclick="' . generateUrl($model) . '">' . $model->fullvoucher . '</a></td>
                                            <td>' . $model->reference_no . '</td>
                                            <td><small>' . $each['narration'] . '</small></td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '</td>
                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($vat, " ") . '</td>
                                        </tr>';

            $total_amount_expense += $total;
            $total_vat_expense += $vat;
        }

        $table .= '<tr>
                                    <td colspan="5" style="text-align:right !important;"><b>Total VAT (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_amount_expense, " ") . '</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total_vat_expense, " ") . '</b></td>
                                </tr></table>';
        }
        
                $taxable_purchase_amount+=$total_amount_expense;
                $purchase_vat+=$total_vat_expense;
        $payable = $total_vat + $total_vat_expense;
        
        $table .= '<table class="table table-hover table-fixed table-bordered" style="font-size:13px;"><tr>
                                    <td colspan="6" style="text-align:right !important;"><b> Total Taxable Amount (Outward) (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($taxable_sales_amount, " ") . '</b></td>
                                </tr>';
        
       $table .= '<tr>
                                    <td colspan="6" style="text-align:right !important;"><b> Total VAT (Outward) (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($sales_vat, " ") . '</b></td>
                                </tr>';
        
        $table .= '<tr>
                                    <td colspan="6" style="text-align:right !important;"><b> Total Taxable Amount (Inward) (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($taxable_purchase_amount, " ") . '</b></td>
                                </tr>';
        
       $table .= '<tr>
                                    <td colspan="6" style="text-align:right !important;"><b> Total VAT (Inward) (' . $fledger->baseCurrency() . ')</b></td>
                                    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($purchase_vat, " ") . '</b></td>
                                </tr>';
       
//        $table .= '<tr>
//                                    <td colspan="5" style="text-align:right !important;"><b> VAT Payable(' . $fledger->baseCurrency() . ')</b></td>
//                                    <td style="text-align:right !important;"><b>' . getSymbol($payable, false) . Yii::app()->numberFormatter->formatCurrency(abs($payable), " ") . '</b></td>
//                                </tr>';
        $table .= '</tbody>
                        <table>';
        echo $table;
    }

    public function actionVat_pdf_extras()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('vat_filter', array('from_date' => $_GET['from_date'], 'to_date' => $_GET['to_date'], 'brand' => (int) $_GET['brand']));
    }

    public function actionVat_pdf()
    {
        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $due_date = Yii::app()->request->getParam('due_date');
        $tax_year_end = Yii::app()->request->getParam('tax_year_end');
        $submission_date = Yii::app()->request->getParam('submission_date');
        $name = Yii::app()->request->getParam('name');
        $phone = Yii::app()->request->getParam('phone');
        $email = Yii::app()->request->getParam('email');
        $brand = Yii::app()->request->getParam('brand');

        $from_date = (count(explode('/', $from_date)) == 3) ? $from_date : date('01/m/Y');
        $to_date = (count(explode('/', $to_date)) == 3) ? $to_date : date('t/m/Y');

        // ALTER TABLE `crm_mas_emirates_list` ADD `have_vat` ENUM('N','Y') NOT NULL DEFAULT 'N' AFTER `isDefault`;

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'due_date' => $due_date,
            'tax_year_end' => $tax_year_end,
            'submission_date' => $submission_date,
            'name' => $name,
            'phone' => $phone,
            'email' => $email,
            'brand' => $brand,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_vat_201_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("vat_report" . date("d-m-Y"), 'I');
    }

    public function actionVat_excel()
    {
        $from_date = (count(explode('/', $_REQUEST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-d');
        $from=$from_date;
        $to=$to_date;
        $emirates_id=$_REQUEST['emirates_id'];
        $type=$_REQUEST['type'];
        $items = FinanceVoucherItems::model()->with('parent', 'ledger')->findAll(array('condition' => 'ledger.main_account_type="L" AND ledger.classification="VAT" AND parent.voucher_type NOT IN(7,8,9,10) AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"', 'order' => 'parent.voucher_date ASC'));
        $taxable_sales_amount=0;
        $sales_vat=0;
        $taxable_purchase_amount=0;
        $purchase_vat=0;
        function generateUrl($parentModel)
        {
            $url = '#';
            $code = $parentModel->vtype->code;
            if ($code == 'SI') {
                $headModel = $parentModel->vtype->header_table;
                $vat_field = $parentModel->vtype->vat_value;
                $tax = $headModel::model()->findBypk($parentModel->header_table_id)->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $parentModel->header_table_id . "&frm=" . $taxType . "', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $parentModel->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $parentModel->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $parentModel->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $parentModel->id . "', '_blank');";
            }
            return $url;
        }
        function SalesUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $id . "&frm=" . $taxType . "', '_blank');";
            return $url;
        }
        function CreditnoteUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $id . "&frm=" . $taxType . "', '_blank');";
            return $url;
        }
        function PurchaseUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $id . "', '_blank');";
            return $url;
        }
        function DebitnoteUrl($id)
        {
            $taxType = 'tax';
            $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $id . "', '_blank');";
            return $url;
        }

        function getSymbol($value, $reverse)
        {
            if (!$reverse) {
                $result = ($value <= 0) ? '' : '(-)';
            } else {
                $result = ($value < 0) ? '(-)' : '';
            }

            return $result;
        }

        function getVendor($code, $header_id)
        {
            return $code == 'PI' || $code == 'DN' ? FinanceVoucherItems::model()->find(array('condition' => 'ledger_id=' . FinanceSystemAccountsMapping::getSystemdefault('creditors') . ' AND header_id=' . $header_id))->subledger->description : 'N/A';
        }

        // Create new PHPExcel object
        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("VAT Report")
            ->setSubject("VAT Report")
            ->setDescription("VAT Report")
            ->setKeywords("VAT Report")
            ->setCategory("Financial Report");

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);

        $excel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(14);
        $excel->getActiveSheet()->getStyle('A1:F1')->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);

        $excel->setActiveSheetIndex(0)->mergeCells('A1:F1');
        $excel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'VAT on Sales (Outwards)'.date("d/m/Y",strtotime($to)));
             $fledger=new FinanceLegder();
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A2', 'No')
            ->setCellValue('B2', 'Date')
            ->setCellValue('C2', 'Voucher No')
            ->setCellValue('D2', 'Customer')
            ->setCellValue('E2', 'Taxable Amount')
            ->setCellValue('F2', 'VAT (' . $fledger->baseCurrency() . ')');

        $total_amount = 0;
        $total_vat = 0;
        $rowId = 3;
        $total_amount = 0;
        $total_vat = 0;
        $condition='1=1';
        $condition1='1=1';
        if($emirates_id>0)
        {
        $condition.=" AND C.customer_emirates_name=".$emirates_id;    
        }
        if($type==1)
        {
        $condition.=" AND IT.tax_vat_amount>0";    
        $condition1.=" AND IT.tax_amount>0";   
        }
        else {
        $condition.=" AND IT.tax_vat_amount=0";  
        $condition1.=" AND IT.tax_amount=0";           
        }
        $sales=Yii::app()->db->createCommand("select I.invoice_date,I.id,C.customer_name,SUM(IT.net_amount) AS net,SUM(tax_vat_amount) AS tax from erp_invoice I INNER JOIN erp_invoice_item IT ON I.id=IT.invoice_id INNER JOIN erp_customer C ON C.id=I.customer_id where $condition AND I.invoice_date>='".$from_date."' AND I.invoice_date<='".$to_date."' group by I.id order by I.invoice_date,I.id")->queryAll();
        $i=0;
        foreach ($sales as $i=>$each) {
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(false);    
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, ($i+1))
            ->setCellValue('B' . $rowId, date("d/m/Y", strtotime($each['invoice_date'])))
            ->setCellValue('C' . $rowId, $each['id'])
            ->setCellValue('D' . $rowId, $each['customer_name'])
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['net'], " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['tax'], " "));
            $rowId++;
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);
            $excel->setActiveSheetIndex(0)
            ->setCellValue('D' . $rowId, 'Total VAT (' . $fledger->baseCurrency().')')
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_amount, " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_vat, " "));
            $rowId++;
                $taxable_sales_amount+=$total_amount;
                $sales_vat+=$total_vat;
                $total_amount=$total_vat=0;
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId.':F' . $rowId);
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A'.$rowId, 'VAT on Sales (Outwards)'.date("d/m/Y",strtotime($to)));
        $rowId++;
        
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'No')
            ->setCellValue('B' . $rowId, 'Date')
            ->setCellValue('C' . $rowId, 'Voucher No')
            ->setCellValue('D' . $rowId, 'Customer')
            ->setCellValue('E' . $rowId, 'Taxable Amount')
            ->setCellValue('F' . $rowId, 'VAT (' . $fledger->baseCurrency() . ')');
            $rowId++;
            
        $sales_return=Yii::app()->db->createCommand("select I.credited_date,I.id,C.customer_name,SUM(IT.net_amount) AS net,SUM(tax_vat_amount) AS tax from erp_creditnote I INNER JOIN erp_creditnote_item IT ON I.id=IT.creditnote_id INNER JOIN erp_customer C ON C.id=I.customer_id where $condition AND I.credited_date>='".$from_date."' AND I.credited_date<='".$to_date."' group by I.id order by I.credited_date,I.id")->queryAll();
        $total_amount=$total_vat=0;
        $i=0;
        foreach ($sales_return as $each) {
        if($each['net']>0)
        {
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(false);  
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, ($i+1))
            ->setCellValue('B' . $rowId, date("d/m/Y", strtotime($each['credited_date'])))
            ->setCellValue('C' . $rowId, $each['id'])
            ->setCellValue('D' . $rowId, $each['customer_name'])
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['net'], " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['tax'], " "));
            $rowId++;
        }
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('D' . $rowId, 'Total VAT (' . $fledger->baseCurrency().')')
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_amount, " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_vat, " "));
            $rowId++;
                $taxable_sales_amount-=$total_amount;
                $sales_vat-=$total_vat;
                $total_amount=$total_vat=0;
        if( (int)$emirates_id==0)
        {
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId.':F' . $rowId);
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A'.$rowId, 'Purchase (Inwards)'.date("d/m/Y",strtotime($to)));
        $rowId++;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'No')
            ->setCellValue('B' . $rowId, 'Date')
            ->setCellValue('C' . $rowId, 'Purchase Invoice No')
            ->setCellValue('D' . $rowId, 'Vendor')
            ->setCellValue('E' . $rowId, 'Taxable Amount')
            ->setCellValue('F' . $rowId, 'VAT (' . $fledger->baseCurrency() . ')');
            $rowId++;
            
        $purchase=Yii::app()->db->createCommand("select I.invoice_date,I.id,C.vendor_name,SUM(IT.net_amount) AS net,SUM(tax_amount) AS tax from erp_purchasinginvoice I INNER JOIN erp_purchasinginvoice_item IT ON I.id=IT.purchasing_invoice_id INNER JOIN erp_vendor C ON C.id=I.vendor_id where $condition1 AND I.invoice_date>='".$from_date."' AND I.invoice_date<='".$to_date."' group by I.id order by I.invoice_date,I.id")->queryAll();
        $total_amount=$total_vat=0;
        $i=0;
        foreach ($purchase as $each) {
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(false);  
        
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, ($i+1))
            ->setCellValue('B' . $rowId, date("d/m/Y", strtotime($each['invoice_date'])))
            ->setCellValue('C' . $rowId, $each['id'])
            ->setCellValue('D' . $rowId, $each['vendor_name'])
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['net'], " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['tax'], " "));
            $rowId++;
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('D' . $rowId, 'Total VAT (' . $fledger->baseCurrency().')')
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_amount, " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_vat, " "));
            $rowId++;
        
                $taxable_purchase_amount+=$total_amount;
                $purchase_vat+=$total_vat;
        
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId.':F' . $rowId);
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A'.$rowId, 'Debit note (Outwards)'.date("d/m/Y",strtotime($to)));
        $rowId++;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'No')
            ->setCellValue('B' . $rowId, 'Date')
            ->setCellValue('C' . $rowId, 'Debit note No')
            ->setCellValue('D' . $rowId, 'Vendor')
            ->setCellValue('E' . $rowId, 'Taxable Amount')
            ->setCellValue('F' . $rowId, 'VAT (' . $fledger->baseCurrency() . ')');
            $rowId++;
            
        $purchase=Yii::app()->db->createCommand("select I.debited_date,I.id,C.vendor_name,SUM(IT.net_amount) AS net,SUM(tax_vat_amount) AS tax from erp_purchasing_debit_note I INNER JOIN erp_purchasing_debit_note_item IT ON I.id=IT.purchasing_debitnote_id INNER JOIN erp_vendor C ON C.id=I.vendor_id where $condition AND I.debited_date>='".$from_date."' AND I.debited_date<='".$to_date."' group by I.id order by I.debited_date,I.id")->queryAll();
        $total_amount=$total_vat=0;
        $i=0;
        foreach ($purchase as $each) {
            
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(false);  
        
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, ($i+1))
            ->setCellValue('B' . $rowId, date("d/m/Y", strtotime($each['debited_date'])))
            ->setCellValue('C' . $rowId, $each['id'])
            ->setCellValue('D' . $rowId, $each['vendor_name'])
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['net'], " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($each['tax'], " "));
            $rowId++;
            $i++;
            $total_amount += $each['net'];
            $total_vat += $each['tax'];
        }
        
                $taxable_purchase_amount-=$total_amount;
                $purchase_vat-=$total_vat;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':F' . $rowId)->getFont()->setBold(true);        
        $excel->setActiveSheetIndex(0)
            ->setCellValue('D' . $rowId, 'Total VAT (' . $fledger->baseCurrency().')')
            ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_amount, " "))
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_vat, " "));
            $rowId++;
            
        $total_amount=$total_vat=0;
        }
        if($type==1 && (int)$emirates_id==0)
        {   
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId.':G' . $rowId);
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A'.$rowId, 'Income (Outwards)'.date("d/m/Y",strtotime($to)));
        $rowId++;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'No')
            ->setCellValue('B' . $rowId, 'Date')
            ->setCellValue('C' . $rowId, 'Voucher No')
            ->setCellValue('D' . $rowId, 'Reference')
            ->setCellValue('E' . $rowId, 'Narration')
            ->setCellValue('F' . $rowId, 'Taxable Amount')
            ->setCellValue('G' . $rowId, 'VAT (' . $fledger->baseCurrency() . ')');
            $rowId++;
            

        foreach ($items as $i=>$each) {
            
           $vat = 1*round(($each->amount * $each->exchange_rate), 4);
//            $total = $each->get_sales_value();
            $total = round($vat / 0.05, 4);
            
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(false);  
        
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, ($i+1))
            ->setCellValue('B' . $rowId, date("d/m/Y", strtotime($each->parent->voucher_date)))
            ->setCellValue('C' . $rowId, $each->parent->fullvoucher)
            ->setCellValue('D' . $rowId, $each->parent->reference_no)
            ->setCellValue('E' . $rowId, $each->narration)
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total, " "))
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($vat, " "));
            $rowId++;
           
           $total_amount += $total;
            $total_vat += $vat;
        }
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('E' . $rowId, 'Total VAT (' . $fledger->baseCurrency().')')
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_amount, " "))
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_vat, " "));
            $rowId++;

                $taxable_sales_amount+=$total_amount;
                $sales_vat+=$total_vat;
        $query = 'SELECT
                        VH.voucher_date,
                        VH.id AS voucher_id,
                        T.code AS voucher_code,
                        CONCAT(T.code,"/", VH.voucher_no) AS voucher_no,
                        VH.reference_no AS reference_no,
                        GROUP_CONCAT(DISTINCT VI.narration SEPARATOR "\n") AS narration,
                        COUNT(VI.id) AS count_of_items,
                        VI.id AS voucher_item_id,
                        ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS vat_amount
                        FROM {{finance_voucher_items}} VI
                        LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                        LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
                        LEFT JOIN {{finance_voucher_type}} T ON T.id = VH.voucher_type
                        WHERE L.main_account_type="A" AND L.classification="VAT" AND VH.voucher_type NOT IN(7,8,9,10) AND VH.is_posted = "Y" AND VH.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"
                        GROUP BY VH.id
                        ORDER BY VH.voucher_date ASC';
        $items = Yii::app()->db->createCommand($query)->queryAll();
        
                $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId.':G' . $rowId);
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A'.$rowId, 'VAT on Purchases/Expenses (Inwards)'.date("d/m/Y",strtotime($to)));
        $rowId++;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'No')
            ->setCellValue('B' . $rowId, 'Date')
            ->setCellValue('C' . $rowId, 'Voucher No')
            ->setCellValue('D' . $rowId, 'Reference')
            ->setCellValue('E' . $rowId, 'Narration')
            ->setCellValue('F' . $rowId, 'Voucher Amount')
            ->setCellValue('G' . $rowId, 'VAT (' . $fledger->baseCurrency() . ')');
            $rowId++;
            

        $total_amount_expense = 0;
        $total_vat_expense = 0;
        $total_amount=$total_vat=0;
        foreach ($items as $i=>$each) {
            $model = FinanceVoucherHead::model()->findBypk($each['voucher_id']);
            $vat = $each['vat_amount'];
            // $total = $model->debit_total;
            $total = round($each['vat_amount'] / 0.05, 4);
            
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(false);  
        
            $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, ($i+1))
            ->setCellValue('B' . $rowId, date("d/m/Y", strtotime($each['voucher_date'])))
            ->setCellValue('C' . $rowId, $each['voucher_no'])
            ->setCellValue('D' . $rowId, $each['reference_no'])
            ->setCellValue('E' . $rowId, $each['narration'])
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total, " "))
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($vat, " "));
            $rowId++;
            
            $total_amount_expense += $total;
            $total_vat_expense += $vat;
        }
$excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('E' . $rowId, 'Total VAT (' . $fledger->baseCurrency().')')
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_amount_expense, " "))
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($total_vat_expense, " "));
            $rowId++;
        }
        
                $taxable_purchase_amount+=$total_amount_expense;
                $purchase_vat+=$total_vat_expense;
        $payable = $total_vat + $total_vat_expense;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('F' . $rowId, ' Total Taxable Amount (Outward) (' . $fledger->baseCurrency().')')
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($taxable_sales_amount, " "));
            $rowId++;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);            
        $excel->setActiveSheetIndex(0)
            ->setCellValue('F' . $rowId, 'Total VAT (Outward)(' . $fledger->baseCurrency().')')
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($sales_vat, " "));
            $rowId++;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('F' . $rowId, ' Total Taxable Amount (Inward) (' . $fledger->baseCurrency().')')
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($taxable_purchase_amount, " "));
            $rowId++;
        $excel->getActiveSheet()->getStyle('A' . $rowId.':G' . $rowId)->getFont()->setBold(true);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('F' . $rowId, ' Total VAT (Inward) (' .$fledger->baseCurrency().')')
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($purchase_vat, " "));
            $rowId++;
       
        // Rename worksheet
        $excel->getActiveSheet()->setTitle('VAT Report');

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="vat_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionStatement_report()
    {
        $legder_Array = array('customer' => FinanceSystemAccountsMapping::getSystemdefault('debtors'), 'vendor' => FinanceSystemAccountsMapping::getSystemdefault('creditors'), 'bank' => FinanceSystemAccountsMapping::getSystemdefault('creditors'));
        $this->render('statement_report', array('type' => $_GET['type'], 'ledger_id' => (int) $legder_Array[$_GET['type']]));
    }
    
    public function actionStatement_report_new()
    {
        $legder_Array = array('customer' => FinanceSystemAccountsMapping::getSystemdefault('debtors'), 'vendor' => FinanceSystemAccountsMapping::getSystemdefault('creditors'), 'bank' => FinanceSystemAccountsMapping::getSystemdefault('creditors'));
        $this->render('statement_report_new', array('type' => $_GET['type'], 'ledger_id' => (int) $legder_Array[$_GET['type']]));
    }

    public function actionReconciliation_report()
    {
        $this->render('reconciliation_report');
    }

    public function actionStatement_html()
    {
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger_id = (int) $_POST['subledger_id'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=1;
        $currency_code=$cur->currency_code;
        $amountType = 'VI.amount < 0';
        $paidType = 'VI.amount > 0';
        if ($_POST['type'] == 'customer') {
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $items = array();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Paid</th>
                            <th style="width:10%">Balance</th>
                        </tr>
                    </thead>
                    <tbody>';
//    $opening='SELECT ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS balance FROM {{finance_voucher_items}} VI
//    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
//    WHERE V.is_posted ="Y" AND is_allocated="N" AND  ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id;
//    $opening_bal = Yii::app()->db->createCommand($opening)->queryScalar();
    // $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS SELECT
    //                 V.id AS voucher_id,
    //                 V.voucher_date AS voucher_date,
    //                 V.due_date AS due_date,
    //                 V.reference_no AS reference_no,
    //                 VI.narration AS narration,
    //                 VI.id AS voucher_item_id,
    //                 V.voucher_no,
    //                 ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    //                 ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    //                 ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
    //             FROM {{finance_voucher_items}} VI
    //             LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
    //             LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
    //             WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from_date.'" AND V.voucher_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
    //             GROUP BY VI.id';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS (SELECT
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
GROUP BY VI.id)
UNION
(SELECT
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from_date.'" AND V.voucher_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
GROUP BY VI.id)';
        if ($ledger_id > 0 && $subledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement}} order by voucher_date')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $table .= '<tr>
                            <td colspan="3">Opening Balance</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency((0/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " ") . '</td>
                        </tr>';
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            foreach ($items as $each) {
                if(round($each['balance'],2)!=0)
                {
                if ($_POST['type'] == 'customer') {
                $vouchreformat = '<a href="#" onclick="' . generateUrl(FinanceVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $each['voucher_no'] . '</a>';
                }
                else {
                $head=FinanceVoucherHead::model()->findByPk($each['voucher_id']);
                if($head->voucher_type==8)
                {
                $ref=PurchasingInvoice::model()->findByPk($head->voucher_no)->invoice_no;    
                }
                else {
                $ref=$each['reference_no'];    
                }
                if(empty($ref))
                {
                $ref=$head->voucher_no;    
                }
                $vouchreformat = '<a href="#" onclick="' . generateUrl(FinanceVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $ref . '</a>';
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $vouchreformat . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($each['amount']/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($each['allocated']/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($each['balance']/$exchange_rate), " ") . '</td>
                        </tr>';
                        $amount+=$each['amount']/$exchange_rate;
                        $allocated+=$each['allocated']/$exchange_rate;
                        $balanced+=$each['balance']/$exchange_rate;
                }
            }
            $table .= '<tr>
                            <td colspan="3"></td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($amount/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($allocated/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.$currency_code . Yii::app()->numberFormatter->formatCurrency(($balanced/$exchange_rate), " ") . '</td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;">No Data</td>
                      </tr>';
        }
        echo $table;
    }

    public function actionStatement_pdf_filter()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('statement_filter', array('ledger_id' => $_GET['ledger_id'], 'subledger_id' => $_GET['subledger_id'], 'type' => $_GET['type']));
    }

    public function actionstatement_pdf()
    {

        $ledger = (int) Yii::app()->request->getParam('ledger_id');
        $subledger = (int) Yii::app()->request->getParam('subledger_id');
        $layout = (int) Yii::app()->request->getParam('layout');
        $type = Yii::app()->request->getParam('type');
        $from = Yii::app()->request->getParam('from');
        $to = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $ageing_type = Yii::app()->request->getParam('ageing_type');
        $ageing_type=1;
        $param = array(
            'ledger' => $ledger,
            'subledger' => $subledger,
            'type' => $type,
            'from' => $from,
            'to' => $to,
            'ageing_type' => $ageing_type,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        
        
        if($type=='customerstatement'){
            $mpdf->WriteHTML($this->renderPartial('pdf_customer_statement', $param, true));
        }
        else{
            $view = $layout == 1 ? 'pdf_statement_base' : 'pdf_statement_voucher';
            $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        }
        $mpdf->Output("statement" . date("d-m-Y"), 'I');
    }

//    public function actionstatement_excel()
//    {
//        $from = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
//        $to = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
//
//        $ledger = (int) Yii::app()->request->getParam('ledger_id');
//        $subledger = (int) Yii::app()->request->getParam('subledger_id');
//        $type = Yii::app()->request->getParam('type');
//        $currency = (int) Yii::app()->request->getParam('currency');
//        $cur=MasCurrency::model()->findByPk($currency);
//        $exchange_rate=$cur->exchange_rate;
//        $currency_code=$cur->currency_code;
//
//        $subledgerModel = FinanceSubledger::model()->findBypk((int) $subledger);
//
//        $amountType = 'VI.amount < 0';
//        $paidType = 'VI.amount > 0';
//        if ($type == 'customer') {
//            $amountType = 'VI.amount > 0';
//            $paidType = 'VI.amount < 0';
//        }
//
//        $items = array();
//        $opening='SELECT ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS balance FROM {{finance_voucher_items}} VI
//                    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
//                    WHERE V.is_posted ="Y" AND is_allocated="N" AND V.voucher_date<"'.$from.'" AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger;
//        $opening_bal = Yii::app()->db->createCommand($opening)->queryScalar();
//
//        // $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS SELECT
//        //             V.id AS voucher_id,
//        //             V.voucher_date AS voucher_date,
//        //             V.due_date AS due_date,
//        //             V.reference_no AS reference_no,
//        //             VI.narration AS narration,
//        //             VI.id AS voucher_item_id,
//        //             V.voucher_no,
//        //             ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
//        //             ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
//        //             ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
//        //         FROM {{finance_voucher_items}} VI
//        //         LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
//        //         LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
//        //         WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from.'" AND V.voucher_date<="'.$to.'" AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
//        //         GROUP BY VI.id';
//        $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS (SELECT
//        V.id AS voucher_id,
//        V.voucher_date AS voucher_date,
//        V.due_date AS due_date,
//        V.reference_no AS reference_no,
//        VI.narration AS narration,
//        VI.id AS voucher_item_id,
//        V.voucher_no,
//        ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
//        ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
//        ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
//    FROM {{finance_voucher_items}} VI
//    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
//    LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
//    WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from.'" AND V.voucher_date<="'.$to.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
//    GROUP BY VI.id)
//    UNION
//    (SELECT
//        V.id AS voucher_id,
//        V.voucher_date AS voucher_date,
//        V.due_date AS due_date,
//        V.reference_no AS reference_no,
//        VI.narration AS narration,
//        VI.id AS voucher_item_id,
//        V.voucher_no,
//        -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
//        -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
//        -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
//    FROM {{finance_voucher_items}} VI
//    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
//    LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
//    WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from.'" AND V.voucher_date<="'.$to.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
//    GROUP BY VI.id)';
//        if ($ledger > 0 && $subledger > 0) {
//            Yii::app()->db->createCommand($query)->execute();
//            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement}} order by voucher_date')->queryAll();
//        }
//
//        Yii::import('ext.PHPExcel.PHPExcel');
//
//        $excel = new PHPExcel();
//        $excel->getProperties()->setCreator("Bluesky ERP")
//            ->setLastModifiedBy("Bluesky ERP")
//            ->setTitle("Statement of Account")
//            ->setSubject("Statement of Account")
//            ->setDescription("Statement of Account From : $from To : $to")
//            ->setKeywords("Statement of Account")
//            ->setCategory("Financial Report");
//
//        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
//        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
//        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
//        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
//        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
//        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
//
//        $excel->setActiveSheetIndex(0)->mergeCells('A1:F1');
//        $excel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(14);
//        $excel->setActiveSheetIndex(0)
//            ->setCellValue('A1', 'Statement for ' . $subledgerModel->description . ' From : ' .date("d/m/Y",strtotime($from)).' To : '.date("d/m/Y",strtotime($to)));
//
//        $rowId = 3;
//        $excel->setActiveSheetIndex(0)
//            ->setCellValue('A' . $rowId, 'Date')
//            ->setCellValue('B' . $rowId, 'Invoice No')
//            ->setCellValue('C' . $rowId, 'Due Date')
//            ->setCellValue('D' . $rowId, 'Invoice value')
//            ->setCellValue('E' . $rowId, 'Paid')
//            ->setCellValue('F' . $rowId, 'Balance');
//
//        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true)->setSize(14);
//        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFill()->applyFromArray(array(
//            'type' => PHPExcel_Style_Fill::FILL_SOLID,
//            'startcolor' => array(
//                'rgb' => 'd9d9d9',
//            ),
//        ));
//
//        $totalValue = 0;
//        $balanceTotal = 0;
//        $totalPaid = 0;
//        $rowId++;
//        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':C' . $rowId);
//        $excel->setActiveSheetIndex(0)
//            ->setCellValue('A' . $rowId, 'Opening Balance');
//        $excel->setActiveSheetIndex(0)
//            ->setCellValue('D' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " "))
//            ->setCellValue('E' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency((0/$exchange_rate), " "))
//            ->setCellValue('F' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " "));
//        $rowId++;
//        $totalValue += $opening_bal;
//        $balanceTotal += $opening_bal;
//        $totalPaid += 0;
//        foreach ($items as $each) {
//            if (round($each['balance'],0) != 0):
//                $totalValue += $each['amount'];
//                $balanceTotal += $each['balance'];
//                $totalPaid += $each['allocated'];
//                if ($_REQUEST['type'] == 'customer') {
//                    $vouchreformat = $each['voucher_no'];
//                    }
//                    else {
//                    $head=FinanceVoucherHead::model()->findByPk($each['voucher_id']);
//                    if($head->voucher_type==8)
//                    {
//                    $ref=PurchasingInvoice::model()->findByPk($head->voucher_no)->invoice_no;    
//                    }
//                    else {
//                    $ref=$each['reference_no'];    
//                    }
//                    $vouchreformat = $ref;
//                    }
//                    if(empty($ref))
//                    {
//                    $ref=$head->voucher_no;    
//                    }
//                $excel->setActiveSheetIndex(0)
//                    ->setCellValue('A' . $rowId, date("d/m/Y", strtotime($each['voucher_date'])))
//                    ->setCellValue('B' . $rowId, $vouchreformat)
//                    ->setCellValue('C' . $rowId, date("d/m/Y", strtotime($each['due_date'])))
//                    ->setCellValue('D' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($each['amount']/$exchange_rate), " "))
//                    ->setCellValue('E' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($each['allocated']/$exchange_rate), " "))
//                    ->setCellValue('F' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($each['balance']/$exchange_rate), " "));
//                $rowId++;
//            endif;
//        }
//
//        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true)->setSize(14);
//        $excel->getActiveSheet(0)->getStyle('A' . $rowId . ':F' . $rowId)->applyFromArray(array(
//            'borders' => array(
//                'top' => array(
//                    'style' => PHPExcel_Style_Border::BORDER_THIN,
//                    'color' => array('argb' => '#1E1F20'),
//                ),
//            ),
//        ));
//        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':C' . $rowId);
//        $excel->setActiveSheetIndex(0)
//            ->setCellValue('A' . $rowId, 'Total in AED');
//        $excel->setActiveSheetIndex(0)
//            ->setCellValue('D' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($totalValue/$exchange_rate), " "))
//            ->setCellValue('E' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($totalPaid/$exchange_rate), " "))
//            ->setCellValue('F' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($balanceTotal/$exchange_rate), " "));
//
//        $excel->getActiveSheet()->getStyle('D2:F' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
//        $excel->getActiveSheet()->getStyle('A' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
//
//        // Redirect output to a client’s web browser (Excel2007)
//        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
//        header('Content-Disposition: attachment;filename="statement.xlsx"');
//        header('Cache-Control: max-age=0');
//        // If you're serving to IE 9, then the following may be needed
//        header('Cache-Control: max-age=1');
//
//        // If you're serving to IE over SSL, then the following may be needed
//        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
//        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
//        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
//        header('Pragma: public'); // HTTP/1.0
//
//        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
//        $objWriter->save('php://output');
//        exit;
//    }
    public function actionstatement_excel()
    {
        $from = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

        $ledger = (int) Yii::app()->request->getParam('ledger_id');
        $subledger = (int) Yii::app()->request->getParam('subledger_id');
        $type = Yii::app()->request->getParam('type');
        $currency = 1;
        $outlet = (int) Yii::app()->request->getParam('outlet');
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;

        $subledgerModel = FinanceSubledger::model()->findBypk((int) $subledger);

        $amountType = 'VI.amount < 0';
        $paidType = 'VI.amount > 0';
        if ($type == 'customer') {
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';
        }
        $condition = '' ;
        $condition_for_opening = '';
       if ($outlet > 0) {
            $condition .= ' AND V.outlet=' . $outlet;
            $condition_for_opening .= ' AND V.outlet=' . $outlet;
        }
        $items = array();
                                            $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS (SELECT
                                    VT.description AS voucher_type,
                                    V.id AS voucher_id,
                                    V.voucher_date AS voucher_date,
                                    V.due_date AS due_date,
                                    V.reference_no AS reference_no,
                                    VI.narration AS narration,
                                    VI.id AS voucher_item_id,
                                    V.voucher_no,
                                    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
                                    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
                                    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
                                FROM {{finance_voucher_items}} VI
                                LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                                LEFT JOIN {{finance_voucher_type}} VT ON VT.id = V.voucher_type
                                LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                                WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
                                GROUP BY VI.id)
                                UNION
                                (SELECT
                                    VT.description AS voucher_type,
                                    V.id AS voucher_id,
                                    V.voucher_date AS voucher_date,
                                    V.due_date AS due_date,
                                    V.reference_no AS reference_no,
                                    VI.narration AS narration,
                                    VI.id AS voucher_item_id,
                                    V.voucher_no,
                                    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
                                    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
                                    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
                                FROM {{finance_voucher_items}} VI
                                LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                                LEFT JOIN {{finance_voucher_type}} VT ON VT.id = V.voucher_type
                                LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
                                WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
                                GROUP BY VI.id)';
        if ($ledger > 0 && $subledger > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement}} order by voucher_date')->queryAll();
        }

        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();
        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Statement of Account")
            ->setSubject("Statement of Account")
            ->setDescription("Statement of Account Upto : $to")
            ->setKeywords("Statement of Account")
            ->setCategory("Financial Report");

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);

        $excel->setActiveSheetIndex(0)->mergeCells('A1:F1');
        $excel->getActiveSheet()->getStyle('A1:F1')->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Statement for ' . $subledgerModel->description . ' Upto : '.date("d/m/Y",strtotime($to)));

        $rowId = 3;
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Date')
            ->setCellValue('B' . $rowId, 'Invoice No')
            ->setCellValue('C' . $rowId, 'Due Date')
            ->setCellValue('D' . $rowId, 'Invoice value')
            ->setCellValue('E' . $rowId, 'Paid')
            ->setCellValue('F' . $rowId, 'Balance');

        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));

        $totalValue = 0;
        $balanceTotal = 0;
        $totalPaid = 0;
        $rowId++;
        $totalPaid += 0;
        foreach ($items as $each) {
//            if($each['amount']>0)
//            {
            if (round($each['balance'], 2) != 0) :
                                                            $totalValue += $each['amount'];
                                                            $balanceTotal += $each['balance'];
                                                            $totalPaid += $each['allocated'];
                if ($_REQUEST['type'] == 'customer') {
                    $vouchreformat = $each['voucher_no'];
                    }
                    else {
                    if($each['type']==7)
                    {
                    $ref=Invoice::model()->findByPk($each['head_id'])->reference;    
                    }
                    else {
                    $ref='- '; 
                    }
                    $vouchreformat = $ref;
                    }
                    if(empty($ref))
                    {
                    $ref=$head->voucher_no;    
                    }
                $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, date("d/m/Y", strtotime($each['voucher_date'])))
                    ->setCellValue('B' . $rowId, $vouchreformat)
                    ->setCellValue('C' . $rowId, date("d/m/Y", strtotime($each['due_date'])))
                    ->setCellValue('D' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($each['amount']/$exchange_rate), " "))
                    ->setCellValue('E' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($each['allocated']/$exchange_rate), " "))
                    ->setCellValue('F' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($each['balance']/$exchange_rate), " "));
                $rowId++;
            endif;
//            }
        }

        $excel->getActiveSheet()->getStyle('A' . $rowId . ':F' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->getActiveSheet(0)->getStyle('A' . $rowId . ':F' . $rowId)->applyFromArray(array(
            'borders' => array(
                'top' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        ));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':C' . $rowId);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Total in AED');
        $excel->setActiveSheetIndex(0)
            ->setCellValue('D' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($totalValue/$exchange_rate), " "))
            ->setCellValue('E' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($totalPaid/$exchange_rate), " "))
            ->setCellValue('F' . $rowId, $currency_code.Yii::app()->numberFormatter->formatCurrency(($balanceTotal/$exchange_rate), " "));

        $excel->getActiveSheet()->getStyle('D2:F' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()->getStyle('A' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="statement.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    public function actionRec_gl_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 't.reconciled="Y" AND parent.is_posted = "Y" AND t.reconciled_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'I.reconciled="Y" AND H.is_posted = "Y" AND I.reconciled_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND t.brand_id=' . $brand;
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $tax = $headModel::model()->findBypk($childModel->parent->header_table_id)->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "&frm=" . $taxType . "', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 't.reconciled_date ASC'));

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;
        $fledger=new FinanceLegder();

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:10%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:20%" >Subledger</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">Debit (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">Credit (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="4" class="text-right" style="text-align:right !important;"><b>Beginning Balance</b></td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
                      <td></td>
                  </tr>';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            $table .= ' <tr  data-id="' . $parent . '" data-parent="">
                          <td>' . date("d/m/Y", strtotime($each->reconciled_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td>' . $subledgerName . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';

            $eachItem = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.header_id="' . (int) $each->header_id . '" AND t.id != "' . (int) $each->id . '"', 'order' => 'parent.voucher_date ASC'));
            $child = $parent + 1;
            foreach ($eachItem as $eachLine) {

                $debit = ($eachLine->amount > 0) ? round(($eachLine->amount * $eachLine->exchange_rate), 2) : '';
                $credit = ($eachLine->amount < 0) ? round(abs($eachLine->amount * $eachLine->exchange_rate), 2) : '';
                $subledgerName = ($eachLine->subledger_id > 0) ? $eachLine->subledger->description : '';

                $table .= ' <tr data-id="' . $child . '" data-parent="' . $parent . '">
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df">' . $eachLine->ledger->description . '</td>
                                    <td style="background-color:#d8f5df">' . $subledgerName . '</td>
                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df"><small>' . $eachLine->narration . '</small></td>
                            </tr>';
                $child++;
            }
            $parent = $child;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }

    public function actionRec_gl_excel()
    {
        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $condition = 't.reconciled="Y" AND parent.is_posted = "Y" AND t.reconciled_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'I.reconciled="Y" AND H.is_posted = "Y" AND I.reconciled_date < "' . $from_date . '"';

        if ($ledger != '') {
            $condition .= ' AND t.ledger_id IN(' . $ledger . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger . ')';
        }
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }
        $brand = (int) $_GET['brand'];
        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.subledger_id=' . $brand;
        }

        $openingBalance = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 't.reconciled_date'));

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("General Transaction Ledger Report")
            ->setSubject("General Transaction Ledger Report")
            ->setDescription("General Transaction Ledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("General Transaction Ledger Report")
            ->setCategory("Financial Report");

        // Add some data
         $fledger=new FinanceLegder();
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Date')
            ->setCellValue('B1', 'Voucher')
            ->setCellValue('C1', 'Ledger')
            ->setCellValue('D1', 'Subledger')
            ->setCellValue('E1', 'Debit (' . $fledger->baseCurrency() . ')')
            ->setCellValue('F1', 'Credit (' . $fledger->baseCurrency() . ')')
            ->setCellValue('G1', 'Balance')
            ->setCellValue('H1', 'Narration')
            ->setCellValue('D2', 'Beginning Balance');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('D2', 'Beginning Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E2', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('F2', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $parent = 3;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';

            $excel->getActiveSheet()->getStyle('A1:H1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->reconciled_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $each->ledger->description)
                ->setCellValue('D' . $parent, $subledgerName)
                ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('G' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('H' . $parent, $each->narration);

            if ($ledger != '') {
                $eachItem = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.header_id="' . (int) $each->header_id . '" AND t.id != "' . (int) $each->id . '"', 'order' => 'parent.voucher_date ASC'));
                $child = $parent + 1;
                foreach ($eachItem as $eachLine) {

                    $debit = ($eachLine->amount > 0) ? round(($eachLine->amount * $eachLine->exchange_rate), 2) : '';
                    $credit = ($eachLine->amount < 0) ? round(abs($eachLine->amount * $eachLine->exchange_rate), 2) : '';
                    $subledgerName = ($eachLine->subledger_id > 0) ? $eachLine->subledger->description : '';

                    $excel->setActiveSheetIndex(0)
                        ->setCellValue('C' . $child, $eachLine->ledger->description)
                        ->setCellValue('D' . $child, $subledgerName)
                        ->setCellValue('E' . $child, Yii::app()->numberFormatter->formatCurrency($debit, " "))
                        ->setCellValue('F' . $child, Yii::app()->numberFormatter->formatCurrency($credit, " "))
                        ->setCellValue('H' . $child, $eachLine->narration);

                    $excel->getActiveSheet()->getRowDimension($child)->setVisible(false);

                    $child++;
                }
                $parent = $child;
            } else {
                $parent++;
            }
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':H' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':D' . $parent);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('G2:G' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':H' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);

        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:H' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="reconciled_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionRec_gL_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        $brand = (int) Yii::app()->request->getParam('brand');

        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
        );

        $mode = 'A4-L';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_reconciled_gl_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("Reconciled_report" . date("d-m-Y"), 'I');
    }

    public function actionCus_pl_report()
    {
        $this->render('cus_pl_report');
    }

    public function actionCus_pl_excel()
    {

        $ledger_id = $_GET['ledger'];
        $subledger_id = $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $totalSales = 0;
        $totalSales_bonus = 0;
        $totalSales_discount = 0;

        $extras = $subledger_id > 0 ? ' VH.related_subledger=' . $subledger_id . ' AND ' : '';

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $query = 'SELECT
                        S.id AS subledger_id,
                        S.description AS subledger_name,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                        ROUND((SUM( CASE WHEN VI.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $services . ' ) tmp
                                    ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $cog . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS cost_of_sales
                    FROM {{finance_voucher_items}} VI
                    LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                    LEFT JOIN {{finance_subledger}} S ON S.id = VH.related_subledger
                    WHERE ' . $extras . ' VH.related_subledger > 0 AND VH.is_posted="Y" AND VH.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY VH.related_subledger ORDER BY S.description ASC';

        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(8)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Customer Report")
            ->setSubject("Customer Report")
            ->setDescription("Customer Report Generated on " . date('d/m/Y'))
            ->setKeywords("Customer Report")
            ->setCategory("Financial Report");

        // Add some data
        $excel->setActiveSheetIndex(0)
         ->setCellValue('A1', 'Customer ')
            ->setCellValue('B1', 'Sales Goods (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('C1', 'Sales Bonus (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('D1', 'Sales Discount (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('E1', 'Services (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('F1', 'Net Sales (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('G1', 'Total COGS (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('H1', 'Total Expenses (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('I1', 'Net Profit (' . FinanceLegder::baseCurrency() . ')');

            $border = array(
                'borders' => array(
                    'bottom' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '#1E1F20'),
                    ),
                ),
            );
    
            $excel->getActiveSheet(0)->getStyle('A1:I1')->applyFromArray($border); //boom border
            $excel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true)->setSize(12); //bold

        $items = Yii::app()->db->createCommand($query)->queryAll();
        $rowId = 2;
       

            foreach ($items as $each) {

                $expenses = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '  AND L.main_account_type="E" AND  H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();

                $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];
                $netProfit = $netSales - $each['cost_of_sales'] - $expenses;

                $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, $each['subledger_name'])
                    ->setCellValue('B' . $rowId, $each['sales_goods'])
                     ->setCellValue('C' . $rowId, $each['sales_bonus'])
                    ->setCellValue('D' . $rowId, $each['sales_discount'])
                     ->setCellValue('E' . $rowId, $each['sales_service'])
                     
                    ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($netSales, " "))
                    
                     ->setCellValue('G' . $rowId, $each['cost_of_sales'])
                     
                   ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency($expenses, " "))
                   ->setCellValue('I' . $rowId, Yii::app()->numberFormatter->formatCurrency($netProfit, " "));
                   
               
                $rowId++;
            }

            $excel->getActiveSheet()
                ->getStyle('B2:D' . $rowId)
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT); //right align
       
        // Rename worksheet
        $excel->getActiveSheet()->setTitle('Customer Report');

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="customer_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;

    }

    public function actionCus_pl_pdf()
    {

        $ledger_id = $_GET['ledger'];
        $subledger_id = $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $totalSales = 0;
        $totalSales_bonus = 0;
        $totalSales_discount = 0;

        $extras = $subledger_id > 0 ? ' VH.related_subledger=' . $subledger_id . ' AND ' : '';

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $query = 'SELECT
                        S.id AS subledger_id,
                        S.description AS subledger_name,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                        ROUND((SUM( CASE WHEN VI.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $services . ' ) tmp
                                    ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $cog . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS cost_of_sales
                    FROM {{finance_voucher_items}} VI
                    LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                    LEFT JOIN {{finance_subledger}} S ON S.id = VH.related_subledger
                    WHERE ' . $extras . ' VH.related_subledger > 0 AND VH.is_posted="Y" AND VH.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY VH.related_subledger ORDER BY S.description ASC';

        $table = '<table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th style="width:40%">Customer</th>
                                <th style="width:8%;text-align:right;">Sales Goods (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right;">Sales Bonus (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right;">Sales Discount (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right;">Services (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right;">Net Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right;">Total COGS (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right;">Total Expenses (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right;">Net Profit</th>
                            </tr>
                        </thead>
                        <tbody>';

        $items = Yii::app()->db->createCommand($query)->queryAll();
        if (!empty($items)) {

            foreach ($items as $each) {

                $expenses = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '  AND L.main_account_type="E" AND  H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();

                $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];
                $netProfit = $netSales - $each['cost_of_sales'] - $expenses;

                $table .= '<tr>
                                    <td>' . $each['subledger_name'] . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_goods'], " ") . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_service'], " ") . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['cost_of_sales'], " ") . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($expenses, " ") . '</td>
                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($netProfit, " ") . '</td>
                               </tr>';
            }
        } else {
            $table .= '<tr>
                                <td colspan="9" class="text-center">No Data</td>
                           </tr>';
        }
        $table .= '</tbody>
        </table>';

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_cus_201_report';
        $mpdf->WriteHTML($this->renderPartial($view, array('table' => $table, 'to_date' => $to_date, 'from_date' => $from_date, 'ledger_id' => $ledger_id), true));
        $mpdf->Output("cus_pl_reportt" . date("d-m-Y"), 'I');
    }

    public function actionCus_pl_html()
    {
        $ledger_id = $_POST['ledger_id'];
        $subledger_id = $_POST['subledger_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $totalSales = 0;
        $totalSales_bonus = 0;
        $totalSales_discount = 0;

        function getClick($from_date, $to_date, $subledger)
        {
            return 'js:load_details( \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\', ' . $subledger . ');';
        }

        $extras = $subledger_id > 0 ? ' VH.related_subledger=' . $subledger_id . ' AND ' : '';

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $query = 'SELECT
                        S.id AS subledger_id,
                        S.description AS subledger_name,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                        ROUND((SUM( CASE WHEN VI.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $services . ' ) tmp
                                    ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $cog . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS cost_of_sales
                    FROM {{finance_voucher_items}} VI
                    LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                    LEFT JOIN {{finance_subledger}} S ON S.id = VH.related_subledger
                    WHERE ' . $extras . ' VH.related_subledger > 0 AND VH.is_posted="Y" AND VH.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY VH.related_subledger ORDER BY S.description ASC';

        $table = '<table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th style="width:40%">Customer</th>
                                <th style="width:8%;text-align:right !important;">Sales Goods (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right !important;">Sales Bonus (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right !important;">Sales Discount (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right !important;">Services (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right !important;">Net Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right !important;">Total COGS (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right !important;">Total Expenses (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:8%;text-align:right !important;">Net Profit</th>
                            </tr>
                        </thead>
                        <tbody>';

        $items = Yii::app()->db->createCommand($query)->queryAll();
        if (!empty($items)) {

            foreach ($items as $each) {

                $expenses = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '  AND L.main_account_type="E" AND  H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();

                $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];
                $netProfit = $netSales - $each['cost_of_sales'] - $expenses;

                $table .= '<tr>
                                    <td><a href="#" onclick="' . getClick($from_date, $to_date, $each['subledger_id']) . '">' . $each['subledger_name'] . '</a>' . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_goods'], " ") . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_service'], " ") . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['cost_of_sales'], " ") . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($expenses, " ") . '</td>
                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netProfit, " ") . '</td>
                               </tr>';
            }
        } else {
            $table .= '<tr>
                                <td colspan="9" class="text-center">No Data</td>
                           </tr>';
        }
        $table .= '</tbody>
        </table>';
        echo $table;
    }

    public function actionPl_cus_detailed()
    {
        $subledger_id = $_POST['subledger_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $query = 'SELECT
                        S.id AS subledger_id,
                        S.description AS subledger_name,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                        ROUND((SUM( CASE WHEN VI.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $services . ' ) tmp
                                    ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount,
                        ROUND((SUM( CASE WHEN VI.ledger_id = ' . $cog . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS cost_of_sales
                    FROM {{finance_voucher_items}} VI
                    LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                    LEFT JOIN {{finance_subledger}} S ON S.id = VH.related_subledger
                    WHERE VH.related_subledger=' . $subledger_id . ' AND VI.ledger_id IN (' . $sales . ', ' . $services . ', ' . $bonus . ', ' . $discount . ', ' . $cog . ') AND VH.related_subledger > 0 AND VH.is_posted="Y" AND VH.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY VH.related_subledger ORDER BY S.description ASC';

        $items = Yii::app()->db->createCommand($query)->queryAll();
        $each = $items[0];
        $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];

        $table = '<table class="table table-hover table-fixed table-bordered">
                    <thead>
                        <tr>
                            <th style="width:60%">Paricular</th>
                            <th style="width:40%">Amount (' . FinanceLegder::baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Sales Goods</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_goods'], " ") . '</td>
                        </tr>
                         <tr>
                            <td>Sales Bonus</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                        </tr>
                        <tr>
                            <td>Sales Discount</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                        </tr>
                        <tr>
                            <td>Services</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_service'], " ") . '</td>
                        </tr>
                        <tr>
                            <td>Net Sales</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                        </tr>';

        //COGS Expense
        $table .= '<tr>
                                        <td><b>Cost of Goods Sold (-)</b></td>
                                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($each['cost_of_sales'], " ") . '</b></td>
                                    </tr>';

        $netSales -= $each['cost_of_sales'];

        $expenses = Yii::app()->db->createCommand('SELECT
                                                        L.description AS particular,
                                                        ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount
                                                        FROM {{finance_voucher_items}} I
                                                        LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id
                                                        LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id
                                                        WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '
                                                        AND L.main_account_type="E" AND
                                                        H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" '
        )->queryAll();

        foreach ($expenses as $eachEx) {
            if ($eachEx['particular'] != "") {
                $table .= '<tr>
                                        <td><b>' . $eachEx['particular'] . ' (-)</b></td>
                                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($eachEx['amount'], " ") . '</b></td>
                                    </tr>';
            }

            $netSales -= $eachEx['amount'];
        }

        $table .= '<tr>
                            <td style="color:#1F67B2;text-align:right !important;"><b>Profit</b></td>
                            <td style="color:#1F67B2;text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</b></td>
                        </tr>';

        $table .= '</tbody>
                </table>';

        echo $table;
    }

    public function actionEmp_pl_report()
    {
        $this->render('emp_pl_report');
    }

    public function actionEmp_pl_pdf()
    {

        $subledger_id = $_GET['subledger_id'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $extras = $subledger_id > 0 ? ' I.subledger_id=' . $subledger_id . ' AND ' : '';
        $items = Yii::app()->db->createCommand('SELECT
                                                    S.description AS subledger_name,
                                                    S.id AS subledger_id,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                                                    ROUND((SUM( CASE WHEN I.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                                                JOIN
                                                                (SELECT @pv:=' . $services . ' ) tmp
                                                                ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount
                                                FROM {{finance_voucher_items}} I
                                                LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id
                                                LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id
                                                LEFT JOIN {{finance_subledger}} S ON S.id = I.subledger_id
                                                WHERE ' . $extras . ' H.is_posted = "Y"
                                                AND L.main_account_type="I" AND L.id IN(' . $sales . ', ' . $services . ', ' . $bonus . ', ' . $discount . ') AND
                                                H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY I.subledger_id ORDER BY S.description ASC'
        )->queryAll();

        $table = '<table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th style="width:20%">Employee/Salesman</th>
                                <th style="width:10%;text-align:right;">Sales Goods (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right;">Sales Bonus (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right;">Sales Discount (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right;">Services (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right;">Net Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right;">COGS (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right;">Total Expenses (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right;">Profit</th>
                            </tr>
                        </thead>
                        <tbody>';

        if (!empty($items)) {

            foreach ($items as $each) {

                $cost_of_sales = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  WHERE  H.is_posted = "Y" AND H.emp_subledger=' . $each['subledger_id'] . '  AND I.ledger_id=' . $cog . ' AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();
                $expenses = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '  AND L.main_account_type="E" AND  H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();

                $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];
                $netProfit = $netSales - $cost_of_sales - $expenses;

                $table .= '<tr>
                                                   <td>' . $each['subledger_name'] . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_goods'], " ") . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_service'], " ") . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($cost_of_sales, " ") . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($expenses, " ") . '</td>
                                                    <td style="text-align:right;">' . Yii::app()->numberFormatter->formatCurrency($netProfit, " ") . '</td>
                                               </tr>';
            }
        } else {
            $table .= '<tr>
                                <td colspan="9" class="text-center">No Data</td>
                           </tr>';
        }
        $table .= '</tbody>
        </table>';

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_emp_report';
        $mpdf->WriteHTML($this->renderPartial($view, array('table' => $table, 'to_date' => $to_date, 'from_date' => $from_date, 'subledger_id' => $subledger_id), true));
        $mpdf->Output("emp_pl_reportt" . date("d-m-Y"), 'I');
    }
    
     public function actionEmp_pl_excel()
    {

        $subledger_id = $_GET['subledger_id'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $extras = $subledger_id > 0 ? ' I.subledger_id=' . $subledger_id . ' AND ' : '';
        $items = Yii::app()->db->createCommand('SELECT
                                                    S.description AS subledger_name,
                                                    S.id AS subledger_id,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                                                    ROUND((SUM( CASE WHEN I.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                                                JOIN
                                                                (SELECT @pv:=' . $services . ' ) tmp
                                                                ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount
                                                FROM {{finance_voucher_items}} I
                                                LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id
                                                LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id
                                                LEFT JOIN {{finance_subledger}} S ON S.id = I.subledger_id
                                                WHERE ' . $extras . ' H.is_posted = "Y"
                                                AND L.main_account_type="I" AND L.id IN(' . $sales . ', ' . $services . ', ' . $bonus . ', ' . $discount . ') AND
                                                H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY I.subledger_id ORDER BY S.description ASC'
        )->queryAll();
        
        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();
        
         $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Employee Report")
            ->setSubject("Employee Report")
            ->setDescription("Employee Report Generated on " . date('d/m/Y'))
            ->setKeywords("Employee Report")
            ->setCategory("Financial Report");

        // Add some data
        $excel->setActiveSheetIndex(0)
         ->setCellValue('A1', 'Employee/Salesman ')
            ->setCellValue('B1', 'Sales Goods (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('C1', 'Sales Bonus (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('D1', 'Sales Discount (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('E1', 'Services (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('F1', 'Net Sales (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('G1', 'COGS (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('H1', 'Total Expenses (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('I1', 'Profit ');

        $border = array(
                'borders' => array(
                    'bottom' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '#1E1F20'),
                    ),
                ),
            );
    
            $excel->getActiveSheet(0)->getStyle('A1:I1')->applyFromArray($border); //boom border
            $excel->getActiveSheet()->getStyle('A1:I1')->getFont()->setBold(true)->setSize(12); //bold

      //  $items = Yii::app()->db->createCommand($query)->queryAll();
        $rowId = 2;
       
        

            foreach ($items as $each) {

                $cost_of_sales = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  WHERE  H.is_posted = "Y" AND H.emp_subledger=' . $each['subledger_id'] . '  AND I.ledger_id=' . $cog . ' AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();
                $expenses = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '  AND L.main_account_type="E" AND  H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();

                $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];
                $netProfit = $netSales - $cost_of_sales - $expenses;
                
                $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, $each['subledger_name'])
                    ->setCellValue('B' . $rowId, $each['sales_goods'])
                     ->setCellValue('C' . $rowId, $each['sales_bonus'])
                    ->setCellValue('D' . $rowId, $each['sales_discount'])
                     ->setCellValue('E' . $rowId, $each['sales_service'])
                     
                    ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency($netSales, " "))
                    
                     ->setCellValue('G' . $rowId, $each['cost_of_sales'])
                     
                   ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency($expenses, " "))
                   ->setCellValue('I' . $rowId, Yii::app()->numberFormatter->formatCurrency($netProfit, " "));
                   
               
                $rowId++;
            }

              
         $excel->getActiveSheet()
                ->getStyle('B2:D' . $rowId)
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT); //right align
       
        // Rename worksheet
        $excel->getActiveSheet()->setTitle('Employee Report');

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="employee_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
        }

    public function actionEmp_pl_html()
    {
        $subledger_id = $_POST['subledger_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        function getClick($from_date, $to_date, $subledger)
        {
            return 'js:load_details( \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\', ' . $subledger . ');';
        }

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $extras = $subledger_id > 0 ? ' I.subledger_id=' . $subledger_id . ' AND ' : '';
        $items = Yii::app()->db->createCommand('SELECT
                                                    S.description AS subledger_name,
                                                    S.id AS subledger_id,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                                                    ROUND((SUM( CASE WHEN I.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                                                JOIN
                                                                (SELECT @pv:=' . $services . ' ) tmp
                                                                ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount
                                                FROM {{finance_voucher_items}} I
                                                LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id
                                                LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id
                                                LEFT JOIN {{finance_subledger}} S ON S.id = I.subledger_id
                                                WHERE ' . $extras . ' H.is_posted = "Y"
                                                AND L.main_account_type="I" AND L.id IN(' . $sales . ', ' . $services . ', ' . $bonus . ', ' . $discount . ') AND
                                                H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY I.subledger_id ORDER BY S.description ASC'
        )->queryAll();

        $table = '<table class="table table-hover table-fixed table-bordered">
                        <thead>
                            <tr>
                                <th style="width:20%">Employee/Salesman</th>
                                <th style="width:10%;text-align:right !important;">Sales Goods (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right !important;">Sales Bonus (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right !important;">Sales Discount (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right !important;">Services (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right !important;">Net Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right !important;">COGS (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right !important;">Total Expenses (' . FinanceLegder::baseCurrency() . ')</th>
                                <th style="width:10%;text-align:right !important;">Profit</th>
                            </tr>
                        </thead>
                        <tbody>';

        if (!empty($items)) {

            foreach ($items as $each) {

                $cost_of_sales = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  WHERE  H.is_posted = "Y" AND H.emp_subledger=' . $each['subledger_id'] . '  AND I.ledger_id=' . $cog . ' AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();
                $expenses = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '  AND L.main_account_type="E" AND  H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();

                $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];
                $netProfit = $netSales - $cost_of_sales - $expenses;

                $table .= '<tr>
                                                    <td><a href="#" onclick="' . getClick($from_date, $to_date, $each['subledger_id']) . '">' . $each['subledger_name'] . '</a>' . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_goods'], " ") . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_service'], " ") . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($cost_of_sales, " ") . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($expenses, " ") . '</td>
                                                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netProfit, " ") . '</td>
                                               </tr>';
            }
        } else {
            $table .= '<tr>
                                                <td colspan="8" class="text-center">No Data</td>
                                           </tr>';
        }

        $table .= '</tbody>
        </table>';
        echo $table;

    }

    public function actionPl_emp_detailed()
    {
        $subledger_id = $_POST['subledger_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $sales = FinanceLegder::findByclass('SALE');
        $services = FinanceLegder::findByclass('SALESRV');
        $bonus = FinanceLegder::findByclass('SALEB');
        $discount = FinanceLegder::findByclass('SALED');
        $cog = FinanceLegder::findByclass('COG');

        $items = Yii::app()->db->createCommand('SELECT
                                                    S.description AS subledger_name,
                                                    S.id AS subledger_id,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $sales . ' THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_goods,
                                                    ROUND((SUM( CASE WHEN I.ledger_id IN( SELECT GROUP_CONCAT(lv) AS child FROM (
                                                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                                                JOIN
                                                                (SELECT @pv:=' . $services . ' ) tmp
                                                                ) a ) THEN -1*( amount*exchange_rate) ELSE 0 END )), 4) AS sales_service,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $bonus . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_bonus,
                                                    ROUND((SUM( CASE WHEN I.ledger_id = ' . $discount . ' THEN ( amount*exchange_rate) ELSE 0 END )), 4) AS sales_discount
                                                FROM {{finance_voucher_items}} I
                                                LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id
                                                LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id
                                                LEFT JOIN {{finance_subledger}} S ON S.id = I.subledger_id
                                                WHERE I.subledger_id=' . $subledger_id . ' AND  H.is_posted = "Y"
                                                AND L.main_account_type="I" AND L.id IN(' . $sales . ', ' . $services . ', ' . $bonus . ', ' . $discount . ') AND
                                                H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" GROUP BY I.subledger_id ORDER BY S.description ASC'
        )->queryAll();
        $each = $items[0];

        $netSales = $each['sales_goods'] + $each['sales_service'] - $each['sales_bonus'] - $each['sales_discount'];
        $cost_of_sales = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id  WHERE  H.is_posted = "Y" AND H.emp_subledger=' . $subledger_id . '  AND I.ledger_id=' . $cog . ' AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ')->queryScalar();

        $table = '<table class="table table-hover table-fixed table-bordered">
                    <thead>
                        <tr>
                            <th style="width:60%">Paricular</th>
                            <th style="width:40%">Amount (' . FinanceLegder::baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>Sales Goods</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_goods'], " ") . '</td>
                        </tr>
                         <tr>
                            <td>Sales Bonus</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                        </tr>
                        <tr>
                            <td>Sales Discount</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                        </tr>
                        <tr>
                            <td>Services</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_service'], " ") . '</td>
                        </tr>
                        <tr>
                            <td>Net Sales</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                        </tr>
                        <tr>
                            <td><b>Cost of Sales (-)</b></td>
                            <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($cost_of_sales, " ") . '</b></td>
                        </tr>';

        $netSales -= $cost_of_sales;

        $expenses = Yii::app()->db->createCommand('SELECT
                                                        L.description AS particular,
                                                        ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount
                                                        FROM {{finance_voucher_items}} I
                                                        LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id
                                                        LEFT JOIN {{finance_legder}} L ON L.id = I.ledger_id
                                                        WHERE  H.is_posted = "Y" AND I.subledger_id=' . $each['subledger_id'] . '
                                                        AND L.main_account_type="E" AND
                                                        H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" '
        )->queryAll();

        foreach ($expenses as $eachEx) {
            if ($eachEx['particular'] != "") {
                $table .= '<tr>
                                        <td><b>' . $eachEx['particular'] . ' (-)</b></td>
                                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($eachEx['amount'], " ") . '</b></td>
                                    </tr>';
            }

            $netSales -= $eachEx['amount'];
        }

        $table .= '<tr>
                            <td style="color:#1F67B2;text-align:right !important;"><b>Profit</b></td>
                            <td style="color:#1F67B2;text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</b></td>
                        </tr>';

        $table .= '</tbody>
                </table>';

        echo $table;
    }

    public function actionSales_cg_report()
    {
        $this->render('sales_cg_report');
    }

    public function actionSales_cg_pdf()
    {
        $product_id = (int) $_GET['product_id'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $items = Yii::app()->db->createCommand('SELECT
                                                    C.customer_name,
                                                    ROUND((SUM(II.quantity*II.rate*I.exchange_rate)), 4) AS sales,
                                                    ROUND(SUM(II.bonus_qty*II.rate*I.exchange_rate), 4) AS sales_bonus,
                                                    ROUND(SUM(II.deduction_amount*I.exchange_rate), 4) AS sales_discount,
                                                    ROUND((SUM((II.quantity+II.bonus_qty)*II.cost_rate)), 4) AS total_cogs
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                WHERE II.product_id="' . $product_id . '" AND I.invoice_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" AND I.posted ="Y"
                                                GROUP BY I.customer_id
                                                ORDER BY C.customer_name')->queryAll();

        $table = '<table class="table table-hover table-fixed table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th style="width:30%">Customer</th>
                                                        <th style="width:10%;text-align:right !important;">Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Sales Bonus (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Sales Discount (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Net Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">COGS (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Profitt (' . FinanceLegder::baseCurrency() . ')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>';

        if (!empty($items)) {

            foreach ($items as $each) {
                $netSales = $each['sales'] - $each['sales_discount'];
                $netProfit = $netSales - $each['total_cogs'];
                $table .= '<tr>
                                                                            <td>' . $each['customer_name'] . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales'] + $each['sales_bonus'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['total_cogs'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netProfit, " ") . '</td>
                                                                       </tr>';
            }
        } else {
            $table .= '<tr>
                                <td colspan="9" class="text-center">No Data</td>
                           </tr>';
        }
        $table .= '</tbody>
        </table>';

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_sales_report';
        $mpdf->WriteHTML($this->renderPartial($view, array('table' => $table, 'to_date' => $to_date, 'from_date' => $from_date, 'product_id' => $product_id), true));
        $mpdf->Output("sales_cg_reportt" . date("d-m-Y"), 'I');
    }


 public function actionSales_cg_excel()
    {
        $product_id = (int) $_GET['product_id'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');

        $items = Yii::app()->db->createCommand('SELECT
                                                    C.customer_name,
                                                    ROUND((SUM(II.quantity*II.rate*I.exchange_rate)), 4) AS sales,
                                                    ROUND(SUM(II.bonus_qty*II.rate*I.exchange_rate), 4) AS sales_bonus,
                                                    ROUND(SUM(II.deduction_amount*I.exchange_rate), 4) AS sales_discount,
                                                    ROUND((SUM((II.quantity+II.bonus_qty)*II.cost_rate)), 4) AS total_cogs
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                WHERE II.product_id="' . $product_id . '" AND I.invoice_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" AND I.posted ="Y"
                                                GROUP BY I.customer_id
                                                ORDER BY C.customer_name')->queryAll();
                                                
                                                
                                                
                                                
                                                
                                                
                                                
                                                
                                                
                                                 Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Sales VS COGS Report")
            ->setSubject("Sales VS COGS Report")
            ->setDescription("Sales VS COGS Report Generated on " . date('d/m/Y'))
            ->setKeywords("Sales VS COGS Report")
            ->setCategory("Financial Report");

        // Add some data
        $excel->setActiveSheetIndex(0)
         ->setCellValue('A1', 'Customer ')
            ->setCellValue('B1', 'Sales (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('C1', 'Sales Bonus (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('D1', 'Sales Discount (' . FinanceLegder::baseCurrency() . ')')
       
            ->setCellValue('E1', 'Net Sales (' . FinanceLegder::baseCurrency() . ')')
            ->setCellValue('F1', 'COGS (' . FinanceLegder::baseCurrency() . ')')
           
            ->setCellValue('G1', 'Profit (' . FinanceLegder::baseCurrency() . ')');

            $border = array(
                'borders' => array(
                    'bottom' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THICK,
                        'color' => array('argb' => '#1E1F20'),
                    ),
                ),
            );


         $excel->getActiveSheet(0)->getStyle('A1:G1')->applyFromArray($border); //boom border
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12); //bold

       
        $rowId = 2;

        
            foreach ($items as $each) {
                $netSales = $each['sales'] - $each['sales_discount'];
                $netProfit = $netSales - $each['total_cogs'];
                
                
                
                
                  $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, $each['customer_name'])
                    ->setCellValue('B' . $rowId, $each['sales'] + $each['sales_bonus'])
                     ->setCellValue('C' . $rowId, $each['sales_bonus'])
                    ->setCellValue('D' . $rowId, $each['sales_discount'])
                   
                    ->setCellValue('E' . $rowId, Yii::app()->numberFormatter->formatCurrency($netSales, " "))
                    
                     ->setCellValue('F' . $rowId, $each['total_cogs'])
                     
                  
                   ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency($netProfit, " "));
                   
               
                $rowId++;
            }

               
 $excel->getActiveSheet()
                ->getStyle('B2:D' . $rowId)
                ->getAlignment()
                ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT); //right align
       
        // Rename worksheet
        $excel->getActiveSheet()->setTitle('Sales Vs COGS Report');

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="sales_cogs_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;

    }

    public function actionSales_cg_html()
    {
        $product_id = (int) $_POST['product_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $items = Yii::app()->db->createCommand('SELECT
                                                    C.customer_name,
                                                    ROUND((SUM(II.quantity*II.rate*I.exchange_rate)), 4) AS sales,
                                                    ROUND(SUM(II.bonus_qty*II.rate*I.exchange_rate), 4) AS sales_bonus,
                                                    ROUND(SUM(II.deduction_amount*I.exchange_rate), 4) AS sales_discount,
                                                    ROUND((SUM((II.quantity+II.bonus_qty)*II.cost_rate)), 4) AS total_cogs
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                WHERE II.product_id="' . $product_id . '" AND I.invoice_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" AND I.posted ="Y"
                                                GROUP BY I.customer_id
                                                ORDER BY C.customer_name')->queryAll();

        $table = '<table class="table table-hover table-fixed table-bordered">
                                                <thead>
                                                    <tr>
                                                        <th style="width:30%">Customer</th>
                                                        <th style="width:10%;text-align:right !important;">Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Sales Bonus (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Sales Discount (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Net Sales (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">COGS (' . FinanceLegder::baseCurrency() . ')</th>
                                                        <th style="width:10%;text-align:right !important;">Profitt (' . FinanceLegder::baseCurrency() . ')</th>
                                                    </tr>
                                                </thead>
                                                <tbody>';

        if (!empty($items)) {

            foreach ($items as $each) {
                $netSales = $each['sales'] - $each['sales_discount'];
                $netProfit = $netSales - $each['total_cogs'];
                $table .= '<tr>
                                                                            <td>' . $each['customer_name'] . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales'] + $each['sales_bonus'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_bonus'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['sales_discount'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netSales, " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($each['total_cogs'], " ") . '</td>
                                                                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($netProfit, " ") . '</td>
                                                                       </tr>';
            }
        } else {
            $table .= '<tr>
                                                                        <td colspan="7" class="text-center">No Data</td>
                                                                   </tr>';
        }

        $table .= '</tbody>
                                </table>';
        echo $table;
    }

    public function actionSubledger_report()
    {
        $this->render('subledger_report');
    }

    public function actionSubledger_report_html()
    {
        $subledger_id = (int) $_POST['subledger_id'];
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

        if ($subledger_id > 0) {
            Yii::app()->db->createCommand('CREATE OR REPLACE VIEW {{finance_subledger_summary}} AS SELECT
                                            L.main_account_type,
                                            L.description ,
                                            ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS balance
                                        FROM erp_finance_voucher_items VI
                                        LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                                        LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
                                        LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
                                        WHERE VH.is_posted="Y" AND VH.voucher_date >= "' . $from_date . '" AND VH.voucher_date <= "' . $to_date . '" AND subledger_id=' . $subledger_id . '
                                        GROUP BY L.id
                                        ORDER BY L.main_account_type ASC')->execute();
        }

        $items = $subledger_id > 0 ? Yii::app()->db->createCommand('SELECT main_account_type FROM {{finance_subledger_summary}} GROUP BY main_account_type')->queryAll() : array();
        
          $fledger=new FinanceLegder();

        $table = '<table class="table table-hover table-fixed table-bordered" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th style="width:50%">Ledger</th>
                            <th style="width:50%;text-align:right !important;">Closing Balance (' . $fledger->baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>';
        $labels = array('A' => 'Assets', 'L' => 'Liability', 'I' => 'Income', 'E' => 'Expense');
        if (!empty($items)) {
            foreach ($items as $each) {
                $table .= '<tr> <td colspan="2"><b>' . $labels[$each['main_account_type']] . '</b></td> </tr>';

                foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_subledger_summary}} WHERE main_account_type="' . $each['main_account_type'] . '"')->queryAll() as $eachItem) {
                    $suffix = $eachItem['balance'] > 0 ? ' Dr' : ' Cr';
                    $table .= '<tr>
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachItem['description'] . '</td>
                                        <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($eachItem['balance']), " ") . $suffix . '</td>
                                </tr>';
                }
            }
        } else {
            $table .= '<tr>
                            <td colspan="2" class="text-center">No Data</td>
                        </tr>';
        }

        $table .= '</tbody>
                </table>';
        echo $table;
    }
    public function actionCashflow_report() 
    {
    $this->render('cashflow_report');
    }
    public function actionCashflow_report_html()
    {
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

//         $SQL="CREATE OR REPLACE VIEW erp_cash_flow AS (select inv.id,inv.invoice_no,inv.invoice_date,pay.payment_terms,pay.no_of_days,
//         cust.customer_name, DATE_ADD(inv.invoice_date, INTERVAL pay.no_of_days DAY) AS receive_date,DATEDIFF(CURDATE(),
//         DATE_ADD(inv.invoice_date, INTERVAL pay.no_of_days DAY)) AS due_days,'SI' AS type,cur.currency_code,inv.grand_total,inv.exchange_rate from erp_invoice inv 
//           LEFT JOIN erp_customer cust ON inv.customer_id=cust.id LEFT JOIN erp_mas_payment_term pay ON inv.payment_terms=pay.id
//   LEFT JOIN erp_mas_currency cur ON inv.currency=cur.id 
//          ORDER BY `inv`.`invoice_date` DESC)
//           UNION 
//         (select inv.id,inv.invoice_no,inv.invoice_date,pay.payment_terms,pay.no_of_days,vendor.vendor_name,
//          DATE_ADD(inv.invoice_date, INTERVAL pay.no_of_days DAY) AS receive_date,DATEDIFF(CURDATE(),DATE_ADD(inv.invoice_date, 
//           INTERVAL pay.no_of_days DAY)) AS due_days,'PI' AS type,cur.currency_code,inv.grand_total,inv.exchange_rate from erp_purchasinginvoice inv 
//           LEFT JOIN erp_vendor vendor ON inv.vendor_id=vendor.id LEFT JOIN erp_mas_payment_term pay ON inv.payment_terms=pay.id
//         LEFT JOIN erp_mas_currency cur ON inv.currency=cur.id  ORDER BY `inv`.`invoice_date` DESC)";
        
        $items = Yii::app()->db->createCommand('SELECT * FROM {{cash_flow}}  where invoice_date>="'.$from_date.'" AND invoice_date<="'.$to_date.'"  order by invoice_date')->queryAll();

        $table = '<table class="table table-hover table-bordered" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th style="width:5%">No.</th>
                            <th style="width:5%">Inv. No.</th>
                            <th style="width:30%">Customer / Vendor</th>
                            <th style="width:5%">Inv. Date</th>
                            <th style="width:20%">Payment terms</th>
                            <th style="width:5%">Receipt Date</th>
                            <th style="width:5%">Over Due</th>
                            <th  style="width:5%;text-align:right !important;">Value</th>
                            <th  style="width:5%;text-align:right !important;">Income(BC)</th>
                            <th  style="width:5%;text-align:right !important;">Expense(BC)</th>
                        </tr>
                    </thead>
                    <tbody>';
                    $total_amount=0;
                    $total_income=0;
                    $total_expense=0;
            if (!empty($items)) {
            foreach ($items as $i=>$each) {
                $type=$each["type"]=="SI"?"<i class='fa fa-plus-square' aria-hidden='true' style='color:blue'></i>":"<i class='fa fa-minus-square' aria-hidden='true' style='color:blue'></i>";
                $color=$each["type"]=="PI"?"#fff":"#fff";
                if($each["type"]=='SI')
                {
                $total+=($each['exchange_rate']*$each['grand_total']);
                $income= ($each['exchange_rate']*$each['grand_total']);  
                $total_income+=$income;
                $expense=0;
                }
                else {
                $total-=($each['exchange_rate']*$each['grand_total']);    
                $expense= ($each['exchange_rate']*$each['grand_total']);
                $total_expense+=$expense;
                $income=0;
                }
                $table .= '<tr bgcolor="'.$color.'"> <td>' . ($i+1) . '</td> <td>' . $each["invoice_no"] . '</td> <td>' . $each["customer_name"] . '</td> 
                <td>' . date("d/m/Y",strtotime($each["invoice_date"])) . '</td>  <td>' . $each["payment_terms"] . '</td><td>' . date("d/m/Y",strtotime($each["receive_date"])) . '</td> <td>' . 
                $each["due_days"]. '</td> <td style="width:20%;text-align:right !important;">' . $each['currency_code'].' '.Yii::app()->numberFormatter->formatCurrency($each['grand_total'],"") . '</td>
                <td style="width:20%;text-align:right !important;">' .Yii::app()->numberFormatter->formatCurrency($income,"") . '</td>
                <td style="width:20%;text-align:right !important;">' .Yii::app()->numberFormatter->formatCurrency($expense,"") . '</td></tr>';
                
            }
        } else {
            $table .= '<tr>
                            <td colspan="10" class="text-center">No Data</td>
                        </tr>';
        }
        
        $total_amount=Yii::app()->numberFormatter->formatCurrency(($total),"");    
        
        $table .= '<tr>
                        <th colspan="8" class="text-right" style="width:20%;text-align:right !important;">TOTAL</th><th class="text-right" style="width:20%;text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency($total_income,"").'</th>
                        <th class="text-right" style="width:20%;text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency($total_expense,"").'</th>
                        </tr>';
        if($total_amount>0)
        {
        $table.='<tr>
        <th colspan="8" class="text-right" style="width:20%;text-align:right !important;">TOTAL</th><th class="text-right" style="width:20%;text-align:right !important;">'.$total_amount.'</th><th></th></tr>';        
        }
        else {
        $table.='<tr>
        <th colspan="8" class="text-right" style="width:20%;text-align:right !important;">TOTAL</th><th></th><th class="text-right" style="width:20%;text-align:right !important;">'.$total_amount.'</th></tr>';    
        }
        $table .= '</tbody>
                </table>';
        echo $table;
    }
    public function actionCashflow_finance_report() 
    {
    $this->render('cashflow_finance_report');
    }
    public function actionCashflow_finance_report_html()
    {
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $condition = '(t.ledger_id=21) AND (amount<0 AND t.opening_cheque_cleared="N" AND parent.is_posted = "Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $total_debit=0;
        $total_credit=0;
        $fledger=new FinanceLegder();
                  $table = '<table class="table table-hover table-fixed table-bordered">
                  <thead>
                      <tr>
                        <th style="width:80%" >Details</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Income (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Expense (' . $fledger->baseCurrency() . ')</th>
                      </tr>
                  </thead>
                  <tbody>';
                  //OUTGOING
                  $pdci_id=FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
                  $pdcr_id=FinanceSystemAccountsMapping::getSystemdefault('pdc_r');
                  $cash_id=FinanceSystemAccountsMapping::getSystemdefault('cash_account');
                  $debtors_id=FinanceSystemAccountsMapping::getSystemdefault('debtors');
                  $creditors_id=FinanceSystemAccountsMapping::getSystemdefault('creditors');
                  $bank_id=FinanceSystemAccountsMapping::getSystemdefault('bank');
                  $condition = '(I.ledger_id='.$pdci_id.') AND (I.amount<0 AND I.opening_cheque_cleared="N" AND H.is_posted = "Y" AND H.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $pdc_i=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition)->queryScalar();
                  $condition1 = '(I.ledger_id='.$cash_id.') AND (I.amount<0 AND H.is_posted = "Y" AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $table.= '<tr bgcolor="#ffcccc"><td>Issued Cheques</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($pdc_i), " ") . '</td>
                  </tr>';
                  $creditors=Yii::app()->db->createCommand('SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE H.is_posted="Y" AND I.ledger_id='.$creditors_id.' AND H.due_date<="'. $to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Creditors</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($creditors), " ") . '</td>
                  </tr>';
                  $cash_out=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition1)->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Cash Payables</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($cash_out), " ") . '</td>
                  </tr>';
                  $total_debit+=abs($cash_out);
                  $total_debit+=abs($pdc_i);
                  $purchase_order=Yii::app()->db->createCommand('select SUM(stock_grand_total*exchange_rate) from erp_purchasing_order O INNER JOIN erp_master_file M ON O.file_id=M.id where M.current_process_status="P_O" AND expected_delivery_date>="'.$from_date.'" AND expected_delivery_date<="'.$to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Purchase Order</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($purchase_order), " ") . '</td>
                  </tr>';
                  $total_debit+=abs($purchase_order);
                  $empsalary=new EmployeeSalary();
                  $wps_value1=$empsalary->getemployeesmonthlysalary(1,date("m",strtotime($from_date)),date("Y",strtotime($from_date)));
                  $wps_value2=$empsalary->getemployeesmonthlysalary(3,date("m",strtotime($from_date)),date("Y",strtotime($from_date)));
                  $wps_value=$wps_value1+$wps_value2;
                  $table.= '<tr bgcolor="#ffcccc"><td>Fixed Salaries</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($wps_value, " ") . '</td></tr>';
                  $total_debit+=$wps_value;
                  $expenses=EmiCategory::model()->findAll(array('condition'=>'type="E"'));
                  foreach($expenses as $eachExp)
                  {
                    $exp_value=0;
                    $exp_value=FinanceEmiInstallment::TotalEmi($from_date,$to_date,$eachExp->id);
                    $table.= '<tr bgcolor="#ffcccc"><td>'.$eachExp->name.'</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($exp_value, " ") . '</td></tr>';
                    $total_debit+=$exp_value;
                  }
                  //INCOMING
                  $condition2 = '(I.ledger_id='.$pdcr_id.') AND (I.opening_cheque_cleared="N" AND H.is_posted = "Y" AND H.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $pdc_r=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition2)->queryScalar();
                  $condition3 = '(I.ledger_id='.$cash_id.') AND (H.is_posted = "Y" AND H.voucher_date <="' . $to_date . '")';
                  $cash_in=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition3)->queryScalar();
                  $table.= '<tr bgcolor="#ccffeb"><td>Received Cheques</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($pdc_r, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                  $debitors=Yii::app()->db->createCommand('SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE H.is_posted="Y" AND I.ledger_id='.$debtors_id.' AND H.due_date<="'. $to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ccffeb"><td>Debtors</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($debitors), " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  </tr>';
                  $table.= '<tr bgcolor="#ccffeb"><td>Cash In Hand</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($cash_in, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                  $total_credit+=$cash_in;
                  $total_credit+=$pdc_r;
                  $income=EmiCategory::model()->findAll(array('condition'=>'type="I"'));
                  foreach($income as $eachIncome)
                  {
                    $inc_value=0;
                    $inc_value=FinanceEmiInstallment::TotalEmi($from_date,$to_date,$eachIncome->id);
                    $table.= '<tr bgcolor="#ccffeb"><td>'.$eachIncome->name.'</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($inc_value, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                    $total_credit+=$inc_value;
                  }
                  $bank=FinanceLegder::model()->findByPk($bank_id);
                  $bank_subledgers=FinanceSubledger::model()->findAll(array('condition'=>'subledger_type_id IN ('.$bank->subledger_types.')'));
                  foreach($bank_subledgers as $eachSubledger)
                  {
                    $condition4='';
                    $condition4 = '(I.ledger_id='.$bank_id.' AND I.subledger_id='.$eachSubledger->id.') AND (H.is_posted = "Y" AND H.voucher_date <="' . $to_date . '")';
                    $bank=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition4)->queryScalar();
                    $table.= '<tr bgcolor="#ccffeb"><td>'.$eachSubledger->description.'</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($bank, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                    $total_credit+=$bank;
                  }
                  
        // $parent = 1;
        // foreach ($items as $each) {

        //     $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
        //     $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
        //     $running = $debit - $credit + $previousBalance;
        //     $previousBalance = $running;
        //     $symbol = ($running > 0) ? 'Dr' : 'Cr';
        //     $closingBalance += ($debit - $credit);

        //     $total_debit += $debit;
        //     $total_credit += $credit;

        //     $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
        //     $table .= ' <tr>
        //                   <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
        //                   <td>' . $each->parent->fullvoucher . '</td>
        //                   <td>' . $each->ledger->description . '</td>
        //                   <td>' . $subledgerName . '</td>
        //                   <td>' . date("d/m/Y", strtotime($each->parent->cheque_date)) . '</td>
        //                   <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
        //                   <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
        //                   <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
        //                   <td><small>' . $each->narration . '</small></td>
        //               </tr>';
        // }
        // $condition = '(t.ledger_id=9) AND (amount<0 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
        // $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        // foreach ($items as $each) {

        //     $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
        //     $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
        //     $running = $debit - $credit + $previousBalance;
        //     $previousBalance = $running;
        //     $symbol = ($running > 0) ? 'Dr' : 'Cr';
        //     $closingBalance += ($debit - $credit);

        //     $total_debit += $debit;
        //     $total_credit += $credit;

        //     $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
        //     $table .= ' <tr>
        //                   <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
        //                   <td>' . $each->parent->fullvoucher . '</td>
        //                   <td>' . $each->ledger->description . '</td>
        //                   <td>' . $subledgerName . '</td>
        //                   <td>-</td>
        //                   <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
        //                   <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
        //                   <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
        //                   <td><small>' . $each->narration . '</small></td>
        //               </tr>';
        // }
        // $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        // $total_debit=$pdc_i+$cash_out;
        // $total_credit=$pdc_r+$cash_in;
        $table .= '<tr>
                      <th style="text-align:right !important;"><b>Total</b></th>
                      <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></th>
                      <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></th>
                  </tr>';
        $table .= '<tr>
                  <th colspan="2" style="text-align:right !important;"><b>Difference</b></th>
                  <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit)-abs($total_debit), " ") . '</b></th>
              </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }
    public function actionCashflow_finance_report_excel()
    {
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $condition = '(t.ledger_id=21) AND (amount<0 AND t.opening_cheque_cleared="N" AND parent.is_posted = "Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $total_debit=0;
        $total_credit=0;
        $fledger=new FinanceLegder();
                  $table = '<table class="table table-hover table-fixed table-bordered">
                  <thead>
                      <tr>
                        <th style="width:80%" >Details</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Income (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Expense (' . $fledger->baseCurrency() . ')</th>
                      </tr>
                  </thead>
                  <tbody>';
                  //OUTGOING
                  $pdci_id=FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
                  $pdcr_id=FinanceSystemAccountsMapping::getSystemdefault('pdc_r');
                  $cash_id=FinanceSystemAccountsMapping::getSystemdefault('cash_account');
                  $debtors_id=FinanceSystemAccountsMapping::getSystemdefault('debtors');
                  $creditors_id=FinanceSystemAccountsMapping::getSystemdefault('creditors');
                  $bank_id=FinanceSystemAccountsMapping::getSystemdefault('bank');
                  $condition = '(I.ledger_id='.$pdci_id.') AND (I.amount<0 AND I.opening_cheque_cleared="N" AND H.is_posted = "Y" AND H.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $pdc_i=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition)->queryScalar();
                  $condition1 = '(I.ledger_id='.$cash_id.') AND (I.amount<0 AND H.is_posted = "Y" AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $table.= '<tr bgcolor="#ffcccc"><td>Issued Cheques</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($pdc_i), " ") . '</td>
                  </tr>';
                  $creditors=Yii::app()->db->createCommand('SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE H.is_posted="Y" AND I.ledger_id='.$creditors_id.' AND H.due_date<="'. $to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Creditors</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($creditors), " ") . '</td>
                  </tr>';
                  $cash_out=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition1)->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Cash Payables</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($cash_out), " ") . '</td>
                  </tr>';
                  $total_debit+=abs($cash_out);
                  $total_debit+=abs($pdc_i);
                  $purchase_order=Yii::app()->db->createCommand('select SUM(stock_grand_total*exchange_rate) from erp_purchasing_order O INNER JOIN erp_master_file M ON O.file_id=M.id where M.current_process_status="P_O" AND expected_delivery_date>="'.$from_date.'" AND expected_delivery_date<="'.$to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Purchase Order</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($purchase_order), " ") . '</td>
                  </tr>';
                  $total_debit+=abs($purchase_order);
                  //$wps_value1=EmployeeSalary::getemployeesmonthlysalary(1,date("m",strtotime($from_date)),date("Y",strtotime($from_date)));
                  //$wps_value2=EmployeeSalary::getemployeesmonthlysalary(3,date("m",strtotime($from_date)),date("Y",strtotime($from_date)));
                  $wps_value=$wps_value1+$wps_value2;
                  $table.= '<tr bgcolor="#ffcccc"><td>Fixed Salaries</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($wps_value, " ") . '</td></tr>';
                  $total_debit+=$wps_value;
                  $expenses=EmiCategory::model()->findAll(array('condition'=>'type="E"'));
                  foreach($expenses as $eachExp)
                  {
                    $exp_value=0;
                    $exp_value=FinanceEmiInstallment::TotalEmi($from_date,$to_date,$eachExp->id);
                    $table.= '<tr bgcolor="#ffcccc"><td>'.$eachExp->name.'</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($exp_value, " ") . '</td></tr>';
                    $total_debit+=$exp_value;
                  }
                  //INCOMING
                  $condition2 = '(I.ledger_id='.$pdcr_id.') AND (I.opening_cheque_cleared="N" AND H.is_posted = "Y" AND H.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $pdc_r=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition2)->queryScalar();
                  $condition3 = '(I.ledger_id='.$cash_id.') AND (H.is_posted = "Y" AND H.voucher_date <="' . $to_date . '")';
                  $cash_in=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition3)->queryScalar();
                  $table.= '<tr bgcolor="#ccffeb"><td>Received Cheques</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($pdc_r, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                  $debitors=Yii::app()->db->createCommand('SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE H.is_posted="Y" AND I.ledger_id='.$debtors_id.' AND H.due_date<="'. $to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ccffeb"><td>Debtors</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($debitors), " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  </tr>';
                  $table.= '<tr bgcolor="#ccffeb"><td>Cash In Hand</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($cash_in, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                  $total_credit+=$cash_in;
                  $total_credit+=$pdc_r;
                  $income=EmiCategory::model()->findAll(array('condition'=>'type="I"'));
                  foreach($income as $eachIncome)
                  {
                    $inc_value=0;
                    $inc_value=FinanceEmiInstallment::TotalEmi($from_date,$to_date,$eachIncome->id);
                    $table.= '<tr bgcolor="#ccffeb"><td>'.$eachIncome->name.'</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($inc_value, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                    $total_credit+=$inc_value;
                  }
                  $bank=FinanceLegder::model()->findByPk($bank_id);
                  $bank_subledgers=FinanceSubledger::model()->findAll(array('condition'=>'subledger_type_id IN ('.$bank->subledger_types.')'));
                  foreach($bank_subledgers as $eachSubledger)
                  {
                    $condition4='';
                    $condition4 = '(I.ledger_id='.$bank_id.' AND I.subledger_id='.$eachSubledger->id.') AND (H.is_posted = "Y" AND H.voucher_date <="' . $to_date . '")';
                    $bank=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition4)->queryScalar();
                    $table.= '<tr bgcolor="#ccffeb"><td>'.$eachSubledger->description.'</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($bank, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                    $total_credit+=$bank;
                  }
        $table .= '<tr>
                      <th style="text-align:right !important;"><b>Total</b></th>
                      <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></th>
                      <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></th>
                  </tr>';
        $table .= '<tr>
                  <th colspan="2" style="text-align:right !important;"><b>Difference</b></th>
                  <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit)-abs($total_debit), " ") . '</b></th>
              </tr>';
        $table .= '</tbody>
              </table>';
    header("Content-type: application/octet-stream");
		header("Content-Disposition: attachment; filename=cashflow.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
    echo $table;
    }
    public function actionSales_finance_report() 
    {
    $this->render('sales_finance_report');
    }
    public function actionSales_finance_report_html()
    {
    Yii::app()->db->createCommand("TRUNCATE TABLE temp_sales_finance_tbl")->execute();
    $sql="INSERT INTO temp_sales_finance_tbl select voucher_no AS v_no,voucher_date AS v_date,header_id AS head_id,SUM(subledger_id) AS subledger_id,SUM(sales) AS sales,SUM(vat) AS vat from ((SELECT voucher_no,voucher_date,header_id,subledger_id,amount*exchange_rate AS sales,0 AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (7,10) AND ledger_id=11 AND is_posted='Y') UNION (SELECT voucher_no,voucher_date,header_id,0 AS subledger_id,0 AS sales,amount*exchange_rate AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (7,10) AND ledger_id=23 AND is_posted='Y')) AS Summary GROUP BY header_id";
    Yii::app()->db->createCommand($sql)->execute();
    $subledger_id = $_REQUEST['subledger_id'];
    $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');
    $condition="1=1";
    if(!empty($subledger_id))
    {
    $condition.=" AND subledger_id=$subledger_id ";
    }
    if(!empty($from_date))
    {
    $condition.=" AND v_date>='$from_date'";
    }
    if(!empty($to_date))
    {
    $condition.=" AND v_date<='$to_date'";
    }
    $SQL="select F.*,S.description,I.is_hiring_invoice,T.inv_name from temp_sales_finance_tbl F INNER JOIN erp_finance_subledger S ON F.subledger_id=S.id 
    LEFT JOIN erp_invoice I ON F.v_no=I.id LEFT JOIN erp_mas_invoice_type T ON I.invoice_type=T.id where $condition";
    $sales=Yii::app()->db->createCommand($SQL)->queryAll();
     $fledger=new FinanceLegder();
    $table = '<table class="table table-hover table-fixed table-bordered" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:10%" >VO Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:20%" >Customer</th>
                        <th style="width:5%" >Sale/Hire</th>
                        <th style="width:10%" >Invoice Type</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">Value W/O VAT (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">VAT (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Value(' . $fledger->baseCurrency() . ')</th>
                        </tr>
                  </thead>
                  <tbody>';
        $tot_sale=0;
        $tot_vat=0;
        $total=0;
    foreach($sales AS $eachItem)
    {
        if(($eachItem["sales"]+$eachItem["vat"])>0)
        {
        $vat=abs($eachItem["vat"]);   
        }
        else {
        $vat=-$eachItem["vat"];       
        }
        $table .= ' <tr>
                          <td>' . date("d/m/Y", strtotime($eachItem["v_date"])) . '</td>
                          <td>' . $eachItem["v_no"] . '</td>
                          <td>' . $eachItem["description"] . '</td>
                          <td>' . $eachItem["is_hiring_invoice"] . '</td>
                          <td>' . $eachItem["inv_name"] . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(($eachItem["sales"]+$eachItem["vat"])," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($vat," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($eachItem["sales"], " ") . '</td>
                      </tr>';
        $tot_sale+=($eachItem["sales"]+$eachItem["vat"]);
        $tot_vat+=$vat;
        $total+=$eachItem["sales"];
    }
    $table .= ' <tr>
    <td colspan="5" style="text-align:right !important;"><b>Total</b></td>
    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_sale," ") . '</b></td>
    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_vat," ") . '</b></td>
    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '</b></td>
</tr>';
$table .= '</tbody>
    </table>';
    echo $table;
    }
    public function actionSales_finance_report_excel()
    {
        Yii::app()->db->createCommand("TRUNCATE TABLE temp_sales_finance_tbl")->execute();
    $sql="INSERT INTO temp_sales_finance_tbl select voucher_no AS v_no,voucher_date AS v_date,header_id AS head_id,SUM(subledger_id) AS subledger_id,SUM(sales) AS sales,SUM(vat) AS vat from ((SELECT voucher_no,voucher_date,header_id,subledger_id,amount*exchange_rate AS sales,0 AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (7,10) AND ledger_id=11 AND is_posted='Y') UNION (SELECT voucher_no,voucher_date,header_id,0 AS subledger_id,0 AS sales,amount*exchange_rate AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (7,10) AND ledger_id=23 AND is_posted='Y')) AS Summary GROUP BY header_id";
    Yii::app()->db->createCommand($sql)->execute();
    $subledger_id = $_REQUEST['subledger_id'];
    $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');
    $condition="1=1";
    if(!empty($subledger_id))
    {
    $condition.=" AND subledger_id=$subledger_id ";
    }
    if(!empty($from_date))
    {
    $condition.=" AND v_date>='$from_date'";
    }
    if(!empty($to_date))
    {
    $condition.=" AND v_date<='$to_date'";
    }
    $SQL="select F.*,S.description,I.is_hiring_invoice,T.inv_name from temp_sales_finance_tbl F INNER JOIN erp_finance_subledger S ON F.subledger_id=S.id 
    LEFT JOIN erp_invoice I ON F.v_no=I.id LEFT JOIN erp_mas_invoice_type T ON I.invoice_type=T.id where $condition";
    $sales=Yii::app()->db->createCommand($SQL)->queryAll();
     $fledger=new FinanceLegder();
    $table = '<table class="table table-hover table-fixed table-bordered">
                  <thead>
                      <tr>
                        <th style="width:10%" >VO Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:20%" >Customer</th>
                        <th style="width:5%" >Sale/Hire</th>
                        <th style="width:10%" >Invoice Type</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">Value W/O VAT (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">VAT (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Value(' . $fledger->baseCurrency() . ')</th>
                        </tr>
                  </thead>
                  <tbody>';
        $tot_sale=0;
        $tot_vat=0;
        $total=0;
    foreach($sales AS $eachItem)
    {
        if(($eachItem["sales"]+$eachItem["vat"])>0)
        {
        $vat=abs($eachItem["vat"]);   
        }
        else {
        $vat=-$eachItem["vat"];       
        }
        $table .= ' <tr>
                          <td>' . date("d/m/Y", strtotime($eachItem["v_date"])) . '</td>
                          <td>' . $eachItem["v_no"] . '</td>
                          <td>' . $eachItem["description"] . '</td>
                          <td>' . $eachItem["is_hiring_invoice"] . '</td>
                          <td>' . $eachItem["inv_name"] . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(($eachItem["sales"]+$eachItem["vat"])," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($vat," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($eachItem["sales"], " ") . '</td>
                      </tr>';
        $tot_sale+=($eachItem["sales"]+$eachItem["vat"]);
        $tot_vat+=$vat;
        $total+=$eachItem["sales"];
    }
    $table .= ' <tr>
                          <td colspan="5" style="text-align:right !important;"><b>Total</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_sale," ") . '</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_vat," ") . '</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '</b></td>
                      </tr>';
    $table .= '</tbody>
    </table>';
        
    // header('Content-Type: application/vnd.ms-excel');  
    // header('Content-disposition: attachment; filename=cashflow.xls');  
    header("Content-type: application/octet-stream");
		header("Content-Disposition: attachment; filename=sales_report.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
    echo $table;
    }
    public function actionPurchase_finance_report() 
    {
    $this->render('purchase_finance_report');
    }
    public function actionPurchase_finance_report_html()
    {
    Yii::app()->db->createCommand("TRUNCATE TABLE temp_purchase_finance_tbl")->execute();
    $sql="INSERT INTO temp_purchase_finance_tbl select voucher_no AS v_no,voucher_date AS v_date,header_id AS head_id,SUM(subledger_id) AS subledger_id,SUM(purchase) AS purchase,SUM(vat) AS vat from ((SELECT voucher_no,voucher_date,header_id,subledger_id,amount*exchange_rate AS purchase,0 AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (8,9) AND ledger_id=20 AND is_posted='Y') UNION (SELECT voucher_no,voucher_date,header_id,0 AS subledger_id,0 AS purchase,amount*exchange_rate AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (8,9) AND ledger_id=31 AND is_posted='Y')) AS Summary GROUP BY header_id";
    Yii::app()->db->createCommand($sql)->execute();
    $subledger_id = $_REQUEST['subledger_id'];
    $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');
    $condition="1=1";
    if(!empty($subledger_id))
    {
    $condition.=" AND subledger_id=$subledger_id ";
    }
    if(!empty($from_date))
    {
    $condition.=" AND v_date>='$from_date'";
    }
    if(!empty($to_date))
    {
    $condition.=" AND v_date<='$to_date'";
    }
    $SQL="select F.*,S.description,T.inv_name from temp_purchase_finance_tbl F INNER JOIN erp_finance_subledger S ON F.subledger_id=S.id 
    LEFT JOIN erp_purchasinginvoice I ON F.v_no=I.id LEFT JOIN erp_mas_invoice_type T ON I.invoice_type=T.id where $condition";
    $sales=Yii::app()->db->createCommand($SQL)->queryAll();
    $fledger=new FinanceLegder();
    $table = '<table class="table table-hover table-fixed table-bordered" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:10%" >VO Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:20%" >Vendor</th>
                        <th style="width:10%" >Invoice Type</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">Value W/O VAT (' .  $fledger->baseCurrency() . ')</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">VAT (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Value(' . $fledger->baseCurrency() . ')</th>
                        </tr>
                  </thead>
                  <tbody>';
        $tot_sale=0;
        $tot_vat=0;
        $total=0;
    foreach($sales AS $eachItem)
    {
        $purchase=(-1*$eachItem["purchase"]);
        $vat=(-1*$eachItem["vat"]);
        if(($purchase+$vat)>0)
        {
        $vat=abs($vat);   
        }
        else {
        $vat=-$vat;       
        }
        $table .= ' <tr>
                          <td>' . date("d/m/Y", strtotime($eachItem["v_date"])) . '</td>
                          <td>' . $eachItem["v_no"] . '</td>
                          <td>' . $eachItem["description"] . '</td>
                          <td>' . $eachItem["inv_name"] . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(($purchase-$vat)," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($vat," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($purchase, " ") . '</td>
                      </tr>';
        $tot_purchase+=($purchase-$vat);
        $tot_vat+=$vat;
        $total+=$purchase;
    }
    $table .= ' <tr>
    <td colspan="4" style="text-align:right !important;"><b>Total</b></td>
    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_purchase," ") . '</b></td>
    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_vat," ") . '</b></td>
    <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '</b></td>
</tr>';
$table .= '</tbody>
    </table>';
    echo $table;
    }
    public function actionPurchase_finance_report_excel()
    {
        Yii::app()->db->createCommand("TRUNCATE TABLE temp_purchase_finance_tbl")->execute();
    $sql="INSERT INTO temp_purchase_finance_tbl select voucher_no AS v_no,voucher_date AS v_date,header_id AS head_id,SUM(subledger_id) AS subledger_id,SUM(purchase) AS purchase,SUM(vat) AS vat from ((SELECT voucher_no,voucher_date,header_id,subledger_id,amount*exchange_rate AS purchase,0 AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (8,9) AND ledger_id=20 AND is_posted='Y') UNION (SELECT voucher_no,voucher_date,header_id,0 AS subledger_id,0 AS sales,amount*exchange_rate AS vat FROM `erp_finance_voucher_items` I INNER JOIN erp_finance_voucher_head H ON H.id=I.header_id where H.voucher_type IN (8,9) AND ledger_id=31 AND is_posted='Y')) AS Summary GROUP BY header_id";
    Yii::app()->db->createCommand($sql)->execute();
    $subledger_id = $_REQUEST['subledger_id'];
    $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');
    $condition="1=1";
    if(!empty($subledger_id))
    {
    $condition.=" AND subledger_id=$subledger_id ";
    }
    if(!empty($from_date))
    {
    $condition.=" AND v_date>='$from_date'";
    }
    if(!empty($to_date))
    {
    $condition.=" AND v_date<='$to_date'";
    }
    $SQL="select F.*,S.description,T.inv_name from temp_purchase_finance_tbl F INNER JOIN erp_finance_subledger S ON F.subledger_id=S.id 
    LEFT JOIN erp_purchasinginvoice I ON F.v_no=I.id LEFT JOIN erp_mas_invoice_type T ON I.invoice_type=T.id where $condition";
    $sales=Yii::app()->db->createCommand($SQL)->queryAll();
    $fledger=new FinanceLegder();
    $table = '<table class="table table-hover table-fixed table-bordered">
                  <thead>
                      <tr>
                        <th style="width:10%" >VO Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:20%" >Customer</th>
                        <th style="width:10%" >Invoice Type</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">Value W/O VAT (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:8%;text-align:right !important;" class="text-right">VAT (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Value(' . $fledger->baseCurrency() . ')</th>
                        </tr>
                  </thead>
                  <tbody>';
        $tot_sale=0;
        $tot_vat=0;
        $total=0;
    foreach($sales AS $eachItem)
    {
        $purchase=(-1*$eachItem["purchase"]);
        $vat=(-1*$eachItem["vat"]);
        if(($purchase+$vat)>0)
        {
        $vat=abs($vat);   
        }
        else {
        $vat=-$vat;       
        }
        $table .= ' <tr>
                          <td>' . date("d/m/Y", strtotime($eachItem["v_date"])) . '</td>
                          <td>' . $eachItem["v_no"] . '</td>
                          <td>' . $eachItem["description"] . '</td>
                          <td>' . $eachItem["inv_name"] . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(($purchase-$vat)," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($vat," ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($purchase, " ") . '</td>
                      </tr>';
        $tot_purchase+=($purchase-$vat);
        $tot_vat+=$vat;
        $total+=$purchase;
    }
    $table .= ' <tr>
                          <td colspan="4" style="text-align:right !important;"><b>Total</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_purchase," ") . '</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($tot_vat," ") . '</b></td>
                          <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($total, " ") . '</b></td>
                      </tr>';
    $table .= '</tbody>
    </table>';
        
    // header('Content-Type: application/vnd.ms-excel');  
    // header('Content-disposition: attachment; filename=cashflow.xls');  
    header("Content-type: application/octet-stream");
		header("Content-Disposition: attachment; filename=purchase_report.xls");
		header("Pragma: no-cache");
		header("Expires: 0");
    echo $table;
    }
    public function actionSubledgerwise_report()
    {
        $this->render('subledgerwise_report');
    }

    public function actionSubledgerwise_report_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $employee = (int) $_POST['employee'];
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="3" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
                      <td></td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            $table .= ' <tr>
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }
    
        public function actionSubledgerwise_report_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = 1;
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Subledger Report")
            ->setSubject("Subledger Report")
            ->setDescription("Subledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("Subledger Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('C11', 'Opening Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 12;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="subledger_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionSubledgerwise_report_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        $brand = (int) Yii::app()->request->getParam('brand');
        $employee = (int) Yii::app()->request->getParam('employee');
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'currency_code' => $currency_code,
            'exchange_rate' => $exchange_rate,
            'currency' => $currency,
            'brand' => $brand,
            'employee' => $employee
        );

        $mode = 'A4-L';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_subledger_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("SubledgerReport" . date("d-m-Y"), 'I');
    }
    
     public function actionBrandwise_report()
    {
        $this->render('brandwise_report');
    }

    public function actionBrandwise_report_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="3" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
                      <td></td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            $table .= ' <tr>
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }
    public function actionEmployeewise_report()
    {
        $this->render('employeewise_report');
    }

    public function actionEmployeewise_report_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $employee = (int) $_POST['employee'];
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 'parent.voucher_type!=12 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.voucher_type!=12 AND H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

//        if ($brand > 0) {
//            $condition .= ' AND t.brand_id=' . $brand;
//            $condition_for_opening .= ' AND I.subledger_id=' . $brand;
//        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

//        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
//        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
//        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
//        $previousBalance = $openingBalance;
        $previousBalance = 0;
        $closingBalance = 0;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>';
//        $table.='<tr>
//                      <td colspan="3" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
//                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
//                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
//                      <td style="text-align:right !important;">' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
//                      <td></td>
//                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 1;
        foreach ($items as $each) {
            if($each->parent->voucher_type!=12)
            {
            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            $table .= ' <tr>
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';
        }
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }
    public function actionBrandwise_report_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = 1;
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Brand Report")
            ->setSubject("Brand Report")
            ->setDescription("Brand Report Generated on " . date('d/m/Y'))
            ->setKeywords("Brand Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('C11', 'Opening Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 12;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="brand_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionBrandwise_report_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        $brand = (int) Yii::app()->request->getParam('brand');
        $employee = (int) Yii::app()->request->getParam('employee');
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'currency_code' => $currency_code,
            'exchange_rate' => $exchange_rate,
            'currency' => $currency,
            'brand' => $brand,
            'employee' => $employee
        );

        $mode = 'A4-L';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_brand_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("BrandReport" . date("d-m-Y"), 'I');
    }
    public function actionEmployeewise_report_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = 1;
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.voucher_type!=12 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.voucher_type!=12 AND H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Employee Report")
            ->setSubject("Employee Report")
            ->setDescription("Employee Report Generated on " . date('d/m/Y'))
            ->setKeywords("Employee Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('C11', 'Opening Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 12;
        foreach ($items as $each) {
            if($each->parent->voucher_type!=12)
            {
            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="employee_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionEmployeewise_report_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        $brand = (int) Yii::app()->request->getParam('brand');
        $employee = (int) Yii::app()->request->getParam('employee');
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'currency_code' => $currency_code,
            'exchange_rate' => $exchange_rate,
            'currency' => $currency,
            'brand' => $brand,
            'employee' => $employee
        );

        $mode = 'A4-L';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_employee_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("EmployeeReport" . date("d-m-Y"), 'I');
    }
    public function actionStatement_html_new()
    {
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger_id = (int) $_POST['subledger_id'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $amountType = 'VI.amount < 0';
        $paidType = 'VI.amount > 0';
        if ($_POST['type'] == 'customer') {
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $items = array();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:10%">DO</th>
                            <th style="width:10%">LPO</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Paid</th>
                            <th style="width:10%">Balance</th>
                        </tr>
                    </thead>
                    <tbody>';
    $opening='SELECT ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS balance FROM {{finance_voucher_items}} VI
    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
    WHERE V.is_posted ="Y" AND is_allocated="N" AND V.voucher_date<"'.$from_date.'" AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id;
    $opening_bal = Yii::app()->db->createCommand($opening)->queryScalar();
    // $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS SELECT
    //                 V.id AS voucher_id,
    //                 V.voucher_date AS voucher_date,
    //                 V.due_date AS due_date,
    //                 V.reference_no AS reference_no,
    //                 VI.narration AS narration,
    //                 VI.id AS voucher_item_id,
    //                 V.voucher_no,
    //                 ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    //                 ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    //                 ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
    //             FROM {{finance_voucher_items}} VI
    //             LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
    //             LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
    //             WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from_date.'" AND V.voucher_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
    //             GROUP BY VI.id';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS (SELECT
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
GROUP BY VI.id)
UNION
(SELECT
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
GROUP BY VI.id)';
        if ($ledger_id > 0 && $subledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $opening_bal = Yii::app()->db->createCommand('SELECT SUM(balance) FROM {{finance_statement}} where voucher_date<"'.$from_date.'" order by voucher_date')->queryScalar();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement}} where voucher_date>="'.$from_date.'" order by voucher_date')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $table .= '<tr>
                            <td colspan="5">Opening Balance</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency((0/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " ") . '</td>
                        </tr>';
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            foreach ($items as $each) {
                if(round($each['balance'],2)!=0)
                {
                $do=''; 
                $lpo='';
                if ($_POST['type'] == 'customer') {
                $vouchreformat = '<a href="#" onclick="' . generateUrl(FinanceVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $each['voucher_no'] . '</a>';
                $head=FinanceVoucherHead::model()->findByPk($each['voucher_id']);
                if($head->voucher_type==7)
                {
                $inv=Invoice::model()->findByPk($head->voucher_no);    
                $do=$inv->delivery_ids;
                $lpo=$inv->order_lpo_no;
                }
                else {
                $do='-'; 
                $lpo='-';
                }
                }
                else {
                $head=FinanceVoucherHead::model()->findByPk($each['voucher_id']);
                if($head->voucher_type==8)
                {
                $ref=PurchasingInvoice::model()->findByPk($head->voucher_no)->invoice_no;    
                }
                else {
                $ref=$each['reference_no'];    
                }
                if(empty($ref))
                {
                $ref=$head->voucher_no;    
                }
                $vouchreformat = '<a href="#" onclick="' . generateUrl(FinanceVoucherItems::model()->findBypk((int) $each['voucher_item_id'])) . '">' . $ref . '</a>';
                $do='-'; 
                $lpo='-';
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $vouchreformat . '</td>
                            <td>' . $do . '</td>
                            <td>' . $lpo . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($each['amount']/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($each['allocated']/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($each['balance']/$exchange_rate), " ") . '</td>
                        </tr>';
                        $amount+=$each['amount']/$exchange_rate;
                        $allocated+=$each['allocated']/$exchange_rate;
                        $balanced+=$each['balance']/$exchange_rate;
                }
            }
            $table .= '<tr>
                            <td colspan="5"></td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($amount/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($allocated/$exchange_rate), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(($balanced/$exchange_rate), " ") . '</td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="8" style="text-align:center !important;">No Data</td>
                      </tr>';
        }
        echo $table;
    }

    public function actionStatement_pdf_filter_new()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('statement_filter_new', array('ledger_id' => $_GET['ledger_id'], 'subledger_id' => $_GET['subledger_id'], 'type' => $_GET['type']));
    }

    public function actionstatement_pdf_new()
    {
        $from = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

        $ledger = (int) Yii::app()->request->getParam('ledger_id');
        $subledger = (int) Yii::app()->request->getParam('subledger_id');
        $layout = (int) Yii::app()->request->getParam('layout');
        $type = Yii::app()->request->getParam('type');
        $currency = Yii::app()->request->getParam('currency');
        $param = array(
            'ledger' => $ledger,
            'subledger' => $subledger,
            'type' => $type,
            'from' => $from,
            'to' => $to,
            'currency' => $currency,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        if($type=='customerstatement'){
            $mpdf->WriteHTML($this->renderPartial('pdf_customer_statement_new', $param, true));
        }
        else{
           $view = $layout == 1 ? 'pdf_statement_base_new' : 'pdf_statement_voucher_new';
            $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        }
        
        $mpdf->Output("statement" . date("d-m-Y").".pdf", 'I');
    }

    public function actionstatement_excel_new()
    {
        $from = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

        $ledger = (int) Yii::app()->request->getParam('ledger_id');
        $subledger = (int) Yii::app()->request->getParam('subledger_id');
        $type = Yii::app()->request->getParam('type');
        $currency = (int) Yii::app()->request->getParam('currency');
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;

        $subledgerModel = FinanceSubledger::model()->findBypk((int) $subledger);

        $amountType = 'VI.amount < 0';
        $paidType = 'VI.amount > 0';
        if ($type == 'customer') {
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';
        }

        $items = array();
        $opening='SELECT ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS balance FROM {{finance_voucher_items}} VI
                    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
                    WHERE V.is_posted ="Y" AND is_allocated="N" AND V.voucher_date<"'.$from.'" AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger;
        $opening_bal = Yii::app()->db->createCommand($opening)->queryScalar();

        // $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS SELECT
        //             V.id AS voucher_id,
        //             V.voucher_date AS voucher_date,
        //             V.due_date AS due_date,
        //             V.reference_no AS reference_no,
        //             VI.narration AS narration,
        //             VI.id AS voucher_item_id,
        //             V.voucher_no,
        //             ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
        //             ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
        //             ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
        //         FROM {{finance_voucher_items}} VI
        //         LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
        //         LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
        //         WHERE V.is_posted ="Y" AND V.voucher_date>="'.$from.'" AND V.voucher_date<="'.$to.'" AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
        //         GROUP BY VI.id';
        $query = 'CREATE OR REPLACE VIEW {{finance_statement}} AS (SELECT
        V.id AS voucher_id,
        V.voucher_date AS voucher_date,
        V.due_date AS due_date,
        V.reference_no AS reference_no,
        VI.narration AS narration,
        VI.id AS voucher_item_id,
        V.voucher_no,
        ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
        ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
        ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
    FROM {{finance_voucher_items}} VI
    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
    LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
    WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
    GROUP BY VI.id)
    UNION
    (SELECT
        V.id AS voucher_id,
        V.voucher_date AS voucher_date,
        V.due_date AS due_date,
        V.reference_no AS reference_no,
        VI.narration AS narration,
        VI.id AS voucher_item_id,
        V.voucher_no,
        -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
        -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
        -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
    FROM {{finance_voucher_items}} VI
    LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
    LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
    WHERE V.is_posted ="Y" AND V.voucher_date<="'.$to.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger . ' AND VI.subledger_id = ' . $subledger . '
    GROUP BY VI.id)';
        if ($ledger > 0 && $subledger > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $opening_bal = Yii::app()->db->createCommand('SELECT SUM(balance) FROM {{finance_statement}} where voucher_date<"'.$from.'" order by voucher_date')->queryScalar();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement}} where voucher_date>="'.$from.'" order by voucher_date')->queryAll();
        }

        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();
        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Statement of Account")
            ->setSubject("Statement of Account")
            ->setDescription("Statement of Account From : $from To : $to")
            ->setKeywords("Statement of Account")
            ->setCategory("Financial Report");

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);

        $excel->setActiveSheetIndex(0)->mergeCells('A1:H1');
        $excel->getActiveSheet()->getStyle('A1:H1')->getFont()->setBold(true)->setSize(14);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Statement for ' . $subledgerModel->description . ' From : ' .date("d/m/Y",strtotime($from)).' To : '.date("d/m/Y",strtotime($to)));

        $rowId = 3;
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Date')
            ->setCellValue('B' . $rowId, 'Invoice No')
            ->setCellValue('C' . $rowId, 'DO')
            ->setCellValue('D' . $rowId, 'PLO')
            ->setCellValue('E' . $rowId, 'Due Date')
            ->setCellValue('F' . $rowId, 'Invoice value')
            ->setCellValue('G' . $rowId, 'Paid')
            ->setCellValue('H' . $rowId, 'Balance');

        $excel->getActiveSheet()->getStyle('A' . $rowId . ':H' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->getActiveSheet()->getStyle('A' . $rowId . ':H' . $rowId)->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));

        $totalValue = 0;
        $balanceTotal = 0;
        $totalPaid = 0;
        $rowId++;
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':E' . $rowId);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Opening Balance');
        $excel->setActiveSheetIndex(0)
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " "))
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency((0/$exchange_rate), " "))
            ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency(($opening_bal/$exchange_rate), " "));
        $rowId++;
        $totalValue += $opening_bal;
        $balanceTotal += $opening_bal;
        $totalPaid += 0;
        foreach ($items as $each) {
            if (round($each['balance'],0) != 0):
                $totalValue += $each['amount'];
                $balanceTotal += $each['balance'];
                $totalPaid += $each['allocated'];
                if ($_REQUEST['type'] == 'customer') {
                    $vouchreformat = $each['voucher_no'];
                $head=FinanceVoucherHead::model()->findByPk($each['voucher_id']);
                if($head->voucher_type==7)
                {
                $inv=Invoice::model()->findByPk($head->voucher_no);    
                $do=$inv->delivery_ids;
                $lpo=$inv->order_lpo_no;
                }
                else {
                $do='-'; 
                $lpo='-';
                }
                    }
                    else {
                    $head=FinanceVoucherHead::model()->findByPk($each['voucher_id']);
                    if($head->voucher_type==8)
                    {
                    $ref=PurchasingInvoice::model()->findByPk($head->voucher_no)->invoice_no;    
                    }
                    else {
                    $ref=$each['reference_no'];    
                    }
                    $vouchreformat = $ref;
                    $do='-'; 
                    $lpo='-';
                    }
                    if(empty($ref))
                    {
                    $ref=$head->voucher_no;    
                    }
                $excel->setActiveSheetIndex(0)
                    ->setCellValue('A' . $rowId, date("d/m/Y", strtotime($each['voucher_date'])))
                    ->setCellValue('B' . $rowId, $vouchreformat)
                    ->setCellValue('C' . $rowId, $do)
                    ->setCellValue('D' . $rowId, $lpo)
                    ->setCellValue('E' . $rowId, date("d/m/Y", strtotime($each['due_date'])))
                    ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(($each['amount']/$exchange_rate), " "))
                    ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency(($each['allocated']/$exchange_rate), " "))
                    ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency(($each['balance']/$exchange_rate), " "));
                $rowId++;
            endif;
        }

        $excel->getActiveSheet()->getStyle('A' . $rowId . ':H' . $rowId)->getFont()->setBold(true)->setSize(14);
        $excel->getActiveSheet(0)->getStyle('A' . $rowId . ':H' . $rowId)->applyFromArray(array(
            'borders' => array(
                'top' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        ));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $rowId . ':E' . $rowId);
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A' . $rowId, 'Total in AED');
        $excel->setActiveSheetIndex(0)
            ->setCellValue('F' . $rowId, Yii::app()->numberFormatter->formatCurrency(($totalValue/$exchange_rate), " "))
            ->setCellValue('G' . $rowId, Yii::app()->numberFormatter->formatCurrency(($totalPaid/$exchange_rate), " "))
            ->setCellValue('H' . $rowId, Yii::app()->numberFormatter->formatCurrency(($balanceTotal/$exchange_rate), " "));

        $excel->getActiveSheet()->getStyle('F2:H' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()->getStyle('A' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="statement.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    
    public function actionEmployeewise_summary_report()
    {
    $this->render('employeewise_summary_report');
    }
    
    public function actionEmployeewise_summary_report_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $employee = (int) $_POST['employee'];
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 'head.voucher_type!=12 AND head.is_posted = "Y" AND head.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.voucher_type!=12 AND H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($subledger > 0) {
            $condition .= ' AND item.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }
        
        if ($employee > 0) {
            $condition .= ' AND item.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
//        echo 'SELECT ROUND((SUM(item.amount*item.exchange_rate)), 4) AS amount,ledger.description AS ledger FROM {{finance_voucher_items}} item INNER JOIN {{finance_voucher_head}} head ON item.header_id = head.id INNER JOIN {{finance_legder}} ledger ON item.ledger_id = ledger.id WHERE  '. $condition . ' group by ledger.id ';die;
        $items = Yii::app()->db->createCommand('SELECT ROUND((SUM(item.amount*item.exchange_rate)), 4) AS amount,ledger.description AS ledger FROM {{finance_voucher_items}} item INNER JOIN {{finance_voucher_head}} head ON item.header_id = head.id INNER JOIN {{finance_legder}} ledger ON item.ledger_id = ledger.id WHERE  '. $condition . ' group by ledger.id ')->queryAll();
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                  <thead>
                      <tr>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                      </tr>
                  </thead>
                  <tbody>';
//                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
//                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each['amount'] > 0) ? round(($each['amount']), 4) : '0';
            $credit = ($each['amount'] < 0) ? round(abs($each['amount']), 4) : '0';
            
//            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
//            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $table .= ' <tr>
                          <td>' . $each['ledger'] . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . $currency_code .Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                      </tr>';
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                  </tr>';
        $table .= '<tr>
                      <td style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="2" style="text-align:right !important;"><b>' . $currency_code . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }
        public function actionEmployeewise_summary_report_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = 1;
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
                                $condition = 'head.voucher_type!=12 AND head.is_posted = "Y" AND head.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
                                $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "'.$from_date.'"';
                
                                if( $subledger > 0 ){
                                    $condition .= ' AND t.subledger_id='.$subledger;
                                    $condition_for_opening .= ' AND I.subledger_id='.$subledger;
                                }
                                if ($employee > 0) {
                                    $condition .= ' AND item.employee_id=' . $employee;
                                    $condition_for_opening .= ' AND I.employee_id=' . $employee;
                                }
                                if ($brand > 0) {
                                    $condition .= ' AND t.brand_id=' . $brand;
                                    $condition_for_opening .= ' AND I.brand_id=' . $brand;
                                }

        $items = Yii::app()->db->createCommand('SELECT ROUND((SUM(item.amount*item.exchange_rate)), 4) AS amount,ledger.description AS ledger FROM {{finance_voucher_items}} item INNER JOIN {{finance_voucher_head}} head ON item.header_id = head.id INNER JOIN {{finance_legder}} ledger ON item.ledger_id = ledger.id WHERE  '. $condition . ' group by ledger.id ')->queryAll();
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Employee Summary Report")
            ->setSubject("Employee Summary Report")
            ->setDescription("Employee Summary Report Generated on " . date('d/m/Y'))
            ->setKeywords("Employee Summary Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:C1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:C1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:C2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:C3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:C4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:C5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:C6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:C6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:C7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:C8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:C9');

        
        $excel->getActiveSheet()->getStyle('A10:C10')->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet()->getStyle('A10:C10')->getFill()->applyFromArray(array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'startcolor' => array(
                'rgb' => 'd9d9d9',
            ),
        ));
        
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A10', 'Ledger')
            ->setCellValue('B10', 'Debit')
            ->setCellValue('C10', 'Credit');
        
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 11;
        
        foreach ($items as $each) {

            $debit = ($each['amount'] > 0) ? round(($each['amount']), 4) : '0';
            $credit = ($each['amount'] < 0) ? round(abs($each['amount']), 4) : '0';

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;
            $particular=$each['ledger'];
            $excel->getActiveSheet()->getStyle('A'.$parent.':C'.$parent)->getFont()->setSize(10);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, $particular)
                ->setCellValue('B' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('C' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "));
                $parent++;
        }
        $excel->getActiveSheet()->getStyle('A'.$parent.':C'.$parent)->getFont()->setSize(14);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, "Total")
                ->setCellValue('B' . $parent,  Yii::app()->numberFormatter->formatCurrency($total_debit, " "))
                ->setCellValue('C' . $parent,  Yii::app()->numberFormatter->formatCurrency($total_credit, " "));
                $parent++;
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A'.$parent.':C'.$parent)->getFont()->setSize(14);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, "Closing Balance")
                ->setCellValue('B' . $parent,  "")
                ->setCellValue('C' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ").$symbol);
                $parent++;
        // Rename worksheet
        $excel->getActiveSheet()->setTitle('Employee Salary Summary');


        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="employee_summary_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionEmployeewise_summary_report_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        $brand = (int) Yii::app()->request->getParam('brand');
        $employee = (int) Yii::app()->request->getParam('employee');
        $currency = 1;
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'currency_code' => $currency_code,
            'exchange_rate' => $exchange_rate,
            'currency' => $currency,
            'brand' => $brand,
            'employee' => $employee
        );

        $mode = 'A4-L';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_employee_summary_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("EmployeeSummaryReport" . date("d-m-Y"), 'I');
    }
//        public function actionTb_new_html()
//    {
//        $brand = (int) $_POST['brand'];
//        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
//        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
//        $condition = 'H.is_posted="Y" AND H.voucher_date >= "' . $from_date . '" AND H.voucher_date <= "' . $to_date . '"';
//        $bs_condition = 'H.is_posted="Y" AND H.voucher_date <= "' . $to_date . '"';
//       
//$time=strtotime($end_date);
//$year=date("Y",$time);
//Yii::app()->db->createCommand('TRUNCATE TABLE trail_balance_tbl')->execute();     
//Yii::app()->db->createCommand('INSERT INTO  trail_balance_tbl (SELECT I.ledger_id,A.account_order,0 AS account_open_amount,A.account_no,A.description,A.level,A.main_account_type,A.isParent,sum(I.amount) AS amount FROM {{finance_legder}} as A left join  {{finance_voucher_items}} as I on I.ledger_id=A.id left join {{finance_voucher_head}} as H on H.id=I.header_id WHERE  '.$bs_condition.' AND (A.main_account_type="A" OR A.main_account_type="L") group by A.id order by A.account_no)')->execute();
//Yii::app()->db->createCommand('INSERT INTO  trail_balance_tbl (SELECT I.ledger_id,A.account_order,0 AS account_open_amount,A.account_no,A.description,A.level,A.main_account_type,A.isParent,sum(I.amount) AS amount FROM {{finance_legder}} as A left join  {{finance_voucher_items}} as I on I.ledger_id=A.id left join {{finance_voucher_head}} as H on H.id=I.header_id WHERE  '.$condition.' AND (A.main_account_type="I" OR A.main_account_type="E")  group by A.id order by A.account_no)')->execute();
//Yii::app()->db->createCommand('INSERT INTO  trail_balance_tbl (SELECT id,account_order,0 AS account_open_amount,account_no,description,level,main_account_type,isParent,0 AS amount FROM {{finance_legder}})')->execute();
//$SQL="select id,account_sorting_number,account_open_amount,accounting_number,title,stage,type_of_account,rollup_account,sum(amount) AS amount from trail_balance_tbl group by id order by account_sorting_number,accounting_number,title";
//$income=Yii::app()->db->createCommand($SQL)->queryAll();
//
//        $table = '<table class="table table-hover table-fixed table-bordered">
//                    <thead>
//                        <tr>
//                            <th style="width:50%">Accounts</th>
//                            <th style="width:25%">debit</th>
//                            <th style="width:25%">credit</th>
//                        </tr>
//                    </thead>
//                <tbody>';
//        $totals = array();
//        $total_debit = 0;
//        $total_credit = 0;
//        $Total_Income=0;
//        foreach ($income as $eachAccount) {
//        if($eachAccount['id']!=26)    
//        {   
//                        $balance = 0;
//                        $debit=0;
//                        $credit=0;
//                switch ($eachAccount['stage'])
//                {
//                    case 1:
//                    $space='&nbsp;&nbsp;&nbsp;';
//                    break;
//                    case 2:
//                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
//                    break;
//                    case 3:
//                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
//                    break;
//                    case 4:
//                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
//                    break;
//                    case 5:
//                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
//                    break;
//                }
//                    
//                        $accountName = $eachAccount['title'];
//                        if($eachAccount['amount']>0)
//                        {
//                        $debit=$eachAccount['amount'];  
//                        $total_debit+=$debit;
//                        }
//                        else {
//                        $credit=-1*$eachAccount['amount']; 
//                        $total_credit+=$credit;
//                        }
//                        if($eachAccount['rollup_account']=='Y')
//                        {
//                        $acc_id=$eachAccount['id'];
//                        $table .= '<tr><td colspan="3"><b>' . $space. $accountName . '</b><a onclick="loadPopupModal(\'finance/reports/parentaccountlist&id='.$acc_id.'&from_date='.$from_date.'&to_date='.$to_date.'&outlet='.$outlet.'\',\'Parent Accounts Total\',\'ls\')"><i class="fa fa-plus"></i></a></td></tr>';   
//                        }
//                        else {
//                            if($debit!=0 || $credit!=0)
//                            {
//                              $table .= '<tr>
//                                            <td>' . $space. $accountName . '</td>
//                                            <td style="text-align:right !important;" >' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
//                                            <td style="text-align:right !important;" >' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
//                                        </tr>';    
//                            }
//                        }
//        }
//        }
//                
//        $table .= '<tr>
//                                <td style="color:#1F67B2;text-align:right !important;"><b>Total  </b></td>
//                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
//                                    <td style="color:#1F67B2;text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
//                            </tr>';
//        
//        $table .= '</tbody>
//                </table>';
//        echo $table;
//
//    }
    
        public function actionTb_new_html()
    {
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        // $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);
        $accountingPeriod = $from;
        $level = in_array((int) $_GET['level'], array(1, 2, 3, 4, 5)) ? (int) $_GET['level'] : 5;

        $query = 'CREATE OR REPLACE VIEW {{finance_trialbalance}} AS SELECT
                    L.id AS ledger_id,
                    L.account_no AS ledger_no,
                    L.description AS ledger_name,
                    L.level AS level,
                    L.parent_account AS parent,
                    IFNULL(S.description, "N/A") AS subledger,
                    IFNULL(S.id, 0) AS subledger_id,
                    ROUND((SUM(CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS debit,
                    ROUND((SUM(CASE WHEN VI.amount < 0 THEN VI.amount*VI.exchange_rate ELSE 0 END)), 4) AS credit,
                    ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance
                FROM {{finance_legder}} L
                LEFT JOIN {{finance_voucher_items}} VI ON VI.ledger_id = L.id
                LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
                WHERE V.is_posted="Y" AND V.voucher_date BETWEEN  "' . $from_date . '" AND "' . $to_date . '" AND L.type_of_account IN ("B", "P")
                GROUP BY L.id, S.id';

        Yii::app()->db->createCommand($query)->execute();

        $table = '<table class="table-grid" id="tb_table">
                    <thead>
                        <tr>
                            <th style="width:5%" >#</th>
                            <th style="width:30%" >Particular</th>
                            <th style="width:17%;" class="text-right">Debit (' . FinanceLegder::baseCurrency() . ')</th>
                            <th style="width:17%;" class="text-right">Credit (' . FinanceLegder::baseCurrency() . ')</th>
                            <th style="width:17%;" class="text-right">Balance (' . FinanceLegder::baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>';

        function get_symbol($value)
        {
            return ($value) > 0 ? ' Dr' : ' Cr';
        }

        //We have 5 levels
        $total_debit = $total_credit = 0;
        $levelOne = FinanceLegder::model()->findAll(array('condition' => 'level=1 AND type_of_account IN ("B", "P") '));
        foreach ($levelOne as $eachOne) {

            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                JOIN
                (SELECT @pv:=' . $eachOne->id . ') tmp
                ) a';
            $ids = Yii::app()->db->createCommand($query)->queryAll();

            $debit = $credit = $balance = $opening = 0;
            $accountName = $eachOne->description;

            if ($ids[0]['child'] != '') {
                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE  H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                $balance += $opening;
            }

            if (abs($balance) > 0 && $level >= 1) {
                $table .= '<tr>
                            <td><b>' . $eachOne->account_no . '</b></td>
                            <td><b>' . $accountName . '</b></td>
                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . '</b></td>
                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . '</b></td>
                            <td class="text-right" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . '</b></td>
                        </tr>';
            }

            $total_debit += $debit;
            $total_credit += $credit;
//LEVEL 2
            $levelTwo = FinanceLegder::model()->findAll(array('condition' => 'level=2 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachOne->id));
            foreach ($levelTwo as $eachTwo) {

                $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                            SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                            WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                            JOIN
                            (SELECT @pv:=' . $eachTwo->id . ') tmp
                            ) a';
                $ids = Yii::app()->db->createCommand($query)->queryAll();

                $debit = $credit = $balance = $opening = 0;
                $bo = $bc = '';
                $accountName = $eachTwo->description;

                if ($ids[0]['child'] != '') {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                    $balance += $opening;
                    $bo = '<b>';
                    $bc = '</b>';
                } else {
                    $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachTwo->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                    $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();
                    $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachTwo->id . ')')->queryScalar();

                    $balance += $opening;
                }
                if (abs($balance) > 0 && $level >= 2) {
                    $table .= '<tr>
                                    <td>' . $bo . $eachTwo->account_no . $bc . '</td>
                                    <td>&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                </tr>';
                }

                //LEVEL 3
                $levelThree = FinanceLegder::model()->findAll(array('condition' => 'level=3 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachTwo->id));
                foreach ($levelThree as $eachThree) {

                    $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                JOIN
                                (SELECT @pv:=' . $eachThree->id . ') tmp
                                ) a';
                    $ids = Yii::app()->db->createCommand($query)->queryAll();

                    $debit = $credit = $balance = $opening = 0;
                    $bo = $bc = '';
                    $accountName = $eachThree->description;

                    if ($ids[0]['child'] != '') {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                        $balance += $opening;
                        $bo = '<b>';
                        $bc = '</b>';
                    } else {
                        $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachThree->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                        $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();
                        $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachThree->id . ')')->queryScalar();

                        $balance += $opening;
                    }
                    if (abs($balance) > 0 && $level >= 3) {
                        $table .= '<tr>
                                        <td>' . $bo . $eachThree->account_no . $bc . '</td>
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                        <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                    </tr>';
                    }

                    //LEVEL 4
                    $levelFour = FinanceLegder::model()->findAll(array('condition' => 'level=4 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachThree->id));
                    foreach ($levelFour as $eachFour) {

                        $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                    SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                    WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                    JOIN
                                    (SELECT @pv:=' . $eachFour->id . ') tmp
                                    ) a';
                        $ids = Yii::app()->db->createCommand($query)->queryAll();

                        $debit = $credit = $balance = $opening = 0;
                        $bo = $bc = '';
                        $accountName = $eachFour->description;

                        if ($ids[0]['child'] != '') {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                            $balance += $opening;
                            $bo = '<b>';
                            $bc = '</b>';
                        } else {
                            $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFour->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                            $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();
                            $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFour->id . ')')->queryScalar();

                            $balance += $opening;
                        }
                        if (abs($balance) > 0 && $level >= 4) {
                            $table .= '<tr data-id="' . $eachFour->id . '" data-parent="' . $eachThree->id . '" >
                                    <td>' . $bo . $eachFour->account_no . $bc . '</td>
                                    <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                    <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                </tr>';
                        }

                        //LEVEL 4
                        $levelFive = FinanceLegder::model()->findAll(array('condition' => 'level=5 AND type_of_account IN ("B", "P")  AND parent_account=' . (int) $eachFour->id));
                        foreach ($levelFive as $eachFive) {

                            $query = 'SELECT GROUP_CONCAT(lv) AS child FROM (
                                        SELECT @pv:=(SELECT GROUP_CONCAT(id SEPARATOR ",") FROM {{finance_legder}}
                                        WHERE FIND_IN_SET(parent_account, @pv)) AS lv FROM {{finance_legder}}
                                        JOIN
                                        (SELECT @pv:=' . $eachFive->id . ') tmp
                                        ) a';
                            $ids = Yii::app()->db->createCommand($query)->queryAll();

                            $debit = $credit = $balance = $opening = 0;
                            $bo = $bc = '';
                            $accountName = $eachFive->description;

                            if ($ids[0]['child'] != '') {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $ids[0]['child'] . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $ids[0]['child'] . ')')->queryScalar();

                                $bo = '<b>';
                                $bc = '</b>';
                            } else {
                                $opening = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE H.is_posted = "Y" AND I.ledger_id IN (' . $eachFive->id . ') AND H.voucher_date < "' . $accountingPeriod['from'] . '" ')->queryScalar();
                                $balance = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $debit = Yii::app()->db->createCommand('SELECT SUM(debit) AS debit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();
                                $credit = Yii::app()->db->createCommand('SELECT SUM(credit) AS credit FROM {{finance_trialbalance}} WHERE ledger_id IN (' . $eachFive->id . ')')->queryScalar();

                                $balance += $opening;
                            }
                            if (abs($balance) > 0 && $level >= 5) {
                                $table .= '<tr>
                                            <td>' . $bo . $eachFive->account_no . $bc . '</td>
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $bo . $accountName . $bc . '</td>
                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($debit), " ") . $bc . '</td>
                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($credit), " ") . $bc . '</td>
                                            <td class="text-right" >' . $bo . Yii::app()->numberFormatter->formatCurrency(abs($balance), " ") . get_symbol($balance) . $bc . '</td>
                                        </tr>';
                            }

                        }
                    }
                }
            }
        }
        $table .= '<tr>
                        <td colspan="2" class="text-right" style="text-align: right;"><b>Total</b></td>
                        <td class="text-right" alignt="right" style="text-align: right;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                        <td class="text-right" alignt="right" style="text-align: right;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                        <td></td>
                </tr>';
        $table .= '</tbody>
            </table>';
        echo $table;

    }
    public function actionPl_new_html()
    {
        $brand = (int) $_POST['brand'];
        $outlet = (int) $_POST['outlet'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $condition = 'H.is_posted="Y" AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
       
        if ($outlet > 0) {
            $condition .= ' AND I.outlet=' . $outlet;
            $conditions .= ' AND outlet=' . $outlet;
        }
        
$time=strtotime($end_date);
$year=date("Y",$time);
//echo '(SELECT A.id,A.account_order,0 AS account_open_amount,A.account_no,A.description,A.level,A.main_account_type,A.isParent,sum(I.amount) AS amount FROM {{finance_voucher_items}} as I left join {{finance_legder}} as A on I.ledger_id=A.id left join {{finance_voucher_head}} as H on H.id=I.header_id WHERE  '.$condition.'   AND ( A.main_account_type="I") group by A.id order by A.account_no)';die;
Yii::app()->db->createCommand('TRUNCATE TABLE trail_balance_tbl')->execute();                    
Yii::app()->db->createCommand('INSERT INTO  trail_balance_tbl (SELECT A.id,A.account_order,0 AS account_open_amount,A.account_no,A.description,A.level,A.main_account_type,A.isParent,sum(I.amount) AS amount FROM {{finance_voucher_items}} as I left join {{finance_legder}} as A on I.ledger_id=A.id left join {{finance_voucher_head}} as H on H.id=I.header_id WHERE  '.$condition.'   AND ( A.main_account_type="I") group by A.id order by A.account_no)')->execute();
Yii::app()->db->createCommand("INSERT INTO  trail_balance_tbl (SELECT id,account_order,0 AS account_open_amount,account_no,description,level,main_account_type,isParent,0 AS amount FROM {{finance_legder}}  where main_account_type='I')")->execute();
$SQL="select id,account_sorting_number,account_open_amount,accounting_number,title,stage,type_of_account,rollup_account,sum(amount) AS amount from trail_balance_tbl group by id order by account_sorting_number,accounting_number,title";
$income=Yii::app()->db->createCommand($SQL)->queryAll();


        //We have 5 levels
        $table = '<table class="table table-hover table-fixed table-bordered">
                    <thead>
                        <tr>
                            <th style="width:50%">Accounts</th>
                            <th style="width:25%">Amount</th>
                        </tr>
                    </thead>
                <tbody>';
        $totals = array();
//        $directIncome = FinanceLegder::model()->findAll(array('condition' => 'classification="DIRECT_INCOME"', 'order' => 'id ASC'));
        $totalDirectincome = 0;
        $totalDirectexpense = 0;
        $totalIndirectincome = 0;
        $totalIndirectexpense = 0;
        //level - 2
        $Total_Income=0;
        $TotalDirectIncome=0;
        foreach ($income as $eachAccount) {

                        $balance = 0;
                        $accountName = $eachAccount['title'];
                        switch ($eachAccount['stage'])
                {
                    case 1:
                    $space='&nbsp;&nbsp;&nbsp;';
                    break;
                    case 2:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 3:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 4:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 5:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                }
                        if($eachAccount['rollup_account']=='Y')
                        {
                            $table .= '<tr>
                                            <td colspan="2"><b>' . $space.$accountName . '</b></td>
                                        </tr>';   
                        }
                        else {
                            if($eachAccount['amount']!=0)
                            {
                            $table .= '<tr>
                                            <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $accountName . '</td>
                                            <td style="text-align:right !important;" >' . Yii::app()->numberFormatter->formatCurrency((-1*$eachAccount['amount']), " ") . '</td>
                                        </tr>';
                            }
                        }
                        
                        $Total_Income+=-1*($eachAccount['amount']);                
        }
        
        //direct expense
        
Yii::app()->db->createCommand('TRUNCATE TABLE trail_balance_tbl')->execute();                    
Yii::app()->db->createCommand('INSERT INTO  trail_balance_tbl (SELECT A.id,A.account_order,0 AS account_open_amount,A.account_no,A.description,A.level,A.main_account_type,A.isParent,sum(I.amount) AS amount FROM {{finance_voucher_items}} as I left join {{finance_legder}} as A on I.ledger_id=A.id left join {{finance_voucher_head}} as H on H.id=I.header_id WHERE '.$condition.' AND ( A.main_account_type="E") group by A.id order by A.account_no)')->execute();
Yii::app()->db->createCommand("INSERT INTO  trail_balance_tbl (select id,account_order,0 AS account_open_amount,account_no,description,level,main_account_type,isParent,0 AS amount FROM {{finance_legder}}  where main_account_type='E')")->execute();
$SQL1="select id,account_sorting_number,account_open_amount,accounting_number,title,stage,type_of_account,rollup_account,sum(amount) AS amount from trail_balance_tbl group by id order by account_sorting_number,accounting_number,title";
$expenses=Yii::app()->db->createCommand($SQL1)->queryAll();
$Total_Expense=0;
        foreach ($expenses as $eachAccount) {

                        $balance = 0;
                        switch ($eachAccount['stage'])
                {
                    case 1:
                    $space='&nbsp;&nbsp;&nbsp;';
                    break;
                    case 2:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 3:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 4:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 5:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                }
                        $accountName = $eachAccount['title'];
                        if($eachAccount['rollup_account']=='Y')
                        {
                            $table .= '<tr>
                                            <td colspan="2"><b>' . $space.$accountName . '</b></td>
                                        </tr>';   
                        }
                        else {
                            if($eachAccount['amount']!=0)
                            {
                            $table .= '<tr>
                                            <td>' . $space.$accountName . '</td>
                                            <td style="text-align:right !important;" >' . Yii::app()->numberFormatter->formatCurrency($eachAccount['amount'], " ") . '</td>
                                        </tr>';
                            }
                        }
        $Total_Expense+=$eachAccount['amount'];           
        }
        $table .= '<tr>
                                <td style="color:#1F67B2;text-align:right !important;"><b>Total Expense </b></td>
                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($Total_Expense), " ") . '</b></td>
                            </tr>';
        
        $netProfit = $Total_Income-$Total_Expense;
        if($netProfit>0)
        {
        $table .= '<tr>
                                <td style="color:#1F67B2;text-align:right !important;"><b>Profit (' . FinanceLegder::baseCurrency() . ')</b></td>
                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . $symbol . Yii::app()->numberFormatter->formatCurrency(abs($netProfit), " ") . '</b></td>
                            </tr>';
        }
        else {
        $table .= '<tr>
                                <td style="color:#1F67B2;text-align:right !important;"><b>Loss (' . FinanceLegder::baseCurrency() . ')</b></td>
                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . $symbol . Yii::app()->numberFormatter->formatCurrency(abs($netProfit), " ") . '</b></td>
                            </tr>';    
        }
        $table .= '</tbody>
                </table>';
        echo $table;

    }
    public function actionBs_new_html()
    {
        $brand = (int) $_POST['brand'];
        $outlet = (int) $_POST['outlet'];
//        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $from_date='2019-01-01';
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $condition = 'H.is_posted="Y" AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
       
        
$time=strtotime($end_date);
$year=date("Y",$time);
Yii::app()->db->createCommand('TRUNCATE TABLE trail_balance_tbl')->execute();                    
Yii::app()->db->createCommand('INSERT INTO  trail_balance_tbl (SELECT A.id,A.account_order,0 AS account_open_amount,A.account_no,A.description,A.level,A.main_account_type,A.isParent,sum(I.amount) AS amount FROM {{finance_voucher_items}} as I left join {{finance_legder}} as A on I.ledger_id=A.id left join {{finance_voucher_head}} as H on H.id=I.header_id WHERE  '.$condition.'   AND ( A.main_account_type="A") group by A.id order by A.account_no)')->execute();
Yii::app()->db->createCommand("INSERT INTO  trail_balance_tbl (select id,account_order,0 AS account_open_amount,account_no,description,level,main_account_type,isParent,0 AS amount FROM {{finance_legder}}  where main_account_type='A')")->execute();
$SQL="select id,account_sorting_number,account_open_amount,accounting_number,title,stage,type_of_account,rollup_account,sum(amount) AS amount from trail_balance_tbl group by id order by account_sorting_number,accounting_number,title";
$income=Yii::app()->db->createCommand($SQL)->queryAll();


        //We have 5 levels
        $table = '<table class="table table-hover table-fixed table-bordered">
                    <thead>
                        <tr>
                            <th style="width:50%">Accounts</th>
                            <th style="width:25%">Amount</th>
                        </tr>
                    </thead>
                <tbody>';
        $totals = array();
//        $directIncome = FinanceLegder::model()->findAll(array('condition' => 'classification="DIRECT_INCOME"', 'order' => 'id ASC'));
        $totalDirectincome = 0;
        $totalDirectexpense = 0;
        $totalIndirectincome = 0;
        $totalIndirectexpense = 0;
        //level - 2
        $Total_Income=0;
        foreach ($income as $eachAccount) {
                        $balance = 0;
                        $accountName = $eachAccount['title'];
                switch ($eachAccount['stage'])
                {
                    case 1:
                    $space='&nbsp;&nbsp;&nbsp;';
                    break;
                    case 2:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 3:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 4:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 5:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                }
                         if($eachAccount['rollup_account']=='Y')
                        {
                            $table .= '<tr>
                                            <td colspan="2"><b>' .$space.$accountName . '</b></td>
                                        </tr>';   
                        }
                        else {
                            if($eachAccount['amount']!=0)
                            {
                            $table .= '<tr>
                                            <td>' . $space.$accountName . '</td>
                                            <td style="text-align:right !important;" >' . Yii::app()->numberFormatter->formatCurrency(($eachAccount['amount']), " ") . '</td>
                                        </tr>';
                            }
                        }
                        $Total_Income+=($eachAccount['amount']);      
        }
        $table .= '<tr>
                                <td style="color:#1F67B2;text-align:right !important;"><b>Total Asset </b></td>
                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($Total_Income), " ") . '</b></td>
                            </tr>';
        //direct expense
        
Yii::app()->db->createCommand('TRUNCATE TABLE trail_balance_tbl')->execute();                    
Yii::app()->db->createCommand('INSERT INTO  trail_balance_tbl (SELECT A.id,A.account_order,0 AS account_open_amount,A.account_no,A.description,A.level,A.main_account_type,A.isParent,sum(I.amount) AS amount FROM {{finance_voucher_items}} as I left join {{finance_legder}} as A on I.ledger_id=A.id left join {{finance_voucher_head}} as H on H.id=I.header_id WHERE '.$condition.' AND ( A.main_account_type="L") group by A.id order by A.account_no)')->execute();
Yii::app()->db->createCommand("INSERT INTO  trail_balance_tbl (select id,account_order,0 AS account_open_amount,account_no,description,level,main_account_type,isParent,0 AS amount FROM {{finance_legder}}  where main_account_type='L')")->execute();
$SQL1="select id,account_sorting_number,account_open_amount,accounting_number,title,stage,type_of_account,rollup_account,sum(amount) AS amount from trail_balance_tbl group by id order by account_sorting_number,accounting_number,title";
$expenses=Yii::app()->db->createCommand($SQL1)->queryAll();
$Total_Expense=0;
        foreach ($expenses as $eachAccount) {
        if($eachAccount['id']!=26)    
        {
                        $balance = 0;
                        $accountName = $eachAccount['title'];
                        switch ($eachAccount['stage'])
                {
                    case 1:
                    $space='&nbsp;&nbsp;&nbsp;';
                    break;
                    case 2:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 3:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 4:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                    case 5:
                    $space='&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;';
                    break;
                }
                         if($eachAccount['rollup_account']=='Y')
                        {
                            $table .= '<tr>
                                            <td colspan="2"><b>' . $space.$accountName . '</b></td>
                                        </tr>';   
                        }
                        else {
                            if($eachAccount['amount']!=0)
                            {
                            $table .= '<tr>
                                            <td>' . $space.$accountName . '</td>
                                            <td style="text-align:right !important;" >' . Yii::app()->numberFormatter->formatCurrency(-1*($eachAccount['amount']), " ") . '</td>
                                        </tr>';
                            }
                        }
        $Total_Expense+=(-1*$eachAccount['amount']);       
        }
                }
        
        $table .= '<tr>
                                <td style="color:#1F67B2;text-align:right !important;"><b>Total Liability </b></td>
                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . Yii::app()->numberFormatter->formatCurrency(abs($Total_Expense), " ") . '</b></td>
                            </tr>';
        
        $netProfit = $Total_Income-$Total_Expense;
        if($netProfit>0)
        {
        $table .= '<tr>
                                <td style="color:#1F67B2;text-align:right !important;"><b>Profit (' . FinanceLegder::baseCurrency() . ')</b></td>
                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . $symbol . Yii::app()->numberFormatter->formatCurrency(abs($netProfit), " ") . '</b></td>
                            </tr>';
        }
        else {
        $table .= '<tr>
                                <td style="color:#1F67B2;text-align:right !important;"><b>Loss (' . FinanceLegder::baseCurrency() . ')</b></td>
                                <td style="color:#1F67B2;text-align:right !important;" ><b>' . $symbol . Yii::app()->numberFormatter->formatCurrency(abs($netProfit), " ") . '</b></td>
                            </tr>';    
        }
        $table .= '</tbody>
                </table>';
        echo $table;

    }
    public function actionSubledger_detail_report()
    {
        $this->render('subledger_detail_report');
    }

    public function actionSubledger_detail_report_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $employee = (int) $_POST['employee'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:20%" >Subledger</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="4" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
                      <td></td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            $table .= ' <tr  data-id="' . $parent . '" data-parent="">
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td>' . $subledgerName . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';
            $parent = $child;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }

    public function actionstatement_sales_pdf()
    {

        $ledger = (int) Yii::app()->request->getParam('ledger_id');
        $customer = (int) Yii::app()->request->getParam('customer_id');
        $subledger = FinanceSubledger::model()->find(array('condition'=>'subledger_type_id=1 AND parent_id='.$customer))->id;
        $layout = (int) Yii::app()->request->getParam('layout');
        $type = Yii::app()->request->getParam('type');
        $from = Yii::app()->request->getParam('from');
        $to = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $ageing_type = Yii::app()->request->getParam('ageing_type');
        $ageing_type=1;
        $param = array(
            'ledger' => $ledger,
            'subledger' => $subledger,
            'type' => $type,
            'from' => $from,
            'to' => $to,
            'ageing_type' => $ageing_type,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = $layout == 1 ? 'pdf_statement_base' : 'pdf_statement_voucher';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("statement" . date("d-m-Y"), 'I');
    }
    
    public function actionVehicle_report()
    {
        $this->render('vehicle_report');
    }
    
    public function actionVehicle_report_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $employee = (int) $_POST['employee'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 't.amount>0 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'I.amount>0 AND H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:20%" >Subledger</th>
                        <th style="width:40%">Narration</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Amount</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="5" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            $table .= ' <tr  data-id="' . $parent . '" data-parent="">
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td>' . $subledgerName . '</td>
                          <td><small>' . $each->narration . '</small></td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                      </tr>';
            $parent = $child;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="5" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td></tr>';
//        $table .= '<tr>
//                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
//                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
//                      <td></td>
//                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }
    public function actionCustomer_aging_report()
    {
        $category = ((int) $_GET['type'] == 1) ? 'RECEIVABLE' : 'PAYABLE';
        $this->render('customer_aging_report', array('filter_array' => $this->getCategories($category), 'category' => $category));
    }
    public function actionCustomer_aging_html()
    {
        $from_date = '2019-01-01';
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger_id = (int) $_POST['subledger_id'];
        $industry_id = (int) $_POST['industry'];
        $currency = (int) $_POST['currency'];
        $type = (int) $_POST['types'];
        $lead_owner = (int) $_POST['lead_owner'];
        if($type==1)
        {
        $from_date=$to_date;
        $to_date=date('Y-m-d', strtotime($to_date . ' +15 days'));    
        }
        if($type==2)
        {
        $from_date=date('Y-m-d', strtotime($to_date . ' +15 days'));
        $to_date=date('Y-m-d', strtotime($to_date . ' +30 days'));    
        }
        if($lead_owner>0)
        {
        $condition=' AND S.lead_owner='.$lead_owner;    
        }
        else {
        $condition='';    
        }
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=1;
        $currency_code=$cur->currency_code;
        $amountType = 'VI.amount < 0';
        $paidType = 'VI.amount > 0';
        if ($_POST['type'] == 'customer') {
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }
        if($industry_id>0)
        {
        $items = array();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th style="width:7%">Date</th>
                            <th style="width:5%">Invoice No</th>
                            <th style="width:20%">Subledger</th>
                            <th style="width:7%">Due Date</th>
                            <th style="width:10%">Over Due Days</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Pending Amount</th>
                        </tr>
                    </thead>
                    <tbody>';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement_new}} AS (SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id. $condition . '
GROUP BY VI.id)
UNION
(SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id. $condition . '
GROUP BY VI.id)';
        if ($ledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement_new}} where industry_name='.$industry_id.' order by subledger_id,due_date')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            $subledger_id=0;
            $subledger_tot=0;
            $i=0;
            foreach ($items as $each) {
                $date1=date_create($each['due_date']);
                $date2=date_create($to_date);
                $diff=date_diff($date1,$date2);
                if($diff->format("%R%a")>0)
                {
                $over_due=$diff->format("%a");    
                }
                else {
                $over_due=0;     
                }
                if(round($each['balance'],2)!=0 && $over_due>0)
                {
                if($each['subledger_id']!=$subledger_id)
                {
                if($i>0)
                {
                if($subledger_tot!=0)
                {    
                $table .= '<tr>
                            <td colspan="6" style="text-align:right !important;"><b>Total</b></td>
                            <td style="text-align:right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($subledger_tot), " ") . '</b></td>
                        </tr>';
                }
                }
                $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;"><b>'.$each['subledger_name'].'</b></td>
                        </tr>';
                $subledger_tot=0;
                $subledger_id=$each['subledger_id'];
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $subledger_tot+=-1*$each['balance'];
                        $i++;
                }
                else {
                if($i==0)
                {
                $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;"><b>'.$each['subledger_name'].'</b></td>
                        </tr>';
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $subledger_tot+=-1*$each['amount'];
                        $i++;
                }
                }
            }
            $table .= '<tr>
                            <td colspan="6" style="text-align:right !important;"><b>Total</b></td>
                            <td style="text-align:right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($subledger_tot), " ") . '</b></td>
                        </tr>'; 
            $table .= '<tr>
                            <td colspan="6"style="text-align:right !important;"><b>Grand Total</b></td>
                            <td style="text-align:right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($balanced), " ") . '</b></td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;">No Data</td>
                      </tr>';
        }    
        }
        else 
        {
        $items = array();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:10%">Subledger</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Over Due Days</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Pending Amount</th>
                        </tr>
                    </thead>
                    <tbody>';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement_new}} AS (SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'"  AND V.due_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)
UNION
(SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'"  AND V.due_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)';
        if ($ledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement_new}} order by industry_name,due_date,subledger_id')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            $industry=0;
            $industry_tot=0;
            $i=0;
            foreach ($items as $each) {
                $date1=date_create($each['due_date']);
                $date2=date_create($to_date);
                $diff=date_diff($date1,$date2);
                if($diff->format("%R%a")>0)
                {
                $over_due=$diff->format("%a");    
                }
                else {
                $over_due=0;     
                }
                if(round($each['balance'],2)!=0 && $over_due>0)
                {
                if($each['industry_name']!=$industry)
                {
                if($industry_tot!=0)
                {
                $table .= '<tr>
                            <td colspan="6" style="text-align:right !important;"><b>Total</b></td>
                            <td style="text-align:right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($industry_tot), " ") . '</b></td>
                        </tr>';
                }
                if($each['industry_name']>0)
                {
                $customer_industry=MasIndustry::model()->findByPk($each['industry_name'])->name;
                $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;"><b>'.$customer_industry.'</b></td>
                        </tr>';
                }
                $industry_tot=0;
                $industry=$each['industry_name'];
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                                <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $industry_tot+=-1*$each['balance'];
                        $i++;
                }
                else {
                if($i==0)
                {
                if($each['industry_name']>0)
                {
                $customer_industry=MasIndustry::model()->findByPk($each['industry_name'])->name;
                $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;"><b>'.$customer_industry.'</b></td>
                        </tr>';
                }
                else {
                $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;"><b></b></td>
                        </tr>';
                }
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                                <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $industry_tot+=-1*$each['balance'];    
                        $i++;
                }
                }
            }
            $table .= '<tr>
                            <td colspan="6" style="text-align:right !important;"><b>Total</b></td>
                            <td style="text-align:right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($industry_tot), " ") . '</b></td>
                        </tr>'; 
            $table .= '<tr>
                            <td colspan="6"style="text-align:right !important;"><b>Grand Total</b></td>
                            <td style="text-align:right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($balanced), " ") . '</b></td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;">No Data</td>
                      </tr>';
        }
    }
        echo $table;
    }
    public function actionParentaccountlist()
    {
    $parent_id = (int) $_REQUEST['id']; 
    $from_date = $_REQUEST['from_date'];
    $to_date = $_REQUEST['to_date'];
    $Ledgers=FinanceLegder::model()->findAll(array('condition'=>'root like "%,'.$parent_id.',%" OR root like "'.$parent_id.',%" OR root like "%,'.$parent_id.'" OR root like "'.$parent_id.'"','order'=>'account_order'));
    $debit_total=$credit_total=0;
    echo '<table><tr><th>Accounts</th><th>Debit</th><th>Credit</th></tr>';
    foreach ($Ledgers as $i=>$each)
    {
    $debit=$credit=0;
    if($each->isParent=='N')  
    {
    if($each->main_account_type=="A" || $each->main_account_type=="L")    
    {
    $amount=Yii::app()->db->createCommand('SELECT SUM(amount) from {{finance_voucher_head}} head INNER JOIN {{finance_voucher_items}} items ON head.id=items.header_id where head.is_posted ="Y" AND head.voucher_date<="'.$to_date.'"  AND items.ledger_id = ' . $each->id )->queryScalar();    
    }
    else {
    $amount=Yii::app()->db->createCommand('SELECT SUM(amount) from {{finance_voucher_head}} head INNER JOIN {{finance_voucher_items}} items ON head.id=items.header_id where head.is_posted ="Y" AND head.voucher_date>="'.$from_date.'" AND head.voucher_date<="'.$to_date.'"  AND items.ledger_id = ' . $each->id )->queryScalar();    
    }
    if($amount>0)
    {
    $debit=$amount; 
    $debit_total+=$debit;
    }
    else {
    $credit=abs($amount); 
    $credit_total+=$credit; 
    }
    if($debit!=0 || $credit!=0)
    {
    echo '<tr><td>'.$each->description.'</td><td>'.Yii::app()->numberFormatter->formatCurrency(($debit), " ").'</td><td>'.Yii::app()->numberFormatter->formatCurrency(($credit), " ").'</td></tr>';
    }
    }
    }
    echo '<tr><td><b>Total</b></td><td><b>'.Yii::app()->numberFormatter->formatCurrency(($debit_total), " ").'</b></td><td><b>'.Yii::app()->numberFormatter->formatCurrency(($credit_total), " ").'</b></td></tr>';
    $balance=$debit_total-$credit_total;
    if($balance>0)
    {
    echo '<tr><td><b>Balance</b></td><td><b>'.Yii::app()->numberFormatter->formatCurrency(($balance), " ").'</b></td><td><b>'.Yii::app()->numberFormatter->formatCurrency(0, " ").'</b></td></tr>';
    }
    else
    {
    echo '<tr><td><b>Balance</b></td><td><b>'.Yii::app()->numberFormatter->formatCurrency(0, " ").'</b></td><td><b>'.Yii::app()->numberFormatter->formatCurrency(abs($balance), " ").'</b></td></tr>';
    }
    }
    
    public function actionCustomer_aging_pdf()
    {
        $from_date = '2019-01-01';
        $to_date = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-d');

        $ledger_id = (int) $_REQUEST['ledger'];
        $industry_id = (int) $_REQUEST['industry'];
        $currency = (int) $_REQUEST['currency'];
        $type = (int) $_REQUEST['types']; 
        $lead_owner = (int) $_REQUEST['lead_owner'];
        if($type==1)
        {
        $from_date=$to_date;
        $to_date=date('Y-m-d', strtotime($to_date . ' +15 days'));    
        }
        if($type==2)
        {
        $from_date=date('Y-m-d', strtotime($to_date . ' +15 days'));
        $to_date=date('Y-m-d', strtotime($to_date . ' +30 days'));    
        }
        if($lead_owner>0)
        {
        $condition=' AND S.lead_owner='.$lead_owner;    
        }
        else {
        $condition='';    
        }
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=1;
        $currency_code=$cur->currency_code;
        $amountType = 'VI.amount < 0';
        $paidType = 'VI.amount > 0';
        if ($_REQUEST['type'] == 'customer') {
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';
        }

        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }
        if($industry_id>0)
        {
        $items = array();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                    <thead>
                        <tr>
                            <th style="width:7%">Date</th>
                            <th style="width:5%">Invoice No</th>
                            <th style="width:30%">Subledger</th>
                            <th style="width:7%">Due Date</th>
                            <th style="width:10%">Over Due Days</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Pending Amount</th>
                        </tr>
                    </thead>
                    <tbody>';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement_new}} AS (SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)
UNION
(SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)';
        if ($ledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement_new}} where industry_name='.$industry_id.' order by subledger_id,due_date')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            $subledger_id=0;
            $subledger_tot=0;
            $i=0;
            foreach ($items as $each) {
                $date1=date_create($each['due_date']);
                $date2=date_create($to_date);
                $diff=date_diff($date1,$date2);
                if($diff->format("%R%a")>0)
                {
                $over_due=$diff->format("%a");    
                }
                else {
                $over_due=0;     
                }
                if(round($each['balance'],2)!=0 && $over_due>0)
                {
                if($each['subledger_id']!=$subledger_id)
                {
                if($i>0)
                {
                if($subledger_tot!=0)
                { 
                $table .= '<tr>
                            <td colspan="6" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(($subledger_tot), " ") . '</b></td>
                        </tr>';
                }
                }
                $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;"><b>'.$each['subledger_name'].'</b></td>
                        </tr>';
                $subledger_tot=0;
                $subledger_id=$each['subledger_id'];
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $subledger_tot+=-1*$each['balance'];
                        $i++;
                }
                else {
                if($i==0)
                {
                $table .= '<tr>
                            <td colspan="8" style="text-align:center !important;"><b>'.$each['subledger_name'].'</b></td>
                        </tr>';
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $subledger_tot+=-1*$each['balance'];
                        $i++;
                }
                }
            }
            $table .= '<tr>
                            <td colspan="6" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(($subledger_tot), " ") . '</b></td>
                        </tr>'; 
            $table .= '<tr>
                            <td colspan="6" class="text-right"><b>Grand Total</b></td>
                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(($balanced), " ") . '</b></td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;">No Data</td>
                      </tr>';
        }    
        }
        else 
        {
        $items = array();
        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:30%">Subledger</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Over Due Days</th>
                            <th style="width:10%">Invoice value</th>
                            <th style="width:10%">Pending Amount</th>
                        </tr>
                    </thead>
                    <tbody>';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement_new}} AS (SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)
UNION
(SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)';
        if ($ledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement_new}} order by industry_name,due_date,subledger_id')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            $industry=0;
            $industry_tot=0;
            $i=0;
            foreach ($items as $each) {
                $date1=date_create($each['due_date']);
                $date2=date_create($to_date);
                $diff=date_diff($date1,$date2);
                if($diff->format("%R%a")>0)
                {
                $over_due=$diff->format("%a");    
                }
                else {
                $over_due=0;     
                }
                if(round($each['balance'],2)!=0 && $over_due>0)
                {
                if($each['industry_name']!=$industry)
                {
                if($industry_tot!=0)
                {
                $table .= '<tr>
                            <td colspan="6" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(($industry_tot), " ") . '</b></td>
                        </tr>';
                }
                if($each['industry_name']>0)
                {
                $customer_industry=MasIndustry::model()->findByPk($each['industry_name'])->name;
                $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;"><b>'.$customer_industry.'</b></td>
                        </tr>';
                }
                $industry_tot=0;
                $industry=$each['industry_name'];
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $industry_tot+=-1*$each['balance'];
                        $i++;
                }
                else {
                if($i==0)
                {
                if($each['industry_name']>0)
                {
                $customer_industry=MasIndustry::model()->findByPk($each['industry_name'])->name;
                $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;"><b>'.$customer_industry.'</b></td>
                        </tr>';
                }
                else {
                $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;"><b></b></td>
                        </tr>';
                }
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                            <td class="text-right">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['balance']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $industry_tot+=-1*$each['balance'];    
                        $i++;
                }
                }
            }
            $table .= '<tr>
                            <td colspan="6" class="text-right"><b>Total</b></td>
                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(($industry_tot), " ") . '</b></td>
                        </tr>'; 
            $table .= '<tr>
                            <td colspan="6" class="text-right"><b>Grand Total</b></td>
                            <td class="text-right"><b>'.Yii::app()->numberFormatter->formatCurrency(($balanced), " ") . '</b></td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="7" style="text-align:center !important;">No Data</td>
                      </tr>';
        }
    }
        $table .= '</table>';
        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_customer_aging';
        $mpdf->WriteHTML($this->renderPartial($view, array('table' => $table, 'to_date' => $to_date, 'from_date' => $from_date, 'ledger_id' => $ledger_id, 'industry_id'=>$industry_id, 'lead_owner'=>$lead_owner), true));
        $mpdf->Output("Customer Ageing Report" . date("d-m-Y").".pdf", 'I');
    }
    
    public function actionCustomer_aging_excel()
    {

        $from_date = '2019-01-01';
        $to_date = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-d');

        $ledger_id = (int) $_REQUEST['ledger'];
        $industry_id = (int) $_REQUEST['industry'];
        $currency = (int) $_REQUEST['currency'];
        $type = (int) $_REQUEST['types'];
        $lead_owner = (int) $_REQUEST['lead_owner'];
        if($type==1)
        {
        $from_date=$to_date;
        $to_date=date('Y-m-d', strtotime($to_date . ' +15 days'));    
        }
        if($type==2)
        {
        $from_date=date('Y-m-d', strtotime($to_date . ' +15 days'));
        $to_date=date('Y-m-d', strtotime($to_date . ' +30 days'));    
        }
        
        if($lead_owner>0)
        {
        $condition=' AND S.lead_owner='.$lead_owner;    
        }
        else {
        $condition='';    
        }

        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=1;
        $currency_code=$cur->currency_code;
        $amountType = 'VI.amount < 0';
        $paidType = 'VI.amount > 0';
        if ($_REQUEST['type'] == 'customer') {
            $amountType = 'VI.amount > 0';
            $paidType = 'VI.amount < 0';
        }
    $table='<style>
        @page {
	margin-top: 1cm;
	margin-bottom: 3.6cm;
	margin-left: 1cm;
	margin-right: 1cm;
	header: html_myHeader;
	footer: html_myfooter;
	/*size: landscape;*/
	font-family:tahoma;
}
body {
	font-family:tahoma;
	color: #101010;
	font-size: 14px;
}
*{
	-moz-box-sizing: border-box;
	-webkit-box-sizing: border-box;
	box-sizing: border-box;
}

.col-1, .col-2, .col-3, .col-4, .col-5, .col-6, .col-7, .col-8, .col-9, .col-10, .col-11, .col-12 {
	float: left;
}
.col-12 {
	width: 100%;
}
.col-11 {
	width: 91.66666667%;
}
.col-10 {
	width: 83.33333333%;
}
.col-9 {
	width: 75%;
}
.col-8 {
	width: 66.66666667%;
}
.col-7 {
	width: 58.33333333%;
}
.col-6 {
	width: 50%;
}
.col-5 {
	width: 41.66666667%;
}
.col-4 {
	width: 33.33333333%;
}
.col-3 {
	width: 25%;
}
.col-2 {
	width: 16.66666667%;
}
.col-1 {
	width: 8.33333333%;
}
.offset-1 {
  margin-left: 8.33333%;
}

.offset-2 {
  margin-left: 16.66667%;
}

.offset-3 {
  margin-left: 25%;
}

.offset-4 {
  margin-left: 33.33333%;
}

.offset-5 {
  margin-left: 41.66667%;
}

.offset-6 {
  margin-left: 50%;
}

.offset-7 {
  margin-left: 58.33333%;
}

.offset-8 {
  margin-left: 66.66667%;
}

.offset-9 {
  margin-left: 75%;
}

.offset-10 {
  margin-left: 83.33333%;
}

.offset-11 {
  margin-left: 91.66667%;
}
.pad-15,.pad15{
	padding: 0 15px;
	box-sizing: border-box;
}
.row{
	margin-left: -15px;
	margin-right: -15px;
}
.clearfix{
	display: table;
	clear: both;
	width: 100%;
}
.text-left{
	text-align: left;
	text-align: left !important;
}
.text-right{
	text-align: right;
	text-align: right !important;
}
.text-center{
	text-align: center;
	text-align: center !important;
}
.heading{
	padding-bottom: 15px;
	border-bottom: 1px solid  #1f67b2;
}
.companay_name{
	padding-top: 15px;
	color: #101010;
}
.heading  .companay_name h3{
	margin: 0;
	padding: 0;
}
.heading .companay_name p{
	margin: 0;
	padding: 0;
}
.title h1{
	color: #101010;
	font-weight: normal;
	font-size: 22px;
}
.table {
	border-collapse: collapse !important;
	font-size: 12px;
	color: #101010;
	width: 100%;
}
.table thead th{
	background: #1f67b2;
	color: #Fff;
}
.table th,
.table td {
	border: 1px solid #1f67b2 !important;
	text-align: left;
	padding: 3px 6px;
}
.table th.text-left,
.table td.text-left{
	text-align: left;
	text-align: left !important;
}
.table th.text-right,
.table td.text-right{
	text-align: right;
	text-align: right !important;
}
.table th.text-center,
.table td.text-center{
	text-align: center;
	text-align: center !important;
}
.table tbody tr:nth-child(even){
	background: #f4fef3;
}
.table th.Table-Title,
.table td.Table-Title{
    padding:7px 6px !important;
    font-size:1.15rem;
    color:green;
    font-weight:500;
    text-transform:uppercase;
}
.table th.total,
.table td.total{
	background: #1f67b2;
	color: #Fff;
	font-size: 14px;
}
h5{
	margin-top:10px;
	margin-bottom: 3px;
}
.h5sub-details{
	font-size: 12px;
	white-space:pre-line;
}
.input-block{
	display: inline-block;
	padding: 5px 10px;
	background: #d4e9ff;
	border: 1px solid #1f67b2;
	border-radius: 4px;
	font-size:14px;
	margin-top:4px;
	margin-bottom:8px;
	width: 200px;
}
.h3{
	font-size: 16px;
	font-weight: bold;
}
.bc-tl{
	border-radius: 5px 0 0 0;
}
.bc-tr{
	border-radius: 0 5px 0 0;
}
.bc-bl{
	border-radius: 0 0 5px 0;
}
.bc-br{
	border-radius: 0 0 0 5px;
}
.box{
	padding: 10px;
	border: 1px solid #1f67b2;
	margin-top: 15px;
	border-radius: 5px;
	width: 50%;
}
.box h5{
	margin-top:0px;
	color: #00366e;
}
small{
	margin: 0;
	padding: 0;
}
</style>
';
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }
        if($industry_id>0)
        {
        $items = array();
        $table= '<table border=1>
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:10%">Subledger</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Over Due Days</th>
                            <th style="width:10%">Invoice value</th>
                        </tr>
                    </thead>
                    <tbody>';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement_new}} AS (SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)
UNION
(SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)';
        if ($ledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement_new}} where industry_name='.$industry_id.' order by subledger_id,due_date')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            $subledger_id=0;
            $subledger_tot=0;
            $i=0;
            foreach ($items as $each) {
                $date1=date_create($each['due_date']);
                $date2=date_create($to_date);
                $diff=date_diff($date1,$date2);
                if($diff->format("%R%a")>0)
                {
                $over_due=$diff->format("%a");    
                }
                else {
                $over_due=0;     
                }
                if(round($each['balance'],2)!=0 && $over_due>0)
                {
                if($each['subledger_id']!=$subledger_id)
                {
                if($i>0)
                {
                if($subledger_tot!=0)
                { 
                $table .= '<tr>
                            <td colspan="5" style="text-align: right;text-align: right !important;">
                            <b>Total</b>
                            </td>
                            <td style="text-align: right;text-align: right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($subledger_tot), " ") . '</b></td>
                        </tr>';
                }
                }
                $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;"><b>'.$each['subledger_name'].'</b></td>
                        </tr>';
                $subledger_tot=0;
                $subledger_id=$each['subledger_id'];
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align: right;text-align: right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $subledger_tot+=-1*$each['amount'];
                        $i++;
                }
                else {
                if($i==0)
                {
                $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;"><b>'.$each['subledger_name'].'</b></td>
                        </tr>';
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align:right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $subledger_tot+=-1*$each['amount'];
                        $i++;
                }
                }
            }
            $table .= '<tr>
                            <td colspan="5" style="text-align:right !important;"><b>Total</b></td>
                            <td style="text-align: right;text-align: right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($subledger_tot), " ") . '</b></td>
                        </tr>'; 
            $table .= '<tr>
                            <td colspan="5" style="text-align: right;text-align: right !important;"><b>Grand Total</b></td>
                            <td style="text-align: right;text-align: right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($amount), " ") . '</b></td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;">No Data</td>
                      </tr>';
        }    
        }
        else 
        {
        $items = array();
        $table='<table border=1>
                    <thead>
                        <tr>
                            <th style="width:10%">Date</th>
                            <th style="width:10%">Invoice No</th>
                            <th style="width:10%">Subledger</th>
                            <th style="width:10%">Due Date</th>
                            <th style="width:10%">Over Due Days</th>
                            <th style="width:10%">Invoice value</th>
                        </tr>
                    </thead>
                    <tbody>';
    $query = 'CREATE OR REPLACE VIEW {{finance_statement_new}} AS (SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
    ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
    ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)
UNION
(SELECT
    S.id AS subledger_id,
    S.description AS subledger_name,
    S.industry AS industry_name,
    V.id AS voucher_id,
    V.voucher_date AS voucher_date,
    V.due_date AS due_date,
    V.reference_no AS reference_no,
    VI.narration AS narration,
    VI.id AS voucher_item_id,
    V.voucher_no,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4)) AS amount,
    -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS allocated,
    -(ROUND(ABS(VI.amount*VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
FROM {{finance_voucher_items}} VI
LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
LEFT JOIN {{finance_subledger}} S ON S.id = VI.subledger_id
LEFT JOIN {{finance_allocation_items}} AI ON AI.voucher_item_id = VI.id
WHERE S.subledger_type_id=1 AND V.is_posted ="Y" AND V.due_date>="'.$from_date.'" AND V.due_date<="'.$to_date.'"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id.$condition. '
GROUP BY VI.id)';
        if ($ledger_id > 0) {
            Yii::app()->db->createCommand($query)->execute();
            $items = Yii::app()->db->createCommand('SELECT * FROM {{finance_statement_new}} order by industry_name,due_date,subledger_id')->queryAll();
        }
        $amount=0;
        $allocated=0;
        $balanced=0;
        $amount+=$opening_bal;
        $allocated+=0;
        $balanced+=$opening_bal;
        if (!empty($items)) {
            $industry=0;
            $industry_tot=0;
            $i=0;
            foreach ($items as $each) {
                $date1=date_create($each['due_date']);
                $date2=date_create($to_date);
                $diff=date_diff($date1,$date2);
                if($diff->format("%R%a")>0)
                {
                $over_due=$diff->format("%a");    
                }
                else {
                $over_due=0;     
                }
                if(round($each['balance'],2)!=0 && $over_due>0)
                {
                if($each['industry_name']!=$industry)
                {
                if($industry_tot!=0)
                {
                $table .= '<tr>
                            <td colspan="5" style="text-align: right;text-align: right !important;"><b>Total</b></td>
                            <td style="text-align: right;text-align: right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($industry_tot), " ") . '</b></td>
                        </tr>';
                }
                if($each['industry_name']>0)
                {
                $customer_industry=MasIndustry::model()->findByPk($each['industry_name'])->name;
                $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;"><b>'.$customer_industry.'</b></td>
                        </tr>';
                }
                $industry_tot=0;
                $industry=$each['industry_name'];
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align: right;text-align: right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $industry_tot+=-1*$each['amount'];
                        $i++;
                }
                else {
                if($i==0)
                {
                if($each['industry_name']>0)
                {
                $customer_industry=MasIndustry::model()->findByPk($each['industry_name'])->name;
                $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;"><b>'.$customer_industry.'</b></td>
                        </tr>';
                }
                else {
                $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;"><b></b></td>
                        </tr>';
                }
                }
                $table .= '<tr>
                            <td>' . date("d/m/Y", strtotime($each['voucher_date'])) . '</td>
                            <td>' . $each['voucher_no'] . '</td>
                            <td>' . $each['subledger_name'] . '</td>
                            <td>' . date("d/m/Y", strtotime($each['due_date'])) . '</td>
                            <td>' . $over_due . '</td>
                            <td style="text-align: right;text-align: right !important;">'.Yii::app()->numberFormatter->formatCurrency(-1*($each['amount']), " ") . '</td>
                        </tr>';
                        $amount+=-1*$each['amount'];
                        $allocated+=-1*$each['allocated'];
                        $balanced+=-1*$each['balance'];
                        $industry_tot+=-1*$each['amount'];    
                        $i++;
                }
                }
            }
            $table .= '<tr>
                            <td colspan="5" style="text-align: right;text-align: right !important;"><b>Total</b></td>
                            <td style="text-align: right;text-align: right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($industry_tot), " ") . '</b></td>
                        </tr>'; 
            $table .= '<tr>
                            <td colspan="5" style="text-align: right;text-align: right !important;"><b>Grand Total</b></td>
                            <td style="text-align: right;text-align: right !important;"><b>'.Yii::app()->numberFormatter->formatCurrency(($amount), " ") . '</b></td>
                        </tr>';
        } else {
            $table .= '<tr>
                            <td colspan="6" style="text-align:center !important;">No Data</td>
                      </tr>';
        }
    }
        $table .= '</table>';
        
        $filename = 'Customer Ageing Report' . date('dmYhis') . '.xls';
        
        header("Content-type: application/vnd.ms-excel");

        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");

        echo $table;

        Yii::app()->end();

        return;
}

    public function actionGl_report_cash()
    {
        $this->render('gl_cash_report');
    }
    public function actionGl_cash_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $employee = (int) $_POST['employee'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 't.amount != 0 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:20%" >Particular</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="3" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
                      <td></td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            if($each->amount!=0)
            {
            $table .= ' <tr  data-id="' . $parent . '" data-parent="">
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $particular . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';

            $eachItem = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.header_id="' . (int) $each->header_id . '" AND t.id != "' . (int) $each->id . '"', 'order' => 'parent.voucher_date ASC'));
            $child = $parent + 1;
            foreach ($eachItem as $eachLine) {

                $debit = ($eachLine->amount > 0) ? round(($eachLine->amount * $eachLine->exchange_rate), 2) : '';
                $credit = ($eachLine->amount < 0) ? round(abs($eachLine->amount * $eachLine->exchange_rate), 2) : '';

                $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
                $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

                $subledgerName = ($eachLine->subledger_id > 0) ? $eachLine->subledger->description : '';
                if($subledgerName!='')
                {
                $particular_in=$eachLine->ledger->description . ' / ' . $subledgerName;
                }
                else {
                $particular_in=$eachLine->ledger->description;    
                }
                $table .= ' <tr data-id="' . $child . '" data-parent="' . $parent . '">
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df">' . $particular_in . '</td>
                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                                    <td style="background-color:#d8f5df"></td>
                                    <td style="background-color:#d8f5df"><small>' . $eachLine->narration . '</small></td>
                            </tr>';
                $child++;
            }
            $parent = $child;
        }
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }

    public function actionGL_cash_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = (int) $_GET['currency'];
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        if((int)$currency==0)
        {
        $currency=1;    
        }
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger . ')';
            $ledger_details=FinanceLegder::model()->findByPk($ledger);
            $title=$ledger_details->description;
        }
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
            $subledger_details=FinanceSubledger::model()->findByPk($subledger);
            $title=$subledger_details->description;
        }
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("General Transaction Ledger Report")
            ->setSubject("General Transaction Ledger Report")
            ->setDescription("General Transaction Ledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("General Transaction Ledger Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('C11', 'Opening Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 12;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
//            $particular=$each->ledger->description;
//            if($each->subledger_id>0)
//            {
//            $particular.='-'.$each->subledger->description;
//            }
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="general_ledger.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }

    public function actionGL_cash_pdf()
    {

        $from_date = Yii::app()->request->getParam('from_date');
        $to_date = Yii::app()->request->getParam('to_date');
        $ledger = Yii::app()->request->getParam('ledger');
        $subledger = (int) Yii::app()->request->getParam('subledger');
        $brand = (int) Yii::app()->request->getParam('brand');
        $employee = (int) Yii::app()->request->getParam('employee');
        $currency = (int) Yii::app()->request->getParam('currency');
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'ledger' => $ledger,
            'subledger' => $subledger,
            'currency_code' => $currency_code,
            'exchange_rate' => $exchange_rate,
            'currency' => $currency,
            'brand' => $brand,
            'employee' => $employee
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_gl_cash_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("GLReport" . date("d-m-Y"), 'I');
    }
    public function actionBs_report_new()
    {
    $this->render('bs_report_new');
    }
    public function actionBs_html_new()
    {
        $brand = (int) $_POST['brand'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
    $this->renderPartial('html_bs_report_new', array('from_date'=>$from_date,'to_date'=>$to_date));
    }
    public function actionPdf_bs_report_new()
    {
        $brand = (int) $_POST['brand'];
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
                $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
        );
        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_bs_report_new';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("GLReport" . date("d-m-Y"), 'I');
    }
    
    public function actionPl_report_new()
    {
    $this->render('pl_report_new');
    }
    
    public function actionPl_html_new()
    {
        $brand = (int) $_POST['brand'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
    $this->renderPartial('html_pl_report_new', array('from_date'=>$from_date,'to_date'=>$to_date));
    }
    public function actionPdf_pl_report_new()
    {
        $brand = (int) $_POST['brand'];
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
                $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
        );
        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_pl_report_new';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("GLReport" . date("d-m-Y"), 'I');
    }
        public function actionPl_excel_new()
    {
        $brand = (int) $_GET['brand'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
$SQL1="CREATE OR REPLACE VIEW trial_balance AS (SELECT accounts.account_order,accounts.account_no,accounts.description,accounts.level,accounts.main_account_type,sum(ledger.amount*ledger.exchange_rate) AS amount,isParent FROM `erp_finance_voucher_items` as ledger left join `erp_finance_legder` as accounts on ledger.ledger_id=accounts.id INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE accounts.main_account_type='I' AND head.is_posted ='Y' AND head.voucher_date>='".$from_date."' AND head.voucher_date<='".$to_date."' group by accounts.account_no order by accounts.account_no) 
      UNION (select account_order,account_no,description,level,main_account_type,0 AS amount,isParent FROM erp_finance_legder where main_account_type='I')" ;
Yii::app()->db->createCommand($SQL1)->execute();
$SQL="select * from trial_balance group by account_no order by account_order";
        //We have 5 levels
        $table = '';
        $rowId = 2;

        // Create new PHPExcel object
        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Profit and Loss")
            ->setSubject("Profit and Loss")
            ->setDescription("Profit and Loss From ".date("Y-m-d",strtotime($from_date))." To " . date("Y-m-d",strtotime($to_date)))
            ->setKeywords("Profit and Loss")
            ->setCategory("Financial Report");

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);

        $content = $brand > 0 ? 'Profit and Loss for the Period ' . date('d/m/Y', strtotime($from_date)) . ' to ' . date('d/m/Y', strtotime($to_date)) . ' for Brand ' . $brandModel->description : 'Profit and Loss for the Period ' . date('d/m/Y', strtotime($from_date)) . ' to ' . date('d/m/Y', strtotime($to_date));
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', $content);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:C1');
        $excel->getActiveSheet()->getStyle('A1:C1')->getFont()->setBold(true)->setSize(15);
        
        $arr_sum_amount1 	= Yii::app()->db->createCommand($SQL)->queryAll();
        
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, 'ACCOUNT NO')
                ->setCellValue('B' . $rowId, 'ACCOUNT NAME')
                ->setCellValue('C' . $rowId, 'AMOUNT');
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => 'd9d9d9',
                ),
            ));
            $rowId++;
            
$tot_debit=0;
$tot_debit1=0;
$tot_credit=0;
$tot_credit1=0;

        foreach ($arr_sum_amount1 as $i=>$arr_sum_amount) {
            
    			$amount = "0.00";
                        $balance="0.00";
                        $balance1="0.00";
                        $credit="0.00";
                        $debit="0.00";
                        $credit1="0.00";
                        $debit1="0.00";
    			if($arr_sum_amount['amount']<0)
                        {
                            
    			$credit+= $arr_sum_amount['amount'];
                               
                        }
                        if($arr_sum_amount['amount']>0)
                        { 
                        $debit+= $arr_sum_amount['amount'];
                        }
            $balance=$debit+$credit;            
            $accountNo = $arr_sum_amount['account_no'];
            $accountName = $arr_sum_amount['description'];
                            
                switch($arr_sum_amount['level'])
                {
                case 1:
                
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(15);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 2:
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(14);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                    
                break;
                
                case 3:
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(13);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(13);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 4:    
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                

                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(12);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(12);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 5:
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(11);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(11);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                }
        }
                if($tot_credit>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
$cr=Yii::app()->numberFormatter->formatCurrency(abs($tot_credit),"").' '.$label;                    
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Total')
                ->setCellValue('C' . $rowId, $cr);
                $rowId++;
                
$liability_total=$tot_credit;

$SQL1="CREATE OR REPLACE VIEW trial_balance AS (SELECT accounts.account_order,accounts.account_no,accounts.description,accounts.level,accounts.main_account_type,sum(ledger.amount*ledger.exchange_rate) AS amount,isParent FROM `erp_finance_voucher_items` as ledger left join `erp_finance_legder` as accounts on ledger.ledger_id=accounts.id INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE accounts.main_account_type='E' AND head.is_posted ='Y' AND head.voucher_date>='".$from_date."' AND head.voucher_date<='".$to_date."' group by accounts.account_no order by accounts.account_no) 
      UNION (select account_order,account_no,description,level,main_account_type,0 AS amount,isParent FROM erp_finance_legder where main_account_type='E')" ;
Yii::app()->db->createCommand($SQL1)->execute();
$SQL="select * from trial_balance group by account_no order by account_order";


$arr_sum_amount1 	= Yii::app()->db->createCommand($SQL)->queryAll();


$tot_debit=0;
$tot_debit1=0;
$tot_credit=0;
$tot_credit1=0;
foreach($arr_sum_amount1 as $i=>$arr_sum_amount)
{
    			$amount = "0.00";
                        $balance="0.00";
                        $balance1="0.00";
                        $credit="0.00";
                        $debit="0.00";
                        $credit1="0.00";
                        $debit1="0.00";
    			if($arr_sum_amount['amount']<0)
                        {
                            
    			$credit+= $arr_sum_amount['amount'];
                               
                        }
                        if($arr_sum_amount['amount']>0)
                        { 
                        $debit+= $arr_sum_amount['amount'];
                        }
    		

                
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $balance=$credit+$debit;
                }
                
            $accountNo = $arr_sum_amount['account_no'];
            $accountName = $arr_sum_amount['description'];
                            
                switch($arr_sum_amount['level'])
                {
                case 1:
                
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(15);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 2:
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(14);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                    
                break;
                
                case 3:
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(13);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(13);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 4:    
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(12);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(12);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 5:
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(11);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(11);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                }
}
                
                if($tot_debit>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
$db=Yii::app()->numberFormatter->formatCurrency(abs($tot_debit),"").' '.$label;                    
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Total')
                ->setCellValue('C' . $rowId, $db);
                $rowId++;
                
$asset_total=$tot_debit;
$profit=$asset_total+$liability_total;
if($profit<=0)
{
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Profit')
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($profit),""));
                $rowId++;    
}
else {
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Loss')
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($profit),""));
                $rowId++;    
}
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                'startcolor' => array(
//                    'rgb' => 'bbbbc1',
//                ),
//            ));
//
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('A' . $rowId, 'Total')
//                ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($totalDebit), " "))
//                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($totalCredit), " "));
//            $rowId++;
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                'startcolor' => array(
//                    'rgb' => 'bbbbc1',
//                ),
//            ));
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('A' . $rowId, 'Total ' . $eachOne->description)
//                ->setCellValue('C' . $rowId, getSymbol($grandTotal, $eachOne->main_account_type) . Yii::app()->numberFormatter->formatCurrency(abs($grandTotal), " "));
//            $rowId++;
//
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('A' . $rowId, '')
//                ->setCellValue('C' . $rowId, '');
//            $rowId++;

//            if ($eachOne->main_account_type == 'E') {
//                $cost_of_goods_sold = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale') . ')')->queryScalar();
//                $grossProfit = $totals[0] + $cost_of_goods_sold;
//                $symbol = ($grossProfit < 0) ? '' : '(-)';
//
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                    'startcolor' => array(
//                        'rgb' => 'd1d6ff',
//                    ),
//                ));
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
//                $rowId++;
//                $netProfit = $totals[0] + $totals[1];
//                $symbol = ($netProfit < 0) ? '' : '(-)';
//
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                    'startcolor' => array(
//                        'rgb' => 'd1ebff',
//                    ),
//                ));
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
//            }
        

        $excel->getActiveSheet()->getStyle('B2:C' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="profit_and_loss.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
        public function actionBs_excel_new()
    {
        $brand = (int) $_GET['brand'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
$SQL1="CREATE OR REPLACE VIEW trial_balance AS (SELECT accounts.account_order,accounts.account_no,accounts.description,accounts.level,accounts.main_account_type,sum(ledger.amount*ledger.exchange_rate) AS amount,isParent FROM `erp_finance_voucher_items` as ledger left join `erp_finance_legder` as accounts on ledger.ledger_id=accounts.id INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE accounts.main_account_type='A' AND head.is_posted ='Y' AND head.voucher_date<='".$to_date."' group by accounts.account_no order by accounts.account_no) 
      UNION (select account_order,account_no,description,level,main_account_type,0 AS amount,isParent FROM erp_finance_legder where main_account_type='A')" ;
Yii::app()->db->createCommand($SQL1)->execute();
$SQL="select * from trial_balance group by account_no order by account_order";
        //We have 5 levels
        $table = '';
        $rowId = 2;

        // Create new PHPExcel object
        Yii::import('ext.PHPExcel.PHPExcel');

        $excel = new PHPExcel();

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Balance Sheet")
            ->setSubject("Balance Sheet")
            ->setDescription("Balance Sheet From ".date("Y-m-d",strtotime($from_date))." To " . date("Y-m-d",strtotime($to_date)))
            ->setKeywords("Balance Sheet")
            ->setCategory("Financial Report");

        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);

        $content = $brand > 0 ? 'Balance Sheet for the Period ' . date('d/m/Y', strtotime($from_date)) . ' to ' . date('d/m/Y', strtotime($to_date)) . ' for Brand ' . $brandModel->description : 'Balance Sheet for the Period ' . date('d/m/Y', strtotime($from_date)) . ' to ' . date('d/m/Y', strtotime($to_date));
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', $content);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:C1');
        $excel->getActiveSheet()->getStyle('A1:C1')->getFont()->setBold(true)->setSize(15);
        
        $arr_sum_amount1 	= Yii::app()->db->createCommand($SQL)->queryAll();
        
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, 'ACCOUNT NO')
                ->setCellValue('B' . $rowId, 'ACCOUNT NAME')
                ->setCellValue('C' . $rowId, 'AMOUNT');
            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
                'type' => PHPExcel_Style_Fill::FILL_SOLID,
                'startcolor' => array(
                    'rgb' => 'd9d9d9',
                ),
            ));
            $rowId++;
            
$tot_debit=0;
$tot_debit1=0;
$tot_credit=0;
$tot_credit1=0;

        foreach ($arr_sum_amount1 as $i=>$arr_sum_amount) {
            
    			$amount = "0.00";
                        $balance="0.00";
                        $balance1="0.00";
                        $credit="0.00";
                        $debit="0.00";
                        $credit1="0.00";
                        $debit1="0.00";
    			if($arr_sum_amount['amount']<0)
                        {
                            
    			$credit+= $arr_sum_amount['amount'];
                               
                        }
                        if($arr_sum_amount['amount']>0)
                        { 
                        $debit+= $arr_sum_amount['amount'];
                        }
            $balance=$debit+$credit;            
            $accountNo = $arr_sum_amount['account_no'];
            $accountName = $arr_sum_amount['description'];
                            
                switch($arr_sum_amount['level'])
                {
                case 1:
                
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(15);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 2:
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(14);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                    
                break;
                
                case 3:
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(13);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(13);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 4:    
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                

                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(12);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(12);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 5:
                    
                if($arr_sum_amount['main_account_type']=="A" || $arr_sum_amount['main_account_type']=="E")
                {
                $tot_debit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(11);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(11);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                }
        }
                if($tot_debit>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
$db=Yii::app()->numberFormatter->formatCurrency(abs($tot_debit),"").' '.$label;                    
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Total')
                ->setCellValue('C' . $rowId, $db);
                $rowId++;
                
$asset_total=$tot_debit;

$SQL1="CREATE OR REPLACE VIEW trial_balance AS (SELECT accounts.account_order,accounts.account_no,accounts.description,accounts.level,accounts.main_account_type,sum(ledger.amount*ledger.exchange_rate) AS amount,isParent FROM `erp_finance_voucher_items` as ledger left join `erp_finance_legder` as accounts on ledger.ledger_id=accounts.id INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE accounts.main_account_type='L' AND head.is_posted ='Y' AND head.voucher_date<='".$to_date."' group by accounts.account_no order by accounts.account_no) 
      UNION (select account_order,account_no,description,level,main_account_type,0 AS amount,isParent FROM erp_finance_legder where main_account_type='L')" ;
Yii::app()->db->createCommand($SQL1)->execute();
$SQL="select * from trial_balance group by account_no order by account_order";


$arr_sum_amount1 	= Yii::app()->db->createCommand($SQL)->queryAll();


$tot_debit=0;
$tot_debit1=0;
$tot_credit=0;
$tot_credit1=0;
foreach($arr_sum_amount1 as $i=>$arr_sum_amount)
{
    			$amount = "0.00";
                        $balance="0.00";
                        $balance1="0.00";
                        $credit="0.00";
                        $debit="0.00";
                        $credit1="0.00";
                        $debit1="0.00";
    			if($arr_sum_amount['amount']<0)
                        {
                            
    			$credit+= $arr_sum_amount['amount'];
                               
                        }
                        if($arr_sum_amount['amount']>0)
                        { 
                        $debit+= $arr_sum_amount['amount'];
                        }
    		

                
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $balance=$credit+$debit;
                }
                
            $accountNo = $arr_sum_amount['account_no'];
            $accountName = $arr_sum_amount['description'];
                            
                switch($arr_sum_amount['level'])
                {
                case 1:
                
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(15);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 2:
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(14);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                    
                break;
                
                case 3:
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(13);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(13);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 4:    
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(12);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(12);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                case 5:
                    
                if($arr_sum_amount['main_account_type']=="L" || $arr_sum_amount['main_account_type']=="I")
                {
                $tot_credit+=$balance;
                if($balance>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
                
                
                if($arr_sum_amount['isParent']=="Y" && $balance==0)
                {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(11);
                $amt='';    
                }
                else {
                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(false)->setSize(11);
                $amt=Yii::app()->numberFormatter->formatCurrency(abs($balance),"").' '.$label;    
                }
                $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId, $accountNo)
                ->setCellValue('B' . $rowId, $accountName)
                ->setCellValue('C' . $rowId, $amt);
                $rowId++;
                }
                
                break;
                
                }
}

                
$liability_total=$tot_credit;

                    $asset_total1=Yii::app()->db->createCommand("SELECT sum(ledger.amount*ledger.exchange_rate) AS amount FROM `erp_finance_voucher_items` as ledger left join `erp_finance_legder` as accounts on ledger.ledger_id=accounts.id INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE accounts.main_account_type='A' AND head.is_posted ='Y' AND head.voucher_date>='".$from_date."' AND head.voucher_date<='".$to_date."'")->queryScalar();
                    $liability_total1=Yii::app()->db->createCommand("SELECT sum(ledger.amount*ledger.exchange_rate) AS amount FROM `erp_finance_voucher_items` as ledger left join `erp_finance_legder` as accounts on ledger.ledger_id=accounts.id INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE accounts.main_account_type='L' AND head.is_posted ='Y' AND head.voucher_date>='".$from_date."' AND head.voucher_date<='".$to_date."'")->queryScalar();
                    $profit=$asset_total1+$liability_total1;
if($profit<=0)
{
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Loss')
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($profit),""));
                $rowId++;    
}
else {
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Profit')
                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($profit),""));
                $rowId++;    
}

         $tot_credit-=$profit;       
                if($tot_credit>0)
                {
                $label='Dr';
                }
                else {
                $label='Cr';    
                }
$cr=Yii::app()->numberFormatter->formatCurrency(abs($tot_credit),"").' '.$label;                    
$excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(15);
$excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $rowId,'')
                ->setCellValue('B' . $rowId, 'Total')
                ->setCellValue('C' . $rowId, $cr);
                $rowId++;
                
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                'startcolor' => array(
//                    'rgb' => 'bbbbc1',
//                ),
//            ));
//
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(14);
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('A' . $rowId, 'Total')
//                ->setCellValue('B' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($totalDebit), " "))
//                ->setCellValue('C' . $rowId, Yii::app()->numberFormatter->formatCurrency(abs($totalCredit), " "));
//            $rowId++;
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                'startcolor' => array(
//                    'rgb' => 'bbbbc1',
//                ),
//            ));
//            $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('A' . $rowId, 'Total ' . $eachOne->description)
//                ->setCellValue('C' . $rowId, getSymbol($grandTotal, $eachOne->main_account_type) . Yii::app()->numberFormatter->formatCurrency(abs($grandTotal), " "));
//            $rowId++;
//
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('A' . $rowId, '')
//                ->setCellValue('C' . $rowId, '');
//            $rowId++;

//            if ($eachOne->main_account_type == 'E') {
//                $cost_of_goods_sold = Yii::app()->db->createCommand('SELECT SUM(balance) AS balance FROM {{finance_profit_and_loss}} WHERE ledger_id IN (' . FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale') . ')')->queryScalar();
//                $grossProfit = $totals[0] + $cost_of_goods_sold;
//                $symbol = ($grossProfit < 0) ? '' : '(-)';
//
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                    'startcolor' => array(
//                        'rgb' => 'd1d6ff',
//                    ),
//                ));
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
//                $rowId++;
//                $netProfit = $totals[0] + $totals[1];
//                $symbol = ($netProfit < 0) ? '' : '(-)';
//
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFill()->applyFromArray(array(
//                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
//                    'startcolor' => array(
//                        'rgb' => 'd1ebff',
//                    ),
//                ));
//                $excel->getActiveSheet()->getStyle('A' . $rowId . ':C' . $rowId)->getFont()->setBold(true)->setSize(16);
//            }
        

        $excel->getActiveSheet()->getStyle('B2:C' . $rowId)->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="balance_sheet.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    
    public function actionCashflow_finance_report_pdf()
    {
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $condition = '(t.ledger_id=21) AND (amount<0 AND t.opening_cheque_cleared="N" AND parent.is_posted = "Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $total_debit=0;
        $total_credit=0;
         $fledger=new FinanceLegder();
                  $table = '<table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable">
                  <thead>
                      <tr>
                        <th style="width:80%" >Details</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Income (' . $fledger->baseCurrency() . ')</th>
                        <th style="width:10%;text-align:right !important;" class="text-right">Expense (' . $fledger->baseCurrency() . ')</th>
                      </tr>
                  </thead>
                  <tbody>';
                  //OUTGOING
                  $pdci_id=FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
                  $pdcr_id=FinanceSystemAccountsMapping::getSystemdefault('pdc_r');
                  $cash_id=FinanceSystemAccountsMapping::getSystemdefault('cash_account');
                  $debtors_id=FinanceSystemAccountsMapping::getSystemdefault('debtors');
                  $creditors_id=FinanceSystemAccountsMapping::getSystemdefault('creditors');
                  $bank_id=FinanceSystemAccountsMapping::getSystemdefault('bank');
                  $condition = '(I.ledger_id='.$pdci_id.') AND (I.amount<0 AND I.opening_cheque_cleared="N" AND H.is_posted = "Y" AND H.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $pdc_i=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition)->queryScalar();
                  $condition1 = '(I.ledger_id='.$cash_id.') AND (I.amount<0 AND H.is_posted = "Y" AND H.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $table.= '<tr bgcolor="#ffcccc"><td>Issued Cheques</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($pdc_i), " ") . '</td>
                  </tr>';
                  $creditors=Yii::app()->db->createCommand('SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE H.is_posted="Y" AND I.ledger_id='.$creditors_id.' AND H.due_date<="'. $to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Creditors</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($creditors), " ") . '</td>
                  </tr>';
                  $cash_out=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition1)->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Cash Payables</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($cash_out), " ") . '</td>
                  </tr>';
                  $total_debit+=abs($cash_out);
                  $total_debit+=abs($pdc_i);
                  $purchase_order=Yii::app()->db->createCommand('select SUM(stock_grand_total*exchange_rate) from erp_purchasing_order O INNER JOIN erp_master_file M ON O.file_id=M.id where M.current_process_status="P_O" AND expected_delivery_date>="'.$from_date.'" AND expected_delivery_date<="'.$to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ffcccc"><td>Purchase Order</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($purchase_order), " ") . '</td>
                  </tr>';
                  $total_debit+=abs($purchase_order);
                  //$wps_value1=EmployeeSalary::getemployeesmonthlysalary(1,date("m",strtotime($from_date)),date("Y",strtotime($from_date)));
                  //$wps_value2=EmployeeSalary::getemployeesmonthlysalary(3,date("m",strtotime($from_date)),date("Y",strtotime($from_date)));
                  $wps_value=$wps_value1+$wps_value2;
                  $table.= '<tr bgcolor="#ffcccc"><td>Fixed Salaries</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($wps_value, " ") . '</td></tr>';
                  $total_debit+=$wps_value;
                  $expenses=EmiCategory::model()->findAll(array('condition'=>'type="E"'));
                  foreach($expenses as $eachExp)
                  {
                    $exp_value=0;
                    $exp_value=FinanceEmiInstallment::TotalEmi($from_date,$to_date,$eachExp->id);
                    $table.= '<tr bgcolor="#ffcccc"><td>'.$eachExp->name.'</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($exp_value, " ") . '</td></tr>';
                    $total_debit+=$exp_value;
                  }
                  //INCOMING
                  $condition2 = '(I.ledger_id='.$pdcr_id.') AND (I.opening_cheque_cleared="N" AND H.is_posted = "Y" AND H.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '")';
                  $pdc_r=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition2)->queryScalar();
                  $condition3 = '(I.ledger_id='.$cash_id.') AND (H.is_posted = "Y" AND H.voucher_date <="' . $to_date . '")';
                  $cash_in=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition3)->queryScalar();
                  $table.= '<tr bgcolor="#ccffeb"><td>Received Cheques</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($pdc_r, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                  $debitors=Yii::app()->db->createCommand('SELECT SUM(amount) FROM `erp_finance_voucher_head` H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE H.is_posted="Y" AND I.ledger_id='.$debtors_id.' AND H.due_date<="'. $to_date.'"')->queryScalar();
                  $table.= '<tr bgcolor="#ccffeb"><td>Debtors</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($debitors), " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td>
                  </tr>';
                  $table.= '<tr bgcolor="#ccffeb"><td>Cash In Hand</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($cash_in, " ") . '</td>
                  <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                  $total_credit+=$cash_in;
                  $total_credit+=$pdc_r;
                  $income=EmiCategory::model()->findAll(array('condition'=>'type="I"'));
                  foreach($income as $eachIncome)
                  {
                    $inc_value=0;
                    $inc_value=FinanceEmiInstallment::TotalEmi($from_date,$to_date,$eachIncome->id);
                    $table.= '<tr bgcolor="#ccffeb"><td>'.$eachIncome->name.'</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($inc_value, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                    $total_credit+=$inc_value;
                  }
                  $bank=FinanceLegder::model()->findByPk($bank_id);
                  $bank_subledgers=FinanceSubledger::model()->findAll(array('condition'=>'subledger_type_id IN ('.$bank->subledger_types.')'));
                  foreach($bank_subledgers as $eachSubledger)
                  {
                    $condition4='';
                    $condition4 = '(I.ledger_id='.$bank_id.' AND I.subledger_id='.$eachSubledger->id.') AND (H.is_posted = "Y" AND H.voucher_date <="' . $to_date . '")';
                    $bank=Yii::app()->db->createCommand('select SUM(amount*exchange_rate) from erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id where '.$condition4)->queryScalar();
                    $table.= '<tr bgcolor="#ccffeb"><td>'.$eachSubledger->description.'</td><td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($bank, " ") . '</td>
                    <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(0, " ") . '</td></tr>';
                    $total_credit+=$bank;
                  }
        $table .= '<tr>
                      <th style="text-align:right !important;"><b>Total</b></th>
                      <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></th>
                      <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></th>
                  </tr>';
        $table .= '<tr>
                  <th colspan="2" style="text-align:right !important;"><b>Difference</b></th>
                  <th style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit)-abs($total_debit), " ") . '</b></th>
              </tr>';
        $table .= '</tbody>
              </table>';
//        echo $table;
                $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'table' => $table,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_cashflow_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("CashFlowReport" . date("d-m-Y"), 'I');
    }
        public function actionVehicle_report_pdf()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_REQUEST['ledger_id'];
        $subledger = (int) $_REQUEST['subledger_id'];
        $brand = (int) $_REQUEST['brand'];
        $employee = (int) $_REQUEST['employee'];
        $currency = (int) $_REQUEST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');

        $condition = 't.amount>0 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'I.amount>0 AND H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:20%" >Subledger</th>
                        <th style="width:40%">Narration</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Amount</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="5" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $vouchreformat = $each->parent->fullvoucher;
            $table .= ' <tr  data-id="' . $parent . '" data-parent="">
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td>' . $subledgerName . '</td>
                          <td><small>' . $each->narration . '</small></td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                      </tr>';
            $parent = $child;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="5" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td></tr>';
//        $table .= '<tr>
//                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
//                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
//                      <td></td>
//                  </tr>';
        $table .= '</tbody>
              </table>';
       
                $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'subledger' => $subledger,
            'table' => $table,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_vehicle_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("VehicleReport" . date("d-m-Y"), 'I');
    }
    public function actionSubledger_detail_report_pdf()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_REQUEST['ledger_id'];
        $subledger = (int) $_REQUEST['subledger'];
        $brand = (int) $_REQUEST['brand'];
        $employee = (int) $_REQUEST['employee'];
        $currency = (int) $_REQUEST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_REQUEST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-t');

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
                $tax=$inv->$vat_field;
                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
            } else if ($code == 'PI') {
                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'DN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else if ($code == 'CN') {
                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
            } else {
                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
            }
            return $url;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                  <thead>
                      <tr>
                        <th style="width:7%" >Date</th>
                        <th style="width:5%" >VO #</th>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:20%" >Subledger</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                        <th style="width:40%">Narration</th>
                      </tr>
                  </thead>
                  <tbody>
                  <tr>
                      <td colspan="4" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
                      <td></td>
                  </tr>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $vouchreformat = $each->parent->fullvoucher;
            $table .= ' <tr  data-id="' . $parent . '" data-parent="">
                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                          <td>' . $vouchreformat . '</td>
                          <td>' . $each->ledger->description . '</td>
                          <td>' . $subledgerName . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                          <td><small>' . $each->narration . '</small></td>
                      </tr>';
            $parent = $child;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '</tbody>
              </table>';
           
                $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'subledger' => $subledger,
            'table' => $table,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_subledger_detailed_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("SubledgerDetailedReport" . date("d-m-Y"), 'I');
    }
    
    public function actionSubledger_report_pdf()
    {
        $subledger_id = (int) $_REQUEST['subledger'];
        $from_date = (count(explode('/', $_REQUEST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from_date']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-d');

        if ($subledger_id > 0) {
            Yii::app()->db->createCommand('CREATE OR REPLACE VIEW {{finance_subledger_summary}} AS SELECT
                                            L.main_account_type,
                                            L.description ,
                                            ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS balance
                                        FROM erp_finance_voucher_items VI
                                        LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                                        LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
                                        LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
                                        WHERE VH.is_posted="Y" AND VH.voucher_date >= "' . $from_date . '" AND VH.voucher_date <= "' . $to_date . '" AND subledger_id=' . $subledger_id . '
                                        GROUP BY L.id
                                        ORDER BY L.main_account_type ASC')->execute();
        }

        $items = $subledger_id > 0 ? Yii::app()->db->createCommand('SELECT main_account_type FROM {{finance_subledger_summary}} GROUP BY main_account_type')->queryAll() : array();

 $fledger=new FinanceLegder();
        $table = '<table class="table table-hover table-fixed table-bordered">
                    <thead>
                        <tr>
                            <th style="width:50%">Ledger</th>
                            <th style="width:50%;text-align:right !important;">Closing Balance (' . $fledger->baseCurrency() . ')</th>
                        </tr>
                    </thead>
                    <tbody>';
        $labels = array('A' => 'Assets', 'L' => 'Liability', 'I' => 'Income', 'E' => 'Expense');
        if (!empty($items)) {
            foreach ($items as $each) {
                $table .= '<tr> <td colspan="2"><b>' . $labels[$each['main_account_type']] . '</b></td> </tr>';

                foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_subledger_summary}} WHERE main_account_type="' . $each['main_account_type'] . '"')->queryAll() as $eachItem) {
                    $suffix = $eachItem['balance'] > 0 ? ' Dr' : ' Cr';
                    $table .= '<tr>
                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachItem['description'] . '</td>
                                        <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($eachItem['balance']), " ") . $suffix . '</td>
                                </tr>';
                }
            }
        } else {
            $table .= '<tr>
                            <td colspan="2" class="text-center">No Data</td>
                        </tr>';
        }

        $table .= '</tbody>
                </table>';
        
                $param = array(
            'from_date' => $from_date,
            'to_date' => $to_date,
            'subledger' => $subledger,
            'table' => $table,
        );

        $mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);
        $view = 'pdf_subledger_summary_report';
        $mpdf->WriteHTML($this->renderPartial($view, $param, true));
        $mpdf->Output("SubledgerSummaryReport" . date("d-m-Y"), 'I');
    }
    
    public function actionVehicle_report_excel()
    {
        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_REQUEST['ledger'];
        $subledger = (int) $_REQUEST['subledger_id'];
        $from_date = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');

        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }
        $brand = (int) $_GET['brand'];
        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.subledger_id=' . $brand;
        }

        $openingBalance = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' AND amount > 0')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date'));

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;
        $total_debit+=$openingBalance;
        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Vehicle Report")
            ->setSubject("Vehicle Report")
            ->setDescription("Vehicle  Report Generated on " . date('d/m/Y'))
            ->setKeywords("Vehicle Report")
            ->setCategory("Financial Report");

        // Add some data
         $fledger=new FinanceLegder();

        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Date')
            ->setCellValue('B1', 'Voucher')
            ->setCellValue('C1', 'Ledger')
            ->setCellValue('D1', 'Subledger')
            ->setCellValue('E1', 'Narration')
            ->setCellValue('F1', 'Amount (' . $fledger->baseCurrency() . ')')
            ->setCellValue('E2', 'Beginning Balance');

        //Opening Balance

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('F2', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } 
        //Data Items
        $parent = 3;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';

            $excel->getActiveSheet()->getStyle('A1:H1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $each->ledger->description)
                ->setCellValue('D' . $parent, $subledgerName)
                ->setCellValue('E' . $parent, $each->narration)
                ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency($debit, " "));
            $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':F' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':D' . $parent);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        // Rename worksheet
        $excel->getActiveSheet()->setTitle('Vehicle Report');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;

        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:F' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="vehicle_report.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
        
    public function actionSubledger_detail_report_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = (int) $_GET['currency'];
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
            $subledger_details=FinanceSubledger::model()->findByPk($subledger);
            $title=$subledger_details->description;
        }
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("General Transaction Ledger Report")
            ->setSubject("General Transaction Ledger Report")
            ->setDescription("General Transaction Ledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("General Transaction Ledger Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('C11', 'Opening Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '0';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '0';
        $parent = 12;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
//            $particular=$each->ledger->description;
//            if($each->subledger_id>0)
//            {
//            $particular.='-'.$each->subledger->description;
//            }
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="general_ledger.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    public function actionSubledger_report_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_REQUEST['ledger'];
        $subledger_id = (int) $_REQUEST['subledger'];
        $from_date = (count(explode('/', $_REQUEST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_REQUEST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to_date']))) : date('Y-m-t');
        $currency = (int) $_GET['currency'];
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
            $subledger_details=FinanceSubledger::model()->findByPk($subledger);
            $title=$subledger_details->description;
        }
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

       if ($subledger_id > 0) {
            Yii::app()->db->createCommand('CREATE OR REPLACE VIEW {{finance_subledger_summary}} AS SELECT
                                            L.main_account_type,
                                            L.description ,
                                            ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS balance
                                        FROM erp_finance_voucher_items VI
                                        LEFT JOIN {{finance_voucher_head}} VH ON VH.id = VI.header_id
                                        LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
                                        LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
                                        WHERE VH.is_posted="Y" AND VH.voucher_date >= "' . $from_date . '" AND VH.voucher_date <= "' . $to_date . '" AND subledger_id=' . $subledger_id . '
                                        GROUP BY L.id
                                        ORDER BY L.main_account_type ASC')->execute();
        }

        $items = $subledger_id > 0 ? Yii::app()->db->createCommand('SELECT main_account_type FROM {{finance_subledger_summary}} GROUP BY main_account_type')->queryAll() : array();
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("General Transaction Ledger Report")
            ->setSubject("General Transaction Ledger Report")
            ->setDescription("General Transaction Ledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("General Transaction Ledger Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:B1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:B1');
        $excel->getActiveSheet(0)->setCellValue('A1', $settings->company_name);
        
        $excel->getActiveSheet()->getStyle('A2:B2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:B2');
        $excel->getActiveSheet(0)->setCellValue('A2', $settings->company_name);
        $excel->getActiveSheet(0)->setCellValue('A2', 'Date From '. date('d-m-Y',strtotime($from_date)).' To '.date('d-m-Y',strtotime($to_date)));
        
//        $table = '<table class="table table-hover table-fixed table-bordered">
//                    <thead>
//                        <tr>
//                            <th style="width:50%">Ledger</th>
//                            <th style="width:50%;text-align:right !important;">Closing Balance (' . FinanceLegder::baseCurrency() . ')</th>
//                        </tr>
//                    </thead>
//                    <tbody>';
        $excel->getActiveSheet()->getStyle('A3:B3')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A3','Ledger')
                ->setCellValue('B3','Amount');
        $parent=4;
        $labels = array('A' => 'Assets', 'L' => 'Liability', 'I' => 'Income', 'E' => 'Expense');
        if (!empty($items)) {
            foreach ($items as $each) {
                $parent++;
//                $table .= '<tr> <td colspan="2"><b>' . $labels[$each['main_account_type']] . '</b></td> </tr>';
            $excel->getActiveSheet()->getStyle('A'.$parent.':B'.$parent)->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)->mergeCells('A'.$parent.':B'.$parent);
            $type=$labels[$each['main_account_type']];
            $excel->setActiveSheetIndex(0)
//                ->setCellValue('A' . $parent, $type);
            ->setCellValue('A' . $parent,$type);
                $parent++;
                foreach (Yii::app()->db->createCommand('SELECT * FROM {{finance_subledger_summary}} WHERE main_account_type="' . $each['main_account_type'] . '"')->queryAll() as $eachItem) {
                    $suffix = $eachItem['balance'] > 0 ? ' Dr' : ' Cr';
//                    $table .= '<tr>
//                                        <td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $eachItem['description'] . '</td>
//                                        <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($eachItem['balance']), " ") . $suffix . '</td>
//                                </tr>';
                    $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, $eachItem['description'])
                ->setCellValue('B' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($eachItem['balance']), " ") . $suffix);
                $parent++;
                }
            }
        }
        // Rename worksheet
        $excel->getActiveSheet()->setTitle('Subledger Summary');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:B' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="subledger_summary.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    
    public function actionGl_cost_summary_html()
    {
        $ledger = (int) $_POST['ledger_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $brand = (int) $_POST['brand'];
        $condition = 'VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date <= "' . $to_date . '"';
//        if ($brand > 0) {
//            $condition .= ' AND VI.brand_id=' . $brand;
//        }

        $glSummaryquery = 'CREATE OR REPLACE VIEW {{finance_gl_summary}} AS SELECT
                                SL.id AS subledger_id,
								SL.account_no AS subledger_no,
								VI.generic_id,
                                ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                L.id AS ledger_id,VI.subledger_id AS voucher_sub_id
							FROM {{finance_voucher_items}} VI
							LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
							LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
							LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
							WHERE ' . $condition . '
							GROUP BY  VI.generic_id';
        Yii::app()->db->createCommand($glSummaryquery)->execute();

        $summaryItems = Yii::app()->db->createCommand('SELECT * FROM {{finance_gl_summary}} WHERE balance != 0 ORDER BY generic_id desc')->queryAll();

        $table = '<table class="table table-hover table-fixed table-bordered">
                    <thead>
                        <tr>
                            <th style="width:10%" >#</th>
                            <th style="width:30%" >Particular</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Debit</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Credit</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Balance</th>
                        </tr>
                    </thead>
                    <tbody>';

        $totalDebit = $totalCredit = 0;
        $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);

        foreach ($summaryItems as $each) {
            // $debit = ($each['balance'] > 0) ? $each['balance'] : '';
            // $credit = ($each['balance'] < 0) ? abs($each['balance']) : '';
            if($each['generic_id']>0)
            {
            $debit = $each['debit'];
            $credit = $each['credit'];
            $balance = $each['debit']-$each['credit'];
            $totalDebit += $debit;
            $totalCredit += $credit;
            $generic=MasGeneric::model()->findByPk($each['generic_id']);
            $count=Yii::app()->db->createCommand("SELECT count(*) FROM `erp_finance_voucher_items` as ledger INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE ledger.ledger_id='".$each['ledger_id']."' AND ledger.subledger_id='".$each['subledger_id']."' AND head.is_posted ='Y' AND head.voucher_date>='".$from_date."' AND head.voucher_date<='".$to_date."'")->queryScalar();
//            if($count<50)
//            {
            $genericName = '<a href="#" onclick="js:load_gl_cost_report(' . $each['ledger_id'] . ', ' . $each['generic_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $generic->generic_name . '</a>';
//            }
//            else {
//            $subledgerName = '<a href="#" onclick="js:load_gl_report_excel(' . $each['ledger_id'] . ', ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';  
//            }
            $table .= '  <tr>
                            <td>' . $generic->id . '</td>
                            <td>' . $genericName . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($balance, " ") . '</td>
                        </tr>';
            }
        }

        $table .= ' <tr>
                        <td colspan="2" style="text-align:right !important;"><b>Total</b></td>
                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($totalDebit, " ") . '</b></td>
                        <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($totalCredit, " ") . '</b></td>
                        <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($totalDebit-$totalCredit, " ") . '</b></td>
                    </tr>';

        $balance = $totalDebit - $totalCredit;
        $debitBalance = ($balance > 0) ? $balance : 0;
        $creditBalance = ($balance <= 0) ? abs($balance) : 0;

        $table .= '<tr>
                        <td colspan="2"style="text-align:right !important;"><b>Balance</b></td>
                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($debitBalance, " ") . '</b></td>
                        <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($creditBalance, " ") . '</b></td>
                    </tr>';
        $table .= '</tbody>
            </table>';
        echo $table;
    }
        
    public function actionGl_cost_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $generic_id = (int) $_POST['generic_id'];
        $brand = (int) $_POST['brand'];
        $employee = (int) $_POST['employee'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 't.amount != 0 AND parent.is_posted = "Y" AND parent.voucher_date <="' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($generic_id > 0) {
            $condition .= ' AND t.generic_id=' . $generic_id;
            $condition_for_opening .= ' AND I.generic_id=' . $generic_id;
        }

//        if ($brand > 0) {
//            $condition .= ' AND t.brand_id=' . $brand;
//            $condition_for_opening .= ' AND I.brand_id=' . $brand;
//        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

//        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $items = Yii::app()->db->createCommand('SELECT product_id,ROUND((SUM(t.exchange_rate*t.amount)), 4) AS amount FROM {{finance_voucher_items}} t LEFT JOIN {{finance_voucher_head}} parent ON t.header_id = parent.id WHERE '. $condition.' group by product_id')->queryAll();
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
                  <thead>
                      <tr>
                        <th style="width:10%" >Ledger</th>
                        <th style="width:20%" >Generic</th>
                        <th style="width:20%" >Product</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
                      </tr>
                  </thead>
                  <tbody>';
                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 1;
        foreach ($items as $each) {

            $debit = ($each['amount'] > 0) ? round(($each['amount']), 4) : '';
            $credit = ($each['amount'] < 0) ? round(abs($each['amount']), 4) : '';
            
//            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
//            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

//            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
//            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
            if($each['amount']!=0)
            {
            $ledger=FinanceLegder::model()->findByPk($ledger_id);
            $generic=MasGeneric::model()->findByPk($generic_id);
            $product=Store::model()->findByPk($each['product_id']);   
            $productName = '<a href="#" onclick="js:load_gl_cost_report_excel(' . $ledger_id . ', ' . $each['product_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $product->part_number.' | '.$product->description . '</a>';
            $table .= ' <tr>
                          <td>' . $ledger->description . '</td>
                          <td>' . $generic->generic_name . '</td>
                          <td>' . $productName . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
                      </tr>';

//            $eachItem = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.header_id="' . (int) $each->header_id . '" AND t.id != "' . (int) $each->id . '"', 'order' => 'parent.voucher_date ASC'));
//            $child = $parent + 1;
//            foreach ($eachItem as $eachLine) {
//
//                $debit = ($eachLine->amount > 0) ? round(($eachLine->amount * $eachLine->exchange_rate), 2) : '';
//                $credit = ($eachLine->amount < 0) ? round(abs($eachLine->amount * $eachLine->exchange_rate), 2) : '';
//
//                $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
//                $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;
//
//                $subledgerName = ($eachLine->subledger_id > 0) ? $eachLine->subledger->description : '';
//
//                $table .= ' <tr data-id="' . $child . '" data-parent="' . $parent . '">
//                                    <td style="background-color:#d8f5df"></td>
//                                    <td style="background-color:#d8f5df"></td>
//                                    <td style="background-color:#d8f5df">' . $eachLine->ledger->description . '</td>
//                                    <td style="background-color:#d8f5df">' . $subledgerName . '</td>
//                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
//                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
//                                    <td style="background-color:#d8f5df"></td>
//                                    <td style="background-color:#d8f5df"><small>' . $eachLine->narration . '</small></td>
//                            </tr>';
//                $child++;
//            }
            $parent = $child;
        }
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Total</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
                      <td></td>
                  </tr>';
        $table .= '<tr>
                      <td colspan="3" style="text-align:right !important;"><b>Closing Balance</b></td>
                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
                      
                  </tr>';
        $table .= '</tbody>
              </table>';
        echo $table;
    }
//    
//    public function actionGl_cost_html()
//    {
//        $ledgerItems = array();
//
//        $ledger_id = (int) $_POST['ledger_id'];
//        $generic_id = (int) $_POST['generic_id'];
//        $brand = (int) $_POST['brand'];
//        $employee = (int) $_POST['employee'];
//        $currency = (int) $_POST['currency'];
//        $cur=MasCurrency::model()->findByPk(1);
//        $exchange_rate=$cur->exchange_rate;
//        $currency_code=$cur->currency_code;
//        
//        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
//        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');
//
//        $condition = 't.amount != 0 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
//        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
//
//        if ($ledger_id > 0) {
//            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
//            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
//        }
//
//        if ($generic > 0) {
//            $condition .= ' AND t.generic_id=' . $generic;
//            $condition_for_opening .= ' AND I.generic_id=' . $generic;
//        }
//
//        if ($brand > 0) {
//            $condition .= ' AND t.brand_id=' . $brand;
//            $condition_for_opening .= ' AND I.brand_id=' . $brand;
//        }
//        
//        if ($employee > 0) {
//            $condition .= ' AND t.employee_id=' . $employee;
//            $condition_for_opening .= ' AND I.employee_id=' . $employee;
//        }
//        function generateUrl($childModel)
//        {
//            $url = '#';
//            $code = $childModel->parent->vtype->code;
//            if ($code == 'SI') {
//                $headModel = $childModel->parent->vtype->header_table;
//                $vat_field = $childModel->parent->vtype->vat_value;
//                $inv = $headModel::model()->findBypk($childModel->parent->header_table_id);
//                $tax=$inv->$vat_field;
//                $taxType = ($tax > 0) ? 'tax' : 'taxnil';
//                $hire = $inv->invoice_nature=='H' ? '&hiring=Y' : '';
//                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id .$hire."&frm=" . $taxType . "&type=1', '_blank');";
//            } else if ($code == 'PI') {
//                $url = "window.open($('#liveSite').val()+'index.php?r=purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->header_table_id . "', '_blank');";
//            } else if ($code == 'DN') {
//                $url = "window.open($('#liveSite').val()+'index.php?r=debitnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
//            } else if ($code == 'CN') {
//                $url = "window.open($('#liveSite').val()+'index.php?r=creditnote/printfile&id=" . $childModel->parent->header_table_id . "', '_blank');";
//            } else {
//                $url = "window.open($('#liveSite').val()+'index.php?r=finance/core/print&id=" . $childModel->header_id . "', '_blank');";
//            }
//            return $url;
//        }
//
//        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
//        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
//        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
//        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
//        $previousBalance = $openingBalance;
//        $closingBalance = $openingBalance;
//        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';
//
//        $total_debit = 0;
//        $total_credit = 0;
//
//        $table = '<table class="table table-hover table-fixed table-bordered" id="gl_table">
//                  <thead>
//                      <tr>
//                        <th style="width:7%" >Date</th>
//                        <th style="width:5%" >VO #</th>
//                        <th style="width:10%" >Ledger</th>
//                        <th style="width:20%" >Generic</th>
//                        <th style="width:20%" >Product</th>
//                        <th style="width:12%;text-align:right !important;" class="text-right">Debit</th>
//                        <th style="width:12%;text-align:right !important;" class="text-right">Credit</th>
//                        <th style="width:12%;text-align:right !important;" class="text-right">Balance</th>
//                        <th style="width:40%">Narration</th>
//                      </tr>
//                  </thead>
//                  <tbody>
//                  <tr>
//                      <td colspan="5" class="text-right" style="text-align:right !important;"><b>Opening Balance</b></td>
//                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance > 0) ? abs($previousBalance) : ''), " ") . '</td>
//                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency((($previousBalance < 0) ? abs($previousBalance) : ''), " ") . '</td>
//                      <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($previousBalance), " ") . ' ' . $symbol . '</td>
//                      <td></td>
//                  </tr>';
//                  $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
//                  $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
//        $parent = 1;
//        foreach ($items as $each) {
//
//            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
//            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
//            
//            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
//            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;
//
//            $running = $debit - $credit + $previousBalance;
//            $previousBalance = $running;
//            $symbol = ($running > 0) ? 'Dr' : 'Cr';
//            $closingBalance += ($debit - $credit);
//
//            $total_debit += $debit;
//            $total_credit += $credit;
//
//            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
//            $vouchreformat = '<a href="#" onclick="' . generateUrl($each) . '">' . $each->parent->fullvoucher . '</a>';
//            if($each->amount!=0)
//            {
//            $generic=MasGeneric::model()->findByPk($each->generic_id);
//            $product=Store::model()->findByPk($each->product_id);    
//            $table .= ' <tr>
//                          <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
//                          <td>' . $vouchreformat . '</td>
//                          <td>' . $each->ledger->description . '</td>
//                          <td>' . $generic->generic_name . '</td>
//                          <td>' . $product->description . '</td>
//                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
//                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
//                          <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol . '</td>
//                          <td><small>' . $each->narration . '</small></td>
//                      </tr>';
//
////            $eachItem = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 't.header_id="' . (int) $each->header_id . '" AND t.id != "' . (int) $each->id . '"', 'order' => 'parent.voucher_date ASC'));
////            $child = $parent + 1;
////            foreach ($eachItem as $eachLine) {
////
////                $debit = ($eachLine->amount > 0) ? round(($eachLine->amount * $eachLine->exchange_rate), 2) : '';
////                $credit = ($eachLine->amount < 0) ? round(abs($eachLine->amount * $eachLine->exchange_rate), 2) : '';
////
////                $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
////                $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;
////
////                $subledgerName = ($eachLine->subledger_id > 0) ? $eachLine->subledger->description : '';
////
////                $table .= ' <tr data-id="' . $child . '" data-parent="' . $parent . '">
////                                    <td style="background-color:#d8f5df"></td>
////                                    <td style="background-color:#d8f5df"></td>
////                                    <td style="background-color:#d8f5df">' . $eachLine->ledger->description . '</td>
////                                    <td style="background-color:#d8f5df">' . $subledgerName . '</td>
////                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
////                                    <td style="background-color:#d8f5df; text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
////                                    <td style="background-color:#d8f5df"></td>
////                                    <td style="background-color:#d8f5df"><small>' . $eachLine->narration . '</small></td>
////                            </tr>';
////                $child++;
////            }
//            $parent = $child;
//        }
//        }
//        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
//        $table .= '<tr>
//                      <td colspan="5" style="text-align:right !important;"><b>Total</b></td>
//                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " ") . '</b></td>
//                      <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " ") . '</b></td>
//                      <td></td>
//                      <td></td>
//                  </tr>';
//        $table .= '<tr>
//                      <td colspan="4" style="text-align:right !important;"><b>Closing Balance</b></td>
//                      <td colspan="3" style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol . '</b></td>
//                      <td></td>
//                  </tr>';
//        $table .= '</tbody>
//              </table>';
//        echo $table;
//    }
        public function actionGL_cost_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $product_id = (int) $_GET['product_id'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = (int) $_GET['currency'];
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        if((int)$currency==0)
        {
        $currency=1;    
        }
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger . ')';
            $ledger_details=FinanceLegder::model()->findByPk($ledger);
            $title=$ledger_details->description;
        }
        if ($product_id > 0) {
            $condition .= ' AND t.product_id=' . $product_id;
            $condition_for_opening .= ' AND I.product_id=' . $product_id;
            $product_details=Store::model()->findByPk($product_id);
            $title=$product_details->part_number.' | '.$product_details->description;
        }
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);

        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("General Transaction Ledger Report")
            ->setSubject("General Transaction Ledger Report")
            ->setDescription("General Transaction Ledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("General Transaction Ledger Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
        $excel->setActiveSheetIndex(0)
            ->setCellValue('C11', 'Opening Balance');

        if ($openingBalance > 0) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        } else {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 12;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
//            if($each->amount>0)
//            {
//            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
//            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
//            }
//            else if($each->amount<0)
//            {
//            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
//            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
//            }
            $particular=$each->ledger->description;
            if($each->subledger_id>0)
            {
            $particular.='-'.$each->subledger->description;
            }
            $particular=$title;
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="general_ledger.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    
    public function actionGl_summary_new_html()
    {
        $ledger = (int) $_POST['ledger_id'];
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-d');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-d');
        $brand = (int) $_POST['brand'];
        $condition = 'VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date <= "' . $to_date . '"';
        if ($brand > 0) {
            $condition .= ' AND VI.brand_id=' . $brand;
        }

        $glSummaryquery = 'CREATE OR REPLACE VIEW {{finance_gl_summary}} AS SELECT
                                SL.id AS subledger_id,
								SL.account_no AS subledger_no,
								IFNULL(SL.description, "No Subledger") AS subledger_name,
                                ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                L.id AS ledger_id,VI.subledger_id AS voucher_sub_id
							FROM {{finance_voucher_items}} VI
							LEFT JOIN {{finance_voucher_head}} V ON V.id = VI.header_id
							LEFT JOIN {{finance_legder}} L ON L.id = VI.ledger_id
							LEFT JOIN {{finance_subledger}} SL ON SL.id = VI.subledger_id
							WHERE ' . $condition . '
							GROUP BY  VI.ledger_id, VI.subledger_id';
        Yii::app()->db->createCommand($glSummaryquery)->execute();

        $summaryItems = Yii::app()->db->createCommand('SELECT * FROM {{finance_gl_summary}} WHERE balance != 0 ORDER BY subledger_name')->queryAll();

        $table = '<table class="table table-hover table-fixed table-bordered">
                    <thead>
                        <tr>
                            <th style="width:10%" >#</th>
                            <th style="width:30%" >Particular</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Debit</th>
                            <th style="width:15%;text-align:right !important;" class="text-right">Credit</th>
                        </tr>
                    </thead>
                    <tbody>';

        $totalDebit = $totalCredit = 0;
        $accountingPeriod = FinanceVoucherType::generateAccountingperiod($to_date);

        foreach ($summaryItems as $each) {
            // $debit = ($each['balance'] > 0) ? $each['balance'] : '';
            // $credit = ($each['balance'] < 0) ? abs($each['balance']) : '';

            $debit = $each['debit'];
            $credit = $each['credit'];

            $totalDebit += $debit;
            $totalCredit += $credit;
            $count=Yii::app()->db->createCommand("SELECT count(*) FROM `erp_finance_voucher_items` as ledger INNER JOIN erp_finance_voucher_head head ON head.id=ledger.header_id WHERE ledger.ledger_id='".$each['ledger_id']."' AND ledger.subledger_id='".$each['subledger_id']."' AND head.is_posted ='Y' AND head.voucher_date>='".$from_date."' AND head.voucher_date<='".$to_date."'")->queryScalar();
            if($count<50)
            {
            $subledgerName = '<a href="#" onclick="js:load_gl_report(' . $each['ledger_id'] . ', ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';
            }
            else {
            $subledgerName = '<a href="#" onclick="js:load_gl_report_excel(' . $each['ledger_id'] . ', ' . $each['subledger_id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');" >' . $each['subledger_name'] . '</a>';  
            }
            $table .= '  <tr>
                            <td>' . $each['subledger_no'] . '</td>
                            <td>' . $subledgerName . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($debit, " ") . '</td>
                            <td style="text-align:right !important;">' . Yii::app()->numberFormatter->formatCurrency($credit, " ") . '</td>
                        </tr>';
        }

        $table .= ' <tr>
                        <td colspan="2" style="text-align:right !important;"><b>Total</b></td>
                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($totalDebit, " ") . '</b></td>
                        <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($totalCredit, " ") . '</b></td>
                    </tr>';

        $balance = $totalDebit - $totalCredit;
        $debitBalance = ($balance > 0) ? $balance : 0;
        $creditBalance = ($balance <= 0) ? abs($balance) : 0;

        $table .= '<tr>
                        <td colspan="2"style="text-align:right !important;"><b>Balance</b></td>
                        <td style="text-align:right !important;"><b>' . Yii::app()->numberFormatter->formatCurrency($debitBalance, " ") . '</b></td>
                        <td style="text-align:right !important;"><b>' .Yii::app()->numberFormatter->formatCurrency($creditBalance, " ") . '</b></td>
                    </tr>';
        $table .= '</tbody>
            </table>';
        echo $table;
    }
    public function actionGL_cash_pl_excel()
    {

        Yii::import('ext.PHPExcel.PHPExcel');

        $ledger = $_GET['ledger'];
        $subledger = (int) $_GET['subledger'];
        $from_date = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-t');
        $currency = (int) $_GET['currency'];
        $brand = (int) $_GET['brand'];
        $employee = (int) $_GET['employee'];
        if((int)$currency==0)
        {
        $currency=1;    
        }
        $cur=MasCurrency::model()->findByPk($currency);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        $condition = 'parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        $title='';
        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger . ')';
            $ledger_details=FinanceLegder::model()->findByPk($ledger);
            $title=$ledger_details->description;
        }
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
            $subledger_details=FinanceSubledger::model()->findByPk($subledger);
            $title=$subledger_details->description;
        }
        
         if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{finance_voucher_items}} I LEFT JOIN {{finance_voucher_head}} H ON I.header_id = H.id WHERE I.currency_id!='.$currency.' AND '. $condition_for_opening . ' ')->queryScalar();
        $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));
        $openingBalance=$openingBalance1+($openingBalance2/$exchange_rate);
        $openingBalance=0;
        $previousBalance = $openingBalance;
        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        $total_debit = 0;
        $total_credit = 0;

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("General Transaction Ledger Report")
            ->setSubject("General Transaction Ledger Report")
            ->setDescription("General Transaction Ledger Report Generated on " . date('d/m/Y'))
            ->setKeywords("General Transaction Ledger Report")
            ->setCategory("Financial Report");

        // Add some data
        $settings = MasCompany::model()->findByPk(Yii::app()->user->master_user_company_id);
        $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A1:G1');
        $excel->getActiveSheet(0)
            ->setCellValue('A1', $settings->company_name);

        // $excel->getActiveSheet()->getStyle('A2:H2')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A2:G2');
        $excel->getActiveSheet(0)
                ->setCellValue('A2', $settings->billing_address);

        // $excel->getActiveSheet()->getStyle('A3:H3')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A3:G3');
        $excel->getActiveSheet(0)
                    ->setCellValue('A3','Emirate : '.$settings->billing_city);

        $excel->setActiveSheetIndex(0)->mergeCells('A4:G4');

        // $excel->getActiveSheet()->getStyle('A4:H4')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A5:G5');
        $excel->getActiveSheet(0)
                                ->setCellValue('A5','TRN : '.$settings->trn_no);

        $excel->getActiveSheet()->getStyle('A6:G6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A6:G6');
        $excel->getActiveSheet(0)
                                ->setCellValue('A6',$title);

        $date_title=date("d-m-Y", strtotime($from_date)).' TO '.date("d-m-Y", strtotime($to_date));
        // $excel->getActiveSheet()->getStyle('A6:H6')->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A7:G7');
        $excel->getActiveSheet(0)
                                ->setCellValue('A7',$date_title);
        $excel->setActiveSheetIndex(0)->mergeCells('A8:G8');
        $currency1='Currency : '.$currency_code;
        $excel->getActiveSheet(0)
                                ->setCellValue('A8',$currency1);
        $excel->setActiveSheetIndex(0)->mergeCells('A9:G9');

        $excel->getActiveSheet(0)
            ->setCellValue('A10', 'Date')
            ->setCellValue('B10', 'Voucher')
            ->setCellValue('C10', 'Particular')
            ->setCellValue('D10', 'Debit')
            ->setCellValue('E10', 'Credit')
            ->setCellValue('F10', 'Balance')
            ->setCellValue('G10', 'Narration');

        //Opening Balance
//        $excel->setActiveSheetIndex(0)
//            ->setCellValue('C11', 'Opening Balance');
//
//        if ($openingBalance > 0) {
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('D11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
//        } else {
//            $excel->setActiveSheetIndex(0)
//                ->setCellValue('E11', Yii::app()->numberFormatter->formatCurrency(abs($openingBalance), " "));
//        }
        //Data Items
        $total_debit += $previousBalance > 0 ? abs($previousBalance) : '';
        $total_credit += $previousBalance < 0 ? abs($previousBalance) : '';
        $parent = 12;
        foreach ($items as $each) {

            $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : '';
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : '';
            
            $debit= ($currency==$each->currency_id) ? $debit/$each->exchange_rate : $debit/$exchange_rate;
            $credit= ($currency==$each->currency_id) ? $credit/$each->exchange_rate : $credit/$exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;

            $subledgerName = ($each->subledger_id > 0) ? $each->subledger->description : '';
            $particular='';
            if($each->amount>0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount<0 AND header_id='.$each->header_id, 'order' => 'amount ASC')); 
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
            else if($each->amount<0)
            {
            $itemparticular = FinanceVoucherItems::model()->find(array('condition' => 'amount>0 AND header_id='.$each->header_id, 'order' => 'amount DESC'));
            $particular= ($itemparticular->subledger_id > 0) ? $itemparticular->subledger->description : $itemparticular->ledger->description;
            }
//            $particular=$each->ledger->description;
//            if($each->subledger_id>0)
//            {
//            $particular.='-'.$each->subledger->description;
//            }
            $excel->getActiveSheet()->getStyle('A1:G1')->getFont()->setBold(true)->setSize(12);
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date("d/m/Y", strtotime($each->parent->voucher_date)))
                ->setCellValue('B' . $parent, $each->parent->fullvoucher)
                ->setCellValue('C' . $parent, $particular)
                ->setCellValue('D' . $parent,  Yii::app()->numberFormatter->formatCurrency($debit, " "))
                ->setCellValue('E' . $parent,  Yii::app()->numberFormatter->formatCurrency($credit, " "))
                ->setCellValue('F' . $parent,  Yii::app()->numberFormatter->formatCurrency(abs($running), " ") . " " . $symbol)
                ->setCellValue('G' . $parent, $each->narration);
                $parent++;
        }
        $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Total')
            ->setCellValue('D' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_debit), " "))
            ->setCellValue('E' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($total_credit), " "));
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':C' . $parent);
        $excel->getActiveSheet()
            ->getStyle('D2:D' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('E2:E' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet()
            ->getStyle('F2:F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);

        // Rename worksheet
        $excel->getActiveSheet()->setTitle('General Ledger');

        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $excel->setActiveSheetIndex(0);
        $parent++;
        $excel->getActiveSheet()->getStyle('A' . $parent . ':G' . $parent)->getFont()->setBold(true)->setSize(12);
        $excel->setActiveSheetIndex(0)->mergeCells('A' . $parent . ':E' . $parent);
        $excel->getActiveSheet(0)
            ->getStyle('F' . $parent)
            ->getAlignment()
            ->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_RIGHT);
        $excel->getActiveSheet(0)
            ->setCellValue('A' . $parent, 'Closing Balance')
            ->setCellValue('F' . $parent, Yii::app()->numberFormatter->formatCurrency(abs($closingBalance), " ") . ' ' . $symbol);
        
        $styleArray = array(
            'borders' => array(
                'allborders' => array(
                    'style' => PHPExcel_Style_Border::BORDER_THIN,
                    'color' => array('argb' => '#1E1F20'),
                ),
            ),
        );

        $excel->getActiveSheet(0)->getStyle('A1:G' . $parent)->applyFromArray($styleArray);

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="general_ledger.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;
    }
    public function actionGl_cash_pl_html()
    {
        $ledgerItems = array();

        $ledger_id = (int) $_POST['ledger_id'];
        $subledger = (int) $_POST['subledger_id'];
        $brand = (int) $_POST['brand'];
        $employee = (int) $_POST['employee'];
        $currency = (int) $_POST['currency'];
        $cur=MasCurrency::model()->findByPk(1);
        $exchange_rate=$cur->exchange_rate;
        $currency_code=$cur->currency_code;
        
        $from_date = (count(explode('/', $_POST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to']))) : date('Y-m-t');

        $condition = 't.amount != 0 AND parent.is_posted = "Y" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';
        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';

        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        if ($brand > 0) {
            $condition .= ' AND t.brand_id=' . $brand;
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
        
        if ($employee > 0) {
            $condition .= ' AND t.employee_id=' . $employee;
            $condition_for_opening .= ' AND I.employee_id=' . $employee;
        }
        function generateUrl($childModel)
        {
            $url = '#';
            $code = $childModel->parent->vtype->code;
            if ($code == 'SI') {
                $headModel = $childModel->parent->vtype->header_table;
                $vat_field = $childModel->parent->vtype->vat_value;
                $inv = $headModel::model()->findBypk($childModel->paren