<?php

class CoreController extends Controller
{

    public function accessRules()
    {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'Getvouchers', 'Subledgers', 'Getsubledgerlist', 'Sublegdertypes', 'Ledgers', 'Getledgers', 'Createledger',
                    'Getaccountno', 'Saveledger', 'Systemmapping', 'Getsubledgers', 'Savemapping', 'Vouchersettings',
                    'Savevouchersettings', 'Importvouchers', 'Getimportvouchers', 'Savemodulevouchers', 'Footermapping', 'Savefootermapping',
                    'savesubledgertype', 'Newsubledger', 'Savesubledger', 'Importsystemsubledgers', 'Print', 'Havesubledger', 'Auditclosing',
                    'Closeyear_preaudit', 'Unlockyear_preaudit', 'Updateyear_finalaudit', 'Allocationlist', 'Getallocationlist', 'Deleteallocation',
                    'Printallocation', 'Migrate', 'Deleteledger', 'Deletesubledger', 'Getnarrations', 'Update_refs', 'build_due_sales', 'Build_due_purchase',
                    'Reconciliation', 'Getbalances', 'Get_unreconciled_vouchers', 'Savereconciliation', 'Reconciliationlist', 'Get_reconciliation_history',
                    'Printreconciliation', 'Deletereconciliation', 'Chequemanagement', 'Get_uncleared_pdc', 'Savecheques', 'Savechequesreturn',
                    'Export_vouchers', 'Post_unpost', 'Get_posted_unposted_vouchers', 'Updatestatus', 'Voucher_maintenance', 'Print_vouchers',
                    'Get_cleared_pdc','Chequestatuschange','Savechequesstatuschange','Bouncedchequestatuschange','Get_bounced_pdc','Savechequesstatuschangeresubmit',
                    'Chequemanagementnew','Get_uncleared_pdc_new','Savechequesnew','ImportsystemsubledgersType','PostExpenseVoucher','PostSingleReceiptVoucher','AccountSorting',
                    'EditAccountSortOrder','SaveAccountSortOrder','FetChchild','CostSalesVoucher','SalespriceInventorySalesVoucher','SalespriceServiceSalesVoucher',
                    'CostPurchaseVoucher','CostPurchaseReturnVoucher','CostSalesReturnVoucher','SalespriceSalesReturnVoucher','CostupdateSalesInvoice','Savemodulevouchers1'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionIndex()
    {
        $this->render('index');
    }

    public function actionGetvouchers()
    {
        //Subledger - Update
        // ALTER TABLE `erp_customer` ADD `subledger_added` ENUM('Y', 'N') NULL DEFAULT 'N' AFTER `updated_by`;
        // ALTER TABLE `erp_vendor` ADD `subledger_added` ENUM('Y', 'N') NOT NULL DEFAULT 'N' AFTER `updated_by`;

        //Currency Modification
        // ALTER TABLE `erp_finance_voucher_head` ADD `currency` INT NOT NULL AFTER `total_voucher_amount`, ADD `exchange_rate` DECIMAL(15,8) NOT NULL AFTER `currency`;
        // ALTER TABLE `erp_finance_voucher_head` CHANGE `currency` `currency` VARCHAR(45) NOT NULL;

        //Modify this Query
        // CREATE OR REPLACE VIEW erp_finance_voucher_head_list AS
        // SELECT VH.id AS id, VT.have_mappings, CONCAT(VT.code,'/',VH.voucher_no) AS voucher_no, VT.description AS voucher_type, VT.code, VT.id AS voucher_type_id, VH.voucher_date, VH.reference_no, VH.total_voucher_amount, VH.cheque_no, VH.cheque_date, VH.is_posted, VH.is_allocated, GROUP_CONCAT(DISTINCT SU.description SEPARATOR ",") AS subledger, GROUP_CONCAT(DISTINCT LE.description SEPARATOR ",") AS ledger, SUM( CASE WHEN VI.amount > 0 THEN ROUND((VI.amount*VI.exchange_rate), 2) ELSE 0 END) AS value, ABS(SUM(ROUND((VI.amount*VI.exchange_rate), 4))) AS balance
        // FROM erp_finance_voucher_items VI
        // LEFT JOIN erp_finance_voucher_head VH ON VH.id = VI.header_id
        // LEFT JOIN erp_finance_subledger SU ON SU.id = VI.subledger_id
        // LEFT JOIN erp_finance_legder LE ON LE.id = VI.ledger_id
        // LEFT JOIN erp_finance_voucher_type VT ON VT.id = VH.voucher_type GROUP BY VI.header_id ORDER BY VH.id

        //Reconciliation Query
        //ALTER TABLE `erp_finance_voucher_items` ADD `reconciled` ENUM('Y', 'N') NOT NULL DEFAULT 'N' AFTER `amount`;
        //ALTER TABLE `erp_finance_voucher_items` ADD `reconciled_date` DATE NOT NULL AFTER `reconciled`;
        //ALTER TABLE `erp_finance_voucher_head` ADD `general_narration` TEXT NOT NULL AFTER `reference_no`;
        //ALTER TABLE `erp_finance_voucher_items` ADD `opening_cheque_cleared` ENUM('Y', 'N') NOT NULL DEFAULT 'N' COMMENT 'only used to clear opening balance voucher' AFTER `reconciled_date`;
        //ALTER TABLE `erp_finance_voucher_items` ADD `reconciliation_id` INT NOT NULL AFTER `reconciled`;
        //ALTER TABLE `erp_finance_voucher_items` ADD INDEX(`reconciliation_id`);

        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $searchString = trim($_POST['search']['value']);
        $columns = array(
            // datatable column index  => database column name
            0 => 'voucher_no',
            1 => 'voucher_date',
            2 => 'ledger',
            3 => 'subledger',
            4 => 'reference_no',
            5 => 'value',
            6 => 'is_allocated',
            7 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $condition = 'code != "YC" AND voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

        if ($_POST['voucher_type'] > 0) {
            $condition .= ' AND voucher_type_id=' . $_POST['voucher_type'];
        }

        if ($_POST['posting_type'] != '') {
            $condition .= ' AND is_posted="' . $_POST['posting_type'] . '"';
        }

        if ($searchString != "") {
            if ($searchString != 'show_all_unbalanced') {
                $condition .= ' AND ( reference_no LIKE "%' . $searchString . '%" OR cheque_no LIKE "%' . $searchString . '%" OR voucher_no LIKE "%' . $searchString . '%" OR subledger LIKE "%' . $searchString . '%" OR ledger LIKE "%' . $searchString . '%" )';
            } else {
                $condition .= ' AND ( balance != 0 )';
            }

        }

        $model = Yii::app()->db->createCommand('SELECT * FROM {{finance_voucher_head_list}} WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset)->queryAll();
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) AS value FROM {{finance_voucher_head_list}} WHERE ' . $condition)->queryScalar();

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();

        foreach ($model as $eachItem) {

            $div = '<div class="btn-wrap text-center">';
            if ($eachItem['have_mappings'] == 'N' && $eachItem['is_posted'] == "N") {
                if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_voucher_add"] ) 
                    $div .= ' <button class="btn btn-primary btn-xs" title ="Edit Voucher" onclick="loadPopupModal(\'finance/vouchers/create&id=' . $eachItem['id'] . '\',\'' . $eachItem['voucher_no'] . '\',\'xl\')"><i class="fa fa-pencil"></i></button>';
                if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_post_voucher"] )  
                    $div .= ' <button class="btn btn-primary btn-xs" title ="Post Voucher" onclick="updatevoucher(' . $eachItem['id'] . ',1)"><i class="fa fa-send"></i></button>';
                if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_voucher_delete"] ) 
                    $div .= ' <button class="btn btn-primary btn-xs" title ="Delete Voucher" onclick="updatevoucher(' . $eachItem['id'] . ',2)"><i class="fa fa-trash"></i></button>';
            } else if ($eachItem['have_mappings'] == 'N' && $eachItem['is_posted'] == "Y") {
                if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_unpost_voucher"] )  
                    $div .= ' <button class="btn btn-primary btn-xs" title ="Unpost Voucher" onclick="updatevoucher(' . $eachItem['id'] . ',0)"><i class="fa fa-remove"></i></button>';
            }
            if( Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_print_voucher"] )  
            {
            $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=finance/core/print&id=' . $eachItem['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
                if($eachItem['code']=='SI')
                {
                $inv = Invoice::model()->findBypk($eachItem['header_table_id']);
                $taxType = 'tax';
                $url = "window.open($('#liveSite').val()+'index.php?r=invoice/PrintInvoiceReportPDF&id=" . $eachItem['header_table_id'] ."&c_id=24&frm=tax&barcode=N', '_blank');";
                $div .= ' <a class="btn btn-primary btn-xs" title="Invoice Print PDF" target="_blank" onclick="'.$url.'"><i class="fa fa-print"></i></a>';
                }
            }
            if(strpos($eachItem['ledger'], 'PDC-I') !== false || strpos($eachItem['ledger'], 'Bank Accounts') !== false)
            {
            $pdc=true;
            }
            else {
            $pdc=false;    
            }
            if( (Yii::app()->user->authorised_user == 1 || (int) Yii::app()->user->havePermissionOn["finance_print_cheque"]) && ($eachItem['code'] == "PV" && $pdc) )  
                $div .= ' <a class="btn btn-primary btn-xs" title="Print Cheque" target="_blank" href="?r=cheque/default/Paymentchequeprint&id=' . $eachItem['id'] . '"><i class="fa fa-print"></i></a>';
            $div .= '</div>';

            $eachItemData[] = array($eachItem['voucher_no'], date('d/m/Y', strtotime($eachItem['voucher_date'])), nl2br(str_replace(',', PHP_EOL, $eachItem['ledger'])), nl2br(str_replace(',', PHP_EOL, $eachItem['subledger'])), $eachItem['reference_no'], Yii::app()->numberFormatter->formatCurrency($eachItem['total_voucher_amount'], " "), ($eachItem['is_allocated'] == "Y") ? 'Yes' : 'No', $div);
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionLedgers()
    {
        $this->render('ledgers');
    }

    public function actionGetledgers()
    {
        $model = new FinanceLegder();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 'account_no',
            1 => 'description',
            2 => 'parent_account',
            3 => 'main_account_type',
            4 => 'haveSubledger',
            5 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        if ($_POST['parent_account'] > 0) {
            $condition = 'parent_account=' . $_POST['parent_account'];
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = 'account_no LIKE "%' . $searchString . '%" OR description LIKE "%' . $searchString . '%"';
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        function getGroup($type)
        {
            $groups = array('A' => 'Assets', 'L' => 'Equity & Liabilities', 'I' => 'Income', 'E' => 'Expense');
            return $groups[$type];
        }
         $fledger=new FinanceLegder();
         
       $fitems= new FinanceVoucherItems();

        foreach ($model as $eachItem) {

            $div = '<div class="btn-wrap text-center">';
            if ($eachItem['system_generated'] == 'N'):
                $div .= '<button class="btn btn-primary btn-xs" onclick="loadPopupModal(\'finance/core/createledger&id=' . $eachItem['id'] . '\',\' ' . $eachItem['description'] . ' \',\'lg\')"><i class="fa fa-pencil"></i></button> ';
                if ((int)  $fitems->no_of_entries((int) $eachItem['id']) == 0 && (int) $fitems->no_of_childs((int) $eachItem['id']) == 0) {
                    $div .= '<a href ="#" class="btn btn-danger btn-xs" onclick="deleteAccount(' . $eachItem['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                }
            endif;
            $div .= '</div>';
            $eachItemData[] = array($eachItem['account_no'], $eachItem['description'], $fledger->getParent($eachItem['parent_account']), getGroup($eachItem['main_account_type']), ($eachItem['haveSubledger'] == "Y") ? 'Yes' : 'No', $div);

        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionSubledgers()
    {
        $this->render('subledgers');
    }

    public function actionGetsubledgerlist()
    {
        $model = new FinanceSubledger();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.account_no',
            1 => 't.description',
            2 => 'subledgertype.description',
            3 => 'subledgertype.description',
            4 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';
        // if ($_POST['subledger_type'] > 0) {
        //     $condition .= ' AND subledgertype.id=' . $_POST['subledger_type'];
        // }
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition = 'subledgertype.description LIKE "%' . $searchString . '%" OR t.description LIKE "%' . $searchString . '%" OR t.account_no LIKE "%' . $searchString . '%" OR t.account_no LIKE "%' . $searchString . '%"';
        }

        $count = $model->with('subledgertype')->count(array('condition' => $condition));
        $model = $model->with('subledgertype')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        
       $fvoucheritems= new FinanceVoucherItems();

        foreach ($model as $eachItem) {
            $div = '<div class="btn-wrap text-center">';
            if ($eachItem['subledgertype']['system_generated'] == 'N') {
                $div .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'finance/core/newsubledger&id=' . $eachItem['id'] . '\',\'Edit Subledger \',\'lg\')"><i class="fa fa-edit"></i></a>';
                if ($fvoucheritems->no_of_subledger_entries($eachItem['id']) == 0) {
                    $div .= ' <a href ="#" class="btn btn-danger btn-xs" onclick="deleteSublegder(' . $eachItem['id'] . ')"><i class="fa fa-trash-o "></i></a>';
                }

            }
            $div .= '</div>';
            $eachItemData[] = array($eachItem['account_no'], $eachItem['description'], $eachItem['subledgertype']['description'], $eachItem->related_ledgers(), $div);
            $m++;

        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionSublegdertypes()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new FinanceSubledgerType();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('sublegder_types', array('model' => $model));
    }

    public function actionCreateledger()
    {
        $model = new FinanceLegder;
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findBypk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('ledger_create', array('model' => $model));
    }

    public function actionGetaccountno()
    {
        $parent_id = (int) $_POST['parent_id'];
        $response = array();
        if ($parent_id > 0) {
            $parentModel = FinanceLegder::model()->findByPk($parent_id);
            $count_of_child = FinanceLegder::model()->count(array('condition' => 'parent_account=' . $parent_id));
            if ($count_of_child > 0) {
                $response['account_no'] = Yii::app()->db->createCommand('SELECT MAX(account_no)+1 AS account_no FROM erp_finance_legder WHERE parent_account=' . $parent_id)->queryScalar();
            } else {
                $response['account_no'] = $parentModel->account_no . '1';
            }
            $exist = true;
            while ($exist) {
                $existance = FinanceLegder::model()->find(array('condition' => 'account_no=' . $response['account_no']));
                if ($existance->id > 0) {
                    $response['account_no'] += 1;
                } else {
                    $exist = false;
                }

            }
        }

        echo json_encode($response);
    }

    public function actionSaveledger()
    {

        $others = $sortOrder = array();
        $oldParent = 0;

        $arr_levels = array('A' => 'A', 'L' => 'B', 'I' => 'C', 'E' => 'D');

        $model = new FinanceLegder;
        if ((int) $_POST['FinanceLegder']['id'] > 0) {
            $model = $model->findBypk((int) $_POST['FinanceLegder']['id']);
            $oldParent = $model->parent_account;
        }

        $model->attributes = $_POST['FinanceLegder'];
        if ($model->haveSubledger == 'Y') {
            $model->scenario = 'havesublegder';
            if (is_array($_POST['FinanceLegder']['subledger_types'])) {
                foreach ($_POST['FinanceLegder']['subledger_types'] as $eachSub) {
                    $arr_sub_type[] = $eachSub;
                }
                $model->subledger_types = implode(',', $arr_sub_type);
            }
        } else {
            $model->subledger_types = null;
        }
        if ((int) $model->parent_account > 0 && $oldParent != $model->parent_account) {
            $parentModel = FinanceLegder::model()->findBypk((int) $model->parent_account);
            $model->type_of_account = $parentModel->type_of_account;
            $model->main_account_type = $parentModel->main_account_type;
            $model->level = $parentModel->level + 1;
            $model->created_by = Yii::app()->user->id;
            $model->created_datetime = date('Y-m-d h:i:s');
            $root_array = ($parentModel->root != null) ? array($parentModel->root, $model->parent_account) : array($model->parent_account);
            $model->root = implode(',', $root_array);

            //Sort order
            $model->sort_order = 1;
        }

        if ($model->isParent == 'Y') {
            $model->haveSubledger == 'N';
            $model->subledger_types = null;
        }

        if ($model->validate() && $model->level <= 10) {

            echo json_encode(array('status' => 'success'));
            $model->save();
            $model->setup_levels();

        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            if ($model->level > 10) {
                $others[] = 'Maximum 10 levels are allowed';
            }

            echo CJSON::encode(array_merge_recursive($error1, $others));
        }
    }

    public function actionSystemmapping()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('system_mapping');
    }

    public function actionGetsubledgers()
    {

        $model = $_POST['model'];
        $field = $_POST['field'];
        $account = (int) $_POST['account'];
        $i = $_POST['i'];

        echo CHtml::activedropdownlist(new $model, "[" . $i . "]" . $field, FinanceSubledger::getSubledgers($account), array('class' => 'form-control', 'prompt' => '-select-'));
    }

    public function actionSavemapping()
    {
        $mappings = array();
        $valid = true;
        $i = 0;

        if (is_array($_POST['FinanceSystemAccountsMapping'])) {
            foreach ($_POST['FinanceSystemAccountsMapping'] as $each) {
                $mappings[$i] = FinanceSystemAccountsMapping::model()->findBypk($each['id']);
                $mappings[$i]->attributes = $each;
                $valid = $valid && $mappings[$i]->validate();
                $i++;
            }
            if ($valid) {
                foreach ($mappings as $each) {
                    $each->save();
                }

                echo json_encode(array('status' => 'success'));
            } else {
                echo CActiveForm::validateTabular($mappings, '', false);
            }
        }
    }

    public function actionSavefootermapping()
    {
        $mappings = array();
        $valid = true;
        $i = 0;

        if (is_array($_POST['FinanceFooterMapping'])) {
            foreach ($_POST['FinanceFooterMapping'] as $each) {
                $mappings[$i] = new FinanceFooterMapping;
                if ($each['id'] > 0) {
                    $mappings[$i] = $mappings[$i]->findBypk($each['id']);
                }

                $mappings[$i]->attributes = $each;
                $valid = $valid && $mappings[$i]->validate();
                $i++;
            }
            if ($valid) {
                foreach ($mappings as $each) {
                    $each->save();
                }

                echo json_encode(array('status' => 'success'));
            } else {
                echo CActiveForm::validateTabular($mappings, '', false);
            }
        }
    }

    public function actionVouchersettings()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $model = new FinanceVoucherType;
        $mappings = array(new FinanceVoucherTypeMappings);
        if ($id > 0) {
            $model = $model->findByPk($id);
            $mappings = FinanceVoucherTypeMappings::model()->findAll(array('condition' => 'voucher_type=' . $id, 'order' => 'id'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('voucher_settings', array('model' => $model, 'items' => (empty($mappings)) ? array(new FinanceVoucherTypeMappings) : $mappings));
    }

    public function actionSavevouchersettings()
    {
        $model = new FinanceVoucherType;
        $others = array();
        $isProceedable = true;
        $items = array();
        $i = 0;
        if ((int) $_POST['FinanceVoucherType']['id'] > 0) {
            $model = $model->findbypk((int) $_POST['FinanceVoucherType']['id']);
        }

        $model->attributes = $_POST['FinanceVoucherType'];
        $model->scenario = ($model->have_mappings == 'Y') ? 'haveMapping' : 'noMapping';
        if ($model->have_mappings == 'Y') {
            foreach ($_POST['FinanceVoucherTypeMappings'] as $each) {
                if ($each['account_id'] > 0) {
                    if ($each['debit_field'] != '' || $each['credit_field'] != '') {
                        $items[$i] = new FinanceVoucherTypeMappings;
                        $items[$i]->attributes = $each;
                        if ($model->support_rcm == 'N') {
                            $items[$i]->rcm_comparison = 'NORMAL';
                        }

                        $i++;
                    } else {
                        $others[] = 'Choose debit or credit';
                        $isProceedable = false;
                    }
                }
            }
        }
        if ($model->validate() && $isProceedable) {
            $model->save();
            FinanceVoucherTypeMappings::model()->deleteAll('voucher_type=:refer_id', array(':refer_id' => $model->id));
            if (!empty($items)) {
                foreach ($items as $each) {
                    $each->voucher_type = $model->id;
                    $each->save(false);
                }
            }
            echo json_encode(array('status' => 'success'));
        } else {
            $error1 = json_decode(CActiveForm::validate($model, '', false), true);
            if ($model->have_mappings == 'Y' && count($items) == 0) {
                $others[] = 'Add atleaset one item!';
            }

            echo CJSON::encode(array_merge_recursive($error1, $others));
        }
    }

    public function actionImportvouchers()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('voucher_import');
    }

    public function actionGetimportvouchers()
    {

        $status = $_POST['status'];
        $voucher = $_POST['voucher'];

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');

        $this->render('voucher_import_details', array('from_date' => $from_date, 'status' => $status, 'to_date' => $to_date, 'voucher' => $voucher));
    }

    public function actionSavemodulevouchers()
    {
        $response = array();

        function validatePost($arr_post)
        {
            $returnValue = false;
            if (count(explode('/', $arr_post['from_date'])) == 3 && count(explode('/', $arr_post['to_date'])) == 3 && $arr_post['voucher_selection'] > 0 && $arr_post['status'] != '') {
                $returnValue = true;
            }

            return $returnValue;
        }

        function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        function getSublegder($parnet_id, $subledger_type)
        {
            if($parnet_id>0 && $subledger_type==1)
            {
            $model=Customer::model()->findByPk($parnet_id);
            $model->saveSublegder();   
            }
            else if($parnet_id>0 && $subledger_type==2)
            {
            $model=Vendor::model()->findByPk($parnet_id);
            $model->saveSublegder();   
            }    
            
            return FinanceSubledger::model()->find(array('condition' => 'parent_id=' . (int) $parnet_id . ' AND subledger_type_id=' . (int) $subledger_type))->id;
        }

        if (count($_POST['ids']) > 0) {

            if (validatePost($_POST)) {

                $from_date = $_POST['from_date'];
                $to_date = $_POST['to_date'];
                $voucher = (int) $_POST['voucher_selection'];
                $status = $_POST['status'];

                $voucherModel = FinanceVoucherType::model()->findBypk($voucher);
                $updatFlag = $voucherModel->status_field;
                //Emirate
                $vatField = $voucherModel->vat_value;

                foreach ($_POST['ids'] as $i => $each) {

                    $itemsArray = $voucherHead = array();
                    if ((int) $each > 0) {
                        if ($status == 'NEW') {

                            $voucherHead['voucher_type'] = $voucher;
                            $voucherHead['header_table_id'] = $mainTable->id;
                            $voucherHead['is_posted'] = 'Y';
                            $voucherHead['created_by'] = Yii::app()->user->id;
                            $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

                            if ($voucherModel->code == 'SI') {
                                $mainTable = Invoice::model()->findBypk($each);
                                $employee_id=User::model()->findByPk($mainTable->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id; 
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->lead_owner_id;    
                                }
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->invoice_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->customer_id, 1);
                                $voucherHead['emp_subledger'] = getSublegder($leadowner_id, 3);
                                $voucherHead['reference_no'] = $mainTable->reference;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $voucherHead['due_date'] = date('Y-m-d', strtotime($mainTable->invoice_date . ' + ' . (int) $mainTable->paymentTerm->no_of_days . ' days'));
                                $valid = isPostable($mainTable->invoice_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'PI') {
                                $mainTable = PurchasingInvoice::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->invoice_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->vendor_id, 2);
                                $voucherHead['reference_no'] = $mainTable->invoice_no;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $voucherHead['due_date'] = date('Y-m-d', strtotime($mainTable->invoice_date . ' + ' . (int) $mainTable->paymentTerm->no_of_days . ' days'));
                                $valid = isPostable($mainTable->invoice_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'DN') {
                                $mainTable = Purchasingdebitnote::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->debited_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->vendor_id, 2);
                                $voucherHead['reference_no'] = 'Purchase Return for Invoice #' . $mainTable->purchasing_invoice_id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->debited_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'CN') {
                                $mainTable = Creditnote::model()->findBypk($each);
                                $employee_id=User::model()->findByPk($mainTable->invoice->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id;    
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;    
                                }
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->credited_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->customer_id, 1);
                                $voucherHead['emp_subledger'] = getSublegder($leadowner_id, 3);
                                $voucherHead['reference_no'] = 'Sales Return for Invoice #' . $mainTable->invoice->id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->credited_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'GI') {
                                $mainTable = InventoryGoodsIssue::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->goods_issue_date;
                                $voucherHead['reference_no'] = 'Goods Issue #' . $mainTable->id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->goods_issue_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'GR') {
                                $mainTable = InventoryGoodsReceipt::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->goods_receipt_date;
                                $voucherHead['reference_no'] = 'Goods Receipt #' . $mainTable->id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->goods_receipt_date) && $mainTable->$updatFlag == 'N';
                            }

                            $lastSavedid = $valid ? $this->addVoucherhead($voucherHead) : 0;

                            if ($lastSavedid > 0) {
                                if ($voucherModel->code == 'PI') {
                                    $totalPurchase = $totalLanding = 0;
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND((SUM(IV.net_amount)*I.exchange_rate), 6) AS net_amount FROM {{purchasinginvoice_item}} IV LEFT JOIN {{purchasinginvoice}} I ON I.id = IV.purchasing_invoice_id WHERE IV.purchasing_invoice_id=' . (int) $each)->queryScalar();
                                    $items = Yii::app()->db->createCommand('
                                                SELECT
                                                    I.id AS invoice_id,
                                                    IV.id AS item_id,
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_id,
                                                    SUM(IV.net_amount) AS net_amount_bc,
                                                    SUM(IV.tax_amount) AS tax_amount_bc
                                                FROM {{purchasinginvoice_item}} IV
                                                LEFT JOIN {{purchasinginvoice}} I ON I.id = IV.purchasing_invoice_id
                                                LEFT JOIN {{store}} S ON S.id = IV.product_id
                                                WHERE IV.purchasing_invoice_id=' . (int) $each.' group by IV.id' )->queryAll();
                                    $tax_tot_items=0;
                                    foreach ($items as $eachItem) {
                                        $itemsArray = array();
                                        //Inventory Dr
                                        $narration='Purchase #' . $eachItem['invoice_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                        if ($eachItem['net_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                                'brand_id' => $eachItem['brand_id'],
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $eachItem['generic_id'],
                                                'detail_table_id' => $eachItem['item_id'],
                                                'subledger_id' => 0,
                                                'narration' => $narration,
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => (float) $eachItem['net_amount_bc'],
                                            ));
                                            $totalPurchase += $eachItem['net_amount_bc'];
                                        }
                                       $tax_tot_items += $eachItem['tax_amount_bc'];
                                       $totalPurchase += $eachItem['tax_amount_bc'];
                                        //Sundry Creditor Cr
                                        $totalValue = $eachItem['net_amount_bc'] + $eachItem['tax_amount_bc'];
                                        

                                        //Footer Deduction Cr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasinginvoice->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => -1 * ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_deduction > 0) {
                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                                    'narration' => 'Purchase Deduction',
                                                    'currency' => $mainTable->currency,
                                                    'exchange_rate' => $mainTable->exchange_rate,
                                                    'amount' => (float) $net_footer_deduction,
                                                ));
                                            }
                                        }

                                        //Landing cost Update
                                        if (!empty($mainTable->landingItems)) {
                                            foreach ($mainTable->landingItems as $eachCost) {

                                                $ratio = $netAmount > 0 ? (round(($eachCost->particular_value), 2) / $netAmount) : 0;
                                                $ratio = round($ratio, 6);

                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => MasLandedCostItems::getAccount($eachCost->particular),
                                                    'subledger_id' => MasLandedCostItems::getSubledger($eachCost->particular),
                                                    'narration' => 'Purchase Cost/ Landing',
                                                    'currency' => $eachCost->currency_id,
                                                    'exchange_rate' => $eachCost->exchange_rate,
                                                    'amount' => (float) $ratio * $eachItem['net_amount_bc'],
                                                ));

                                                $totalPurchase += ($ratio * $eachItem['net_amount_bc']);

                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                                    'subledger_id' => getSublegder($eachCost->vendor_id, 2), //2-Creditors 1- debtors
                                                    'narration' => 'Purchase Cost/ Landing',
                                                    'currency' => $eachCost->currency_id,
                                                    'exchange_rate' => $eachCost->exchange_rate,
                                                    'amount' => -1 * $ratio * $eachItem['net_amount_bc'],
                                                ));
                                            }
                                        }
                                        
                                        //VAT on Purchase Dr
                                        if ($eachItem['tax_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('purchase_vat'),
                                                'subledger_id' => 0,
                                                'narration' => 'Purchase #' . $eachItem['invoice_id'],
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => (float) $eachItem['tax_amount_bc'],
                                            ));
                                        }
                                    }
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                            'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                            'narration' => 'Purchase #' . $eachItem['invoice_id'],
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'amount' => (float)  - 1 * $totalPurchase,
                                        ));
                                        //Footer Addition Dr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceSystemAccountsMapping::getSystemdefault('other_expenses');
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasinginvoice->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings,
                                                        'subledger_id' => 0,
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
//                                                        'amount' => (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                        'amount' => (float) $eachFooter->calculated_value,
                                                    ));
                                                    $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                                    'narration' => 'Purchase Cost',
                                                    'currency' => $mainTable->currency,
                                                    'exchange_rate' => $mainTable->exchange_rate,
                                                    'amount' => (float)  - 1 * $eachFooter->calculated_value,
                                                ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
//                                            if ($net_footer_addition > 0) {
//                                                $this->addVoucheritems($lastSavedid, array(
//                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
//                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
//                                                    'narration' => 'Purchase Cost',
//                                                    'currency' => $mainTable->currency,
//                                                    'exchange_rate' => $mainTable->exchange_rate,
//                                                    'amount' => (float)  - 1 * $net_footer_addition,
//                                                ));
//                                            }
                                            $totalPurchase += $net_footer_addition;
                                        }
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => ($mainTable->grand_total), 'cheque_cleared' => 'Y')); //$netTotal
                                    PurchasingInvoice::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                } else if ($voucherModel->code == 'SI') {
                                    //For Item sales
                                    $totalSales = 0;
                                    $invoice=Invoice::model()->findByPk((int)$each);
                                    if($invoice->invoice_nature=='S' || $invoice->invoice_nature=='SR')
                                    {
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND( ( SUM( ( IV.quantity * IV.rate ) )*I.exchange_rate), 6) AS net_amount FROM {{invoice_item}} IV LEFT JOIN {{store}} S ON S.id = IV.product_id LEFT JOIN {{invoice}} I ON I.id = IV.invoice_id WHERE S.inventory_item_type=1 AND IV.invoice_id=' . (int) $each)->queryScalar();

                                    $items = Yii::app()->db->createCommand('
                                        SELECT
                                            product_id,
                                            part_number,
                                            description,
                                            generic_id,
                                            brand_class_id,
                                            invoice_id,
                                            item_id,
                                            net_amount_wo_discount AS net_amount_bc,
                                            SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                            SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                            SUM( bonus_net_amount_wo_discount ) AS total_bonus_sales,
                                            SUM( discount ) AS discount,
                                            SUM( total_tax_amount) AS total_tax_amount,
                                            SUM( addition_amount) AS total_add_amount,
                                            SUM( deduction_amount) AS total_ded_amount,
                                            ROUND(total_cost, 6) AS total_cost,
                                            emirate_id
                                        FROM(
                                                SELECT 
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_class_id,
                                                    I.id AS invoice_id,
                                                    II.id AS item_id,
                                                    SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                    SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                    SUM( II.addition_amount ) AS addition_amount,
                                                    SUM( II.deduction_amount ) AS deduction_amount,
                                                    SUM( II.bonus_qty * II.rate ) AS bonus_net_amount_wo_discount,
                                                    SUM(II.deduction_amount) AS discount,
                                                    SUM( ( ( II.quantity + II.bonus_qty ) * II.cost_rate ) ) AS total_cost,
                                                    C.customer_emirates_name AS emirate_id
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                LEFT JOIN {{store}} S ON S.id = II.product_id
                                                WHERE I.id="' . $each . '" AND S.inventory_item_type=1 group by II.id
                                            ) AS A group by item_id ')->queryAll();
                                        
                                    $total_bonus_sales=0;
                                    $total_discount=0;
                                    $total_debtor_amount=0;
                                    $total_cost=0;
                                    $total_sales=0;
                                    $total_tax_amount=0;
                                    foreach ($items as $eachItem) {
                                    $total_bonus_sales+=(float) $eachItem['total_bonus_sales'];
                                    $total_discount+=(float) $eachItem['discount'];
                                    $total_debtor_amount+= (float) $eachItem['debtor_amount']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount'];
                                    $total_cost+=$eachItem['total_cost'];
                                    $total_sales+=$eachItem['total_sales']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount']; //-ve value
                                    $sales_amount=$eachItem['total_sales']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount']; //-ve value
                                    $total_tax_amount+=$eachItem['total_tax_amount']; //-ve value
                                    
                                $employee_id=User::model()->findByPk($mainTable->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id; 
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->lead_owner_id;    
                                }
                                $narration='Sales #' . $mainTable->id.' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                if ($eachItem['total_cost'] != 0) {
                                        //Cost of Sale Dr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale'),
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'subledger_id' => 0,
                                            'narration' => $narration,
                                            'currency' => 1,
                                            'exchange_rate' => 1,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => (float)$eachItem['total_cost'],
                                            'employee_id' => getSublegder($leadowner_id, 3),
                                        ));
                                    }
                                    if ($sales_amount != 0) {
                                        //Sales Accounts Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales'),
                                            'subledger_id' => getSublegder($leadowner_id, 3),
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'narration' => $narration,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $sales_amount, 
                                            'employee_id' => getSublegder($leadowner_id, 3),
                                        ));
                                    }
                                    if ($eachItem['total_cost'] != 0) {
                                        //Inventory Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'subledger_id' => 0,
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'narration' => $narration,
                                            'currency' => 1,
                                            'exchange_rate' => 1,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $eachItem['total_cost'],
                                        ));
                                    }
                                        //Footer Items
                                        //Footer Addition Cr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => -1 * (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                    ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount+=$net_footer_addition;
                                        }

                                        //Footer Deduction Dr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount-=$net_footer_deduction;
                                        }
                                    }

                                    //Service Sales
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND( ( SUM( ( IV.quantity * IV.rate ) )*I.exchange_rate), 6) AS net_amount FROM {{invoice_item}} IV LEFT JOIN {{store}} S ON S.id = IV.product_id LEFT JOIN {{invoice}} I ON I.id = IV.invoice_id WHERE S.inventory_item_type=2 AND IV.invoice_id=' . (int) $each)->queryScalar();
                                    $items = Yii::app()->db->createCommand('
                                    SELECT
                                        product_id,
                                        part_number,
                                        description,
                                        generic_id,
                                        brand_class_id,
                                        invoice_id,
                                        ledger_id,
                                        item_id,
                                        net_amount_wo_discount AS net_amount_bc,
                                        SUM( net_amount_wo_discount + total_tax_amount ) AS debtor_amount,
                                        SUM( net_amount_wo_discount ) AS total_sales,
                                        SUM( discount ) AS discount,
                                        SUM( total_tax_amount ) AS total_tax_amount
                                    FROM(
                                            SELECT 
                                                S.id AS product_id,
                                                S.part_number AS part_number,
                                                S.description AS description,
                                                S.generic_id AS generic_id,
                                                S.brand_class_id AS brand_class_id,
                                                I.id AS invoice_id,
                                                L.id AS ledger_id,
                                                II.id AS item_id,
                                                SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                SUM( II.deduction_amount ) AS discount
                                            FROM {{invoice_item}} II 
                                            LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                            LEFT JOIN {{store}} S ON S.id = II.product_id
                                            LEFT JOIN {{finance_legder}} L ON S.id = L.parent_id
                                            WHERE I.id="' . $each . '" AND S.inventory_item_type=2
                                            GROUP BY II.product_id
                                        ) AS A  GROUP BY ledger_id')->queryAll();

                                    foreach ($items as $eachItem) {
                                        $total_bonus_sales+=(float) $eachItem['total_bonus_sales'];
                                    $total_discount+=(float) $eachItem['discount'];
                                    $total_debtor_amount+= (float) $eachItem['debtor_amount'] - (float) $eachItem['discount'];
                                    $total_cost+=$eachItem['total_cost'];
                                    $total_sales+=$eachItem['total_sales']; //-ve value
                                    $total_tax_amount+=$eachItem['total_tax_amount']; //-ve value
                                    
                                     $narration='Sales #' . $mainTable->id.' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                    
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('sales');
                                    $subledger=getSublegder($leadowner_id, 3);
                                    switch($eachItem['product_id'])
                                    {
                                    case 1239:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon_income'); 
                                    $subledger=0;
                                    break;
                                    case 1240:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('referral_fee_amazon');   
                                    $subledger=0; 
                                    break;
                                    case 1263:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('order_cancellation_charge_amazon');  
                                    $subledger=0;  
                                    break;
                                    case 1266:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon');  
                                    $subledger=0;  
                                    break;
                                    }
                                    
                                    if ($eachItem['total_sales'] != 0) {
                                        //Sales Accounts Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => $sale,
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'subledger_id' => $subledger,
                                            'narration' => $narration,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $eachItem['total_sales'],
                                            'employee_id' => getSublegder($leadowner_id, 3),
                                        ));
                                    }

                                        //Footer Items
                                        //Footer Addition Cr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => -1 * (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                    ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount+=$net_footer_addition;
                                        }

                                        //Footer Deduction Dr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount-=$net_footer_deduction;
                                        }
                                    }
                                }
                                else if($invoice->invoice_nature=='H')
                                {
                                    $total_bonus_sales=0;
                                    $total_discount=0;
                                    $total_debtor_amount=0;
                                    $total_cost=0;
                                    $total_sales=0;
                                    $total_tax_amount=0;
                                    $total_debtor_amount+= (float)$invoice->grand_total;
                                    $total_sales+=(float)$invoice->grand_total-(float)$invoice->total_tax_amount; //-ve value
                                    $total_tax_amount+=(float)$invoice->total_tax_amount; //-ve value
                                }
                                // ADVANCE PAYMENT INVOICE
                                else if($invoice->invoice_nature=='A')
                                {
                                    $total_bonus_sales=0;
                                    $total_discount=0;
                                    $total_debtor_amount=0;
                                    $total_cost=0;
                                    $total_sales=0;
                                    $total_tax_amount=0;
                                    $total_debtor_amount+= (float)$invoice->grand_total;
                                    $total_sales+=(float)$invoice->grand_total-(float)$invoice->total_tax_amount; //-ve value
                                    $total_tax_amount+=(float)$invoice->total_tax_amount; //-ve value
                                }
                                

                                    //POSTING
                                    
                                    if ($total_bonus_sales > 0) {
                                        //Sales Bonus Dr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_bonus'),
                                            'brand_id' => 0,
                                            'subledger_id' => getSublegder($mainTable->lead_owner_id, 3),
                                            'narration' => 'Sales #' . $mainTable->id,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => (float) $total_bonus_sales,
                                        ));
}

//                                    if ($total_discount > 0) {
//                                        //Discount Given Dr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_discount'),
//                                            'brand_id' => 0,
//                                            'subledger_id' => getSublegder($mainTable->lead_owner_id, 3),
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => $mainTable->currency,
//                                            'exchange_rate' => $mainTable->exchange_rate,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => (float) $total_discount,
//                                        ));
//}

//                                    if($total_debtor_amount > 0) {
                                        //Debtor Dr
                                        $finalvalue = (float) $eachItem['debtor_amount'] - (float) $eachItem['discount'];
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                            'brand_id' => 0,
                                            'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                            'narration' => 'Sales #' . $mainTable->id,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => (float)$total_debtor_amount,
                                        ));
//                                    }

//                                    if ($total_cost > 0) {
//                                        //Cost of Sale Dr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale'),
//                                            'brand_id' => $mainTable->order_id,
//                                            'subledger_id' => 0,
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => 1,
//                                            'exchange_rate' => 1,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => (float)$total_cost,
//                                        ));
//                                    }
//                                    if ($total_sales > 0) {
//                                        //Sales Accounts Cr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales'),
//                                            'brand_id' => $mainTable->order_id,
//                                            'subledger_id' => getSublegder($mainTable->lead_owner_id, 3),
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => $mainTable->currency,
//                                            'exchange_rate' => $mainTable->exchange_rate,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => -1 * $total_sales,
//                                        ));
//                                    }
                                    if ($total_tax_amount > 0) {
                                        //VAT Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_vat'),
                                            'brand_id' => 0,
                                            'subledger_id' => 0,
                                            'narration' => 'Sales #' . $mainTable->id,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $total_tax_amount,
                                        ));
                                    }
//                                    if ($total_cost > 0) {
//                                        //Inventory Cr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
//                                            'brand_id' => 0,
//                                            'subledger_id' => 0,
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => 1,
//                                            'exchange_rate' => 1,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => -1 * $total_cost,
//                                        ));
//                                    }

                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => abs($mainTable->grand_total), 'cheque_cleared' => 'Y')); //$netTotal
                                    Invoice::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                } else if ($voucherModel->code == 'DN') {
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND((SUM(IV.net_amount)*I.exchange_rate), 6) AS net_amount FROM {{purchasing_debit_note_item}} IV LEFT JOIN {{purchasing_debit_note}} I ON I.id = IV.purchasing_debitnote_id WHERE IV.purchasing_debitnote_id=' . (int) $each)->queryScalar();
                                    $items = Yii::app()->db->createCommand('
                                            SELECT
                                                D.id AS invoice_id,
                                                DI.id AS item_id,
                                                S.id AS product_id,
                                                S.part_number AS part_number,
                                                S.description AS description,
                                                S.generic_id AS generic_id,
                                                S.brand_class_id AS brand_class_id,
                                                ROUND(( SUM(DI.net_amount)), 6) AS net_amount_bc,
                                                ROUND(( SUM(DI.tax_vat_amount)), 6) AS tax_amount_bc
                                            FROM {{purchasing_debit_note_item}} DI
                                            LEFT JOIN {{purchasing_debit_note}} D ON DI.purchasing_debitnote_id = D.id
                                            LEFT JOIN {{store}} S ON DI.product_id = S.id
                                            WHERE D.id = "' . $each . '" group by DI.id')->queryAll();

                                    $totalDebit = 0;
                                    $totalAmount=0;
                                    $totalVat=0;
                                    foreach ($items as $eachItem) {
                                        $itemsArray = array();
                                        $narration='Purchase Return #' . $eachItem['invoice_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                        //Inventory Cr
                                        if ($eachItem['net_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                                'subledger_id' => 0,
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $eachItem['generic_id'],
                                                'detail_table_id' => $eachItem['item_id'],
                                                 'brand_id' => $eachItem['brand_class_id'],
                                                'narration' => $narration,
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => -1 * (float) $eachItem['net_amount_bc'],
                                            ));
                                            $totalDebit += $eachItem['net_amount_bc'];
                                            $totalAmount += $eachItem['net_amount_bc'];
                                        }
                                       $totalDebit += $eachItem['tax_amount_bc'];
                                       $totalVat += $eachItem['tax_amount_bc'];
                                       $totalValue = $eachItem['net_amount_bc'] + $eachItem['tax_amount_bc'];
                                       
                                                                               
                                     //VAT on Purchase Cr
                                        if ($eachItem['tax_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('purchase_vat'),
                                                'subledger_id' => 0,
                                                'narration' => 'Purchase Return#' . $eachItem['invoice_id'] ,
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => -1 * (float) $eachItem['tax_amount_bc'],
                                            ));
                                        }
                                        
                                        //Footer Addition Cr
//                                        $net_footer_addition = 0;
//                                        if (!empty($mainTable->adItems)) {
//                                            foreach ($mainTable->adItems as $eachFooter) {
//                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
//                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
//                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasedebitnote->exchange_rate) / $netAmount) : 0;
//                                                    $ratio = round($ratio, 6);
//                                                    $this->addVoucheritems($lastSavedid, array(
//                                                        'ledger_id' => (int) $mappings['account'],
//                                                        'subledger_id' => (int) $mappings['subledger'],
//                                                        'narration' => $mappings['name'],
//                                                        'currency' => $mainTable->currency,
//                                                'exchange_rate' => $mainTable->exchange_rate,
//                                                        'amount' => -1 * (float) $eachItem['net_amount_bc'] * (float) $ratio,
//                                                    ));
//                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
//                                                }
//                                            }
//                                            $totalDebit += $net_footer_addition;
//                                        }

                                        //Footer Deduction Dr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasedebitnote->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
//                                                    $this->addVoucheritems($lastSavedid, array(
//                                                        'ledger_id' => (int) $mappings['account'],
//                                                        'subledger_id' => (int) $mappings['subledger'],
//                                                        'narration' => $mappings['name'],
//                                                        'currency' => $mainTable->currency,
//                                                        'exchange_rate' => $mainTable->exchange_rate,
//                                                        'amount' => ((float) $eachItem['net_amount_bc'] * (float) $ratio),
//                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_deduction > 0) {
//                                                $this->addVoucheritems($lastSavedid, array(
//                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
//                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
//                                                    'narration' => 'Purchase Return || Brand ' . $eachItem['description'],
//                                                    'currency' => $mainTable->currency,
//                                                'exchange_rate' => $mainTable->exchange_rate,
//                                                    'amount' => -1 * (float) $net_footer_deduction,
//                                                ));
                                            }
                                        }
                                    }
                                    
                                                                            //Footer Addition Dr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceSystemAccountsMapping::getSystemdefault('other_expenses');
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasedebitnote->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings,
                                                        'subledger_id' => 0,
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => (float)  - 1 * $eachFooter->calculated_value,
                                                    ));
//                                                    $this->addVoucheritems($lastSavedid, array(
//                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
//                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
//                                                    'narration' => 'Purchase Cost',
//                                                    'currency' => $mainTable->currency,
//                                                    'exchange_rate' => $mainTable->exchange_rate,
//                                                    'amount' => (float) $eachFooter->calculated_value,
//                                                ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $totalDebit += $net_footer_addition;
                                        }

                                        
                                        //Sundry Creditor Dr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                            'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                            'narration' => 'Purchase Return #' . $eachItem['invoice_id'] ,
                                            'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                            'amount' => (float) $totalDebit,
                                        ));
                                        
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => ($mainTable->debited_amount), 'cheque_cleared' => 'Y')); //$netTotal
                                    Purchasingdebitnote::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));

                                } else if ($voucherModel->code == 'CN') {
                                    $items = Yii::app()->db->createCommand('
                                                SELECT
                                                    brand_id,
                                                    brand,
                                                    invoice_id,
                                                    item_id,
                                                    product_id,
                                                    part_number,
                                                    description,
                                                    generic_id,
                                                    net_amount_wo_discount AS net_amount_bc,
                                                    SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                                    SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                                    bonus_net_amount_wo_discount AS total_bonus_sales,
                                                    SUM(discount) AS discount,
                                                    SUM(total_tax_amount) AS total_tax_amount,
                                                    ROUND(total_cost, 6) AS total_cost,
                                                    emirate_id
                                                FROM (
                                                    SELECT
                                                        B.id AS brand_id,
                                                        B.description AS brand,
                                                        CI.product_id AS product_id,
                                                        S.part_number AS part_number,
                                                        S.description AS description,
                                                        S.generic_id AS generic_id,
                                                        C.id AS invoice_id,
                                                        II.id AS item_id,
                                                        ROUND( ( SUM(CI.net_amount)*C.exchange_rate ), 6) AS net_amount_wo_discount,
                                                        ROUND( ( SUM( CI.tax_vat_amount  )*C.exchange_rate ), 6) AS total_tax_amount,
                                                        ROUND( ( SUM( CI.bonus_qty * CI.rate ) * C.exchange_rate ), 6) AS bonus_net_amount_wo_discount,
                                                        0 AS discount,
                                                        ROUND( ( SUM( ( ( CI.returned_quantity + CI.returned_bonus_qty ) * II.cost_rate ) ) ), 6) AS total_cost,
                                                        CU.customer_emirates_name AS emirate_id
                                                    FROM {{creditnote_item}} CI
                                                    LEFT JOIN {{invoice_item}} II ON II.id = CI.invoice_item_id
                                                    LEFT JOIN {{creditnote}} C ON C.id = CI.creditnote_id
                                                    LEFT JOIN {{customer}} CU ON CU.id = C.customer_id
                                                    LEFT JOIN {{store}} S ON S.id = CI.product_id
                                                    LEFT JOIN {{product_class}} B ON B.id = S.brand_class_id
                                                    WHERE C.id = "' . $each . '"
                                                    GROUP BY II.id
                                                ) AS A GROUP BY item_id')->queryAll();

                                    $totalReturn = 0;
                                    $totalVat=0;
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND( ( SUM( ( IV.net_amount ) )*I.exchange_rate), 6) AS net_amount FROM {{creditnote_item}} IV LEFT JOIN {{creditnote}} I ON I.id = IV.creditnote_id WHERE IV.creditnote_id=' . (int) $each)->queryScalar();
                                
                                $mainTable = Creditnote::model()->findBypk($each);
                                $employee_id=User::model()->findByPk($mainTable->invoice->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id;    
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;    
                                }
                                
                                    foreach ($items as $eachItem) {
                                        
                                        $product=Store::model()->findByPk($eachItem['product_id']);
                                        $narration='Sales Return #' . $eachItem['invoice_id'] .' Product : '.$product->part_number.' / '.$product->description;
                                        
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('sales');
                                    $subledger=getSublegder($leadowner_id, 3);
                                    switch($eachItem['product_id'])
                                    {
                                    case 1239:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon_income'); 
                                    $subledger=0;
                                    break;
                                    case 1240:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('referral_fee_amazon');   
                                    $subledger=0; 
                                    break;
                                    case 1263:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('order_cancellation_charge_amazon');  
                                    $subledger=0;  
                                    break;
                                    case 1266:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon');  
                                    $subledger=0;  
                                    break;
                                    }
                                        if ($eachItem['total_sales'] != 0.00) {
                                            //Sales Accounts Dr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => $sale,
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $product->generic_id,
                                                'detail_table_id' => $eachItem['item_id'],
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => $subledger,
                                                'narration' => $narration,
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => $eachItem['total_sales'],
                                                'employee_id' => getSublegder($leadowner_id, 3),
                                            ));
                                        }
                                        
                                        if ($eachItem['total_cost'] > 0) {
                                            //Inventory Dr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                                'brand_id' => $product->brand_class_id,
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $product->generic_id,
                                                'detail_table_id' => $eachItem['item_id'],
                                                'subledger_id' => 0,
                                                'narration' => $narration,
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => $eachItem['total_cost'],
                                            ));
                                        }

                                        $debtorAmount = (float) $eachItem['debtor_amount']  - (float) $eachItem['discount'];

                                        $totalReturn += (float) $eachItem['debtor_amount'];
                                        
                                        $totalVat+= (float) $eachItem['total_tax_amount'];

                                        if ($eachItem['total_bonus_sales'] > 0) {
                                            //Sales Bonus Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_bonus'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => getSublegder($mainTable->invoice->lead_owner_id, 3),
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * (float) $eachItem['total_bonus_sales'],
                                            ));
                                            $totalReturn += (float) $eachItem['total_bonus_sales'];
                                        }

                                        if ($eachItem['discount'] > 0) {
                                            //Discount Given Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_discount'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => 0,
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * (float) $eachItem['discount'],
                                            ));
                                        }
                                        $totalReturn += (float) $eachItem['discount'];

                                        if ($eachItem['total_cost'] > 0) {
                                            //Cost of Sale Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale'),
                                                'brand_id' => $product->brand_class_id,
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $product->generic_id,
                                                'detail_table_id' => $eachItem['item_id'],
                                                'subledger_id' => 0,
                                                'narration' => $narration,
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * $eachItem['total_cost'],
                                                'employee_id' => getSublegder($leadowner_id, 3),
                                            ));
//                                            $totalReturn += (float) $eachItem['total_cost'];
                                        }

                                        //Footer Items
                                        //Footer Addition Dr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->parent->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $product->brand_class_id,
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => 1,
                                                        'exchange_rate' => 1,
                                                        'amount' => (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                    ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_addition > 0) {
                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                                    'brand_id' => $product->brand_class_id,
                                                    'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                                    'narration' => 'Sales Return Addition',
                                                    'currency' => 1,
                                                    'exchange_rate' => 1,
                                                    'amount' => -1 * (float) $net_footer_addition,
                                                ));
                                            }
                                            $totalReturn += $net_footer_addition;
                                        }

                                        //Footer Deduction Cr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->parent->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $product->brand_class_id,
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => 1,
                                                        'exchange_rate' => 1,
                                                        'amount' => -1 * ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_deduction > 0) {
                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                                    'brand_id' => $product->brand_class_id,
                                                    'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                                    'narration' => 'Sales Return Deduction',
                                                    'currency' => 1,
                                                    'exchange_rate' => 1,
                                                    'amount' => (float) $net_footer_deduction,
                                                ));
                                            }
                                        }
                                    }


                                        if ($totalVat > 0) {
                                            //VAT Dr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_vat'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => 0,
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => $totalVat,
                                            ));
                                        }
                                        
//                                        if ($totalReturn > 0 ) {
                                            //Debtor Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * $totalReturn,
                                            ));
//                                        }
                                        
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => abs($mainTable->credited_amount), 'cheque_cleared' => 'Y')); //$netTotal
                                    Creditnote::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                } else if ($voucherModel->code == 'GI') {
                                    
                                    $items = Yii::app()->db->createCommand('SELECT 
                                                                                G.ledger_id,
                                                                                G.subledger_id,
                                                                                G.reference AS narration,
                                                                                GI.product_id AS product_id,
                                                                                GI.id AS item_id,
                                                                                ROUND(GI.rate * GI.picked_qty, 2) AS total_value
                                                                            FROM {{inventory_goods_issue_item}} GI 
                                                                            LEFT JOIN {{inventory_goods_issue}} G ON G.id = GI.inventory_goods_issue_id
                                                                            WHERE G.id='.(int) $each)->queryAll();                                  
                                    $total=0;
                                    foreach($items as $eachItem)
                                    {
                                    $product=Store::model()->findByPk($eachItem['product_id']);
                                    $narration= $eachItem['narration'] .' Product : '.$product->part_number.' / '.$product->description;
                                    //Expense header
                                    $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => $eachItem['ledger_id'],
                                        'subledger_id' => $eachItem['subledger_id'],
                                        'narration' => $narration,
                                        'amount' => (float) $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));

                                     //Inventory
                                     $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                        'narration' => $narration,
                                        'amount' => -1 *  $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));
                                    $total+=$eachItem['total_value'];
                                    }
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => $total, 'cheque_cleared' => 'Y')); //$netTotal
                                    InventoryGoodsIssue::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                } else if ($voucherModel->code == 'GR') {
                                    
                                    $items = Yii::app()->db->createCommand('SELECT 
                                                                                G.reference AS narration,
                                                                                ROUND(GR.rate * GR.picked_qty, 2) AS total_value,
                                                                                GR.product_id AS product_id,
                                                                                GR.id AS item_id
                                                                            FROM {{inventory_goods_receipt_item}} GR 
                                                                            LEFT JOIN {{inventory_goods_receipt}} G ON G.id = GR.inventory_goods_receipt_id
                                                                            WHERE G.id='.(int) $each )->queryAll();
                                    $total=0;
                                    foreach($items as $eachItem)
                                    {
                                    $product=Store::model()->findByPk($eachItem['product_id']);
                                    $narration= $eachItem['narration'] .' Product : '.$product->part_number.' / '.$product->description;
                                    //inventory header
                                    $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                        'narration' => $narration,
                                        'amount' => (float) $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));

                                     //Retained
                                     $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('retained_earnings'),
                                        'narration' => $narration,
                                        'amount' => -1 *  $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));
                                    $total+=$eachItem['total_value'];
                                    }
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => $total, 'cheque_cleared' => 'Y')); //$netTotal
                                    InventoryGoodsReceipt::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                }
                            }

                        } else {
                            
                            if ($voucherModel->code == 'SI') {
                            $model = new Invoice;
                            } else if ($voucherModel->code == 'PI') {
                            $model = new PurchasingInvoice;
                            } else if ($voucherModel->code == 'DN') {
                            $model = new Purchasingdebitnote;
                            } else if ($voucherModel->code == 'CN') {
                            $model = new Creditnote;
                            } else if ($voucherModel->code == 'GI') {
                            $model = new InventoryGoodsIssue;
                            } else if ($voucherModel->code == 'GR') {
                            $model = new InventoryGoodsReceipt;
                            }

                            $AllexistingVocher = FinanceVoucherHead::model()->findAll(array('condition' => 'voucher_type=' . $voucher . ' AND header_table_id=' . (int) $each));
                            foreach($AllexistingVocher as $existingVocher)
                            {
                                if ($existingVocher->id > 0) {
                                if ($existingVocher->is_allocated == 'N' && isPostable($existingVocher->voucher_date)) {
                                    FinanceVoucherHead::model()->deletebypk((int)$existingVocher->id);
                                    FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => (int)$existingVocher->id));
                                $model::model()->updateBypk($each, array($voucherModel->status_field => 'N'));    
                                }
                            }
                            }
                            
                        }
                    }
                }
                $response['status'] = 'success';
            } else {
                $response[] = 'Something went wrong!';
            }

        } else {
            $response[] = 'Select atleast one item!';
        }

        echo json_encode($response);
    }

    public function addVoucherhead($arr_items)
    {
        $model = new FinanceVoucherHead;
        $model->voucher_type = $arr_items['voucher_type'];
        $model->voucher_no = $arr_items['voucher_no'];
        $model->voucher_date = $arr_items['voucher_date'];
        $model->related_subledger = $arr_items['related_subledger'];
        $model->emp_subledger = $arr_items['emp_subledger'];
        $model->due_date = (isset($arr_items['due_date'])) ? $arr_items['due_date'] : $model->voucher_date;
        $model->header_table_id = $arr_items['header_table_id'];
        $model->reference_no = $arr_items['reference_no'];
        $model->is_posted = (isset($arr_items['is_posted'])) ? $arr_items['is_posted'] : 'Y';
        $model->created_by = Yii::app()->user->id;
        $model->created_datetime = date('Y-m-d h:i:s');
        $model->cheque_no = $arr_items['cheque_no'];
        return ($model->save(false)) ? $model->id : 0; //exception
    }

    public function addVoucheritems($headerId, $arr_items)
    {
        $model = new FinanceVoucherItems;
        $model->header_id = $headerId;
        $model->ledger_id = $arr_items['ledger_id'];
        $model->brand_id = (int) $arr_items['brand_id'];
        $model->product_id = (int) $arr_items['product_id'];
        $model->detail_table_id = (int) $arr_items['detail_table_id'];
        $model->generic_id = (int) $arr_items['generic_id'];
        $model->employee_id = (int) $arr_items['employee_id'];
        $model->emirate_id = $arr_items['emirate_id'];
        $model->subledger_id = $arr_items['subledger_id'];
        $model->narration = $arr_items['narration'];
        $model->amount = $arr_items['amount'];
        $model->currency_id = $arr_items['currency'] > 0 ? $arr_items['currency'] : FinanceLegder::baseCurrency_id();
        $model->exchange_rate = $arr_items['exchange_rate'] > 0 ? $arr_items['exchange_rate'] : 1;
        $model->amount = $arr_items['amount'];
        $model->reconciled_date=$arr_items['reconciled_date'];
        $cleared=$arr_items['opening_cheque_cleared'];
        if($cleared=='')
        $cleared='N';
        $model->opening_cheque_cleared=$cleared;
        $reconciled=$arr_items['reconciled'];
        if($reconciled=='')
        $reconciled='N';
        $model->reconciled=$reconciled;
        $model->save(false);
        $model->update_currency_code();
        return $model->id>0?$model->id:0;
    }

    public function actionFootermapping()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('footer_mapping');
    }

    public function actionSaveSubledgerType()
    {
        $model = new FinanceSubledgerType();
        if (isset($_POST['FinanceSubledgerType'])) {

            if ((int) @$_POST['FinanceSubledgerType']['id'] > 0) {
                $id = (int) @$_POST['FinanceSubledgerType']['id'];
                $model = $model->findByPk($id);
            }
            $model->attributes = $_POST['FinanceSubledgerType'];
            if ($model->save()) {
                $jsonData['status'] = 'success';
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') {
                    echo $error;
                }

            }

        }
    }

    public function actionNewsubledger()
    {

        $id = (int) Yii::app()->request->getParam('id');
        $model = new FinanceSubledger();
        if ($id > 0) {
            $model = $model->findByPk($id);
        }

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('subledger_create', array('model' => $model));
    }

    public function actionSavesubledger()
    {
        $model = new FinanceSubledger();
        if ((int) @$_POST['FinanceSubledger']['id'] > 0) {
            $model = $model->findByPk((int) @$_POST['FinanceSubledger']['id']);
        } else {
            $model->account_no = 0;
        }

        $model->attributes = $_POST['FinanceSubledger'];
        if ($model->validate()) {
            if ($model->isNewRecord) {
                $model->account_no = FinanceSubledgerType::nextAccount((int) $model->subledger_type_id, true);
            }

            $model->save();
            echo CJSON::encode(array('status' => 'success'));
        } else {
            echo CActiveForm::validate($model, '', false);
        }

    }

    public function actionImportsystemsubledgers()
    {
        echo json_encode(array('status' => 'success'));

        ini_set('max_execution_time', 0);

        $systemSubledgers = FinanceSubledgerType::model()->findAll();
        foreach ($systemSubledgers as $each) {

            $mainModel = $each->table_model;
            $valueField = $each->value_field;
            $updateField = $each->update_field;
            $addressField = $each->address_field;
            $phoneField = $each->phone_field;
            // $currencyField = $each->currency_field;

            if ($mainModel != "" && $valueField != "" && $updateField != "") {
                if( $each->id == 3 ) //Employee
                {
                $items = $mainModel::model()->findAll( array( 'condition' => 'isActive="Y" AND company_id='.(int) Yii::app()->user->master_user_company_id )); 
                }
                else
                {
                $items = $mainModel::model()->findAll(); //array('condition' => $updateField . '="N"')
                }
                foreach ($items as $eachItem) {
                    $exist = FinanceSubledger::model()->find(array('condition' => 'parent_id=' . $eachItem->id . ' AND subledger_type_id=' . $each->id));
                    if ($exist->id > 0) {
                        FinanceSubledger::model()->updateBypk($exist->id, array('description' => $eachItem->$valueField, 'address' => ($addressField != '') ? $eachItem->$addressField : '', 'phone' => ($phoneField != '') ? $eachItem->$phoneField : ''));
                    } else {
                        $newItem = new FinanceSubledger;
                        $newItem->description = $eachItem->$valueField;
                        $newItem->account_no = $eachItem->id;
                        if ($addressField != '') {
                            $newItem->address = $eachItem->$addressField;
                        }

                        if ($phoneField != '') {
                            $newItem->phone = $eachItem->$phoneField;
                        }
                        // $newItem->currecny_id = $eachItem->$currencyField;
                        $newItem->subledger_type_id = $each->id;
                        $newItem->parent_id = $eachItem->id;
                        $newItem->save(false);
                    }
                    $eachItem->$updateField = 'Y';
                    $eachItem->save(false);
                }
            }
        }
    }

    public function actionImportsystemsubledgersType()
    {
        $id = (int) Yii::app()->request->getParam('id');
        ini_set('max_execution_time', 0);
        $systemSubledgers = FinanceSubledgerType::model()->findAll(array('condition'=>'id='.$id));
        
        foreach ($systemSubledgers as $each) {
          
            $mainModel = $each->table_model;
            $valueField = $each->value_field;
            $updateField = $each->update_field;
            $addressField = $each->address_field;
            $phoneField = $each->phone_field;
            
            // $currencyField = $each->currency_field;

            // if ($mainModel != "" && $valueField != "" && $updateField != "") {
                
                if( $each->id == 1 ) //Customer
                $items = $mainModel::model()->findAll(array('condition'=>'(created_date_time>="'.$each->last_sync_date.'" OR updated_date_time>="'.$each->last_sync_date.'") AND updated_date_time!="0000-00-00 00:00:00"'));
                else if( $each->id == 2 ) //Vendor
                $items = $mainModel::model()->findAll(array('condition'=>'(created_date_time>="'.$each->last_sync_date.'" OR updated_date_time>="'.$each->last_sync_date.'") AND updated_date_time!="0000-00-00 00:00:00"'));
                else if( $each->id == 3 ) //Employee
                $items = $mainModel::model()->findAll( array( 'condition' => 'company_id='.(int) Yii::app()->user->master_user_company_id )); 
                else
                $items = $mainModel::model()->findAll(); //array('condition' => $updateField . '="N"')
                foreach ($items as $eachItem) {
                if( $each->id == 1 )
                {
                $industry=$eachItem->customer_industry;
                $emirates=$eachItem->customer_emirates_name;
                $lead_owner=$eachItem->lead_owner_id;
                }
                    $exist = FinanceSubledger::model()->find(array('condition' => 'parent_id=' . $eachItem->id . ' AND subledger_type_id=' . $each->id));
                    if ($exist->id > 0 && ($each->id==1 || $each->id==2 || $each->id==3)) {
                        if( $each->id == 3 )
                        {
                        if($eachItem->employee_id==0) 
                        {
                        $description=$eachItem->$valueField.' - CRM';
                        }
                        else {
                        $description=$eachItem->$valueField; 
                        }
                        }
                        else {
                         $description = $eachItem->$valueField;    
                        }
                        FinanceSubledger::model()->updateBypk($exist->id, array('description' => $description, 'address' => ($addressField != '') ? $eachItem->$addressField : '', 'phone' => ($phoneField != '') ? $eachItem->$phoneField : '','industry' => $industry,'emirates_id' => $emirates));
                    } else {
                        $newItem = new FinanceSubledger;
                        if( $each->id == 3 )
                        {
                        if($eachItem->employee_id==0) 
                        {
                        $newItem->description = $eachItem->$valueField.' - CRM';
                        }
                        else {
                        $newItem->description = $eachItem->$valueField;    
                        }
                        }
                        else {
                        $newItem->description = $eachItem->$valueField;    
                        }
                        $newItem->account_no = $eachItem->id;
                        if ($addressField != '') {
                            $newItem->address = $eachItem->$addressField;
                        }

                        if ($phoneField != '') {
                            $newItem->phone = $eachItem->$phoneField;
                        }
                        // $newItem->currecny_id = $eachItem->$currencyField;
                        $newItem->subledger_type_id = $each->id;
                        $newItem->parent_id = $eachItem->id;
                        $newItem->industry = $industry;
                        $newItem->emirates_id = $emirates;
                        $newItem->lead_owner = $lead_owner;
                        $newItem->save(false);
                    }
                    $eachItem->$updateField = 'Y';
                    $eachItem->save(false);
                }
                $type=FinanceSubledgerType::model()->findByPk($id); 
                $type->last_sync_date=date('Y-m-d H:i:s');  
                $type->save(false);
             echo json_encode(array('status' => 'success'));
            // }
        }
    }

    public function actionPrint()
    {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = FinanceVoucherHead::model()->findBypk($id);
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $mpdf->WriteHTML($this->renderPartial($model->vtype->pdf_layout, array('model' => $model), true));
            $mpdf->Output(date('dmYhis'), 'I');
        } else {
            echo 'Oops!';
        }

    }

    public function actionHavesubledger()
    {
        $account = (int) $_POST['account'];
        echo (FinanceLegder::model()->findBypk($account)->haveSubledger == 'Y') ? 'true' : 'false';
    }

    public function actionAuditclosing()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('audit_closing', array('model' => new FinanceAuditClose));
    }

    public function actionCloseyear_preaudit()
    {
        $type = $_POST['type'];
        $year = $_POST['year'];
        $current_year = date('Y');
        if ($year != '') {
            if ($year < $current_year) {
                $exist = FinanceAuditClose::model()->find(array('condition' => 'year="' . $year . '"'));
                if ((int) $exist->id == 0) {
                    $newClosing = new FinanceAuditClose;
                    $newClosing->year = $year;
                    $newClosing->created_by = Yii::app()->user->id;
                    $newClosing->created_datetime = date('Y-m-d h:i:s');

                    $accountingPeriod = FinanceVoucherType::generateAccountingperiod($year . '-12-31');

                    $balanceQuery = 'SELECT
                                        ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS amount
                                    FROM {{finance_voucher_items}} VI
                                    LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                                    LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id
                                    WHERE V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $accountingPeriod['to'] . '"';
                    $grossProfitorloss = Yii::app()->db->createCommand($balanceQuery)->queryScalar();

                    $lastSavedid = $this->addVoucherhead(array(
                        'voucher_type' => 11,
                        'voucher_no' => $year . '-RETAINED',
                        'voucher_date' => $year . '-12-31',
                        'reference_no' => 'System generated voucher',
                        'is_posted' => 'Y',
                        'created_by' => Yii::app()->user->id,
                        'created_datetime' => date('Y-m-d h:i:s'),
                    ));
                    if ($lastSavedid > 0) {
                        $this->addVoucheritems($lastSavedid, array('narration' => 'Year closing voucher for ' . $year, 'amount' => $grossProfitorloss, 'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('retained_earnings')));
                        $query = 'SELECT
                                    VI.ledger_id AS ledger_id,
                                    VI.subledger_id AS subledger_id,
                                    ROUND((SUM(VI.amount*VI.exchange_rate)), 4) AS amount
                                  FROM {{finance_voucher_items}} VI
                                  LEFT JOIN {{finance_voucher_head}} V ON VI.header_id = V.id
                                  LEFT JOIN {{finance_legder}} L ON VI.ledger_id = L.id
                                  WHERE V.is_posted="Y" AND  L.main_account_type IN ("I", "E") AND V.voucher_date BETWEEN "' . $accountingPeriod['from'] . '" AND "' . $accountingPeriod['to'] . '"
                                  GROUP BY VI.ledger_id, VI.subledger_id';
                        $items = Yii::app()->db->createCommand($query)->queryAll();
                        foreach ($items as $each) {
                            $this->addVoucheritems($lastSavedid,
                                array(
                                    'narration' => 'Year closing voucher for ' . $year,
                                    'amount' => -1 * $each['amount'],
                                    'ledger_id' => $each['ledger_id'],
                                    'subledger_id' => $each['subledger_id'],
                                )
                            );
                        }
                    }
                    $newClosing->voucher_id = $lastSavedid;
                    $newClosing->save(false);
                    echo 'success';
                } else {
                    echo 'Already closed!';
                }

            } else {
                echo 'Nice try :)';
            }

        } else {
            echo 'Invalid year!';
        }

    }

    public function actionUnlockyear_preaudit()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            $voucher_id = FinanceAuditClose::model()->findbypk($id)->voucher_id;
            FinanceAuditClose::model()->deleteBypk($id);
            FinanceVoucherHead::model()->deletebypk($voucher_id);
            FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $voucher_id));
            echo 'success';
        } else {
            echo 'Nice try :)';
        }

    }

    public function actionUpdateyear_finalaudit()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            FinanceAuditClose::model()->updateBypk($id, array('closed' => 'FINAL'));
            echo 'success';
        } else {
            echo 'Nice try :)';
        }

    }

    public function actionAllocationlist()
    {
        $this->render('allocation_index');
    }

    public function actionGetallocationlist()
    {
        $model = new FinanceAllocation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $searchString = trim($_POST['search']['value']);
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.allocation_date',
            2 => 'ledger.description',
            3 => 'subledger.description',
            4 => 't.amount',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $condition = 't.allocation_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

        if ($searchString != "") {
            $condition .= ' AND ( t.id LIKE "%' . $searchString . '%" OR ledger.description LIKE "%' . $searchString . '%" OR subledger.description LIKE "%' . $searchString . '%" )';
        }

        $count = $model->with('ledger', 'subledger')->count(array('condition' => $condition));
        $model = $model->with('ledger', 'subledger')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {

            $div = '<div class="btn-wrap text-center">';
            $div .= ' <button class="btn btn-primary btn-xs" title ="Delete Allocation" onclick="deleteAllocation(' . $eachItem['id'] . ')"><i class="fa fa-remove"></i></button>';
            $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=finance/core/printallocation&id=' . $eachItem['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            $div .= '</div>';

            $eachItemData[] = array($eachItem['id'], date('d/m/Y', strtotime($eachItem['allocation_date'])), $eachItem['ledger']['description'], $eachItem['subledger']['description'], $eachItem['amount'], $div);

        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionDeleteallocation()
    {
        $id = (int) $_POST['id'];
        if ($id > 0) {
            FinanceAllocation::model()->deletebypk($id);
            $modelItem = FinanceAllocationItems::model()->findAll(array('condition' => 'header_id=' . $id));
            foreach ($modelItem as $each):
                FinanceVoucherHead::model()->updateBypk($each->voucher_id, array('is_allocated' => 'N'));
            endforeach;
            FinanceAllocationItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => $id));
            echo 'success';
        } else {
            echo 'Failed to delete!';
        }

    }

    public function actionPrintallocation()
    {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = FinanceAllocation::model()->findBypk($id);
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $mpdf->WriteHTML($this->renderPartial('allocation_pdf', array('model' => $model), true));
            $mpdf->Output(date('dmYhis').".pdf", 'I');
        } else {
            echo 'Oops!';
        }

    }

    public function actionMigrate()
    {
        //ALTER TABLE `erp_fin_general_ledger_head` ADD `migrated` ENUM('Y', 'N', 'D') NOT NULL DEFAULT 'N' AFTER `value`;
        //ALTER TABLE `erp_fin_accounts` ADD `new_account_id` INT NOT NULL AFTER `created_date`;
        //ALTER TABLE `erp_fin_subledger` ADD `new_account_id` INT NOT NULL AFTER `updated_date_time`;
        $all_vouchers = FinGeneralLedgerHead::model()->findAll(array('condition' => 'voucher_type  IN ("OI") AND migrated="N"', 'limit' => 500));
        $arr_voucher_types = array('J1' => 3, 'P1' => 1, 'R1' => 2, 'OI' => 5); //voucher_type_ids
        foreach ($all_vouchers as $each) {

            $modelItem = FinGeneralLedger::model()->find(array('select' => 'SUM(debit) AS debit, SUM(credit) AS credit', 'condition' => 'form_ref_no=' . $each->id));
            $debitSum = $modelItem->debit;
            $creditSum = $modelItem->credit;
            if ($debitSum > 0 && $creditSum > 0 && $creditSum == $debitSum) {
                $voucherHead = array();
                $voucherHead['voucher_type'] = $arr_voucher_types[$each->voucher_type];
                $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno($voucherHead['voucher_type'], true);
                $voucherHead['voucher_date'] = $each->voucher_date;
                $voucherHead['header_table_id'] = 0;
                $voucherHead['reference_no'] = $each->voucher_type . '/' . $each->voucher_no;
                $voucherHead['is_posted'] = 'N';
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

                $lastSavedid = $this->addVoucherhead($voucherHead);

                $items = FinGeneralLedger::model()->findAll(array('condition' => 'form_ref_no=' . $each->id));
                $total = 0;
                foreach ($items as $eachItem):
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = FinAccounts::new_account($eachItem->account_id);
                    $itemsArray['subledger_id'] = Subledger::new_account($eachItem->subledger);
                    $itemsArray['narration'] = $eachItem->item_description;
                    $itemsArray['amount'] = ($eachItem->credit > 0) ? -1 * $eachItem->credit : $eachItem->debit;
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                    $total += $eachItem->credit;
                endforeach;
                FinanceVoucherHead::model()->updateBypk($lastSavedid, array('total_voucher_amount' => $total, 'cheque_cleared' => 'Y'));
                $each->migrated = 'Y';
            } else {
                $each->migrated = 'D';
            }

            $each->update();
            echo 'done' . PHP_EOL;
        }
    }

    public function actionGetnarrations()
    {
        foreach (FinanceVoucherHead::model()->findAll() as $each) {
            $exist = FinGeneralLedger::model()->find(array('condition' => 'voucher_no="' . $each->reference_no . '" AND narration !=""'));
            if ($exist->id > 0) {
                Yii::app()->db->createCommand('UPDATE erp_finance_voucher_items  SET narration= "' . str_replace('"', '', $exist->narration) . '" WHERE header_id=' . $each->id)->execute();
            }
        }
        echo 'done';
    }

    public function actionDeleteledger()
    {
        if ($_POST['id'] > 0) {
            $items=FinanceVoucherItems::model()->findAll(array('condition'=>'ledger_id='.$_POST['id']));
            $ledger=FinanceLegder::model()->findbypk($_POST['id']);
            $child=FinanceLegder::model()->findAll(array('condition'=>'parent_account='.$_POST['id']));
            if(empty($items) && empty($child))
            {
            FinanceLegder::model()->deletebypk($_POST['id']);
            echo 'success';
            }
            else {
            echo 'fail';    
            }
        }
        echo 'fail';
    }

    public function actionDeletesubledger()
    {
        if ($_POST['id'] > 0) {
            $vouchers=FinanceVoucherItems::model()->find(array('condition'=>'subledger_id='.$_POST['id']));
            if(empty($vouchers))
            {
            FinanceSubledger::model()->deletebypk($_POST['id']);
            echo 'success';
            }
            else {
            echo 'fail';    
            }
        }
        echo 'fail';
    }

    public function actionUpdate_refs()
    {
        foreach (FinanceVoucherHead::model()->findAll(array('condition' => 'voucher_type=7 AND header_table_id > 0')) as $each) {
            Yii::app()->db->createCommand('UPDATE erp_finance_voucher_items SET narration="Sales Invoice ' . $each->reference_no . ' PO No ' . $each->salesinvoice->reference . '" WHERE header_id=' . $each->id)->execute();
        }
    }

    public function actionBuild_due_sales()
    {
        foreach (FinanceVoucherHead::model()->findAll(array('condition' => 'voucher_type=7 AND header_table_id > 0')) as $each) {
            $each->due_date = date('Y-m-d', strtotime($each->salesinvoice->invoice_date . ' + ' . (int) $each->salesinvoice->paymentTerm->no_of_days . ' days'));
            $each->save(false);
        }
    }

    public function actionBuild_due_purchase()
    {
        foreach (FinanceVoucherHead::model()->findAll(array('condition' => 'voucher_type=8 AND header_table_id > 0')) as $each) {
            $each->due_date = date('Y-m-d', strtotime($each->purchaseinvoice->purchase_order_date . ' + ' . (int) $each->purchaseinvoice->paymentTerm->no_of_days . ' days'));
            $each->save(false);
        }
    }

    public function actionReconciliation()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('reconciliation');
    }

    public function actionGetbalances()
    {
        $ledger = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $from_date = $_POST['date'];
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-d');

        $condition_for_opening = 'H.is_posted = "Y" AND H.voucher_date < "' . $from_date . '"';
        if ($ledger > 0) {
            $condition .= ' AND t.ledger_id=' . $ledger;
            $condition_for_opening .= ' AND I.ledger_id=' . $ledger;
        }
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }
        $opening_in_books = Yii::app()->db->createCommand('SELECT SUM(I.amount*I.exchange_rate) AS amount FROM erp_finance_voucher_items I LEFT JOIN erp_finance_voucher_head H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' ')->queryScalar();
        $reconciled_in_books = Yii::app()->db->createCommand('SELECT SUM(I.amount*I.exchange_rate) AS amount FROM erp_finance_voucher_items I LEFT JOIN erp_finance_voucher_head H ON I.header_id = H.id WHERE ' . $condition_for_opening . ' AND I.reconciled="Y"')->queryScalar();

        echo json_encode(array('current_balance' => (float) round($opening_in_books, 2), 'opening_balance' => (float) round($reconciled_in_books, 2)));
    }

    // public function actionGet_unreconciled_vouchers()
    // {
    //     $ledger = (int) $_POST['ledger'];
    //     $subledger = (int) $_POST['subledger'];
    //     $to_date = $_POST['date'];
    //     $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-d');

    //     $condition = 't.reconciled="N" AND parent.is_posted="Y" AND parent.voucher_date <= "' . $to_date . '" AND t.ledger_id=' . $ledger;
    //     if ($subledger > 0) {
    //         $condition .= ' AND t.subledger_id=' . $subledger;
    //     }

    //     $funds_in_items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 'amount > 0 AND ' . $condition, 'order' => 'parent.voucher_date ASC'));
    //     $funds_out_items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 'amount < 0 AND ' . $condition, 'order' => 'parent.voucher_date ASC'));

    //     $funds_in = $funds_out = $funds_in_foot = $funds_out_foot = '';
    //     if (!empty($funds_in_items)) {
    //         foreach ($funds_in_items as $i => $each) {
    //             $funds_in .= '<tr>
    //                             <td>' . CHtml::CheckBox('Fundin[' . $i . '][check]', '', array('value' => $each->id, 'onChange' => 'calculateValue();','class'=>'checkbox')) . '</td>
    //                             <td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
    //                             <td>' . $each->parent->fullvoucher . '</td>
    //                             <td>' . $each->parent->vtype->description . '</td>
    //                             <td>' . $each->narration . '</td>
    //                             <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenfield('Fundin[' . $i . '][value]', abs($each->amount * $each->exchange_rate)) . '</td>
    //                         </tr>';
    //         }
    //         $funds_in_foot .= '<tr>
    //                         <td style="padding: 3px 232px;" class="text-right"><b>Total</b></td>
    //                         <td>' . CHtml::textfield('total_funds_in', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
    //                     </tr>';
    //     } else {
    //         $funds_in .= '<tr>
    //                         <td colspan="6" class="text-center">No Data</td>
    //                     </tr>';
    //     }

    //     if (!empty($funds_out_items)) {
    //         foreach ($funds_out_items as $i => $each) {
    //             $funds_out .= '<tr>
    //                             <td>' . CHtml::CheckBox('Fundout[' . $i . '][check]', '', array('value' => $each->id, 'onChange' => 'calculateValue();','class'=>'checkbox1')) . '</td>
    //                             <td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
    //                             <td>' . $each->parent->fullvoucher . '</td>
    //                             <td>' . $each->parent->vtype->description . '</td>
    //                             <td>' . $each->narration . '</td>
    //                             <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenfield('Fundout[' . $i . '][value]', abs($each->amount * $each->exchange_rate)) . '</td>
    //                         </tr>';
    //         }
    //         $funds_out_foot .= '<tr>
    //                                 <td style="padding: 3px 232px;" class="text-right"><b>Total</b></td>
    //                                 <td>' . CHtml::textfield('total_funds_out', 0, array('style' => 'width:100%;', 'class' => 'form-control text-right', 'readonly' => true)) . '</td>
    //                             </tr>';
    //     } else {
    //         $funds_out .= '<tr>
    //                         <td colspan="6" class="text-center">No Data</td>
    //                     </tr>';
    //     }

    //     echo json_encode(array('funds_in' => $funds_in, 'funds_out' => $funds_out, 'funds_in_foot' => $funds_in_foot, 'funds_out_foot' => $funds_out_foot));
    // }

    // public function actionGet_unreconciled_vouchers()
    // {
    //     $ledger = (int) $_POST['ledger'];
    //     $subledger = (int) $_POST['subledger'];
    //     $to_date = $_POST['date'];
    //     $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-d');

    //     $condition = 't.reconciled="N" AND parent.is_posted="Y" AND parent.voucher_date <= "' . $to_date . '" AND t.ledger_id=' . $ledger;
    //     if ($subledger > 0) {
    //         $condition .= ' AND t.subledger_id=' . $subledger;
    //     }

    //     $funds_in_items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 'amount > 0 AND ' . $condition, 'order' => 'parent.voucher_date ASC'));
    //     $funds_out_items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 'amount < 0 AND ' . $condition, 'order' => 'parent.voucher_date ASC'));

    //     $funds_in = $funds_out = $funds_in_foot = $funds_out_foot = '';
    //     if (!empty($funds_in_items)) {
    //         foreach ($funds_in_items as $i => $each) {
    //             $assigned_date=date('d/m/Y', strtotime($each->parent->voucher_date));
    //             $funds_in .= '<tr>
    //                             <td>' . CHtml::CheckBox('Fundin[' . $i . '][check]', '', array('value' => $each->id, 'onChange' => 'calculateValue();','class'=>'checkbox')) . '</td>
    //                             <td>' . CHtml::textField('Fundin[' . $each->id . '][cheque_date]',$assigned_date,array("data-label"=>"Date", "class" => "datepicker","style"=>"max-width: 82px;")). '</td>
    //                             <td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
    //                             <td>' . $each->parent->fullvoucher . '</td>
    //                             <td>' . $each->parent->vtype->description . '</td>
    //                             <td>' . $each->narration . '</td>
    //                             <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenfield('Fundin[' . $i . '][value]', abs($each->amount * $each->exchange_rate)) . '</td>
    //                         </tr>';
    //         }
    //         $funds_in_foot .= '<tr>
    //                         <td style="padding: 3px 200px;" class="text-right"><b>Total</b></td>
    //                         <td>' . CHtml::textfield('total_funds_in', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
    //                     </tr>';
    //     } else {
    //         $funds_in .= '<tr>
    //                         <td colspan="6" class="text-center">No Data</td>
    //                     </tr>';
    //     }

    //     if (!empty($funds_out_items)) {
    //         foreach ($funds_out_items as $i => $each) {
    //             $assigned_date=date('d/m/Y', strtotime($each->parent->voucher_date));
    //             $funds_out .= '<tr>
    //                             <td>' . CHtml::CheckBox('Fundout[' . $i . '][check]', '', array('value' => $each->id, 'onChange' => 'calculateValue();','class'=>'checkbox1')) . '</td>
    //                             <td>' . CHtml::textField('Fundout[' . $each->id . '][cheque_date]',$assigned_date,array("data-label"=>"Date", "class" => "datepicker","style"=>"max-width: 82px;")). '</td>
    //                             <td>' . date('d/m/Y', strtotime($each->parent->voucher_date)) . '</td>
    //                             <td>' . $each->parent->fullvoucher . '</td>
    //                             <td>' . $each->parent->vtype->description . '</td>
    //                             <td>' . $each->narration . '</td>
    //                             <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenfield('Fundout[' . $i . '][value]', abs($each->amount * $each->exchange_rate)) . '</td>
    //                         </tr>';
    //         }
    //         $funds_out_foot .= '<tr>
    //                                 <td style="padding: 3px 200px;" class="text-right"><b>Total</b></td>
    //                                 <td>' . CHtml::textfield('total_funds_out', 0, array('style' => 'width:100%;', 'class' => 'form-control text-right', 'readonly' => true)) . '</td>
    //                             </tr>';
    //     } else {
    //         $funds_out .= '<tr>
    //                         <td colspan="6" class="text-center">No Data</td>
    //                     </tr>';
    //     }

    //     echo json_encode(array('funds_in' => $funds_in, 'funds_out' => $funds_out, 'funds_in_foot' => $funds_in_foot, 'funds_out_foot' => $funds_out_foot));
    // }

    // public function actionSavereconciliation()
    // {
    //     $ledger_id = (int) $_POST['ledger_id'];
    //     $subledger_id = (int) $_POST['subledger_id'];
    //     $opening_balance = (float) $_POST['opening_balance'];
    //     $statement_date = $_POST['statement_date'];
    //     $current_balance = (float) $_POST['current_balance'];

    //     $statement_date = (count(explode('/', $statement_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $statement_date))) : date('Y-m-d');

    //     $i = 0;
    //     $total_funds_in = 0;
    //     $in_ids = $out_ids = $modelItems_in = $modelItems_out = array();
    //     if (!empty($_POST['Fundin'])) {
    //         foreach ($_POST['Fundin'] as $each) {
    //             if ((int) $each['check'] > 0) {
    //                 $modelItems_in[$i] = FinanceVoucherItems::model()->findBypk((int) $each['check']);
    //                 $modelItems_in[$i]->reconciled = 'Y';
    //                 $modelItems_in[$i]->reconciled_date = $statement_date;
    //                 $total_funds_in += (float) $each['value'];
    //                 $in_ids[$i] = $each['check'];
    //                 $i++;
    //             }
    //         }
    //     }
    //     $i = 0;
    //     $total_funds_out = 0;
    //     if (!empty($_POST['Fundout'])) {
    //         foreach ($_POST['Fundout'] as $each) {
    //             if ((int) $each['check'] > 0) {
    //                 $modelItems_out[$i] = FinanceVoucherItems::model()->findBypk((int) $each['check']);
    //                 $modelItems_out[$i]->reconciled = 'Y';
    //                 $modelItems_out[$i]->reconciled_date = $statement_date;
    //                 $total_funds_out += (float) $each['value'];
    //                 $out_ids[$i] = $each['check'];
    //                 $i++;
    //             }
    //         }
    //     }
    //     $reconciled = $opening_balance + $total_funds_in - $total_funds_out;
    //     if ($reconciled == $current_balance && (!empty($modelItems_in) || !empty($modelItems_out))) {
    //         $model = new FinanceReconciliation;
    //         $model->statement_date = $statement_date;
    //         $model->ledger_id = $ledger_id;
    //         $model->subledger_id = $subledger_id;
    //         $model->funds_in_ids = (!empty($in_ids)) ? implode(',', $in_ids) : '';
    //         $model->funds_out_ids = (!empty($out_ids)) ? implode(',', $out_ids) : '';
    //         $model->created_by = Yii::app()->user->id;
    //         $model->created_date_time = date('Y-m-d h:i:s');
    //         $model->save(false);

    //         echo json_encode(array('status' => 'success'));
    //         if (!empty($modelItems_in)) {
    //             foreach ($modelItems_in as $each) {
    //                 $each->reconciliation_id = $model->id;
    //                 $each->save(false);
    //             }
    //         }
    //         if (!empty($modelItems_out)) {
    //             foreach ($modelItems_out as $each) {
    //                 $each->reconciliation_id = $model->id;
    //                 $each->save(false);
    //             }
    //         }

    //     } else {
    //         echo json_encode(array('Something went Wrong!'));
    //     }
    // }

    public function actionGet_unreconciled_vouchers()
    {
        $ledger = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $from_date = $_POST['from_date'];
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-d');
        $to_date = $_POST['to_date'];
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-d');
        // $condition = 't.reconciled="N" AND parent.is_posted="Y" AND parent.voucher_date <= "' . $to_date . '" AND t.ledger_id=' . $ledger;
        $condition = 'parent.is_posted="Y" AND parent.voucher_date >= "' . $from_date . '" AND parent.voucher_date <= "' . $to_date . '" AND t.ledger_id=' . $ledger;
        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
        }

        $funds_in_items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 'amount > 0 AND ' . $condition, 'order' => 'parent.voucher_date ASC'));
        $funds_out_items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => 'amount < 0 AND ' . $condition, 'order' => 'parent.voucher_date ASC'));

        $funds_in = $funds_out = $funds_in_foot = $funds_out_foot = '';
        if (!empty($funds_in_items)) {
            foreach ($funds_in_items as $i => $each) {
                if($each->reconciled_date=='0000-00-00')
                {
                $rec_date=$each->parent->voucher_date;    
                }
                else {
                $rec_date=$each->reconciled_date;    
                }
                $funds_in .= '<tr>
                                <td>' . CHtml::textField('Fundin[' . $each->id . '][statement_date]',date('d/m/Y', strtotime($rec_date)),array("data-label"=>"Statement Date", "class" => "datepicker","style"=>"max-width: 85px;")). '</td>
                                <td>' . $each->parent->fullvoucher . '</td>
                                <td>' . $each->parent->vtype->description . '</td>
                                <td>' . $each->narration . '</td>
                                <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenfield('Fundin[' . $i . '][value]', abs($each->amount * $each->exchange_rate)) . '</td>
                            </tr>';
            }
            $funds_in_foot .= '<tr>
                            <td style="padding: 3px 232px;" class="text-right"><b>Total</b></td>
                            <td>' . CHtml::textfield('total_funds_in', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
                        </tr>';
        } else {
            $funds_in .= '<tr>
                            <td colspan="5" class="text-center">No Data</td>
                        </tr>';
        }

        if (!empty($funds_out_items)) {
            foreach ($funds_out_items as $i => $each) {
                if($each->reconciled_date=='0000-00-00')
                {
                $rec_date=$each->parent->voucher_date;    
                }
                else {
                $rec_date=$each->reconciled_date;    
                }
                $funds_out .= '<tr>
                                <td>' . CHtml::textField('Fundout[' . $each->id . '][statement_date]',date('d/m/Y', strtotime($rec_date)),array("data-label"=>"Statement Date", "class" => "datepicker","style"=>"max-width: 85px;")). '</td>
                                <td>' . $each->parent->fullvoucher . '</td>
                                <td>' . $each->parent->vtype->description . '</td>
                                <td>' . $each->narration . '</td>
                                <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . CHtml::hiddenfield('Fundout[' . $i . '][value]', abs($each->amount * $each->exchange_rate)) . '</td>
                            </tr>';
            }
            $funds_out_foot .= '<tr>
                                    <td style="padding: 3px 232px;" class="text-right"><b>Total</b></td>
                                    <td>' . CHtml::textfield('total_funds_out', 0, array('style' => 'width:100%;', 'class' => 'form-control text-right', 'readonly' => true)) . '</td>
                                </tr>';
        } else {
            $funds_out .= '<tr>
                            <td colspan="5" class="text-center">No Data</td>
                        </tr>';
        }

        echo json_encode(array('funds_in' => $funds_in, 'funds_out' => $funds_out, 'funds_in_foot' => $funds_in_foot, 'funds_out_foot' => $funds_out_foot));
    }

    public function actionSavereconciliation()
    {
        $ledger_id = (int) $_POST['ledger_id'];
        $subledger_id = (int) $_POST['subledger_id'];
        if (!empty($_POST['Fundin'])) {
            foreach ($_POST['Fundin'] as $i=>$each) {
                if ((int) $i > 0) {
                    $statement_date = $_POST['Fundin'][$i]['statement_date'];
                    if(!empty($statement_date))
                    {
                    $statement_date = (count(explode('/', $statement_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $statement_date))) : date('Y-m-d');
                    $modelItems_in = FinanceVoucherItems::model()->findBypk((int) $i);
                    $modelItems_in->reconciled = 'Y';
                    $modelItems_in->reconciled_date = $statement_date;
                    $modelItems_in->save();
                    $in_ids[$i] = $i;
                    }
                }
            }
        }
        if (!empty($_POST['Fundout'])) {
            foreach ($_POST['Fundout'] as $i=>$each) {
                    if ((int) $i > 0) {
                        $statement_date = $_POST['Fundout'][$i]['statement_date'];
                        if(!empty($statement_date))
                        {
                        $statement_date = (count(explode('/', $statement_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $statement_date))) : date('Y-m-d');
                        $modelItems_out = FinanceVoucherItems::model()->findBypk((int) $i);
                        $modelItems_out->reconciled = 'Y';
                        $modelItems_out->reconciled_date = $statement_date;
                        $modelItems_out->save();
                        $out_ids[$i] = $i;
                        }
                    }
        }
    }
            $model = new FinanceReconciliation;
            $model->statement_date = date('Y-m-d');
            $model->ledger_id = $ledger_id;
            $model->subledger_id = $subledger_id;
            $model->funds_in_ids = (!empty($in_ids)) ? implode(',', $in_ids) : '';
            $model->funds_out_ids = (!empty($out_ids)) ? implode(',', $out_ids) : '';
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->save(false);
            echo json_encode(array('status' => 'success'));
    }
    
    public function actionReconciliationlist()
    {
        $this->render('reconciliation_index');
    }

    public function actionGet_reconciliation_history()
    {
        $model = new FinanceReconciliation();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $searchString = trim($_POST['search']['value']);
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 't.statement_date',
            2 => 'ledger.description',
            3 => 'subledger.description',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $condition = 't.statement_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

        if ($searchString != "") {
            $condition .= ' AND ( t.id LIKE "%' . $searchString . '%" OR ledger.description LIKE "%' . $searchString . '%" OR subledger.description LIKE "%' . $searchString . '%" )';
        }

        $count = $model->with('ledger', 'subledger')->count(array('condition' => $condition));
        $model = $model->with('ledger', 'subledger')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;

        foreach ($model as $eachItem) {

            $div = '<div class="btn-wrap text-center">';
            $div .= ' <button class="btn btn-primary btn-xs" title ="Delete Allocation" onclick="deleteReconciliation(' . $eachItem['id'] . ')"><i class="fa fa-remove"></i></button>';
            $div .= ' <a class="btn btn-primary btn-xs" title="Print PDF" target="_blank" href="?r=finance/core/printreconciliation&id=' . $eachItem['id'] . '"><i class="fa fa-file-pdf-o"></i></a>';
            $div .= '</div>';
            if($eachItem->funds_in_ids!='' || $eachItem->funds_out_ids!='')
            {
            $vouchers='';
            $cheque_no='';
            $in_arr = explode(",", $eachItem->funds_in_ids);
            $out_arr = explode(",", $eachItem->funds_out_ids);
            //in
            if(!empty($in_arr))
            {
            foreach($in_arr as $each_in)
            {
            $in_fin_items=FinanceVoucherItems::model()->findByPk((int)$each_in);
            if(!empty($in_fin_items))
            {
            if($vouchers=='')
            {
            $vouchers.=$in_fin_items->parent->vtype->code.'/'.$in_fin_items->parent->voucher_no;    
            }
            else {
            $vouchers.=','.$in_fin_items->parent->vtype->code.'/'.$in_fin_items->parent->voucher_no;     
            }
            if($cheque_no=='')
            {
            $cheque_no.=$in_fin_items->parent->cheque_no;    
            }
            else {
            $cheque_no.=','.$in_fin_items->parent->cheque_no;     
            }
            }
            }
            }
            //out
            if(!empty($out_arr))
            {
            foreach($out_arr as $each_out)
            {
            $in_fin_items=FinanceVoucherItems::model()->findByPk($each_out);
            if(!empty($in_fin_items))
            {
            if(empty($vouchers))
            {
            $vouchers.=$in_fin_items->parent->vtype->code.'/'.$in_fin_items->parent->voucher_no;    
            }
            else {
            $vouchers.=','.$in_fin_items->parent->vtype->code.'/'.$in_fin_items->parent->voucher_no;     
            }
            if(empty($cheque_no))
            {
            $cheque_no.=$in_fin_items->parent->cheque_no;    
            }
            else {
            $cheque_no.=','.$in_fin_items->parent->cheque_no;     
            }
            }
            }
            }
            }
            // $vouchers=$eachItem->funds_in_ids;
            // $cheque_no=$eachItem->funds_out_ids;
            $eachItemData[] = array($eachItem['id'], date('d/m/Y', strtotime($eachItem['statement_date'])), $eachItem['ledger']['description'], $eachItem['subledger']['description'],$vouchers, $div);

        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    public function actionPrintreconciliation()
    {
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = FinanceReconciliation::model()->findBypk($id);
            $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
            $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
            $mpdf->WriteHTML($stylesheet, 1);
            $mpdf->WriteHTML($this->renderPartial('reconciliation_pdf', array('model' => $model), true));
            $mpdf->Output(date('dmYhis').".pdf", 'I');
        } else {
            echo 'Oops!';
        }

    }

    public function actionDeletereconciliation()
    {
        $id = $_POST['id'];
        if ($id > 0) {
            $model = FinanceReconciliation::model()->findBypk($id);
            if ($model->funds_in_ids != '') {
                Yii::app()->db->createCommand('UPDATE {{finance_voucher_items}} SET reconciled="N", reconciliation_id=0,  reconciled_date="0000-00-00" WHERE id IN(' . $model->funds_in_ids . ')')->execute();
            }

            if ($model->funds_out_ids != '') {
                Yii::app()->db->createCommand('UPDATE {{finance_voucher_items}} SET reconciled="N", reconciliation_id=0,  reconciled_date="0000-00-00" WHERE id IN(' . $model->funds_out_ids . ')')->execute();
            }

            FinanceReconciliation::model()->deleteBypk($id);
        }
        echo 'success';
    }

    public function actionChequemanagement()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('cheque_management');
    }

    public function actionGet_uncleared_pdc()
    {
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $type = (int) $_POST['type'];

        $count = 0;
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');

        $response = '';
        $legder = ($type == 1) ? FinanceSystemAccountsMapping::getSystemdefault('pdc_r') : FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        if ($legder > 0) {
            $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => '( parent.voucher_type=' . FinanceVoucherType::get_voucher_id('OB') . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="N" AND parent.is_posted="Y" AND t.ledger_id=' . $legder . ' ) OR parent.is_posted="Y" AND t.ledger_id=' . $legder . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="N" AND parent.voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ', 'order' => 'parent.voucher_date ASC'));
            if (!empty($items)) {
                foreach ($items as $i => $each) {
                    // $assigned_date=date('d/m/Y', strtotime(($each->parent->cheque_date != '0000-00-00') ? $each->parent->cheque_date : $each->parent->voucher_date));
                    $assigned_date=date('d/m/Y', strtotime($each->parent->voucher_date));
                    $bank='';
                    $options=FinanceSubledger::getSubledgers(FinanceLegder::getBankId());
                    if($type==2)
                    {
                    $bank=$each->subledger_id;
                    $options=array($each->subledger_id=>$each->subledger->description);
                    }
                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id,'class'=>'checkbox')) . '</td>
                                    <td>'.date('d/m/Y', strtotime($each->parent->voucher_date)).'</td>
                                    <td>' .$assigned_date. CHtml::hiddenField('ClearedCheque[' . $each->id . '][cheque_date]',$assigned_date). '</td>
                                    <td>' . CHtml::dropdownlist('ClearedCheque[' . $each->id . '][subledger_id]',$bank,$options, array('class'=>'tooltipster', 'data-label' => 'Bank')). '</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $each->subledger->description . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . '</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $count++;
                }
            } else {
                $response .= '<tr>
                                <td colspan="7" class="text-center"> No Data</td>
                            </tr>';
            }
        } else {
            $response .= '<tr>
                                <td colspan="7" class="text-center"> Please map accounts Properly</td>
                            </tr>';
        }

        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count));
    }

    public function actionSavecheques()
    {
        $items = array();
        $i = 0;
        $ledger_id = (int) $_POST['ledger_id'];
        $subledger_id = (int) $_POST['subledger_id'];
        $type = (int) $_POST['type']; // 1 - Receivable 2 - Payable
        // $cleared_date = $_POST['cleared_date'];
        // $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
        $clearing_account = ($type == 1) ? FinanceSystemAccountsMapping::getSystemdefault('pdc_r') : FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        $clearing_value = ($type == 1) ? -1 : 1;
        $response = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));

            
            $totalValue = 0;
            $arr_cheques = array();
            foreach ($items as $each) {
            $ledger_id = (int)FinanceLegder::getBankId();
            $subledger_id = (int)$_POST['ClearedCheque'][$each]['subledger_id'];
            $cleared_date = $_POST['ClearedCheque'][$each]['cheque_date'];
            $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
            if($ledger_id > 0 && $subledger_id > 0)
            {
                $model = FinanceVoucherItems::model()->findBypk($each);
                $model->opening_cheque_cleared = 'Y';
                $model->update();

                $voucherHead = array();
                $voucherHead['voucher_type'] = 3; //Journal Voucher
                $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno($voucherHead['voucher_type'], true);
                $voucherHead['voucher_date'] = $cleared_date; //Y-m-d
                $voucherHead['header_table_id'] = 0;
                $voucherHead['reference_no'] = 'Cheques Cleared';
                $voucherHead['is_posted'] = 'Y';
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
                $voucherHead['cheque_no'] = $model->parent->cheque_no;

                $lastSavedid = $this->addVoucherhead($voucherHead);

                $itemsArray = array();
                $itemsArray['ledger_id'] = $model->ledger_id;
                $itemsArray['subledger_id'] = $model->subledger_id;
                $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' |  Dated ' . date('d/m/Y', strtotime($model->parent->cheque_date));
                $itemsArray['amount'] = $clearing_value * abs($model->amount);
                $itemsArray['reconciled']='N';
                $totalValue += $itemsArray['amount'];
                $this->addVoucheritems($lastSavedid, $itemsArray);
                $arr_cheques[] = $model->parent->cheque_no;
                // BANK
            $itemsArray = array();
            $itemsArray['ledger_id'] = $ledger_id;
            $itemsArray['subledger_id'] = $subledger_id;
            $itemsArray['subledger_id'] = $subledger_id;
            $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' |  Dated ' . date('d/m/Y', strtotime($model->parent->cheque_date));
            $itemsArray['amount'] = -1 * $clearing_value * abs($model->amount);
            $itemsArray['reconciled']='N';
            $itemsArray['opening_cheque_cleared'] ='Y';
            $this->addVoucheritems($lastSavedid, $itemsArray);
            FinanceVoucherHead::model()->updateBypk($each->header_id, array('cheque_cleared' => 'Y'));
            FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => abs($model->amount)));
            }
            }
            
            // FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => abs($totalValue))); //$netTotal
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }

            // if ($ledger_id == 0) {
            //     $response[] = 'Ledger cannot blank';
            // }

            // if ($ledger_id > 0 && FinanceLegder::is_subledger_account($ledger_id) && $subledger_id == 0) {
            //     $response[] = 'Subledger cannot blank';
            // }

            echo json_encode($response);
        }
    }

    public function actionSavechequesreturn()
    {
        $items = array();
        $i = 0;
        $ledger_id = (int) $_POST['ledger_id'];
        $subledger_id = (int) $_POST['subledger_id'];
        $type = (int) $_POST['type']; 
        // 1 - Receivable 2 - Payable
        // $cleared_date = $_POST['cleared_date'];
        // $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
        $response = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));
            
            

            $arr_cheques = array();
            $parent_ids = array();
            $totalValue = 0;

            foreach ($items as $each) {
                
                $cleared_date = $_POST['ClearedCheque'][$each]['cheque_date'];
                $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
                
                $model = FinanceVoucherItems::model()->findBypk($each);
                $model->cheque_bounced = 'Y';
                $model->no_bounced = $model->no_bounced+1;
                $model->update();

                $voucherHead = array();
                $voucherHead['voucher_type'] = 3; //Journal Voucher
                $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno($voucherHead['voucher_type'], true);
                $voucherHead['voucher_date'] = $cleared_date; //Y-m-d
                $voucherHead['header_table_id'] = 0;
                $voucherHead['reference_no'] = 'Cheques Returned';
                $voucherHead['is_posted'] = 'Y';
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
                $voucherHead['cheque_no'] = $model->parent->cheque_no;
    
                $lastSavedid = $this->addVoucherhead($voucherHead);


                // if ($model->parent->voucher_type != FinanceVoucherType::get_voucher_id('OB')) {
                    $modelHead = FinanceVoucherHead::model()->findBypk($model->header_id);
                    $modelHead->cheque_bounced = 'Y';
                    $modelHead->update();
                        foreach ($modelHead->items as $each) {
                            $itemsArray = array();
                            $itemsArray['ledger_id'] = $each->ledger_id;
                            $itemsArray['subledger_id'] = $each->subledger_id;
                            $itemsArray['narration'] = 'Voucher No ' . $each->parent->fullvoucher . ' | Cheque No ' . $each->parent->cheque_no . ' Returned';
                            $itemsArray['amount'] = -1 * $each->amount;
                            $this->addVoucheritems($lastSavedid, $itemsArray);
                            if ($each->amount > 0) {
                                $totalValue = $each->amount;
                            }

                        }
                // } else {
                //     $itemsArray = array();
                //     $itemsArray['ledger_id'] = $model->ledger_id;
                //     $itemsArray['subledger_id'] = $model->subledger_id;
                //     $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                //     $itemsArray['amount'] = -1 * $model->amount;
                //     $itemsArray['reconciled']='N';
                //     $this->addVoucheritems($lastSavedid, $itemsArray);

                //     $itemsArray = array();
                //     $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('retained_earnings');
                //     $itemsArray['subledger_id'] = 0;
                //     $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                //     $itemsArray['amount'] = $model->amount;
                //     $itemsArray['reconciled']='N';
                //     $this->addVoucheritems($lastSavedid, $itemsArray);

                //     if ($model->amount > 0) {
                //         $totalValue = $model->amount;
                //     } 
                // }
                FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => abs($totalValue))); 
            }

            // if (!empty($parent_ids)) {
            //     foreach ($parent_ids as $each) {
            //         $model = FinanceVoucherHead::model()->findBypk($each);
            //         $model->cheque_bounced = 'Y';
            //         $model->update();

            //         if ($model->voucher_type != FinanceVoucherType::get_voucher_id('OB')) {
            //             foreach ($model->items as $each) {
            //                 $itemsArray = array();
            //                 $itemsArray['ledger_id'] = $each->ledger_id;
            //                 $itemsArray['subledger_id'] = $each->subledger_id;
            //                 $itemsArray['narration'] = 'Voucher No ' . $each->parent->fullvoucher . ' | Cheque No ' . $each->parent->cheque_no . ' Returned';
            //                 $itemsArray['amount'] = -1 * $each->amount;
            //                 $this->addVoucheritems($lastSavedid, $itemsArray);
            //                 if ($each->amount > 0) {
            //                     $totalValue += $each->amount;
            //                 }

            //             }
            //         }
            //     }
            // }

            

        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }

            echo json_encode($response);
        }
    }

    public function actionExport_vouchers()
    {
      
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $voucher_type = (int) $_GET['voucher_type'];
        $posting_type = $_GET['posting_type'];
        $chq_flag = $_GET['chq_flag'];

        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');
        $condition = 'code != "YC" AND voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"';

        if ($voucher_type > 0) {
            $condition .= ' AND voucher_type_id=' . $voucher_type;
        }

        if ($posting_type != '') {
            $condition .= ' AND is_posted="' . $posting_type . '"';
        }

        $model = Yii::app()->db->createCommand('SELECT * FROM {{finance_voucher_head_list}} WHERE ' . $condition . ' ORDER BY voucher_date ASC')->queryAll();
        Yii::import('ext.PHPExcel.PHPExcel');

        // Create new PHPExcel object
        $excel = new PHPExcel();

        // Set document properties
        $excel->getActiveSheet()->getColumnDimensionByColumn(0)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(1)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(2)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(3)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(4)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setAutoSize(true);
        $excel->getActiveSheet()->getColumnDimensionByColumn(7)->setAutoSize(true);

        if( $chq_flag == 'false' ){
            $excel->getActiveSheet()->getColumnDimensionByColumn(5)->setVisible(false);
            $excel->getActiveSheet()->getColumnDimensionByColumn(6)->setVisible(false);
        }

        $excel->getProperties()->setCreator("Bluesky ERP")
            ->setLastModifiedBy("Bluesky ERP")
            ->setTitle("Vouchers list")
            ->setSubject("Vouchers list")
            ->setDescription("Vouchers list Generated on " . date('d/m/Y'))
            ->setKeywords("Vouchers list")
            ->setCategory("Financial Report");

        // Add some data
        $excel->setActiveSheetIndex(0)
            ->setCellValue('A1', 'Date')
            ->setCellValue('B1', 'Voucher')
            ->setCellValue('C1', 'Ledger')
            ->setCellValue('D1', 'Subledger')
            ->setCellValue('E1', 'Reference')
            ->setCellValue('F1', 'CHQ No')
            ->setCellValue('G1', 'CHQ Date')
            ->setCellValue('H1', 'Amount');

        $excel->getActiveSheet()->getStyle('A1:H1')->getFont()->setBold(true)->setSize(14);
        $parent = 2;
        foreach ($model as $eachItem) {
            $excel->setActiveSheetIndex(0)
                ->setCellValue('A' . $parent, date('d/m/Y', strtotime($eachItem['voucher_date'])))
                ->setCellValue('B' . $parent, $eachItem['voucher_no'])
                ->setCellValue('C' . $parent, str_replace(',', PHP_EOL, $eachItem['ledger']))
                ->setCellValue('D' . $parent, str_replace(',', PHP_EOL, $eachItem['subledger']))
                ->setCellValue('E' . $parent, $eachItem['reference_no'])
                ->setCellValue('F' . $parent, $eachItem['cheque_no'])
                ->setCellValue('G' . $parent, $eachItem['cheque_date'] != '0000-00-00' ? date('d/m/Y', strtotime($eachItem['cheque_date'])) : '')
                ->setCellValue('H' . $parent, Yii::app()->numberFormatter->formatCurrency($eachItem['value'], " "));

            $excel->getActiveSheet()->getStyle('C' . $parent . ':D' . $parent)->getAlignment()->setWrapText(true);
            $parent++;
        }

        // Redirect output to a client’s web browser (Excel2007)
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="vouchers.xlsx"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');

        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
        header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header('Pragma: public'); // HTTP/1.0

        $objWriter = PHPExcel_IOFactory::createWriter($excel, 'Excel2007');
        $objWriter->save('php://output');
        exit;

    }

    public function actionPost_unpost()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('bulk_posting');
    }

    public function actionGet_posted_unposted_vouchers()
    {
        $status = $_POST['status'];
        $voucher = $_POST['voucher'];

        $from_date = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');

        $table = '<table class="table table-hover table-bordered" id="table_post" >
                    <tr>
                        <th>' . CHtml::CheckBox('checkAll', false, array('class' => 'checkall', 'id' => 'all', 'onclick' => ' $("#table_post input:checkbox").prop("checked", $(this).prop("checked"));')) . '</th>
                        <th>Voucher No</th>
                        <th>Voucher Date</th>
                        <th>Reference</th>
                        <th>Party</th>
                        <th>Amount (' . FinanceLegder::baseCurrency() . ')</th>
                    </tr>';

        $model = FinanceVoucherHead::model()->findAll(array('select' => 'id, voucher_no, voucher_type, voucher_date', 'condition' => 'voucher_type="' . $voucher . '" AND is_posted="' . $status . '" AND voucher_date BETWEEN "' . $from_date . '" AND "' . $to_date . '"'));
        if (!empty($model)) {
            foreach ($model as $each):
                $table .= '<tr>
	                                        <td>' . CHtml::CheckBox("ids[]", '', array('value' => $each->id)) . '</td>
	                                        <td>' . $each->Fullvoucher . '</td>
	                                        <td>' . date('d/m/Y', strtotime($each->voucher_date)) . '</td>
	                                        <td>' . $each->reference_no . '</td>
	                                        <td>' . $each->get_any_subledger() . '</td>
	                                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency($each->debit_total_base, " ") . '</td>
	                                    </tr>';
            endforeach;
        } else {
            $table .= '<tr>
                                <td colspan="6" class="text-center">No Items</td>
                             </tr>';
        }

        $table .= '</table>';
        echo $table;
    }

    public function actionUpdatestatus()
    {

        $warnings = array();
        $post = $_POST['status'] == 'N' ? true : false;

        function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        if (count($_POST['ids']) > 0) {
            foreach ($_POST['ids'] as $each) {
                if ($each > 0) {
                    $voucherModel = FinanceVoucherHead::model()->findBypk($each);
                    if (isPostable($voucherModel->voucher_date)) {
                        if ($post) { //Posing
                            if ($voucherModel->is_postable_voucher()) {
                                $voucherModel->is_posted = 'Y';
                                $voucherModel->save(false);
                            } else {
                                $warnings[] = $voucherModel->vtype->description . ' ' . $voucherModel->Fullvoucher . ' have some error, Please fix';
                            }
                        } else { //Unposting
                            if ($voucherModel->is_allocated == 'N' && !$voucherModel->haveReconcilation()) {
                                $voucherModel->is_posted = 'N';
                                $voucherModel->save(false);
                            } else {
                                $warnings[] = $voucherModel->vtype->description . ' ' . $voucherModel->Fullvoucher . ' have allocaion or reconciliation';
                            }
                        }
                    } else {
                        $warnings[] = $voucherModel->vtype->description . ' ' . $voucherModel->Fullvoucher . ' is Audited, cannot do the operation';
                    }
                }
            }
        } else {
            $warnings[] = 'No vouchers';
        }

        echo json_encode(array('status' => 'success', 'warnings' => $warnings));
    }

    public function actionVoucher_maintenance(){
        
        function getSublegder($parnet_id, $subledger_type)
        {
            return FinanceSubledger::model()->find(array('condition' => 'parent_id=' . (int) $parnet_id . ' AND subledger_type_id=' . (int) $subledger_type))->id;
        }
        
        foreach( FinanceVoucherHead::model()->findAll( array( 'condition' => 'voucher_type IN(7, 10)' ) ) as $each ){
            $model = $each->voucher_type == 7 ? new Invoice: new Creditnote;
            $model = $model->findBypk($each->header_table_id);
            if($each->voucher_type == 10)
            {
            $employee_id=User::model()->findByPk($model->invoice->lead_owner_id)->connected_employee_id;
            if($employee_id>0)
            {
            $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id));    
            if($leadowner_id==0)
            {
            $leadowner_id=$model->invoice->lead_owner_id;        
            }
            }
            else {
            $leadowner_id=$model->invoice->lead_owner_id;    
            }
            }
            else {
            $employee_id=User::model()->findByPk($model->lead_owner_id)->connected_employee_id;
            if($employee_id>0)
            {
            $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id));   
            if($leadowner_id==0)
            {
            $leadowner_id=$model->lead_owner_id;        
            }
            }
            else {
            $leadowner_id=$model->lead_owner_id;    
            }
            }
            $each->emp_subledger = $each->voucher_type == 10 ? getSublegder($leadowner_id, 3) : getSublegder($leadowner_id, 3);
            $each->update();
        }

        echo 'done';
    }

    public function actionPrint_vouchers()
    {
        $from_date = $_GET['from_date'];
        $to_date = $_GET['to_date'];
        $voucher_type = (int) $_GET['voucher_type'];
        $posting_type = $_GET['posting_type'];

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('print_filter', array('from_date' => $from_date, 'to_date' => $to_date, 'voucher_type' => $voucher_type, 'posting_type' => $posting_type ));
    }
    
    public function actionChequestatuschange()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('cheque_statuschange');
    }

    public function actionGet_cleared_pdc()
    {
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $type = (int) $_POST['type'];

        $count = 0;
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');

        $response = '';
        $legder = ($type == 1) ? FinanceSystemAccountsMapping::getSystemdefault('pdc_r') : FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        if ($legder > 0) {
            $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => '( parent.voucher_type=' . FinanceVoucherType::get_voucher_id('OB') . ' AND t.opening_cheque_cleared="Y" AND parent.is_posted="Y" AND t.ledger_id=' . $legder . ' ) OR parent.is_posted="Y" AND t.ledger_id=' . $legder . ' AND t.opening_cheque_cleared="Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ', 'order' => 'parent.cheque_date ASC'));
            if (!empty($items)) {
                foreach ($items as $i => $each) {
                    $assigned_date=date('d/m/Y', strtotime(($each->parent->cheque_date != '0000-00-00') ? $each->parent->cheque_date : $each->parent->voucher_date));
                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id,'class'=>'checkbox')) . '</td>
                                    <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][cleared_date]',$assigned_date,array("data-label"=>"Return Date", "class" => "datepicker")). '</td>
                                    <td>' . CHtml::dropdownlist('ClearedCheque[' . $each->id . '][subledger_id]', '',FinanceSubledger::getSubledgers(FinanceLegder::getBankId()), array('class'=>'tooltipster', 'data-label' => 'Bank')). '</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $each->subledger->description . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . '</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $count++;
                }
            } else {
                $response .= '<tr>
                                <td colspan="7" class="text-center"> No Data</td>
                            </tr>';
            }
        } else {
            $response .= '<tr>
                                <td colspan="7" class="text-center"> Please map accounts Properly</td>
                            </tr>';
        }

        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count));
    }

    public function actionSavechequesstatuschange()
    {
        $items = array();
        $i = 0;
        $ledger_id = (int) $_POST['bank_ledger_id'];
        $subledger_id = (int) $_POST['bank_subledger_id'];
        $type = (int) $_POST['type']; // 1 - Receivable 2 - Payable
        // $cleared_date = $_POST['cleared_date'];
        // $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
        $clearing_account = ($type == 1) ? FinanceSystemAccountsMapping::getSystemdefault('pdc_r') : FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        $clearing_value = ($type == 1) ? 1 : -1;
        $response = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));

            $totalValue = 0;
            $arr_cheques = array();
            foreach ($items as $each) {

                $cleared_date = $_POST['ClearedCheque'][$each]['cleared_date'];
                $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
    
                $ledger_id = (int)FinanceLegder::getBankId();
                $subledger_id = (int)$_POST['ClearedCheque'][$each]['subledger_id'];
    
                $model = FinanceVoucherItems::model()->findBypk($each);
                $model->opening_cheque_cleared = 'N';
                $model->cheque_bounced = 'Y';
                $model->no_bounced = $model->no_bounced+1;
                $model->update();

                $voucherHead = array();
                $voucherHead['voucher_type'] = 3; //Journal Voucher
                $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno($voucherHead['voucher_type'], true);
                $voucherHead['voucher_date'] = $cleared_date; //Y-m-d
                $voucherHead['header_table_id'] = 0;
                $voucherHead['reference_no'] = 'Cheques Bounced';
                $voucherHead['is_posted'] = 'Y';
                $voucherHead['created_by'] = Yii::app()->user->id;
                $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
                $voucherHead['cheque_no'] = $model->parent->cheque_no;
    
                $lastSavedid = $this->addVoucherhead($voucherHead);

                //PDC DEBIT
                // $itemsArray = array();
                // $itemsArray['ledger_id'] = $model->ledger_id;
                // $itemsArray['subledger_id'] = $model->subledger_id;
                // $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' |  Dated ' . date('d/m/Y', strtotime($model->parent->cheque_date));
                // $itemsArray['amount'] = $clearing_value * abs($model->amount);
                // $this->addVoucheritems($lastSavedid, $itemsArray);
                
                $totalValue = $clearing_value * abs($model->amount);
                if($type==1)
                {
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = $model->ledger_id;
                    $itemsArray['subledger_id'] = $model->subledger_id;
                    $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                    $itemsArray['amount'] = -1 * $clearing_value * $model->amount;
                    $itemsArray['reconciled']='N';
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                }
                else if($type==2){
                    $itemsArray = array();
                    $itemsArray['ledger_id'] = $model->ledger_id;
                    $itemsArray['subledger_id'] = $model->subledger_id;
                    $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                    $itemsArray['amount'] = 1 * $clearing_value * $model->amount;
                    $itemsArray['reconciled']='N';
                    $this->addVoucheritems($lastSavedid, $itemsArray);
                }
                    //Sundry Debtors
                    // $itemsArray = array();
                    // $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('retained_earnings');
                    // $itemsArray['subledger_id'] = 0;
                    // $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                    // $itemsArray['amount'] = $clearing_value * abs($model->amount);
                    // $this->addVoucheritems($lastSavedid, $itemsArray);

                    $modelHead = FinanceVoucherHead::model()->findBypk($model->header_id);
                    if($type==1)
                    {
                    if ($modelHead->voucher_type != FinanceVoucherType::get_voucher_id('OB')) {
                        foreach ($modelHead->items as $eachHead) {
                            $itemsArray = array();
                            $itemsArray['ledger_id'] = $eachHead->ledger_id;
                            $itemsArray['subledger_id'] = $eachHead->subledger_id;
                            $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                            $itemsArray['amount'] = 1 * $clearing_value * $model->amount;
                            $itemsArray['reconciled']='N';
                            $this->addVoucheritems($lastSavedid, $itemsArray);
                        }
                    }
                    }
                    else if($type==2){
                        if ($modelHead->voucher_type != FinanceVoucherType::get_voucher_id('OB')) {
                            foreach ($modelHead->items as $eachHead) {
                                $itemsArray = array();
                                $itemsArray['ledger_id'] = $eachHead->ledger_id;
                                $itemsArray['subledger_id'] = $eachHead->subledger_id;
                                $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                                $itemsArray['amount'] = -1 * $clearing_value * $model->amount;
                                $itemsArray['reconciled']='N';
                                $this->addVoucheritems($lastSavedid, $itemsArray);
                            }
                        }
                    }
                $arr_cheques[] = $model->parent->cheque_no;

                FinanceVoucherHead::model()->updateBypk($each, array('cheque_cleared' => 'N','cheque_bounced' => 'Y'));
                //BANK
            if($type==1)
            {
            $itemsArray = array();
            $itemsArray['ledger_id'] = $ledger_id;
            $itemsArray['subledger_id'] = $subledger_id;
            $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
            $itemsArray['amount'] = -1 * $clearing_value * $model->amount;
            $itemsArray['reconciled']='N';
            $this->addVoucheritems($lastSavedid, $itemsArray);
            }
            else if($type==2){
                $itemsArray = array();
                $itemsArray['ledger_id'] = $ledger_id;
                $itemsArray['subledger_id'] = $subledger_id;
                $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Returned';
                $itemsArray['amount'] = 1 * $clearing_value * $model->amount;
                $itemsArray['reconciled']='N';
                $this->addVoucheritems($lastSavedid, $itemsArray);    
            }
            FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => abs($totalValue))); //$netTotal
            }
            
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }

            if ($ledger_id == 0) {
                $response[] = 'Ledger cannot blank';
            }

            if ($ledger_id > 0 && FinanceLegder::is_subledger_account($ledger_id) && $subledger_id == 0) {
                $response[] = 'Subledger cannot blank';
            }

            echo json_encode($response);
        }
    }
    public function actionBouncedchequestatuschange()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('bounced_cheque_statuschange');
    }
    public function actionGet_bounced_pdc()
    {
        $from_date = $_POST['from_date'];
        $to_date = $_POST['to_date'];
        $type = (int) $_POST['type'];

        $count = 0;
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');

        $response = '';
        $legder = ($type == 1) ? FinanceSystemAccountsMapping::getSystemdefault('pdc_r') : FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        if ($legder > 0) {
            $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => '( parent.voucher_type=' . FinanceVoucherType::get_voucher_id('OB') . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="Y" AND parent.is_posted="Y" AND t.ledger_id=' . $legder . ' ) OR parent.is_posted="Y" AND t.ledger_id=' . $legder . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="Y" AND parent.cheque_date BETWEEN "' . $from_date . '" AND "' . $to_date . '" ', 'order' => 'parent.cheque_date ASC'));
            if (!empty($items)) {
                foreach ($items as $i => $each) {
                    $assigned_date=date('d/m/Y', strtotime(($each->parent->cheque_date != '0000-00-00') ? $each->parent->cheque_date : $each->parent->voucher_date));
                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id,'class'=>'checkbox')) . '</td>
                                    <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][resubmit_date]',$assigned_date,array("data-label"=>"Resubmit Date", "class" => "datepicker")). '</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $each->subledger->description . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") . '</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $count++;
                }
            } else {
                $response .= '<tr>
                                <td colspan="7" class="text-center"> No Data</td>
                            </tr>';
            }
        } else {
            $response .= '<tr>
                                <td colspan="7" class="text-center"> Please map accounts Properly</td>
                            </tr>';
        }

        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count));
    }
    public function actionSavechequesstatuschangeresubmit()
    {
        $items = array();
        $i = 0;
        $ledger_id = (int) $_POST['bank_ledger_id'];
        $subledger_id = (int) $_POST['bank_subledger_id'];
        $type = (int) $_POST['type']; // 1 - Receivable 2 - Payable
        // $cleared_date = $_POST['cleared_date'];
        // $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
        $clearing_account = ($type == 1) ? FinanceSystemAccountsMapping::getSystemdefault('pdc_r') : FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        $clearing_value = ($type == 1) ? 1 : -1;
        $response = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));
            $arr_cheques = array();
            $parent_ids = array();

            foreach ($items as $each) {
            $totalValue = 0;
            $cleared_date = $_POST['ClearedCheque'][$each]['resubmit_date'];
            $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : date('Y-m-d');
            $model = FinanceVoucherItems::model()->findBypk($each);
            $model->cheque_bounced = 'N';
            $model->update();
            $voucherHead = array();
            $voucherHead['voucher_type'] = 3; //Journal Voucher
            $voucherHead['voucher_no'] = FinanceVoucherType::getVoucherno($voucherHead['voucher_type'], true);
            $voucherHead['voucher_date'] = $cleared_date; //Y-m-d
            $voucherHead['header_table_id'] = 0;
            $voucherHead['reference_no'] = 'Cheques Resubmitted';
            $voucherHead['is_posted'] = 'Y';
            $voucherHead['created_by'] = Yii::app()->user->id;
            $voucherHead['created_datetime'] = date('Y-m-d h:i:s');
            $voucherHead['cheque_no'] = $model->parent->cheque_no;
            
            $lastSavedid = $this->addVoucherhead($voucherHead);
                

                // if ($model->parent->voucher_type != FinanceVoucherType::get_voucher_id('OB')) {
                    $modelHead = FinanceVoucherHead::model()->findBypk($model->header_id);
                    $modelHead->cheque_bounced = 'N';
                    $modelHead->update();
                        foreach ($modelHead->items as $each) {
                            $itemsArray = array();
                            $itemsArray['ledger_id'] = $each->ledger_id;
                            $itemsArray['subledger_id'] = $each->subledger_id;
                            $itemsArray['narration'] = 'Voucher No ' . $each->parent->fullvoucher . ' | Cheque No ' . $each->parent->cheque_no . ' Resubmitted';
                            $itemsArray['amount'] = 1 * $each->amount;
                            $itemsArray['reconciled']='N';
                            $this->addVoucheritems($lastSavedid, $itemsArray);
                            if ($each->amount > 0) {
                                $totalValue = $each->amount;
                            }
                        }
                // } else {
                //     $itemsArray = array();
                //     $itemsArray['ledger_id'] = $model->ledger_id;
                //     $itemsArray['subledger_id'] = $model->subledger_id;
                //     $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Resubmitted';
                //     $itemsArray['amount'] = 1 * $model->amount;
                //     $itemsArray['reconciled']='N';
                //     $this->addVoucheritems($lastSavedid, $itemsArray);

                //     $itemsArray = array();
                //     $itemsArray['ledger_id'] = FinanceSystemAccountsMapping::getSystemdefault('retained_earnings');
                //     $itemsArray['subledger_id'] = 0;
                //     $itemsArray['narration'] = 'Voucher No ' . $model->parent->fullvoucher . ' | Cheque No ' . $model->parent->cheque_no . ' Resubmitted';
                //     $itemsArray['amount'] = -1 * $model->amount;
                //     $itemsArray['reconciled']='N';
                //     $this->addVoucheritems($lastSavedid, $itemsArray);

                //     if ($model->amount > 0) {
                //         $totalValue = $model->amount;
                //     }
                // }
                FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => abs($totalValue))); //$netTotal
            }

            // if (!empty($parent_ids)) {
            //     foreach ($parent_ids as $each) {
            //         $model = FinanceVoucherHead::model()->findBypk($each);
            //         $model->cheque_bounced = 'N';
            //         $model->update();

            //         if ($model->voucher_type != FinanceVoucherType::get_voucher_id('OB')) {
            //             foreach ($model->items as $each) {
            //                 $itemsArray = array();
            //                 $itemsArray['ledger_id'] = $each->ledger_id;
            //                 $itemsArray['subledger_id'] = $each->subledger_id;
            //                 $itemsArray['narration'] = 'Voucher No ' . $each->parent->fullvoucher . ' | Cheque No ' . $each->parent->cheque_no . ' Resubmitted';
            //                 $itemsArray['amount'] = 1 * $each->amount;
            //                 $this->addVoucheritems($lastSavedid, $itemsArray);
            //                 if ($each->amount > 0) {
            //                     $totalValue += $each->amount;
            //                 }

            //             }
            //         }
            //     }
            // }
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }
            echo json_encode($response);
        }
    }
    public function actionChequemanagementnew()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('cheque_management_new');
    }
    public function actionGet_uncleared_pdc_new()
    {
        $from_date = $_REQUEST['from_date'];
        $to_date = $_REQUEST['to_date'];
        $bank_id = (int) $_REQUEST['bank'];
        $status = $_REQUEST['status'];
        $bank_total_amt=0;
        $count = 0;
        $from_date = (count(explode('/', $from_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $from_date))) : date('Y-m-01');
        $to_date = (count(explode('/', $to_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $to_date))) : date('Y-m-t');

        $response = '';
        $legder = FinanceSystemAccountsMapping::getSystemdefault('pdc_r').','.FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
        $bank=FinanceSystemAccountsMapping::getSystemdefault('bank');
        $opening_balance=Yii::app()->db->createCommand('select ROUND(SUM(amount*exchange_rate),2) from {{finance_voucher_items}} I INNER JOIN {{finance_voucher_head}} H ON H.id=I.header_id where ledger_id='.$bank.' AND subledger_id='.$bank_id.' AND H.voucher_date<="'.$to_date.'" AND H.is_posted="Y"')->queryScalar();
        if($status=='N')
        {
        $opening_balance_bank_rec=Yii::app()->db->createCommand('select ROUND(SUM(amount*exchange_rate),2) from {{finance_voucher_items}} I INNER JOIN {{finance_voucher_head}} H ON H.id=I.header_id where ledger_id='.$bank.' AND subledger_id='.$bank_id.' AND  H.voucher_date<="'.$to_date.'"'.'  AND H.is_posted="Y"')->queryScalar();
        }
        else {
        $opening_balance_bank_rec=Yii::app()->db->createCommand('select ROUND(SUM(amount*exchange_rate),2) from {{finance_voucher_items}} I INNER JOIN {{finance_voucher_head}} H ON H.id=I.header_id where ledger_id='.$bank.' AND subledger_id='.$bank_id.' AND I.reconciled="Y" AND I.reconciled_date<"'.$from_date.'"'.' AND I.reconciled_date!="0000-00-00" AND H.is_posted="Y"')->queryScalar();
        }
        // echo 'select ROUND(SUM(amount*exchange_rate),2) from {{finance_voucher_items}} I INNER JOIN {{finance_voucher_head}} H ON H.id=I.header_id where ledger_id='.$bank.' AND subledger_id='.$bank_id.' AND H.realisation_date<="'.$to_date.'"'.' AND H.realisation_date>"0000-00-00" AND H.is_posted="Y"';die;
        // $items = FinanceVoucherItems::model()->with('parent')->findAll(array('condition' => '( parent.voucher_type=' . FinanceVoucherType::get_voucher_id('OB') . ' AND t.opening_cheque_cleared="N" AND t.cheque_bounced="N" AND parent.is_posted="Y" AND t.ledger_id IN (' . $legder . ') ) OR parent.is_posted="Y" AND t.ledger_id IN (' . $legder . ') AND t.opening_cheque_cleared="N" AND t.cheque_bounced="N" AND parent.cheque_date >= "' . $from_date . '" AND parent.cheque_date <= "' . $to_date . '" ', 'order' => 'parent.cheque_date ASC'));
        if($status=='N')
        {
        $items = FinanceVoucherItems::model()->with('parent')->findAll((array('condition' => 'parent.is_posted="Y" AND t.ledger_id='.$bank.' AND subledger_id='.$bank_id.' AND (parent.voucher_date<="'.$to_date.'") AND ( t.reconciled!="Y" OR ( t.reconciled="Y" AND t.reconciled_date>"'.$to_date.'"))')));
        }
        else if($status=='Y') {
        $items = FinanceVoucherItems::model()->with('parent')->findAll((array('condition' => 'parent.is_posted="Y" AND t.ledger_id='.$bank.' AND subledger_id='.$bank_id.' AND t.reconciled="Y" AND (parent.voucher_date>="'.$from_date.'" AND parent.voucher_date<="'.$to_date.'")')));
        }
        else if($status=='ALL') {
        $items = FinanceVoucherItems::model()->with('parent')->findAll((array('condition' => 'parent.is_posted="Y" AND t.ledger_id='.$bank.' AND subledger_id='.$bank_id.' AND (parent.voucher_date>="'.$from_date.'" AND parent.voucher_date<="'.$to_date.'")'))); 
        }
        $received=0;
        $paid=0;    
        if (!empty($items)) {
                foreach ($items as $i => $each) {
                    if(($each->reconciled_date!='0000-00-00') && ($each->reconciled=='Y'))
                    {
                    $assigned_date=date('d/m/Y', strtotime($each->reconciled_date));
                    $as_val=$assigned_date;
                    }
                    else {
                    $assigned_date=date('d/m/Y', strtotime($each->parent->voucher_date));
                    $as_val='';
                    }
                    $bank='';
                    $options=FinanceSubledger::getSubledgers(FinanceLegder::getBankId());
                    if($type==2)
                    {
                    $bank=$each->subledger_id;
                    $options=array($each->subledger_id=>$each->subledger->description);
                    }
                    if($each->amount>0)
                    {
                    $prefix='Dr';
                    }
                    else {
                    $prefix='Cr';    
                    }
                    $ass_date_id='#ClearedCheque_'.$each->id.'_cheque_date';
                    $ass_date_value=$assigned_date;
                    $check_id='#Cleared_'.$i.'_check';
                    $item='calculateValue("'.$ass_date_id.'","'.$ass_date_value.'","'.$check_id.'")';
                    $voucher_items = FinanceVoucherItems::model()->findAll(array('condition'=>'id!='.$each->id.' AND header_id='.$each->header_id));
                    $other_accounts='';
                    foreach($voucher_items as $z=>$vitems)
                    {
                    if($z==0)
                    {
                    $other_accounts.=$vitems->ledger->description.' ('.$vitems->subledger->description.')';
                    }  
                    else {
                    $other_accounts.=', '.$vitems->ledger->description.' ('.$vitems->subledger->description.')';    
                    }  
                    }
                    if($each->amount<0)
                    {
                    $response .= '<tr>
                                    <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id,'class'=>'checkbox','onclick'=>'calculateValue("'.$ass_date_id.'","'.$ass_date_value.'","'.$check_id.'")')) . '</td>
                                    <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][cheque_date]',$as_val,array("data-label"=>"Date", "class" => "datepicker")).'</td>
                                    <td>' . $each->parent->fullvoucher . '</td>
                                    <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                                    <td>' . $each->parent->cheque_no . '</td>
                                    <td>' . $other_accounts . '</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(0, " ").'</td>
                                    <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") .CHtml::hiddenField('ClearedCheque[' . $each->id . '][values]',$each->amount*$each->exchange_rate).CHtml::hiddenField('ClearedCheque[' . $i . '][as_date_id]',$ass_date_id).CHtml::hiddenField('ClearedCheque[' . $i . '][as_date]',$ass_date_value).'</td>
                                    <td>' . $each->narration . '</td>
                                 </tr>';
                    $bank_total_amt+=$each->amount*$each->exchange_rate;
                    $paid+=-1*$each->amount*$each->exchange_rate;
                    }
                    else {
                        $response .= '<tr>
                        <td>' . CHtml::CheckBox('Cleared[' . $i . '][check]', '', array('value' => $each->id,'class'=>'checkbox','onclick'=>'calculateValue("'.$ass_date_id.'","'.$ass_date_value.'","'.$check_id.'")')) . '</td>
                        <td>' . CHtml::textField('ClearedCheque[' . $each->id . '][cheque_date]',$as_val,array("data-label"=>"Date", "class" => "datepicker")).'</td>
                        <td>' . $each->parent->fullvoucher . '</td>
                        <td>' . date("d/m/Y", strtotime($each->parent->voucher_date)) . '</td>
                        <td>' . $each->parent->cheque_no . '</td>
                        <td>' . $other_accounts . '</td>
                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(abs($each->amount * $each->exchange_rate), " ") .CHtml::hiddenField('ClearedCheque[' . $each->id . '][values]',$each->amount*$each->exchange_rate).CHtml::hiddenField('ClearedCheque[' . $i . '][as_date_id]',$ass_date_id).CHtml::hiddenField('ClearedCheque[' . $i . '][as_date]',$ass_date_value).'</td>
                        <td class="text-right">' . Yii::app()->numberFormatter->formatCurrency(0, " ").'</td>
                        <td>' . $each->narration . '</td>
                     </tr>'; 
                    $bank_total_amt+=$each->amount*$each->exchange_rate;  
                    $received+=$each->amount*$each->exchange_rate;
                    }
                    $count++;
                }
            } else {
                $response .= '<tr>
                                <td colspan="7" class="text-center"> No Data</td>
                            </tr>';
            }
            $bank_total_amt+=$opening_balance_bank_rec;
        // echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count,'opening_balance'=>$opening_balance,'bank_total_amount'=>$bank_total_amt,'paid'=>$paid,'received'=>$received,'opening_balance_bank_rec'=>$opening_balance_bank_rec));
        echo json_encode(array('cheque_in_body' => $response, 'count_of_items' => $count,'opening_balance'=>($opening_balance_bank_rec),'bank_total_amount'=>$bank_total_amt,'paid'=>$paid,'received'=>$received,'opening_balance_bank_rec'=>$opening_balance_bank_rec));
    }
    public function actionSavechequesnew()
    {
        $items = array();
        $i = 0;
        $ledger_id = (int)FinanceSystemAccountsMapping::getSystemdefault('bank');
        $subledger_id = (int) $_POST['bank'];
//        $type = (int) $_POST['type'];
//        $clearing_account = ($type == 1) ? FinanceSystemAccountsMapping::getSystemdefault('pdc_r') : FinanceSystemAccountsMapping::getSystemdefault('pdc_i');
//        $clearing_value = ($type == 1) ? -1 : 1;
        $response = array();

        if (!empty($_POST['Cleared'])) {
            foreach ($_POST['Cleared'] as $each) {
                if ($each['check'] > 0) {
                    $items[$i] = $each['check'];
                    $i++;
                }
            }
        }

        if (count($items) > 0) {
            echo json_encode(array('status' => 'success'));

            $totalValue = 0;
            $arr_cheques = array();
            foreach ($items as $each) {
            $ledger_id = (int)FinanceLegder::getBankId();
            $cleared_date = $_POST['ClearedCheque'][$each]['cheque_date'];
            $cleared_value = $_POST['ClearedCheque'][$each]['values'];
            $clearing_value = ($cleared_value>0) ? -1 : 1;
            $cleared_date = (count(explode('/', $cleared_date)) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $cleared_date))) : '0000-00-00';
            if($ledger_id > 0 && $subledger_id > 0)
            {
                $model = FinanceVoucherItems::model()->findBypk($each);
                $model->reconciled_date=$cleared_date;
                if($cleared_date=='0000-00-00')
                {
                $model->reconciled = 'N';
                }
                else {
                $model->reconciled = 'Y';
                }
                $model->update();
                $bank_item_id=$model->id;
            //Reconciliation
            FinanceReconciliation::model()->deleteAll(array('condition'=>'funds_in_ids='.$bank_item_id.' OR funds_out_ids='.$bank_item_id));
            if($cleared_date!='0000-00-00')
            {
            $model = new FinanceReconciliation;
            $model->statement_date = date('Y-m-d');
            $model->ledger_id = $ledger_id;
            $model->subledger_id = $subledger_id;
            if($clearing_value>0)
            {
            $model->funds_in_ids = $bank_item_id; 
            }
            else {
            $model->funds_out_ids = $bank_item_id;
            }
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->save(false);
            }
            }
            }
        } else {
            if (count($items) == 0) {
                $response[] = 'Select atleast one line of item!';
            }

            echo json_encode($response);
        }
    }
    public function actionPostExpenseVoucher()
    {
    $created_by=Yii::app()->user->id;
    $cash=FinanceSystemAccountsMapping::getSystemdefault('cash_account');
    $to_account=$_POST['to_account'];
    $have_to_subledger='N';
    if($to_account>0)
    {
    $ledger=FinanceLegder::model()->findByPk($to_account);
    if(($ledger->haveSubledger=='Y') && (int)$_POST['to_subledger_id']==0)
    {
    $have_to_subledger='Y';    
    }
    }
    $from_account=$_POST['from_account'];
    $have_from_subledger='N';
    if($from_account>0)
    {
    $ledger=FinanceLegder::model()->findByPk($from_account);
    if(($ledger->haveSubledger=='Y') && (int)$_POST['from_subledger_id']==0)
    {
    $have_from_subledger='Y';    
    }
    }
    if(isset($_POST['from_account']) &&isset($_POST['to_account']) && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($_POST['amount']>$_POST['vat_amount']) && ($have_to_subledger=='N') && ($have_from_subledger=='N'))
    {
    function savableDate( $date ){
    $last_closed_year = FinanceAuditClose::lastClosed();
    $voucherDate_array = explode('-', $date);
    $voucherYear = $voucherDate_array[0];
    return ( $voucherYear <= $last_closed_year ) ? false : true;
    }
                
    $model= new FinanceVoucherHead;
    $vouchertype=FinanceVoucherType::model()->find(array('condition'=>'code="PV"'))->id;

    $model->voucher_type=$vouchertype;
    $model->voucher_no = FinanceVoucherType::getVoucherno( $model->voucher_type, true);
    $model->voucher_date= (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
    $model->due_date= (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
    $model->total_voucher_amount=$_POST['amount'];
    $model->general_narration=$_POST['narration'];
    $model->is_posted='Y';
    $model->created_by=Yii::app()->user->id;
    $model->created_datetime = date('Y-m-d h:i:s');
    $savableVoucher = savableDate($model->voucher_date);
    if($savableVoucher)
    {
    $model->save();
    $modelItems=new FinanceVoucherItems;    
    $modelItems->header_id=$model->id;
    $modelItems->ledger_id=$from_account;
    $modelItems->subledger_id=$_POST['from_subledger_id'];
    $modelItems->narration=$_POST['narration'];
    $modelItems->amount=-($_POST['amount']);
    $modelItems->currency_code=1;
     $modelItems->currency_id=1;
    $modelItems->exchange_rate=1;
    $modelItems->save(false);
    // Debit Side
    $modelItems=new FinanceVoucherItems;    
    $modelItems->header_id=$model->id;
    $modelItems->ledger_id=$_POST['to_account'];
    $modelItems->subledger_id=$_POST['to_subledger_id'];
    $modelItems->narration=$_POST['narration'];
    $modelItems->amount=(float)($_POST['amount'])-(float)($_POST['vat_amount']);
    $modelItems->currency_code=1;
     $modelItems->currency_id=1;
    $modelItems->exchange_rate=1;
    $modelItems->save(false);
    // VAT
    if($_POST['vat_amount']>0)
    {
    $modelItems=new FinanceVoucherItems;    
    $modelItems->header_id=$model->id;
    $modelItems->ledger_id=FinanceSystemAccountsMapping::getSystemdefault('vat_on_expense');
    $modelItems->narration=$_POST['narration'];
    $modelItems->amount=$_POST['vat_amount'];
    $modelItems->currency_code=1;
    $modelItems->currency_id=1;
    $modelItems->exchange_rate=1;
    $modelItems->save(false);
    }
    
    // Allocation
    if($_POST['total_allocation_amount']>0)
    {   
            $model = new FinanceAllocation;
            $model->ledger_id = $_POST['from_account'];
            $model->subledger_id = $_POST['from_subledger_id'];
            $model->allocation_date = date('Y-m-d');
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->amount = $_POST['amount'];
            $model->save(false);
            
            $totalDebit = $totalCredit = 0;
            $debitArray = $creditArray = array();
            foreach ($_POST['Credit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $debitArray[$i] = new FinanceAllocationItems;
                    $debitArray[$i]->header_id = $model->id;
                    $debitArray[$i]->voucher_id = $each['voucher_id'];
                    $debitArray[$i]->voucher_item_id = $each['voucher_item_id'];
                    $debitArray[$i]->amount = -1*(float)$each['amount'];
                    $debitArray[$i]->save(false);
                    FinanceVoucherHead::model()->updateBypk($debitArray[$i]->voucher_id, array('is_allocated' => 'Y'));
                    $totalDebit += (float)$each['amount'];
                }
            }
                
                    $creditArray[0] = new FinanceAllocationItems;
                    $creditArray[0]->header_id = $model->id;
                    $creditArray[0]->voucher_id = $modelItems->header_id;
                    $creditArray[0]->voucher_item_id = $modelItems->id;
                    $creditArray[0]->amount = ($_POST['amount']);
                    $totalCredit += (float)($_POST['amount']);
                    $creditArray[0]->save(false);
                    FinanceVoucherHead::model()->updateBypk($creditArray[0]->voucher_id, array('is_allocated' => 'Y'));
    }
    
    $jsonData['status'] = 'success';
    echo CJSON::encode($jsonData);
    }
    else {
    $jsonData['status'] = 'Year closed';
    echo CJSON::encode($jsonData);
    }
    }
    else {
    if($_POST['vat_amount']>$_POST['amount'])    
    {
    $jsonData['status'] = 'Amount must be greater than VAT';    
    }
    else {
    $jsonData['status'] = 'Please fill all mandatory fields';
    }
    echo CJSON::encode($jsonData);
    }
    }
    public function actionPostSingleReceiptVoucher()
    {
    $created_by=Yii::app()->user->id;
    $cash=FinanceSystemAccountsMapping::getSystemdefault('cash_account');
    $to_account=$_POST['to_account'];
    $have_to_subledger='N';
    if($to_account>0)
    {
    $ledger=FinanceLegder::model()->findByPk($to_account);
    if(($ledger->haveSubledger=='Y') && (int)$_POST['to_subledger_id']==0)
    {
    $have_to_subledger='Y';    
    }
    }
    $from_account=$_POST['from_account'];
    $have_from_subledger='N';
    if($from_account>0)
    {
    $ledger=FinanceLegder::model()->findByPk($from_account);
    if(($ledger->haveSubledger=='Y') && (int)$_POST['from_subledger_id']==0)
    {
    $have_from_subledger='Y';    
    }
    }
    $valid=true;
    if($_POST['total_allocation_amount']!=$_POST['amount'] && $_POST['total_allocation_amount']>0)
    {
    $valid=false;    
    }
    if(isset($_POST['from_account']) &&isset($_POST['to_account']) && isset($_POST['voucher_date']) && isset($_POST['amount']) && ($have_to_subledger=='N') && ($have_from_subledger=='N' && $valid))
    {
    function savableDate( $date ){
    $last_closed_year = FinanceAuditClose::lastClosed();
    $voucherDate_array = explode('-', $date);
    $voucherYear = $voucherDate_array[0];
    return ( $voucherYear <= $last_closed_year ) ? false : true;
    }
                
    $model= new FinanceVoucherHead;
    $vouchertype=FinanceVoucherType::model()->find(array('condition'=>'code="CA"'))->id;

    $model->voucher_type=$vouchertype;
    $model->voucher_no = FinanceVoucherType::getVoucherno( $model->voucher_type, true);
    $model->voucher_date= (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
    $model->due_date= (count(explode('/', $_POST['voucher_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date']))) : date('Y-m-d');
    $model->total_voucher_amount=$_POST['amount'];
    $model->general_narration=$_POST['narration'];
    $model->is_posted='Y';
    $model->created_by=Yii::app()->user->id;
    $model->created_datetime = date('Y-m-d h:i:s');
    if($_POST['to_account']==9)
    {
    $model->payment_method = 1;
    }
    else if($_POST['to_account']==8)
    {
    $model->payment_method = 3;    
    $model->bank_name=$_POST['bank'];
    $model->cheque_no=$_POST['cheque_no'];
    $model->cheque_date=(count(explode('/', $_POST['cheque_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date']))) : date('Y-m-d');
    }
    else if($_POST['to_account']==10)
    {
    $model->payment_method = 2;  
    $model->bank_name=$_POST['bank'];
    $model->cheque_no=$_POST['cheque_no'];
    $model->cheque_date=(count(explode('/', $_POST['cheque_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['cheque_date']))) : date('Y-m-d');
    }
    $savableVoucher = savableDate($model->voucher_date);
    if($savableVoucher)
    {
    $model->save(false);
    $modelItems=new FinanceVoucherItems;    
    $modelItems->header_id=$model->id;
    $modelItems->ledger_id=$to_account;
    $modelItems->subledger_id=$_POST['to_subledger_id'];
    $modelItems->narration=$_POST['narration'];
    $modelItems->amount=$_POST['amount'];
    $modelItems->currency_code=1;
     $modelItems->currency_id=1;
    $modelItems->exchange_rate=1;
    $modelItems->save(false);
    // Debit Side
    $modelItems=new FinanceVoucherItems;    
    $modelItems->header_id=$model->id;
    $modelItems->ledger_id=$_POST['from_account'];
    $modelItems->subledger_id=$_POST['from_subledger_id'];
    $modelItems->narration=$_POST['narration'];
    $modelItems->amount=-($_POST['amount']);
    $modelItems->currency_code=1;
     $modelItems->currency_id=1;
    $modelItems->exchange_rate=1;
    $modelItems->save(false);
    // Allocation
    if($_POST['total_allocation_amount']>0)
    {   
            $model = new FinanceAllocation;
            $model->ledger_id = $_POST['from_account'];
            $model->subledger_id = $_POST['from_subledger_id'];
            $model->allocation_date = date('Y-m-d');
            $model->created_by = Yii::app()->user->id;
            $model->created_date_time = date('Y-m-d h:i:s');
            $model->amount = $_POST['amount'];
            $model->save(false);
            
            $totalDebit = $totalCredit = 0;
            $debitArray = $creditArray = array();
            foreach ($_POST['Debit'] as $i => $each) {
                if ($each['amount'] > 0) {
                    $debitArray[$i] = new FinanceAllocationItems;
                    $debitArray[$i]->header_id = $model->id;
                    $debitArray[$i]->voucher_id = $each['voucher_id'];
                    $debitArray[$i]->voucher_item_id = $each['voucher_item_id'];
                    $debitArray[$i]->amount = $each['amount'];
                    $debitArray[$i]->save(false);
                    FinanceVoucherHead::model()->updateBypk($debitArray[$i]->voucher_id, array('is_allocated' => 'Y'));
                    $totalDebit += (float)$each['amount'];
                }
            }
                
                    $creditArray[0] = new FinanceAllocationItems;
                    $creditArray[0]->header_id = $model->id;
                    $creditArray[0]->voucher_id = $modelItems->header_id;
                    $creditArray[0]->voucher_item_id = $modelItems->id;
                    $creditArray[0]->amount = -($_POST['amount']);
                    $totalCredit += (float)($_POST['amount']);
                    $creditArray[0]->save(false);
                    FinanceVoucherHead::model()->updateBypk($creditArray[0]->voucher_id, array('is_allocated' => 'Y'));
    }
    $jsonData['status'] = 'success';
    echo CJSON::encode($jsonData);
    }
    else {
    $jsonData['status'] = 'Year closed';
    echo CJSON::encode($jsonData);
    }
    }
    else {
    if($valid==false)
    {
    $jsonData['status'] = 'Amounts are not matching';    
    }
    else {
    $jsonData['status'] = 'Please fill all mandatory fields';
    }
    echo CJSON::encode($jsonData);
    }
    }
    public function actionAccountSorting()
    {
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('account_sorting', array());
    }
  public function actionEditAccountSortOrder()
  {
  if(isset($_POST['accounts']) && isset($_POST['level']))
  {
  $accounts = FinanceLegder::model()->findAll(array('condition'=>'main_account_type="'.$_POST['accounts'].'" AND level='.(int)$_POST['level']));
  $accounts=CHtml::listData($accounts,'id','description');
  $jsondata['list']='<div id="lists">'.CHtml::dropDownList('listname','', 
  $accounts,  array('data-label'=>'Accounts','prompt'=>'select one','id'=>'listname','onChange'=>'getChildAccounts(this.value)')).'</div>';
  $jsondata['status']='success';
  echo CJSON::encode($jsondata);
   }
   else {
   $jsondata['status']='fail';
   echo CJSON::encode($jsondata);

}     
}
    public function actionSaveAccountSortOrder()
    {
    if(isset($_POST['child']))
    {
    $count=$_POST['count'];
    for($i=0;$i<=$count;$i++)
    {
    $account=FinanceLegder::model()->findByPk($_POST['child'][$i]);
    $account->account_order=$_POST['child_list'][$i];  
    $account->save(false);
    }
    $jsonData['status'] = 'success';
    echo CJSON::encode($jsonData);
    }
    else {
    $jsonData['status'] = 'fail';
    echo CJSON::encode($jsonData);
    }
    }
    public function actionFetChchild() {
        $accounts = FinanceLegder::model()->findAll(array('condition'=>'parent_account='.(int) $_POST['listname'],'order'=>'sort_order'));
        $parent=FinanceLegder::model()->findByPk($_POST['listname']);
        $jsondata['list']='<table><tr><th>Accounts</th><th>Sort Order - '.$parent->account_order.'</th></tr>';
        foreach ($accounts as $i=>$row)
        {
        $jsondata['list'].='<tr><td>'.$row->description.'</td><td>'.CHtml::textField('child_list['.$i.']',$row->account_order).CHtml::hiddenField('child['.$i.']',$row->id).'</td></tr>';
        }
        $jsondata['list'].='</table>';
        $jsondata['list'].=CHtml::hiddenField('count',$i);
        $jsondata['status']='success';
        echo CJSON::encode($jsondata);
    }
    
    public function actionCostSalesVoucher()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-08-10") AND H.voucher_type=7 AND I.ledger_id=7 AND product_id=0';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    $items = Yii::app()->db->createCommand('SELECT
                                            product_id,
                                            part_number,
                                            description,
                                            generic_id,
                                            brand_class_id,
                                            invoice_id,
                                            item_id,
                                            net_amount_wo_discount AS net_amount_bc,
                                            SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                            SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                            SUM( bonus_net_amount_wo_discount ) AS total_bonus_sales,
                                            SUM( discount ) AS discount,
                                            SUM( total_tax_amount) AS total_tax_amount,
                                            SUM( addition_amount) AS total_add_amount,
                                            SUM( deduction_amount) AS total_ded_amount,
                                            ROUND(total_cost, 2) AS total_cost,
                                            emirate_id
                                        FROM(
                                                SELECT 
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_class_id,
                                                    I.id AS invoice_id,
                                                    II.id AS item_id,
                                                    SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                    SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                    SUM( II.addition_amount ) AS addition_amount,
                                                    SUM( II.deduction_amount ) AS deduction_amount,
                                                    SUM( II.bonus_qty * II.rate ) AS bonus_net_amount_wo_discount,
                                                    SUM(II.deduction_amount) AS discount,
                                                    SUM( ( ( II.quantity + II.bonus_qty ) * II.cost_rate ) ) AS total_cost,
                                                    C.customer_emirates_name AS emirate_id
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                LEFT JOIN {{store}} S ON S.id = II.product_id
                                                WHERE I.id="' . $each['header_table_id'] . '" AND S.inventory_item_type=1 group by II.id
                                            ) AS A group by item_id ')->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    if($amount==$eachItem['total_cost'])   
    {
    if($i==0)
    {
    $narration='Sales #' . $each['header_table_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_class_id'];
    }
    $i++;
    }
    }
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$eachItem['total_cost'];die;
    if($i==1 && $item_id>1)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
    }
    }
    }
    }
    
    public function actionSalespriceInventorySalesVoucher()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-08-03") AND H.voucher_type=7 AND I.ledger_id=101';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=abs($each['amount']);
    $items = Yii::app()->db->createCommand('
                                        SELECT
                                            product_id,
                                            part_number,
                                            description,
                                            generic_id,
                                            brand_class_id,
                                            invoice_id,
                                            item_id,
                                            net_amount_wo_discount AS net_amount_bc,
                                            SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                            SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                            SUM( bonus_net_amount_wo_discount ) AS total_bonus_sales,
                                            SUM( discount ) AS discount,
                                            SUM( total_tax_amount) AS total_tax_amount,
                                            SUM( addition_amount) AS total_add_amount,
                                            SUM( deduction_amount) AS total_ded_amount,
                                            ROUND(total_cost, 6) AS total_cost,
                                            emirate_id
                                        FROM(
                                                SELECT 
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_class_id,
                                                    I.id AS invoice_id,
                                                    II.id AS item_id,
                                                    SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                    SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                    SUM( II.addition_amount ) AS addition_amount,
                                                    SUM( II.deduction_amount ) AS deduction_amount,
                                                    SUM( II.bonus_qty * II.rate ) AS bonus_net_amount_wo_discount,
                                                    SUM(II.deduction_amount) AS discount,
                                                    SUM( ( ( II.quantity + II.bonus_qty ) * II.cost_rate ) ) AS total_cost,
                                                    C.customer_emirates_name AS emirate_id
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                LEFT JOIN {{store}} S ON S.id = II.product_id
                                                WHERE I.id="' . $each['header_table_id'] . '" AND S.inventory_item_type=1 group by II.id
                                            ) AS A group by item_id ')->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    $sales_amount=abs($eachItem['total_sales']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount']);
    $sales_amount=round($sales_amount,2);
    if($amount==$sales_amount)   
    {
    if($i==0)
    {
    $narration='Sales #' . $each['header_table_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_class_id'];
    }
    $i++;
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$sales_amount.'<br>';
    }
    }
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$sales_amount.'<br>';
    if($i==1 && $item_id>0)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$sales_amount.'///'.$product_id.'///'.$generic_id.'///'.$brand.'<br>'.$each['id'].'<br>';
    }
    }
    }
//    die;
    }
    
    public function actionSalespriceServiceSalesVoucher()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-08-09") AND H.voucher_type=7 AND I.ledger_id=101 AND product_id=0';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    $items = Yii::app()->db->createCommand('
                                        SELECT
                                            product_id,
                                            part_number,
                                            description,
                                            generic_id,
                                            brand_class_id,
                                            invoice_id,
                                            item_id,
                                            net_amount_wo_discount AS net_amount_bc,
                                            SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                            SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                            SUM( bonus_net_amount_wo_discount ) AS total_bonus_sales,
                                            SUM( discount ) AS discount,
                                            SUM( total_tax_amount) AS total_tax_amount,
                                            SUM( addition_amount) AS total_add_amount,
                                            SUM( deduction_amount) AS total_ded_amount,
                                            ROUND(total_cost, 6) AS total_cost,
                                            emirate_id
                                        FROM(
                                                SELECT 
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_class_id,
                                                    I.id AS invoice_id,
                                                    II.id AS item_id,
                                                    SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                    SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                    SUM( II.addition_amount ) AS addition_amount,
                                                    SUM( II.deduction_amount ) AS deduction_amount,
                                                    SUM( II.bonus_qty * II.rate ) AS bonus_net_amount_wo_discount,
                                                    SUM(II.deduction_amount) AS discount,
                                                    SUM( ( ( II.quantity + II.bonus_qty ) * II.cost_rate ) ) AS total_cost,
                                                    C.customer_emirates_name AS emirate_id
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                LEFT JOIN {{store}} S ON S.id = II.product_id
                                                WHERE I.id="' . $each['header_table_id'] . '" AND S.inventory_item_type=1 group by II.id
                                            ) AS A group by item_id ')->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    $sales_amount=abs($eachItem['total_sales']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount']);
    if($amount==$sales_amount)   
    {
    if($i==0)
    {
    $narration='Sales #' . $each['header_table_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_class_id'];
    }
    $i++;
    }
    }
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$eachItem['total_cost'];die;
    if($i==1 && $item_id>1)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
    }
    }
    }
    }
        
    public function actionCostPurchaseVoucher()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-07-31") AND H.voucher_type=8 AND I.ledger_id=7';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    $items = Yii::app()->db->createCommand('
                                                SELECT
                                                    I.id AS invoice_id,
                                                    IV.id AS item_id,
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_id,
                                                    SUM(IV.net_amount) AS net_amount_bc,
                                                    SUM(IV.tax_amount) AS tax_amount_bc
                                                FROM {{purchasinginvoice_item}} IV
                                                LEFT JOIN {{purchasinginvoice}} I ON I.id = IV.purchasing_invoice_id
                                                LEFT JOIN {{store}} S ON S.id = IV.product_id
                                                WHERE IV.purchasing_invoice_id=' . (int) $each['header_table_id'].' group by IV.id' )->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    if($amount==$eachItem['net_amount_bc'])   
    {
    if($i==0)
    {
    $narration='Purchase #' . $eachItem['invoice_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_id'];
    }
    $i++;
    }
    }
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$eachItem['total_cost'];die;
    if($i==1 && $item_id>1)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
    }
    }
    }
    }
    
    public function actionCostPurchaseReturnVoucher()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-07-31") AND H.voucher_type=9 AND I.ledger_id=7';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    
    $items = Yii::app()->db->createCommand('
                                            SELECT
                                                D.id AS invoice_id,
                                                DI.id AS item_id, 
                                                S.id AS product_id,
                                                S.part_number AS part_number,
                                                S.description AS description,
                                                S.generic_id AS generic_id,
                                                S.brand_class_id AS brand_class_id,
                                                ROUND(( SUM(DI.net_amount)), 6) AS net_amount_bc,
                                                ROUND(( SUM(DI.tax_vat_amount)), 6) AS tax_amount_bc
                                            FROM {{purchasing_debit_note_item}} DI
                                            LEFT JOIN {{purchasing_debit_note}} D ON DI.purchasing_debitnote_id = D.id
                                            LEFT JOIN {{store}} S ON DI.product_id = S.id
                                            WHERE D.id = "' . $each['header_table_id'] . '" group by DI.id')->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    if($amount==$eachItem['net_amount_bc'])   
    {
    if($i==0)
    {
    $narration='Purchase Return #' . $eachItem['invoice_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_class_id'];
    }
    $i++;
    }
    }
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$eachItem['total_cost'];die;
    if($i==1 && $item_id>1)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
    }
    }
    }
    }
    
    public function actionCostSalesReturnVoucher()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-08-03") AND H.voucher_type=10 AND I.ledger_id=7 AND product_id=0';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    
    $items = Yii::app()->db->createCommand('
                                                SELECT
                                                    brand_id,
                                                    brand,
                                                    invoice_id,
                                                    item_id,
                                                    product_id,
                                                    part_number,
                                                    description,
                                                    generic_id,
                                                    net_amount_wo_discount AS net_amount_bc,
                                                    SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                                    SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                                    bonus_net_amount_wo_discount AS total_bonus_sales,
                                                    SUM(discount) AS discount,
                                                    SUM(total_tax_amount) AS total_tax_amount,
                                                    ROUND(total_cost, 6) AS total_cost,
                                                    emirate_id
                                                FROM (
                                                    SELECT
                                                        B.id AS brand_id,
                                                        B.description AS brand,
                                                        CI.product_id AS product_id,
                                                        S.part_number AS part_number,
                                                        S.description AS description,
                                                        S.generic_id AS generic_id,
                                                        C.id AS invoice_id,
                                                        II.id AS item_id,
                                                        ROUND( ( SUM(CI.net_amount)*C.exchange_rate ), 6) AS net_amount_wo_discount,
                                                        ROUND( ( SUM( CI.tax_vat_amount  )*C.exchange_rate ), 6) AS total_tax_amount,
                                                        ROUND( ( SUM( CI.bonus_qty * CI.rate ) * C.exchange_rate ), 6) AS bonus_net_amount_wo_discount,
                                                        0 AS discount,
                                                        ROUND((SUM(CI.returned_quantity * II.cost_rate)), 6) AS total_cost,
                                                        CU.customer_emirates_name AS emirate_id
                                                    FROM {{creditnote_item}} CI
                                                    LEFT JOIN {{invoice_item}} II ON II.id = CI.invoice_item_id
                                                    LEFT JOIN {{creditnote}} C ON C.id = CI.creditnote_id
                                                    LEFT JOIN {{customer}} CU ON CU.id = C.customer_id
                                                    LEFT JOIN {{store}} S ON S.id = CI.product_id
                                                    LEFT JOIN {{product_class}} B ON B.id = S.brand_class_id
                                                    WHERE C.id = "' . $each['header_table_id'] . '"
                                                    GROUP BY II.id
                                                ) AS A GROUP BY item_id')->queryAll();
    
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    echo '
                                                SELECT
                                                    brand_id,
                                                    brand,
                                                    invoice_id,
                                                    item_id,
                                                    product_id,
                                                    part_number,
                                                    description,
                                                    generic_id,
                                                    net_amount_wo_discount AS net_amount_bc,
                                                    SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                                    SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                                    bonus_net_amount_wo_discount AS total_bonus_sales,
                                                    SUM(discount) AS discount,
                                                    SUM(total_tax_amount) AS total_tax_amount,
                                                    ROUND(total_cost, 6) AS total_cost,
                                                    emirate_id
                                                FROM (
                                                    SELECT
                                                        B.id AS brand_id,
                                                        B.description AS brand,
                                                        CI.product_id AS product_id,
                                                        S.part_number AS part_number,
                                                        S.description AS description,
                                                        S.generic_id AS generic_id,
                                                        C.id AS invoice_id,
                                                        II.id AS item_id,
                                                        ROUND( ( SUM(CI.net_amount)*C.exchange_rate ), 6) AS net_amount_wo_discount,
                                                        ROUND( ( SUM( CI.tax_vat_amount  )*C.exchange_rate ), 6) AS total_tax_amount,
                                                        ROUND( ( SUM( CI.bonus_qty * CI.rate ) * C.exchange_rate ), 6) AS bonus_net_amount_wo_discount,
                                                        0 AS discount,
                                                        ROUND((SUM(CI.returned_quantity * II.cost_rate)), 6) AS total_cost,
                                                        CU.customer_emirates_name AS emirate_id
                                                    FROM {{creditnote_item}} CI
                                                    LEFT JOIN {{invoice_item}} II ON II.id = CI.invoice_item_id
                                                    LEFT JOIN {{creditnote}} C ON C.id = CI.creditnote_id
                                                    LEFT JOIN {{customer}} CU ON CU.id = C.customer_id
                                                    LEFT JOIN {{store}} S ON S.id = CI.product_id
                                                    LEFT JOIN {{product_class}} B ON B.id = S.brand_class_id
                                                    WHERE C.id = "' . $each['header_table_id'] . '"
                                                    GROUP BY II.id
                                                ) AS A GROUP BY item_id';
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    print_r($eachItem);die;
    if($amount==round($eachItem['total_cost'],2))   
    {
    if($i==0)
    {
    $narration='Sales Return #' . $eachItem['invoice_id'] .' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_id'];
    }
    $i++;
    }
    }
    echo $i.'//'.$item_id.'///'.$amount.'///'.$eachItem['total_cost'];die;
    if($i==1 && $item_id>1)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
    }
    }
    }
    }
    
    public function actionSalespriceSalesReturnVoucher()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-08-03") AND H.voucher_type=10 AND I.ledger_id=101';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    
    $items = Yii::app()->db->createCommand('
                                                SELECT
                                                    brand_id,
                                                    brand,
                                                    invoice_id,
                                                    item_id,
                                                    product_id,
                                                    part_number,
                                                    description,
                                                    generic_id,
                                                    net_amount_wo_discount AS net_amount_bc,
                                                    SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                                    SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                                    bonus_net_amount_wo_discount AS total_bonus_sales,
                                                    SUM(discount) AS discount,
                                                    SUM(total_tax_amount) AS total_tax_amount,
                                                    ROUND(total_cost, 2) AS total_cost,
                                                    emirate_id
                                                FROM (
                                                    SELECT
                                                        B.id AS brand_id,
                                                        B.description AS brand,
                                                        CI.product_id AS product_id,
                                                        S.part_number AS part_number,
                                                        S.description AS description,
                                                        S.generic_id AS generic_id,
                                                        C.id AS invoice_id,
                                                        II.id AS item_id,
                                                        ROUND( ( SUM(CI.net_amount)*C.exchange_rate ), 6) AS net_amount_wo_discount,
                                                        ROUND( ( SUM( CI.tax_vat_amount  )*C.exchange_rate ), 6) AS total_tax_amount,
                                                        ROUND( ( SUM( CI.bonus_qty * CI.rate ) * C.exchange_rate ), 6) AS bonus_net_amount_wo_discount,
                                                        0 AS discount,
                                                        ROUND( ( SUM( ( ( CI.returned_quantity + CI.returned_bonus_qty ) * II.cost_rate ) ) ), 6) AS total_cost,
                                                        CU.customer_emirates_name AS emirate_id
                                                    FROM {{creditnote_item}} CI
                                                    LEFT JOIN {{invoice_item}} II ON II.id = CI.invoice_item_id
                                                    LEFT JOIN {{creditnote}} C ON C.id = CI.creditnote_id
                                                    LEFT JOIN {{customer}} CU ON CU.id = C.customer_id
                                                    LEFT JOIN {{store}} S ON S.id = CI.product_id
                                                    LEFT JOIN {{product_class}} B ON B.id = S.brand_class_id
                                                    WHERE C.id = "' . $each['header_table_id'] . '"
                                                    GROUP BY II.id
                                                ) AS A GROUP BY item_id')->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    $sales_amount=abs(round($eachItem['total_sales'],2));
    if($amount==$sales_amount)   
    {
    if($i==0)
    {
    $narration='Sales Return #' . $eachItem['invoice_id'] .' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_id'];
    }
    $i++;
    }
    }
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$eachItem['total_cost'];die;
    if($i==1 && $item_id>1)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
    }
    }
    }
    }
    
    public function actionCostupdateSalesInvoice()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-08-29") AND H.voucher_type=7 AND I.ledger_id=7 AND product_id=325';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    $items = Yii::app()->db->createCommand('SELECT
                                            product_id,
                                            part_number,
                                            description,
                                            generic_id,
                                            brand_class_id,
                                            invoice_id,
                                            item_id,
                                            net_amount_wo_discount AS net_amount_bc,
                                            SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                            SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                            SUM( bonus_net_amount_wo_discount ) AS total_bonus_sales,
                                            SUM( discount ) AS discount,
                                            SUM( total_tax_amount) AS total_tax_amount,
                                            SUM( addition_amount) AS total_add_amount,
                                            SUM( deduction_amount) AS total_ded_amount,
                                            ROUND(total_cost, 2) AS total_cost,
                                            emirate_id
                                        FROM(
                                                SELECT 
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_class_id,
                                                    I.id AS invoice_id,
                                                    II.id AS item_id,
                                                    SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                    SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                    SUM( II.addition_amount ) AS addition_amount,
                                                    SUM( II.deduction_amount ) AS deduction_amount,
                                                    SUM( II.bonus_qty * II.rate ) AS bonus_net_amount_wo_discount,
                                                    SUM(II.deduction_amount) AS discount,
                                                    SUM( ( ( II.quantity + II.bonus_qty ) * II.cost_rate ) ) AS total_cost,
                                                    C.customer_emirates_name AS emirate_id
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                LEFT JOIN {{store}} S ON S.id = II.product_id
                                                WHERE I.id="' . $each['header_table_id'] . '" AND S.inventory_item_type=1 AND S.id=325 group by II.id
                                            ) AS A group by item_id ')->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    if($eachItem['product_id']=325)   
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->amount = -1 * $eachItem['total_cost'];
    $fin_item->save(false);
    }
    }
    }
    }
    }
        
    public function actionCostSalesVoucher1()
    {
    $sql='SELECT I.id,H.header_table_id,abs(I.amount) AS amount FROM erp_finance_voucher_head H INNER JOIN erp_finance_voucher_items I ON H.id=I.header_id WHERE (H.voucher_date>="2020-01-01" AND H.voucher_date<="2021-08-10") AND H.voucher_type=7 AND I.ledger_id=25 AND product_id=0';    
    $data=Yii::app()->db->createCommand($sql)->queryAll();
    foreach($data as $each)
    {
    $amount=$each['amount'];
    $items = Yii::app()->db->createCommand('SELECT
                                            product_id,
                                            part_number,
                                            description,
                                            generic_id,
                                            brand_class_id,
                                            invoice_id,
                                            item_id,
                                            net_amount_wo_discount AS net_amount_bc,
                                            SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                            SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                            SUM( bonus_net_amount_wo_discount ) AS total_bonus_sales,
                                            SUM( discount ) AS discount,
                                            SUM( total_tax_amount) AS total_tax_amount,
                                            SUM( addition_amount) AS total_add_amount,
                                            SUM( deduction_amount) AS total_ded_amount,
                                            ROUND(total_cost, 2) AS total_cost,
                                            emirate_id
                                        FROM(
                                                SELECT 
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_class_id,
                                                    I.id AS invoice_id,
                                                    II.id AS item_id,
                                                    SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                    SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                    SUM( II.addition_amount ) AS addition_amount,
                                                    SUM( II.deduction_amount ) AS deduction_amount,
                                                    SUM( II.bonus_qty * II.rate ) AS bonus_net_amount_wo_discount,
                                                    SUM(II.deduction_amount) AS discount,
                                                    SUM( ( ( II.quantity + II.bonus_qty ) * II.cost_rate ) ) AS total_cost,
                                                    C.customer_emirates_name AS emirate_id
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                LEFT JOIN {{store}} S ON S.id = II.product_id
                                                WHERE I.id="' . $each['header_table_id'] . '" AND S.inventory_item_type=1 group by II.id
                                            ) AS A group by item_id ')->queryAll();
    $i=0;
    $narration='';
    $product_id=0;
    $generic_id=0;
    $item_id=0;
    $brand=0;
    if(!empty($items))
    {
    foreach($items as $eachItem)
    {
    if($amount==$eachItem['total_cost'])   
    {
    if($i==0)
    {
    $narration='Sales #' . $each['header_table_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
    $product_id=$eachItem['product_id'];
    $generic_id=$eachItem['generic_id'];
    $item_id=$eachItem['item_id'];
    $brand=$eachItem['brand_class_id'];
    }
    $i++;
//    echo $each['id'].'//'.$item_id;die;
    }
    }
//    echo $i.'//'.$item_id.'///'.$amount.'///'.$eachItem['total_cost'];die;
    if($i==1 && $item_id>0)
    {
    $fin_item=FinanceVoucherItems::model()->findByPk($each['id']);  
    $fin_item->product_id = $product_id;
    $fin_item->generic_id = $generic_id;
    $fin_item->detail_table_id = $item_id;
    $fin_item->brand_id = $brand;
    $fin_item->narration = $narration;
    $fin_item->save(false);
    }
    }
    }
    }
    
    public function actionSavemodulevouchers1()
    {
        $response = array();
//        $ids= array(49589);
//        $ids= array(49589,49343,49178,47538,47540,47456,47464,47067,46978,42596,42562,42441,42445,42415,42419,42391,42361,42380,42387,42311,42264,42267,42244,42216,
//            42223,42176,42177,42142,42106,42107,42093,42057,42059,42060,42061,42063,42037,41979,41947,41950,41951,41961,41920,41869,41870,41853,41860,41787,41712,41717,
//            41681,41686,41691,41707,41670,41642,41645,41538,41522,41370,41160,40934,40629,40581,40546,40420,40338,40293,40280,40238,40239,40246,40221,40208,40179,40134,
//            40124,40133,40079,40034);
        function validatePost($arr_post)
        {
            $returnValue = false;
            if (count(explode('/', $arr_post['from_date'])) == 3 && count(explode('/', $arr_post['to_date'])) == 3 && $arr_post['voucher_selection'] > 0 && $arr_post['status'] != '') {
                $returnValue = true;
            }

            return $returnValue;
        }

        function isPostable($date)
        {
            $last_closed_year = FinanceAuditClose::lastClosed();
            $voucherDate_array = explode('-', $date);
            $voucherYear = $voucherDate_array[0];
            return ($voucherYear <= $last_closed_year) ? false : true;
        }

        function getSublegder($parnet_id, $subledger_type)
        {
            if($parnet_id>0 && $subledger_type==1)
            {
            $model=Customer::model()->findByPk($parnet_id);
            $model->saveSublegder();   
            }
            else if($parnet_id>0 && $subledger_type==2)
            {
            $model=Vendor::model()->findByPk($parnet_id);
            $model->saveSublegder();   
            }    
            
            return FinanceSubledger::model()->find(array('condition' => 'parent_id=' . (int) $parnet_id . ' AND subledger_type_id=' . (int) $subledger_type))->id;
        }

//                $from_date = $_POST['from_date'];
//                $to_date = $_POST['to_date'];
//                $voucher = (int) $_POST['voucher_selection'];
//                $status = $_POST['status'];
                $voucher = 7;
                $status='EXISTING';
                $voucherModel = FinanceVoucherType::model()->findBypk($voucher);
                $updatFlag = $voucherModel->status_field;
                //Emirate
                $vatField = $voucherModel->vat_value;

                foreach ($ids as $i => $each) {
                    $itemsArray = $voucherHead = array();
                    if ((int) $each > 0) {
                        if ($status == 'NEW') {

                            $voucherHead['voucher_type'] = $voucher;
                            $voucherHead['header_table_id'] = $mainTable->id;
                            $voucherHead['is_posted'] = 'Y';
                            $voucherHead['created_by'] = Yii::app()->user->id;
                            $voucherHead['created_datetime'] = date('Y-m-d h:i:s');

                            if ($voucherModel->code == 'SI') {
                                $mainTable = Invoice::model()->findBypk($each);
                                if($mainTable->posted=='N')
                                {
                                $employee_id=User::model()->findByPk($mainTable->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id; 
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->lead_owner_id;    
                                }
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->invoice_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->customer_id, 1);
                                $voucherHead['emp_subledger'] = getSublegder($leadowner_id, 3);
                                $voucherHead['reference_no'] = $mainTable->reference;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $voucherHead['due_date'] = date('Y-m-d', strtotime($mainTable->invoice_date . ' + ' . (int) $mainTable->paymentTerm->no_of_days . ' days'));
                                $valid = isPostable($mainTable->invoice_date) && $mainTable->$updatFlag == 'N';
                                }
                            } else if ($voucherModel->code == 'PI') {
                                $mainTable = PurchasingInvoice::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->invoice_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->vendor_id, 2);
                                $voucherHead['reference_no'] = $mainTable->invoice_no;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $voucherHead['due_date'] = date('Y-m-d', strtotime($mainTable->invoice_date . ' + ' . (int) $mainTable->paymentTerm->no_of_days . ' days'));
                                $valid = isPostable($mainTable->invoice_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'DN') {
                                $mainTable = Purchasingdebitnote::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->debited_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->vendor_id, 2);
                                $voucherHead['reference_no'] = 'Purchase Return for Invoice #' . $mainTable->purchasing_invoice_id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->debited_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'CN') {
                                $mainTable = Creditnote::model()->findBypk($each);
                                $employee_id=User::model()->findByPk($mainTable->invoice->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id;    
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;    
                                }
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->credited_date;
                                $voucherHead['related_subledger'] = getSublegder($mainTable->customer_id, 1);
                                $voucherHead['emp_subledger'] = getSublegder($leadowner_id, 3);
                                $voucherHead['reference_no'] = 'Sales Return for Invoice #' . $mainTable->invoice->id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->credited_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'GI') {
                                $mainTable = InventoryGoodsIssue::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->goods_issue_date;
                                $voucherHead['reference_no'] = 'Goods Issue #' . $mainTable->id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->goods_issue_date) && $mainTable->$updatFlag == 'N';
                            } else if ($voucherModel->code == 'GR') {
                                $mainTable = InventoryGoodsReceipt::model()->findBypk($each);
                                $voucherHead['voucher_no'] = $mainTable->id;
                                $voucherHead['voucher_date'] = $mainTable->goods_receipt_date;
                                $voucherHead['reference_no'] = 'Goods Receipt #' . $mainTable->id;
                                $voucherHead['header_table_id'] = $mainTable->id;
                                $valid = isPostable($mainTable->goods_receipt_date) && $mainTable->$updatFlag == 'N';
                            }

                            $lastSavedid = $valid ? $this->addVoucherhead($voucherHead) : 0;

                            if ($lastSavedid > 0) {
                                if ($voucherModel->code == 'PI') {
                                    $totalPurchase = $totalLanding = 0;
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND((SUM(IV.net_amount)*I.exchange_rate), 6) AS net_amount FROM {{purchasinginvoice_item}} IV LEFT JOIN {{purchasinginvoice}} I ON I.id = IV.purchasing_invoice_id WHERE IV.purchasing_invoice_id=' . (int) $each)->queryScalar();
                                    $items = Yii::app()->db->createCommand('
                                                SELECT
                                                    I.id AS invoice_id,
                                                    IV.id AS item_id,
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_id,
                                                    SUM(IV.net_amount) AS net_amount_bc,
                                                    SUM(IV.tax_amount) AS tax_amount_bc
                                                FROM {{purchasinginvoice_item}} IV
                                                LEFT JOIN {{purchasinginvoice}} I ON I.id = IV.purchasing_invoice_id
                                                LEFT JOIN {{store}} S ON S.id = IV.product_id
                                                WHERE IV.purchasing_invoice_id=' . (int) $each.' group by IV.id' )->queryAll();
                                    $tax_tot_items=0;
                                    foreach ($items as $eachItem) {
                                        $itemsArray = array();
                                        //Inventory Dr
                                        $narration='Purchase #' . $eachItem['invoice_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                        if ($eachItem['net_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                                'brand_id' => $eachItem['brand_id'],
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $eachItem['generic_id'],
                                                'detail_table_id' => $eachItem['item_id'],
                                                'subledger_id' => 0,
                                                'narration' => $narration,
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => (float) $eachItem['net_amount_bc'],
                                            ));
                                            $totalPurchase += $eachItem['net_amount_bc'];
                                        }
                                       $tax_tot_items += $eachItem['tax_amount_bc'];
                                       $totalPurchase += $eachItem['tax_amount_bc'];
                                        //Sundry Creditor Cr
                                        $totalValue = $eachItem['net_amount_bc'] + $eachItem['tax_amount_bc'];
                                        

                                        //Footer Deduction Cr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasinginvoice->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => -1 * ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_deduction > 0) {
                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                                    'narration' => 'Purchase Deduction',
                                                    'currency' => $mainTable->currency,
                                                    'exchange_rate' => $mainTable->exchange_rate,
                                                    'amount' => (float) $net_footer_deduction,
                                                ));
                                            }
                                        }

                                        //Landing cost Update
                                        if (!empty($mainTable->landingItems)) {
                                            foreach ($mainTable->landingItems as $eachCost) {

                                                $ratio = $netAmount > 0 ? (round(($eachCost->particular_value), 2) / $netAmount) : 0;
                                                $ratio = round($ratio, 6);

                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => MasLandedCostItems::getAccount($eachCost->particular),
                                                    'subledger_id' => MasLandedCostItems::getSubledger($eachCost->particular),
                                                    'narration' => 'Purchase Cost/ Landing',
                                                    'currency' => $eachCost->currency_id,
                                                    'exchange_rate' => $eachCost->exchange_rate,
                                                    'amount' => (float) $ratio * $eachItem['net_amount_bc'],
                                                ));

                                                $totalPurchase += ($ratio * $eachItem['net_amount_bc']);

                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                                    'subledger_id' => getSublegder($eachCost->vendor_id, 2), //2-Creditors 1- debtors
                                                    'narration' => 'Purchase Cost/ Landing',
                                                    'currency' => $eachCost->currency_id,
                                                    'exchange_rate' => $eachCost->exchange_rate,
                                                    'amount' => -1 * $ratio * $eachItem['net_amount_bc'],
                                                ));
                                            }
                                        }
                                        
                                        //VAT on Purchase Dr
                                        if ($eachItem['tax_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('purchase_vat'),
                                                'subledger_id' => 0,
                                                'narration' => 'Purchase #' . $eachItem['invoice_id'],
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => (float) $eachItem['tax_amount_bc'],
                                            ));
                                        }
                                    }
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                            'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                            'narration' => 'Purchase #' . $eachItem['invoice_id'],
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'amount' => (float)  - 1 * $totalPurchase,
                                        ));
                                        //Footer Addition Dr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceSystemAccountsMapping::getSystemdefault('other_expenses');
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasinginvoice->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings,
                                                        'subledger_id' => 0,
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
//                                                        'amount' => (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                        'amount' => (float) $eachFooter->calculated_value,
                                                    ));
                                                    $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                                    'narration' => 'Purchase Cost',
                                                    'currency' => $mainTable->currency,
                                                    'exchange_rate' => $mainTable->exchange_rate,
                                                    'amount' => (float)  - 1 * $eachFooter->calculated_value,
                                                ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
//                                            if ($net_footer_addition > 0) {
//                                                $this->addVoucheritems($lastSavedid, array(
//                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
//                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
//                                                    'narration' => 'Purchase Cost',
//                                                    'currency' => $mainTable->currency,
//                                                    'exchange_rate' => $mainTable->exchange_rate,
//                                                    'amount' => (float)  - 1 * $net_footer_addition,
//                                                ));
//                                            }
                                            $totalPurchase += $net_footer_addition;
                                        }
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => ($mainTable->grand_total), 'cheque_cleared' => 'Y')); //$netTotal
                                    PurchasingInvoice::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                } else if ($voucherModel->code == 'SI') {
                                    
                                    //For Item sales
                                    $totalSales = 0;
                                    $invoice=Invoice::model()->findByPk((int)$each);
                                    if($invoice->posted=='N')
                                    {
                                    if($invoice->invoice_nature=='S' || $invoice->invoice_nature=='SR')
                                    {
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND( ( SUM( ( IV.quantity * IV.rate ) )*I.exchange_rate), 6) AS net_amount FROM {{invoice_item}} IV LEFT JOIN {{store}} S ON S.id = IV.product_id LEFT JOIN {{invoice}} I ON I.id = IV.invoice_id WHERE S.inventory_item_type=1 AND IV.invoice_id=' . (int) $each)->queryScalar();

                                    $items = Yii::app()->db->createCommand('
                                        SELECT
                                            product_id,
                                            part_number,
                                            description,
                                            generic_id,
                                            brand_class_id,
                                            invoice_id,
                                            item_id,
                                            net_amount_wo_discount AS net_amount_bc,
                                            SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                            SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                            SUM( bonus_net_amount_wo_discount ) AS total_bonus_sales,
                                            SUM( discount ) AS discount,
                                            SUM( total_tax_amount) AS total_tax_amount,
                                            SUM( addition_amount) AS total_add_amount,
                                            SUM( deduction_amount) AS total_ded_amount,
                                            ROUND(total_cost, 6) AS total_cost,
                                            emirate_id
                                        FROM(
                                                SELECT 
                                                    S.id AS product_id,
                                                    S.part_number AS part_number,
                                                    S.description AS description,
                                                    S.generic_id AS generic_id,
                                                    S.brand_class_id AS brand_class_id,
                                                    I.id AS invoice_id,
                                                    II.id AS item_id,
                                                    SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                    SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                    SUM( II.addition_amount ) AS addition_amount,
                                                    SUM( II.deduction_amount ) AS deduction_amount,
                                                    SUM( II.bonus_qty * II.rate ) AS bonus_net_amount_wo_discount,
                                                    SUM(II.deduction_amount) AS discount,
                                                    SUM( ( ( II.quantity + II.bonus_qty ) * II.cost_rate ) ) AS total_cost,
                                                    C.customer_emirates_name AS emirate_id
                                                FROM {{invoice_item}} II
                                                LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                                LEFT JOIN {{customer}} C ON C.id = I.customer_id
                                                LEFT JOIN {{store}} S ON S.id = II.product_id
                                                WHERE I.id="' . $each . '" AND S.inventory_item_type=1 group by II.id
                                            ) AS A group by item_id ')->queryAll();
                                        
                                    $total_bonus_sales=0;
                                    $total_discount=0;
                                    $total_debtor_amount=0;
                                    $total_cost=0;
                                    $total_sales=0;
                                    $total_tax_amount=0;
                                    foreach ($items as $eachItem) {
                                    $total_bonus_sales+=(float) $eachItem['total_bonus_sales'];
                                    $total_discount+=(float) $eachItem['discount'];
                                    $total_debtor_amount+= (float) $eachItem['debtor_amount']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount'];
                                    $total_cost+=$eachItem['total_cost'];
                                    $total_sales+=$eachItem['total_sales']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount']; //-ve value
                                    $sales_amount=$eachItem['total_sales']+(float) $eachItem['total_add_amount']-(float) $eachItem['total_ded_amount']; //-ve value
                                    $total_tax_amount+=$eachItem['total_tax_amount']; //-ve value
                                    
                                $employee_id=User::model()->findByPk($mainTable->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id; 
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->lead_owner_id;    
                                }
                                $narration='Sales #' . $mainTable->id.' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                if ($eachItem['total_cost'] != 0) {
                                        //Cost of Sale Dr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale'),
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'subledger_id' => 0,
                                            'narration' => $narration,
                                            'currency' => 1,
                                            'exchange_rate' => 1,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => (float)$eachItem['total_cost'],
                                            'employee_id' => getSublegder($leadowner_id, 3),
                                        ));
                                    }
                                    if ($sales_amount != 0) {
                                        //Sales Accounts Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales'),
                                            'subledger_id' => getSublegder($leadowner_id, 3),
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'narration' => $narration,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $sales_amount, 
                                            'employee_id' => getSublegder($leadowner_id, 3),
                                        ));
                                    }
                                    if ($eachItem['total_cost'] != 0) {
                                        //Inventory Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'subledger_id' => 0,
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'narration' => $narration,
                                            'currency' => 1,
                                            'exchange_rate' => 1,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $eachItem['total_cost'],
                                        ));
                                    }
                                        //Footer Items
                                        //Footer Addition Cr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => -1 * (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                    ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount+=$net_footer_addition;
                                        }

                                        //Footer Deduction Dr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount-=$net_footer_deduction;
                                        }
                                    }

                                    //Service Sales
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND( ( SUM( ( IV.quantity * IV.rate ) )*I.exchange_rate), 6) AS net_amount FROM {{invoice_item}} IV LEFT JOIN {{store}} S ON S.id = IV.product_id LEFT JOIN {{invoice}} I ON I.id = IV.invoice_id WHERE S.inventory_item_type=2 AND IV.invoice_id=' . (int) $each)->queryScalar();
                                    $items = Yii::app()->db->createCommand('
                                    SELECT
                                        product_id,
                                        part_number,
                                        description,
                                        generic_id,
                                        brand_class_id,
                                        invoice_id,
                                        ledger_id,
                                        item_id,
                                        net_amount_wo_discount AS net_amount_bc,
                                        SUM( net_amount_wo_discount + total_tax_amount ) AS debtor_amount,
                                        SUM( net_amount_wo_discount ) AS total_sales,
                                        SUM( discount ) AS discount,
                                        SUM( total_tax_amount ) AS total_tax_amount
                                    FROM(
                                            SELECT 
                                                S.id AS product_id,
                                                S.part_number AS part_number,
                                                S.description AS description,
                                                S.generic_id AS generic_id,
                                                S.brand_class_id AS brand_class_id,
                                                I.id AS invoice_id,
                                                L.id AS ledger_id,
                                                II.id AS item_id,
                                                SUM( II.quantity * II.rate ) AS net_amount_wo_discount,
                                                SUM( II.tax_vat_amount ) AS total_tax_amount,
                                                SUM( II.deduction_amount ) AS discount
                                            FROM {{invoice_item}} II 
                                            LEFT JOIN {{invoice}} I ON I.id = II.invoice_id
                                            LEFT JOIN {{store}} S ON S.id = II.product_id
                                            LEFT JOIN {{finance_legder}} L ON S.id = L.parent_id
                                            WHERE I.id="' . $each . '" AND S.inventory_item_type=2
                                            GROUP BY II.product_id
                                        ) AS A  GROUP BY ledger_id')->queryAll();

                                    foreach ($items as $eachItem) {
                                        $total_bonus_sales+=(float) $eachItem['total_bonus_sales'];
                                    $total_discount+=(float) $eachItem['discount'];
                                    $total_debtor_amount+= (float) $eachItem['debtor_amount'] - (float) $eachItem['discount'];
                                    $total_cost+=$eachItem['total_cost'];
                                    $total_sales+=$eachItem['total_sales']; //-ve value
                                    $total_tax_amount+=$eachItem['total_tax_amount']; //-ve value
                                    
                                     $narration='Sales #' . $mainTable->id.' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                     
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('sales');
                                    switch($eachItem['product_id'])
                                    {
                                    case 1239:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon');    
                                    break;
                                    case 1240:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('referral_fee_amazon');    
                                    break;
                                    case 1263:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('order_cancellation_charge_amazon');    
                                    break;
                                    case 1266:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon');  
                                    $subledger=0;  
                                    break;
                                    }
                                    if ($eachItem['total_sales'] != 0) {
                                        //Sales Accounts Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => $sale,
                                            'product_id' => $eachItem['product_id'],
                                            'generic_id' => $eachItem['generic_id'],
                                            'detail_table_id' => $eachItem['item_id'],
                                            'brand_id' => $eachItem['brand_class_id'],
                                            'subledger_id' => getSublegder($leadowner_id, 3),
                                            'narration' => $narration,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $eachItem['total_sales'],
                                            'employee_id' => getSublegder($leadowner_id, 3),
                                        ));
                                    }

                                        //Footer Items
                                        //Footer Addition Cr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => -1 * (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                    ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount+=$net_footer_addition;
                                        }

                                        //Footer Deduction Dr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $eachItem['order_id'],
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $total_debtor_amount-=$net_footer_deduction;
                                        }
                                    }
                                }
                                else if($invoice->invoice_nature=='H')
                                {
                                    $total_bonus_sales=0;
                                    $total_discount=0;
                                    $total_debtor_amount=0;
                                    $total_cost=0;
                                    $total_sales=0;
                                    $total_tax_amount=0;
                                    $total_debtor_amount+= (float)$invoice->grand_total;
                                    $total_sales+=(float)$invoice->grand_total-(float)$invoice->total_tax_amount; //-ve value
                                    $total_tax_amount+=(float)$invoice->total_tax_amount; //-ve value
                                }
                                // ADVANCE PAYMENT INVOICE
                                else if($invoice->invoice_nature=='A')
                                {
                                    $total_bonus_sales=0;
                                    $total_discount=0;
                                    $total_debtor_amount=0;
                                    $total_cost=0;
                                    $total_sales=0;
                                    $total_tax_amount=0;
                                    $total_debtor_amount+= (float)$invoice->grand_total;
                                    $total_sales+=(float)$invoice->grand_total-(float)$invoice->total_tax_amount; //-ve value
                                    $total_tax_amount+=(float)$invoice->total_tax_amount; //-ve value
                                }
                                

                                    //POSTING
                                    
                                    if ($total_bonus_sales > 0) {
                                        //Sales Bonus Dr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_bonus'),
                                            'brand_id' => 0,
                                            'subledger_id' => getSublegder($mainTable->lead_owner_id, 3),
                                            'narration' => 'Sales #' . $mainTable->id,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => (float) $total_bonus_sales,
                                        ));
}

//                                    if ($total_discount > 0) {
//                                        //Discount Given Dr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_discount'),
//                                            'brand_id' => 0,
//                                            'subledger_id' => getSublegder($mainTable->lead_owner_id, 3),
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => $mainTable->currency,
//                                            'exchange_rate' => $mainTable->exchange_rate,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => (float) $total_discount,
//                                        ));
//}

                                    if($total_debtor_amount > 0) {
                                        //Debtor Dr
                                        $finalvalue = (float) $eachItem['debtor_amount'] - (float) $eachItem['discount'];
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                            'brand_id' => 0,
                                            'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                            'narration' => 'Sales #' . $mainTable->id,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => (float)$total_debtor_amount,
                                        ));
}

//                                    if ($total_cost > 0) {
//                                        //Cost of Sale Dr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale'),
//                                            'brand_id' => $mainTable->order_id,
//                                            'subledger_id' => 0,
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => 1,
//                                            'exchange_rate' => 1,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => (float)$total_cost,
//                                        ));
//                                    }
//                                    if ($total_sales > 0) {
//                                        //Sales Accounts Cr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales'),
//                                            'brand_id' => $mainTable->order_id,
//                                            'subledger_id' => getSublegder($mainTable->lead_owner_id, 3),
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => $mainTable->currency,
//                                            'exchange_rate' => $mainTable->exchange_rate,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => -1 * $total_sales,
//                                        ));
//                                    }
                                    if ($total_tax_amount > 0) {
                                        //VAT Cr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_vat'),
                                            'brand_id' => 0,
                                            'subledger_id' => 0,
                                            'narration' => 'Sales #' . $mainTable->id,
                                            'currency' => $mainTable->currency,
                                            'exchange_rate' => $mainTable->exchange_rate,
                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
                                            'amount' => -1 * $total_tax_amount,
                                        ));
                                    }
//                                    if ($total_cost > 0) {
//                                        //Inventory Cr
//                                        $this->addVoucheritems($lastSavedid, array(
//                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
//                                            'brand_id' => 0,
//                                            'subledger_id' => 0,
//                                            'narration' => 'Sales #' . $mainTable->id,
//                                            'currency' => 1,
//                                            'exchange_rate' => 1,
//                                            'emirate_id' => (int) $mainTable->customer->customer_emirates_name,
//                                            'amount' => -1 * $total_cost,
//                                        ));
//                                    }

                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => ($mainTable->grand_total), 'cheque_cleared' => 'Y')); //$netTotal
                                    Invoice::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                }
                                } else if ($voucherModel->code == 'DN') {
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND((SUM(IV.net_amount)*I.exchange_rate), 6) AS net_amount FROM {{purchasing_debit_note_item}} IV LEFT JOIN {{purchasing_debit_note}} I ON I.id = IV.purchasing_debitnote_id WHERE IV.purchasing_debitnote_id=' . (int) $each)->queryScalar();
                                    $items = Yii::app()->db->createCommand('
                                            SELECT
                                                D.id AS invoice_id,
                                                DI.id AS item_id,
                                                S.id AS product_id,
                                                S.part_number AS part_number,
                                                S.description AS description,
                                                S.generic_id AS generic_id,
                                                S.brand_class_id AS brand_class_id,
                                                ROUND(( SUM(DI.net_amount)), 6) AS net_amount_bc,
                                                ROUND(( SUM(DI.tax_vat_amount)), 6) AS tax_amount_bc
                                            FROM {{purchasing_debit_note_item}} DI
                                            LEFT JOIN {{purchasing_debit_note}} D ON DI.purchasing_debitnote_id = D.id
                                            LEFT JOIN {{store}} S ON DI.product_id = S.id
                                            WHERE D.id = "' . $each . '" group by DI.id')->queryAll();

                                    $totalDebit = 0;
                                    $totalAmount=0;
                                    $totalVat=0;
                                    foreach ($items as $eachItem) {
                                        $itemsArray = array();
                                        $narration='Purchase Return #' . $eachItem['invoice_id'].' Product : '.$eachItem['part_number'].' / '.$eachItem['description'];
                                        //Inventory Cr
                                        if ($eachItem['net_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                                'subledger_id' => 0,
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $eachItem['generic_id'],
                                                'detail_table_id' => $eachItem['item_id'],
                                                 'brand_id' => $eachItem['brand_class_id'],
                                                'narration' => $narration,
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => -1 * (float) $eachItem['net_amount_bc'],
                                            ));
                                            $totalDebit += $eachItem['net_amount_bc'];
                                            $totalAmount += $eachItem['net_amount_bc'];
                                        }
                                       $totalDebit += $eachItem['tax_amount_bc'];
                                       $totalVat += $eachItem['tax_amount_bc'];
                                       $totalValue = $eachItem['net_amount_bc'] + $eachItem['tax_amount_bc'];
                                       
                                                                               
                                     //VAT on Purchase Cr
                                        if ($eachItem['tax_amount_bc'] > 0) {
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('purchase_vat'),
                                                'subledger_id' => 0,
                                                'narration' => 'Purchase Return#' . $eachItem['invoice_id'] ,
                                                'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                                'amount' => -1 * (float) $eachItem['tax_amount_bc'],
                                            ));
                                        }
                                        
                                        //Footer Addition Cr
//                                        $net_footer_addition = 0;
//                                        if (!empty($mainTable->adItems)) {
//                                            foreach ($mainTable->adItems as $eachFooter) {
//                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
//                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
//                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasedebitnote->exchange_rate) / $netAmount) : 0;
//                                                    $ratio = round($ratio, 6);
//                                                    $this->addVoucheritems($lastSavedid, array(
//                                                        'ledger_id' => (int) $mappings['account'],
//                                                        'subledger_id' => (int) $mappings['subledger'],
//                                                        'narration' => $mappings['name'],
//                                                        'currency' => $mainTable->currency,
//                                                'exchange_rate' => $mainTable->exchange_rate,
//                                                        'amount' => -1 * (float) $eachItem['net_amount_bc'] * (float) $ratio,
//                                                    ));
//                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
//                                                }
//                                            }
//                                            $totalDebit += $net_footer_addition;
//                                        }

                                        //Footer Deduction Dr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasedebitnote->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
//                                                    $this->addVoucheritems($lastSavedid, array(
//                                                        'ledger_id' => (int) $mappings['account'],
//                                                        'subledger_id' => (int) $mappings['subledger'],
//                                                        'narration' => $mappings['name'],
//                                                        'currency' => $mainTable->currency,
//                                                        'exchange_rate' => $mainTable->exchange_rate,
//                                                        'amount' => ((float) $eachItem['net_amount_bc'] * (float) $ratio),
//                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_deduction > 0) {
//                                                $this->addVoucheritems($lastSavedid, array(
//                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
//                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
//                                                    'narration' => 'Purchase Return || Brand ' . $eachItem['description'],
//                                                    'currency' => $mainTable->currency,
//                                                'exchange_rate' => $mainTable->exchange_rate,
//                                                    'amount' => -1 * (float) $net_footer_deduction,
//                                                ));
                                            }
                                        }
                                    }
                                    
                                                                            //Footer Addition Dr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceSystemAccountsMapping::getSystemdefault('other_expenses');
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->purchasedebitnote->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings,
                                                        'subledger_id' => 0,
                                                        'narration' => $mappings['name'],
                                                        'currency' => $mainTable->currency,
                                                        'exchange_rate' => $mainTable->exchange_rate,
                                                        'amount' => (float)  - 1 * $eachFooter->calculated_value,
                                                    ));
                                                    $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                                    'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                                    'narration' => 'Purchase Cost',
                                                    'currency' => $mainTable->currency,
                                                    'exchange_rate' => $mainTable->exchange_rate,
                                                    'amount' => (float) $eachFooter->calculated_value,
                                                ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            $totalDebit += $net_footer_addition;
                                        }

                                        
                                        //Sundry Creditor Dr
                                        $this->addVoucheritems($lastSavedid, array(
                                            'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('creditors'),
                                            'subledger_id' => getSublegder($mainTable->vendor_id, 2), //2-Creditors 1- debtors
                                            'narration' => 'Purchase Return #' . $eachItem['invoice_id'] ,
                                            'currency' => $mainTable->currency,
                                                'exchange_rate' => $mainTable->exchange_rate,
                                            'amount' => (float) $totalDebit,
                                        ));
                                        
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => ($mainTable->debited_amount), 'cheque_cleared' => 'Y')); //$netTotal
                                    Purchasingdebitnote::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));

                                } else if ($voucherModel->code == 'CN') {
                                    $items = Yii::app()->db->createCommand('
                                                SELECT
                                                    brand_id,
                                                    brand,
                                                    invoice_id,
                                                    item_id,
                                                    product_id,
                                                    part_number,
                                                    description,
                                                    generic_id,
                                                    net_amount_wo_discount AS net_amount_bc,
                                                    SUM( net_amount_wo_discount+total_tax_amount) AS debtor_amount,
                                                    SUM( net_amount_wo_discount + bonus_net_amount_wo_discount ) AS total_sales,
                                                    bonus_net_amount_wo_discount AS total_bonus_sales,
                                                    SUM(discount) AS discount,
                                                    SUM(total_tax_amount) AS total_tax_amount,
                                                    ROUND(total_cost, 6) AS total_cost,
                                                    emirate_id
                                                FROM (
                                                    SELECT
                                                        B.id AS brand_id,
                                                        B.description AS brand,
                                                        CI.product_id AS product_id,
                                                        S.part_number AS part_number,
                                                        S.description AS description,
                                                        S.generic_id AS generic_id,
                                                        C.id AS invoice_id,
                                                        II.id AS item_id,
                                                        ROUND( ( SUM(CI.net_amount)*C.exchange_rate ), 6) AS net_amount_wo_discount,
                                                        ROUND( ( SUM( CI.tax_vat_amount  )*C.exchange_rate ), 6) AS total_tax_amount,
                                                        ROUND( ( SUM( CI.bonus_qty * CI.rate ) * C.exchange_rate ), 6) AS bonus_net_amount_wo_discount,
                                                        0 AS discount,
                                                        ROUND( ( SUM( ( ( CI.returned_quantity + CI.returned_bonus_qty ) * II.cost_rate ) ) ), 6) AS total_cost,
                                                        CU.customer_emirates_name AS emirate_id
                                                    FROM {{creditnote_item}} CI
                                                    LEFT JOIN {{invoice_item}} II ON II.id = CI.invoice_item_id
                                                    LEFT JOIN {{creditnote}} C ON C.id = CI.creditnote_id
                                                    LEFT JOIN {{customer}} CU ON CU.id = C.customer_id
                                                    LEFT JOIN {{store}} S ON S.id = CI.product_id
                                                    LEFT JOIN {{product_class}} B ON B.id = S.brand_class_id
                                                    WHERE C.id = "' . $each . '"
                                                    GROUP BY II.id
                                                ) AS A GROUP BY item_id')->queryAll();

                                    $totalReturn = 0;
                                    $totalVat=0;
                                    $netAmount = Yii::app()->db->createCommand('SELECT ROUND( ( SUM( ( IV.net_amount ) )*I.exchange_rate), 6) AS net_amount FROM {{creditnote_item}} IV LEFT JOIN {{creditnote}} I ON I.id = IV.creditnote_id WHERE IV.creditnote_id=' . (int) $each)->queryScalar();
                                
                                $mainTable = Creditnote::model()->findBypk($each);
                                $employee_id=User::model()->findByPk($mainTable->invoice->lead_owner_id)->connected_employee_id;
                                if($employee_id>0)
                                {
                                $leadowner_id=User::model()->find(array('condition'=>'employee_id='.$employee_id))->id;    
                                if($employee_id==0)
                                {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;       
                                }
                                }
                                else {
                                $leadowner_id=$mainTable->invoice->lead_owner_id;    
                                }
                                
                                    foreach ($items as $eachItem) {
                                        
                                        $product=Store::model()->findByPk($eachItem['product_id']);
                                        $narration='Sales Return #' . $eachItem['invoice_id'] .' Product : '.$product->part_number.' / '.$product->description;
                                        if ($eachItem['total_sales'] > 0) {
                                            //Sales Accounts Dr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales'),
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $product->generic_id,
                                                'detail_table_id' => $eachItem['item_id'],
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => getSublegder($leadowner_id, 3),
                                                'narration' => $narration,
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => $eachItem['total_sales'],
                                                'employee_id' => getSublegder($leadowner_id, 3),
                                            ));
                                        }
                                                                    
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('sales');
                                    switch($eachItem['product_id'])
                                    {
                                    case 1239:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon');    
                                    break;
                                    case 1240:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('referral_fee_amazon');    
                                    break;
                                    case 1263:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('order_cancellation_charge_amazon');    
                                    break;
                                    case 1266:
                                    $sale=FinanceSystemAccountsMapping::getSystemdefault('transportation_fee_amazon');  
                                    break;
                                    }
                                    
                                        if ($eachItem['total_cost'] > 0) {
                                            //Inventory Dr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => $sale,
                                                'brand_id' => $product->brand_class_id,
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $product->generic_id,
                                                'detail_table_id' => $eachItem['item_id'],
                                                'subledger_id' => 0,
                                                'narration' => $narration,
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => $eachItem['total_cost'],
                                            ));
                                        }

                                        $debtorAmount = (float) $eachItem['debtor_amount']  - (float) $eachItem['discount'];

                                        $totalReturn += (float) $eachItem['debtor_amount'];
                                        
                                        $totalVat+= (float) $eachItem['total_tax_amount'];

                                        if ($eachItem['total_bonus_sales'] > 0) {
                                            //Sales Bonus Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_bonus'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => getSublegder($mainTable->invoice->lead_owner_id, 3),
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * (float) $eachItem['total_bonus_sales'],
                                            ));
                                            $totalReturn += (float) $eachItem['total_bonus_sales'];
                                        }

                                        if ($eachItem['discount'] > 0) {
                                            //Discount Given Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_discount'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => 0,
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * (float) $eachItem['discount'],
                                            ));
                                        }
                                        $totalReturn += (float) $eachItem['discount'];

                                        if ($eachItem['total_cost'] > 0) {
                                            //Cost of Sale Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('cost_of_sale'),
                                                'brand_id' => $product->brand_class_id,
                                                'product_id' => $eachItem['product_id'],
                                                'generic_id' => $product->generic_id,
                                                'detail_table_id' => $eachItem['item_id'],
                                                'subledger_id' => 0,
                                                'narration' => $narration,
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * $eachItem['total_cost'],
                                                'employee_id' => getSublegder($leadowner_id, 3),
                                            ));
//                                            $totalReturn += (float) $eachItem['total_cost'];
                                        }

                                        //Footer Items
                                        //Footer Addition Dr
                                        $net_footer_addition = 0;
                                        if (!empty($mainTable->adItems)) {
                                            foreach ($mainTable->adItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->parent->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $product->brand_class_id,
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => 1,
                                                        'exchange_rate' => 1,
                                                        'amount' => (float) $eachItem['net_amount_bc'] * (float) $ratio,
                                                    ));
                                                    $net_footer_addition += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_addition > 0) {
                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                                    'brand_id' => $product->brand_class_id,
                                                    'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                                    'narration' => 'Sales Return Addition',
                                                    'currency' => 1,
                                                    'exchange_rate' => 1,
                                                    'amount' => -1 * (float) $net_footer_addition,
                                                ));
                                            }
                                            $totalReturn += $net_footer_addition;
                                        }

                                        //Footer Deduction Cr
                                        $net_footer_deduction = 0;
                                        if (!empty($mainTable->dedItems)) {
                                            foreach ($mainTable->dedItems as $eachFooter) {
                                                if ($eachFooter->particular > 0 && $eachFooter->calculated_value > 0) {
                                                    $mappings = FinanceFooterMapping::getFooteraccount($eachFooter->particular);
                                                    $ratio = $netAmount > 0 ? (($eachFooter->calculated_value * $eachFooter->parent->exchange_rate) / $netAmount) : 0;
                                                    $ratio = round($ratio, 6);
                                                    $this->addVoucheritems($lastSavedid, array(
                                                        'ledger_id' => (int) $mappings['account'],
                                                        'brand_id' => $product->brand_class_id,
                                                        'subledger_id' => (int) $mappings['subledger'],
                                                        'narration' => $mappings['name'],
                                                        'currency' => 1,
                                                        'exchange_rate' => 1,
                                                        'amount' => -1 * ((float) $eachItem['net_amount_bc'] * (float) $ratio),
                                                    ));
                                                    $net_footer_deduction += (float) $eachItem['net_amount_bc'] * (float) $ratio;
                                                }
                                            }
                                            if ($net_footer_deduction > 0) {
                                                $this->addVoucheritems($lastSavedid, array(
                                                    'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                                    'brand_id' => $product->brand_class_id,
                                                    'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                                    'narration' => 'Sales Return Deduction',
                                                    'currency' => 1,
                                                    'exchange_rate' => 1,
                                                    'amount' => (float) $net_footer_deduction,
                                                ));
                                            }
                                        }
                                    }


                                        if ($totalVat > 0) {
                                            //VAT Dr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('sales_vat'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => 0,
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => $totalVat,
                                            ));
                                        }
                                        
                                        if ($totalReturn > 0 ) {
                                            //Debtor Cr
                                            $this->addVoucheritems($lastSavedid, array(
                                                'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('debtors'),
                                                'brand_id' => $product->brand_class_id,
                                                'subledger_id' => getSublegder($mainTable->customer_id, 1), //2-Creditors 1- debtors
                                                'narration' => 'Sales Return #' . $eachItem['invoice_id'],
                                                'emirate_id' => (int) $eachItem['emirate_id'],
                                                'currency' => 1,
                                                'exchange_rate' => 1,
                                                'amount' => -1 * $totalReturn,
                                            ));
                                        }
                                        
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => $mainTable->credited_amount, 'cheque_cleared' => 'Y')); //$netTotal
                                    Creditnote::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                } else if ($voucherModel->code == 'GI') {
                                    
                                    $items = Yii::app()->db->createCommand('SELECT 
                                                                                G.ledger_id,
                                                                                G.subledger_id,
                                                                                G.reference AS narration,
                                                                                GI.product_id AS product_id,
                                                                                GI.id AS item_id,
                                                                                ROUND(GI.rate * GI.picked_qty, 2) AS total_value
                                                                            FROM {{inventory_goods_issue_item}} GI 
                                                                            LEFT JOIN {{inventory_goods_issue}} G ON G.id = GI.inventory_goods_issue_id
                                                                            WHERE G.id='.(int) $each)->queryAll();                                  
                                    $total=0;
                                    foreach($items as $eachItem)
                                    {
                                    $product=Store::model()->findByPk($eachItem['product_id']);
                                    $narration= $eachItem['narration'] .' Product : '.$product->part_number.' / '.$product->description;
                                    //Expense header
                                    $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => $eachItem['ledger_id'],
                                        'subledger_id' => $eachItem['subledger_id'],
                                        'narration' => $narration,
                                        'amount' => (float) $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));

                                     //Inventory
                                     $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                        'narration' => $narration,
                                        'amount' => -1 *  $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));
                                    $total+=$eachItem['total_value'];
                                    }
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => $total, 'cheque_cleared' => 'Y')); //$netTotal
                                    InventoryGoodsIssue::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                } else if ($voucherModel->code == 'GR') {
                                    
                                    $items = Yii::app()->db->createCommand('SELECT 
                                                                                G.reference AS narration,
                                                                                ROUND(GR.rate * GR.picked_qty, 2) AS total_value,
                                                                                GR.product_id AS product_id,
                                                                                GR.id AS item_id
                                                                            FROM {{inventory_goods_receipt_item}} GR 
                                                                            LEFT JOIN {{inventory_goods_receipt}} G ON G.id = GR.inventory_goods_receipt_id
                                                                            WHERE G.id='.(int) $each )->queryAll();
                                    $total=0;
                                    foreach($items as $eachItem)
                                    {
                                    $product=Store::model()->findByPk($eachItem['product_id']);
                                    $narration= $eachItem['narration'] .' Product : '.$product->part_number.' / '.$product->description;
                                    //inventory header
                                    $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('inventory'),
                                        'narration' => $narration,
                                        'amount' => (float) $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));

                                     //Retained
                                     $this->addVoucheritems($lastSavedid, array(
                                        'ledger_id' => FinanceSystemAccountsMapping::getSystemdefault('retained_earnings'),
                                        'narration' => $narration,
                                        'amount' => -1 *  $eachItem['total_value'],
                                        'brand_id' => $product->brand_class_id,
                                        'product_id' => $eachItem['product_id'],
                                        'generic_id' => $product->generic_id,
                                        'detail_table_id' => $eachItem['item_id']
                                    ));
                                    $total+=$eachItem['total_value'];
                                    }
                                    FinanceVoucherHead::model()->updatebypk($lastSavedid, array('total_voucher_amount' => $total, 'cheque_cleared' => 'Y')); //$netTotal
                                    InventoryGoodsReceipt::model()->updateBypk($each, array($voucherModel->status_field => 'Y'));
                                }
                            }

                        } else {
                            if ($voucherModel->code == 'SI') {
                            $model = new Invoice;
                            } else if ($voucherModel->code == 'PI') {
                            $model = new PurchasingInvoice;
                            } else if ($voucherModel->code == 'DN') {
                            $model = new Purchasingdebitnote;
                            } else if ($voucherModel->code == 'CN') {
                            $model = new Creditnote;
                            } else if ($voucherModel->code == 'GI') {
                            $model = new InventoryGoodsIssue;
                            } else if ($voucherModel->code == 'GR') {
                            $model = new InventoryGoodsReceipt;
                            }

                            $AllexistingVocher = FinanceVoucherHead::model()->findAll(array('condition' => 'voucher_type=' . $voucher . ' AND header_table_id=' . (int) $each));
                            foreach($AllexistingVocher as $existingVocher)
                            {
                                if ($existingVocher->id > 0) {
                                if ($existingVocher->is_allocated == 'N' && isPostable($existingVocher->voucher_date)) {
                                    $model=Invoice::model()->findByPk($each);
                                    if($model->posted=='Y')
                                    {
                                    FinanceVoucherHead::model()->deletebypk((int)$existingVocher->id);
                                    FinanceVoucherItems::model()->deleteAll('header_id=:refer_id', array(':refer_id' => (int)$existingVocher->id));
                                    $model::model()->updateBypk($each, array($voucherModel->status_field => 'N'));   
                                    }
                                }
                            }
                            }
                            
                        }
                    }
                }
                $response['status'] = 'success';
                
        echo json_encode($response);
    }
}
