<?php

/**
 * This is the model class for table "{{mas_sub_module}}".
 *
 * The followings are the available columns in table '{{mas_sub_module}}':
 * @property integer $id
 * @property integer $module_id
 * @property string $sub_module
 * @property string $isActive
 * @property string $is_default
 * @property integer $created_by
 * @property string $created_date_time
 */
class MasSubModule extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{mas_sub_module}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('module_id, sub_module, is_default, created_by, created_date_time', 'required'),
			array('module_id, created_by', 'numerical', 'integerOnly'=>true),
			array('sub_module', 'length', 'max'=>255),
			array('isActive, is_default', 'length', 'max'=>1),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, module_id, sub_module, isActive, is_default, created_by, created_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		 return array(
        'module' => array(self::BELONGS_TO, 'MasModule', 'module_id'),
    );
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'module_id' => 'Module',
			'sub_module' => 'Sub Module',
			'isActive' => 'Is Active',
			'is_default' => 'Is Default',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('module_id',$this->module_id);
		$criteria->compare('sub_module',$this->sub_module,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('is_default',$this->is_default,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return MasSubModule the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
