<?php

/**
 * This is the model class for table "{{features_approve_level}}".
 *
 * The followings are the available columns in table '{{features_approve_level}}':
 * @property integer $id
 * @property integer $operations_type
 * @property integer $max_level
 * @property integer $level_1_authority
 * @property integer $level_2_authority
 * @property integer $level_3_authority
 * @property integer $level_4_authority
 * @property integer $level_5_authority
 */
class FeaturesApproveLevel extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{features_approve_level}}';
	}
    //public $line_manager;
    //public $supervisor;
    //public $functionality_name;
    public $operations_array = array('LE' => 'Leads', 'QU' => 'Quotes', 'SO' => 'Sales Orders', 'SRO' => 'Service Orders', 'PR' => 'Purchase Requisitions', 'PE' => 'Purchase Enquiries', 'PO' => 'Purchase Orders');
        /**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('operations_type, max_level', 'required'),
			array('max_level, level_1_authority, level_2_authority, level_3_authority, level_4_authority, level_5_authority', 'numerical', 'integerOnly'=>true),
			array('level_1_type, level_2_type, level_3_type, level_4_type, level_5_type', 'length', 'max'=>1),
            array('max_level', 'validatelevelapproval'),
            //array('max_level', 'validatedocumentlevel'),
            //array('max_level', 'validateDuplicateAuthority'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, operations_type, max_level, level_1_type, level_2_type, level_3_type, level_4_type, level_5_type, level_1_authority, level_2_authority, level_3_authority, level_4_authority, level_5_authority', 'safe', 'on'=>'search'),
		);
	}

    public static function getUserHierarchyLevels() {
        $condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id . ' AND t.level > 0 AND t.level!=2';
        $model = User::model()->findAll(array('condition' => $condition, 'order' => 't.hierarchy_level'));
        return CHtml::listData($model, 'hierarchy_level', 'designation');
    }

    public static function getUsersByLevel($level = '') {
        $condition = 'isActive =  "Y" AND company_id=' . Yii::app()->user->master_user_company_id . ' AND t.level > 0 AND t.level!=2';
        if ($level > 0) {
            $condition .= ' AND hierarchy_level = '.$level;
        }
        $model = User::model()->findAll(array('condition' => $condition, 'order' => 't.first_name,t.username'));
        return CHtml::listData($model, 'id', 'fullname');
    }

    public static function getCurrentApproveLevel($type, $file_id) {
        $approveLevel = 0;
        $model = new self;
        $operations_array = $model->operations_array;
        if (array_key_exists($type, $operations_array)) {
            $model_level_approval = self::model()->find(array('condition' => ' operations_type="' . $type .'"'));
            if ($model_level_approval->max_level > 0) {
                $approveLevel = $model_level_approval->max_level;
                for ($level = $model_level_approval->max_level; $level >= 1; $level--) {
                    Yii::import('application.modules.features.models.FeaturesOperations');
                    $modelFeaturesOperations = new FeaturesOperations();
                    $condition = 't.file_no = "' . $file_id . '" AND is_active = "Y"';// AND level = "'.$level.'"';
                    $modelFeaturesOperations = $modelFeaturesOperations->find(array('condition' => $condition, 'order' => 'id DESC'));
                    if ($modelFeaturesOperations) {
                        if ($modelFeaturesOperations->operation_status == 'R') {
                            $approveLevel = ($modelFeaturesOperations->level-1>0)?$modelFeaturesOperations->level-1:$modelFeaturesOperations->level;
                            break;
                        } else {
                            $approveLevel = ($modelFeaturesOperations->level < $model_level_approval->max_level)?$modelFeaturesOperations->level+1:0;
                            break;
                        }
                    } else {
                        $approveLevel = $level;
                    }
                }
            }
        }
        return $approveLevel;
    }

    public static function getAccessApproveLevel($currentLevel, $user_id, $type) {
        $accessLevel = "N";
        $model = new self;
        $operations_array = $model->operations_array;
        if (array_key_exists($type, $operations_array) && $currentLevel>0) {
            $model_level_access = self::model()->find(array('condition' => ' operations_type="' . $type .'" AND max_level > 0 AND level_'.$currentLevel.'_authority = '.$user_id.''));
            if ($model_level_access->id > 0) {
                $accessLevel = "Y";
            }
            $model_level_approval = self::model()->find(array('condition' => ' operations_type="' . $type .'" '));
            if ($model_level_approval->max_level > $currentLevel) {
                $approveLevel = $model_level_approval->max_level;
                for ($level = $currentLevel+1; $level <= $model_level_approval->max_level; $level++) {
                    $model_level_access = self::model()->find(array('condition' => ' operations_type="' . $type .'"  AND max_level > 0 AND level_'.$level.'_authority = '.$user_id.''));
                    if ($model_level_access->id > 0) {
                        $accessLevel = "Y";
                        break;
                    }
                }
            }
        }
        return $accessLevel;
    }



       
        public function validateDuplicateAuthority()
        {
            if($this->max_level>0 && $this->employee_id>0){
                $maxLevel = $this->max_level; // Set the maximum level
                $authorityValues = [];
                $hasDuplicates = false;
                for ($level = 1; $level <= $maxLevel; $level++) {
                    $value = $this->{'level_' . $level . '_authority'};
                    if (!empty($value)) {
                        if (isset($authorityValues[$value])) {
                            $this->addError('level_' . $level . '_authority', 'Duplicate entry found in level ' . $level . ' of '.$this->employeedetail->employeefullname);
                            $hasDuplicates = true;
                        } else {
                            $authorityValues[$value] = true;
                        }
                    }
                }
                return !$hasDuplicates;
            }else if($this->max_level>0 && $this->employee_id==0){
                $maxLevel = $this->max_level; // Set the maximum level
                $authorityValues = [];
                $hasDuplicates = false;
                for ($level = 1; $level <= $maxLevel; $level++) {
                    $value = $this->{'level_' . $level . '_authority'};
                    if (!empty($value)) {
                        if (isset($authorityValues[$value])) {
                            $this->addError('level_' . $level . '_authority', 'Duplicate entry found in level ' . $level.' of '.$this->functionalitydetail->functionality);
                            $hasDuplicates = true;
                        } else {
                            $authorityValues[$value] = true;
                        }
                    }
                }
                return !$hasDuplicates;
            }
            else{
                if($this->max_level==0){
                    $this->addError('max_level', 'Level Must be Greater than 0');
                        return false;
                }else{
                    return true;
                }
            }
        }
        public function validatedocumentlevel() {
            if($this->max_level != '' && $this->functionality_id==4) {
                if($this->max_level==1){
                    if ($this->level_1_type!='H') {
                        $this->addError('level_1_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==2){
                    if ($this->level_2_type!='H') {
                        $this->addError('level_2_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==3){
                    if ($this->level_3_type!='H') {
                        $this->addError('level_3_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==4){
                    if ($this->level_4_type!='H') {
                        $this->addError('level_4_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }else if($this->max_level==5){
                    if ($this->level_5_type!='H') {
                        $this->addError('level_5_type', 'Select Final Level as Admin to Issue Document');
                        return false;
                    }
                }
            }
        }
        public function validatelevelapproval() {
            if($this->max_level > 0) {
                for ($level = 1; $level <= $this->max_level; $level++) {
                    $authorityField = 'level_' . $level . '_authority';
                    if (empty($this->$authorityField) || $this->$authorityField == 0) {
                        $this->addError(
                            $authorityField,
                            "Select Level {$level} Authority"
                        );
                        return false; // stop after first error
                    }
                }
            }
            //var_dump($this->max_level);
            //var_dump($this->level_1_authority);
            //var_dump($this->level_2_authority);
            //var_dump($this->level_3_authority);
           // var_dump($this->level_4_authority);
            //var_dump($this->level_5_authority);
            /*if($this->max_level != '') {
                if($this->max_level==1){
                    if ($this->level_1_authority=='' || $this->level_1_authority==0) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==2){
                    if (($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==3){
                    if (($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_authority=='' || $this->level_3_authority==0) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        //var_dump($this);
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==4){
                    if (($this->level_1_authority=='' || $this->level_1_authority==0)) {
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_authority=='' || $this->level_3_authority==0) {
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else if ($this->level_4_authority=='' || $this->level_4_authority==0) {
                        $this->addError('level_4_authority', 'Select Level 4 Authority');
                        return false;
                    }else {
                        return true;
                    }
                }else if($this->max_level==5){echo "1";
                    if (($this->level_1_authority=='' || $this->level_1_authority==0)) {echo "<br>2";
                        $this->addError('level_1_authority', 'Select Level 1 Authority');
                        return false;
                    }else if ($this->level_2_authority=='' || $this->level_2_authority==0) {echo "<br>3";
                        $this->addError('level_2_authority', 'Select Level 2 Authority');
                        return false;
                    }else if ($this->level_3_authority=='' || $this->level_3_authority==0) {echo "<br>4";
                        $this->addError('level_3_authority', 'Select Level 3 Authority');
                        return false;
                    }else if ($this->level_4_authority=='' || $this->level_4_authority==0) {echo "<br>5";
                        $this->addError('level_4_authority', 'Select Level 4 Authority');
                        return false;
                    }else if ($this->level_5_authority=='' || $this->level_5_authority==0) {echo "<br>6";
                        $this->addError('level_5_authority', 'Select Level 5 Authority');
                        return false;
                    }else {echo "<br>7";
                        return true;
                    }
                }
                var_dump($this);exit;
            }*/
        }
	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
            'level1details' => array(self::BELONGS_TO, 'User', 'level_1_authority'),
            'level2details' => array(self::BELONGS_TO, 'User', 'level_2_authority'),
            'level3details' => array(self::BELONGS_TO, 'User', 'level_3_authority'),
            'level4details' => array(self::BELONGS_TO, 'User', 'level_4_authority'),
            'level5details' => array(self::BELONGS_TO, 'User', 'level_5_authority'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'operations_type' => 'Operations Name',
			'max_level' => 'Max Level',
			'level_1_authority' => 'Level 1 Authority',
			'level_2_authority' => 'Level 2 Authority',
			'level_3_authority' => 'Level 3 Authority',
			'level_4_authority' => 'Level 4 Authority',
			'level_5_authority' => 'Level 5 Authority',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('operations_type',$this->operations_type);
		$criteria->compare('max_level',$this->max_level);
		$criteria->compare('level_1_authority',$this->level_1_authority);
		$criteria->compare('level_2_authority',$this->level_2_authority);
		$criteria->compare('level_3_authority',$this->level_3_authority);
		$criteria->compare('level_4_authority',$this->level_4_authority);
		$criteria->compare('level_5_authority',$this->level_5_authority);
		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return HrEmployeeApproveLevel the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
    
    public static function getmailid($id,$level) {
            $employee_id=0;
            $model = self::model()->findbyPK($id);
            if($level==1){
                $employee_id=$model->level_1_authority;
            }else if($level==2){
                $employee_id=$model->level_2_authority;
            }else if($level==3){
                $employee_id=$model->level_3_authority;
            }else if($level==4){
                $employee_id=$model->level_4_authority;
            }else if($level==5){
                $employee_id=$model->level_5_authority;
            }
            return $employee_id;
        }
    public static function getleveltype($id,$level) {
            $approval_login='';
            $arr_login=array('N'=>'ADM','L'=>'ESS','S'=>'ESS','N'=>'ESS');
            $model = self::model()->findbyPK($id);
            if($level==1){
                $approval_login=$arr_login[$model->level_1_type];
            }else if($level==2){
                $approval_login=$arr_login[$model->level_2_type];
            }else if($level==3){
                $approval_login=$arr_login[$model->level_3_type];
            }else if($level==4){
                $approval_login=$arr_login[$model->level_4_type];
            }else if($level==5){
                $approval_login=$arr_login[$model->level_5_type];
            }
            return $approval_login;
        }
}
