<?php
class ApprovelevelController extends Controller {
    public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array( 'listleveldetail', 'listlevelusers','SaveFeaturesApprovals', 'Saveapprove', 'Savereject', 'GetApprovalHistory', 'GetApprovalHistoryList'
                    ),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function actionlistleveldetail() {   
        $max_level =Yii::app()->request->getparam('max_level'); 
        $operations_type =Yii::app()->request->getparam('operations_type'); 
        $employee_id =Yii::app()->request->getparam('employee_id'); 
        $row =Yii::app()->request->getparam('row'); 
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $this->renderPartial('level_list', array('max_level' => $max_level,'operations_type' => $operations_type,'employee_id'=>$employee_id,'row'=>$row), false, true); 
    }

    public static function actionlistlevelusers() {
        $level_id =Yii::app()->request->getparam('level_id');
        $row_field_id =Yii::app()->request->getparam('row_field_id');
        $model_approval = new FeaturesApproveLevel();
        $users_list = $model_approval->getUsersByLevel($level_id);
        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        echo CHtml::activedropDownList($model_approval, '[' . $row_field_id . ']level_'.$level_id.'_authority', $users_list, array('class' => 'searchdropdown class_level_1_user', 'empty' => 'Select', 'style' => "width:250px;", 'onchange' => 'checkuserexist(this.id,1)'));
    }

    public static function SaveFeaturesApprovals($dataArray) {
        if ($dataArray) {
            Yii::import('application.modules.features.models.FeaturesApproveLevel');
            foreach ($dataArray as $approvalKey => $approvalData) {
                $featuresApproveLevel[$approvalKey] = new FeaturesApproveLevel();
                //if ($approvalData && $approvalData['max_level']>0) {
                    if ($approvalData['id']>0) {
                        $featuresApproveLevel[$approvalKey] = FeaturesApproveLevel::model()->findByPk($approvalData['id']);
                        $featuresApproveLevel[$approvalKey]['updated_by'] = Yii::app()->user->id;
                        $featuresApproveLevel[$approvalKey]['updated_date_time'] = date('Y-m-d h:i:s');
                    } else {
                        $featuresApproveLevel[$approvalKey]['created_by'] = Yii::app()->user->id;
                        $featuresApproveLevel[$approvalKey]['created_date_time'] = date('Y-m-d h:i:s');
                    }
                    $featuresApproveLevel[$approvalKey]['operations_type'] = $approvalData['operations_type']?$approvalData['operations_type']:'';
                    $featuresApproveLevel[$approvalKey]['max_level'] = $approvalData['max_level']?$approvalData['max_level']:0;
                    //$featuresApproveLevel[$approvalKey]['level_1_type'] = $approvalData['level_1_type']?$approvalData['level_1_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_1_authority'] = $approvalData['level_1_authority']?$approvalData['level_1_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_2_type'] = $approvalData['level_2_type']?$approvalData['level_2_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_2_authority'] = $approvalData['level_2_authority']?$approvalData['level_2_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_3_type'] = $approvalData['level_3_type']?$approvalData['level_3_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_3_authority'] = $approvalData['level_3_authority']?$approvalData['level_3_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_4_type'] = $approvalData['level_4_type']?$approvalData['level_4_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_4_authority'] = $approvalData['level_4_authority']?$approvalData['level_4_authority']:'';
                    //$featuresApproveLevel[$approvalKey]['level_5_type'] = $approvalData['level_5_type']?$approvalData['level_5_type']:'';
                    $featuresApproveLevel[$approvalKey]['level_5_authority'] = $approvalData['level_5_authority']?$approvalData['level_5_authority']:'';
                    //$valid = $featuresApproveLevel[$approvalKey]->validate();
                    if($featuresApproveLevel[$approvalKey]->validate()){
                        $featuresApproveLevel[$approvalKey]->save();
                    }
                //}
            }
            // if ($valid) {
            //     if (!empty($featuresApproveLevel)) {
            //         foreach ($FeaturesAppfeaturesApproveLevelroveLevel as $eachModel) {
            //             $eachModel->save();
            //         }
            //     }
            // } else {
            //     $error = CActiveForm::validate($featuresApproveLevel, '', false);
            //     if ($error != '[]')
            //         echo $error;
            // }
            //$jsonData['status'] = 'success';
            //echo CJSON::encode($jsonData);
        }
    }
    
    public function actionSaveapprove() {
        if ((isset($_POST['Quotes']) && $_POST['Quotes']) || (isset($_POST['PurchasingOrder']) && $_POST['PurchasingOrder']) || (isset($_POST['Order']) && $_POST['Order']) || (isset($_POST['Lead']) && $_POST['Lead'])){
            $valid=true;
            $itemsQuotes = $_POST['Quotes'];
            $itemsPurchasingOrder = $_POST['PurchasingOrder'];
            $itemsOrder = $_POST['Order'];
            $itemsLead = $_POST['Lead'];
            if($itemsQuotes['id']>0){
                $modelQuotes = Quotes::model()->findByPK($itemsQuotes['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'QU';
                $modelFeaturesOperations->file_no = $modelQuotes->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelQuotes->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsQuotes['notes'];
            }
            if($itemsPurchasingOrder['id']>0){
                $modelPurchasingOrder = PurchasingOrder::model()->findByPK($itemsPurchasingOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PO';
                $modelFeaturesOperations->file_no = $modelPurchasingOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsPurchasingOrder['notes'];
            }
            if($itemsOrder['id']>0){
                $modelOrder = Order::model()->findByPK($itemsOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'SO';
                if ($_POST['frm'] == 3) {
                    $modelFeaturesOperations->operations_type = 'SRO';
                }
                $modelFeaturesOperations->file_no = $modelOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsOrder['notes'];
            }
            if($itemsLead['id']>0){
                $modelLead = Lead::model()->findByPK($itemsLead['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'LE';
                $modelFeaturesOperations->file_no = $modelLead->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelLead->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'A';
                $modelFeaturesOperations->notes = $itemsLead['notes'];
            }
            $valid = $modelFeaturesOperations->validate() && $valid;
            if($valid){
                if (!empty($modelFeaturesOperations)) {
                    $modelFeaturesOperations->save();
                    $model_approval = new FeaturesApproveLevel();
                    $model_level_approval = $model_approval->model()->find(array('condition' => ' operations_type="' . $modelFeaturesOperations->operations_type .'"'));
                    if ($model_level_approval->max_level == $modelFeaturesOperations->level) {
                        $status = 'Q';
                        if ($modelFeaturesOperations->operations_type == 'PO') {
                            $status = 'P_O';
                        } elseif ($modelFeaturesOperations->operations_type == 'SO') {
                            $status = 'O';
                        } elseif ($modelFeaturesOperations->operations_type == 'SRO') {
                            $status = 'O';
                        } elseif ($modelFeaturesOperations->operations_type == 'LE') {
                            $status = 'L';
                        }
                        MasterFile::model()->updateByPk($modelFeaturesOperations->file_no, array('is_approved' => "Y", 'current_process_status' => $status, 'date_of_approval' => date('Y-m-d'), 'approved_by' => Yii::app()->user->id));
                    }
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($modelFeaturesOperations, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }
    
    public function actionSavereject() {
        if ((isset($_POST['Quotes']) && $_POST['Quotes']) || (isset($_POST['PurchasingOrder']) && $_POST['PurchasingOrder']) || (isset($_POST['Order']) && $_POST['Order']) || (isset($_POST['Lead']) && $_POST['Lead'])){
            $valid=true;
            $itemsQuotes = $_POST['Quotes'];
            $itemsPurchasingOrder = $_POST['PurchasingOrder'];
            $itemsOrder = $_POST['Order'];
            $itemsLead = $_POST['Lead'];
            if($itemsQuotes['id']>0){
                $modelQuotes = Quotes::model()->findByPK($itemsQuotes['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'QU';
                $modelFeaturesOperations->file_no = $modelQuotes->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelQuotes->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsQuotes['notes'];
            }
            if($itemsPurchasingOrder['id']>0){
                $modelPurchasingOrder = PurchasingOrder::model()->findByPK($itemsPurchasingOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'PO';
                $modelFeaturesOperations->file_no = $modelPurchasingOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelPurchasingOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsPurchasingOrder['notes'];
            }
            if($itemsOrder['id']>0){
                $modelOrder = Order::model()->findByPK($itemsOrder['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'SO';
                $modelFeaturesOperations->file_no = $modelOrder->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelOrder->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsOrder['notes'];
            }
            if($itemsLead['id']>0){
                $modelLead = Lead::model()->findByPK($itemsLead['id']);
                $modelFeaturesOperations = new FeaturesOperations();
                $modelFeaturesOperations->operations_type = 'LE';
                $modelFeaturesOperations->file_no = $modelLead->file_id;
                $modelFeaturesOperations->operation_date = date('Y-m-d H:i:s');
                $modelFeaturesOperations->level = $_POST['level'];
                $modelFeaturesOperations->header_id = $modelLead->id;
                $modelFeaturesOperations->user_id = Yii::app()->user->id;
                $modelFeaturesOperations->user_name = Yii::app()->user->name;
                $modelFeaturesOperations->operation_status = 'R';
                $modelFeaturesOperations->notes = $itemsLead['notes'];
            }
            $valid = $modelFeaturesOperations->validate() && $valid;
            if($valid){
                if (!empty($modelFeaturesOperations)) {
                    $modelFeaturesOperations->save();
                }
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            }else{
                $error = CJSON::encode(json_decode(CActiveForm::validateTabular($modelFeaturesOperations, '', false), true));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionGetApprovalHistory() {
        $file_id = Yii::app()->request->getparam("file_id");
        $modelHistory = FeaturesOperations::model()->find(array('condition' => 'file_no = "' . $file_id . '"'));
        if (empty($modelHistory)) {
            $modelHistory = new FeaturesOperations();
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, '*jquery-2.1.4.min.js' => false, 'jquery-2.1.4.min.js' => false, '*.css' => false);
        $this->renderPartial('approval_history', array('modelHistory' => $modelHistory, 'file_id' => $file_id), false, true);
    }

    public function actionGetApprovalHistoryList()
    {
        $model = new FeaturesOperations();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.user_id',
            1 => 't.operation_date',
            2 => 't.level',
            3 => 't.operations_type',
            4 => 'notes'
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.file_no = "' . $_POST['file_id'] . '"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (user_name LIKE '%" . $searchString . "%' OR operations_type LIKE '%" . $searchString . "%' OR notes LIKE '%" . $searchString . "%')";
        }
        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'operation_date DESC'));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($model as $row) {
            $button_string = "";
            $status = "Approved";
            if ($row['operation_status'] == 'R') {
                $status = "Rejected";
            }
            $rowData[] = array($m, $row['user_name'], date("d/m/Y h:i:s", strtotime($row['operation_date'])), $row['level'], $status, $row['notes']);
            $m++;
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }
}