<?php

class FavouriteController extends Controller
{
     public function accessRules() {
        return array(
            array('allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array('allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('index', 'Create','SaveFavourite','ViewFavourities'),
                'expression' => '$user->isMember()',
            ),
            array('deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
	public function actionIndex() {
       
        $this->render('index');
    }
    
    

    public function actionViewFavourities()
    {
        $this->render('favourites');
    }


    public function actionSaveFavourite() {
        $model = new MasFavourite();
    
        if (isset($_POST['MasFavourite'])) {
            $userId = $_POST['MasFavourite']['user_id'] ?? Yii::app()->user->id; // Get user ID from POST
    
            // Check if a record with the same created_by already exists
            $existingModel = MasFavourite::model()->find('created_by = :userId', [':userId' => $userId]);
    
            // If an existing record is found, update it
            if ($existingModel) {
                $model = $existingModel; // Use existing model
                $model->updated_by = $userId; // Update updated_by
                $model->updated_datetime = date('Y-m-d H:i:s');
    
            } else {
                // No existing record means we want to create a new record
                $model->created_by = $userId; // Set created_by for the new row
                $model->created_datetime = date('Y-m-d H:i:s');
            }
    
            // Process favourites
            $favourites = [];
            foreach ($_POST['MasFavourite']['favourites'] as $eachfavouritesArray) {
                if (is_array($eachfavouritesArray)) {
                    foreach ($eachfavouritesArray as $eachfavourites) {
                        $favourites[$eachfavourites] = 1;
                    }
                }
            }
            $model->favourites = json_encode($favourites);
    
            // Save the model
            if ($model->save()) {
                $jsonData['status'] = 'success';
                echo CJSON::encode($jsonData);
            } else {
                // Collect and echo validation errors
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') {
                    echo $error; // Return validation errors if any
                }
            }
        }
    }
    
    
    
    
    
    
    



}