<?php



/**

 * This is the model class for table "{{order_addition}}".

 *

 * The followings are the available columns in table '{{order_addition}}':

 * @property integer $id

 * @property integer $order_id

 * @property string $particular

 * @property string $particular_value

 * @property double $calculated_value

 */

class ProductionGoodsReceiptAddition extends CActiveRecord {



    /**

     * @return string the associated database table name

     */

    public function tableName() {

        return '{{production_goods_receipt_addition}}';

    }



    /**

     * @return array validation rules for model attributes.

     */

    public function rules() {

        // NOTE: you should only define rules for those attributes that

        // will receive user inputs.

        return array(

            //array('order_id, particular, particular_value, calculated_value', 'required'),

            array('production_goods_receipt_id', 'numerical', 'integerOnly' => true),

            array('calculated_value', 'numerical'),

            array('particular', 'length', 'max' => 255),

            array('particular_value', 'length', 'max' => 50),

            // The following rule is used by search().

            // @todo Please remove those attributes that should not be searched.

            array('id, production_goods_receipt_id, particular, particular_value, calculated_value', 'safe', 'on' => 'search'),

        );

    }



    /**

     * @return array relational rules.

     */

    public function relations() {

        // NOTE: you may need to adjust the relation name and the related

        // class name for the relations automatically generated below.

        return array(

            

        );

    }



    /**

     * @return array customized attribute labels (name=>label)

     */

    public function attributeLabels() {

        return array(

            'id' => 'ID',

            'production_goods_receipt_id' => 'Goods Receipt',

            'particular' => 'Particular',

            'particular_value' => 'Particular Value',

            'calculated_value' => 'Calculated Value',

        );

    }



    /**

     * Retrieves a list of models based on the current search/filter conditions.

     *

     * Typical usecase:

     * - Initialize the model fields with values from filter form.

     * - Execute this method to get CActiveDataProvider instance which will filter

     * models according to data in model fields.

     * - Pass data provider to CGridView, CListView or any similar widget.

     *

     * @return CActiveDataProvider the data provider that can return the models

     * based on the search/filter conditions.

     */

    public function search() {

        // @todo Please modify the following code to remove attributes that should not be searched.



        $criteria = new CDbCriteria;



        $criteria->compare('id', $this->id);

        $criteria->compare('production_goods_receipt_id', $this->production_goods_receipt_id);

        $criteria->compare('particular', $this->particular, true);

        $criteria->compare('particular_value', $this->particular_value, true);

        $criteria->compare('calculated_value', $this->calculated_value);



        return new CActiveDataProvider($this, array(

            'criteria' => $criteria,

        ));

    }



    /**

     * Returns the static model of the specified AR class.

     * Please note that you should have this exact method in all your CActiveRecord descendants!

     * @param string $className active record class name.

     * @return OrderAddition the static model class

     */

    public static function model($className = __CLASS__) {

        return parent::model($className);

    }



}

