<?php
//created by nisha on 21-09-2022
class AutoproductionController extends Controller
{

    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('CreateAutoProductionOrder', 'SaveAutoProductionOrder'),
                /**modified and editted by jisha on 08-11-17**/
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
    public function actionCreateAutoProductionOrder()
    {
        $id = (int) Yii::app()->request->getParam('id');
        $modelProductionOrder = new ProductionOrder();
        $modelProductionOrderItem   =   array(new ProductionOrderItem());

        $modelBillofMaterial        =   new ProductionBillofmaterial();
        $modelBillofMaterial        =   $modelBillofMaterial->findByPk($id);
        $modelProductionOrder->billofmaterial_id = $id;
        $modelProductionOrder->quantity = $modelBillofMaterial->quantity;
        $modelBillofMaterialItems = ProductionBillofmaterialItem::model()->findAll(array('condition' => 'production_billofmaterial_id = ' . $id));
        if (empty($modelBillofMaterialItems)) {
            $modelProductionOrderItem = array(new ProductionOrderItem());
        } else {
            foreach ($modelBillofMaterialItems as $i => $eachBOMItem) {

                $modelProductionOrderItem[$i] = new ProductionOrderItem();
                $modelProductionOrderItem[$i]->product_id           = $eachBOMItem->product_id;
                $modelProductionOrderItem[$i]->product_name         = $eachBOMItem->product_name;
                $modelProductionOrderItem[$i]->description          = $eachBOMItem->description;
                $modelProductionOrderItem[$i]->quantity             = (float) ($eachBOMItem->quantity * $modelProductionOrder->quantity);
                // echo"tesr=".$modelProductionOrderItem[$i]->quantity;
                $modelProductionOrderItem[$i]->bom_qty              = $eachBOMItem->quantity;
            }
        }


        $modelStore = new Store();
        $modelStore = $modelStore->findByPk((int) $modelBillofMaterial->product_id);
        $total_free_qty         = (float) $modelStore->totalQuantity;
        $total_allocated_qty    = (float) $modelStore->total_allocated_quantity;
        $total_available_qty    = $total_free_qty - $total_allocated_qty;

        $modelWarehouse = new MasInventoryWarehouse();
        $modelWarehouse = $modelWarehouse->find(array('condition' => 'isBaseWarehouse="Y"'));
        $warehouse_id = (int) $modelWarehouse->id;

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
        $this->render('auto_product_order', array('modelProductionOrder' => $modelProductionOrder, 'modelProductionOrderItem' => $modelProductionOrderItem, 'total_available_qty' => $total_available_qty));
    }



    public function actionSaveAutoProductionOrder()
    {
        $modelProductionOrder = new ProductionOrder();
        $modelProductionOrderItem = array(new ProductionOrderItem());
        $valid = true;
        $qty_error = array();

        if (isset($_POST['ProductionOrder'])) {
            if ((int) @$_POST['ProductionOrder']['billofmaterial_id'] > 0) {

                $modelWarehouse = new MasInventoryWarehouse();
                $modelWarehouse = $modelWarehouse->find(array('condition' => 'isBaseWarehouse="Y"'));
                $warehouse_id = (int) $modelWarehouse->id;

                $bom_id = (int) @$_POST['ProductionOrder']['billofmaterial_id'];
                $production_qty = $_POST['ProductionOrder']['quantity'];
                $modelBillofMaterial        =   new ProductionBillofmaterial();
                $modelBillofMaterialItems   =   array(new ProductionBillofmaterialItem());

                $modelBillofMaterial        =   $modelBillofMaterial->findByPk($bom_id);

                $modelProductionOrder->billofmaterial_id    = $bom_id;
                $modelProductionOrder->product_id           = $modelBillofMaterial->product_id;
                $modelProductionOrder->description          = $modelBillofMaterial->description;
                $modelProductionOrder->quantity             = $production_qty;
                $modelProductionOrder->unit                 = $modelBillofMaterial->unit;
                $modelProductionOrder->file_id              = $modelBillofMaterial->file_id;
                $productionorder_date                       = '';
                if ($_POST['ProductionOrder']['productionorder_date'] != '') {
                    $productionorder_date = str_replace('/', '-', $_POST['ProductionOrder']['productionorder_date']);
                    $productionorder_date = date("Y-m-d", strtotime($productionorder_date));
                }
                $modelProductionOrder->productionorder_date = $productionorder_date;
                $modelProductionOrder->end_date             = $productionorder_date;
                $modelProductionOrder->customer_id          = 0;
                $modelProductionOrder->variance             = 0;
                $modelProductionOrder->vendor_id            = 0;
                $modelProductionOrder->notes                = $modelBillofMaterial->notes;
                $modelProductionOrder->remarks              = $modelBillofMaterial->remarks;
                $modelProductionOrder->terms_and_conditions = $modelBillofMaterial->terms_and_conditions;
                $modelProductionOrder->reference            = '';
                $modelProductionOrder->connected_file       = 0;
                $modelProductionOrder->grand_total          = 0;
                $modelProductionOrder->project              = 0;
                $modelProductionOrder->goods_issue_status   = "C";
                $modelProductionOrder->po_row               = 0;
                $modelProductionOrder->crm_user_id          = Yii::app()->user->id;
                $modelProductionOrder->created_by           = Yii::app()->user->id;
                $modelProductionOrder->created_datetime     = date('Y-m-d h:i:s');
                $modelProductionOrder->updated_by           = 0;
                $modelProductionOrder->created_datetime     = '0000-00-00 00:00:00';


                $modelBillofMaterialItems = ProductionBillofmaterialItem::model()->findAll(array('condition' => 'production_billofmaterial_id = ' . $bom_id));
                if (empty($modelBillofMaterialItems)) {
                    $modelBillofMaterialItems = array(new ProductionBillofmaterialItem());
                }

                $arr_service_item = [];
                foreach ($modelBillofMaterialItems as $i => $eachBOMItem) {
                 
                    $modelProductionOrderItem[$i] = new ProductionOrderItem();
                    $modelProductionOrderItem[$i]->production_order_id  = 0;
                    $modelProductionOrderItem[$i]->bom_item_id          = $eachBOMItem->id;
                    $modelProductionOrderItem[$i]->product_id           = $eachBOMItem->product_id;
                    $modelProductionOrderItem[$i]->product_name         = $eachBOMItem->product_name;
                    $modelProductionOrderItem[$i]->description          = $eachBOMItem->description;
                    $modelProductionOrderItem[$i]->unit                 = $eachBOMItem->unit;
                    $modelProductionOrderItem[$i]->quantity             = ($eachBOMItem->quantity * $production_qty);
                    $modelProductionOrderItem[$i]->bom_qty              = $eachBOMItem->quantity;
                    $modelProductionOrderItem[$i]->amount               = 0;
                    $modelProductionOrderItem[$i]->created_by           = Yii::app()->user->id;
                    $modelProductionOrderItem[$i]->created_datetime     = date('Y-m-d h:i:s');
                    $modelProductionOrderItem[$i]->updated_by           = 0;
                    $modelProductionOrderItem[$i]->updated_datetime     = '0000-00-00 00:00:00';
                    $modelProductionOrderItem[$i]->wastage_qty          = $_POST['ProductionOrderItem'][$i]['wastage_qty'];

                    $modelStore = new Store();
                    $modelStore = $modelStore->findByPk((int) $eachBOMItem->product_id);

                    $total_free_qty         = (float) $modelStore->totalQuantity;
                    $total_allocated_qty    = (float) $modelStore->total_allocated_quantity;

                    $total_available_qty    = $total_free_qty - $total_allocated_qty;

                    if ($modelProductionOrderItem[$i]->quantity > $total_available_qty && ($modelStore->inventory_item_type != 2)) {
                        $qty_error[] = $eachBOMItem->product_name . ' maximum sellable qty : ' . ($total_available_qty);
                        $valid = false;
                    }

                    $arr_service_item[] = $modelStore->inventory_item_type;


                    $i++;
                }
            }
        }

        /* echo '<pre>';
        print_r($modelProductionOrderItem);
        exit;*/

        $cost_rate = 0;
        if ($valid) {
            /*`id`, `goods_issue_date`, `file_id`, `ticket_id`, `ledger_id`, `subledger_id`, `customer_id`, `project_id`, `project_classification_id`, 
            `contract_id`, `warehouse_id`, `notes`, `terms_and_conditions`, `remarks`, `reference`, `issue_notification`, `isActive`,
            `stock_updated`, `created_by`, `updated_by`, `created_date_time`, `updated_date_time`, `posted`, `issue_type`, `reference_id`*/
            //Save to production order

            // -------------------------------

            $have_service_item = "N"; // Default value
            foreach ($arr_service_item as $value) {
                if ($value == 2) {
                    $have_service_item = "Y"; // Set to Y if any item is 2
                    break; // Exit the loop as soon as we find a 2
                }
            }
            $modelProductionOrder->have_service_item = $have_service_item;
            // -------------------------------

            $modelProductionOrder->save();
            $production_order_id = $modelProductionOrder->id;
            //added by jisha
            $po_header_unit_id =$modelProductionOrder->unit;
            $modelPOHeaderUOM   = new UnitOfMeasurement();
            $modelPOHeaderUOM    = $modelPOHeaderUOM->findByPk((int) $po_header_unit_id);
            $po_header_unit_factor = $modelPOHeaderUOM->factor;
            //added by jisha
            
            
            
            //save data into goods issue
            $modelGoodsIssue = new InventoryGoodsIssue();
            //$modelGoodsIssueItem = new InventoryGoodsIssueItem();
            $modelGoodsIssue->goods_issue_date     = $productionorder_date;
            $modelGoodsIssue->file_id              = 0;
            $modelGoodsIssue->customer_id          = 0;
            $modelGoodsIssue->project_id           = 0;
            $modelGoodsIssue->notes                = $modelBillofMaterial->notes;
            $modelGoodsIssue->terms_and_conditions = $modelBillofMaterial->terms_and_conditions;
            $modelGoodsIssue->remarks              = $modelBillofMaterial->remarks;
            $modelGoodsIssue->isActive             = 'Y';
            $modelGoodsIssue->ticket_id           = $modelBillofMaterial->product_id;
            //$modelGoodsIssue->description          = $modelBillofMaterial->description;
            $modelGoodsIssue->project_classification_id = $production_qty;
            $modelGoodsIssue->reference            = 'PGI';
            $modelGoodsIssue->issue_type            = 'PR';
            //$modelGoodsIssue->grand_total          = 0;
            $modelGoodsIssue->stock_updated        = 'Y';
            //$modelGoodsIssue->status               = 'CM';
            //$modelGoodsIssue->crm_user_id          = Yii::app()->user->id;;
            $modelGoodsIssue->reference_id         = $modelProductionOrder->id;
            $modelGoodsIssue->created_by           = Yii::app()->user->id;
            $modelGoodsIssue->created_date_time     = date('Y-m-d h:i:s');;
            $modelGoodsIssue->updated_by           = Yii::app()->user->id;
            $modelGoodsIssue->updated_date_time     = "0000-00-00 00:00:00";
            $modelGoodsIssue->warehouse_id      = $warehouse_id;
            $modelGoodsIssue->save(false);
            //end
            $goods_issue_id = $modelGoodsIssue->id;



            $grand_total = $totalwastage_qty = 0;
            foreach ($modelProductionOrderItem as $j => $eachItem) {

                $modelStore = new Store();
                $modelStore = $modelStore->findByPk((int) $eachItem->product_id);



                //save data into production order item
                $eachItem->production_order_id = $modelProductionOrder->id;
                $eachItem->rate = $modelStore->rate;
                $eachItem->amount = ($modelStore->rate * $eachItem->quantity);
                $eachItem->goods_issue_cost_rate    = $eachItem->rate;

                $grand_total += $eachItem->amount;
                $eachItem->save(false);
                //end

                if ($modelStore->inventory_item_type !== 2) {

                    // ---------------------START---------PRODUCTION_GOODS_ISSUE-----------------------------------------
                    //don't add service item in goods issue
                    //save data into goods issue item
                    $modelGoodsIssueItem = new InventoryGoodsIssueItem();
                    $modelGoodsIssueItem->inventory_goods_issue_id = $modelGoodsIssue->id;
                    $modelGoodsIssueItem->product_location_id      = $eachItem->id;
                    $modelGoodsIssueItem->product_id               = $eachItem->product_id;
                    $modelGoodsIssueItem->product_name             = $eachItem->product_name;
                    $modelGoodsIssueItem->description              = $eachItem->description;
                    //$modelGoodsIssueItem->quantity                 = $eachItem->quantity;
                    $modelGoodsIssueItem->picked_qty               = $eachItem->quantity;
                    $modelGoodsIssueItem->unit                     = $eachItem->unit;
                    $modelGoodsIssueItem->rate                     = $eachItem->rate;
                    //$modelGoodsIssueItem->amount                   = $eachItem->amount;
                    $modelGoodsIssueItem->created_by               = Yii::app()->user->id;
                    $modelGoodsIssueItem->created_date_time         = date("Y-m-d H:i:s");
                    $modelGoodsIssueItem->save(false);
                    //end


                    //save data into stock ledger for goods issue


                    $modelUOM   = new UnitOfMeasurement();
                    $arr_uom    = $modelUOM->findByPk((int) $eachItem->unit);

                    $modelIssueStockLedger                         =   new StockLedger();
                    $modelIssueStockLedger->file_id                =   $modelBillofMaterial->file_id;
                    $modelIssueStockLedger->header_id              =   $modelGoodsIssue->id;
                    $modelIssueStockLedger->header_item_id         =   $modelGoodsIssueItem->id;
                    $modelIssueStockLedger->customer_vendor_id     =   0;
                    $modelIssueStockLedger->customer_vendor_name   =   '';
                    $modelIssueStockLedger->product_id             =   $eachItem->product_id;
                    $modelIssueStockLedger->product_name           =   $eachItem->product_name;
                    $modelIssueStockLedger->product_description    =   $eachItem->description;
                    $modelIssueStockLedger->brand_id               =   $modelStore->brand_class_id;
                    $modelIssueStockLedger->brand_name             =   $modelStore->brand_detail->brand_name;
                    $modelIssueStockLedger->warehouse_id           =   $warehouse_id;
                    $modelIssueStockLedger->warehouse_name         =   MasInventoryWarehouse::getWarehouseName($warehouse_id);
                    $modelIssueStockLedger->rack_id                =   $modelStore->rack_id;
                    $modelIssueStockLedger->rack_name              =   MasInvRack::getRackName($modelStore->rack_id);
                    $modelIssueStockLedger->bin_id                 =   $modelStore->bin_id;
                    $modelIssueStockLedger->bin_name               =   MasInvBin::getBinName($modelStore->bin_id);
                    $modelIssueStockLedger->unit_id                =   $eachItem->unit;
                    $modelIssueStockLedger->unit_name              =   $arr_uom->name;
                    $modelIssueStockLedger->unit_factor            =   abs($arr_uom->factor);
                    $modelIssueStockLedger->quantity               =   (-1 * $eachItem->quantity);
                    $modelIssueStockLedger->available_status       =   'U';
                    $modelIssueStockLedger->batch_no               =   '';
                    $modelIssueStockLedger->serial_no              =   '';
                    $modelIssueStockLedger->manufacturing_date     =   '0000-00-00';
                    $modelIssueStockLedger->expiry_date            =   '0000-00-00';
                    $modelIssueStockLedger->cost_price             =   $modelStore->rate;
                    $modelIssueStockLedger->sales_price            =   0;
                    $modelIssueStockLedger->transaction_date       =   $productionorder_date;;
                    $modelIssueStockLedger->transaction_from       =   'PRODUCTION_GOODS_ISSUE';
                    $modelIssueStockLedger->transaction_type       =   "OUT";
                    $modelIssueStockLedger->created_by             =   Yii::app()->user->id;
                    $modelIssueStockLedger->created_date           =   date("Y-m-d H:i:s");
                    $modelIssueStockLedger->master_stock_ledger_id =   0;
                    $modelIssueStockLedger->save(false);
                    //end
                    // ---------------------END---------PRODUCTION_GOODS_ISSUE-----------------------------------------


                }
                $totalwastage_qty += (float)$eachItem->wastage_qty;

                $cost_rate += ($eachItem->bom_qty *$arr_uom->factor* $modelStore->rate);
            }

            if ((float)$totalwastage_qty > 0) {

                //-------------------------------------------------------------------------------------------
                // ----------------start----------INVENTORY_GOODS_ISSUE-----------------------------------
                //-------------------------------------------------------------------------------------------
                $modelGoodsIssue = new InventoryGoodsIssue();
                $modelGoodsIssue->goods_issue_date     = $productionorder_date;
                $modelGoodsIssue->file_id              = 0;
                $modelGoodsIssue->customer_id          = 0;
                $modelGoodsIssue->project_id           = 0;
                $modelGoodsIssue->notes                = $modelBillofMaterial->notes;
                $modelGoodsIssue->terms_and_conditions = $modelBillofMaterial->terms_and_conditions;
                $modelGoodsIssue->remarks              = $modelBillofMaterial->remarks;
                $modelGoodsIssue->isActive             = 'Y';
                $modelGoodsIssue->ticket_id           = $modelBillofMaterial->product_id;
                //$modelGoodsIssue->description          = $modelBillofMaterial->description;
                $modelGoodsIssue->project_classification_id = $production_qty;
                $modelGoodsIssue->reference            = 'Wastage';
                $modelGoodsIssue->issue_type            = 'WI';
                //$modelGoodsIssue->grand_total          = 0;
                $modelGoodsIssue->stock_updated        = 'Y';
                //$modelGoodsIssue->status               = 'CM';
                //$modelGoodsIssue->crm_user_id          = Yii::app()->user->id;;
                $modelGoodsIssue->reference_id         = $modelProductionOrder->id;
                $modelGoodsIssue->created_by           = Yii::app()->user->id;
                $modelGoodsIssue->created_date_time     = date('Y-m-d h:i:s');;
                $modelGoodsIssue->updated_by           = Yii::app()->user->id;
                $modelGoodsIssue->updated_date_time     = "0000-00-00 00:00:00";
                $modelGoodsIssue->warehouse_id      = $warehouse_id;
                $modelGoodsIssue->save(false);
                //end
                $goods_issue_id = $modelGoodsIssue->id;



                $grand_total = 0;
                foreach ($modelProductionOrderItem as $j => $eachItem) {
                    $modelStore = new Store();
                    $modelStore = $modelStore->findByPk((int) $eachItem->product_id);
                    //end
                    if ($modelStore->inventory_item_type !== 2 && (float)$eachItem->wastage_qty>0) {

                        //don't add service item in goods issue
                        //save data into goods issue item
                        $modelGoodsIssueItem = new InventoryGoodsIssueItem();
                        $modelGoodsIssueItem->inventory_goods_issue_id = $modelGoodsIssue->id;
                        $modelGoodsIssueItem->product_location_id      = $eachItem->id;
                        $modelGoodsIssueItem->product_id               = $eachItem->product_id;
                        $modelGoodsIssueItem->product_name             = $eachItem->product_name;
                        $modelGoodsIssueItem->description              = $eachItem->description;
                        $modelGoodsIssueItem->picked_qty               = $eachItem->wastage_qty;
                        $modelGoodsIssueItem->unit                     = $eachItem->unit;
                        $modelGoodsIssueItem->rate                     = $eachItem->rate;
                        //$modelGoodsIssueItem->amount                   = $eachItem->amount;
                        $modelGoodsIssueItem->created_by               = Yii::app()->user->id;
                        $modelGoodsIssueItem->created_date_time         = date("Y-m-d H:i:s");
                        $modelGoodsIssueItem->save(false);
                        //end


                        //save data into stock ledger for goods issue


                        $modelUOM   = new UnitOfMeasurement();
                        $arr_uom    = $modelUOM->findByPk((int) $eachItem->unit);

                        $modelIssueStockLedger                         =   new StockLedger();
                        $modelIssueStockLedger->file_id                =   $modelBillofMaterial->file_id;
                        $modelIssueStockLedger->header_id              =   $modelGoodsIssue->id;
                        $modelIssueStockLedger->header_item_id         =   $modelGoodsIssueItem->id;
                        $modelIssueStockLedger->customer_vendor_id     =   0;
                        $modelIssueStockLedger->customer_vendor_name   =   '';
                        $modelIssueStockLedger->product_id             =   $eachItem->product_id;
                        $modelIssueStockLedger->product_name           =   $eachItem->product_name;
                        $modelIssueStockLedger->product_description    =   $eachItem->description;
                        $modelIssueStockLedger->brand_id               =   $modelStore->brand_class_id;
                        $modelIssueStockLedger->brand_name             =   $modelStore->brand_detail->brand_name;
                        $modelIssueStockLedger->warehouse_id           =   $warehouse_id;
                        $modelIssueStockLedger->warehouse_name         =   MasInventoryWarehouse::getWarehouseName($warehouse_id);
                        $modelIssueStockLedger->rack_id                =   $modelStore->rack_id;
                        $modelIssueStockLedger->rack_name              =   MasInvRack::getRackName($modelStore->rack_id);
                        $modelIssueStockLedger->bin_id                 =   $modelStore->bin_id;
                        $modelIssueStockLedger->bin_name               =   MasInvBin::getBinName($modelStore->bin_id);
                        $modelIssueStockLedger->unit_id                =   $eachItem->unit;
                        $modelIssueStockLedger->unit_name              =   $arr_uom->name;
                        $modelIssueStockLedger->unit_factor            =   abs($arr_uom->factor);
                        $modelIssueStockLedger->quantity               =   (-1 * (float)$eachItem->wastage_qty);
                        $modelIssueStockLedger->available_status       =   'U';
                        $modelIssueStockLedger->batch_no               =   '';
                        $modelIssueStockLedger->serial_no              =   '';
                        $modelIssueStockLedger->manufacturing_date     =   '0000-00-00';
                        $modelIssueStockLedger->expiry_date            =   '0000-00-00';
                        $modelIssueStockLedger->cost_price             =   $modelStore->rate;
                        $modelIssueStockLedger->sales_price            =   0;
                        $modelIssueStockLedger->transaction_date       =   $productionorder_date;;
                        $modelIssueStockLedger->transaction_from       =   'GOODS_ISSUE';
                        $modelIssueStockLedger->transaction_type       =   "OUT";
                        $modelIssueStockLedger->created_by             =   Yii::app()->user->id;
                        $modelIssueStockLedger->created_date           =   date("Y-m-d H:i:s");
                        $modelIssueStockLedger->master_stock_ledger_id =   0;
                        $modelIssueStockLedger->save(false);
                        //end
                    }
                }
                //-------------------------------------------------------------------------------------------
                // ----------------end----------INVENTORY_GOODS_ISSUE-----------------------------------
                //-------------------------------------------------------------------------------------------
            }

            $modelProductionStore              = new Store();
            $modelProductionStore              = $modelProductionStore->findByPk((int) $modelBillofMaterial->product_id);

            $production_item_exist_qty         = (float) $modelProductionStore->totalQuantity;
            $production_item_exist_rate        = $modelProductionStore->rate;

            $production_item_rate     = $cost_rate * $production_qty;
            $production_item_old_rate = $production_item_exist_rate * $production_item_exist_qty;
            
            $production_total_qty     = $production_item_exist_qty + ($production_qty*$po_header_unit_factor);//added by jisha
            $new_production_rate      = (($production_item_rate + $production_item_old_rate) / $production_total_qty);
            $new_production_rate      = round($new_production_rate, 6);//base cost rate


            /*
            `id`, `goods_receipt_date`, `file_id`, `customer_id`, `project_id`, `ticket_id`, `contract_id`, `project_classification_id`, `warehouse_id`, `notes`, `terms_and_conditions`, 
            `remarks`, `reference`, `receipt_notification`, `isActive`, `stock_updated`, `created_by`, `updated_by`, `created_date_time`, `updated_date_time`, `posted`, `receipt_type`, `reference_id`
            */

            //save data into goods receipt
            $modelGoodsReceipt = new InventoryGoodsReceipt();
            //$modelGoodsReceipt->crm_user_id          = Yii::app()->user->id;;
            $modelGoodsReceipt->reference_id  = $modelProductionOrder->id;
            $modelGoodsReceipt->goods_receipt_date   = $productionorder_date;
            $modelGoodsReceipt->ticket_id           = $modelBillofMaterial->product_id;
            //$modelGoodsReceipt->product_name         = $modelBillofMaterial->part_number;
            //$modelGoodsReceipt->description          = $modelBillofMaterial->description;
            $modelGoodsReceipt->project_classification_id             = $production_qty;
            $modelGoodsReceipt->file_id              = 0;
            $modelGoodsReceipt->notes                = $modelBillofMaterial->notes;
            $modelGoodsReceipt->terms_and_conditions = $modelBillofMaterial->terms_and_conditions;
            $modelGoodsReceipt->remarks              = $modelBillofMaterial->remarks;
            $modelGoodsReceipt->isActive             = 'Y';
            $modelGoodsReceipt->reference            = 'PGR';
            $modelGoodsReceipt->receipt_type         = 'PGR';
            $modelGoodsReceipt->customer_id          = 0;
            //$modelGoodsReceipt->variants              = 0;
            //$modelGoodsReceipt->grand_total          = ($new_production_rate * $production_qty);
            $modelGoodsReceipt->stock_updated     = 'Y';
            $modelGoodsReceipt->created_by           = Yii::app()->user->id;
            $modelGoodsReceipt->created_date_time     = date('Y-m-d h:i:s');;
            $modelGoodsReceipt->updated_by           = Yii::app()->user->id;
            $modelGoodsReceipt->updated_date_time     = "0000-00-00 00:00:00";
            $modelGoodsReceipt->warehouse_id      = $warehouse_id;
            $modelGoodsReceipt->save(false);

            $goods_receipt_id = $modelGoodsReceipt->id;
            $goods_receipt_grand_total = ($new_production_rate * $production_qty);

            //end

            //save data into goods receipt item
            $modelGoodsReceiptItem = new InventoryGoodsReceiptItem();
            $modelGoodsReceiptItem->inventory_goods_receipt_id = $modelGoodsReceipt->id;
            $modelGoodsReceiptItem->po_item_id               = $modelProductionOrder->id;
            $modelGoodsReceiptItem->product_id               = $modelBillofMaterial->product_id;
            $modelGoodsReceiptItem->product_name             = $modelBillofMaterial->part_number;
            $modelGoodsReceiptItem->description              = $modelBillofMaterial->description;
            $modelGoodsReceiptItem->picked_qty               = $production_qty;
            $modelGoodsReceiptItem->unit                     = $modelBillofMaterial->unit;
            $modelGoodsReceiptItem->rate                     = $cost_rate;
            //$modelGoodsReceiptItem->amount                   = ($new_production_rate * $production_qty);
            $modelGoodsReceiptItem->created_by               = Yii::app()->user->id;
            $modelGoodsReceiptItem->created_date_time        = date("Y-m-d H:i:s");
            $modelGoodsReceiptItem->save(false);
            //end

            //save data into stock ledger for goods issue
            $modelStore = new Store();
            $modelStore = $modelStore->findByPk((int) $modelBillofMaterial->product_id);

            $modelUOM   = new UnitOfMeasurement();
            $arr_uom    = $modelUOM->findByPk((int) $modelBillofMaterial->unit);

            $modelReceiptStockLedger                         =   new StockLedger();
            $modelReceiptStockLedger->file_id                =   $modelBillofMaterial->file_id;
            $modelReceiptStockLedger->header_id              =   $modelGoodsReceipt->id;
            $modelReceiptStockLedger->header_item_id         =   $modelGoodsReceiptItem->id;
            $modelReceiptStockLedger->customer_vendor_id     =   0;
            $modelReceiptStockLedger->customer_vendor_name   =   '';
            $modelReceiptStockLedger->product_id             =   (int) $modelBillofMaterial->product_id;
            $modelReceiptStockLedger->product_name           =   $modelBillofMaterial->part_number;
            $modelReceiptStockLedger->product_description    =   $modelBillofMaterial->description;
            $modelReceiptStockLedger->brand_id               =   $modelStore->brand_class_id;
            $modelReceiptStockLedger->brand_name             =   $modelStore->brand_detail->brand_name;
            $modelReceiptStockLedger->warehouse_id           =   $warehouse_id;
            $modelReceiptStockLedger->warehouse_name         =   MasInventoryWarehouse::getWarehouseName($warehouse_id);
            $modelReceiptStockLedger->rack_id                =   $modelStore->rack_id;
            $modelReceiptStockLedger->rack_name              =   MasInvRack::getRackName($modelStore->rack_id);
            $modelReceiptStockLedger->bin_id                 =   $modelStore->bin_id;
            $modelReceiptStockLedger->bin_name               =   MasInvBin::getBinName($modelStore->bin_id);
            $modelReceiptStockLedger->unit_id                =   $modelBillofMaterial->unit;
            $modelReceiptStockLedger->unit_name              =   $arr_uom->name;
            $modelReceiptStockLedger->unit_factor            =   abs($arr_uom->factor);
            $modelReceiptStockLedger->quantity               =   $production_qty;
            $modelReceiptStockLedger->available_status       =   'A';
            $modelReceiptStockLedger->batch_no               =   '';
            $modelReceiptStockLedger->serial_no              =   '';
            $modelReceiptStockLedger->manufacturing_date     =   '0000-00-00';
            $modelReceiptStockLedger->expiry_date            =   '0000-00-00';
            $modelReceiptStockLedger->buying_price           =   $cost_rate/abs($arr_uom->factor);
            $modelReceiptStockLedger->cost_price             =   $new_production_rate;
            $modelReceiptStockLedger->sales_price            =   0;
            $modelReceiptStockLedger->transaction_date       =   $productionorder_date;;
            $modelReceiptStockLedger->transaction_from       =   'PRODUCTION_GOODS_RECEIPT';
            $modelReceiptStockLedger->transaction_type       =   "IN";
            $modelReceiptStockLedger->created_by             =   Yii::app()->user->id;
            $modelReceiptStockLedger->created_date           =   date("Y-m-d H:i:s");
            $modelReceiptStockLedger->master_stock_ledger_id =   0;
            $modelReceiptStockLedger->save(false);
            //end


            $modelProductionStore = new Store();

            $modelProductionStore->updateByPK((int) $modelBillofMaterial->product_id, array('rate' => $new_production_rate));

            $modelUpdateProductionOrder = new ProductionOrder();
            $modelUpdateProductionOrder->updateByPk($production_order_id, array('grand_total' => $grand_total, 'goods_issue_total_rate' => $grand_total));

            /*$modelUpdateProductionGoodsIssue = new ProductionGoodsIssue();
                $modelUpdateProductionGoodsIssue->updateByPk($goods_issue_id,array('grand_total'=>$grand_total,'warehouse_id'=>$warehouse_id));
                
                $modelUpdateProductionGoodsReceipt = new ProductionGoodsReceipt();
                $modelUpdateProductionGoodsReceipt->updateByPk($goods_receipt_id,array('grand_total'=>$goods_receipt_grand_total,'warehouse_id'=>$warehouse_id));*/


            $jsonData['status'] = 'success';
            echo CJSON::encode($jsonData);
        } else {

            $error = CJSON::encode($qty_error);
            if ($error != '[]')
                echo $error;
        }
    }
}
