<?php

$cs = Yii::app()->getClientScript();
$cs->registerScript("Invoiceposted", "function Invoiceposted(invoice_id,invoice_no) {
    jConfirm('Confirm Posting  of Production Order- '+invoice_no+' ?', 'Confirmation Dialog', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data' :{'id':invoice_id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/Posting/PostProductionOrder') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Production Order Posted!');
                            reloadTable('#tble_order_material');
                        }else{
                            $.each(data, function(key, val) {
                                t8.error(val);
                            });
                        }
                    },
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();
                    }
                });
            }
        });
};", CClientScript::POS_HEAD);

?>
<script>
    $(document).ready(function () {
        var table_id = "#tble_order_material";
        var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
            data.display_type = $("#display_type").val();
            return data;
        }).DataTable({
            scrollY: "645px",
            pageLength: 50,
            processing: true,columns: [
                { className: "nw sl col-max-1" }, // PRD No
                { className: "nw sl col-max-2" }, // Product#
                { className: "nw sl col-max-4" }, // Description
                { className: "nw sl col-max-1 text-right" }, // Quantity
                { className: "nw sl col-max-2" },  // PRD Date
                { className: "nw sl col-max-2" },  // End Date
                { className: "nw sl col-max-2" },  // Status
                
            ],
            ajax: {
                url: "<?php echo Yii::app()->createUrl('assembly/production/getorder') ?>",
                type: "POST",
                cache: false,
            },
            serverSide: true,
            fixedColumns: true,
            processing: true,
            "order": [[0, "DESC"]],
            "fnCreatedRow": function (nRow, aData, iDataIndex) {
                $(nRow).addClass("context-menu");
            },
            "fnRowCallback": function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
                AddContextMenu(nRow, aData);
                if (aData[7].posted == "Y") {
                    $("td", nRow).addClass("bg-success");
                }
            }
        });
    });

    function AddContextMenu(row, datas) {
        console.log(datas);
        
        var print_permission = <?php echo (Yii::app()->user->havePermissionOn['prod_po_print']) ? '1' : '0'; ?>;
        var edit_flag = datas[7].edit_flag;
        var invoice_posted = datas[7].posted;
        var have_service_item = datas[7].have_service_item;
        var po_status		=	datas[6];
        $(row).contextMenu({
            selector: 'td',
            items: {
                <?php if (isset(Yii::app()->user->havePermissionOn['prod_po_edit_new']) || Yii::app()->user->authorised_user == 1) { ?>
                    "edit": {
                        name: "Edit",
                        icon: "edit",
                        accesskey: "e",
                        callback: function () {
                            loadPopupModal("assembly/production/CreatePO&id=" + datas[7].id, datas[7].code, "lg");
                        },
                        disabled: function (key, opt) {
                            return edit_flag != 'Y';
                        }
                    },
                <?php } ?>

                "print": {
                    name: "Print",
                    icon: "fa-print",
                    accesskey: "p",
                    disabled: function () {
                        return print_permission != 1;
                    },
                    callback: function () {
                        var url = $('#liveSite').val() + "index.php?r=assembly/production/PrintProductionPOPDF&id=" + datas[7].id;
                        window.open(url);
                    }
                },
                "Auto": {
                    name: "Auto Production",
                    icon: "fa-tag",
                    accesskey: "e",
                    callback: function () {
                        // loadPopupModal("assembly/autoproduction/createautoproductionorder&id=" + datas[5].id, "Auto Production", "lg");
                        loadPopupModal("assembly/autoproduction/createautoproductionorder&id=" + datas[7].id + '&frm=PO', "Auto Production - " + datas[1], "lg");
                    },
                    disabled: function (key, opt) {
                        // this references the trigger element
                        if (po_status != 'Production Order') {
                            return !this.data('AutoDisabled');
                        }
                    }
                },
                <?php if (isset(Yii::app()->user->havePermissionOn['prod_po_convert']) || Yii::app()->user->authorised_user == 1) { ?>
                    "issue_material": {
                        name: "Issue Material",
                        icon: "fa-cubes",
                        accesskey: "i",
                        callback: function () {
                            loadPopupModal("issues/Create&frm=PR&po_id=" + datas[7].id, "Issue Material - " + datas[7].code, "xl");
                        },
                        disabled: function () {
                            return invoice_posted == 'Y';
                        }
                    },
                <?php } ?>
                <?php if (isset(Yii::app()->user->havePermissionOn['prod_po_convert']) || Yii::app()->user->authorised_user == 1) { ?>
                    "receive_material": {
                        name: "Receive Material",
                        icon: "fa-inbox",
                        accesskey: "r",
                        callback: function () {
                            console.log(datas);
                            loadPopupModal("receipts/create&frm=PRO&po_id=" + datas[7].id, "Receive Material - " + datas[7].code, "xl");
                        },
                        disabled: function () {
                            return invoice_posted == 'Y';
                        }
                    }
                <?php } ?>
            }
        });
    }
</script>



<section class="panel">

    <header class="panel-heading clearfix panel-theame">

        <!-- <i class="material-icons">list</i> -->
        Production Orders

        <div class="pull-right">

            <?php
            //here auto production from bill of material commented by mereena on 27/06/2024 
            if (isset(Yii::app()->user->havePermissionOn['prod_po_add']) || Yii::app()->user->authorised_user == 1) { ?>

                <a class="ad-btn"  id="add_popup"
                onclick="loadPopupModal('assembly/production/createPO','Add New Production Order','xl')" title="Add">
                <svg width="30" height="30" viewBox="0 0 24 24" fill="none"
                xmlns="http://www.w3.org/2000/svg" class="pluss-ad">
                <circle cx="12" cy="12" r="11" stroke="white" stroke-width="2" fill="none" />
                <line x1="12" y1="7" x2="12" y2="17" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                <line x1="7" y1="12" x2="17" y2="12" stroke="#5db5a4" stroke-width="2" stroke-linecap="round"/>
                </svg>
                </a>
            <?php } ?>
        </div>

    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tble_order_material">
                <thead>
                    <tr>

                        <th>PRD No.</th>

                        <th>Product#</th>

                        <th>Description</th>

                        <th>Quantity</th>

                        <th>PRD Date</th>

                        <th>End Date</th>

                        <th>Status</th>

                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>