<?php

/**
 * This is the model class for table "{{production_order}}".
 *
 * The followings are the available columns in table '{{production_order}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property string $productionorder_date
 * @property string $notes
 * @property string $terms_and_conditions
 * @property string $remarks
 * @property string $isActive
 * @property integer $product_id
 * @property string $description
 * @property integer $quantity
 * @property string $reference
 */
class ProductionOrder extends CActiveRecord {

    public $project_name_in_productionorder;
    public $connected_file_in_productionorder;
    public $customer_name;
    public $selectedproductionorder_name;
    public $unit_name;
    public $available_quantity;
        
    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{production_order}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('productionorder_date,end_date,product_id, description, quantity', 'required'),
            array('crm_user_id,billofmaterial_id, file_id, product_id,project,connected_file,customer_id,unit,variance', 'numerical', 'integerOnly' => true),
            array('quantity', 'numerical'),
            array('isActive,have_service_item,goods_issue_status', 'length', 'max' => 1),
            array('description, reference', 'length', 'max' => 255),
            array('notes,terms_and_conditions,remarks', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id,have_service_item,end_date,productionorder_date, notes, terms_and_conditions, remarks, isActive, product_id, description, quantity, reference,variance', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'project' => array(self::BELONGS_TO, 'MasProject', 'project'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'customerdetails' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'items' => array(self::HAS_MANY, 'ProductionOrderItem', 'production_order_id'),
            //'unitdetails' => array(self::BELONGS_TO, 'Unit', 'unit'),
            'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
              'customerDetails' => array(self::BELONGS_TO, 'Customer', 'customer_id'),

        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'file_id' => 'File',
            'productionorder_date' => 'Productionorder Date',
            'notes' => 'Notes',
            'terms_and_conditions' => 'Terms And Conditions',
            'remarks' => 'Remarks',
            'isActive' => 'Is Active',
            'product_id' => 'Product',
            'description' => 'Description',
            'quantity' => 'Quantity',
            'reference' => 'Reference',
            'customer_id' => 'Customer Name',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    /* public function search() {
      // @todo Please modify the following code to remove attributes that should not be searched.

      $criteria = new CDbCriteria;

      $criteria->compare('id', $this->id);
      $criteria->compare('crm_user_id', $this->crm_user_id);
      $criteria->compare('file_id', $this->file_id);
      $criteria->compare('productionorder_date', $this->productionorder_date, true);
      $criteria->compare('notes', $this->notes, true);
      $criteria->compare('terms_and_conditions', $this->terms_and_conditions, true);
      $criteria->compare('remarks', $this->remarks, true);
      $criteria->compare('isActive', $this->isActive, true);
      $criteria->compare('product_id', $this->product_id);
      $criteria->compare('description', $this->description, true);
      $criteria->compare('project', $this->project, true);
      $criteria->compare('end_date', $this->end_date, true);
      $criteria->compare('connected_file', $this->connected_file, true);
      $criteria->compare('customer_id', $this->customer_id, true);
      $criteria->compare('quantity', $this->quantity);
      $criteria->compare('reference', $this->reference, true);

      return new CActiveDataProvider($this, array(
      'criteria' => $criteria,
      'sort' => array(
      'defaultOrder' => 't.id DESC, t.file_id DESC ,t.productionorder_date DESC',
      ),
      'pagination' => array('pageSize' => 5)
      ));
      } */
    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('productionorder_search')) : $searchterm;
        $criteria->with = array('file', 'file.company', 'product');
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //((int) Yii::app()->session['company_id'] > 0 && !isset($_GET['month'])) ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        product.part_number like "%' . $searchterm . '%" OR 
                                        product.description like "%' . $searchterm . '%" OR
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }
        if (empty($searchterm))
        $criteria->addCondition('file.current_process_status="PR_O"', 'AND');
        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC ,t.productionorder_date DESC',
            ),
           'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ProductionOrder the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    public function getPOStatus() {
        $status = 'Production Order';        
        $order_id = (int)$this->id;
        $modelIssue = new InventoryGoodsIssue();
        $modelIssue = $modelIssue->find(['condition'=>'issue_type ="PR" AND production_order_id='.(int)$order_id]);
        
        
        $modelReceipt = new InventoryGoodsReceipt();
        $modelReceipt = $modelReceipt->find(['condition'=>'(receipt_type ="PR" OR receipt_type ="PRO") AND reference_id='.(int)$order_id]);
        
        
        
        $sqlReceipt = 'SELECT SUM(picked_qty) AS received_qty FROM {{inventory_goods_receipt_item}} GRI LEFT JOIN {{inventory_goods_receipt}} GR ON GR.id=GRI.goods_receipt_id WHERE GR.reference_id ='.(int)$order_id.' AND GRI.product_id ='.(int)$this->product_id.' AND stock_updated="Y" GROUP BY GR.reference_id';
        $received_qty= Yii::app()->db->createCommand($sqlReceipt)->queryScalar();
       
        if($this->quantity<=$received_qty){
            $status = 'Production Completed';
        }
        else if(!empty($modelReceipt)){
            
            if($modelReceipt->stock_updated=='N'){
                $status = 'Receipt Pickup';
            }
            else{
                $status = 'Quality Check';
            }
            
        }
        else if(!empty($modelIssue)){
            
            if($modelIssue->stock_updated=='N'){
                $status = 'Issue Pickup';
            }
            else{
                $status = 'Issued';
            }
            
        }
        
        else if(!empty($modelIssue)){
            
            if($modelIssue->stock_updated=='N'){
                $status = 'Pickup';
            }
            else{
                $status = 'Issued';
            }
            
        }
        
        return $status;
    }
}
