<?php

/**
 * This is the model class for table "{{production_billofmaterial}}".
 *
 * The followings are the available columns in table '{{production_billofmaterial}}':
 * @property integer $id
 * @property integer $crm_user_id
 * @property integer $file_id
 * @property integer $product_id
 * @property string $bm_date
 * @property string $isActive
 */
class ProductionBillofmaterial extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public $unit_name;
    public $product_name;

    public function tableName() {
        return '{{production_billofmaterial}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('description,product_id', 'required'),
            array('crm_user_id, file_id, product_id,customer_id', 'numerical', 'integerOnly' => true),
            array('isActive', 'length', 'max' => 1),
            //array('notes,terms_and_conditions,remarks', 'length', 'max' => 5000),
            array('quantity', 'numerical'),
            array('description,unit,part_number', 'length', 'max' => 255),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, crm_user_id, part_number,file_id,customer_id, product_id, bm_date, isActive', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'product' => array(self::BELONGS_TO, 'Store', 'product_id'),
            'file' => array(self::BELONGS_TO, 'MasterFile', 'file_id'),
            'items' => array(self::HAS_MANY, 'ProductionBillofmaterialItem', 'production_billofmaterial_id'),
            //'unitdetails' => array(self::BELONGS_TO, 'Unit', 'unit'),
             'unitdetails' => array(self::BELONGS_TO, 'UnitOfMeasurement', 'unit'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'crm_user_id' => 'Crm User',
            'file_id' => 'File',
            'product_id' => 'Product',
            'bm_date' => 'Bm Date',
            'isActive' => 'Is Active',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search($searchterm = null) {
        $criteria = new CDbCriteria;
        $searchterm = empty($searchterm) ? trim(Yii::app()->request->getParam('bill_search')) : $searchterm;
        $criteria->with = array('file', 'file.company','product');
        /*$criteria->addCondition('       file.own_company_id=' . Yii::app()->user->master_user_company_id . ' AND 
                                        file.own_branch_id=' . Yii::app()->user->master_user_branch_id, 'AND');*/
        //((int) Yii::app()->session['company_id'] > 0 && !isset($_GET['month'])) ? $criteria->addCondition('t.company_id=' . Yii::app()->session['company_id'], 'AND') : '';
        if (!empty($searchterm)) {
            $criteria->addCondition('   t.id like "%' . $searchterm . '%" OR 
                                        product.part_number like "%' . $searchterm . '%" OR 
                                        product.description like "%' . $searchterm . '%" OR
                                        t.file_id like "%' . $searchterm . '%" OR 
                                        company.company_name like "%' . $searchterm . '%" OR 
                                        file.file_title like "%' . $searchterm . '%"', 'AND');
        }

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
            'sort' => array(
                'defaultOrder' => 't.id DESC, t.file_id DESC',
            ),
           'pagination' => (Yii::app()->controller->id != "export") ? array('pageSize' => 15) : false,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return ProductionBillofmaterial the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }
    
    public function getProductName()
    {
        return $this->part_number . ' | ' . $this->description;
    }
    
     public static function getCustomers()
    {
        $condition = '1=1';
        $model = self::model()->with('customer')->findAll(array('condition' => $condition, 'order' => 'customer.customer_name'));
        return CHtml::listData($model, 'customer_id', 'customer.customer_name');
    }
    public static function getProducts()
    {
        $condition = '1=1';
        $model = self::model()->with('product')->findAll(array('condition' => $condition, 'order' => 'product.part_number'));
        return CHtml::listData($model, 'product_id', 'productName');
    }

}
