<style>
    .contact-cards-container {
        display: grid;
        grid-template-columns: repeat(1, 1fr);
        gap:0px;
    }

    .card {
        background-color: #ffffff;
        border-left: 5px solid green;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        padding: 14px;
        transition: transform 0.2s ease;
        position: relative;
    }

    .card:hover {
        transform: translateY(-3px);
    }

    .card-content {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .card-title {
        background: linear-gradient(135deg, #2c3e50, #5db5a4);
        color: #fff;
        font-weight: 600;
        font-size: 13px;
        padding: 0.75rem 1rem;
        border-radius: 10px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-count {
        color: #ffffff;
        font-size: 13px;
        font-weight: 500;
        text-align: center;
    }

    .card-info {
        display:block;
        justify-content: space-between;
        font-size: 14px;
        color: #555;
    }

    .card-info span {
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .card-info i {
       color: #529b92;
    }
    .link-color
    {
        color: #5bb1a1;
    }

</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="contact-cards-container">
    
    <?php 
    foreach($arr_news_details as $eachNews){
        /*echo '<pre>';
        print_r($eachNews);exit;*/
        if(!empty($eachNews['publisher'])){
        ?>
<div class="card">
    <div class="card-content">
        <div class="card-title">
            <span><i class="fas fa-bullseye"></i> <?php echo $eachNews['publisher'];?></span>
            <span class="card-count"></span>
        </div>
        <div class="card-info">
            <span><i class="fas fa-calendar-alt"></i> <?php echo date('d/m/Y', strtotime($eachNews['published_date'])); ?></span>
            <span><i class="fas fa-newspaper"></i>  <?php echo $eachNews['title']; ?></span>
            <span><i class="fas fa-link "></i> <a href="<?php echo $eachNews['url']; ?>" class="link-color" target="_blank"><?php echo $eachNews['url']; ?></a></span>
        </div>
    </div>
</div>
        <?php
        }
        else{
            ?>
            <div class="card">
                <div class="card-content">
                    <div class="text-center">
                        <span><i class="fas fa-bullseye"></i>  <b>No News Available </b></span>
                        <span class="card-count"></span>
                    </div>
                </div>
            </div>
            <?php
        }
        
    }
    ?>
   

   
</div>
