<style>
    .contact-cards-container {
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        gap: 12px;
    }

    .card {
        background-color: #ffffff;
        border-left: 5px solid green;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        padding: 14px;
        transition: transform 0.2s ease;
        position: relative;
    }

    .card:hover {
        transform: translateY(-3px);
    }

    .card-content {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .card-title {
        background: linear-gradient(135deg, #2c3e50, #5db5a4);
        color: #fff;
        font-weight: 600;
        font-size: 13px;
        padding: 0.75rem 1rem;
        border-radius: 10px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-count {
        color: #ffffff;
        font-size: 13px;
        font-weight: 500;
        text-align: center;
    }

    .card-info {
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        color: #555;
    }

    .card-info span {
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .card-info i {
        color: #888;
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="contact-cards-container">

    <div class="card">
        <?php
        $lead_count = Lead::model()->with('file')->count(array('condition' => ' t.customer_id=' . $customerId . ' AND current_process_status="L"'));
        $lead_last = Lead::model()->with('file')->find(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="L"', 'order' => 't.id DESC'));
        $lead_last_date = !empty($lead_last) ? date('d/m/Y', strtotime($lead_last->enq_date)) : ""; 
        ?>
        <div class="card-content">
            <div class="card-title">
                <span><i class="fas fa-bullseye"></i> Leads</span>
                <span class="card-count"><?php echo $lead_count ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $lead_last_date ?></span>
                <span></span>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-content">
            <?php
            $quote_count = Quotes::model()->with('file')->count(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="Q"'));
            $quoteModel = Quotes::model()->with('file')->find(array('select'=>'MAX(qtn_start_date) AS qtn_start_date','condition' => 't.customer_id=' . $customerId . ' AND current_process_status="Q"'));
            $quote_last_date = date('d/m/Y', strtotime($quoteModel->qtn_start_date));
            $SQL = "SELECT SUM(quantity) AS quantity, SUM(grand_total * Q.exchange_rate) AS amount   FROM `erp_quotes_item` 
                    INNER JOIN erp_quotes Q ON Q.id = quotes_id 
                    INNER JOIN erp_master_file f ON (f.id = Q.file_id) 
                    WHERE f.current_process_status = 'Q' AND Q.customer_id=" . $customerId;
            $arr_quotes_details = Yii::app()->db->createCommand($SQL)->queryRow();
            ?>
            <div class="card-title">
                <span><i class="fas fa-clipboard-list"></i> Quotes</span>
                <span class="card-count"><?php echo $quote_count; ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $quote_last_date; ?></span>
                <span><i class=""></i> <?php echo number_format($arr_quotes_details['amount'], 2); ?></span>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-content">
            <?php
            $order_count = Order::model()->with('file')->count(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="O"'));
            $orderModel = Order::model()->with('file')->find(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="O"'));
            $order_last_date = isset($orderModel->order_date)?date('d/m/Y', strtotime($orderModel->order_date)):"";
            $SQL = "SELECT SUM(quantity) AS quantity, SUM(grand_total * O.exchange_rate) AS amount FROM `erp_order_item` 
                    INNER JOIN erp_order O ON O.id = order_id 
                    INNER JOIN erp_master_file f ON (f.id = O.file_id) 
                    WHERE f.current_process_status = 'O' AND O.customer_id =" . $customerId;
            $arr_order_details = Yii::app()->db->createCommand($SQL)->queryRow();
            ?>
            <div class="card-title">
                <span><i class="fas fa-shopping-cart"></i> Order</span>
                <span class="card-count"><?php echo $order_count; ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $order_last_date ?></span>
                <span><i class=""></i> <?php echo number_format($arr_order_details['amount'], 2); ?></span>
            </div>
        </div>
    </div>
    
    <?php
            $delivery_count = DeliveryNote::model()->with('file')->count(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="D"'));
            $deliveryModel = DeliveryNote::model()->with('file')->find(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="D"'));
            $delivery_last_date = date('d/m/Y', strtotime($deliveryModel->delivery_date));
            $SQL = "SELECT SUM(quantity) AS quantity FROM `erp_delivery_item` 
                    INNER JOIN erp_delivery_note D ON D.id = delivery_note_id  
                    INNER JOIN erp_master_file f ON (f.id = D.file_id) 
                    WHERE f.current_process_status = 'D' AND D.customer_id =" . $customerId;
            $arr_delivery_details = Yii::app()->db->createCommand($SQL)->queryRow();
            ?>

    <div class="card">
        <div class="card-content">
            <div class="card-title">
                <span><i class="fas fa-truck"></i> Delivery</span>
                <span class="card-count"><?php echo $delivery_count; ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $delivery_last_date ?></span>
            </div>
        </div>
    </div>
 <?php
            $invoice_count = Invoice::model()->with('file')->count(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="I"'));
            $invoiceModel = Invoice::model()->with('file')->find(array('condition' => 't.customer_id=' . $customerId . ' AND current_process_status="I"'));
            $invoice_last_date = date('d/m/Y', strtotime($deliveryModel->delivery_date));
            $SQL = "SELECT SUM(quantity) AS quantity, SUM(grand_total * I.exchange_rate) AS amount FROM `erp_invoice_item` 
                    INNER JOIN erp_invoice I ON I.id = invoice_id  
                    INNER JOIN erp_master_file f ON (f.id = I.file_id) 
                    WHERE f.current_process_status = 'I' AND I.customer_id =" . $customerId;
            $arr_invoice_details = Yii::app()->db->createCommand($SQL)->queryRow();
            ?>
    <div class="card">
        <div class="card-content">
            <div class="card-title">
                <span><i class="fas fa-file-invoice-dollar"></i> Invoice</span>
                <span class="card-count"><?php echo $invoice_count;?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $invoice_last_date ?></span>
                <span><i class=""></i> <?php echo number_format($arr_invoice_details['amount'],2); ?></span>
            </div>
        </div>
    </div>
</div>
