<style>
    .contact-cards-container {
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        gap: 12px;
    }

    .card {
        background-color: #ffffff;
        border-left: 5px solid green;
        border-radius: 10px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
        padding: 14px;
        transition: transform 0.2s ease;
        position: relative;
    }

    .card:hover {
        transform: translateY(-3px);
    }

    .card-content {
        display: flex;
        flex-direction: column;
        gap: 8px;
    }

    .card-title {
        background: linear-gradient(135deg, #2c3e50, #5db5a4);
        color: #fff;
        font-weight: 600;
        font-size: 13px;
        padding: 0.75rem 1rem;
        border-radius: 10px;
        display: flex;
        justify-content: space-between;
        align-items: center;
    }

    .card-count {
        color: #ffffff;
        font-size: 13px;
        font-weight: 500;
        text-align: center;
    }

    .card-info {
        display: flex;
        justify-content: space-between;
        font-size: 14px;
        color: #555;
    }

    .card-info span {
        display: flex;
        align-items: center;
        gap: 6px;
    }

    .card-info i {
        color: #888;
    }
</style>

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="contact-cards-container">

    <div class="card">
        <?php
         
        $lead_count = PurchasingOrder::model()->with('file')->count(array('condition' => ' t.vendor_id=' . $vendorId . ' AND file.current_process_status = "P_O"'));
        $lead_last = PurchasingOrder::model()->with('file')->find(array('condition' => 'vendor_id=' . $vendorId.' AND file.current_process_status = "P_O"', 'order' => 't.id DESC','order'=>'order_date DESC'));
        $lead_last_date = !empty($lead_last) ? date('d/m/Y', strtotime($lead_last->order_date)) : "";
         $SQL = "SELECT Q.stock_grand_total AS amount FROM `erp_purchasing_order_stock_item` 
                    INNER JOIN erp_purchasing_order Q ON Q.id = purchasing_order_id 
                    INNER JOIN erp_master_file f ON (f.id = Q.file_id) 
                    WHERE  ((f.current_process_status = 'P_O' OR Q.convert_status = 'Y')  AND completed!='C') AND  Q.vendor_id=" . $vendorId;
            $arr_po_details = Yii::app()->db->createCommand($SQL)->queryRow();
        ?>
        <div class="card-content">
            <div class="card-title">
                <span><i class="fas fa-bullseye"></i> Orders</span>
                <span class="card-count"><?php echo $lead_count ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $lead_last_date ?></span>
                <span>  <?php echo number_format($arr_po_details['amount'], 2); ?></span>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-content">
            <?php
            $quote_count = PurchasingMaterialreceipt::model()->with('file','vendor_details')->count(array('condition' => 't.vendor_id=' . $vendorId . ' AND file.current_process_status = "M_R" '));
            $quoteModel = PurchasingMaterialreceipt::model()->with('file','vendor_details')->find(array('condition' => 'vendor_id=' . $vendorId.' AND file.current_process_status = "M_R" ','order'=>'mrv_receipt_date DESC'));
            $quote_last_date = !empty($quoteModel) ? date('d/m/Y', strtotime($quoteModel->mrv_receipt_date)) : "";
            $SQL = "SELECT SUM(quantity) AS quantity, SUM(quantity * rate) AS amount FROM `erp_purchasing_material_receipt_item` 
                    INNER JOIN erp_purchasing_material_receipt Q ON Q.id = purchasing_materialreceipt_id 
                    INNER JOIN erp_master_file f ON (f.id = Q.file_id) 
                    WHERE f.current_process_status = 'M_R'  AND Q.vendor_id=" . $vendorId;
            $arr_quotes_details = Yii::app()->db->createCommand($SQL)->queryRow();
            ?>
            <div class="card-title">
                <span><i class="fas fa-clipboard-list"></i> Material Receipt</span>
                <span class="card-count"><?php echo $quote_count; ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $quote_last_date; ?></span>
                <span>  <?php //echo number_format($arr_quotes_details['amount'], 2); ?></span>
            </div>
        </div>
    </div>

    <div class="card">
        <div class="card-content">
            <?php
            $order_count = PurchasingMaterialreceipt::model()->with('purchaseorder')->count(array('condition' => 't.vendor_id=' . $vendorId . ' AND  (qcchecked="N" OR is_convertable="Y") and purchaseorder.service_invoice!="Y"'));
            $orderModel = PurchasingMaterialreceipt::model()->with('purchaseorder')->find(array('condition' => 't.vendor_id=' . $vendorId.' AND  (qcchecked="N" OR is_convertable="Y") and purchaseorder.service_invoice!="Y"','order'=>'mrv_receipt_date DESC'));
                        $order_last_date = !empty($orderModel) ? date('d/m/Y', strtotime($orderModel->mrv_receipt_date)) : "";
             $SQL = "SELECT SUM(quantity) AS quantity, SUM(quantity * rate) AS amount FROM `erp_purchasing_material_receipt_item` 
                    INNER JOIN erp_purchasing_material_receipt Q ON Q.id = purchasing_materialreceipt_id 
                    INNER JOIN erp_purchasing_order purchaseorder ON purchaseorder.id = Q.po_id 
                    INNER JOIN erp_master_file f ON (f.id = Q.file_id) 
                    WHERE  (qcchecked='N' OR is_convertable='Y') and purchaseorder.service_invoice!='Y'AND  Q.vendor_id=" . $vendorId;
            $arr_order_details = Yii::app()->db->createCommand($SQL)->queryRow();
            ?>
            <div class="card-title">
                <span><i class="fas fa-shopping-cart"></i> Quality Check</span>
                <span class="card-count"><?php echo $order_count; ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $order_last_date ?></span>
                <span>  <?php //echo number_format($arr_order_details['amount'], 2); ?></span>
            </div>
        </div>
    </div>

    <!-- <div class="card">
        <div class="card-content">
            <div class="card-title">
                <span><i class="fas fa-truck"></i> Delivery</span>
                <span class="card-count">0</span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> 06/05/2025</span>
                <span><i class="fas fa-dollar-sign"></i> -</span>
            </div>
        </div>
    </div> -->

    <!-- <div class="card">
        <div class="card-content">
            <div class="card-title">
                <span><i class="fas fa-file-invoice-dollar"></i> Invoice</span>
                <span class="card-count">0</span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> 06/05/2025</span>
                <span><i class="fas fa-dollar-sign"></i> -</span>
            </div>
        </div>
    </div> -->
    <div class="card">
        <div class="card-content">
            <?php
            $invoice_count = PurchasingInvoice::model()->with('file')->count(array('condition' => 't.vendor_id=' . $vendorId . ' '));
            $invoiceModel = PurchasingInvoice::model()->find(array('condition' => 'vendor_id=' . $vendorId,'order'=>'invoice_date DESC'));
            $invoicelast_date = ($invoiceModel->invoice_date!="0000-00-00 00:00:00")?date('d/m/Y', strtotime($invoiceModel->invoice_date)):"";
            $SQL = "SELECT SUM(quantity) AS quantity, SUM(net_amount+tax_amount) AS amount FROM `erp_purchasinginvoice_item` 
                    INNER JOIN erp_purchasinginvoice Q ON Q.id = purchasing_invoice_id  
                    INNER JOIN erp_master_file f ON (f.id = Q.file_id) 
                    WHERE Q.isActive='Y' AND  Q.vendor_id=" . $vendorId;
            $arr_invoice_details = Yii::app()->db->createCommand($SQL)->queryRow();
            ?>
            <div class="card-title">
                <span><i class="fas fa-shopping-cart"></i> Invoices</span>
                <span class="card-count"><?php echo $invoice_count; ?></span>
            </div>
            <div class="card-info">
                <span><i class="fas fa-calendar-alt"></i> <?php echo $invoicelast_date ?></span>
                <span>  <?php echo number_format($arr_invoice_details['amount'], 2); ?></span>
            </div>
        </div>
</div>
</div>
