<?php
// $from_date,$to_date,$customer_id,$from,$vendor_id PARAMETERS PASSING

$modelMasCurrency =  new MasCurrency();


$modelAccSubledger = new AccSubledger();
$modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
$modAccSubledgerType = new AccSubledgerType();

$ledger = 0;
$subledger_id = 0;
if ($from == 'sales') {
    $ledger = $modelAccSystemAccountsMapping->getSystemdefault('debtors');  //136;
    $subledger_type_id = $modAccSubledgerType->getIdFromType('C');
    $subledger_id = $modelAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $customer_id); //4;
}
if ($from == 'purchase') {
    $ledger = $modelAccSystemAccountsMapping->getSystemdefault('creditors');  //204;
    $subledger_type_id = $modAccSubledgerType->getIdFromType('V');
    $subledger_id = $modelAccSubledger->getsubledgerFromledgerandtype($subledger_type_id, $vendor_id); //163;
}


$dates_array = array(

    '0_to_30' => array('from' => date('Y-m-d', strtotime($to_date . ' -30 days')), 'to' => $to_date),

    '31_to_60' => array('from' => date('Y-m-d', strtotime($to_date . ' -60 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -31 days'))),

    '61_to_90' => array('from' => date('Y-m-d', strtotime($to_date . ' -90 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -61 days'))),

    '91_to_120' => array('from' => date('Y-m-d', strtotime($to_date . ' -120 days')), 'to' => date('Y-m-d', strtotime($to_date . ' -91 days'))),

    'greaterthan_120' => array('from' => '2010-01-01', 'to' => date('Y-m-d', strtotime($to_date . ' -121 days'))),

);
$modelAccLedger = new AccLedger;

$baseCurrency =   $modelAccLedger->baseCurrencycode();


foreach ($dates_array as $key => $each_date_pair) {

    // ------------------------create- or-update- view- view_acc_ageing_--------------------------------------------------------------------------------------------

    $condition = 'V.is_posted =  "Y"';

    if ($subledger_id > 0) {

        $condition .= " AND  VI.subledger_id = '" . (int) $subledger_id . "'";
    }



    $condition .= " AND  VI.ledger_id = '" . (int) $ledger . "'";



    //$condition .= ' AND V.voucher_date <="' . $from_date . '"';



    $condition .= ' AND V.voucher_date BETWEEN "' . $each_date_pair['from'] . '" AND "' . $each_date_pair['to'] . '"';


/* 
    $query = 'CREATE OR REPLACE VIEW {{view_acc_ageing_' . $key . '}} AS SELECT

    VI.ledger_id AS ledger_id,

    VI.subledger_id AS subledger_id,

    IFNULL(S.subledger_name, "No Subledger") AS subledger,

    V.id AS voucher_id,

    V.voucher_date AS voucher_date,

    V.due_date AS due_date,

    V.reference_no AS reference_no,

    VI.narration AS narration,

    VI.id AS voucher_item_id,

    CONCAT(VT.code,"/",V.voucher_no) AS voucher_no,

    ROUND((VI.amount*VI.exchange_rate), 4) AS total_amount,

    IFNULL(ROUND( SUM(AI.amount), 4), 0) AS allocated,   

    ROUND((VI.amount*VI.exchange_rate), 4) + IFNULL(ROUND( SUM(AI.amount), 4), 0)  AS amount    

    FROM {{acc_voucher_items}} VI 

    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id

    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id

    LEFT JOIN {{acc_subledger}} S ON S.id = VI.subledger_id

    LEFT JOIN {{acc_voucher_type}} VT ON VT.id=V.voucher_type

    WHERE  ' . $condition . '  GROUP BY VI.id, VI.subledger_id';

    Yii::app()->db->createCommand($query)->execute(); */


    $query = 'CREATE OR REPLACE VIEW view_outstanding_' . $key . ' AS SELECT sum(VI.amount)   AS amount
            FROM `erp_acc_voucher_items` VI 
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id
            WHERE ' . $condition . ' ';
    Yii::app()->db->createCommand($query)->execute();
}


$sql_acc = "SELECT
    IFNULL((SELECT SUM(amount) FROM view_outstanding_0_to_30 ), 0) AS amt_0_to_30,
    IFNULL((SELECT SUM(amount) FROM view_outstanding_31_to_60 ), 0) AS amt_31_to_60,
    IFNULL((SELECT SUM(amount) FROM view_outstanding_61_to_90 ), 0) AS amt_61_to_90,
    IFNULL((SELECT SUM(amount) FROM view_outstanding_91_to_120 ), 0) AS amt_91_to_120,
    IFNULL((SELECT SUM(amount) FROM view_outstanding_greaterthan_120 ), 0) AS amt_above_120,
    (
        IFNULL((SELECT SUM(amount) FROM view_outstanding_0_to_30 ), 0) +
        IFNULL((SELECT SUM(amount) FROM view_outstanding_31_to_60 ), 0) +
        IFNULL((SELECT SUM(amount) FROM view_outstanding_61_to_90 ), 0) +
        IFNULL((SELECT SUM(amount) FROM view_outstanding_91_to_120 ), 0) +
        IFNULL((SELECT SUM(amount) FROM view_outstanding_greaterthan_120 ), 0)
    ) AS amount_total";

$report_result = Yii::app()->db->createCommand($sql_acc)->queryRow();

$amt_0_to_30 = abs($report_result['amt_0_to_30']);
$amt_31_to_60 = abs($report_result['amt_31_to_60']);
$amt_61_to_90 = abs($report_result['amt_61_to_90']);
$amt_91_to_120 = abs($report_result['amt_91_to_120']);
$amt_above_120 = abs($report_result['amt_above_120']);

$amt_total = abs($report_result['amount_total']);

?>


<div class="card border-0  shadow-sm rounded-4 card-hover" style="margin-bottom: 10px;">

    <div class="card-title">
        <span><i class="fas fa-bullseye"></i> Outstanding</span>
        <?php // echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amt_total). " " . $baseCurrency;;  
        ?>
        <span class="card-count"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amt_total);  ?></span>
    </div>
    <div class="card-body px-3 py-3">
        <!--   <p class="mb-2 text-secondary small" style="font-size: 13px;"><strong>Description:</strong>
            xxxxx
        </p> -->



        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;display: flex; justify-content: space-between; align-items: center;">
            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-file-invoice-dollar"></i> 0-30
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"> <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amt_0_to_30); ?></span>

        </div>


        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;display: flex; justify-content: space-between; align-items: center;">

            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-file-invoice-dollar"></i> 31-60
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat($amt_31_to_60);  ?></span>

        </div>

        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;display: flex; justify-content: space-between; align-items: center;">


            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-file-invoice-dollar"></i> 61-90
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amt_61_to_90); ?></span>

        </div>

        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;display: flex; justify-content: space-between; align-items: center;">


            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-file-invoice-dollar"></i> 91-120
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amt_91_to_120); ?></span>

        </div>

        <div class="mt-1 d-flex justify-content-between align-items-center" style="font-size: 13px;display: flex; justify-content: space-between; align-items: center;">

            <div class="text-muted d-flex align-items-center" style="gap: 4px;">
                <i class="fas fa-file-invoice-dollar"></i> > 120
            </div>
            <span class="fw-bold" style="color: #57a699 !important;"> <?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($amt_above_120); ?></span>
        </div>

    </div>
</div>