<?php

class SearchController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index','PurchaseIndex','SearchCustomer','GetCustomerDetails','SearchVendor','GetVendorDetails','InfoIndex','FinanceIndex','GetPurchaseInvoiceItems','InventoryIndex',
                    'GetGoogleBusinessProfile','GetRelevantNews','GetEmployeeProfiles','analyzeWithGrok'
                    
                ),
                'expression' => '$user->isMember()', 
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
  
    public function actionIndex() 
    {
        
        
        $this->render('index_ai_dashboard');
        
        
        //$this->render('index_ai_dashboard');
    }

    
    public function actionGetGoogleBusinessProfile()
    {
        $apiKey         = Yii::app()->params['googleMapKey'];
        $companyName    = Yii::app()->request->getParam('company_name');
        
        //$companyName            = 'Sage Media Group'; 
        //$apiKey = 'AIzaSyDbV_5rnOPx03_vYfQk3-gszN72MCtzKnc';
        $gbpLink = '';
        try {
            
            //$placeId = 'ChIJyWwQKSm8MioRhkkq-ipop0o';
            $placeId = '';
            if ($gbpLink) {
                $placeId = $this->extractPlaceId($gbpLink);
            }
            if (!$placeId) {
                $url = 'https://maps.googleapis.com/maps/api/place/findplacefromtext/json?' . http_build_query([
                    'input' => $companyName,
                    'inputtype' => 'textquery',
                    'fields' => 'place_id,name,formatted_address',
                    'key' => $apiKey,
                ]);
               
                $response = $this->makeGetRequest($url);
    
                $data = json_decode($response, true);
                if (empty($data['candidates'])) {
                    return ['error' => 'No Google Business Profile found'];
                }
                $placeId = $data['candidates'][0]['place_id'];
            }

            $url = 'https://maps.googleapis.com/maps/api/place/details/json?' . http_build_query([
                'place_id' => $placeId,
                'fields' => 'name,formatted_address,formatted_phone_number,website,rating,user_ratings_total,opening_hours,reviews',
                'key' => $apiKey,
            ]);
             
            $response = $this->makeGetRequest($url);
            
                       /*  echo '<pre>';
            print_r($response);exit;*/
           
            $result = json_decode($response, true)['result'] ?? [];
            
           
            // echo '<pre>';
           // print_r($result);exit;
            if (empty($result)) {
                return ['error' => 'No Google Business Profile details found'];
            }
             $company_details = array( 
                'company_name' => $result['name'] ?? 'N/A',
                'address' => $result['formatted_address'] ?? 'N/A',
                'phone' => $result['formatted_phone_number'] ?? 'N/A',
                'website' => $result['website'] ?? 'N/A',
                'rating' => $result['rating'] ?? 'N/A',
                'total_reviews' => $result['user_ratings_total'] ?? 'N/A',
                'opening_hours' => $result['opening_hours']['weekday_text'] ?? 'N/A',
                'top_review' => !empty($result['reviews']) ? $result['reviews'][0]['text'] : 'N/A',
                'place_id' => $placeId,
            );
            
            /*echo '<pre>';
            print_r($company_details);*/
            
            $arr_news_details = $this->GetRelevantNews($companyName);
            
            $arr_employee_details = $this->GetEmployeeProfiles($companyName);
            //echo '<pre>';
            //print_r($arr_employee_details);
            
            $this->render('google_search', array('company_details'=>$company_details,'arr_news_details'=>$arr_news_details,'arr_employee_details'=>$arr_employee_details));
            
            
            //$returndata['company'] = $company_details;
            //echo json_encode($returndata);
           
        } catch (Exception $e) {
            return ['error' => 'Failed to fetch Google Business Profile: ' . $e->getMessage()];
        }
    }
    
    private function extractPlaceId($gbpLink)
    {
        try {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $gbpLink);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 5);
            $response = curl_exec($ch);
            curl_close($ch);

            preg_match('/ChIJ[A-Za-z0-9_-]+/', $response, $matches);
            return !empty($matches) ? $matches[0] : null;
        } catch (Exception $e) {
            return null;
        }
    }
    
    function makeGetRequest($url)
    {
       $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        curl_setopt($ch, CURLOPT_USERAGENT, 'MyApp/1.0 (+https://example.com)');
        
        $response = curl_exec($ch);
        curl_close($ch);
        return $response;

    }

   function GetRelevantNews($companyName)
    {
        //$companyName            = 'Sage Media Group'; 
       $apiKey         = Yii::app()->params['newsApiKey'];
        
        //$apiKey = 'c11f4899db0c4311a478b0829a9c6003';
        try {
            $url = 'https://newsapi.org/v2/everything?' . http_build_query([
                'q' => $companyName,
                'sortBy' => 'publishedAt',
                'language' => 'en',
                'pageSize' => 5,
                'apiKey' => $apiKey,
            ]);
            $response = $this->makeGetRequest($url);
            //echo '<pre>';
            //print_r($response);
            $data = json_decode($response, true);

            if ($data['status'] !== 'ok') {
                return ['error' => 'NewsAPI error: ' . ($data['message'] ?? 'Unknown error')];
            }
            if (empty($data['articles'])) {
                return ['error' => "No news found for '$companyName'"];
            }

            $newsList = [];
            foreach ($data['articles'] as $article) {
                $newsList[] = [
                    'title' => $article['title'],
                    'publisher' => $article['source']['name'],
                    'published_date' => $article['publishedAt'],
                    'url' => $article['url'],
                ];
            }
            return $newsList;
        } catch (Exception $e) {
            return ['error' => 'Failed to fetch news: ' . $e->getMessage()];
        }
    }
    
    function GetEmployeeProfiles($companyName)
    {
        //$companyName            = 'Bluesky Technology Consultants FZE'; 
        //$apiKey = 'AIzaSyBmnCX_hj5vKKrQlAPR7c61eh1CTMvyBDA';
        $apiKey         = Yii::app()->params['googleApiKey'];
        $cseId          = Yii::app()->params['cseId'];
        //$cseId = '65f01e14a7a29419b';
        $website='';
        $maxResults=20;
        try {
            $query = "site:linkedin.com \"$companyName\"";
            $employees = [];
            $companyPages = [];
            $others = [];
            $start = 1;
             $employeeList = [];

            while (count($employees) + count($companyPages) + count($others) < $maxResults) {
                $url = 'https://www.googleapis.com/customsearch/v1?' . http_build_query([
                    'key' => $apiKey,
                    'cx' => $cseId,
                    'q' => $query,
                    'num' => min($maxResults, 10),
                    'start' => $start,
                ]);
                $response = $this->makeGetRequest($url);
                $data = json_decode($response, true);
                
                //echo '<pre>';
                //print_r($response);

                if (isset($data['error'])) {
                    return [
                        'employees' => ['error' => 'API error: ' . $data['error']['message']],
                        'company_pages' => ['error' => 'API error: ' . $data['error']['message']],
                        'others' => ['error' => 'API error: ' . $data['error']['message']],
                    ];
                }
                
                
                
                
                //echo '<pre>';
                //print_r($data['items']);
                
                if (empty($data['items'])) {
                    break;
                }
               
                foreach ($data['items'] as $item) {
                    $title = $item['title'] ?? '';
                    $snippet = $item['snippet'] ?? '';
                    $link = $item['link'] ?? '';

                    if (strpos($link, '/company/') !== false || strpos($link, '/products/') !== false || strpos($link, '/showcase/') !== false) {
                        $companyPages[] = [
                            'title' => $title,
                            'url' => $link,
                            'snippet' => $snippet,
                            'grok_validation' => ['is_employee' => false, 'reason' => 'Company page URL detected', 'confidence' => 100],
                        ];
                        continue;
                    }
                    
                    foreach ($item['pagemap']['metatags'] as $eachItemMetatags) {
                            //echo '<pre>';
                            //print_r($eachItemMetatags);exit;
                            $employeeList[] = [
                            'linkedin' => $eachItemMetatags['al:ios:url'],
                            'employee' => $eachItemMetatags['twitter:title'],
                            //'company_logo' => $eachItemMetatags[''],
                            'profile_photo' => $eachItemMetatags['og:image'],
                            'company_type' => $eachItemMetatags['og:type'],
                            'description' => $eachItemMetatags['og:description'],
                            ];
                        }
                        
                      
                    
                    /*foreach ($data['items'] as $eachItem) {
                        //echo '<pre>';
                        //print_r($eachItem['pagemap']['metatags']);
                        
                       
                       
                    }*/

                   /* $content = "Title: $title\nSnippet: $snippet\nURL: $link";
                    echo '<pre>';
                    print_r($employeeList);*/
                    /*$grokResult = $this->analyzeWithGrok($content, $companyName, $website);

                    $nameMatch = preg_match('/^[A-Z][a-z]+(?:\s[A-Z][a-z]+)*\s[A-Z][a-z]+(?:\s[A-Z][a-z]+)*$/i', trim(explode('|', $title)[0]));
                    if ($grokResult['is_employee'] && strpos($link, '/in/') !== false && $nameMatch) {
                        $name = trim(explode('|', $title)[0]);
                        if (!preg_match('/' . preg_quote($companyName, '/') . '/i', $name)) {
                            $employees[] = [
                                'name' => $name,
                                'url' => $link,
                                'snippet' => $snippet,
                                'grok_validation' => $grokResult,
                            ];
                        }
                    } else {
                        $others[] = [
                            'title' => $title,
                            'url' => $link,
                            'snippet' => $snippet,
                            'grok_validation' => $grokResult,
                        ];
                    }*/
                }

                $start += 10;
                if ($start > 100 || count($data['items']) < 10) {
                    break;
                }
            }
            
              /*echo '<pre>';
                    print_r($employeeList);*/
                    
                    return $employeeList;

            /*return [
                'employees' => !empty($employeeList) ? $employeeList : ['error' => 'No employee profiles found'],
                'company_pages' => !empty($companyPages) ? $companyPages : ['error' => 'No company pages found'],
                'others' => !empty($others) ? $others : ['error' => 'No other profiles or posts found'],
            ];*/
        } catch (Exception $e) {
            return [
                'employees' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
                'company_pages' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
                'others' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
            ];
        }
    }
    
    function GetEmployeeProfiles1($companyName)
    {
        //$companyName            = 'Bluesky Technology Consultants FZE'; 
        //$apiKey = 'AIzaSyBmnCX_hj5vKKrQlAPR7c61eh1CTMvyBDA';
        $apiKey         = Yii::app()->params['googleApiKey'];
        $cseId          = Yii::app()->params['cseId'];
        //$cseId = '65f01e14a7a29419b';
        $website='';
        $maxResults=20;
        try {
            $query = "site:linkedin.com \"$companyName\"";
            $employees = [];
            $companyPages = [];
            $others = [];
            $start = 1;

            while (count($employees) + count($companyPages) + count($others) < $maxResults) {
                $url = 'https://www.googleapis.com/customsearch/v1?' . http_build_query([
                    'key' => $apiKey,
                    'cx' => $cseId,
                    'q' => $query,
                    'num' => min($maxResults, 10),
                    'start' => $start,
                ]);
                $response = $this->makeGetRequest($url);
                $data = json_decode($response, true);
                
                /* echo '<pre>';
                        print_r($data);exit;*/
                        
                $employeeList = [];
                foreach ($data['items'] as $eachItem) {
                    //echo '<pre>';
                    //print_r($eachItem['pagemap']['metatags']);
                    foreach ($eachItem['pagemap']['metatags'] as $eachItemMetatags) {
                        //echo '<pre>';
                        //print_r($eachItemMetatags);exit;
                        $employeeList[] = [
                        'linkedin' => $eachItemMetatags['al:ios:url'],
                        'employee' => $eachItemMetatags['twitter:title'],
                        //'company_logo' => $eachItemMetatags[''],
                        'profile_photo' => $eachItemMetatags['og:image'],
                        'company_type' => $eachItemMetatags['og:type'],
                        'description' => $eachItemMetatags['og:description'],
                        ];
                    }
                   
                   
                }
                /* echo '<pre>';
                    print_r($employeeList);*/
                /*echo '<pre>';
                print_r($employeeList);exit;*/
                
                return $employeeList;
                
                
               /* $others[] = [
                            'title' => $title,
                            'url' => $link,
                            'snippet' => $snippet,
                            'grok_validation' => $grokResult,
                        ];

                if (isset($data['error'])) {
                    return [
                        'employees' => ['error' => 'API error: ' . $data['error']['message']],
                        'company_pages' => ['error' => 'API error: ' . $data['error']['message']],
                        'others' => ['error' => 'API error: ' . $data['error']['message']],
                    ];
                }
                if (empty($data['items'])) {
                    break;
                }

                foreach ($data['items'] as $item) {
                    $title = $item['title'] ?? '';
                    $snippet = $item['snippet'] ?? '';
                    $link = $item['link'] ?? '';

                    if (strpos($link, '/company/') !== false || strpos($link, '/products/') !== false || strpos($link, '/showcase/') !== false) {
                        $companyPages[] = [
                            'title' => $title,
                            'url' => $link,
                            'snippet' => $snippet,
                            'grok_validation' => ['is_employee' => false, 'reason' => 'Company page URL detected', 'confidence' => 100],
                        ];
                        continue;
                    }

                    $content = "Title: $title\nSnippet: $snippet\nURL: $link";
                    $grokResult = $this->analyzeWithGrok($content, $companyName, $website);

                    $nameMatch = preg_match('/^[A-Z][a-z]+(?:\s[A-Z][a-z]+)*\s[A-Z][a-z]+(?:\s[A-Z][a-z]+)*$/i', trim(explode('|', $title)[0]));
                    if ($grokResult['is_employee'] && strpos($link, '/in/') !== false && $nameMatch) {
                        $name = trim(explode('|', $title)[0]);
                        if (!preg_match('/' . preg_quote($companyName, '/') . '/i', $name)) {
                            $employees[] = [
                                'name' => $name,
                                'url' => $link,
                                'snippet' => $snippet,
                                'grok_validation' => $grokResult,
                            ];
                        }
                    } else {
                        $others[] = [
                            'title' => $title,
                            'url' => $link,
                            'snippet' => $snippet,
                            'grok_validation' => $grokResult,
                        ];
                    }
                }

                $start += 10;
                if ($start > 100 || count($data['items']) < 10) {
                    break;
                }*/
            }

           /* return [
                'employees' => !empty($employees) ? $employees : ['error' => 'No employee profiles found'],
                'company_pages' => !empty($companyPages) ? $companyPages : ['error' => 'No company pages found'],
                'others' => !empty($others) ? $others : ['error' => 'No other profiles or posts found'],
            ];*/
        } catch (Exception $e) {
            return [
                'employees' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
                'company_pages' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
                'others' => ['error' => 'Failed to fetch profiles: ' . $e->getMessage()],
            ];
        }
    }
    
    function analyzeWithGrok($content, $companyName, $website)
    {
        $config = Yii::app()->params;
        /*$prompt = <<<EOD
Analyze this LinkedIn profile or page for relevance to {$companyName} ({$website}):
{$content}

Determine if this is a real employee profile (individual person working at the company, typically with a URL containing '/in/' and a human-like name) or a company-related page (e.g., company profile, product, or post, typically with a URL containing '/company/', '/products/', or '/showcase/').

Consider:
- Employee profiles usually have URLs like "linkedin.com/in/firstname-lastname-123" and titles like "John Doe | Software Engineer at {$companyName}"
- Company pages have URLs like "linkedin.com/company/company-name" and titles like "{$companyName} | LinkedIn" or similar.

Return ONLY a valid JSON object with these exact keys:
{
    "is_employee": boolean,
    "reason": "string explanation",
    "confidence": 0-100
}
EOD;*/


$prompt = <<<EOD
Analyze this LinkedIn profile or page for relevance to {$companyName} ({$website}):
{$content}

Determine if this is a real employee profile (individual person working at the company, typically with a URL containing '/in/' and a human-like name) or a company-related page (e.g., company profile, product, or post, typically with a URL containing '/company/', '/products/', or '/showcase/').

Consider:
- Employee profiles usually have URLs like 'linkedin.com/in/firstname-lastname-123' and titles like 'John Doe | Software Engineer at {$companyName}'.
- Company pages have URLs like 'linkedin.com/company/company-name' and titles like '{$companyName} | LinkedIn' or similar.

Return ONLY a valid JSON object with these exact keys:
{
    "is_employee": boolean,
    "reason": "string explanation",
    "confidence": 0-100
}
EOD;





        $payload = json_encode([
            'messages' => [
                ['role' => 'system', 'content' => 'You are a JSON output assistant. Always return valid JSON.'],
                ['role' => 'user', 'content' => $prompt],
            ],
            'model' => 'grok-2-latest',
            'temperature' => 0.1,
            'response_format' => ['type' => 'json_object'],
        ]);

        try {
            
            $xaiApiUrl = Yii::app()->params['xaiApiUrl'];
            
            $xaiApiKey = Yii::app()->params['xaiApiKey'];
            
            
            $ch = curl_init($xaiApiUrl);
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Authorization: Bearer ' . $xaiApiKey,
                'Content-Type: application/json',
            ]);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 20);
            $response = curl_exec($ch);
            
            curl_close($ch);

            $data = json_decode($response, true);
            
            echo '<pre>';
            print_r($data);
            
            
            
            return json_decode($data['choices'][0]['message']['content'], true);
        } catch (Exception $e) {
            return [
                'is_employee' => false,
                'reason' => 'API Error: ' . $e->getMessage(),
                'confidence' => 0,
            ];
        }
    }




}