<?php

class GeneralController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetInventoryDetails' 

                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    
    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }

    public function actionIndex()
    {


        $this->render('general_inv_dashboard');


        //$this->render('index_ai_dashboard');
    }
    
      
    public function actionGetInventoryDetails(){
        $ModelStore = new Store();
         $search_date            =  Yii::app()->request->getParam('search_date'); 
         if(!empty($search_date)){
            
            $arr_search_date = explode("/",$search_date);
            $search_date = $arr_search_date[2]."-".$arr_search_date[1]."-".$arr_search_date[0];
        }
         
        
        $this->render('get_inventory_details', array('search_date'=>$search_date  ));
        
    }

}