<?php

class DashboardinventoryController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index','PurchaseIndex','SearchCustomer','GetCustomerDetails','SearchVendor','GetVendorDetails','InfoIndex','FinanceIndex','GetPurchaseInvoiceItems','InventoryIndex',
                            'searchInventory','GetInventoryDetails','GetInventoryItems','GetInventoryItemCustomers','GetTopItemCustomers','GetStatInfoDetails'
                    
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
/*    public function actionIndex()
        {
            
            if (isset(Yii::app()->user->havePermissionOn['dashboard_view']) || Yii::app()->user->authorised_user == 1) {
               
                $this->render('index');
            } else {
                // Unauthorized: render custom unauthorized page without layout
                $this->layout = false;
                $this->render('//front/site/unauthorised'); // Do not include .php
                Yii::app()->end(); // Stop execution
            }
        }*/


    // Uncomment the following methods and override them if needed

    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
        );
    }
  
    public function actionIndex() 
    {
        
        
        $this->render('index_ai_dashboard');
        
        
        //$this->render('index_ai_dashboard');
    }
 public function actionPurchaseIndex() 
    {
        //$this->layout = false;
        
        $id = 2001;
        
        $model = new Vendor();
        $model = $model->findByPk($id);
        
        // Get contacts for this customer
        $contactsDataProvider = new CActiveDataProvider('VendorContact', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'vendor_name ASC',
            ),
            'pagination' => array(
                'pageSize' => 10,
            ),
        ));
        
        // Get leads for this customer
        $leadsDataProvider = new CActiveDataProvider('PurchasingOrder', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_datetime DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        // Get quotes for this customer
        $quotesDataProvider = new CActiveDataProvider('PurchasingMaterialreceipt', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_date_time DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        // Get orders for this customer
        $ordersDataProvider = new CActiveDataProvider('PurchasingMaterialreceipt', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_datetime DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        // Get invoices for this customer
        $invoicesDataProvider = new CActiveDataProvider('PurchasingInvoice', array(
            'criteria' => array(
                'condition' => 'vendor_id=:vendorId',
                'params' => array(':vendorId' => $id),
                'order' => 'created_datetime DESC',
            ),
            'pagination' => array(
                'pageSize' => 5,
            ),
        ));
        
        $this->render('purchase_ai_dashboard', array(
            'model' => $model,
            'contactsDataProvider' => $contactsDataProvider,
            'leadsDataProvider' => $leadsDataProvider,
            'quotesDataProvider' => $quotesDataProvider,
            'ordersDataProvider' => $ordersDataProvider,
            'invoicesDataProvider' => $invoicesDataProvider,
        ));
        
        
        
    }
    
    public function actionSearchCustomer(){
        $model = new Customer();
        $term = Yii::app()->request->getParam('term');
        $condition = "1=1";
        if ($term != '') {
            $condition .= " AND (customer_name LIKE '%" . $term . "%')";
        }
        $model = $model->findAll(["condition" => $condition, "limit" => 10]);
        $data = [];


        foreach ($model as $eachCustomer) {

            $data[] = [
                "value" => $eachCustomer->id,
                "label" => $eachCustomer->customer_name,
                "email" => $eachCustomer->customer_email_id,
                "phone" => $eachCustomer->customer_phone_no,
                "other" => $eachCustomer->location_id,
            ];
        }
        echo json_encode($data);
    }
    
    public function actionGetCustomerDetails(){
        $modelCustomer = new Customer();
        $modelCustomerContact = new CustomerContact();
        
        $customer_id            = (int) Yii::app()->request->getParam('customer_id'); 
        $customer_from_date     = Yii::app()->request->getParam('customer_from_date');
        $customer_to_date       = Yii::app()->request->getParam('customer_to_date');
        
        if(!empty($customer_from_date)){
            
            $arr_customer_from_date = explode("/",$customer_from_date);
            $customer_from_date = $arr_customer_from_date[2]."-".$arr_customer_from_date[1]."-".$arr_customer_from_date[0];
        }
        
        if(!empty($customer_to_date)){
            $arr_customer_to_date = explode("/",$customer_to_date);
            $customer_to_date = $arr_customer_to_date[2]."-".$arr_customer_to_date[1]."-".$arr_customer_to_date[0];
        }
        
        if($customer_id > 0){
            $modelCustomer = $modelCustomer->findByPk($customer_id);
            $modelCustomerContact = $modelCustomerContact->findAll(array('condition'=>'customer_id='.$customer_id));
        }
        
        $this->render('get_customer_details', array('modelCustomer'=>$modelCustomer,'modelCustomerContact'=>$modelCustomerContact,'customer_id'=>$customer_id,'customer_from_date'=>$customer_from_date,'customer_to_date'=>$customer_to_date));
        
    }



    public function actionSearchVendor(){
        $model = new Vendor();
        $term = Yii::app()->request->getParam('term');
        $condition = "1=1";
        if ($term != '') {
            $condition .= " AND (vendor_name LIKE '%" . $term . "%')";
        }
        $model = $model->findAll(["condition" => $condition, "limit" => 10]);
        $data = [];


        foreach ($model as $eachVendor) {

            $data[] = [
                "value" => $eachVendor->id,
                "label" => $eachVendor->vendor_name,
                "email" => $eachVendor->vendor_email_id,
                "phone" => $eachVendor->vendor_phone_no,
                "other" => $eachVendor->vendor_location,
            ];
        }
        echo json_encode($data);
    }
    
    public function actionGetVendorDetails(){
        $modelVendor = new Vendor();
        $modelVendorContact = new VendorContact();
        
        $vendor_id = (int) Yii::app()->request->getParam('vendor_id');
         $vendor_from_date =  Yii::app()->request->getParam('vendor_from_date');
          $vendor_to_date =  Yii::app()->request->getParam('vendor_to_date');
          if(!empty($vendor_from_date)){
            
            $arr_vendor_from_date = explode("/",$vendor_from_date);
            $vendor_from_date = $arr_vendor_from_date[2]."-".$arr_vendor_from_date[1]."-".$arr_vendor_from_date[0];
        }
        
        if(!empty($vendor_to_date)){
            $arr_vendor_to_date = explode("/",$vendor_to_date);
            $vendor_to_date = $arr_vendor_to_date[2]."-".$arr_vendor_to_date[1]."-".$arr_vendor_to_date[0];
        }
        if($vendor_id > 0){
            $modelVendor = $modelVendor->findByPk($vendor_id);
            $modelVendorContact = $modelVendorContact->findAll(array('condition'=>'vendor_id='.$vendor_id));
        }
        
        $this->render('get_vendor_details', array('modelVendor'=>$modelVendor,'modelVendorContact'=>$modelVendorContact,'vendor_id'=>$vendor_id,'vendor_to_date'=>$vendor_to_date,'vendor_from_date'=>$vendor_from_date));
        
    }
    
    public function actionInfoIndex(){
          $this->render('index_ai_info');
    }
    
    public function actionFinanceIndex(){
          $this->render('index_ai_finance');
    }
     public function actionGetPurchaseInvoiceItems(){
         
        $vendor_id = (int) Yii::app()->request->getParam('vendor_id');
        $type = Yii::app()->request->getParam('type');
        
        $this->render('popular_items_purchase', array('vendorId'=>$vendor_id,'type'=>$type ));
        
    }
    
    public function actionInventoryIndex(){
          $this->render('index_ai_inventory');
    }

    public function actionSearchInventory(){
        $model = new Store();
        $term = Yii::app()->request->getParam('term');
        $condition = "1=1";
        if ($term != '') {
            $condition .= " AND (part_number LIKE '%" . $term . "%' OR description LIKE '%" . $term . "%')";
        }
        $model = $model->findAll(["condition" => $condition, "limit" => 10]);
        $data = [];


        foreach ($model as $eachItem) {

            $data[] = [
                "value" => $eachItem->id,
                "label" => $eachItem->part_number.'|'.$eachItem->description,
                "other" => $eachItem->part_number, 
            ];
        }
        echo json_encode($data);
    }
    
    public function actionGetInventoryDetails(){
        $ModelStore = new Store();
         $product_id            = (int) Yii::app()->request->getParam('product_id'); 
        
        if($product_id > 0){
           // $ModelStore = $ModelStore->findByPk($product_id);
             $query = 'SELECT * FROM (SELECT product_id,generic_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,item_type
            FROM view_warehousewise_stock
            WHERE "1=1" AND product_id ='.$product_id.'
            GROUP BY product_id
            )A' ;

         $ModelStore = Yii::app()->db->createCommand($query)->queryRow();
         }
        
        $this->render('get_inventory_details', array('ModelStore'=>$ModelStore ,'product_id'=>$product_id));
        
    }
     public function actionGetInventoryItems(){
         
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $type = Yii::app()->request->getParam('type');
        
        $this->render('inventory_card_info', array('product_id'=>$product_id,'type'=>$type ));
        
    }
    
    public function actionGetInventoryItemCustomers(){
         
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $type = Yii::app()->request->getParam('type');
        
        $this->render('inventory_customers', array('product_id'=>$product_id,'type'=>$type ));
        
    }
    
     public function actionGetTopItemCustomers(){
         
        $product_id = (int) Yii::app()->request->getParam('product_id');
        $type = Yii::app()->request->getParam('type');
        
        $this->render('inventory_customers_year', array('product_id'=>$product_id,'type'=>$type ));
        
    }
     public function actionGetStatInfoDetails(){
         
         $ModelStore = new Store();
         $product_id            = (int) Yii::app()->request->getParam('product_id'); 
        
        if($product_id > 0){
           // $ModelStore = $ModelStore->findByPk($product_id);
             $query = 'SELECT * FROM (SELECT product_id,generic_id,part_number,description,bar_code,brand_id,brand,SUM(quantity) AS quantity,isActive,inventory_item_type,rate,selling_price_1,item_type
            FROM view_warehousewise_stock
            WHERE "1=1" AND product_id ='.$product_id.'
            GROUP BY product_id
            )A' ;

         $ModelStore = Yii::app()->db->createCommand($query)->queryRow();
         }
        $type = Yii::app()->request->getParam('type');
        
        $this->render('quick_stats_info', array('product_id'=>$product_id,'type'=>$type,'ModelStore'=>$ModelStore ));
        
    }

}