<style>
    .datepicker-popover,
    .info-table,
    .info-table-close {
        z-index: 999999999999 !important;
    }
</style>

<section class="panel" style="background-color:#F6F3EE;">
    <input type="hidden" name="added_from" id="added_from" value="<?php echo $added_from; ?>">
    <input type="hidden" name="customer_id" id="customer_id" value="<?php echo $customer_id; ?>">
    <input type="hidden" name="header_id" id="header_id" value="<?php echo $header_id; ?>">
    <input type="hidden" name="file_id" id="file_id" value="<?php echo $file_id; ?>">
    <input type="hidden" name="mode" id="mode" value="<?php echo $mode; ?>">

    <header class="panel-heading clearfix panel-theame">
        <?php
        if ((int) $customer_id > 0) {
            $customer_vendor_name = ($mode == 'purchase')
                ? Vendor::model()->findByPk((int)$customer_id)->vendor_name
                : Customer::model()->findByPk((int)$customer_id)->customer_name;
        } elseif ($added_from == 'LE') {
            $customer_vendor_name = Lead::model()->findByPk($header_id)->customer_name;
        }
        ?>
        <span style="color: white;">
            <?php echo $customer_vendor_name; ?>
        </span>

        <div class="pull-right">
            <div class="col-md-12">
                <div class="col-md-7"></div>
                <div class="col-md-2">
                    <button class="btn btn-sm btn-theme" onclick="loadPopupModal('activity/activity/createactivity&frm=<?php echo $added_from; ?>&customer_id=<?php echo $customer_id; ?>&header_id=<?php echo $header_id; ?>&file_id=<?php echo $file_id; ?>&mode=<?php echo $mode; ?>', 'Activity-<?php echo $header_id ?>', 'xl')" title="Add">
                        <i class="fa fa-plus"></i>
                    </button>
                </div>
            </div>
        </div>
    </header>

    <div class="panel-body">
        <div class="custom-data-table">
            <table class="table table-hover table-bordered personal-task" id="tbl_activity_list" style="font-size:13px;">
                <thead>
                    <tr>
                        <th></th>
                        <th><?php echo CHtml::textField('filter_header_id', '', array('onkeyup' => 'reloadTable("#tbl_activity_list")','style'=>'width:60px;height:15px;')); ?></th>
                        <th><?php echo CHtml::dropDownList('filter_activity_type', '', ActivityType::getAllActivityType(), array('prompt'=>'--Type--','onChange' => 'reloadTable("#tbl_activity_list")')); ?></th>
                        <th><?php echo CHtml::dropDownList('filter_activity_status', '', ActivityStatus::getAllActivityStatus(), array('prompt'=>'--Status--','onChange' => 'reloadTable("#tbl_activity_list")')); ?></th>
                        <th></th>
                        <th><?php echo CHtml::dropDownList('filter_assigned_to', '', Employee::getEmployee(), array('prompt'=>'--Assigned--','onChange' => 'reloadTable("#tbl_activity_list")')); ?></th>
                        <th></th>
                        <th><?php echo CHtml::textField('filter_notes', '', array('onkeyup' => 'reloadTable("#tbl_activity_list")')); ?></th>
                    </tr>
                    <tr>
                        <th>No</th>
                        <th>Ref#</th>
                        <th>Type</th>
                        <th>Status</th>
                        <th>Date</th>
                        <th>Assigned To</th>
                        <th>Assigned By</th>
                        <th>Deadline Date</th>
                        <th>Notes</th>
                        <th>Action</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</section>

<script>
$(document).ready(function () {
    var table = $("#tbl_activity_list").on("preXhr.dt", function (e, settings, data) {
        data.customer_id = $("#customer_id").val();
        data.added_from = $("#added_from").val();
        data.mode = $("#mode").val();
        data.header_id = $("#header_id").val();
        data.file_id = $('#file_id').val();
        data.filter_added_from = $("#filter_added_from").val();
        data.filter_activity_type = $("#filter_activity_type").val();
        data.filter_date_of_activity = $("#filter_date_of_activity").val();
        data.filter_assigned_to = $("#filter_assigned_to").val();
        data.filter_follow_up_date = $("#filter_follow_up_date").val();
        data.filter_notes = $("#filter_notes").val();
        data.filter_header_id = $("#filter_header_id").val();
        data.filter_file_id = $("#filter_file_id").val();
        data.filter_activity_status = $("#filter_activity_status").val();
        return data;
    }).DataTable({
        scrollY: "345px",
        pageLength: 50,
        processing: true,
        serverSide: true,
        fixedColumns: true,
        ajax: {
            url: "<?php echo Yii::app()->createUrl('activity/activity/getactivitylist') ?>",
            type: "POST",
            cache: false,
        },
        columns: [
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
            {className: "sl col-max-2"},
            {className: "sl col-max-2"},
            {className: "sl col-max-2"},
            {className: "sl col-max-2"},
            {className: "sl col-max-3"},
            {className: "sl col-max-1"},
            {className: "sl col-max-1"},
        ],
        columnDefs: [
            {
                targets: [9], // Hides Action column
                visible: false,
            },
        ],
        initComplete: function () {
            $('.activityNotesOver').popover({
                title: '<b>Notes</b>',
                html: true,
                placement: 'right',
                trigger: 'hover',
                content: popoverContent
            });
        },
        fnRowCallback: function (nRow, aData, iDisplayIndex, iDisplayIndexFull) {
            AddContextMenu(nRow, aData);
        }
    });

    $('#tbl_activity_list tbody').on('mouseover', 'tr', function () {
        $('.activityNotesOver').popover({
            title: '<b>Notes</b>',
            html: true,
            placement: 'right',
            trigger: 'hover',
            content: popoverContent
        });
    });
});

function AddContextMenu(row, datas) {
    $(row).contextMenu({
        selector: 'td',
        items: {
            "edit": {
                name: (datas[3] !== 'Completed') ? "Edit" : "View",
                icon: (datas[3] !== 'Completed') ? "edit" : "view",
                callback: function () {
                    const mode = $("#mode").val();
                    const added_from = $("#added_from").val();
                    const customer_id = $("#customer_id").val();
                    const header_id = datas[1];
                    const activity_id = datas[10];
                    const type = (datas[3] === 'Completed') ? '&type=view' : '';
                    loadPopupModal(
                        'activity/activity/createactivity&frm=' + added_from +
                        '&customer_id=' + customer_id +
                        '&id=' + activity_id +
                        '&header_id=' + header_id +
                        '&edit_from=' + added_from +
                        '&mode=' + mode + type,
                        added_from,
                        'xl'
                    );
                }
            }
        }
    });
}

function popoverContent() {
    var content = '';
    var element = $(this);
    var id = element.attr("id");
    var arr_fields = id.split('_');
    var activity_id = arr_fields[2];
    $.ajax({
        type: 'post',
        url: "<?php echo Yii::app()->createUrl('activity/activity/GetActivityNote') ?>",
        data: { activity_id: activity_id },
        cache: false,
        async: false,
        success: function (retdata) {
            content = retdata;
        }
    });
    return content;
}
</script>
