<?php

/**
 * This is the model class for table "{{activity}}".
 *
 * The followings are the available columns in table '{{activity}}':
 * @property integer $id
 * @property string $task_type
 * @property integer $customer_id
 * @property string $task_date_time
 * @property string $deadline_date_time
 * @property integer $assigned_to
 * @property string $task_status
 * @property string $added_from
 * @property string $notes
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_date_time
 * @property string $updated_date_time
 */
class Activity extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{activity}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('customer_id, assigned_from, task_status,task_date_time,deadline_date_time,notes,task_type', 'required'),
			array('customer_id, assigned_from,assigned_to, created_by, updated_by,header_id,task_type,task_status, ', 'numerical', 'integerOnly'=>true),
			array('isActive', 'length', 'max'=>1),
			array('added_from', 'length', 'max'=>2),
			array('customer_name', 'length', 'max'=>255),
			
			array('file_id,task_date_time, deadline_date_time, updated_date_time', 'safe'),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, task_type, customer_id, task_date_time, deadline_date_time, assigned_to, task_status, added_from, notes, isActive, created_by, updated_by, created_date_time, updated_date_time', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'user' => array(self::BELONGS_TO, 'User', 'crm_user_id'),
            'customer' => array(self::BELONGS_TO, 'Customer', 'customer_id'),
            'vendor' => array(self::BELONGS_TO, 'Vendor', 'customer_id'),
            'assignedFrom' => array(self::BELONGS_TO, 'User','assigned_from'),
            'assignedTo' => array(self::BELONGS_TO, 'Employee','assigned_to'),
            'addedfrom' => array(self::BELONGS_TO, 'ActivityMasAddedFrom','added_from'),   
            'tasktype' => array(self::BELONGS_TO, 'ActivityType','task_type'),   
            'taskstatus' => array(self::BELONGS_TO, 'ActivityStatus','task_status'),  
            'createdby' => array(self::BELONGS_TO, 'User', 'created_by'),      
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'task_type' => 'Type',
			'customer_id' => 'Customer',
			'task_date_time' => 'Task Date',
			'deadline_date_time' => 'Deadline Date/time',
			'assigned_to' => 'Assigned To',
			'task_status' => 'Status',
			'added_from' => 'C-Customer,L-Lead,Q-quotation',
			'notes' => 'Notes',
			'isActive' => 'Is Active',
			'created_by' => 'Created By',
			'updated_by' => 'Updated By',
			'created_date_time' => 'Created Date Time',
			'updated_date_time' => 'Updated Date Time',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('task_type',$this->task_type,true);
		$criteria->compare('customer_id',$this->customer_id);
		$criteria->compare('task_date_time',$this->task_date_time,true);
		$criteria->compare('deadline_date_time',$this->deadline_date_time,true);
		$criteria->compare('assigned_to',$this->assigned_to);
		$criteria->compare('task_status',$this->task_status,true);
		$criteria->compare('added_from',$this->added_from,true);
		$criteria->compare('notes',$this->notes,true);
		$criteria->compare('isActive',$this->isActive,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Activity the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
