<?php

class ActivityController extends Controller
{
        public function accessRules() {
    
            return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index', 'MasterIndex','GetMasterList','CreateMaster','SaveMaster','GetActivityList', 'CreateActivity', 'SaveActivity','ActivityTasks','GetActivityTaskList','CreateTask','SaveTask','History','Indexactivityfrom','GetListActivityfrom','CreateActivityfrom','SaveActivityfrom','DisableActivityfrom','GetActivityNote','CreateNewActivity'), 
                    'expression' => '$user->isMember()',
                ),
                array('deny', // deny all users
                    'users' => array('*'),
                ),
            );
        }
    
        public function filters() {
    
            return array(
                'accessControl', // perform access control for CRUD operations
            );
        }
        
        public function actionIndex() {
            $customer_id = (int) Yii::app()->request->getParam('customer_id');
            $added_from = Yii::app()->request->getParam('frm');
            $model = new Activity();
            //$model=$model->findAll();
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $this->render('index', array('model' => $model,'customer_id'=>$customer_id,'added_from'=>$added_from));
        }
        
         public function actionHistory() {
            $customer_id = (int) Yii::app()->request->getParam('customer_id');
            $header_id = (int) Yii::app()->request->getParam('header_id');
            $file_id = (int) Yii::app()->request->getParam('file_id');
            $added_from = Yii::app()->request->getParam('frm');
            $mode = Yii::app()->request->getParam('mode');
            $model = new Activity();
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false, 'jquery-2.1.4.min.js' => false);
            $this->render('history', array('model' => $model,'customer_id'=>$customer_id,'added_from'=>$added_from,'header_id'=>$header_id,'file_id'=>$file_id,'mode'=>$mode));
        }
        
        public function actionGetActivityList(){
            $model = new Activity();
            $customer_id                =   (int) $_POST['customer_id'];
            $added_from                 =   $_POST['added_from'];
            $filter_added_from          =  $_POST['filter_added_from'];
            $filter_activity_type       =  (int) $_POST['filter_activity_type'];
            $filter_task_date           =  $_POST['filter_task_date'];
            $filter_assigned_to         =  $_POST['filter_assigned_to'];
            $filter_deadline_date_time  =  $_POST['filter_deadline_date_time'];
            $filter_notes               =  $_POST['filter_notes'];
            $filter_header_id           =  $_POST['filter_header_id'];
            $header_id                  =  (int) $_POST['header_id'];
            $filter_file_id             =  $_POST['filter_file_id '];
            $file_id                    =  (int) $_POST['file_id'];
            $mode                       =  $_POST['mode']; 
            $filter_activity_status     =  (int) $_POST['filter_activity_status'];
            $filter_customer_name       =  $_POST['filter_customer_name'];
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
                0 => 'parent.activity',
            );
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
            $condition = 't.isActive="Y"';
            if($added_from=='DI'){
                
                $condition.= ' AND added_from="DI"';
            }

            if(((int) Yii::app()->user->havePermissionOn["activity_view_all"]) == 0){
                $condition.= ' AND (t.assigned_from="'.Yii::app()->user->id.'" OR t.assigned_to="'.Yii::app()->user->id.'")';
            }
            
            
            if($added_from=='TA' || $added_from=='DI'){
                $filter_task_date         =  $_POST['filter_task_date'];
                
                if(!empty($filter_task_date)){
                    
                    $filter_task_date       = str_replace('/', '-', $filter_task_date);
                    $filter_task_date       = date("Y-m-d", strtotime($filter_task_date));
                    
                    $condition.= ' AND DATE(task_date_time)="'.$filter_task_date.'"';
                }
                
                $filter_deadline_date           =  $_POST['filter_deadline_date'];
                if(!empty($filter_deadline_date)){
                    
                    
                    $filter_deadline_date       = str_replace('/', '-', $filter_deadline_date);
                    $filter_deadline_date       = date("Y-m-d", strtotime($filter_deadline_date));
                    
                    $condition.= ' AND DATE(deadline_date_time)="'.$filter_deadline_date.'"';
                    
                }
                $condition.= ' AND taskstatus.status_code!="C"';
            }
            
            if($customer_id > 0){
                $condition.= ' AND t.customer_id='.$customer_id;
            }
            
            if(!empty($filter_added_from)){
                $condition.= ' AND t.added_from="'.$filter_added_from.'"';
            }
            
             if((int) $filter_activity_type >0){
                $condition.= ' AND t.task_type="'.$filter_activity_type.'"';
            }
            
            if((int) $filter_activity_status >0){
                $condition.= ' AND t.task_status="'.$filter_activity_status.'"';
            }
            if((int) $filter_assigned_to >0){
                $condition.= ' AND t.assigned_to="'.$filter_assigned_to.'"';
            } 
            if(!empty($filter_deadline_date_time)){
                $condition.= ' AND DATE(deadline_date_time)="'.date('Y-m-d',strtotime($filter_deadline_date_time)).'"';
            }
            if(!empty($filter_notes)){
                $condition.= ' AND t.notes LIKE "%'.$filter_notes.'%"';
            }
            if(!empty($filter_header_id)){
                $condition.= ' AND t.header_id LIKE "%'.$filter_header_id.'%"';
            }

            if($file_id > 0 && $added_from!="CU"){
                $condition.= ' AND t.file_id='.$file_id;
            }
            
            if(!empty($filter_customer_name)){
                $condition.= ' AND (customer.customer_name LIKE "%' . $filter_customer_name . '%" OR t.customer_name LIKE "%' . $filter_customer_name . '%")';
            }
            
    
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition .= " AND (t.id LIKE '%" . $searchString . "%' OR notes LIKE '%" . $searchString . "%' OR customer.customer_name LIKE '%" . $searchString . "%')";
            }
            // echo $condition;
            // die();
            $count = $model->with('taskstatus','tasktype','customer')->count(array('condition' => $condition));
            $model = $model->with('taskstatus','tasktype','customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 't.task_date_time DESC'));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $m = 1;

            foreach ($model as $i=>$row) {
                $display_added_from =ActivityMasAddedFrom::getActivityFromByCode($row['added_from']);
                
                // $div="";
                // if($row['taskstatus']['status']!='Completed'){
                //     $div = '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'activity/activity/createactivity&frm='.$added_from.'&customer_id='.$customer_id.'&id=' . $row['id'].'&header_id=' . $row['header_id'] . '&edit_from='.$row['added_from'].'&mode='.$mode.'\',\'' . $display_added_from . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                // }
                // else{
                //     $div = '<button class="btn btn-primary btn-xs" title ="View" onclick="loadPopupModal(\'activity/activity/createactivity&frm='.$added_from.'&customer_id='.$customer_id.'&id=' . $row['id'].'&header_id=' . $row['header_id'] . '&edit_from='.$row['added_from'].'&mode='.$mode.'&type=view\',\'' . $display_added_from . '\',\'xl\')"><i class="fa fa-eye"></i></button>';
                // }
                
                $task_date="";
                if($row['task_date_time']!="0000-00-00 00:00:00"){
                    $task_date=date('d/m/Y h:i a',strtotime($row['task_date_time']));
                }
                $deadline_date_time="";
                if($row['deadline_date_time']!="0000-00-00 00:00:00"){
                    $deadline_date_time=date('d/m/Y h:i a',strtotime($row['deadline_date_time']));
                }
                
                $notes_div="";
                if(!empty($row['notes'])){
                    $notes_div = ' <a href="#" class="activityNotesOver" id="locationhelper_'.$m.'_'.$row['id'].'"><i class="fa fa-info-circle"><div class="triangle-right"></div></i></a>';   
                }
                
                if (strlen($row['notes']) > 50)
                $row['notes'] = substr($row['notes'], 0, 50) . '...';
                
                if($added_from=='TA' || $added_from=='DI'){
                    
                    if(!empty($row['customer_name'])){
                        $customer_name = $row['customer_name'];
                    }
                    else{
                        $customer_name = $row['customer']['customer_name'];
                    }
                    $rowData[] = array($m.$notes_div,$customer_name,$display_added_from,$row['file_id'],$row['header_id'],$row['tasktype']['type'],$row['taskstatus']['status'],$task_date,$row['assignedTo']['fullName'],$deadline_date_time,$row['notes'],$div,$row['id']);
                }
                else{
                    if($added_from == 'ID')
                    {
                        $display_added_from = $row['customer']['customer_name'];
                    }
                   $rowData[] = array(
                                $m . $notes_div,                 // [0] Serial number + notes icon
                                //$display_added_from,          
                                //$row['file_id'],              
                                $row['header_id'],              // [1] Reference #
                                $row['tasktype']['type'],       // [2]  Type
                                $row['taskstatus']['status'],   // [3]  Status
                                $task_date,                     // [4] Date of Activity
                                $row->assignedTo->employeefullname, // [5] Assigned To
                                $row['assignedFrom']['fullName'],   // [6] Assigned By
                                $deadline_date_time,            // [7] Follow Up / Deadline
                                $row['notes'],                  // [8] Notes
                                $div,                           // [9] Action button(s)
                                $row['id'],                   // [10] Activity ID (used in context menu logic)
                                
                            );

                }

                $m++;
            }
            // var_dump($rowData);
            // die();
            $data['data'] = $rowData;
            echo json_encode($data);
        }
        
        
    
        public function actionCreateActivity() {
            $model = new Activity();
            $id = (int) Yii::app()->request->getParam('id');
            $added_from = Yii::app()->request->getParam('frm');
            $customer_id = Yii::app()->request->getParam('customer_id');
            $header_id = (int) Yii::app()->request->getParam('header_id');
            $file_id = (int) Yii::app()->request->getParam('file_id');
            $edit_from = Yii::app()->request->getParam('edit_from');
            $mode = Yii::app()->request->getParam('mode');
            $type = Yii::app()->request->getParam('type');
            
            $model->header_id = (int) $header_id;
            $model->file_id = (int) $file_id;
            $model->customer_id = $customer_id;
            if ($id > 0) {
                $model = $model->findByPk($id);
                $model->customer_name = $model->customer_name;
            }
            $model->added_from = $added_from;
            
            
           /* if($added_from=='TA'){
                $type_of_activity ="T";
            }
            if(!empty($type_of_activity)){
                $model->type_of_activity = $type_of_activity;
            }*/
            
            if(!empty($added_from)){
               $header_added_from =ActivityMasAddedFrom::getActivityFromByCode($added_from); 
            }
            
            
            if($added_from=='LE' || $edit_from=='LE'){
                $modelLead=Lead::model()->findByPk($header_id);
                
                $model->customer_name = $modelLead->customer_name;
            }
            
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create_activity', array('model' => $model,'header_added_from'=>$header_added_from,'edit_from'=>$edit_from,'mode'=>$mode,'type'=>$type,'file_id'=>$file_id));
        }
        
        public function actionCreateNewActivity() {
            $model = new Activity();
            $id = (int) Yii::app()->request->getParam('id');
            $added_from = Yii::app()->request->getParam('frm');
            $customer_id = Yii::app()->request->getParam('customer_id');
            $header_id = (int) Yii::app()->request->getParam('header_id');
            $file_id = (int) Yii::app()->request->getParam('file_id');
            $edit_from = Yii::app()->request->getParam('edit_from');
            $mode = Yii::app()->request->getParam('mode');
            $type = Yii::app()->request->getParam('type');
            
            $model->header_id = (int) $header_id;
            $model->file_id = (int) $file_id;
            $model->customer_id = $customer_id;
            if ($id > 0) {
                $model = $model->findByPk($id);
                $model->customer_name = $model->customer_name;
            }
            $model->added_from = $added_from;
            
            
           /* if($added_from=='TA'){
                $type_of_activity ="T";
            }
            if(!empty($type_of_activity)){
                $model->type_of_activity = $type_of_activity;
            }*/
            
            if(!empty($added_from)){
               $header_added_from =ActivityMasAddedFrom::getActivityFromByCode($added_from); 
            }
            
            
            if($added_from=='LE' || $edit_from=='LE'){
                $modelLead=Lead::model()->findByPk($header_id);
                
                $model->customer_name = $modelLead->customer_name;
            }
            
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create_new_activity', array('model' => $model,'header_added_from'=>$header_added_from,'edit_from'=>$edit_from,'mode'=>$mode,'type'=>$type,'file_id'=>$file_id));
        }
       
        public function actionSaveActivity(){

            $modelActivity = new Activity();
            $id = $_POST['Activity']['id'];
            $flag=0;
            if ($id > 0) {
                $modelActivity = $modelActivity->findByPk($id);
                
                if($modelActivity->notes==$_POST['Activity']['notes']){
                    $flag=1;
                }
                
                $audit_type = 'UPDATED';
            }
            else{
                $audit_type = 'CREATED';
            }
            
            if(empty($_POST['Activity']['customer_id'])){
              $_POST['Activity']['customer_id'] =  $_REQUEST['customer_id'];
            }
            $modelActivity->attributes = $_POST['Activity'];
            if($modelActivity->validate()){

                $customer_name = $_POST['Activity']['customer_name'];
                if(empty($customer_name) && (int) $_POST['Activity']['customer_id'] > 0){
                    if(!empty($_REQUEST['type_selector']) && $_REQUEST['type_selector'] == 'vendor'){
                        $modelVendor  =   new Vendor();
                        $modelVendor   =   $modelVendor->findByPk((int) $_POST['Activity']['customer_id']);
                        $customer_name  =   $modelVendor->vendor_name;
                    }else{
                        $modelCustomer  =   new Customer();
                        $arr_customer   =   $modelCustomer->findByPk((int) $_POST['Activity']['customer_id']);
                        $customer_name  =   $arr_customer->customer_name;
                    }
                   
                }
                // var_dump($customer_name);
                // die();
                if(!empty($_POST['Activity']['task_date_time'])){
                    $modelActivity->task_date_time = str_replace('/', '-', $_POST['Activity']['task_date_time']);
                    $modelActivity->task_date_time      = date("Y-m-d H:i:s", strtotime($modelActivity->task_date_time));
                }
                else{
                    $modelActivity->task_date_time      = date("Y-m-d H:i:s");
                }
                
                if(!empty($_POST['Activity']['deadline_date_time'])){
                    $modelActivity->deadline_date_time = str_replace('/', '-', $_POST['Activity']['deadline_date_time']);
                    $modelActivity->deadline_date_time      = date("Y-m-d H:i:s", strtotime($modelActivity->deadline_date_time));
                }
                else{
                    $modelActivity->deadline_date_time      = "0000-00-00 00:00:00";
                }
               
                $modelActivity->customer_id                 = $_POST['Activity']['customer_id'];
                $modelActivity->customer_name               = $customer_name;
                $modelActivity->header_id                   = $_POST['Activity']['header_id'];
                $modelActivity->file_id                     = $_POST['Activity']['file_id'];
                $modelActivity->task_type                   = $_POST['Activity']['task_type'];
                $modelActivity->task_status                 = $_POST['Activity']['task_status'];
                $modelActivity->assigned_from               = $_POST['Activity']['assigned_from'];
                $modelActivity->assigned_to                 = $_POST['Activity']['assigned_to'];
                $modelActivity->isActive                    = "Y";
               // $modelActivity->assigned_to                 = Yii::app()->user->id;
                $modelActivity->created_by                  = Yii::app()->user->id;
                $modelActivity->updated_by                  = 0;
                $modelActivity->created_date_time           = date("Y-m-d H:i:s");
                $modelActivity->updated_date_time           = "0000-00-00 00:00:00"; 
                $modelActivity->added_from                  = $_POST['Activity']['added_from'];
                $modelActivity->header_id                   = (int) $_POST['Activity']['header_id'];
                $modelActivity->save(false);
                
                // inserting to audit log
                AuditLog::saveAuditLogs(
                    'ACTIVITY',
                    Yii::app()->user->id,
                    $audit_type,
                    " with Activity No - {$modelActivity->id}  "
                );
                // end audit log 
                
                
                if($_POST['Activity']['notes']!="" && $flag==0){
                    
                    $modelActivityNotesHistory                      = new ActivityNotesHistory();
                    $modelActivityNotesHistory->activity_id         = $modelActivity->id;
                    $modelActivityNotesHistory->activity_notes      = $_POST['Activity']['notes'];
                    $modelActivityNotesHistory->created_by          = Yii::app()->user->id;
                    $modelActivityNotesHistory->assigned_to          = (!empty($_POST['Activity']['assigned_to']))?$_POST['Activity']['assigned_to']:Yii::app()->user->id;
                    $modelActivityNotesHistory->created_date_time   = date("Y-m-d H:i:s");
                    $modelActivityNotesHistory->task_date_time      = $modelActivity->task_date_time;
                    $modelActivityNotesHistory->deadline_date_time   = $modelActivity->deadline_date_time;
                    $modelActivityNotesHistory->save(false);           
                }
                
                echo CJSON::encode( array('status' => 'success') );
            }
            else{
                $error = CActiveForm::validate($modelActivity, '', false);
                if ($error != '[]') {
                    echo $error;
                }
            }
            
            
        }
        
        
        
        public function actionMasterIndex() {
            $model = new ActivityMaster();
            $this->render('master_index', array('model' => $model));
        }
    
        public function actionCreateMaster() {
            $model = new ActivityMaster();
            $id = (int) Yii::app()->request->getParam('id');
            if ($id > 0) {
                $model = $model->findByPk($id);
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('master_create', array('model' => $model));
        }
        
        
        
        public function actionGetMasterList() {
            $model = new ActivityMaster();
            $draw = $_POST['draw'];
            $offset = $_POST['start'];
            $limit = $_POST['length'];
            $columns = array(
                // datatable column index  => database column name
                0 => 'activity',
            );
            $filterColumn = $columns[$_POST['order'][0]['column']];
            $filterOrder = $_POST['order'][0]['dir'];
            $orderBy = $filterColumn . " " . $filterOrder;
            $condition = 't.isActive="Y" ';
    
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition .= " and (activity LIKE '%" . $searchString . "%' )";
            }
    
            $count = $model->count(array('condition' => $condition));
            $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => 'activity'));
            $recordsTotal = $count;
            $recordsFiltered = $count;
            $data['draw'] = $draw;
            $data['recordsTotal'] = $recordsTotal;
            $data['recordsFiltered'] = $recordsFiltered;
            $rowData = array();
            $m = 1;
    
            foreach ($model as $row) {
                $div = '<button class="btn btn-primary btn-xs" title ="Edit" onclick="loadPopupModal(\'activity/activity/createmaster&id=' . $row['id'] . '\',\'' . $row['id'] . ' : ' . $row['activity'] . '\',\'xl\')"><i class="fa fa-edit"></i></button>';
                $rowData[] = array($m,$row['activity'],' <div style="background-color:'.$row['colour'].';color:'.$row['colour'].';">1</div>','<div style="background-color:'.$row['f_colour'].';color:'.$row['f_colour'].';">1</div>',$row['id'],$row['isActive']);
    
                $m++;
            }
    
    
            $data['data'] = $rowData;
            echo json_encode($data);
    }
        
    
        public function actionSaveMaster() {
            $model = new ActivityMaster();
            $id = (int) $_POST['ActivityMaster']['id'];
            if ($id > 0) {
                $model = $model->findByPk($id);
            }
            $model->activity = $_POST['ActivityMaster']['activity'];
            $model->colour = $_POST['ActivityMaster']['colour'];
            $model->f_colour = $_POST['ActivityMaster']['f_colour'];
            if ($model->validate()) {
                if ($model->save()) {
                    $jsonData['status'] = 'success';
                    $jsonData['id'] = $model->id;
                    echo CJSON::encode($jsonData);
                }
            } else {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]') {
                    echo $error;
                }
            }
        }
        
        
        
        
        public function actionActivityTasks(){
            $model = new Activity();
            
            $this->render('activity_task_list', array('model' => $model));
        }
        public function actionGetActivityTaskList(){
            $model = new Activity();
            //filter
            $filter_customer            =  $_POST['filter_customer'];
            $filter_activity_type       =  (int) $_POST['filter_activity_type'];
            $filter_assigned_to         =  $_POST['filter_assigned_to'];
            $filter_notes               =  $_POST['filter_notes'];
            
            $draw   = $_POST['draw'];
            $offset = $_POST['start'];
            $limit  = $_POST['length'];
            $brand = $_POST['brand'];
            $columns = array(
                // datatable column index  => database column name
                0 => 't.id',
                1 => 't.activity_id',
                2 => 't.task_date',
                3 => 't.deadline_date_time'
            );
            $filterColumn   = $columns[$_POST['order'][0]['column']];
            $filterOrder    = $_POST['order'][0]['dir'];
            $orderBy        = $filterColumn . " " . $filterOrder;
            $condition      = '1=1';
            
             if(!empty($filter_customer)){
                $condition.= ' AND customer_name LIKE "%'.$filter_customer.'%"';
            }
            
            
            if((int) $filter_activity_type >0){
                $condition.= ' AND t.activity_id="'.$filter_activity_type.'"';
            }
            
            
            if((int) $filter_assigned_to >0){
                $condition.= ' AND t.assigned_to="'.$filter_assigned_to.'"';
            }
            
            if(!empty($filter_notes)){
                $condition.= ' AND t.notes LIKE "%'.$filter_notes.'%"';
            }
            
            
            if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
                $searchString = $_POST['search']['value'];
                $condition.=" AND (t.notes LIKE '%" . $searchString . "%' )";
            }
            
            $count          = $model->with('customer')->count(array('condition' => $condition));
            $model          = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
            $recordsTotal   = $count;
            $recordsFiltered        = $count;
            $data['draw']   = $draw;
            $data['recordsTotal']   = $recordsTotal;
            $data['recordsFiltered']= $recordsFiltered;
            $rowData                = array();
            $m=1;
            foreach ($model as $row)
            {
                //if ((isset(Yii::app()->user->havePermissionOn['mas_inv_brand_edit']) || Yii::app()->user->authorised_user == 1) )
                //{
                    $div= '<button class="btn btn-primary btn-xs" title ="View" onclick="loadPopupModal(\'activity/activity/history&frm=TA&customer_id='.$row['customer_id'].'&id='.$row['id'].'\',\'Tasks\',\'xl\')"><i class="fa fa-eye" aria-hidden="true"></i></button>';
                //}
                $task_date = ($row['task_date']!="0000-00-00 00:00:00")?date("d/m/Y h:i:s", strtotime($row['task_date'])):"";
                $deadline_date_time = ($row['deadline_date_time']!="0000-00-00 00:00:00")?date("d/m/Y h:i:s", strtotime($row['deadline_date_time'])):"";
                $rowData[]  = array($m,$row['customer']['customer_name'],$row['parent']['activity'],$task_date,$row['assigned']['fullName'],$deadline_date_time,$row['notes'],$div);
                $m++;
            } 
            $data['data'] = $rowData;
            echo json_encode($data);
        }
        public function actionCreateTask(){
            $model = new Activity();
            $id = (int) Yii::app()->request->getParam('id');
            if ($id > 0) {
                $model = $model->findByPk($id);
            }
            Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
            $this->render('create_task', array('model' => $model));
        }
        
        public function actionSaveTask(){
            $modelActivity = new Activity();
            $id = $_POST['Activity']['id'];
            if ($id > 0) {
                $modelActivity = $modelActivity->findByPk($id);
            }
            $modelActivity->attributes = $_POST['Activity'];
            if($modelActivity->validate()){
                $modelActivity->customer_id         = $_POST['Activity']['customer_id'];
                $modelActivity->type_of_activity    = "T";
                $modelActivity->activity_id         = $_POST['Activity']['activity_id'];
                $modelActivity->task_date    = date("Y-m-d H:i:s");
                $modelActivity->deadline_date_time      = date("Y-m-d H:i:s",strtotime($_POST['Activity']['deadline_date_time']));
                $modelActivity->notes               = $_POST['Activity']['notes'];
                $modelActivity->assigned_to         = $_POST['Activity']['assigned_to'];
                $modelActivity->is_completed        = $_POST['Activity']['is_completed'];
                $modelActivity->isActive            = "Y";
                $modelActivity->created_by          = Yii::app()->user->id;
                $modelActivity->updated_by          = 0;
                $modelActivity->created_date_time   = date("Y-m-d H:i:s");
                $modelActivity->updated_date_time   = "0000-00-00 00:00:00";
                $modelActivity->save(false);
                echo CJSON::encode( array('status' => 'success') );
            }
            else{
                $error = CActiveForm::validate($modelActivity, '', false);
                if ($error != '[]') {
                    echo $error;
                }
            }
            
            
        }
       public function actionIndexactivityfrom() {
        $modelactivity = new ActivityMasAddedFrom();
            
            $this->render('master_added_from', array('modelactivity' => $modelactivity));
    }

    public function actionGetListActivityfrom() {

        $modelactivity = new ActivityMasAddedFrom();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.id',
            1 => 'added_from',
            2 => 'code',
            3 => 'isActive',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = 't.isActive="Y"';
        if (isset($_POST['search']['value']) && $_POST['search']['value'] != "") {
            $searchString = $_POST['search']['value'];
            $condition .= " AND (added_from LIKE '%" . $searchString . "%')";
        }
        $count = $modelactivity->count(array('condition' => $condition));
        $modelactivity = $modelactivity->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));
        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();
        $m = 1;
        foreach ($modelactivity as $row) {


            $rowData[] = array($m,
                $row['added_from'],
                $row['code'],
                $row['id'],
                $row['isActive'],
            );

            $m++;
        }

        $data['data'] = $rowData;
        echo json_encode($data);
    }

    public function actionCreateActivityfrom() {
        $modelactivity = new ActivityMasAddedFrom();
        $id = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $modelactivity = $modelactivity->findByPk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);

        $this->renderPartial('master_added_from_create', array('modelactivity' => $modelactivity), false, true);
    }

    public function actionSaveActivityfrom() {
        $modelactivity = new ActivityMasAddedFrom();
        if (isset($_POST['ActivityMasAddedFrom'])) {

            if ((int) @$_POST['ActivityMasAddedFrom']['id'] > 0) {
                $id = (int) @$_POST['ActivityMasAddedFrom']['id'];
                $modelactivity = $modelactivity->findByPk($id);
            } else {

                $modelactivity->created_by = Yii::app()->user->id;
                $modelactivity->created_date_time = date("Y-m-d");
            }

            $modelactivity->attributes = $_POST['ActivityMasAddedFrom'];
            $modelactivity->updated_by = Yii::app()->user->id;
            $modelactivity->updated_date_time = date("Y-m-d");
            if ($modelactivity->save()) {


                $jsonData['status'] = 'success';
                //$jsonData['frm'] = $_POST['Song'];
                $jsonData['id'] = $modelactivity->id;
                echo CJSON::encode($jsonData);
            } else {
                $error = CActiveForm::validate($modelactivity, '', false);
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionDisableActivityfrom() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $modelactivity = new ActivityMasAddedFrom();
        $modelactivity = $modelactivity->findByPk($id);
        $modelactivity->isActive = ($status == "Y" ) ? "N" : "Y";
        $modelactivity->save();
        echo json_encode(array("status" => "success"));
    }
    
    public function actionGetActivityNote(){
        $modelActivity = new Activity();
        $id = Yii::app()->request->getparam('activity_id');
        $modelActivity = $modelActivity->findByPk($id);
        
        echo $modelActivity->notes;
        
      
    }
    
        
    
}