<!--
chart of accounts
Sataement  report
Date 28-12-2022
author -Indhu 
main setup
-->

<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }

    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }

    .to {
        background: rgb(31 103 178);
        color: White;
    }

    .tol1 {
        font-size: 16px !important;
    }

    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }

    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }

    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }

    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }

    .level-5 {
        padding-left: 267px !important;
    }

    .l1 {
        font-size: 17px !important;
    }

    .l2 {
        font-size: 16px !important;
    }

    .l3 {
        font-size: 15px !important;
    }

    .l4 {
        font-size: 14px !important;
    }

    .l5 {
        font-size: 14px !important;
    }

    .txt-right {
        text-align: right !important;
    }
</style>

<?php
$telenumber = "";
$fax = "";
$due_array = [];
$due_array["0-30"] = 0;
for ($index = 1; $index < 6; $index++) {
    $lower_limit = ($index * 30) + 1;
    $upper_limit = $lower_limit + 29;
    $label = "{$lower_limit}-{$upper_limit}";
    if (!isset($due_array[$label])) {
        $due_array[$label] = 0;
    }
}
$due_array[">180"] = 0;
?>

<?php
function generateUrlx($childModel)
{
    $url = '#'; // Default URL in case of errors
    // Check if $childModel, $childModel->parent, and $childModel->parent->vtype exist
    if (!$childModel || !$childModel->parent || !$childModel->parent->vtype) {
        return $url;
    }
    $code = $childModel->parent->vtype->code;
    $imported = $childModel->parent->imported;
    $baseUrl = "$('#liveSite').val() + 'index.php?r='"; // Base URL

    // If not imported
    if ($imported == 'N') {
        return "window.open($baseUrl + 'accounts/voucher/PrintvoucherPdf&id=" . $childModel->acc_voucher_id . "', '_blank');";
    }

    // Switch case for different voucher types
    switch ($code) {
        case 'SI':
            $headModel = $childModel->parent->vtype->header_table;

            // Simulate tax logic (replace with actual logic if needed)
            $tax = 1; // Default tax value
            $taxType = ($tax > 0) ? 'tax' : 'taxnil';
            return "window.open($baseUrl + 'invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . "&frm=" . $taxType . "&type=1', '_blank');";
        case 'PI':
            return "window.open($baseUrl + 'purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . "', '_blank');";
        case 'DN':
            return "window.open($baseUrl + 'debitnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
        case 'CN':
            return "window.open($baseUrl + 'creditnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
        default:
            // Default to voucher print if no matching code is found
            return "window.open($baseUrl + 'accounts/voucher/PrintvoucherPdf&id=" . $childModel->acc_voucher_id . "', '_blank');";
    }
}
?>
<table class="table table-fixed table-bordered table-primary dataTable html_table" id="gl_table" style="font-size:13px;">
    <thead>
        <tr>
            <th style="width:10%">Date</th>
            <th style="width:10%">Invoice No</th>
            <th style="width:10%">Voucher Type</th>
            <th style="width:10%">DO</th>
            <th style="width:10%">LPO</th>
            <th style="width:10%">Due Date</th>
            <th style="width:10%">Invoice value</th>
            <th style="width:10%">Paid</th>
            <th style="width:10%">Balance</th>
        </tr>
    </thead>
    <?php
    $items = array();

    $query = "
            CREATE OR REPLACE VIEW view_acc_statement AS            
            SELECT
                V.id AS voucher_id,
                V.voucher_date,
                V.due_date,
                V.reference_no,
                VI.narration,
                VI.id AS voucher_item_id,
                V.voucher_no,
                V.imported,
                SIGN(VI.amount) * ROUND(ABS(VI.amount * VI.exchange_rate), 4) AS amount,
                SIGN(VI.amount) * ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
                SIGN(VI.amount) * (ROUND(ABS(VI.amount * VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
            FROM
                erp_acc_voucher_items VI
            LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id
            LEFT JOIN erp_acc_allocation_items AI ON AI.voucher_item_id = VI.id
            WHERE
                V.is_posted = 'Y'
                AND V.voucher_date <='" . $to_date . "'
                AND VI.ledger_id = " . $ledger_id . "
                AND VI.subledger_id = " . $subledger_id . "
                AND VI.amount <> 0
            GROUP BY
                VI.id";
    // --------------------------------------------------------------------
    $opening_bal = '0.00';
    if ($ledger_id > 0 && $subledger_id > 0) {

        Yii::app()->db->createCommand($query)->execute();
        $opening_bal = '0.00';
        if ($from_date != '') {
            $opening_bal = Yii::app()->db->createCommand('SELECT SUM(balance) FROM view_acc_statement where balance!=0 and voucher_date<"' . $from_date . '" order by voucher_date')->queryScalar();
            $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement where balance!=0 and voucher_date>="' . $from_date . '" order by voucher_date')->queryAll();
        } else {
            $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement  where balance!=0  order by voucher_date')->queryAll();
        }
    }
    $amount = 0;
    $allocated = 0;
    $balanced = 0;

    $exchange_rate = 1;
    ?>
    <tbody>

        <?php
        $modelMasCurrency =  new MasCurrency();
        $amount += $opening_bal;
        $allocated += 0;
        $balanced += $opening_bal;


        ?>
        <?php if (!empty($items)) {
            $cumulativeBalance = 0;
            foreach ($items as $each) {


                // Graph Array Open
                $due_days = strtotime($each['voucher_date']);
                $due = round(abs(strtotime(date('Y-m-d')) - $due_days) / 86400);
                $array_slot = floor($due / 30);

                if ($array_slot == 0) {
                    if (!isset($due_array["0-30"])) {
                        $due_array["0-30"] = 0;
                    }
                    $due_array["0-30"] = $due_array["0-30"] + $each['balance'];
                } else if ($array_slot >= 6) {
                    if (!isset($due_array[">180"])) {
                        $due_array[">180"] = 0;
                    }
                    $due_array[">180"] = $due_array[">180"] + $each['balance'];
                } else {
                    $lower_limit = ($array_slot * 30) + 1;
                    $upper_limit = $lower_limit + 29;
                    $label = "{$lower_limit}-{$upper_limit}";
                    if (!isset($due_array[$label])) {
                        $due_array[$label] = 0;
                    }
                    $due_array[$label] = $due_array[$label] + $each['balance'];
                }
                // Graph Array Close
                
                $model_voucher_type = new AccVoucherType();
                if (round($each['balance'], 2) != 0) {

                    $do = '';
                    $lpo = '';
                    $inv_ref_no = '';
                    $ref = '';
                    $head = AccVoucher::model()->findByPk($each['voucher_id']);
                    $model_voucher_type_si = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
                    $model_voucher_type_pi = $model_voucher_type->find(array('condition' => 'code="PI"'))->id;


                    if ($type == 'customer') {
                        if (((int)$head->voucher_type == (int)$model_voucher_type_si) && $each['imported'] == 'Y') {
                            $inv = Invoice::model()->findByPk($head->transaction_id);
                            if ($inv) {
                                $do = $inv->delivery_ids;
                                $lpo = $inv->order_id;
                                $inv_ref_no = $inv->file_id;
                                $ref = $inv->id;
                            }
                        }
                    } else {

                        if (((int)$head->voucher_type == (int)$model_voucher_type_pi) && $each['imported'] == 'Y') {
                            $purchasingInvoice = PurchasingInvoice::model()->findByPk($head->transaction_id);
                            if ($purchasingInvoice) {
                                $inv_ref_no = $purchasingInvoice->invoice_no;
                                $ref = $purchasingInvoice->id;
                            }
                        }
                    }
                    $ref = empty($ref) ? $head->voucher_no : $ref;
                    // Format the voucher link
                    $vouchreformat = '<a href="#" onclick="' . generateUrlx(AccVoucherItems::model()->findByPk((int)$each['voucher_item_id'])) . '">' . $ref . '</a>';
                    // Ensure $inv_ref_no has a value
                    $inv_ref_no = empty($inv_ref_no) ? $head->voucher_no : $inv_ref_no;
                    $head = AccVoucher::model()->findByPk($each['voucher_id']);
                    $AccVoucherType = AccVoucherType::model()->findByPk($head->voucher_type)->description;

                    if (round($each['balance'], 2) != 0) {
                        // Rest of your code...
                        $cumulativeBalance += $each['balance'] / $exchange_rate;
                    }
        ?>
                    <tr>
                        <td><?php echo  date("d/m/Y", strtotime($each['voucher_date'])) ?></td>
                        <td><?php echo $vouchreformat; ?></td>
                        <td><?php echo $AccVoucherType; ?></td>
                        <td><?php echo $do; ?></td>
                        <td><?php echo $lpo; ?></td>
                        <td>
                            <?php echo ($each['due_date'] == '0000-00-00') ? '' : date("d/m/Y", timestamp: strtotime($each['due_date'])); ?>

                        </td>
                        <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($each['amount'] / $exchange_rate)); ?></td>
                        <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($each['allocated'] / $exchange_rate));  ?></td>
                        <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($cumulativeBalance));  ?></td>
                    </tr>
            <?php
                    $amount += $each['amount'] / $exchange_rate;
                    $allocated += $each['allocated'] / $exchange_rate;
                    $balanced += $each['balance'] / $exchange_rate;
                }
            } ?>
            <tr>
                <td colspan="6"></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($amount / $exchange_rate));  ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($allocated / $exchange_rate));  ?></td>
                <td style="text-align:right !important;"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(($balanced / $exchange_rate));  ?></td>

            </tr>
        <?php } else { ?>
            <tr>
                <td colspan="9" style="text-align:center !important;">No Data</td>
            </tr>

        <?php } ?>

    </tbody>

    <br>
    <div style="border: solid red 1px"> <br>
        <?php
        echo '<table id="tbl_reorder_level_table" class="table table-fixed table-bordered table-primary dataTable html_table"><thead><tr><th>Period</th>';
        foreach ($due_array as $key => $value) {
            echo '<th class="text-right">' . htmlentities($key) . '</th>';
        }
        echo '</tr></thead><tbody><tr><td>Amount</td>';
        foreach ($due_array as $key => $value) {
            echo '<td class="text-right">' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($value) . '</td>';
        }
        echo '</tr></tbody></table>'; ?>


        <!-------------------------------aging----------------------------------    -->

</table>