<!DOCTYPE html>
<html>

<head>
    <title>
        <?php
        echo "General Ledger Report"; ?>
    </title>


    <style type="text/css">
        table {
            font-family: arial, sans-serif !important;
            border-collapse: collapse !important;
            width: 100% !important;
        }

        td,
        th {
            border: 1px solid #dddddd !important;
            text-align: left !important;
            padding: 8px !important;
        }

        /* table th {
            padding-top: 12px;
            padding-bottom: 12px;
            text-align: left;
            background-color: #1f67b2;
            color: white;
        } */



        .level1 {
            background: #b4c6e7;
            color: black;
        }

        .to {
            background: rgb(31 103 178);
            color: White;
        }

        .tol1 {
            font-size: 16px !important;
        }

        .level-1 {
            padding-left: 5px !important;
            font-weight: bold;
        }

        .level-2 {
            padding-left: 50px !important;
            font-weight: bold;
        }

        .level-3 {
            padding-left: 104px !important;
            font-weight: bold;
        }

        .level-4 {
            padding-left: 197px !important;
            font-weight: bold;
        }

        .level-5 {
            padding-left: 267px !important;
        }

        .l1 {
            font-size: 17px !important;
        }

        .l2 {
            font-size: 16px !important;
        }

        .l3 {
            font-size: 15px !important;
        }

        .l4 {
            font-size: 14px !important;
        }

        .l5 {
            font-size: 14px !important;
        }

        .txt-right {
            text-align: right !important;
        }

        /*  .table-tree {
            width: 100%;
            text-align: left;
            padding-left: 10px !important;
            font-size: 12px;
            border-collapse: collapse;
            border-spacing: 0;
        }

        .table-tree th {
            padding-top: 5px;
            padding-bottom: 5px;
            border-top: 1px solid #000;
            border-bottom: 1px solid #000;
        }
 */
        .table-tree th,
        td {
            border-left: 0;
            border-right: 0;
            margin: 0;
            padding: 3px 5px;
        }

        .ze {
            background: #CCC
        }

        .box-pad,
        .box-pad * {
            -moz-box-sizing: border-box;
            -webkit-box-sizing: border-box;
            box-sizing: border-box;
        }

        .tre td {
            /*border:none;*/
        }

        .level-1 {
            padding-left: 5px !important;
        }

        .level-2 {
            padding-left: 20px !important;

        }

        .level-3 {
            padding-left: 35px !important;
        }

        .level-4 {
            padding-left: 55px !important;
        }

        .level-5 {
            padding-left: 80px !important;
        }

        .l1 {
            font-size: 12px !important;
        }

        .l2 {
            font-size: 11px !important;
            font-style: italic !important;
        }

        .l3 {
            font-size: 12px !important;
        }

        .l4 {
            font-size: 11px !important;
            font-style: italic;
        }

        .l5 {
            font-size: 10px !important;
            font-style: italic;
        }

        .txt-right {
            text-align: right !important;
        }

        .tittle {

            width: 100%;

            margin: 10px 0;

            float: left;

            text-align: center;



        }

        .tittle h6 {

            border-bottom: 2px solid #000;

            width: 150px;

            max-width: 400px;

            font-size: 16px;

            margin: 10px auto;

        }

        .date {
            width: 100%;
            float: left;
            font-size: 11px;
            padding-left: 5px;
            font-weight: 600;
            text-align: left;
            padding-bottom: 3px;
        }

        .date span {

            width: 200px;

            display: inline-block;

        }

        .clear {
            clear: both;
        }

        .cell-left {
            text-align: left !important;
        }

        .cell-right {
            text-align: right !important;
        }

        .br-top {
            border-top: 1px solid #000 !important;
            border-bottom: 3px double #000 !important;
        }

        .space {
            width: 100%;
            float: left;
            clear: both;
            height: 5px;
        }

        .col-6 {
            width: 50%;
        }

        .col-9 {
            width: 75%
        }

        .col-3 {
            width: 25%;
        }

        .f-l {
            float: left;
        }

        .f-r {
            float: right;
        }

        .txt-right {
            text-align: right !important;
        }

        .txt-left {
            text-align: left;
        }

        .x-space {
            box-sizing: border-box;
        }

        .bg-w {
            background: #FFF !important;
        }

        .footer {
            width: 100%;
            float: left;
            font-size: 11px;
            position: absolute;
            bottom: 0px;
            left: 0px;
            text-align: center !important;
            line-height: 18px;
            border-top: 1px dotted #000;
            padding: 5px;
        }

        .span1 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }

        .span2 {
            width: 80px !important;
            display: inline-block;
            float: left;
        }

        .span3 {
            width: auto !important;
            display: inline-block;
            float: left;
        }

        .pro {
            background: #ccffdf;
        }

        .loss {
            background: #ffb4b4;
        }

        .cy {
            background: #cdcdcd;
        }

        .py {
            background: #ececec;
        }

        .to {
            background: #f1f1f1;
        }
    </style>
</head>

<body>

<div class="container my-md-2 py-2" style="width:100%;float: right;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--   header -->
        <?php
        $this->renderPartial('//common/header'); ?>
        <!--   header -->
    </div>
    <div style="width:100%;float: left;margin-top: 10px;font-size:12px;font-family:'Times New Roman', Times, serif;">
        <!--add New Template-->
        <div class="">
            <div class="col-12">
                <div class="input-block">
                    <b><?php echo 'General Ledger Report'; ?></b>
                </div>
                <br> <br> <br>
                <?php $date_name = ($date_field == 'posted_date') ? 'Posted' :  'Voucher'; ?>

                <table class="table" style="font-size: 10px;">
                    <tr>
                        <td><b><?php echo $date_name; ?> From</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($from_date)); ?>
                        </td>

                        <td><b><?php echo $date_name; ?> To</b></td>
                        <td>
                            <?php echo date('d/m/Y', strtotime($to_date)); ?>
                        </td>

                        <td><b>Currency</b></td>
                        <td>
                            <?php
                            $modelMasCurrency =  new MasCurrency();
                            $modelMasCurrency = $modelMasCurrency->findByPk($currency);
                            echo $modelMasCurrency->currency_code; ?>
                        </td>
                    </tr>
                    <tr>

                        <td><b>Ledger</b></td>
                        <td>
                            <?php
                            $modelAccLedger =  new AccLedger();
                            $modelAccLedger = $modelAccLedger->findByPk($ledger_id);
                            echo $modelAccLedger->ledger_acc_name; ?>

                        </td>

                        <td><b>Subledger</b></td>
                        <td  colspan="2">
                            <?php
                            $modelAccSubledger =  new AccSubledger();
                            $modelAccSubledger = $modelAccSubledger->findByPk($subledger);
                            echo $modelAccSubledger->subledger_name; ?>




                        </td>

                        <?php if((int)$outlet_id>0){ ?>
                        <tr>
                            <td><b>Outlet</b></td>
                            <td  colspan="5">
                                <?php
                                if ((int)$outlet_id == 0) {
                                    echo 'All Outlet';
                                } else {
                                    $modelMasOutlet = new MasOutlet();
                                    $modelMasOutlet = $modelMasOutlet->findBypk((int)$outlet_id);
                                    echo $modelMasOutlet->outlet_name;
                                }
                                ?>
                            </td>
                        </tr>
                    <?php } ?>
                    <?php if((int)$warehouse_id>0){ ?>
                    <tr>
                         
                        <td><b>Warehouse</b></td>
                        <td  colspan="5">
                            <?php
                             if ((int)$warehouse_id == 0) {
                                echo 'All Warehouse';
                            } else {
                                $modelMasInventoryWarehouse = new MasInventoryWarehouse();
                                $modelMasInventoryWarehouse = $modelMasInventoryWarehouse->findBypk((int)$warehouse_id);
                                echo $modelMasInventoryWarehouse->warehouse_name;
                            } 
                            ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php if((int)$department_id>0){ ?>
                    <tr>
                         
                        <td><b>Department</b></td>
                        <td colspan="5">
                            <?php
                             if ((int)$department_id == 0) {
                                echo 'All Department';
                            } else {
                                $modelMasDepartment = new MasDepartment();
                                $modelMasDepartment = $modelMasDepartment->findBypk((int)$department_id);
                                echo $modelMasDepartment->department_name;
                            } 
                            ?>
                        </td>
                    </tr>
                    <?php } ?>
                    
                    <?php 
                 
                    
                    if((int)$brand>0){ ?>
                    <tr>
                         
                        <td><b>Brand</b></td>
                        <td colspan="5">
                            <?php
                             if ((int)$brand == 0) {
                                echo 'All Brands';
                            } else {
                                $modelProductClass = new ProductClass();
                                $modelProductClass = $modelProductClass->findBypk((int)$brand);
                                echo $modelProductClass->product_class;
                            } 
                            ?>
                        </td>
                    </tr>
                    <?php } ?>
                    </tr>
                </table>
            </div>

        </div>
        <br>
        <?php

        $baseUrl = Yii::app()->baseUrl;
        $cur = MasCurrency::model()->findByPk(1);
        $exchange_rate = $cur->exchange_rate;
        
        $condition = 'parent.is_posted="Y" AND t.amount != 0 AND DATE(parent.' . $date_field . ') >= "' . $from_date . '" AND DATE(parent.' . $date_field . ')<= "' . $to_date . '"';

        $condition_for_opening = 'H.is_posted="Y" AND DATE(H.' . $date_field . ') < "' . $from_date . '"';
        
        if ($ledger_id > 0) {
            $condition .= ' AND t.ledger_id IN(' . $ledger_id . ')';
            $condition_for_opening .= ' AND I.ledger_id IN(' . $ledger_id . ')';
        }

        if ($subledger > 0) {
            $condition .= ' AND t.subledger_id=' . $subledger;
            $condition_for_opening .= ' AND I.subledger_id=' . $subledger;
        }

        // -------------------------------

       
        if ($warehouse_id > 0) {
            $condition .= " AND t.warehouse_id = '" . $warehouse_id . "'";
            $condition_for_opening .= ' AND I.warehouse_id=' . $warehouse_id;
        }
        if ((int)$outlet_id > 0) {
            $condition .= " AND t.outlet_id = '" . $outlet_id . "'";
            $condition_for_opening .= ' AND I.outlet_id=' . $outlet_id;
        }
    
        if ((int)$brand>0) {
            $condition .= "AND  t.brand_id = '" . $brand . "'";
            $condition_for_opening .= ' AND I.brand_id=' . $brand;
        }
     
        if ((int)$department_id>0) {
            $condition .= "AND  t.department_id = '" . $department_id . "'";
            $condition_for_opening .= ' AND I.department_id=' . $department_id;
        }

     

        $cur = MasCurrency::model()->findByPk($currency);
        $exchange_rate = $cur->exchange_rate;


        // $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE   ' . $condition_for_opening . ' ')->queryScalar();
        // $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*I.exchange_rate)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE   ' . $condition_for_opening . ' ')->queryScalar();

        $openingBalance1 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();
        $openingBalance2 = Yii::app()->db->createCommand('SELECT ROUND((SUM(I.amount*H.exchange_rate)), 4) AS amount FROM {{acc_voucher_items}} I LEFT JOIN {{acc_voucher}} H ON I.acc_voucher_id = H.id WHERE I.currency_id!=' . $currency . ' AND ' . $condition_for_opening . ' ')->queryScalar();




        $openingBalance = $openingBalance1 + ($openingBalance2 / $exchange_rate);


        $previousBalance = $openingBalance;



        $closingBalance = $openingBalance;
        $symbol = ($previousBalance > 0) ? 'Dr' : 'Cr';

        if ($previousBalance > 0) {
            $dbt_previousBalance = $previousBalance;
        }
        if ($previousBalance < 0) {
            $cr_previousBalance = $previousBalance;
        }
        $modelMasCurrency =  new MasCurrency();
        $modelAccVoucherItems = new AccVoucherItems();

        $items = $modelAccVoucherItems->with('parent')->findAll(array('condition' => $condition, 'order' => 'parent.voucher_date ASC'));


        // --------------------------------


        // --------------------------------



        ?>
        <table class="table table-hover table-fixed table-bordere" id="tb_table" style="font-size: 11px;">
            <!-- <table class="table-tree"> -->
            <thead>
                <tr class="to tol1">
                    <th>SL.No</th>


                    <th>Voucher Date</th>
                    <th>Posted Date</th>

                    <th>VO #</th>
                    <th>Trans #</th>
                    <th>Ledger</th>
                    <th>Subledger</th>
                    <th class="txt-right">Debit</th>
                    <th class="txt-right">Credit</th>
                    <th class="txt-right">Balance</th>
                    <th>Narration</th>
                </tr>
            </thead>
            <tbody>
                <tr style=" background: #c3c8d1">

                    <td colspan="7" style="text-align:right "><b>Opening Balance</b></td>
                    <td style="text-align:right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($dbt_previousBalance) ; ?></td>
                    <td style="text-align:right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($cr_previousBalance)) ; ?></td>
                    <td style="text-align:right"><?php echo  $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($previousBalance)) . ' ' . $symbol; ?></td>
                    <td></td>

                </tr>
                <?php
                $parent = 1;
                $total_debit = $total_credit = $closingBalance = 0;
                foreach ($items as $key => $each) {


                    /*   $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : 0;
            $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : 0;

            $debit = ($currency == $each->currency_id) ? $debit / $each->exchange_rate : $debit / $exchange_rate;
            $credit = ($currency == $each->currency_id) ? $credit / $each->exchange_rate : $credit / $exchange_rate;

            $running = $debit - $credit + $previousBalance;
            $previousBalance = $running;
            $symbol = ($running > 0) ? 'Dr' : 'Cr';
            $closingBalance += ($debit - $credit);

            $total_debit += $debit;
            $total_credit += $credit;
            
        

            if ($each->amount > 0) {
                $running = $debit - $credit + $previousBalance;
            }

            if ($each->amount < 0) {

                $running = $credit - $debit + $previousBalance;
            }

            if ($running > 0) {
                $symbol = 'Dr';
            }
            if ($running < 0) {
                $symbol = 'Cr';
            }


            $previousBalance = $running;*/
                    // -----------------------------------------------------------------------

                    $debit = $each['debit'];
                    $credit = $each['credit'];


                    $debit = ($each->amount > 0) ? round(($each->amount * $each->exchange_rate), 4) : 0;
                    $credit = ($each->amount < 0) ? round(abs($each->amount * $each->exchange_rate), 4) : 0;

                    $debit = ($currency == $each->currency_id) ? $debit / $each->exchange_rate : $debit / $exchange_rate;
                    $credit = ($currency == $each->currency_id) ? $credit / $each->exchange_rate : $credit / $exchange_rate;


                    $running = $debit - $credit + $previousBalance;
                    $previousBalance = $running;
                    $symbol = ($running > 0) ? 'Dr' : 'Cr';


                    $total_debit += $debit;
                    $total_credit += $credit;


                    // --------------------------------------------------------------------------







                    $vouchreformat = '<a href="' . $baseUrl . '/index.php?r=accounts/voucher/PrintvoucherPdf&id=' . (int) $each->acc_voucher_id . '" target="_blank">' . $each->parent->fullvoucher . '</a>';
                    $subledgerName = ($each->subledger_id > 0) ? $each->subledger->subledger_name : '';
                ?>
                    <tr data-id="<?php echo $parent; ?>" data-parent="0">
                        <td><?php echo $key + 1; ?></td>
                        <td style="cursor:pointer">
                            <i class="fa fa-plus" onclick="clickFunc(<?php echo $row_id; ?>,<?php echo $each->acc_voucher_id ?>,<?php echo $each->id ?>,<?php echo $currency; ?>,<?php echo $each->currency_id; ?>,<?php echo $each->exchange_rate; ?>,<?php echo $exchange_rate; ?>)"></i>

                            <?php echo ($each->parent->voucher_date == '0000-00-00' || $each->parent->voucher_date == '30/11/-0001') ? "-" : date('d/m/Y', strtotime($each->parent->voucher_date)); ?>
                        </td>

                        <td><?php echo ($each->parent->posted_date == '0000-00-00 00:00:00' || $each->parent->posted_date == '30/11/-0001') ? "-" : date('d/m/Y H:i:s', strtotime($each->parent->posted_date)); ?> </td>


                        <td><?php echo  $each->parent->fullvoucher; ?></td>
                        <td style="text-align:right"><?php echo $each->parent->transaction_number; ?></td>
                        <td><?php echo $each->ledger->ledger_acc_name; ?></td>
                        <td><?php echo $subledgerName; ?></td>
                        <td style="text-align:right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debit); ?></td>
                        <td style="text-align:right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit)); ?></td>
                        <td style="text-align:right"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($running)). " " . $symbol; ?></td>
                        <td><small><?php echo $each->narration . ' - ' . $each->warehouse->warehouse_name; ?></small></td>
                    </tr>
                    <?php
                    $eachItem = AccVoucherItems::model()->with('parent')->findAll(array('condition' => 't.acc_voucher_id="' . (int) $each->acc_voucher_id . '" AND t.id != "' . (int) $each->id . '"', 'order' => 'parent.voucher_date ASC', 'limit' => 1));

                    $child = $parent + 1;
                    foreach ($eachItem as $eachLine) {
                        $subledgerName = ($eachLine->subledger_id > 0) ? $eachLine->subledger->subledger_name : '';
                        if ($eachLine->amount > 0) {
                            if ($currency == $eachLine->parent->currency_id) {
                                $debit = $eachLine->amount / $exchange_rate;
                            } else {
                                $debit = $eachLine->amount;
                            }
                        } else {
                            $debit = 0;
                        }
                        if ($eachLine->amount < 0) {
                            if ($currency == $eachLine->parent->currency_id) {
                                $credit = $eachLine->amount / $exchange_rate;
                            } else {
                                $credit = $eachLine->amount;
                            }
                        } else {
                            $credit = 0;
                        }
                    ?>

                <?php
                        $child++;
                        $parent = $child;
                    }
                    //$parent++;
                }
                $closingBalance = abs($total_debit + $dbt_previousBalance) - (abs($total_credit) + abs($cr_previousBalance));
                $symbol = ($closingBalance > 0) ? 'Dr' : 'Cr';
                ?>
                <tr>
                    <td colspan="7" style="text-align:right"><b>Total</b></td>
                    <td style="text-align:right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_debit + $dbt_previousBalance)); ?></b></td>
                    <td style="text-align:right"><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($total_credit) + abs($cr_previousBalance)); ?></b></td>

                    <td></td>
                    <td></td>
                </tr>
                <tr style=" background: #c3c8d1">
                    <td colspan="7" style="text-align:right ;"><b>Closing Balance</b></td>
                    <td colspan="3" style="text-align:right "><b><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($closingBalance))  . ' ' . $symbol; ?></b></td>

                    <td></td>

                </tr>
            </tbody>
        </table>



        <?php $this->renderPartial("//common/footer");?>

</body>

</html>