<head>
  <title>title</title>
  <style>
    table {
      border-collapse: collapse;
    }

    th,
    td {
      mso-border: solid thin black;
      mso-border-alt: solid thin black;
    }

    .txt-right {
      text-align: right !important;
    }

    .text-left {
      text-align: left;
    }
  </style>
</head>

<?php
$modelMasCurrency =  new MasCurrency();
$decimal_no = $modelMasCurrency->baseCurrencyForExcel(); ?>

<table border="1">
    <thead>

        <tr>
            <th colspan="10">
                <?php
                $modelCompany =  MasCompany::model()->find();

                echo $modelCompany->company_name;
                ?>
            </th>
        </tr>
      
        <tr style="">
            <th style="color: white ;background-color:#696969;" colspan="10">
                <?php
                $type_det     = ($type == 'customer') ? 'CUSTOMER STATEMENT' : 'VENDOR STATEMENT';
                echo $type_det;  ?>
            </th>
        </tr>

        <tr>
            <td  colspan="4"><b>From</b></td>
            <td colspan="6" class="text-left">
                <?php echo date('d/m/Y', strtotime($from_date)); ?>
            </td>
        </tr> 

        <tr>
            <td  colspan="4"><b>To</b></td>
            <td colspan="6" class="text-left">
                <?php echo date('d/m/Y', strtotime($to_date)); ?>
            </td>
        </tr> 
  
        <tr></tr>      
        <tr>
            <th style="width:10%">Date</th>
            <th style="width:10%">Invoice No</th>
            <th style="width:10%">Inv Ref No</th>
            <th style="width:10%">Voucher Type</th>
            <th style="width:10%">DO</th>
            <th style="width:10%">LPO</th>
            <th style="width:10%">Due Date</th>
            <th style="width:10%">Invoice value</th>
            <th style="width:10%">Paid</th>
            <th style="width:10%">Balance</th>
        </tr>
    </thead>
    <?php
    $items = array();
    $query = "
    CREATE OR REPLACE VIEW view_acc_statement AS                        
    SELECT
        V.id AS voucher_id,
        V.voucher_date,
        V.due_date,
        V.reference_no,
        VI.narration,
        VI.id AS voucher_item_id,
        V.voucher_no,
        V.imported,
        SIGN(VI.amount) * ROUND(ABS(VI.amount * VI.exchange_rate), 4) AS amount,
        SIGN(VI.amount) * ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
        SIGN(VI.amount) * (ROUND(ABS(VI.amount * VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
    FROM
        erp_acc_voucher_items VI
    LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id
    LEFT JOIN erp_acc_allocation_items AI ON AI.voucher_item_id = VI.id
    WHERE
        V.is_posted = 'Y'
        AND V.voucher_date <='" . $to_date . "'
        AND VI.ledger_id = " . $ledger_id . "
        AND VI.subledger_id = " . $subledger_id . "
        AND VI.amount <> 0
    GROUP BY
        VI.id";


    $opening_bal = '0.00';
    if ($ledger_id > 0 && $subledger_id > 0) {

        Yii::app()->db->createCommand($query)->execute();
        $opening_bal = '0.00';
        if ($from_date != '') {
            $opening_bal = Yii::app()->db->createCommand('SELECT SUM(balance) FROM view_acc_statement where balance!=0 and voucher_date<"' . $from_date . '" order by voucher_date')->queryScalar();
            $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement where balance!=0 and voucher_date>="' . $from_date . '" order by voucher_date')->queryAll();
        } else {
            $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement  where balance!=0  order by voucher_date')->queryAll();
        }
    }
    $amount = 0;
    $allocated = 0;
    $balanced = 0;

    ?>
    <tbody>
        <tr style="background: #c3c8d1;">
            <td colspan="7" class="text-center" style="text-align:center ;"><b>Opening Balance</b></td>
            <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo number_format(($opening_bal / $exchange_rate), 2); ?></td>
            <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo  number_format((0 / $exchange_rate)); ?></td>
            <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo number_format(($opening_bal / $exchange_rate)); ?></td>
        </tr>
        <?php
        $amount += $opening_bal;
        $allocated += 0;
        $balanced += $opening_bal;
        ?>
        <?php if (!empty($items)) {

            $model_voucher_type = new AccVoucherType();
            foreach ($items as $each) {
                if (round($each['balance'], 2) != 0) {
                    $do = '';
                    $lpo = '';

                    $do = '-';
                    $lpo = '-';
                    $inv_ref_no = '';
                    $ref = '';

                    $head = AccVoucher::model()->findByPk($each['voucher_id']);

                    $model_voucher_type_si = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
                    $model_voucher_type_pi = $model_voucher_type->find(array('condition' => 'code="PI"'))->id;
                    if ($type == 'customer') {
                        if (((int)$head->voucher_type == (int)$model_voucher_type_si) && $each['imported'] == 'Y') {
                            $inv = Invoice::model()->findByPk($head->transaction_id);
                            if ($inv) {
                                $do = $inv->delivery_ids;
                                $lpo = $inv->order_id;
                                $inv_ref_no = $inv->file_id;
                                $ref = $inv->id;
                            }
                        }
                    } else {

                        if (((int)$head->voucher_type == (int)$model_voucher_type_pi) && $each['imported'] == 'Y') {
                            $purchasingInvoice = PurchasingInvoice::model()->findByPk($head->transaction_id);
                            if ($purchasingInvoice) {
                                $inv_ref_no = $purchasingInvoice->invoice_no;
                                $ref = $purchasingInvoice->id;
                            }
                        }
                    }
                    $ref = empty($ref) ? $head->voucher_no : $ref;
                    // Format the voucher link
                    // Ensure $inv_ref_no has a value
                    $inv_ref_no = empty($inv_ref_no) ? $head->voucher_no : $inv_ref_no;
                    $head = AccVoucher::model()->findByPk($each['voucher_id']);
                    $AccVoucherType = AccVoucherType::model()->findByPk($head->voucher_type)->description;
        ?>
                    <tr>
                        <td>
                            <?php echo  date("d/m/Y", strtotime($each['voucher_date'])) ?>
                        </td>
                        <td><?php echo $ref; ?></td>
                        <td><?php echo $inv_ref_no; ?></td>
                        <td><?php echo $AccVoucherType; ?></td>
                        <td><?php echo $do; ?></td>
                        <td><?php echo $lpo; ?></td>
                        <td>
                            <?php echo ($each['due_date'] == '0000-00-00') ? '' : date("d/m/Y", strtotime($each['due_date'])); ?>
                            <?php //echo ($each['voucher_date'] == '0000-00-00') ? '' : date("d/m/Y", timestamp: strtotime($each['voucher_date'])); ?>
                        </td>
                        <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"> <?php echo number_format(($each['amount'] / $exchange_rate), 2); ?></td>
                        <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo number_format(($each['allocated'] / $exchange_rate), 2); ?></td>
                        <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo number_format(($each['balance'] / $exchange_rate), 2); ?></td>
                    </tr>
            <?php
                    $amount += $each['amount'] / $exchange_rate;
                    $allocated += $each['allocated'] / $exchange_rate;
                    $balanced += $each['balance'] / $exchange_rate;
                }
            } ?>
            <tr>
                <td colspan="7"></td>
                <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo number_format(($amount / $exchange_rate), 2); ?></td>
                <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo number_format(($allocated / $exchange_rate), 2); ?></td>
                <td class="txt-right"  style="mso-number-format: '<?php echo $decimal_no; ?>';"><?php echo number_format(($balanced / $exchange_rate), 2); ?></td>
            </tr>
        <?php } else { ?>
            <tr>
                <td colspan="8" style="text-align:center !important;">No Data</td>
            </tr>

        <?php } ?>

    </tbody>

</table>