<!DOCTYPE html>
<html lang="en">

<body>

    <?php

    function printArrow($val)
    {
        $line = "";
        if ($val > 0) {
            $line = '<span  style="font-size: 9px;color: green;" class="deltas" style="color: rgb(0.255.0);"><svg xmlns="http://www.w3.org/2000/svg" width="10" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="19" x2="12" y2="5"></line><polyline points="5 12 12 5 19 12"></polyline></svg>' . ($val) . '%' . '</span>';
        } else if ($val < 0) {
            $line = '<span style="font-size: 9px; color: rgb(255, 7, 58);" class="deltas" style="color: rgb(0, 255, 0);"><svg xmlns="http://www.w3.org/2000/svg" width="10" height="12" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><polyline points="19 12 12 19 5 12"></polyline></svg>' . ($val) . '%' . '</span>';
        } else {
            $line = '';
        }
        return $line;
    }
    ?>

    <?php
    $monthNames = [
        'Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun',
        'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'
    ];
    ?>
    <div class="table-responsive">
        <table class="table table-hover table-bordered" style="min-width:2000px;overflow-x:scroll;" id="tbl_monthwise_budgeting">
            <thead>
                <tr style="background-color: #0e4279; color: white;">
                    <th style="text-align: center;width: 10%;">Year/Month</th>
                    <?php
                    // Display month column headings
                    foreach ($monthNames as $month) {
                        echo '<th style="text-align: center; width: 5%;">' . $month . '</th>';
                    }
                    echo '<th style="text-align: center; width: 10%;">Total</th>'; // Add Total column heading
                    ?>
                </tr>
            </thead>
            <tbody>
                <?php

                // Display rows for each year
                $currentYear = date('Y');
                for ($i = -2; $i <= 0; $i++) {
                    $year = $currentYear + $i;
                    echo '<tr>';
                    echo '<td style="background-color: #d9ebfc;"><b>' . ($year) . '</b></td>';

                    // Display cells for each month
                    $rowTotal = 0; // Initialize row total
                    foreach ($monthNames as $month) {

                        $startDate = $year . '-' . sprintf('%02d', array_search($month, $monthNames) + 1) . '-01';
                        $endDate = date('Y-m-t', strtotime($startDate));
                        $sqlCreateView = "SELECT ledger_id, SUM(credit) as sum_credit, SUM(debit) as sum_debit ,sum(VI.amount) as sum_amount
                    FROM {{acc_voucher}} V
                    LEFT JOIN {{acc_voucher_items}} VI ON VI.acc_voucher_id = V.id
                    WHERE `voucher_date` BETWEEN '$startDate' AND '$endDate' AND V.is_posted ='Y' AND VI.ledger_id = $ledger_id
                    GROUP BY VI.ledger_id";

                        $data = Yii::app()->db->createCommand($sqlCreateView)->queryRow();
                        $amount = $data['sum_amount'];
                        $rowTotal += $amount; // Add to row total

                        echo '<td style="text-align: right"> ' . number_format((float)$amount, 2, '.', '') . '</td>';
                    }

                    // Display Total column for the row
                    echo '<td style="text-align: right"><b>' . number_format((float)$rowTotal, 2, '.', '') . '</b></td>';

                    echo '</tr>';

                    if ($currentYear == $year) {
                        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE 'budgeting_ledger_data'")->queryScalar();
                        $tablestorebalance = 0;
                        if ($tableExists) {
                            $sqlbalance = Yii::app()->db->createCommand("SELECT balance_{$year} as balance  FROM `budgeting_ledger_data` WHERE id = '" . $ledger_id . "'")->queryRow();
                            $tablestorebalance = $sqlbalance['balance'];
                        }
                        echo '<tr>';
                        echo '<td style="background-color: #d9ebfc;"><b>' . $year . ' Budget</b></td>';
                        // Display cells for each month
                        $rowBudgetTotal = 0; // Initialize budget row total
                        foreach ($monthNames as $month) {
                            $budgetData = ((float)$tablestorebalance > 0) ? $tablestorebalance / 12 : 0;
                            $rowBudgetTotal += $budgetData; // Add to budget row total
                            echo '<td style="text-align: right"> ' .
                                number_format((float)$budgetData, 2, '.', '') . '</td>';
                        }

                        // Display Total column for the budget row
                        echo '<td style="text-align: right"><b>' .
                            number_format((float)$rowBudgetTotal, 2, '.', '')  . '</b></td>';

                        echo '</tr>';
                    }


                    if ($currentYear == $year) {

                        echo '<tr>';
                        echo '<td style="background-color: #d9ebfc;"><b>' . $year . ' Varience</b></td>';
                        // Display cells for each month
                        $rowvarTotal = 0; // Initialize budget row total
                        foreach ($monthNames as $month) {


                            $startDate = $year . '-' . sprintf('%02d', array_search($month, $monthNames) + 1) . '-01';
                            $endDate = date('Y-m-t', strtotime($startDate));
                            $sqlCreateView = "SELECT ledger_id, SUM(credit) as sum_credit, SUM(debit) as sum_debit ,
                        sum(VI.amount) as sum_amount
                        FROM {{acc_voucher}} V
                        LEFT JOIN {{acc_voucher_items}} VI ON VI.acc_voucher_id = V.id
                        WHERE `voucher_date` BETWEEN '$startDate' AND '$endDate' AND V.is_posted ='Y' AND VI.ledger_id = $ledger_id
                        GROUP BY VI.ledger_id";

                            $data = Yii::app()->db->createCommand($sqlCreateView)->queryRow();
                            $amount = $data['sum_amount'];
                            $var = 0;
                            if ($amount > 0) {
                                $var =  (((float)$amount - (float)$budgetData) / (float)$amount) * 100;
                                $var = number_format((float)$var, 2, '.', '');
                            }
                            if ($amount < 0) {
                                $var =  (((float)$amount - (float)$budgetData) / (float)$amount) * 100;
                                $var = number_format((float)$var, 2, '.', '');
                            }


                            $varData = (float)(float)$amount - $budgetData;
                            $rowvarTotal += $varData; // Add to budget row total

                            echo '<td style="text-align: right"> 
                        <div class="pull-left">' . printArrow((float)$var) . '</div>
                        ' .
                                number_format((float)$varData, 2, '.', '') . '</td>';
                        }

                        // Display Total column for the budget row
                        echo '<td style="text-align: right"><b>' .
                            number_format((float)$rowvarTotal, 2, '.', '') . '</b></td>';

                        echo '</tr>';
                    }
                }
                ?>

            </tbody>
        </table>
    </div>
</body>

</html>