<?php

/**
 * This is the model class for table "{{acc_security_cheque}}".
 *
 * The followings are the available columns in table '{{acc_security_cheque}}':
 * @property integer $id
 * @property string $transaction_type
 * @property string $bank_name
 * @property string $cheque_payee
 * @property string $cheque_no
 * @property string $cheque_date
 * @property string $cheque_amount
 * @property string $transaction_date
 * @property integer $transaction_done_by
 * @property integer $transaction_return_by
 * @property string $transaction_return_date
 * @property integer $created_by
 * @property string $created_date_time
 * @property integer $updated_by
 * @property string $updated_date_time
 * @property string $isActive
 */
class SecurityCheque extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{acc_security_cheque}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('transaction_type, bank_name, cheque_no, cheque_amount, transaction_date, transaction_done_by', 'required'),
			array('transaction_done_by, transaction_return_by, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('transaction_type, isActive', 'length', 'max'=>1),
			array('bank_name, cheque_payee', 'length', 'max'=>700),
			array('cheque_no', 'length', 'max'=>500),
			array('cheque_amount', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, transaction_type, bank_name, cheque_payee, cheque_no, cheque_date, cheque_amount, transaction_date, transaction_done_by, transaction_return_by, transaction_return_date, created_by, created_date_time, updated_by, updated_date_time, isActive', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
                    'transactionby' => array(self::BELONGS_TO, 'User', 'transaction_done_by'),
                    'transactionreturnby' => array(self::BELONGS_TO, 'User', 'transaction_return_by'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'transaction_type' => 'I-Issued,R-Received',
			'bank_name' => 'Bank Name',
			'cheque_payee' => 'Cheque Payee',
			'cheque_no' => 'Cheque No',
			'cheque_date' => 'Cheque Date',
			'cheque_amount' => 'Cheque Amount',
			'transaction_date' => 'Transaction Date',
			'transaction_done_by' => 'Transaction Done By',
			'transaction_return_by' => 'Transaction Return By',
			'transaction_return_date' => 'Transaction Return Date',
			'created_by' => 'Created By',
			'created_date_time' => 'Created Date Time',
			'updated_by' => 'Updated By',
			'updated_date_time' => 'Updated Date Time',
			'isActive' => 'Is Active',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('transaction_type',$this->transaction_type,true);
		$criteria->compare('bank_name',$this->bank_name,true);
		$criteria->compare('cheque_payee',$this->cheque_payee,true);
		$criteria->compare('cheque_no',$this->cheque_no,true);
		$criteria->compare('cheque_date',$this->cheque_date,true);
		$criteria->compare('cheque_amount',$this->cheque_amount,true);
		$criteria->compare('transaction_date',$this->transaction_date,true);
		$criteria->compare('transaction_done_by',$this->transaction_done_by);
		$criteria->compare('transaction_return_by',$this->transaction_return_by);
		$criteria->compare('transaction_return_date',$this->transaction_return_date,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_date_time',$this->created_date_time,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_date_time',$this->updated_date_time,true);
		$criteria->compare('isActive',$this->isActive,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return SecurityCheque the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
}
