<?php
/* Voucher Type
 author -Indhu 
 main setup
 Tables - erp_acc_voucher_type_details
 Controller - VouchertypesController */


/**
 * This is the model class for table "erp_acc_voucher_type_details".
 *
 * The followings are the available columns in table 'erp_acc_voucher_type_details':
 * @property integer $id
 * @property integer $voucher_type_id
 * @property integer $ledger_id
 * @property integer $subledger_id
 * @property string $default_type
 * @property string $subledger_type
 * @property string $voucher_type_code
 * @property string $narration
 * @property string $attribute
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class AccVoucherTypeDetails extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */

    public $ledger_name;
    public $subledger_name;
    public $debit;
    public $credit;
    public $year;
    public $com_id;
    public $branch_id;
    public $salegrp_id;
    public $brand_id;
    public $emp_id;
    public $dept_id;
    public $cc_id;
    public $cat_id;
    public $project_id;
    public $item;
     public $warehouse_id;
     public $costcenter_id;
     public $outlet_id;
     public $department_id;

    public function tableName()
    {
         return '{{acc_voucher_type_details}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('voucher_type_id,attribute,ledger_id,subledger_type', 'required'),
            array('voucher_type_id, ledger_id, subledger_id, created_by, updated_by', 'numerical', 'integerOnly' => true),
            array('default_type,subledger_type', 'length', 'max' => 1),
            array('narration', 'length', 'max' => 5000),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, voucher_type_id,voucher_type_code,ledger_id, subledger_id, default_type,subledger_type,narration,attribute,created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public $product_name;
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(

            'ledger' => array(self::BELONGS_TO, 'AccSubledger', 'ledger_id'),

        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'voucher_type_id' => 'Voucher Type',
            'attribute' => 'Attribute',
            'ledger_id' => 'Ledger',
            'subledger_id' => 'Subledger',
            'default_type' => 'Default Type',
            'subledger_type' => 'Subledger Type',
            'narration' => 'Narration',
            'created_by' => 'Created By',
            'created_datetime' => 'Created Datetime',
            'updated_by' => 'Updated By',
            'updated_datetime' => 'Updated Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('voucher_type_id', $this->voucher_type_id);
        $criteria->compare('ledger_id', $this->ledger_id);
        $criteria->compare('subledger_id', $this->subledger_id);
        $criteria->compare('default_type', $this->default_type, true);
        $criteria->compare('subledger_type', $this->subledger_type, true);
        $criteria->compare('narration', $this->narration, true);
        $criteria->compare('attribute', $this->attribute, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('created_datetime', $this->created_datetime, true);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('updated_datetime', $this->updated_datetime, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccVoucherTypeDetails the static model class
     */
    public static function model($className = __CLASS__)
    {
        return parent::model($className);
    }
}
