<?php

/* AccSystemAccountsMapping
 author -Indhu 
 main setup
 View - accounts/accounts/system_mapping.php
 Controller - AccountsController
 */

/**
 * This is the model class for table "{{acc_system_accounts_mapping}}".
 *
 * The followings are the available columns in table '{{acc_system_accounts_mapping}}':
 * @property integer $id
 * @property string $attribute
 * @property string $description
 * @property string $account_id
 * @property integer $subledger_id
 * @property integer $modified_by
 * @property string $modified_date_time
 * @property integer $last_account_id
 */
class AccSystemAccountsMapping extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    public function tableName()
    {
        return '{{acc_system_accounts_mapping}}';
    }
	public $ledger_name;
    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('account_id', 'required'),
            array('subledger_id, modified_by, last_account_id', 'numerical', 'integerOnly'=>true),
            array('attribute, description', 'length', 'max'=>255),
            array('account_id', 'length', 'max'=>20),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, attribute, description, account_id, subledger_id, modified_by, modified_date_time, last_account_id', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'attribute' => 'Attribute',
            'description' => 'Description',
            'account_id' => 'Account',
            'subledger_id' => 'Subledger',
            'modified_by' => 'Modified By',
            'modified_date_time' => 'Modified Date Time',
            'last_account_id' => 'Last Account',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('attribute',$this->attribute,true);
        $criteria->compare('description',$this->description,true);
        $criteria->compare('account_id',$this->account_id,true);
        $criteria->compare('subledger_id',$this->subledger_id);
        $criteria->compare('modified_by',$this->modified_by);
        $criteria->compare('modified_date_time',$this->modified_date_time,true);
        $criteria->compare('last_account_id',$this->last_account_id);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccSystemAccountsMapping the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }

	public static function getSystemdefault19_06_2024( $attribute ){
		return self::model()->find( array( 'condition' => 'attribute="'.$attribute.'"' ) )->account_id;
	}
	
	public static function getSystemdefault( $attribute ){
        $model = self::model()->find(array('condition' => 'attribute="'.$attribute.'"'));
        return $model ? $model->account_id : 0; // Return 0 if $model is null
    }

	public static function getSystemdefault_subledger( $attribute ){
		return self::model()->find( array( 'condition' => 'attribute="'.$attribute.'"' ) )->subledger_id;
	}

	public static function getAllaccVoucherMasterSettings(){
		$condition = '1=1';
		$model = self::model()->findAll(array('condition' => $condition, 'order' => 'id'));
		return CHtml::listData($model, 'attribute', 'description');
	}


}