<?php

/*
  chart of accounts
  payment mode, Save
  date 18-11-2022
  author -Indhu
  main setup
  Tables    - acc_payment_mode
  Controller used   - PaymentlmodeController

 */

/**
 * This is the model class for table "{{acc_payment_mode}}".
 *
 * The followings are the available columns in table '{{acc_payment_mode}}':
 * @property integer $id
 * @property string $mode
 * @property string $bank_name
 * @property string $card_no
 * @property string $cheque_no
 * @property string $cheque_date
 * @property string $reference_no
 * @property string $isActive
 * @property integer $created_by
 * @property integer $updated_by
 * @property string $created_datetime
 * @property string $updated_datetime
 */
class AccPaymentMode extends CActiveRecord {

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return '{{acc_payment_mode}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('mode,code,ledger_id', 'required'),
            array('created_by,subledger_id,ledger_id,updated_by, sort_order', 'numerical', 'integerOnly' => true),
            array('mode,classification', 'length', 'max' => 255),
            array('code', 'unique'),
            array('bank_name, card_no, cheque_no, cheque_date, reference_no, isActive,discount, show_in_pos', 'length', 'max' => 1),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id,code,mode,classification,ledger_id,bank_name, card_no, cheque_no, cheque_date, reference_no, isActive, created_by, updated_by, created_datetime, updated_datetime', 'safe', 'on' => 'search'),
        );
    }

    public $ledger_name;
    public $subledger_name;

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'ledger' => array(self::BELONGS_TO, 'AccLedger', 'ledger_id'),
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'id' => 'ID',
            'ledger_id' => 'Ledger',
            'mode' => 'Mode',
            'bank_name' => 'Bank Name',
            'card_no' => 'Card No',
            'cheque_no' => 'Cheque No',
            'cheque_date' => 'Cheque Date',
            'reference_no' => 'Reference No',
            'isActive' => 'Is Active',
            'created_by' => 'Created By',
            'updated_by' => 'Updated By',
            'created_datetime' => 'Created Datetime',
            'updated_datetime' => 'Updated Datetime',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search() {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('id', $this->id);
        $criteria->compare('mode', $this->mode, true);
        $criteria->compare('bank_name', $this->bank_name, true);
        $criteria->compare('card_no', $this->card_no, true);
        $criteria->compare('cheque_no', $this->cheque_no, true);
        $criteria->compare('cheque_date', $this->cheque_date, true);
        $criteria->compare('reference_no', $this->reference_no, true);
        $criteria->compare('isActive', $this->isActive, true);
        $criteria->compare('created_by', $this->created_by);
        $criteria->compare('updated_by', $this->updated_by);
        $criteria->compare('created_datetime', $this->created_datetime, true);
        $criteria->compare('updated_datetime', $this->updated_datetime, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccPaymentMode the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    public static function getAccPaymentModes() {

        $condition = 't.isActive =  "Y"';
        $model = self::model()->findAll(array('condition' => $condition, 'order' => 'id'));
        return CHtml::listData($model, 'id', 'mode');
    }
    
    	public static function getPaymentmodeledger( $code ){
		return self::model()->find( array( 'condition' => 'code="'.$code.'"' ) )->ledger_id;
	}
	
		public static function getPaymentmodesubledger( $code ){
		return self::model()->find( array( 'condition' => 'code="'.$code.'"' ) )->subledger_id;
	}
	
		public static function getPaymentmodeid( $code ){
		return self::model()->find( array( 'condition' => 'code="'.$code.'"' ) )->id;
	}
	
      public static function getAccPaymentModesWithledger($ledger_id = 0) {
        // Get the currency ID for the provided ledger ID
        $sql = "SELECT L.currency_id FROM erp_acc_ledger L WHERE L.id = :ledger_id";
        $commandcur = Yii::app()->db->createCommand($sql);
        $commandcur->bindParam(":ledger_id", $ledger_id, PDO::PARAM_INT);
        $curr = $commandcur->queryRow();
    
        if (!$curr) {
            return [];
        }
    
        // Get the list of active payment modes
        $sqlmain = "SELECT * FROM erp_acc_payment_mode WHERE isActive = 'Y'";
        $commandmain = Yii::app()->db->createCommand($sqlmain);
        $list = $commandmain->queryAll(); // Changed queryRow to queryAll to get all active payment modes
    
        $arraymodes = [];
    
        foreach ($list as $row) {
            // Get the currency ID for each payment mode's ledger ID
            $sqlchild = "SELECT L.currency_id,L.ledger_acc_no,L.ledger_acc_name  FROM erp_acc_ledger L WHERE L.id = :ledger_id";
            $commandchild = Yii::app()->db->createCommand($sqlchild);
            $commandchild->bindParam(":ledger_id", $row['ledger_id'], PDO::PARAM_INT);
            $currchild = $commandchild->queryRow();
    
            if ($currchild && $currchild['currency_id'] == $curr['currency_id']) {
                $modelMasCurrency = new MasCurrency();
                $currency = $modelMasCurrency->findByPk($curr['currency_id']);
                if ($currency) {
                    $row['mode'] .= ' - ' . $currchild['ledger_acc_name'] . ' - ' . $currency->currency_code;
                    $arraymodes[] = $row;
                }
            }
        }
    
        return CHtml::listData($arraymodes, 'id', 'mode');
    }
    
   public static function getPaymentmodeledgers($mode_id)
{
    $mode_det = self::model()->find(array(
        'condition' => 'id = "' . $mode_id . '"'
    ));

    if (!$mode_det) {
        return array(); // mode not found
    }

    $classification = $mode_det->classification; 
    $ledger_id = $mode_det->ledger_id; 
    $mode_ledger_Det = null;

    if ((int)$ledger_id > 0) {
        $mode_ledger_Det = AccLedger::model()->find(array(
            'condition' => 'id = "' . $ledger_id . '"'
        ));
    }

    $ledger_list = array();

    if (!empty($classification)) {
        $ledger_list = AccLedger::model()->findAll(array(
            'condition' => 'classification = "' . $classification . '"'
        ));
    }

    // Add $mode_ledger_Det if not already in $ledger_list
    if ($mode_ledger_Det) {
        $exists = false;
        foreach ($ledger_list as $ledger) {
            if ($ledger->id == $mode_ledger_Det->id) {
                $exists = true;
                break;
            }
        }

        if (!$exists) {
            $ledger_list[] = $mode_ledger_Det;
        }
    }

    return CHtml::listData($ledger_list, 'id', 'ledger_acc_name');
}




}
