<?php

/**
 * This is the model class for table "{{acc_audit_close_details}}".
 *
 * The followings are the available columns in table '{{acc_audit_close_details}}':
 * @property integer $id
 * @property integer $audit_close_id
 * @property integer $ledger_id
 * @property string $ledger_acc_no
 * @property string $ledger_acc_name
 * @property string $ledger_acc_type
 * @property string $balance
 * @property string $ledger_main_acc
 * @property string $ledger_parent_acc
 * @property integer $root
 * @property integer $level
 * @property string $is_parent
 * @property integer $transaction_count
 * @property string $is_active
 * @property integer $created_by
 * @property string $created_datetime
 * @property integer $updated_by
 * @property string $updated_datetime
 */
class AccAuditCloseDetails extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return '{{acc_audit_close_details}}';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('audit_close_id, ledger_id, ledger_acc_no, ledger_acc_name, ledger_acc_type, balance, created_by, created_datetime', 'required'),
			array('audit_close_id, ledger_id, root, level, transaction_count, created_by, updated_by', 'numerical', 'integerOnly'=>true),
			array('ledger_acc_name', 'length', 'max'=>200),
			array('ledger_acc_type, is_active', 'length', 'max'=>1),
			array('balance', 'length', 'max'=>15),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('id, audit_close_id, ledger_id, ledger_acc_no, ledger_acc_name, ledger_acc_type, balance, ledger_main_acc, ledger_parent_acc, root, level, is_parent, transaction_count, is_active, created_by, created_datetime, updated_by, updated_datetime', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		    'ledger' => array(self::BELONGS_TO, 'AccLedger', 'ledger_id'),
		    'auditclose' => array(self::BELONGS_TO, 'AccAuditClose', 'audit_close_id'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id' => 'ID',
			'audit_close_id' => 'Audit Close',
			'ledger_id' => 'Ledger',
			'ledger_acc_no' => 'Ledger Acc No',
			'ledger_acc_name' => 'Ledger Acc Name',
			'ledger_acc_type' => 'Ledger Acc Type',
			'balance' => 'Balance',
			'ledger_main_acc' => 'Ledger Main Acc',
			'ledger_parent_acc' => 'Ledger Parent Acc',
			'root' => 'Root', 
			'level' => 'Level', 
			'is_parent' => 'Is Parent', 
			'transaction_count' => 'Transcation Count',
			'is_active' => 'Is Active',
			'created_by' => 'Created By',
			'created_datetime' => 'Created Datetime',
			'updated_by' => 'Updated By',
			'updated_datetime' => 'Updated Datetime',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('id',$this->id);
		$criteria->compare('audit_close_id',$this->audit_close_id);
		$criteria->compare('ledger_id',$this->ledger_id);
		$criteria->compare('ledger_acc_no',$this->ledger_acc_no,true);
		$criteria->compare('ledger_acc_name',$this->ledger_acc_name,true);
		$criteria->compare('ledger_acc_type',$this->ledger_acc_type,true);
		$criteria->compare('balance',$this->balance,true);
		$criteria->compare('ledger_main_acc',$this->ledger_main_acc,true);
		$criteria->compare('ledger_parent_acc',$this->ledger_parent_acc,true);
		$criteria->compare('root',$this->root,true);
		$criteria->compare('level',$this->level,true);
		$criteria->compare('is_parent',$this->is_parent,true);
		$criteria->compare('transaction_count',$this->transaction_count,true);
		$criteria->compare('is_active',$this->is_active,true);
		$criteria->compare('created_by',$this->created_by);
		$criteria->compare('created_datetime',$this->created_datetime,true);
		$criteria->compare('updated_by',$this->updated_by);
		$criteria->compare('updated_datetime',$this->updated_datetime,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return AccAuditCloseDetails the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
	
	public static function getAllLedgerWithAuditCloseDetails($acc_auditclose_date_id, $type = '')
	{
	    if (empty($acc_auditclose_date_id)) return;
	    $auditCloseLedgerResults = array();
	    $condition = "";
	    if ($type == 'B') {
	        $condition = "ledger_acc_type IN ('B') AND";
	    } else if ($type == 'P') {
	        $condition = "ledger_acc_type IN ('P') AND";
	    }
	    $ledgerResults = AccLedger::model()->findAll(array( 'condition' => "ledger_main_acc IN ('A','L','I','E','AP')", 'order' => 't.ledger_acc_no asc'));
	    $auditCloseResults = self::model()->findAll(array('condition' => $condition." t.audit_close_id = ".$acc_auditclose_date_id, 'order' => 't.ledger_acc_no asc'));
	    if($auditCloseResults) {
	        foreach ($auditCloseResults as $auditCloseResult){
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['id'] = $auditCloseResult['id'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['audit_close_id'] = $auditCloseResult['audit_close_id'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_id'] = $auditCloseResult['ledger_id'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_acc_no'] = $auditCloseResult['ledger_acc_no'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_acc_name'] = $auditCloseResult['ledger_acc_name'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_acc_type'] = $auditCloseResult['ledger_acc_type'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['balance'] = $auditCloseResult['balance'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['amount'] = $auditCloseResult['amount'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['opening'] = $auditCloseResult['opening'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['debit'] = $auditCloseResult['debit'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['credit'] = $auditCloseResult['credit'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_main_acc'] = $auditCloseResult['ledger_main_acc'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['ledger_parent_acc'] = $auditCloseResult['ledger_parent_acc'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['root'] = $auditCloseResult['root'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['level'] = $auditCloseResult['level'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['is_parent'] = $auditCloseResult['is_parent'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['transaction_count'] = $auditCloseResult['transaction_count'];
	            $auditCloseLedgerResults[$auditCloseResult['ledger_id']]['is_active'] = $auditCloseResult['is_active'];
	        }
	    }
	    return $auditCloseLedgerResults;
	}
}
