<?php

/**
 * This is the model class for table "{{acc_allocation_items}}".
 *
 * The followings are the available columns in table '{{acc_allocation_items}}':
 * @property integer $id
 * @property integer $allocation_id
 * @property integer $allocation_date
 * @property integer $ledger_id
 * @property integer $subledger_id
 * @property integer $total_amount
 * @property integer $voucher_type
 * @property integer $reference_id
 * @property integer $customer_vendor_id
 * @property integer $voucher_id
 * @property integer $voucher_item_id
 * @property integer $amount
 * @property integer $created_by
 * @property integer $created_date_time
 */
class AccAllocationItems extends CActiveRecord
{
    /**
     * @return string the associated database table name
     */
    
    public function tableName()
    {
        return '{{acc_allocation_items}}';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules()
    {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('allocation_id, allocation_date, ledger_id, subledger_id, total_amount, voucher_type, reference_id, customer_vendor_id, voucher_id, voucher_item_id, amount, created_by, created_date_time', 'required'),
            array('allocation_id, allocation_date, ledger_id, subledger_id, total_amount, voucher_type, reference_id, customer_vendor_id, voucher_id, voucher_item_id, amount, created_by, created_date_time', 'numerical', 'integerOnly'=>true),
            // The following rule is used by search().
            // @todo Please remove those attributes that should not be searched.
            array('id, allocation_id, allocation_date, ledger_id, subledger_id, total_amount, voucher_type, reference_id, customer_vendor_id, voucher_id, voucher_item_id, amount, created_by, created_date_time', 'safe', 'on'=>'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations()
    {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
            'ledger_det' => array(self::BELONGS_TO, 'AccLegder', 'ledger_id'),
			'subledger_det' => array(self::BELONGS_TO, 'AccSubledger', 'subledger_id'),
            'voucher_det' => array(self::BELONGS_TO, 'AccVoucher', 'voucher_id'),
        
			'parent' => array(self::BELONGS_TO, 'AccAllocation', 'allocation_id'),
            'voucheritems' => array(self::BELONGS_TO, 'AccVoucherItems', 'voucher_item_id'),

			
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels()
    {
        return array(
            'id' => 'ID',
            'allocation_id' => 'Allocation',
            'allocation_date' => 'Allocation Date',
            'ledger_id' => 'Ledger',
            'subledger_id' => 'Subledger',
            'total_amount' => 'Total Amount',
            'voucher_type' => 'Voucher Type',
            'reference_id' => 'Reference',
            'customer_vendor_id' => 'Customer Vendor',
            'voucher_id' => 'Voucher',
            'voucher_item_id' => 'Voucher Item',
            'amount' => 'Amount',
            'created_by' => 'Created By',
            'created_date_time' => 'Created Date Time',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     *
     * Typical usecase:
     * - Initialize the model fields with values from filter form.
     * - Execute this method to get CActiveDataProvider instance which will filter
     * models according to data in model fields.
     * - Pass data provider to CGridView, CListView or any similar widget.
     *
     * @return CActiveDataProvider the data provider that can return the models
     * based on the search/filter conditions.
     */
    public function search()
    {
        // @todo Please modify the following code to remove attributes that should not be searched.

        $criteria=new CDbCriteria;

        $criteria->compare('id',$this->id);
        $criteria->compare('allocation_id',$this->allocation_id);
        $criteria->compare('allocation_date',$this->allocation_date);
        $criteria->compare('ledger_id',$this->ledger_id);
        $criteria->compare('subledger_id',$this->subledger_id);
        $criteria->compare('total_amount',$this->total_amount);
        $criteria->compare('voucher_type',$this->voucher_type);
        $criteria->compare('reference_id',$this->reference_id);
        $criteria->compare('customer_vendor_id',$this->customer_vendor_id);
        $criteria->compare('voucher_id',$this->voucher_id);
        $criteria->compare('voucher_item_id',$this->voucher_item_id);
        $criteria->compare('amount',$this->amount);
        $criteria->compare('created_by',$this->created_by);
        $criteria->compare('created_date_time',$this->created_date_time);

        return new CActiveDataProvider($this, array(
            'criteria'=>$criteria,
        ));
    }

    /**
     * Returns the static model of the specified AR class.
     * Please note that you should have this exact method in all your CActiveRecord descendants!
     * @param string $className active record class name.
     * @return AccAllocationItems the static model class
     */
    public static function model($className=__CLASS__)
    {
        return parent::model($className);
    }
}