<?php

/*
 chart of accounts
 voucher Create, Save
 date 21-09-2022
 author -Nisha
 updated by - indhu

 main setup
 
 Main Tables - erp_acc_voucher,erp_acc_voucher_items
 linked tables - erp_acc_voucher_type,erp_mas_currency,
				 erp_mas_payment_term,erp_user,erp_mas_acc_comapny,erp_mas_acc_branch,erp_ws_project,
				 erp_hr_department,erp_hr_employee,
 Main models used - AccVoucher,AccVoucherItems

 */

class VoucherController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array(
                    'Index',
                    'GetList',
                    'GetDetailedList',
                    'Create',
                    'Save',
                    'getVoucherData',
                    'SaveVoucher',
                    'Postvoucher',
                    'GetcurrencyexchangeRate',
                    'Subledgerlist',
                    'Gettotalcheck',
                    'DeleteVoucher',
                    'Updatevoucher',
                    'GetvoucherList',
                    'Removelineitem',
                    'Add_payment',
                    'Add_receipt',
                    'GetProducts',
                    'PrintvoucherPdf',
                    'Importvouchers',
                    'Getimportvouchers',
                    'GetImportSalesList',
                    'GetImportPurchaseList',
                    'GetImportCreditNoteList',
                    'GetImportDebitNoteList',
                    'GetImportGoodsissueList',
                    'GetImportGoodsreceiptList',
                    'add_commission',
                    'get_commissionemployee',
                    'GetallocationdataFromPayment',
                    'GetallocationdataFromReceiptDebit',
                    'GetallocationdataFromReceiptCredit',
                    'VouchersExcel',
                    'GetImportVoucherList',
                    'PrintPaymentReciptvoucherPdf',
                    'GetExchangeRateFromExchangeMaster',
                    'GetMultipleExchangeRates',
                    'GetallocationdataFromPaymentCredit',
                    'GetallocationdataFromPaymentDebit',
                    'UploadVouchers',
                    'DownloadVouchersFormat',
                    'VouchersUpload',
                    'SaveUploadVouchersList',
                    'DownloadErrorCsv'
                ),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }


    // public $modelMasCurrency;

    // public function init()
    // {
    //     // parent::init();
    //     $this->modelMasCurrency = new MasCurrency();
    // }

    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_vouchers_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_vouchers_menu_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
		}


    public function actionGetList()
    {
        $modelMasCurrency = new MasCurrency();
        $model = new AccVoucher();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $voucher_type = $_POST['voucher_type'];
        $post_status = $_POST['post_status'];
        $import = $_POST['import'];
        $columns = array(
            0 => 'voucher_no',
            1 => 'file_id',
            2 => 'transaction_number',
            3 => 'reference_no',
            4 => 'voucher_date',
            5 => 'voucher_type',
            6 => 'warehouse_name',
            7 => 'imported',           
            8 => 'net_amount',
            9 => 'id',           
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';

        if ((int)$voucher_type > 0) {
            $condition .= " AND voucher_type_id = " . $voucher_type;
        }

        if ($_POST['voucher_date_from'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_from'])));
            $condition .= ' AND voucher_date>="' . $start_date . '" ';
        }
        if ($_POST['voucher_date_to'] != '') {
            $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_to'])));
            $condition .= ' AND voucher_date<="' . $end_date . '" ';
        }

        if (!empty($post_status)) {
            if ($post_status == 'Y') {
                $condition .= ' AND is_posted= "Y"';
            } else {
                $condition .= ' AND is_posted= "N"';
            }
        }

        if (!empty($import)) {
            if ($import == 'Y') {
                $condition .= ' AND imported= "Y"';
            } else {
                $condition .= ' AND imported= "N"';
            }
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition .= ' AND (voucher_no LIKE "%' . $searchString . '%"
                OR voucher_type LIKE "%' . $searchString . '%"
                OR file_id LIKE "%' . $searchString . '%"
                OR transaction_number LIKE "%' . $searchString . '%"
                OR code LIKE "%' . $searchString . '%"             
                OR reference_no LIKE "%' . $searchString . '%" 
                OR net_amount LIKE "%' . $searchString . '%")';
        }
    
        $query = 'SELECT id,voucher_no,code,is_posted,is_allocated,imported,(case when (transaction_number > 0) then transaction_number else "-" end) AS transaction_number,(case when (file_id > 0) then file_id else "-" end) AS file_id,
        reference_no,voucher_type,net_amount,voucher_date,warehouse_name,outlet_id,outlet_name FROM view_acc_voucher_wo_ledger WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_acc_voucher_wo_ledger WHERE ' . $condition . ' ')->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $eachItem) {
            $eachItem['file_id'] == 0 ? $file_id = '-' : $file_id = $eachItem['file_id'];
            $eachItem['transaction_number'] == 0 ? $transaction_number = '-' : $transaction_number = $eachItem['transaction_number'];
            $imported = ($eachItem['imported'] == "Y") ? 'Yes' : 'No';
            $net_amount = $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['net_amount']);
            $temp_det = '';
            $temp_det_status = 'N';
            /* if (!empty($eachItem['subledger_id'])) {
                $sql = "SELECT *  FROM {{ch_template}} WHERE `bank_id` IN (" . $eachItem['subledger_id'] . ")";
                $temp_det          = Yii::app()->db->createCommand($sql)->queryAll();
            }
            if ((!empty($temp_det))) {
                $temp_det_status = 'Y';
            } */

            $rowData[] = array(
                $eachItem['code'] . "/" . $eachItem['voucher_no'], //0
                $file_id, //1
                $transaction_number, //2
                $eachItem['reference_no'], //3
                (!empty($eachItem['voucher_date'])) ? date('d/m/Y', strtotime($eachItem['voucher_date'])) : "-", //4
                $eachItem['voucher_type'], //5
                $eachItem['warehouse_name'], //6
                $imported, //7             
                $net_amount, //8
                array( //9
                    'id'                => $eachItem['id'],
                    'voucher_no_code'   => $eachItem['code'] . "/" . $eachItem['voucher_no'],
                    'posted'            => $eachItem['is_posted'],
                    'voucher_no'        => $eachItem['voucher_no'],
                    'is_allocated'      => $eachItem['is_allocated'],
                    'pv_rv_pdf'         => $eachItem['pv_rv_pdf'],
                    'voucher_type_code' => $eachItem['code'],
                    'imported'          => $eachItem['imported'],
                    'temp_det_status'          => $temp_det_status,
                ),
            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }


    public function actionGetDetailedList()
    {
        $modelMasCurrency = new MasCurrency();
        $model = new AccVoucher();
        $draw = $_POST['draw'];
        $offset = $_POST['start'];
        $limit = $_POST['length'];
        $voucher_type = $_POST['voucher_type'];
        $post_status = $_POST['post_status'];
        $import = $_POST['import'];
        $columns = array(
            0 => 'voucher_no',
            1 => 'file_id',
            2 => 'transaction_number',
            3 => 'reference_no',
            4 => 'voucher_date',
            5 => 'voucher_type',
            6 => 'warehouse_name',
            7 => 'imported',
            8 => 'ledger_name',
            9 => 'subledger_name',
            10 => 'net_amount',
            11 => 'id',
            12 => 'id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder = $_POST['order'][0]['dir'];
        $orderBy = $filterColumn . " " . $filterOrder;
        $condition = '1=1';

        if ((int)$voucher_type > 0) {
            $condition .= " AND voucher_type_id = " . $voucher_type;
        }

        if ($_POST['voucher_date_from'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_from'])));
            $condition .= ' AND voucher_date>="' . $start_date . '" ';
        }
        if ($_POST['voucher_date_to'] != '') {
            $end_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['voucher_date_to'])));
            $condition .= ' AND voucher_date<="' . $end_date . '" ';
        }

        if (!empty($post_status)) {
            if ($post_status == 'Y') {
                $condition .= ' AND is_posted= "Y"';
            } else {
                $condition .= ' AND is_posted= "N"';
            }
        }

        if (!empty($import)) {
            if ($import == 'Y') {
                $condition .= ' AND imported= "Y"';
            } else {
                $condition .= ' AND imported= "N"';
            }
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition .= ' AND (voucher_no LIKE "%' . $searchString . '%"
                OR voucher_type LIKE "%' . $searchString . '%"
                OR file_id LIKE "%' . $searchString . '%"
                OR transaction_number LIKE "%' . $searchString . '%"
                OR code LIKE "%' . $searchString . '%"
                OR subledger_name LIKE "%' . $searchString . '%" 
                OR ledger_name LIKE "%' . $searchString . '%" 
                OR reference_no LIKE "%' . $searchString . '%" 
                OR net_amount LIKE "%' . $searchString . '%")';
        }
        $query = 'SELECT id,subledger_id,voucher_no,pv_rv_pdf,code,is_posted,outlet_name,outlet_id,is_allocated,imported,transaction_number,file_id,reference_no,voucher_type,ledger_name,subledger_name,net_amount,voucher_date,warehouse_name,warehouse_id FROM view_acc_voucher_items WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset;
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_acc_voucher_items WHERE ' . $condition)->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();

        $recordsTotal = $count;
        $recordsFiltered = $count;
        $data['draw'] = $draw;
        $data['recordsTotal'] = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $rowData = array();

        foreach ($model as $eachItem) {
            $eachItem['file_id'] == 0 ? $file_id = '-' : $file_id = $eachItem['file_id'];
            $eachItem['transaction_number'] == 0 ? $transaction_number = '-' : $transaction_number = $eachItem['transaction_number'];
            $imported = ($eachItem['imported'] == "Y") ? 'Yes' : 'No';
            $net_amount = $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['net_amount']);


            $temp_det = '';
            $temp_det_status = 'N';
            if (!empty($eachItem['subledger_id'])) {
                $sql = "SELECT *  FROM {{ch_template}} WHERE `bank_id` IN (" . $eachItem['subledger_id'] . ")";
                $temp_det          = Yii::app()->db->createCommand($sql)->queryAll();
            }
            if ((!empty($temp_det))) {
                $temp_det_status = 'Y';
            }


            $rowData[] = array(
                $eachItem['code'] . "/" . $eachItem['voucher_no'],
                $file_id,
                $transaction_number,
                $eachItem['reference_no'],
                (!empty($eachItem['voucher_date'])) ? date('d/m/Y', strtotime($eachItem['voucher_date'])) : "-",
                $eachItem['voucher_type'],
                $eachItem['warehouse_name'],
                $imported,
                $eachItem['ledger_name'],
                $eachItem['subledger_name'],
                $net_amount,
                array(
                    'id'                => $eachItem['id'],
                    'voucher_no_code'   => $eachItem['code'] . "/" . $eachItem['voucher_no'],
                    'posted'            => $eachItem['is_posted'],
                    'voucher_no'        => $eachItem['voucher_no'],
                    'is_allocated'      => $eachItem['is_allocated'],
                    'pv_rv_pdf'         => $eachItem['pv_rv_pdf'],
                    'voucher_type_code' => $eachItem['code'],
                    'imported'          => $eachItem['imported'],
                    'temp_det_status'          => $temp_det_status,
                ),


            );
        }
        $data['data'] = $rowData;
        echo json_encode($data);
    }





    public function actionCreate()
    {
        $model          = new AccVoucher();
        $modelItems     = array(new AccVoucherItems());
        $id             = (int)Yii::app()->request->getParam('id');
        $frm            = Yii::app()->request->getParam('frm');
        if ($id > 0) {
            $model      = $model->findBypk($id);
            $modelItems = AccVoucherItems::model()->with('ledger', 'subledger')->findAll(array('condition' => 'acc_voucher_id="' . $id . '"'));
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('voucher_new_create', array('model' => $model, 'modelItems' => $modelItems, 'frm' => $frm));
    }


    public function actionSaveVoucher()
    {
        $modelVoucher      = new AccVoucher();
        $modelVoucherItems = array(new AccVoucherItems());
        $error1   = array();
        $error2   = array();
        $error3   = array();
        $error    = array();
        $other    = array();
        $validate = true;

        $tot_debit = 0;


        if (isset($_POST['AccVoucher'])) {
            $modelVoucher->created_by       = Yii::app()->user->id;
            $modelVoucher->created_datetime = date('Y-m-d h:i:s');
            $modelVoucher->updated_by       = Yii::app()->user->id;
            $modelVoucher->updated_datetime = date('Y-m-d h:i:s');

            if (isset($_POST['AccVoucher']['id']) && $_POST['AccVoucher']['id'] > 0) {
                $id = $_POST['AccVoucher']['id'];

                $modelVoucher                   = $modelVoucher->findByPk($id);
                $modelVoucher->updated_by       = Yii::app()->user->id;
                $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
                $audit_type = 'UPDATED';
            } else {
                $audit_type = 'CREATED';
            }
            $modelVoucher->attributes        = $_POST['AccVoucher'];
            $modelVoucher->general_narration = $_POST['AccVoucher']['general_narration'];
            $modelVoucher->imported = 'N';
            if ($modelVoucher->isNewRecord) {
                $modelVoucher->voucher_no    = AccVoucherType::getVoucherno($modelVoucher->voucher_type, true);
            }

            if ($_POST['AccVoucher']['voucher_date'] != '' && $_POST['AccVoucher']['voucher_date'] != '0000-00-00') {
                $modelVoucher->voucher_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['voucher_date'])));
            } else {
                $modelVoucher->voucher_date = date("Y-m-d");
            }
            $usermodel                           = new user();
            $modelVoucher->transaction_number    =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_id        =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_date      =  $modelVoucher->voucher_date;
            $modelVoucher->lead_owner            = (int)Yii::app()->user->id;
            if ($_POST['AccVoucher']['cheque_date'] != '' && $_POST['AccVoucher']['cheque_date'] != '0000-00-00') {
                $modelVoucher->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['cheque_date'])));
            }

            $commingfrom        = $_POST['AccVoucher']['commingfrom'];
            if ($commingfrom == 'copynewvoucher') {
                $modelVoucher->is_allocated = 'N';
                $modelVoucher->allocation_date = '0000-00-00';
            }

            $validate = $modelVoucher->validate();


            //   ---------------------AccAuditClose check------------------------------------
            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastFinalClosedDate());
            $voucher_date = strtotime($modelVoucher->voucher_date);
            if ($voucher_date <= $existing_date) {
                $validate = false;
                $other[] = ' Given Voucher date must be Greater than Final Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastFinalCloseddate()))) . '';
            } else {
                $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
                $voucher_date = strtotime($modelVoucher->voucher_date);
                if ($voucher_date <= $existing_date) {
                    if (!(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"]) || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"]))) {
                        $validate = false;
                        $other[] = ' Given Voucher date must be Greater than Pre Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                    }
                }
            }
            //   --------------------//-AccAuditClose check------------------------------------   
            // -------------------to check and save costcenter-------------------------------------------------
            $costcenter_1 = $costcenter_2 = 'N';

            $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
            if ($tableExists) {
                $acc_settings = Yii::app()->db->createCommand()
                    ->select('costcenter_1, costcenter_2')
                    ->from('{{acc_general_settings}}')
                    ->queryRow();

                $costcenter_1 = $acc_settings['costcenter_1'];
                $costcenter_2 = $acc_settings['costcenter_2'];
            }

            $costcenterMapping = [
                'BRANCH' => ['key' => 'warehouse_id', 'message' => 'Branch cannot be null'],
                'OUTLET' => ['key' => 'outlet_id', 'message' => 'Outlet cannot be null'],
                'DEPARTMENT' => ['key' => 'department_id', 'message' => 'Department cannot be null'],
            ];

            // -------------------// to check and save costcenter-------------------------------------------------

            if (is_array($_POST['AccVoucherTypeDetails'])) {
                $checkcredit =  $checkdebit = 0;
                foreach ($_POST['AccVoucherTypeDetails'] as $i => $TypeDetails) {
                    $modeltype[$i]                   = new AccVoucherItems();
                    $modeltype[$i]->attributes       = $TypeDetails;
                    $modeltype[$i]->created_by       = Yii::app()->user->id;
                    $modeltype[$i]->created_datetime = date('Y-m-d H:i:s');
                    $modeltype[$i]->ledger_id        = $TypeDetails['ledger_id'];
                    // ----------------------
                    if ((int)$TypeDetails['ledger_id'] > 0) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($TypeDetails['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ((int)$TypeDetails['subledger_id'] <= 0) {
                                $validate = false;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }
                    // ----------------------
                    $modeltype[$i]->subledger_id     = $TypeDetails['subledger_id'];
                    $modeltype[$i]->narration        = ($TypeDetails['narration'] == '') ? $modelVoucher->general_narration : $TypeDetails['narration'];
                    $modeltype[$i]->debit            = $TypeDetails['debit'];
                    $modeltype[$i]->credit           = $TypeDetails['credit'];
                    $modeltype[$i]->acc_voucher_id   = 0;
                    $modeltype[$i]->year             = $TypeDetails['year'];
                    $modeltype[$i]->company_id       = $TypeDetails['com_id'];
                    $modeltype[$i]->branch_id        = $TypeDetails['branch_id'];
                    $modeltype[$i]->salegroup_id     = $TypeDetails['salegrp_id'];
                    $modeltype[$i]->brand_id         = $TypeDetails['brand_id'];
                    $modeltype[$i]->employee_id      = $TypeDetails['emp_id'] ? $TypeDetails['emp_id'] : '000';
                    $modeltype[$i]->department_id    = $TypeDetails['dept_id'] ? $TypeDetails['dept_id'] : '00';
                    $modeltype[$i]->costcenter_id    = $TypeDetails['cc_id'];
                    $modeltype[$i]->project_id       = $TypeDetails['project_id'] ? $TypeDetails['project_id'] : '0000';
                    $modeltype[$i]->generic_id       = $TypeDetails['cat_id'];
                    $modeltype[$i]->product_id       = $TypeDetails['item'] ? $TypeDetails['item'] : '0000';
                    $modeltype[$i]->warehouse_id     = $TypeDetails['warehouse_id'];

                    // ----------------------
                    if ($TypeDetails['debit'] > 0) {
                        $modeltype[$i]->amount = $TypeDetails['debit'];
                        $checkdebit += abs($TypeDetails['debit']);
                    } else {
                        $modeltype[$i]->amount = -1 * (float)$TypeDetails['credit'];
                    }


                    if ($commingfrom == 'copynewvoucher') {
                        $modeltype[$i]->allocated_amount = 0;
                        $modeltype[$i]->allocate_ids     = '';
                    }

                    // -------------------to check and save costcenter-------------------------------------------------
                    if (isset($costcenterMapping[$costcenter_1]) && (int)$TypeDetails[$costcenterMapping[$costcenter_1]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_1]['message'];
                    }

                    if (isset($costcenterMapping[$costcenter_2]) && (int)$TypeDetails[$costcenterMapping[$costcenter_2]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_2]['message'];
                    }
                    // --------------------------------------------------------------------
                    if ($TypeDetails['debit'] > 0 && $TypeDetails['credit'] > 0) {
                        $validate = false;
                        $other[] = 'Both Debit and Credit cannot have values greater than zero at the same time.';
                    }
                    $validate = $modeltype[$i]->validate() && $validate;
                }
            }
            // --------------------------------------------------------------------------------------------------

            $checkamount = 0;


            $modelVoucherItems = array();
            if (is_array($_POST['AccVoucherItems'])) {
                $checkcredit =  $checkdebit = 0;
                foreach ($_POST['AccVoucherItems'] as $i => $items) {
                    $modelVoucherItems[$i]                   = new AccVoucherItems();
                    $modelVoucherItems[$i]->updated_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                    $modelVoucherItems[$i]->created_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->created_datetime = date('Y-m-d H:i:s');
                    $modelVoucherItems[$i]->attributes     = $items;
                    $modelVoucherItems[$i]->ledger_id        = $items['ledger_id'];

                    if ((int)$items['ledger_id'] > 0) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($items['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ((int)$items['subledger_id'] <= 0) {
                                $validate = false;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }

                    //end
                    $modelVoucherItems[$i]->acc_voucher_id = 0;
                    $modelVoucherItems[$i]->narration      = ($items['narration'] == '') ? $modelVoucher->general_narration : $items['narration'];
                    $modelVoucherItems[$i]->ledger_id      = $items['ledger_id'];
                    $modelVoucherItems[$i]->year           = $items['year'];
                    $modelVoucherItems[$i]->company_id     = $items['company_id'];
                    $modelVoucherItems[$i]->branch_id      = $items['branch_id'];
                    $modelVoucherItems[$i]->salegroup_id   = $items['salegroup_id'];
                    $modelVoucherItems[$i]->brand_id       = $items['brand_id'];
                    $modelVoucherItems[$i]->employee_id    = $items['employee_id'] ? $items['employee_id'] : '000';
                    $modelVoucherItems[$i]->department_id  = $items['department_id'] ? $items['department_id'] : '00';
                    $modelVoucherItems[$i]->costcenter_id  = $items['costcenter_id'];
                    $modelVoucherItems[$i]->project_id     = $items['project_id'] ? $items['project_id'] : '0000';
                    $modelVoucherItems[$i]->generic_id     = $items['generic_id'];
                    // $modelVoucherItems[$i]->product_id  = $items['product_id'] ? $items['product_id'] : '0000';
                    $modelVoucherItems[$i]->warehouse_id   = $items['warehouse_id'];
                    $modelVoucherItems[$i]->product_id     = $items['product_id'];


                    if ($items['debit'] > 0) {
                        $modelVoucherItems[$i]->amount     = $items['debit'];
                    } else {
                        $modelVoucherItems[$i]->amount     = -1 * (float)$items['credit'];
                    }

                    if ($commingfrom == 'copynewvoucher') {
                        $modelVoucherItems[$i]->allocated_amount = 0;
                        $modelVoucherItems[$i]->allocate_ids     = '';
                    }
                    // -------------------to check and save costcenter-------------------------------------------------

                    if (isset($costcenterMapping[$costcenter_1]) && (int)$items[$costcenterMapping[$costcenter_1]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_1]['message'];
                    }
                    if (isset($costcenterMapping[$costcenter_2]) && (int)$items[$costcenterMapping[$costcenter_2]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_2]['message'];
                    }

                    // --------------------------------------------------------------------
                    if ($items['debit'] > 0 && $items['credit'] > 0) {
                        $validate = false;
                        $other[] = 'Both Debit and Credit cannot have values greater than zero at the same time.';
                    }
                    $validate                              = $modelVoucherItems[$i]->validate() && $validate;
                }
            }
            // -------------------------is_multiple----------------------------------------
            if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                $voucher_date = $_POST['AccVoucher']['start_date'];
                $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                $frequency_type = $_POST['AccVoucher']['frequency_type'];
                $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
            }
            // -------------------------is_multiple----------------------------------------


            if ($validate) {
                $modelVoucher->save();

                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "{$modelVoucher->vtype->description} with voucher no: - {$modelVoucher->voucher_no}  "
                );
                // end audit log

                AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $modelVoucher->id));

                if (!empty($modelVoucherItems)) {
                    $total = 0;

                    foreach ($modelVoucherItems as $eachModel) {
                        if (!empty($eachModel->ledger_id) || $eachModel->ledger_id > 0) {
                            $eachModel->acc_voucher_id  = $modelVoucher->id;
                            if (!empty($eachModel->debit) && $eachModel->debit > 0) {
                                $total += $eachModel->debit;
                                $tot_debit += abs($eachModel->debit);
                            }
                            $eachModel->currency_id    = $modelVoucher->currency_id;
                            $eachModel->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModel->save(false);
                        }
                    }
                }

                if (!empty($modeltype)) {
                    $total = 0;
                    foreach ($modeltype as $eachModeltype) {
                        if (!empty($eachModeltype->ledger_id) || $eachModeltype->ledger_id > 0) {
                            $eachModeltype->acc_voucher_id = $modelVoucher->id;
                            if (!empty($eachModeltype->debit) && $eachModeltype->debit > 0) {
                                $total += $eachModeltype->debit;
                                $tot_debit += abs($eachModeltype->debit);
                            }
                            $eachModeltype->currency_id    = $modelVoucher->currency_id;
                            $eachModeltype->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModeltype->save(false);
                        }
                    }
                }

                $modelAccVoucher = new AccVoucher();
                $modelAccVoucher->updatebypk($modelVoucher->id, array('amount' => ($tot_debit), 'net_amount' => ($tot_debit))); //$netTotal

                // -------------------------is_multiple----------------------------------------

                if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                    $voucher_id = $modelVoucher->id;
                    $voucher_date = $_POST['AccVoucher']['start_date'];
                    $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                    $frequency_type = $_POST['AccVoucher']['frequency_type'];
                    $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
                    if ($_POST['AccVoucher']['frequency_no'] >= 1) {
                        for ($i = 1; $i <= $frequency; $i++) {
                            VoucherController::copyVoucher($voucher_id, $voucher_date);
                            if ($frequency_type == 'D') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 day'));
                            }
                            // Weekly
                            elseif ($frequency_type == 'W') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 week'));
                            }
                            // Monthly
                            elseif ($frequency_type == 'M') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 month'));
                            }
                            // Yearly
                            elseif ($frequency_type == 'Y') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 year'));
                            }
                        }
                    }
                }
                // -----------------------------------------------------------------
                $jsonData['status'] = 'success';
                $jsonData['id'] = $modelVoucher->id;
                echo CJSON::encode($jsonData);
            } else {
                if (!empty($modelVoucher)) {
                    $error1 = json_decode(CActiveForm::validate($modelVoucher, '', false), true);
                }
                if (!empty($modelVoucherItems)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelVoucherItems, '', false), true);
                }
                if (!empty($modeltype)) {
                    $error3 = json_decode(CActiveForm::validateTabular($modeltype, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }




    public function actiongetVoucherData()
    {
        $voucher_type       = $_POST['voucher_type'];
        $model_voucher_type = new AccVoucherType();
        $voucherItems       = array();
        $voucherItems       = AccVoucherItems::model()->with('parent')->findAll(array('condition' => 'parent.voucher_type="' . $voucher_type . '"'));
        if (empty($voucherItems)) {
            $voucherItems   = array(new AccVoucherItems());
        }
        $this->render('voucher_details', array('voucherItems' => $voucherItems));
    }

    public function actionGetcurrencyexchangeRate()
    {
        $currency = (int)$_POST['currency'];
        echo (float)MasCurrency::model()->findBypk($currency)->exchange_rate;
    }

    public function actionGettotalcheck()
    {
        $modelAccVoucherItems = new AccVoucherItems();
        //$resultTotal = AccVoucherItems::model()->find(array('select' => 'sum(debit) as debit,sum(credit) as credit'));
        $resultTotal = $modelAccVoucherItems->find(array('select' => 'sum(debit) as debit,sum(credit) as credit'));

        if ($resultTotal['debit'] == $resultTotal['credit']) {
            echo "success";
        } else {
            echo "fail";
        }
    }


    public function actionDeleteVoucher()
    {
        $id = (int)$_POST['id'];

        if ($id <= 0) {
            $jsonData[] = 'failed';
            echo CJSON::encode($jsonData);
            return;
        }

        $voucherModel = AccVoucher::model()->findByPk($id);

        if (empty($voucherModel)) {
            $jsonData[] = 'This Voucher does not exist!';
            echo CJSON::encode($jsonData);
            return;
        }

        if ($voucherModel->is_allocated == "Y") {
            $jsonData[] = 'Remove the allocation first';
            echo CJSON::encode($jsonData);
            return;
        }

        if ($voucherModel->is_posted == "Y") {
            $jsonData[] = 'Unpost the voucher first';
            echo CJSON::encode($jsonData);
            return;
        }

        $voucherItemsModel = AccVoucherItems::model()->findAll(array('condition' => 'acc_voucher_id="' . $id . '" '));

        if (!empty($voucherItemsModel)) {
            AccVoucherItems::model()->deleteAll(array('condition' => 'acc_voucher_id =' . $id));
        }

        // inserting to audit log
        AccAuditLog::saveAuditLogs(
            'ACCOUNTS',
            Yii::app()->user->id,
            'DELETED',
            changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
        );
        // end audit log


        $voucherModel->deleteByPk($id);



        $jsonData['status'] = 'success';
        echo CJSON::encode($jsonData);
    }

    public function actionGetvoucherList()
    {
        $voucher_type_id                 = Yii::app()->request->getParam('voucher_type');
        $modelAccVoucherTypeDetails      = new AccVoucherTypeDetails();
        $modelAccVoucherTypeDetails_list = $modelAccVoucherTypeDetails->findAll(array('condition' => 'voucher_type_id="' . $voucher_type_id . '" '));
        $this->render('voucher_list', array('voucher_type_id' => $voucher_type_id, 'modelAccVoucherTypeDetails_list' => $modelAccVoucherTypeDetails_list));
    }


    public function actionRemovelineitem()
    {
        $id           = $_POST['id'];
        $debit_total  = $_POST['debit'];
        $credit_total = $_POST['credit'];
        if ($id > 0) {
            AccVoucherItems::model()->deleteByPk($id);
            $status['status'] = 'success';
        } else {
            $status['status'] = 'error';
        }
        echo CJSON::encode($status);
    }


    public function actionAdd_payment()
    {
        $model = new AccVoucher;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('add_payment_voucher', array('model' => $model));
    }

    public function actionSubledgerlist()
    {

        $ledger               = (int)$_GET['ledger'];
        $modelAccLedger       = new AccLedger();
        $legderModel          = $modelAccLedger->findBypk($ledger);
        //$legderModel        = AccLedger::model()->findBypk($ledger);
        $subledger_types      = $legderModel->subledger_types;
        $subledger_types_list = explode(',', $subledger_types);

        foreach ($subledger_types_list as $key => $row) {

            $searchTerm = $_GET['term'];
            $condition  = '(subledger_name LIKE "%' . $searchTerm . '%" OR subledger_name LIKE "%' . $searchTerm . '%")';
            $condition .= 'AND subledger_type IN (' . $row . ')';
            $limit      = 50;
            $query = 'SELECT * FROM erp_acc_subledger WHERE ' . $condition . ' ORDER BY subledger_name LIMIT ' . $limit;
            $model = Yii::app()->db->createCommand($query)->queryAll();
            $i = 0;
            foreach ($model as $eachModel) {
                $data[$i]['value'] = $eachModel['id'];
                $data[$i]['label'] = $eachModel['subledger_name'];
                $i++;
            }
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionAdd_receipt()
    {
        $model = new AccVoucher;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('add_receipt_voucher', array('model' => $model));
    }

    public function actionPostvoucher()
    {
        $modelVoucher = new AccVoucher();
        $modelVoucherItems = array(new AccVoucherItems());
        $error1   = array();
        $error2   = array();
        $error3   = array();
        $error    = array();
        $other    = array();
        $validate = TRUE;
        if (isset($_POST['AccVoucher'])) {
            $modelVoucher->created_by       = Yii::app()->user->id;
            $modelVoucher->created_datetime = date('Y-m-d h:i:s');
            $modelVoucher->updated_by       = Yii::app()->user->id;
            $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
            if ((int)@$_POST['AccVoucher']['id'] > 0) {
                $id = (int)@$_POST['AccVoucher']['id'];
                $modelVoucher                   = $modelVoucher->findByPk($id);
                $modelVoucher->updated_by       = Yii::app()->user->id;
                $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
            }
            $modelVoucher->attributes        = $_POST['AccVoucher'];
            $modelVoucher->general_narration = $_POST['AccVoucher']['general_narration'];
            $modelVoucher->is_posted         = 'Y';
            if ($modelVoucher->isNewRecord) {
                $modelAccVoucherType = new AccVoucherType();
                //$modelVoucher->voucher_no = AccVoucherType::getVoucherno($modelVoucher->voucher_type, true);
                $modelVoucher->voucher_no   = $modelAccVoucherType->getVoucherno($modelVoucher->voucher_type, true);
            }
            if ($_POST['AccVoucher']['voucher_date'] != '' && $_POST['AccVoucher']['voucher_date'] != '0000-00-00') {
                $modelVoucher->voucher_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['voucher_date'])));
            } else {
                $modelVoucher->voucher_date = date("Y-m-d");
            }
            $usermodel                           = new user();
            $modelVoucher->transaction_number    =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_id        =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_date      =  $modelVoucher->voucher_date;
            $modelVoucher->posted_date           =  date('Y-m-d h:i:s');
            $modelVoucher->lead_owner            = (int)Yii::app()->user->id;
            if ($_POST['AccVoucher']['cheque_date'] != '' && $_POST['AccVoucher']['cheque_date'] != '0000-00-00') {
                $modelVoucher->cheque_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['AccVoucher']['cheque_date'])));
            }
            $commingfrom        = $_POST['AccVoucher']['commingfrom'];
            if ($commingfrom == 'copynewvoucher') {
                $modelVoucher->is_allocated = 'N';
                $modelVoucher->allocation_date = '0000-00-00';
            }
            $validate = $modelVoucher->validate();

            //   ---------------------AccAuditClose check------------------------------------
            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastFinalCloseddate());
            $voucher_date = strtotime($modelVoucher->voucher_date);
            if ($voucher_date <= $existing_date) {
                $validate = false;
                $other[] = ' Given Voucher date must be Greater than Final Audit Close Date :-' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastFinalCloseddate()))) . '';
            } else {
                $existing_date = strtotime($modelAccAuditClose->lastCloseddate());
                if ($voucher_date <= $existing_date) {
                    if (!(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"]) || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"]))) {
                        $validate = false;
                        $other[] = ' Given Voucher date must be Greater than Pre Audit Close Date :-' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                    }
                }
            }
            //   --------------------//-AccAuditClose check------------------------------------

            // -------------------to check and save costcenter-------------------------------------------------
            $costcenter_1 = $costcenter_2 = 'N';

            $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
            if ($tableExists) {
                $acc_settings = Yii::app()->db->createCommand()
                    ->select('costcenter_1, costcenter_2')
                    ->from('{{acc_general_settings}}')
                    ->queryRow();

                $costcenter_1 = $acc_settings['costcenter_1'];
                $costcenter_2 = $acc_settings['costcenter_2'];
            }

            $costcenterMapping = [
                'BRANCH' => ['key' => 'warehouse_id', 'message' => 'Branch cannot be null'],
                'OUTLET' => ['key' => 'outlet_id', 'message' => 'Outlet cannot be null'],
                'DEPARTMENT' => ['key' => 'department_id', 'message' => 'Department cannot be null'],
            ];

            // -------------------// to check and save costcenter-------------------------------------------------

            if (is_array($_POST['AccVoucherTypeDetails'])) {
                $checkdebit = 0;
                foreach ($_POST['AccVoucherTypeDetails'] as $i => $TypeDetails) {
                    $modeltype[$i]                   = new AccVoucherItems();
                    $modeltype[$i]->attributes       = $TypeDetails;
                    // ----------------------
                    if ((int)$TypeDetails['ledger_id'] > 0) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($TypeDetails['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ((int)$TypeDetails['subledger_id'] <= 0) {
                                $validate = FALSE;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }
                    // ----------------------
                    $modeltype[$i]->created_by       = Yii::app()->user->id;
                    $modeltype[$i]->created_datetime = date('Y-m-d H:i:s');
                    $modeltype[$i]->ledger_id        = $TypeDetails['ledger_id'];
                    $modeltype[$i]->subledger_id     = $TypeDetails['subledger_id'];
                    $modeltype[$i]->narration        = ($TypeDetails['narration'] == '') ? $modelVoucher->general_narration : $TypeDetails['narration'];
                    $modeltype[$i]->debit            = $TypeDetails['debit'];
                    $modeltype[$i]->credit           = $TypeDetails['credit'];
                    $modeltype[$i]->acc_voucher_id   = 0;
                    $modeltype[$i]->year             = $TypeDetails['year'];
                    $modeltype[$i]->company_id       = $TypeDetails['com_id'];
                    $modeltype[$i]->branch_id        = $TypeDetails['branch_id'];
                    $modeltype[$i]->salegroup_id     = $TypeDetails['salegrp_id'];
                    $modeltype[$i]->brand_id         = $TypeDetails['brand_id'];
                    $modeltype[$i]->employee_id      = $TypeDetails['emp_id'] ? $TypeDetails['emp_id'] : '000';
                    $modeltype[$i]->department_id    = $TypeDetails['dept_id'] ? $TypeDetails['dept_id'] : '00';
                    $modeltype[$i]->costcenter_id    = $TypeDetails['cc_id'];
                    $modeltype[$i]->project_id       = $TypeDetails['project_id'] ? $TypeDetails['project_id'] : '0000';
                    $modeltype[$i]->generic_id       = $TypeDetails['cat_id'];
                    $modeltype[$i]->product_id       = $TypeDetails['item'] ? $TypeDetails['item'] : '0000';
                    $modeltype[$i]->warehouse_id     = $TypeDetails['warehouse_id'];
                    // ----------------------
                    if ($TypeDetails['debit'] > 0) {
                        $modeltype[$i]->amount       = $TypeDetails['debit'];
                        $checkdebit += $TypeDetails['debit'];
                    } else {
                        $modeltype[$i]->amount       = -1 * (float)$TypeDetails['credit'];
                    }

                    if ($commingfrom == 'copynewvoucher') {
                        $modeltype[$i]->allocated_amount = 0;
                        $modeltype[$i]->allocate_ids     = '';
                    }
                    // -------------------to check and save costcenter-------------------------------------------------
                    if (isset($costcenterMapping[$costcenter_1]) && (int)$TypeDetails[$costcenterMapping[$costcenter_1]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_1]['message'];
                    }
                    if (isset($costcenterMapping[$costcenter_2]) && (int)$TypeDetails[$costcenterMapping[$costcenter_2]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_2]['message'];
                    }
                    // --------------------------------------------------------------------
                    if ($TypeDetails['debit'] > 0 && $TypeDetails['credit'] > 0) {
                        $validate = false;
                        $other[] = 'Both Debit and Credit cannot have values greater than zero at the same time.';
                    }
                    $validate = $modeltype[$i]->validate() && $validate;
                }
            }


            $checkamount = 0;
            $modelVoucherItems = array();
            if (is_array($_POST['AccVoucherItems'])) {
                $checkcredit =  $checkdebit = 0;
                foreach ($_POST['AccVoucherItems'] as $i => $items) {
                    // if ($items['id'] > 0) {
                    //     $modelVoucherItems[$i]                   = AccVoucherItems::model()->findByPK($items['id']);
                    //     $modelVoucherItems[$i]->updated_by       = Yii::app()->user->id;
                    //     $modelVoucherItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                    // } else {
                    $modelVoucherItems[$i]                   = new AccVoucherItems();
                    $modelVoucherItems[$i]->updated_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                    $modelVoucherItems[$i]->created_by       = Yii::app()->user->id;
                    $modelVoucherItems[$i]->created_datetime = date('Y-m-d H:i:s');
                    // }
                    // length defined in dimention seting table. if data empty the set 0s
                    $modelVoucherItems[$i]->attributes           = $items;
                    // ----------------------
                    if ((int)$items['ledger_id'] > 0) {
                        $modelAccLedger  = new AccLedger();
                        $modelAccLedger_det   = $modelAccLedger->findByPk($items['ledger_id']);
                        if ($modelAccLedger_det->have_subledger == 'Y') {
                            if ((int)$items['subledger_id'] <= 0) {
                                $validate = FALSE;
                                $other[] = '' . $modelAccLedger_det->ledger_acc_name . ' Sub-ledger !  cant be null';
                            }
                        }
                    }
                    // ----------------------                  

                    $modelVoucherItems[$i]->acc_voucher_id       = 0;
                    $modelVoucherItems[$i]->narration            = ($items['narration'] == '') ? $modelVoucher->general_narration : $items['narration'];
                    $modelVoucherItems[$i]->year                 = $items['year'];
                    $modelVoucherItems[$i]->company_id           = $items['company_id'];
                    $modelVoucherItems[$i]->branch_id            = $items['branch_id'];
                    $modelVoucherItems[$i]->salegroup_id         = $items['salegroup_id'];
                    $modelVoucherItems[$i]->brand_id             = $items['brand_id'];
                    $modelVoucherItems[$i]->employee_id          = $items['employee_id'] ? $items['employee_id'] : '000';
                    $modelVoucherItems[$i]->department_id        = $items['department_id'] ? $items['department_id'] : '00';
                    $modelVoucherItems[$i]->costcenter_id        = $items['costcenter_id'];
                    $modelVoucherItems[$i]->project_id           = $items['project_id'] ? $items['project_id'] : '0000';
                    $modelVoucherItems[$i]->generic_id           = $items['generic_id'];
                    $modelVoucherItems[$i]->product_id           = $items['product_id'] ? $items['product_id'] : '0000';
                    $modelVoucherItems[$i]->warehouse_id         = $items['warehouse_id'];
                    $modelVoucherItems[$i]->currency_id             = $modelVoucher->currency_id;
                    $modelVoucherItems[$i]->exchange_rate           = $modelVoucher->exchange_rate;

                    if ($items['debit'] > 0) {
                        $modelVoucherItems[$i]->amount           = $items['debit'];
                    } else {
                        $modelVoucherItems[$i]->amount           = -1 * (float)$items['credit'];
                    }

                    if ($commingfrom == 'copynewvoucher') {
                        $modelVoucherItems[$i]->allocated_amount = 0;
                        $modelVoucherItems[$i]->allocate_ids     = '';
                    }
                    // -------------------to check and save costcenter-------------------------------------------------
                    if (isset($costcenterMapping[$costcenter_1]) && (int)$items[$costcenterMapping[$costcenter_1]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_1]['message'];
                    }
                    if (isset($costcenterMapping[$costcenter_2]) && (int)$items[$costcenterMapping[$costcenter_2]['key']] <= 0) {
                        $validate = false;
                        $other[] = $costcenterMapping[$costcenter_2]['message'];
                    }
                    // --------------------------------------------------------------------
                    if ($items['debit'] > 0 && $items['credit'] > 0) {
                        $validate = false;
                        $other[] = 'Both Debit and Credit cannot have values greater than zero at the same time.';
                    }
                    $validate = $modelVoucherItems[$i]->validate() && $validate;
                }
            }
            // -------------------------is_multiple----------------------------------------

            if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                $voucher_date = $_POST['AccVoucher']['start_date'];
                $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                $frequency_type = $_POST['AccVoucher']['frequency_type'];
                $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
            }
            // -------------------------is_multiple----------------------------------------


            if ($validate) {
                $modelVoucher->save();
                $audit_type = 'POSTED';
                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "{$modelVoucher->vtype->description} with voucher no: - {$modelVoucher->voucher_no}  "
                );
                // end audit log
                AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $modelVoucher->id));

                if (!empty($modelVoucherItems)) {
                    $total = 0;

                    foreach ($modelVoucherItems as $eachModel) {
                        if (!empty($eachModel->ledger_id) || $eachModel->ledger_id > 0) {
                            $eachModel->acc_voucher_id  = $modelVoucher->id;
                            if (!empty($eachModel->debit) && $eachModel->debit > 0) {
                                $total += $eachModel->debit;
                                $tot_debit += abs($eachModel->debit);
                            }
                            $eachModel->currency_id    = $modelVoucher->currency_id;
                            $eachModel->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModel->save(false);
                        }
                    }
                }

                if (!empty($modeltype)) {
                    $total = 0;
                    foreach ($modeltype as $eachModeltype) {
                        if (!empty($eachModeltype->ledger_id) || $eachModeltype->ledger_id > 0) {
                            $eachModeltype->acc_voucher_id = $modelVoucher->id;
                            if (!empty($eachModeltype->debit) && $eachModeltype->debit > 0) {
                                $total += $eachModeltype->debit;
                                $tot_debit += abs($eachModeltype->debit);
                            }
                            $eachModeltype->currency_id    = $modelVoucher->currency_id;
                            $eachModeltype->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModeltype->save(false);
                        }
                    }
                }

                $modelAccVoucher = new AccVoucher();
                $modelAccVoucher->updatebypk($modelVoucher->id, array('amount' => ($tot_debit), 'net_amount' => ($tot_debit))); //$netTotal
                // -------------------------is_multiple----------------------------------------

                if ($_POST['AccVoucher']['is_multiple'] == 'Y') {
                    $voucher_id = $modelVoucher->id;
                    $voucher_date = $_POST['AccVoucher']['start_date'];
                    $frequency = (int)$_POST['AccVoucher']['frequency_no'];
                    $frequency_type = $_POST['AccVoucher']['frequency_type'];
                    $voucher_date = date('Y-m-d', strtotime(str_replace('/', '-', $voucher_date)));
                    if ($_POST['AccVoucher']['frequency_no'] >= 1) {
                        for ($i = 1; $i <= $frequency; $i++) {
                            VoucherController::copyVoucher($voucher_id, $voucher_date);
                            if ($frequency_type == 'D') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 day'));
                            }
                            // Weekly
                            elseif ($frequency_type == 'W') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 week'));
                            }
                            // Monthly
                            elseif ($frequency_type == 'M') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 month'));
                            }
                            // Yearly
                            elseif ($frequency_type == 'Y') {
                                $voucher_date = date('Y-m-d', strtotime($voucher_date . ' +1 year'));
                            }
                        }
                    }
                }
                // -----------------------------------------------------------------
                $jsonData['status'] = 'success';
                $jsonData['id'] = $modelVoucher->id;
                echo CJSON::encode($jsonData);
            } else {
                if (!empty($modelVoucher)) {
                    $error1 = json_decode(CActiveForm::validate($modelVoucher, '', false), true);
                }
                if (!empty($modelVoucherItems)) {
                    $error2 = json_decode(CActiveForm::validateTabular($modelVoucherItems, '', false), true);
                }
                if (!empty($modeltype)) {
                    $error3 = json_decode(CActiveForm::validateTabular($modeltype, '', false), true);
                }
                $error = CJSON::encode(array_merge_recursive($error1, $error2, $error3, $other));
                if ($error != '[]')
                    echo $error;
            }
        }
    }

    public function actionUpdatevoucher()
    {
        $id   = (int) $_POST['id'];

        $type = $_POST['type'];

        if ($id > 0) {
            $modelAccVoucher = new AccVoucher();
            $voucherModel    = $modelAccVoucher->findBypk($id);


            //   ---------------------AccAuditClose check------------------------------------
            $modelAccAuditClose = new AccAuditClose();
            $existing_date_final = strtotime($modelAccAuditClose->lastFinalClosedDate());
            $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
            $voucher_date = strtotime($voucherModel->voucher_date);
            if ($voucher_date <= $existing_date_final) {
                $jsonData[] = ' Given Voucher date must be Greater than Final Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastFinalClosedDate()))) . '';
                echo CJSON::encode($jsonData);
            } else if (($voucher_date <= $existing_date) && (!(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"]) || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"])))) {
                $jsonData[] = ' Given Voucher date must be Greater than Pre Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastClosedDate()))) . '';
                echo CJSON::encode($jsonData);
            } else {
                //   --------------------//-AccAuditClose check------------------------------------   

                $code = $voucherModel->vtype->code;
                if ($type == 0) {

                    //unpost
                    if ($voucherModel->is_allocated == 'N') {


                        if ($voucherModel->imported == 'N') {
                            $voucherModel->is_posted    = 'N';
                            $voucherModel->save(false);
                            //	$msg = 'success';

                            // inserting to audit log
                            AccAuditLog::saveAuditLogs(
                                'ACCOUNTS',
                                Yii::app()->user->id,
                                'UNPOSTED',
                                changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                            );
                            // end audit log


                            $jsonData['status']    = 'success';
                            echo CJSON::encode($jsonData);
                        } else if ($voucherModel->imported == 'Y') {
                            // ----------added-by-indhu-19-12-2022---------------------------
                            $array_ids = [$voucherModel->transaction_id];
                            // array id's
                            Yii::import('application.modules.accounts.controllers.PostingController');
                            $PostingController = new PostingController('id');
                            if ($code == 'PI') {
                                //if voucher added from purchase invoice
                                $PostingController->addUnpostPurchaseInvoice($array_ids);
                            } else if ($code == 'SI') {
                                //if voucher added from sales invoice
                                $PostingController->addUnpostSales($array_ids);
                            } else if ($code == 'CN') {
                                //if voucher added from sales invoice
                                $PostingController->addUnpostCreditnote($array_ids);
                            } else if ($code == 'DN') {
                                //if voucher added from debit note import
                                $PostingController->addUnpostdebitnote($array_ids);
                            } else if ($code == 'GI') {
                                //if voucher added from Goods issue import
                                $PostingController->addUnpostgoodsissue($array_ids);
                            } else if ($code == 'GR') {
                                //if voucher added from Goods receipt import
                                $PostingController->addUnpostgoodsreceipt($array_ids);
                            } else if ($code == 'RV') {
                                //if voucher added from sales invoice
                                $PostingController->deletePostedReceipt_frm_invoice($voucherModel->transaction_id);
                                $jsonData['status']    = 'success';
                                echo CJSON::encode($jsonData);
                            } else if ($code == 'PV') {
                                //if voucher added from creditnote 
                                $PostingController->deletePostedpayment_frm_creditnote($voucherModel->transaction_id);
                                $jsonData['status']    = 'success';
                                echo CJSON::encode($jsonData);
                            } else if ($code == 'CM') {
                                //if voucher added from sales invoice
                                $PostingController->deletePosted_Commission($voucherModel->transaction_id);
                                $jsonData['status']    = 'success';
                                echo CJSON::encode($jsonData);
                            } else {
                                $jsonData[]            = 'Failed!';
                                echo CJSON::encode($jsonData);
                            }
                            // ---------------------------------------------------------------


                        }
                    } else {
                        //$msg = 'Remove Allocation  first!';

                        $jsonData[]            = 'Remove allocation first!';
                        echo CJSON::encode($jsonData);
                    }
                } else if ($type == 2) {
                    //delete
                    if ($voucherModel->is_allocated == 'N') {
                        $modelAccVoucher            = new AccVoucher();


                        // inserting to audit log
                        AccAuditLog::saveAuditLogs(
                            'ACCOUNTS',
                            Yii::app()->user->id,
                            'DELETED',
                            changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                        );
                        // end audit log


                        $modelAccVoucher->deleteBypk($id);
                        //AccVoucher::model()->deleteBypk($id);
                        $modelAccVoucherItems = new AccVoucherItems();
                        $modelAccVoucherItems->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $id));
                        //	AccVoucherItems::model()->deleteAll('acc_voucher_id=:refer_id', array(':refer_id' => $id));
                        //$msg = 'success';


                        $jsonData['status']    = 'success';
                        echo CJSON::encode($jsonData);
                    } else {
                        //$msg = 'Remove allocation first!';

                        $jsonData[]            = 'Remove allocation first!';
                        echo CJSON::encode($jsonData);
                    }
                } else {
                    //post
                    //	 if ($voucherModel->is_postable_voucher($id)) {
                    $voucherModel->is_posted = 'Y';
                    $voucherModel->posted_date = date('Y-m-d h:i:s');
                    $voucherModel->save(false);
                    //$msg = 'success';

                    // inserting to audit log
                    AccAuditLog::saveAuditLogs(
                        'ACCOUNTS',
                        Yii::app()->user->id,
                        'POSTED',
                        changes: "{$voucherModel->vtype->description} with voucher no: - {$voucherModel->voucher_no}  "
                    );
                    // end audit log
                    $jsonData['status']    = 'success';
                    echo CJSON::encode($jsonData);
                }
            }   // end auditclose
        } else {
            //echo 'Something Went Wrong!';

            $jsonData[]            = 'Something Went Wrong!';
            echo CJSON::encode($jsonData);
        }
    }

    public function actionGetProducts()
    {
        $modelMasCurrency = new MasCurrency();
        $from       = $_GET['frm'];
        $searchTerm = $_GET['term'];
        $condition  = '(part_number LIKE "%' . $searchTerm . '%" OR description LIKE "%' . $searchTerm . '%") and t.isActive="Y"';
        $model      = new Store();
        $model      = $model->with('tax')->findAll(array('select' => 'id,part_number,description,unit_id,inventory_item_type,purchase_from,rate', 'condition' => $condition, 'limit' => 200));
        $i = 0;
        foreach ($model as $eachModel) {
            $data[$i]['value']       = $eachModel->id;
            $availble_qty            = Yii::app()->db->createCommand('SELECT SUM(quantity) as availble_qty FROM `view_all_stock_items` WHERE id=' . $eachModel->id . ' AND stock_updated="Y" GROUP BY id')->queryScalar();
            $data[$i]['label']       = $eachModel->part_number . ' : ' . $eachModel->description . " [Qty: " . $modelMasCurrency->baseCurrencyDecimalNumberFormat($availble_qty) . "]";
            $data[$i]['part_number'] = $eachModel->part_number;
            $i++;
        }
        echo CJSON::encode($data);
        Yii::app()->end();
    }

    public function actionPrintvoucherPdf()
    {
        $model      = new AccVoucher();
        $id         = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model  = $model->findbyPK($id);
        }
        $mPDF1      = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name  = "voucher_list_pdf";
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.accounts.views.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("Voucher_" . $id . "_" . strtoupper($model->voucher_no) . ".pdf", 'I');
    }


    // -----------------------------------------------------------------------------------------------------------
    //Import functions
    //view page ->accounts/voucher
    //------------------------------------------------------------------------------------------------------------

    public function actionImportvouchers()
    {
        $from         = Yii::app()->request->getParam('from');

        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('voucher_import', array('from' => $from));
    }



    public function actionGetimportvouchers()
    {

        $status     = $_POST['status'];
        $voucher    = $_POST['voucher'];
        $from_date  = (count(explode('/', $_POST['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date']))) : date('Y-m-01');
        $to_date    = (count(explode('/', $_POST['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date']))) : date('Y-m-t');
        $import     = $_POST['voucher_import'];

        //   ---------------------AccAuditClose check------------------------------------
        $modelAccAuditClose = new AccAuditClose();
        $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
        $existing_date_final = strtotime($modelAccAuditClose->lastFinalClosedDate());
        $from_date_check = strtotime($from_date);
        $to_date_check = strtotime($to_date);

        if ($from_date_check <= $existing_date_final || $to_date_check <= $existing_date_final) {
            echo 'final auditclose';
        } else if ($from_date_check <= $existing_date || $to_date_check <= $existing_date) {
            echo 'pre auditclose';
        } else {
            //   ---------------------------------------------------------
            $modelAccVoucherType   = new AccVoucherType;
            $model_vouchertype     = $modelAccVoucherType->findBypk($voucher);

            if ($import == "Y") {
                if ($model_vouchertype['code'] == 'SI') {
                    // Sales Invoice
                    $this->render('import_si_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'PI') {
                    //Purchase Invoice
                    $this->render('import_pi_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'CN') {
                    //Credit Note
                    $this->render('import_cn_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'DN') {
                    //debite Note
                    $this->render('import_dn_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'GI') {
                    //Goods  issues
                    $this->render('import_gi_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'GR') {
                    //Goods  receipts
                    $this->render('import_gr_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                } else if ($model_vouchertype['code'] == 'MR') {
                    //Goods  receipts
                    $this->render('import_meterial_receipt_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status));
                }
            } else {

                $this->render('import_voucher_list', array('voucher' => $voucher, 'from_date' => $from_date, 'to_date' => $to_date, 'status' => $status, 'import' => $import));
            }

            // -----------------------------------------------------
        }
    }


    public function actionGetImportVoucherList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new AccVoucher();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        $vouchertype   = $_POST['vouchertype'];

        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'code',
            1 => 'file_id',
            2 => 'transaction_number',
            3 => 'reference_no',
            4 => 'voucher_date',
            5 => 'voucher_type',
            6 => 'warehouse_name',
            7 => 'imported',
            8 => 'ledger_name',
            9 => 'subledger_name',
            10 => 'net_amount',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = 'imported="N"';

        if ($status != '') {
            $condition .= ' AND is_posted="' . $status . '"';
        }

        if ((int)$vouchertype > 0) {
            $condition .= " AND voucher_type_id = " . $vouchertype;
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND voucher_date>="' . $start_date . '" AND voucher_date<="' . $end_date . '"';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (voucher_no LIKE "%' . $searchString . '%"
			 OR voucher_type LIKE "%' . $searchString . '%"
			  OR transaction_number LIKE "%' . $searchString . '%"
			 OR code LIKE "%' . $searchString . '%"
            OR subledger_name LIKE "%' . $searchString . '%" OR ledger_name LIKE "%' . $searchString . '%" OR reference_no LIKE "%' . $searchString . '%" OR amount LIKE "%' . $searchString . '%")';
        }



        $query = 'SELECT id,voucher_no,code,is_posted,is_allocated,imported,transaction_number,voucher_type_id,file_id,reference_no,voucher_type,ledger_name,subledger_name,net_amount,voucher_date,warehouse_name,warehouse_id FROM view_acc_voucher_items WHERE ' . $condition . ' ORDER BY ' . $orderBy . ' LIMIT ' . $limit . ' OFFSET ' . $offset . ' ';
        $count = Yii::app()->db->createCommand('SELECT COUNT(id) FROM view_acc_voucher_items WHERE ' . $condition . ' ')->queryScalar();
        $model = Yii::app()->db->createCommand($query)->queryAll();



        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItem['file_id'] == 0 ? $file_id = '-' : $file_id = $eachItem['file_id'];

            $eachItem['transaction_number'] == 0 ? $transaction_number = '-' : $transaction_number = $eachItem['transaction_number'];

            if ($eachItem['imported'] == "Y") {
                $imported = 'Yes';
            } else {
                $imported = 'No';
            }


            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['code'] . "/" . $eachItem['voucher_no'],
                    $file_id,
                    $transaction_number,
                    $eachItem['reference_no'],
                    (!empty($eachItem['voucher_date'])) ? date('d/m/Y', strtotime($eachItem['voucher_date'])) : "-",
                    $eachItem['voucher_type'],
                    $eachItem['warehouse_name'],
                    $imported,
                    $eachItem['ledger_name'],
                    $eachItem['subledger_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['net_amount']),
                    $eachItem['id'],
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    // -----------------------------------------------------------------------------------------------------------
    //Listing Sales Invoice in  finance voucher Import
    //view page ->accounts/voucher/import_si_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportSalesList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new Invoice();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.invoice_no',
            3 => 't.invoice_date',
            4 => 'customer.customer_name',
            5 => 't.grand_total',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = 't.invoice_status!="C"';

        if ($status != '') {
            $condition .= ' AND t.posted ="' . $status . '"';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND t.invoice_date>="' . $start_date . '" AND t.invoice_date<="' . $end_date . '"';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {

            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (t.invoice_no LIKE "%' . $searchString . '%"
			 OR t.id LIKE "%' . $searchString . '%"
			 OR t.invoice_date LIKE "%' . $searchString . '%"
            OR customer.customer_name LIKE "%' . $searchString . '%" 
            OR t.grand_total LIKE "%' . $searchString . '%" 
            OR t.id LIKE "%' . $searchString . '%")';
        }


        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['invoice_no'],
                    date('d/m/Y', strtotime($eachItem['invoice_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['grand_total']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }



    // -----------------------------------------------------------------------------------------------------------
    //Listing Purchasing Invoice in  finance voucher Import
    //view page ->accounts/voucher/import_pi_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportPurchaseList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new PurchasingInvoice();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.invoice_no',
            3 => 't.invoice_date',
            4 => 'vendor_details.vendor_name',
            5 => 't.grand_total',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (invoice_date>="' . $start_date . '" AND invoice_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= '  AND (t.invoice_no LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.invoice_date LIKE "%' . $searchString . '%"
        OR vendor_details.vendor_name LIKE "%' . $searchString . '%" 
        OR t.grand_total LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%") ';
        }

        $count = $model->with('vendor_details')->count(array('condition' => $condition));
        $model = $model->with('vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['invoice_no'],
                    date('d/m/Y', strtotime($eachItem['invoice_date'])),
                    $eachItem['vendor_details']['vendor_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['grand_total']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }


    // -----------------------------------------------------------------------------------------------------------
    //Listing Creditnote in  finance voucher Import
    //view page ->accounts/voucher/import_cn_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportCreditNoteList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new Creditnote();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.invoice_id',
            3 => 't.credited_date',
            4 => 'customer.customer_name',
            5 => 't.credited_amount',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1 AND is_updated_store = "Y" ';

        if ($status != '') {
            $condition .= ' AND (t.posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (credited_date>="' . $start_date . '" AND credited_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND(t.invoice_id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.credited_date LIKE "%' . $searchString . '%"
        OR customer.customer_name LIKE "%' . $searchString . '%" 
        OR t.credited_amount LIKE "%' . $searchString . '%" 
        OR invoice.invoice_no LIKE "%' . $searchString . '%")';
        }

        $count = $model->with('customer', 'invoice')->count(array('condition' => $condition));
        $model = $model->with('customer', 'invoice')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['invoice']['invoice_no'],
                    date('d/m/Y', strtotime($eachItem['credited_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['credited_amount']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    // -----------------------------------------------------------------------------------------------------------
    //Listing Purchasing debitnote in  finance voucher Import
    //view page ->accounts/voucher/import_dn_list.php
    //------------------------------------------------------------------------------------------------------------
    public function actionGetImportDebitNoteList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new Purchasingdebitnote();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.purchasing_invoice_id',
            3 => 't.debited_date',
            4 => 'vendor_details.vendor_name',
            5 => 't.debited_amount',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (debited_date>="' . $start_date . '" AND debited_date<="' . $end_date . '")';
        }
        $condition .= 'AND t.is_goods_returned="Y"';
        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND(t.purchasing_invoice_id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.debited_date LIKE "%' . $searchString . '%"
        OR vendor_details.vendor_name LIKE "%' . $searchString . '%" 
        OR t.debited_amount LIKE "%' . $searchString . '%" 
        OR t.file_id LIKE "%' . $searchString . '%")';
        }

        $count = $model->with('vendor_details')->count(array('condition' => $condition));
        $model = $model->with('vendor_details')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],

                    $eachItem['purchasing_invoice_id'],
                    date('d/m/Y', strtotime($eachItem['debited_date'])),
                    $eachItem['vendor_details']['vendor_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($eachItem['debited_amount']),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }


    // -----------------------------------------------------------------------------------------------------------
    //Listing  Inventory Goods Issue in  finance voucher Import
    //view page ->accounts/voucher/import_gi_list.php
    //------------------------------------------------------------------------------------------------------------

    public function actionGetImportGoodsissueList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new InventoryGoodsIssue();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.id',
            3 => 't.goods_issue_date',
            4 => 'customer.customer_name',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (goods_issue_date>="' . $start_date . '" AND goods_issue_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND(t.id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.goods_issue_date LIKE "%' . $searchString . '%"
        OR customer.customer_name LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%")';
        }
        $condition .= 'AND t.stock_updated="Y"';
        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $amount = Yii::app()->db->createCommand("select SUM(rate*picked_qty)  from erp_inventory_goods_issue_item where inventory_goods_issue_id='" . $eachItem['id'] . "' ")->queryScalar();

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['reference'],
                    date('d/m/Y', strtotime($eachItem['goods_issue_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($amount),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }




    // -----------------------------------------------------------------------------------------------------------
    //Listing  Inventory Goods Receipt in  finance voucher Import
    //view page ->accounts/voucher/import_gr_list.php
    //------------------------------------------------------------------------------------------------------------


    public function actionGetImportGoodsreceiptList()
    {
        $modelMasCurrency = new MasCurrency();
        $model        = new InventoryGoodsReceipt();
        $draw         = $_POST['draw'];
        $offset       = $_POST['start'];
        $limit        = $_POST['length'];
        // ----------passing-------------------------------
        $from_date   = $_POST['from_date'];
        $to_date     = $_POST['to_date'];
        $updateField = $_POST['updateField'];
        $dateField   = $_POST['dateField'];
        // -----------------------------------------
        $status      = ($_POST['status'] == 'NEW') ? 'N' : 'Y';

        $columns     = array(
            // datatable column index  => database column name
            0 => 'id',
            1 => 't.id',
            2 => 't.id',
            3 => 't.goods_receipt_date',
            4 => 'customer.customer_name',
            5 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';
        $condition = 't.isActive="Y" AND t.stock_updated="Y"';

        if ($status != '') {
            $condition .= ' AND (posted ="' . $status . '")';
        }

        if ($_POST['from_date'] != '' && $_POST['to_date'] != '') {
            $start_date = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['from_date'])));
            $end_date   = date("Y-m-d", strtotime(str_replace('/', '-', $_POST['to_date'])));
            $condition .= ' AND (goods_receipt_date>="' . $start_date . '" AND goods_receipt_date<="' . $end_date . '")';
        }

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    .= ' AND (t.id LIKE "%' . $searchString . '%"
         OR t.id LIKE "%' . $searchString . '%"
         OR t.goods_receipt_date LIKE "%' . $searchString . '%"
        OR customer.customer_name LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%" 
        OR t.id LIKE "%' . $searchString . '%")';
        }
        $count = $model->with('customer')->count(array('condition' => $condition));
        $model = $model->with('customer')->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData = array();
        $m = 1;
        $chk = '';

        foreach ($model as $x => $eachItem) {
            $chk = CHtml::checkBox('Invoice[' . $x . ']', false, array('class' => 'invoice_check', 'value' => $eachItem['id']));

            $div = '';

            $amount = Yii::app()->db->createCommand("select SUM(rate*picked_qty)  from erp_inventory_goods_receipt_item where inventory_goods_receipt_id='" . $eachItem['id'] . "' ")->queryScalar();

            $eachItemData[] =
                array(
                    '<div class="text-center">' . $chk . '</div>',
                    $eachItem['id'],
                    $eachItem['reference'],
                    date('d/m/Y', strtotime($eachItem['goods_receipt_date'])),
                    $eachItem['customer']['customer_name'],
                    $modelMasCurrency->baseCurrencyDecimalNumberFormat($amount),
                    $div
                );
            $m++;
        }

        $data['data'] = $eachItemData;
        echo json_encode($data);
    }

    //end

    public function actionAdd_commission()
    {
        $model = new AccVoucher;
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('add_commission_voucher', array('model' => $model));
    }
    public function actionget_commissionemployee()
    {
        $warehouse_id = (int)$_POST['warehouse_id'];



        $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
        $commision_payable = $modelAccSystemAccountsMapping->getSystemdefault('commision_payable');

        $condition = 'VI.ledger_id = ' . (int)$commision_payable;
        if ($warehouse_id > 0) {
            $condition .= ' AND VI.warehouse_id = ' . (int)$warehouse_id;
        }
        $list = Yii::app()->db->createCommand(
            '
             SELECT IFNULL(-1*SUM(VI.amount),0) as commission_amount ,S.subledger_name AS subledger_name,S.id AS subledger_id
             FROM erp_acc_voucher_items VI
             LEFT JOIN erp_acc_subledger S ON S.id=VI.subledger_id
              WHERE ' . $condition . '
             GROUP BY  VI.subledger_id,VI.warehouse_id'
        )->queryAll();

        $tbl_contents = '';
        $colspan = 4;
        $tbl_contents = '<table class="table table-hover table-bordered personal-task" id="tbl_commission_employee">        
        <tr>            
        <th>No</th>     
        <th>Subledger Name</th>            
        <th>Commission Amount</th>   
        <th>Paid Amount</th>
       </tr>';
        $n = 0;
        if (!empty($list)) {
            foreach ($list as $i => $eachemployee) {

                if (floatval($eachemployee['commission_amount']) != 0) {
                    $tbl_contents .= '<tr>';
                    $tbl_contents .= '<td>' . CHtml::CheckBox("AccVoucherItems[$n]['check']", '', array('class' => 'debit', 'value' => $eachemployee['subledger_id'], 'onChange' => 'copyValue("AccVoucherItems", this, this.id); calculatecommissionValue();')) .
                        CHtml::hiddenField("AccVoucherItems[$n][subledger_id]", $eachemployee['subledger_id']) .
                        CHtml::hiddenField("AccVoucherItems[$n][commission_amount]", $eachemployee['commission_amount']) .
                        ' ' . ($n + 1) . '</td>';
                    $tbl_contents .= '<td>' . $eachemployee['subledger_name'] . '</td>';
                    $tbl_contents .= '<td class="text-right">' . $eachemployee['commission_amount'] . '</td>';
                    $tbl_contents .= '<td class="text-right">' . CHtml::textField("AccVoucherItems[$n][paid_amount]", '0', array('class' => 'go', 'onkeyup' => 'calculatecommissionValue();', 'onkeypress' => 'return isNumberKey(event);')) . '</td>';
                    $tbl_contents .= '</tr>';
                    $n++;
                }
            }
        } else {
            $tbl_contents .=  '<tr><td colspan="' . $colspan . '" class="text-center text-bold">No Commission Exist</td></tr>';
        }
        $tbl_contents .= '</table>';
        $data['tbl_contents'] = $tbl_contents;
        $data['success'] = $tbl_contents;
        echo CJSON::encode($data);
        Yii::app()->end();
    }


    public function actionGetallocationdataFromPayment()
    {
        $modelMasCurrency = new MasCurrency();
        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];


        $allocationCredit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_credit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        ABS(VI.amount * VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount < 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationCredit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_credit}} WHERE balance > 0')->queryScalar();

        if ($creditAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';

            $tables['credit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-all" onclick="toggleSelectAll()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['credit'] .= '<tbody id="credit_table">';

            if ($creditAllocatables != '') {

                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_credit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (" . $creditAllocatables . ")
                        GROUP BY V.id
                        ORDER BY V.voucher_date";

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();

                foreach ($allItems as $i => $each) {
                    $tables['credit'] .= '<tr>
										<td>' . CHtml::CheckBox('Credit[' . $i . '][check]', '', array('class' => 'credit', 'value' => $each->id, 'onChange' => 'copyValue("Credit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['voucher_type'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('Credit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Credit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Credit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Credit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Credit", this.id, this.value); calculateValue();')) . '</td>
									</tr>';
                }

                $tables['credit'] .= '<tr>
									<td colspan="6" class="text-right"><b>Total</b></td>
									<td>' . CHtml::textfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';

                $tables['credit'] .= '</tbody>';
                $tables['credit'] .= '</table>';
            } else {
                $tables['credit'] .= '<tr>
									<td colspan="7" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }


        echo json_encode($tables);
    }


    public function actionGetExchangeRateFromExchangeMaster_deleted()
    {
        $response = ['success' => true, 'debit' => '', 'error' => ''];
        $modeAccLedger = new AccLedger();
        $base_currency_code = $modeAccLedger->baseCurrencycode();
        $voucher_currency_code       =  $_POST['voucher_currency_code'];
        $receiptledger_currency_code =  $_POST['receiptledger_currency_code'];
        $amount_selected_currency    =  $_POST['amount_selected_currency'];

        $modelMasCurrencyExchange = new MasCurrencyExchange();

        $exchange_rate = $modelMasCurrencyExchange->getcurrencyexchange($voucher_currency_code, $base_currency_code);

        $exchange_rate_diff = $modelMasCurrencyExchange->getcurrencyexchange($receiptledger_currency_code, $voucher_currency_code);

        $response['exchange_rate'] = ($exchange_rate > 0) ? $exchange_rate : 0;

        $exchange_rate_diff = ($exchange_rate_diff > 0) ? $exchange_rate_diff : 0;

        $response['exchange_difference_amount'] = ((float)abs($amount_selected_currency) * (float)$exchange_rate_diff);

        echo json_encode($response);
    }

    public function actionGetMultipleExchangeRates()
    {
        $currencyPairs = $_POST['currencyPairs'];
        $exchangeRates = [];

        $modelMasCurrencyExchange = new MasCurrencyExchange();
        $modeAccLedger = new AccLedger();
        $base_currency_code = $modeAccLedger->baseCurrencycode();
        foreach ($currencyPairs as $pair) {
            $voucher_currency_code = $pair['voucher_currency_code'];
            $receiptledger_currency_code = $pair['receiptledger_currency_code'];

            $exchange_rate = $modelMasCurrencyExchange->getcurrencyexchange($voucher_currency_code, $base_currency_code);
            $exchange_rate_diff = $modelMasCurrencyExchange->getcurrencyexchange($receiptledger_currency_code, $voucher_currency_code);

            $exchangeRates[] = [
                'voucher_currency_code' => $voucher_currency_code,
                'receiptledger_currency_code' => $receiptledger_currency_code,
                'exchange_rate' => ($exchange_rate > 0) ? $exchange_rate : 0,
                'exchange_rate_diff' => ($exchange_rate_diff > 0) ? $exchange_rate_diff : 0
            ];
        }

        echo json_encode($exchangeRates);
    }



    public function actionGetallocationdataFromReceiptDebit()
    {
        $response = ['success' => true, 'debit' => '', 'error' => ''];
        $modelAccLedger = new AccLedger();
        $modelMasCurrency = new MasCurrency();
        $ledger    = (int) $_POST['ledger'];

        $subledger = (int) $_POST['subledger'];


        $allocationdebit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_debit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        (VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount > 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationdebit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_debit}} WHERE balance > 0')->queryScalar();


        if ($debitAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {
            $tables = array();
            $tables['debit'] = '';

            $tables['debit'] .= '<table class="table table-bordered" id="table_credit">        
                                <thead>
                                    <tr>
                                       <th style="width:5%"><input type="checkbox" id="select-all" onclick="toggleSelectAll()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>  
                                    </tr>
                                </thead>';
            $tables['debit'] .= '<tbody id="credit_table">';

            if ($debitAllocatables != '') {
                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_debit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_debit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $debitAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();

                foreach ($allItems as $i => $each) {


                    $tables['debit'] .= '<tr>
                    
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('class' => 'debit', 'value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValuedebit();')) . '</td>
									</tr>';
                }

                $tables['debit'] .= '<tr>
                                            <td colspan="6" class="text-right"><b></b></td>
                                            <td>' . CHtml::hiddenField('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
                                        </tr>';
                $tables['debit'] .= '</tbody>';
                $tables['debit'] .= '</table>';
                //}
            } else {
                $tables['debit'] .= '<tr>
                                        <td colspan="13" class="text-center"><b>No Data</b></td>
                                    </tr>';
            }
        }

        $response['debit'] = $tables['debit'];
        echo json_encode($response);
    }


    public function actionGetallocationdataFromReceiptCredit()
    {

        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];
        $modelMasCurrency = new MasCurrency();

        $allocationcredit = 'CREATE OR REPLACE VIEW {{acc_view_allocated_credit}} AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                       ABS( (VI.amount*VI.exchange_rate)) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount < 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationcredit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM {{acc_view_allocated_credit}} WHERE balance > 0')->queryScalar();



        if ($creditAllocatables === false) {
            $tables = array();
            $tables['credit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['credit'] = '';

            $tables['credit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-allcredit" onclick="toggleSelectAllCREDIT()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:20%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['credit'] .= '<tbody id="credit_table">';


            if ($creditAllocatables != '') {


                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.transaction_number) AS fullvoucher,
                        -COALESCE(C.balance, 0) AS balance
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN {{acc_view_allocated_credit}} C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  {{acc_view_allocated_credit}}  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $creditAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();




                foreach ($allItems as $i => $each) {

                    $tables['credit'] .= '<tr>
                    
										<td>' . CHtml::CheckBox('CREDIT[' . $i . '][check]', '', array('class' => 'credit', 'value' => $each->id, 'onChange' => 'copyValue("CREDIT", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
										<td>' . $modelMasCurrency->baseCurrencyDecimalNumberFormat($each['balance']) . '</td>
										<td>' . CHtml::hiddenfield('CREDIT[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('CREDIT[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('CREDIT[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("CREDIT", this.id, this.value); calculateValuecredit();')) . '</td>
									</tr>';
                }

                $tables['credit'] .= '<tr>
									<td colspan="6" class="text-right"><b>Grand Total</b></td>
									<td>' . CHtml::hiddenfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) .
                    CHtml::textfield('total_amount_crdr', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';
                $tables['credit'] .= '</tbody>';
                $tables['credit'] .= '</table>';
            } else {
                $tables['credit'] .= '<tr>
									<td colspan="7" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }
        echo json_encode($tables);
    }


    public function actionVouchersExcel()
    {

        $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
        $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
        $voucher_type   = (int) $_REQUEST['voucher_type'];
        $warehouse_id   = (int)$_REQUEST['warehouse_id'];
        $outlet_id   = (int)$_REQUEST['outlet_id'];

        $param = array(
            'from_date'    => $from_date,
            'to_date'      => $to_date,
            'voucher_type' => $voucher_type,
            'warehouse_id' => $warehouse_id,
            'outlet_id'    => $outlet_id,

        );

        Yii::app()->clientScript->scriptMap = array('*.js' => false, '*.min.js' => false, '*.css' => false);
        $filename = 'voucher_Excel.xls';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $this->renderPartial('application.modules.accounts.views.voucher.excel.voucher_Excel', $param, false, true);
        Yii::app()->end();
    }

    public function actionPrintPaymentReciptvoucherPdf()
    {
        $model      = new AccVoucher();
        $id         = Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model  = $model->findbyPK($id);
        }
        $mPDF1      = Yii::app()->ePdf->mpdf('', 'A4');
        $page_name  = "voucher_list_new_pdf";
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mPDF1->WriteHTML($stylesheet, 1);
        $mPDF1->WriteHTML($this->renderPartial('application.modules.accounts.views.pdf.' . $page_name, array('model' => $model, 'id' => $id, 'mpdf' => $mPDF1), true));
        $mPDF1->Output("Voucher_" . $id . "_" . strtoupper($model->voucher_no) . ".pdf", 'I');
    }


    function copyVoucher($voucher_id, $voucher_date)
    {
        $existVoucher = AccVoucher::model()->findByPk((int)$voucher_id);

        if ($existVoucher !== null) {
            $modelVoucher = new AccVoucher();
            $modelVoucher->setAttributes($existVoucher->getAttributes());
            $modelVoucher->voucher_date = $voucher_date;
            $modelVoucher->isNewRecord = true;
            $modelVoucher->general_narration = $existVoucher['general_narration'];
            $modelVoucher->imported = 'N';
            $modelVoucher->voucher_no    = AccVoucherType::getVoucherno($existVoucher->voucher_type, true);
            $modelVoucher->transaction_number    =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_id        =  $modelVoucher->voucher_no;
            $modelVoucher->transaction_date      =  $modelVoucher->voucher_date;
            $modelVoucher->lead_owner            = (int)Yii::app()->user->id;
            $modelVoucher->is_posted         = $existVoucher['is_posted'];
            $modelVoucher->created_by       = Yii::app()->user->id;
            $modelVoucher->created_datetime = date('Y-m-d h:i:s');
            $modelVoucher->updated_by       = Yii::app()->user->id;
            $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
            $modelVoucher->save(false);
            $modelVoucher->refresh();
            // inserting to audit log  
            if ($existVoucher['is_posted'] == 'Y') {
                $audit_type = 'POSTED';
            } else {
                $audit_type = 'CREATED';
            }
            AccAuditLog::saveAuditLogs(
                'ACCOUNTS',
                Yii::app()->user->id,
                $audit_type,
                "{$existVoucher->vtype->description} with voucher no: - {$modelVoucher->voucher_no}  "
            );
            // end audit log

            $new_id = $modelVoucher->id;

            $modelItems = AccVoucherItems::model()->findAll('acc_voucher_id=:voucher_id', array(':voucher_id' => $voucher_id));
            foreach ($modelItems as $eachvItem) {
                $modelVi = new AccVoucherItems();
                $modelVi->setAttributes($eachvItem->getAttributes());
                $modelVi->acc_voucher_id = $new_id;
                $modelVi->isNewRecord = true;
                $modelVi->updated_by       = Yii::app()->user->id;
                $modelVi->updated_datetime = date('Y-m-d H:i:s');
                $modelVi->created_by       = Yii::app()->user->id;
                $modelVi->created_datetime = date('Y-m-d H:i:s');
                $modelVi->save(false);
            }
            return true;
        }
    }

    public function actionGetallocationdataFromPaymentCredit()
    {

        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];


        $allocationCredit = 'CREATE OR REPLACE VIEW view_acc_allocated_payment_credit AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        ABS(VI.amount * VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount < 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationCredit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $creditAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM view_acc_allocated_payment_credit WHERE balance > 0')->queryScalar();

        if ($creditAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';

            $tables['credit'] .= '<table class="table table-bordered" id="table_credit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-all" onclick="toggleSelectAll()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:10%">Amount</th>
                                <th style="width:10%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['credit'] .= '<tbody id="credit_table">';

            if ($creditAllocatables != '') {

                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type, V.voucher_no, CONCAT(VT.code, '/', V.voucher_no) AS fullvoucher,
                        COALESCE(C.balance, 0) AS balance,C.amount as amount
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN view_acc_allocated_payment_credit C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  view_acc_allocated_payment_credit  WHERE balance > 0)                       
                        GROUP BY V.id
                        ORDER BY V.voucher_date";

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();

                foreach ($allItems as $i => $each) {
                    $tables['credit'] .= '<tr>
										<td>' . CHtml::CheckBox('Credit[' . $i . '][check]', '', array('class' => 'credit', 'value' => $each->id, 'onChange' => 'copyValue("Credit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['voucher_type'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
                                        <td>' . Yii::app()->numberFormatter->formatCurrency($each['amount'], " ") . '</td>
										<td>' . Yii::app()->numberFormatter->formatCurrency($each['balance'], " ") . '</td>
										<td>' . CHtml::hiddenfield('Credit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Credit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Credit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Credit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Credit", this.id, this.value); calculateValuecredit();')) . '</td>
									</tr>';
                }

                $tables['credit'] .= '<tr>
									
									<td>' . CHtml::hiddenfield('total_credit', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
								</tr>';

                $tables['credit'] .= '</tbody>';
                $tables['credit'] .= '</table>';
            } else {
                $tables['credit'] .= '<tr>
									<td colspan="8" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }


        echo json_encode($tables);
    }

    public function actionGetallocationdataFromPaymentDebit()
    {

        $ledger    = (int) $_POST['ledger'];
        $subledger = (int) $_POST['subledger'];


        $allocationdebit = 'CREATE OR REPLACE VIEW view_acc_allocated_payment_debit AS SELECT
                        V.id AS voucher_id,
                        VI.id AS voucher_item_id,
                        V.voucher_no,
                        ABS(VI.amount * VI.exchange_rate) AS amount,
                        IFNULL(ABS(SUM(AI.amount)), 0) AS allocated,
                        (VI.amount*VI.exchange_rate) - IFNULL(ABS(SUM(AI.amount)), 0) AS balance
                    FROM {{acc_voucher_items}} VI
                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                    LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
                    WHERE V.is_posted = "Y" AND VI.amount > 0 AND VI.ledger_id = :ledger AND VI.subledger_id = :subledger
                    GROUP BY VI.id';

        $command = Yii::app()->db->createCommand($allocationdebit);
        $command->bindParam(':ledger', $ledger, PDO::PARAM_INT);
        $command->bindParam(':subledger', $subledger, PDO::PARAM_INT);
        $command->execute();

        $debitAllocatables = Yii::app()->db->createCommand('SELECT GROUP_CONCAT(voucher_item_id) AS value FROM view_acc_allocated_payment_debit WHERE balance > 0')->queryScalar();



        if ($debitAllocatables === false) {
            $tables = array();
            $tables['debit'] = '';
            $tables['credit'] = '';
        } else {


            $tables = array();
            $tables['debit'] = '';

            $tables['debit'] .= '<table class="table table-bordered" id="table_debit">        
                        <thead>
                            <tr>
                                <th style="width:5%"><input type="checkbox" id="select-all_debit" onclick="toggleDebitSelectAll()"></th>
                                <th style="width:5%">#</th>
                                <th style="width:10%">Ref.</th>  
                                <th style="width:20%">Type</th>      
                                <th style="width:20%">Date</th>
                                <th style="width:10%">Amount</th>
                                <th style="width:10%">Balance</th>     
                                <th style="width:20%">Alloc.</th>           
                            </tr>
                        </thead>';
            $tables['debit'] .= '<tbody id="credit_table">';


            if ($debitAllocatables != '') {


                $sql = "SELECT V.reference_no, V.voucher_date, VI.acc_voucher_id AS header_id, VI.id AS voucher_item_id,
                        VT.code AS voucher_type,VT.description as description, V.voucher_no, CONCAT(VT.code, '/', V.voucher_no) AS fullvoucher,
                        -COALESCE(C.balance, 0) AS balance,C.amount as amount
                        FROM {{acc_voucher_items}} VI
                        LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
                        LEFT JOIN {{acc_voucher_type}} VT ON VT.id = V.voucher_type
                        LEFT JOIN view_acc_allocated_payment_debit C ON C.voucher_item_id = VI.id
                        WHERE VI.id IN (select voucher_item_id from  view_acc_allocated_payment_debit  WHERE balance > 0)
                        GROUP BY V.id
                        ORDER BY V.voucher_date"; //" . $debitAllocatables . "

                $command = Yii::app()->db->createCommand($sql);
                $allItems = $command->queryAll();




                foreach ($allItems as $i => $each) {

                    $tables['debit'] .= '<tr>
                    
										<td>' . CHtml::CheckBox('Debit[' . $i . '][check]', '', array('class' => 'debit', 'value' => $each->id, 'onChange' => 'copyValue("Debit", this, this.id);')) . '</td>
										<td>' . $each['fullvoucher'] . '</td>
                                        <td>' . $each['reference_no'] . '</td>
										<td>' . $each['description'] . '</td>
										<td>' . date('d/m/Y', strtotime($each['voucher_date'])) . '</td>
                                        <td>' . Yii::app()->numberFormatter->formatCurrency($each['amount'], " ") . '</td>
										<td>' . Yii::app()->numberFormatter->formatCurrency($each['balance'], " ") . '</td>
										<td>' . CHtml::hiddenfield('Debit[' . $i . '][voucher_id]', $each['header_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][voucher_item_id]', $each['voucher_item_id']) .
                        CHtml::hiddenfield('Debit[' . $i . '][balance]', $each['balance']) .
                        CHtml::textfield('Debit[' . $i . '][amount]', 0, array('class' => 'form-control text-right', 'onkeyup' => 'validateAmount("Debit", this.id, this.value); calculateValuedebit();')) . '</td>
									</tr>';
                }

                $tables['debit'] .= '<tr>
                <td colspan="7" class="text-right"><b>Grand Total</b></td>
                <td>' . CHtml::hiddenfield('total_debit', 0, array('class' => 'form-control text-right', 'readonly' => true)) .
                    CHtml::textfield('total_payment_amount_crdr', 0, array('class' => 'form-control text-right', 'readonly' => true)) . '</td>
            </tr>';
                $tables['debit'] .= '</tbody>';
                $tables['debit'] .= '</table>';
            } else {
                $tables['debit'] .= '<tr>
									<td colspan="8" class="text-center"><b>No Data</b></td>
								</tr>';
            }
        }



        echo json_encode($tables);
    }

    public function actionUploadVouchers() {
        $model = new Store();
        $inventory_item_type = (int) Yii::app()->request->getParam('inventory_item_type');
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('vouchers_upload_index', array('model' => $model, 'inventory_item_type' => $inventory_item_type), false, false);
    }

    public function actionDownloadVouchersFormat()
    {
        $costcenterOne = $this->checkCostCenter(1);
        $costcenterTwo = $this->checkCostCenter(2);
        $costcenterOneKey = array_key_first($costcenterOne);
        $costcenterOneValue = $costcenterOne[$costcenterOneKey];
        $costcenterTwoKey = array_key_first($costcenterTwo);
        $costcenterTwoValue = $costcenterTwo[$costcenterTwoKey];
        $filename = 'vouchersupload_list.csv';
        header("Content-type: application/vnd.ms-excel");
        header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
        $heads = "Voucher Type,Voucher Date (YYYY-MM-DD),Reference No,Narration,";
        $heads .= "Ledger,SubLedger,Debit,Credit,Remarks";
        if ($costcenterOneValue == 'BRANCH') {
            $heads .= ",Branch";
        } elseif ($costcenterOneValue == 'OUTLET') {
            $heads .= ",Outlet";
        } elseif ($costcenterOneValue == 'DEPARTMENT') {
            $heads .= ",Department";
        }
        if ($costcenterTwoValue == 'BRANCH') {
            $heads .= ",Branch";
        } elseif ($costcenterTwoValue == 'OUTLET') {
            $heads .= ",Outlet";
        } elseif ($costcenterTwoValue == 'DEPARTMENT') {
            $heads .= ",Department";
        }
        echo $heads;
        Yii::app()->end();
    }

    public function actionVouchersUpload($folder = null)
    {
        Yii::import("ext.EAjaxUpload.qqFileUploader");
        $folder = Yii::getPathOfAlias('webroot') . '/' . $folder . '/';
        // make the directory to store the pic:
        if (!is_dir($folder)) {
            mkdir($folder, 0777, TRUE);
            chmod($folder, 0755);
        }
        $allowedExtensions = array();
        $sizeLimit = 2 * 1024 * 1024; // maximum file size in bytes
        $uploader = new qqFileUploader($allowedExtensions, $sizeLimit);
        $result = $uploader->handleUpload($folder);
        $result['fileType'] = pathinfo($folder . $result['filename'], PATHINFO_EXTENSION);
        $return = htmlspecialchars(json_encode($result), ENT_NOQUOTES);
        $fileName = $result['filename']; //GETTING FILE NAME
        echo $return; // it's array
    }

    public function actionSaveUploadVouchersList()
    {
        $costcenterOne = $this->checkCostCenter(1);
        $costcenterTwo = $this->checkCostCenter(2);
        $costcenterOneKey = array_key_first($costcenterOne);
        $costcenterOneValue = $costcenterOne[$costcenterOneKey];
        $costcenterTwoKey = array_key_first($costcenterTwo);
        $costcenterTwoValue = $costcenterTwo[$costcenterTwoKey];
        $file_name = Yii::app()->request->getParam('filename');
        $url = Yii::app()->basePath . '/../upload/vouchersuploadlist/' . $file_name;
        $vouchers_list = $this->readInventoryListCSV("upload/vouchersuploadlist/" . $file_name);
        $error_url = Yii::app()->basePath . '/../upload/vouchersuploadlist/error/' . $file_name;
        $error_list = [];
        $error_occurred = false;
        $hasQuantityGreaterThanZero = false;  // Flag to check if any row has quantity > 0
        // Read the header row separately to preserve it in the log
        $header = array_shift($vouchers_list); // Remove the first line (header)
        // Validate each row and check for errors
        $debitTotal = 0;
        $creditTotal = 0;
        $voucher_total = array();
        if ($vouchers_list) {
            if (count($vouchers_list)>500) {
                $error_occurred = true;
                $jsonData['error_url'] = $error_url;
                $jsonData['link'] = '<div style="font-size: 12px;font-weight: bold;color: #ff4d4f;margin-top: 10px;">Upload failed - The number of records exceeds the 500 records - voucher upload limit.</div>';
                echo json_encode($jsonData);
                return; // Return to stop further execution
            }
            foreach ($vouchers_list as $index => $data) {
                $debit  = $this->sanitizeData($data[6]);
                $credit  = $this->sanitizeData($data[7]);
                $debitTotal += (int) $debit;
                $creditTotal += (int) $credit;
            }
            if (($debitTotal > 0) && ($creditTotal > 0) && ($debitTotal != $creditTotal)) {
                $error_occurred = true;
                $jsonData['error_url'] = $error_url;
                $jsonData['link'] = '<div style="font-size: 12px;font-weight: bold;color: #ff4d4f;margin-top: 10px;">Voucher Debit or Credit Amount is Wrong.</div>';
                echo json_encode($jsonData);
                return; // Return to stop further execution
            } else {
                foreach ($vouchers_list as $index => $data) {
                    if (!empty($data)) {
                        $log_remarks = [];
                        $line_number = $index + 2; // Adjust for the header row
                        // Validate each field and append to log_remarks if invalid
                        $voucher_type  = $this->sanitizeData($data[0]);
                        $voucher_date = $this->sanitizeData($data[1]);
                        $reference        = $this->sanitizeData($data[2]);
                        $narration    = $this->sanitizeData($data[3]);
                        $ledger  = $this->sanitizeData($data[4]);
                        $subledger  = $this->sanitizeData($data[5]);
                        $debit  = $this->sanitizeData($data[6]);
                        $credit  = $this->sanitizeData($data[7]);
                        $remarks  = $this->sanitizeData($data[8]);
                        if ($costcenterOneValue == 'BRANCH') {
                            $branch  = $this->sanitizeData($data[9]);    
                        } elseif ($costcenterOneValue == 'OUTLET') {
                            $outlet  = $this->sanitizeData($data[9]);    
                        } elseif ($costcenterOneValue == 'DEPARTMENT') {
                            $department  = $this->sanitizeData($data[9]);
                        }
                        if ($costcenterTwoValue == 'BRANCH') {
                            $branch  = $this->sanitizeData($data[10]);
                        } elseif ($costcenterTwoValue == 'OUTLET') {
                            $outlet  = $this->sanitizeData($data[10]);
                        } elseif ($costcenterTwoValue == 'DEPARTMENT') {
                            $department  = $this->sanitizeData($data[10]);
                        }
                        $voucher_key = trim($data[0]).'_'.trim($data[1]).'_'.trim($data[2]);
                        $voucher_total[$voucher_key]['debitsum'] += (int) $debit;
                        $voucher_total[$voucher_key]['creditsum'] += (int) $credit;
                        $voucher_total[$voucher_key]['reference'] = $reference;
                        $log_remarks = $this->validateAndPrepareLog($data, $log_remarks, $have_item);
                        // If there are any errors, mark the row as failed and record the errors
                        if (!empty($log_remarks)) {
                            $error_occurred = true;
                            if ($costcenterOneValue && $costcenterTwoValue) {
                                $error_list[$line_number] = [
                                    'voucher_type' => $data[0], 'voucher_date' => $data[1], 'Reference' => $data[2], 'narration' => $data[3], 'ledger' => $data[4], 'sub_ledger' => $data[5], 'debit' => $data[6], 'credit' => $data[7], 'remarks' => $data[8], 'branch' => $data[9], 'outlet' => $data[10], 'log_remarks' => implode(" | ", $log_remarks), // Store log remarks here
                                ];
                            } else if ($costcenterTwoValue || $costcenterOneValue) {
                                $error_list[$line_number] = [
                                    'voucher_type' => $data[0], 'voucher_date' => $data[1], 'Reference' => $data[2], 'narration' => $data[3], 'ledger' => $data[4], 'sub_ledger' => $data[5], 'debit' => $data[6], 'credit' => $data[7], 'remarks' => $data[8], 'branch' => $data[9], 'log_remarks' => implode(" | ", $log_remarks), // Store log remarks here
                                ];
                            } else {
                                $error_list[$line_number] = [
                                    'voucher_type' => $data[0], 'voucher_date' => $data[1], 'Reference' => $data[2], 'narration' => $data[3], 'ledger' => $data[4], 'sub_ledger' => $data[5], 'debit' => $data[6], 'credit' => $data[7], 'remarks' => $data[8], 'log_remarks' => implode(" | ", $log_remarks), // Store log remarks here
                                ];
                            }
                        } else {
                            // No errors, so the log_remarks field is empty
                            if ($costcenterOneValue && $costcenterTwoValue) {
                                $error_list[$line_number] = [
                                    'voucher_type' => $data[0], 'voucher_date' => $data[1], 'Reference' => $data[2], 'narration' => $data[3], 'ledger' => $data[4], 'sub_ledger' => $data[5], 'debit' => $data[6], 'credit' => $data[7], 'remarks' => $data[8], 'branch' => $data[9], 'outlet' => $data[10], 'log_remarks' => '', // No errors, so leave it empty
                                ];
                            } else if ($costcenterOneValue || $costcenterTwoValue) {
                                $error_list[$line_number] = [
                                    'voucher_type' => $data[0], 'voucher_date' => $data[1], 'Reference' => $data[2], 'narration' => $data[3], 'ledger' => $data[4], 'sub_ledger' => $data[5], 'debit' => $data[6], 'credit' => $data[7], 'remarks' => $data[8], 'branch' => $data[9], 'log_remarks' => '', // No errors, so leave it empty
                                ];
                            } else {
                                $error_list[$line_number] = [
                                    'voucher_type' => $data[0], 'voucher_date' => $data[1], 'Reference' => $data[2], 'narration' => $data[3], 'ledger' => $data[4], 'sub_ledger' => $data[5], 'debit' => $data[6], 'credit' => $data[7], 'remarks' => $data[8], 'log_remarks' => '', // No errors, so leave it empty
                                ];
                            }
                        }
                    } else {
                        $error_occurred = true;
                    }
                }
                if ($voucher_total) {
                    foreach ($voucher_total as $voucher_total_item) {
                        if ($voucher_total_item['debitsum'] != $voucher_total_item['creditsum']) {
                            $error_occurred = true;
                            $reference_nos[] = $voucher_total_item['reference'];
                        }
                    }
                    if ($reference_nos) {
                        $jsonData['error_url'] = $error_url;
                        $jsonData['link'] = '<div style="font-size: 12px;font-weight: bold;color: #ff4d4f;margin-top: 10px;">Reference No '.implode(', ', $reference_nos).' Voucher Debit or Credit Amount is Wrong.</div>';
                        echo json_encode($jsonData);
                        return; // Return to stop further execution
                    }
                }
            }
        } else {
            $error_occurred = true;
            $error_list[1]['log_remarks'] = 'No data found';
        }
        // If any errors occurred, write to error log and stop saving
        if ($error_occurred) {
            $file_error = fopen($error_url, "w+");
            // Add headers to the CSV file
            if ($costcenterOneValue && $costcenterTwoValue) {
                $headers = ['Voucher Type', 'Voucher Date', 'Reference', 'Narration', 'Ledger', 'Sub Ledger', 'Debit', 'Credit', 'Remarks', ucfirst(strtolower($costcenterOneValue)), ucfirst(strtolower($costcenterTwoValue)), 'Log Remarks'];
            } else if ($costcenterOneValue || $costcenterTwoValue) {
                if ($costcenterOneValue) {
                    $headers = ['Voucher Type', 'Voucher Date', 'Reference', 'Narration', 'Ledger', 'Sub Ledger', 'Debit', 'Credit', 'Remarks', ucfirst(strtolower($costcenterOneValue)), 'Log Remarks'];
                } else {
                    $headers = ['Voucher Type', 'Voucher Date', 'Reference', 'Narration', 'Ledger', 'Sub Ledger', 'Debit', 'Credit', 'Remarks', ucfirst(strtolower($costcenterTwoValue)), 'Log Remarks'];
                }
            } else {
                $headers = ['Voucher Type', 'Voucher Date', 'Reference', 'Narration', 'Ledger', 'Sub Ledger', 'Debit', 'Credit', 'Remarks', 'Log Remarks'];
            }
            fputcsv($file_error, $headers);
            // Add each line from the original CSV, including rows with no errors
            
            foreach ($error_list as $error_detail) {
                if ($vouchers_list) {
                    if ($costcenterOneValue && $costcenterTwoValue) {
                        $line = [
                            $error_detail['voucher_type'], $error_detail['voucher_date'], $error_detail['reference'], $error_detail['narration'], $error_detail['ledger'], $error_detail['subledger'], $error_detail['debit'], $error_detail['credit'], $error_detail['remarks'], $error_detail['branch'], $error_detail['outlet'], $error_detail['log_remarks'], // Include log remarks, empty if no error
                        ];
                    } else if ($costcenterOneValue || $costcenterTwoValue) {
                        $line = [
                            $error_detail['voucher_type'], $error_detail['voucher_date'], $error_detail['reference'], $error_detail['narration'], $error_detail['ledger'], $error_detail['subledger'], $error_detail['debit'], $error_detail['credit'], $error_detail['remarks'], $error_detail['branch'], $error_detail['log_remarks'], // Include log remarks, empty if no error
                        ];
                    } else {
                        $line = [
                            $error_detail['voucher_type'], $error_detail['voucher_date'], $error_detail['reference'], $error_detail['narration'], $error_detail['ledger'], $error_detail['subledger'], $error_detail['debit'], $error_detail['credit'], $error_detail['remarks'], $error_detail['log_remarks'], // Include log remarks, empty if no error
                        ];
                    }
                } else {
                    $line = [$error_list[1]['log_remarks']];
                }
                fputcsv($file_error, $line);
            }
            fclose($file_error);
            $jsonData['error_url'] = $error_url;
            $jsonData['filename'] = $file_name;
            $jsonData['link'] = CHtml::link('Download Log', array('voucher/DownloadErrorCsv', 'id' => $file_name), array(
                'target' => '_blank',
                'style' => '
                    display: inline-block; border: 2px solid #ff4d4f; padding: 5px 15px;border-radius: -3px;font-size: 12px;font-weight: bold; background: #ff4d4f; color: #fff;text-decoration: none;text-align: center; margin-bottom: 10px;'
            )) . '</div>
            <div style="font-size: 12px;font-weight: bold;color: #ff4d4f;margin-top: 10px;">Data updation failed. Please see this file.</div>';
            echo json_encode($jsonData);
            return; // Return to stop further execution
        }
        // Process and save valid rows if no errors occurred
        $sql = "TRUNCATE TABLE `temp_inventory_uploaded_list`";
        Yii::app()->db->createCommand($sql)->execute();
        $voucherData = $voucherItemsData = array();        
        foreach ($vouchers_list as $key => $data) {
            $voucher_key = trim($data[0]).'_'.trim($data[1]).'_'.trim($data[2]);
            $condition = '(description LIKE "%' . trim($data[0]) . '%")';
            $query = 'SELECT id FROM {{acc_voucher_type}} WHERE ' . $condition . ' ORDER BY description';
            $voucher_type_id = Yii::app()->db->createCommand($query)->queryScalar();
            if ($data[1] != '' && $data[1] != '0000-00-00') {
                $voucher_date = date("Y-m-d", strtotime(str_replace('/', '-', $data[1])));
            }
            $condition = '(ledger_acc_name LIKE "%' . trim($data[4]) . '%")';
            $condition .= 'AND is_parent="N"';
            $query = 'SELECT id FROM {{acc_ledger}} WHERE ' . $condition . ' ORDER BY ledger_acc_name';
            $ledger_id = Yii::app()->db->createCommand($query)->queryScalar();
            $modelAccLedger = new AccLedger();
            $acc_ledger = $modelAccLedger->findByPk($ledger_id);
            $subledger_types = $acc_ledger_det->subledger_types;
            if ($subledger_types) {
                $condition = 'subledger_type IN (' . $subledger_types . ') AND subledger_name LIKE "%' . trim($data[5]) . '%"';
                $query = 'SELECT * FROM {{acc_subledger}} WHERE ' . $condition . ' ORDER BY subledger_name';
                $subledger_id = Yii::app()->db->createCommand($query)->queryScalar();
            }
            $modelMasDepartment = new MasDepartment();
            $departmentArray =  $modelMasDepartment->getDepartment();
            $modelMasOutlet = new MasOutlet();
            $outletArray =  $modelMasOutlet->getOutlet();
            $modelMasInventoryWarehouse = new MasInventoryWarehouse();
            $warehouseArray =  $modelMasInventoryWarehouse->getWarehouse();
            if ($costcenterOneKey == 'warehouse_id') {
                $branch_id = array_search($data[9], $warehouseArray);
            } else if ($costcenterOneKey == 'outlet_id') {
                $outlet_id = array_search($data[9], $outletArray);
            } else if ($costcenterOneKey == 'department_id') {
                $department_id = array_search($data[9], $departmentArray);
            }
            if ($costcenterTwoKey == 'warehouse_id') {
                $branch_id = array_search($data[10], $warehouseArray);
            } else if ($costcenterTwoKey == 'outlet_id') {
                $outlet_id = array_search($data[10], $outletArray);
            } else if ($costcenterTwoKey == 'department_id') {
                $department_id = array_search($data[10], $departmentArray);
            }
            $voucherData[$voucher_key]['voucher_type'] = $this->sanitizeData($voucher_type_id);
            $voucherData[$voucher_key]['voucher_date'] = $this->sanitizeData($voucher_date);
            $voucherData[$voucher_key]['reference'] = $this->sanitizeData($data[2]);
            $voucherData[$voucher_key]['narration'] = $this->sanitizeData($data[3]);
            $voucherData[$voucher_key]['debitsum'] += (int) $this->sanitizeData($data[6]);
            $voucherData[$voucher_key]['creditsum'] += (int) $this->sanitizeData($data[7]);
            $voucherData[$voucher_key]['items'][$key]['ledger'] = $this->sanitizeData($ledger_id);
            $voucherData[$voucher_key]['items'][$key]['subledger'] = $this->sanitizeData($subledger_id);
            $voucherData[$voucher_key]['items'][$key]['debit'] = $this->sanitizeData($data[6]);
            $voucherData[$voucher_key]['items'][$key]['credit'] = $this->sanitizeData($data[7]);
            $voucherData[$voucher_key]['items'][$key]['remarks'] = $this->sanitizeData($data[8]);
            $voucherData[$voucher_key]['items'][$key]['branch'] = $this->sanitizeData($branch_id);
            $voucherData[$voucher_key]['items'][$key]['outlet'] = $this->sanitizeData($outlet_id);
            $voucherData[$voucher_key]['items'][$key]['department'] = $this->sanitizeData($department_id);
        }
        $this->saveUploadVoucher($voucherData);
        echo CJSON::encode(['status' => 'success', 'message' => 'Data uploaded successfully.']);
    }

    private function validateAndPrepareLog($data, &$error_list, $have_item)
    {
        $costcenterOne = $this->checkCostCenter(1);
        $costcenterTwo = $this->checkCostCenter(2);
        $costcenterOneKey = array_key_first($costcenterOne);
        $costcenterOneValue = $costcenterOne[$costcenterOneKey];
        $costcenterTwoKey = array_key_first($costcenterTwo);
        $costcenterTwoValue = $costcenterTwo[$costcenterTwoKey];
        $log_remarks = [];
        $voucher_type = $this->sanitizeData($data[0]);
        $voucher_date = $this->sanitizeData($data[1]);
        $reference = $this->sanitizeData($data[2]);
        $narration = $this->sanitizeData($data[3]);
        $ledger = $this->sanitizeData($data[4]);
        $subledger = $this->sanitizeData($data[5]);
        $debit = $this->sanitizeData($data[6]);
        $credit = $this->sanitizeData($data[7]);
        $remarks = $this->sanitizeData($data[8]);
        $costcenter1 = $this->sanitizeData($data[9]);
        $costcenter2 = $this->sanitizeData($data[10]);
        
        if (empty(trim($voucher_type))) {
            $log_remarks[] = "Error: Voucher Type is Empty.";
        } else {
            $condition = '(description = "' . $voucher_type . '")';
            $query = 'SELECT * FROM {{acc_voucher_type}} WHERE ' . $condition . ' ORDER BY description';
            $model_voucher_type = Yii::app()->db->createCommand($query)->queryRow();
            if (empty($model_voucher_type)) {
                $log_remarks[] = "Error: Voucher Type Not Found.";
            }
        }
        if (empty(trim($voucher_date))) {
            $log_remarks[] = "Error: Voucher Date is Empty.";
        } else {
            $dateFormat = 'Y-m-d';
            $dateTimeObject = DateTime::createFromFormat($dateFormat, $voucher_date);
            if (!($dateTimeObject && $dateTimeObject->format($dateFormat) === $voucher_date )) {
                $log_remarks[] = "Error: Voucher Date Format is Wrong. Please use 'YYYY-MM-DD' format";
            }
            //   ---------------------AccAuditClose check------------------------------------
            $modelAccAuditClose = new AccAuditClose();
            $existing_date = strtotime($modelAccAuditClose->lastFinalClosedDate());
            if (strtotime($voucher_date) <= $existing_date) {
                $log_remarks[] = 'Error: Given Voucher date must be Greater than Final Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastFinalCloseddate()))) . '';
            } else {
                $existing_date = strtotime($modelAccAuditClose->lastClosedDate());
                if (strtotime($voucher_date) <= $existing_date) {
                    if (!(Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_audit_close_add"]) || ((int) Yii::app()->user->havePermissionOn["acc_final_audit_close_add"]))) {
                        $log_remarks[] = 'Error: Given Voucher date must be Greater than Pre Audit Close Date :-  ' . date("d/m/Y", strtotime(str_replace('/', '-', $modelAccAuditClose->lastCloseddate()))) . '';
                    }
                }
            }
            //   --------------------//-AccAuditClose check------------------------------------ 
        }
        if (empty(trim($reference))) {
            $log_remarks[] = "Error: Voucher Reference is Empty.";
        }
        if (empty(trim($ledger))) {
            $log_remarks[] = "Error: Ledger is Empty.";
        } else {
            $condition = '(ledger_acc_name = "' . $ledger . '")';
            $condition .= 'AND is_parent="N"';
            $query = 'SELECT * FROM {{acc_ledger}} WHERE ' . $condition . ' ORDER BY ledger_acc_name';
            $model_ledger = Yii::app()->db->createCommand($query)->queryRow();
            if (empty($model_ledger)) {
                $log_remarks[] = "Error: Ledger Not Found.";
            }
            if ($model_ledger['have_subledger'] == 'Y') {
                if (empty(trim($subledger))) {
                    $log_remarks[] = "Error: Sub Ledger is Empty.";
                } else {
                    $modelAccLedger = new AccLedger();
                    $acc_ledger_det = $modelAccLedger->findByPk($model_ledger['id']);
                    $subledger_types = $acc_ledger_det->subledger_types;
                    //$modelAccSubledger = new AccSubledger();
                    //$subledger_types_array = $modelAccSubledger->getDropSublegder($subledger_types);
                    if ($subledger_types) {
                        $condition = 'subledger_type IN (' . $subledger_types . ') AND subledger_name = "' . $subledger . '"';
                        $query = 'SELECT * FROM {{acc_subledger}} WHERE ' . $condition . ' ORDER BY subledger_name';
                        $model_subledger = Yii::app()->db->createCommand($query)->queryRow();
                    }
                    if (empty($model_subledger)) {
                        $log_remarks[] = "Error: Sub Ledger Not Found.";
                    }
                }
            }
        }
        if (empty(trim($debit)) && empty(trim($credit))) {
            $log_remarks[] = "Error: Voucher Debit and Credit Amount is Empty.";
        }
        if ((trim($debit)) && (trim($credit))) {
            $log_remarks[] = "Error: Voucher Debit or Credit Amount is Wrong.";
        }
        if (empty(trim($costcenter1))) {
            $log_remarks[] = "Error: Voucher ".ucfirst(strtolower($costcenterOneValue))." is Empty.";
        }
        if (empty(trim($costcenter2))) {
            $log_remarks[] = "Error: Voucher ".ucfirst(strtolower($costcenterTwoValue))." is Empty.";
        }
        return $log_remarks;
    }

    private function sanitizeData($data)
    {
        // Remove commas and trim any extra spaces
        return !empty($data) ? trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"')) : '';
    }

    private function sanitizeNmber($data)
    {
        // Remove commas and trim any extra spaces
        $sanitizedData = !empty($data) ? trim(trim(iconv('UTF-8', 'ASCII//TRANSLIT', $data), '"')) : '';
        // Remove commas and convert to float
        $sanitizedData = str_replace(',', '', $sanitizedData);
        // Return as a float
        return is_numeric($sanitizedData) ? (float)$sanitizedData : 0.0;
    }

    // Method to save errors to a CSV file
    public function actionDownloadErrorCsv()
    {
        $file_name = $event_id = Yii::app()->request->getParam('id');
        $error_url = Yii::app()->basePath . '/../upload/vouchersuploadlist/error/' . $file_name;
        return Yii::app()->getRequest()->sendFile('vouchers_log.csv', @file_get_contents($error_url));
    }

    public function readInventoryListCSV($csvFile)
    {
        $file_handle = fopen($csvFile, 'r');
        $line_of_text = [];
        while (!feof($file_handle)) {
            $contents = fgetcsv($file_handle, 1024, ',');
            if ($contents) {
                $line_of_text[] = $contents;
            }
        }
        fclose($file_handle);
        return $line_of_text;
    }

    private function saveUploadVoucher($voucherDataArray) {
        $tot_debit = 0;
        if (isset($voucherDataArray)) {
            foreach ($voucherDataArray as $voucherData) {
                $modelVoucher = new AccVoucher();
                $modelVoucher->voucher_type = $voucherData['voucher_type'];
                $modelVoucher->voucher_date = $voucherData['voucher_date'];
                $modelVoucher->reference_no = $voucherData['reference'];
                $modelVoucher->general_narration = $voucherData['narration'];
                $modelVoucher->voucher_no = AccVoucherType::getVoucherno($modelVoucher->voucher_type, true);
                $modelVoucher->transaction_date = $modelVoucher->voucher_date;
                $modelVoucher->transaction_number = $modelVoucher->voucher_no;
                $modelVoucher->transaction_id = $modelVoucher->voucher_no;
                $modelVoucher->created_by       = Yii::app()->user->id;
                $modelVoucher->created_datetime = date('Y-m-d h:i:s');
                $modelVoucher->updated_by       = Yii::app()->user->id;
                $modelVoucher->updated_datetime = date('Y-m-d h:i:s');
                $modelVoucher->imported = 'Y';
                $modelVoucher->lead_owner = (int)Yii::app()->user->id;
                $modelVoucher->commingfrom = '';
                $modelVoucher->currency_id = 1;
                $modelVoucher->exchange_rate = 1;
                $modelVoucher->payment_method = '';
                $modelVoucher->bank_name = '';
                $modelVoucher->card_no = '';
                $modelVoucher->cheque_no = '';
                $modelVoucher->cheque_date = '';
                $audit_type = 'CREATED';
                
                $modelVoucherItems = array();
                 if (is_array($voucherData['items'])) {
                    foreach ($voucherData['items'] as $i => $items) {
                        $modelVoucherItems[$i] = new AccVoucherItems();
                        $modelVoucherItems[$i]->updated_by = Yii::app()->user->id;
                        $modelVoucherItems[$i]->updated_datetime = date('Y-m-d H:i:s');
                        $modelVoucherItems[$i]->created_by = Yii::app()->user->id;
                        $modelVoucherItems[$i]->created_datetime = date('Y-m-d H:i:s');
                        $modelVoucherItems[$i]->ledger_id = $items['ledger'];
                        $modelVoucherItems[$i]->subledger_id = $items['subledger'];
                        $modelVoucherItems[$i]->debit = $items['debit'];
                        $modelVoucherItems[$i]->credit = $items['credit'];
                        $modelVoucherItems[$i]->acc_voucher_id = 0;
                        $modelVoucherItems[$i]->narration = ($items['remarks'] == '') ? $voucherData['narration'] : $items['remarks'];
                        $modelVoucherItems[$i]->branch_id = $items['branch']?$items['branch']:'0';
                        $modelVoucherItems[$i]->warehouse_id = $items['branch']?$items['branch']:'0';
                        $modelVoucherItems[$i]->department_id  = $items['department'] ? $items['department'] : '00';
                        $modelVoucherItems[$i]->outlet_id = $items['outlet']?$items['outlet']:'0';

                        $modelVoucherItems[$i]->year = $items['year']?$items['year']:'0';
                        $modelVoucherItems[$i]->company_id = $items['company_id']?$items['company_id']:'0';
                        $modelVoucherItems[$i]->salegroup_id = $items['salegroup_id']?$items['salegroup_id']:'0';
                        $modelVoucherItems[$i]->brand_id = $items['brand_id']?$items['brand_id']:'0';
                        $modelVoucherItems[$i]->employee_id = $items['employee_id'] ? $items['employee_id'] : '000';
                        $modelVoucherItems[$i]->costcenter_id = $items['costcenter_id']?$items['costcenter_id']:'0';
                        $modelVoucherItems[$i]->project_id = $items['project_id'] ? $items['project_id'] : '0000';
                        $modelVoucherItems[$i]->generic_id = $items['generic_id']?$items['generic_id']:'0';
                        $modelVoucherItems[$i]->product_id = $items['product_id']?$items['product_id']:'0';

                        if ($items['debit'] > 0) {
                            $modelVoucherItems[$i]->amount = $items['debit'];
                        } else {
                            $modelVoucherItems[$i]->amount = -1 * (float)$items['credit'];
                        }
                    }
                 }
                $modelVoucher->save();

                // inserting to audit log
                AccAuditLog::saveAuditLogs(
                    'ACCOUNTS',
                    Yii::app()->user->id,
                    $audit_type,
                    "{$modelVoucher->vtype->description} with voucher no: - {$modelVoucher->voucher_no}  "
                );
                // end audit log

                if (!empty($modelVoucherItems)) {
                    $total = 0;
                    foreach ($modelVoucherItems as $eachModel) {
                        if (!empty($eachModel->ledger_id) || $eachModel->ledger_id > 0) {
                            $eachModel->acc_voucher_id  = $modelVoucher->id;
                            if (!empty($eachModel->debit) && $eachModel->debit > 0) {
                                $total += $eachModel->debit;
                                $tot_debit += abs($eachModel->debit);
                            }
                            $eachModel->currency_id    = $modelVoucher->currency_id;
                            $eachModel->exchange_rate  = $modelVoucher->exchange_rate;
                            $eachModel->save(false);
                        }
                    }
                }
                $modelAccVoucher = new AccVoucher();
                $modelAccVoucher->updatebypk($modelVoucher->id, array('amount' => ($tot_debit), 'net_amount' => ($tot_debit), 'voucher_value' => ($tot_debit))); //$netTotal
            }
        }
    }

    private function checkCostCenter($order = 1) {
        $costcenter_1 = $costcenter_2 = 'N';
        $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
        if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand()->select('costcenter_1, costcenter_2')->from('{{acc_general_settings}}')->queryRow();
            $costcenter_1 = $acc_settings['costcenter_1'];
            $costcenter_2 = $acc_settings['costcenter_2'];
        }
        $costcenterMapping = [
            'BRANCH' => ['key' => 'warehouse_id', 'message' => 'Branch cannot be null'],
            'OUTLET' => ['key' => 'outlet_id', 'message' => 'Outlet cannot be null'],
            'DEPARTMENT' => ['key' => 'department_id', 'message' => 'Department cannot be null'],
        ];
        if ($order == 2) {
            $costcenter[$costcenterMapping[$costcenter_2]['key']] = $costcenter_2;
        } else {
            $costcenter[$costcenterMapping[$costcenter_1]['key']] = $costcenter_1;
        }
        return $costcenter;
    }
}
