<?php

/* Subledgers Type
 
 date 21-09-2022
 author -Indhu 
 main setup
 Tables - acc_subledger_type
 Model - AccSubledgerType */


class SubledgertypeController extends Controller
{
    public function accessRules()
    {
        return array(
            array(
                'allow', // allow all users to perform 'index' and 'view' actions
                'actions' => array('login', 'error', 'logout'),
                'users' => array('*'),
            ),
            array(
                'allow', // allow authenticated user to perform 'create' and 'update' actions
                'actions' => array('Index', 'getsubledgertype', 'Create', 'Save'),
                'expression' => '$user->isMember()',
            ),
            array(
                'deny', // deny all users
                'users' => array('*'),
            ),
        );
    }
    
    
 
//    public $modelMasCurrency; 

//     public function init()
//     {
//         parent::init();
//         $this->modelMasCurrency = new MasCurrency();
//     }
    
    

    public function actionIndex()
        {
            if (Yii::app()->user->authorised_user == 1 ||
        (
            isset(Yii::app()->user->havePermissionOn['accounts_menu_view']) && 
            isset(Yii::app()->user->havePermissionOn['acc_subLedger_type_menu_view']) &&
            Yii::app()->user->havePermissionOn['accounts_menu_view'] && 
            Yii::app()->user->havePermissionOn['acc_subLedger_type_menu_view']
        )
    ) {
        $this->render('index');
    } else {
        $this->layout = false;
        $this->renderFile(Yii::getPathOfAlias('application.views.front.site.unauthorised') . '.php');
        Yii::app()->end(); // Prevent further execution
    }
		}
    public function actiongetsubledgertype()
    {
        $model   = new AccSubledgerType();
        $draw    = $_POST['draw'];
        $offset  = $_POST['start'];
        $limit   = $_POST['length'];
        $columns = array(
            // datatable column index  => database column name
            0 => 't.description',
            1 => 't.start_serial',
            2 => 't.last_serial',
            3 => 't.id',
        );
        $filterColumn = $columns[$_POST['order'][0]['column']];
        $filterOrder  = $_POST['order'][0]['dir'];
        $orderBy      = $filterColumn . " " . $filterOrder;
        $condition    = '1=1';

        if (isset($_POST['search']['value']) && trim($_POST['search']['value']) != "") {
            $searchString = trim($_POST['search']['value']);
            $condition    = 't.description LIKE "%' . $searchString . '%" OR t.start_serial LIKE "%' . $searchString . '%"';
        }

        $count = $model->count(array('condition' => $condition));
        $model = $model->findAll(array('condition' => $condition, 'limit' => $limit, 'offset' => $offset, 'order' => $orderBy));

        $recordsTotal            = $count;
        $recordsFiltered         = $count;
        $data['draw']            = $draw;
        $data['recordsTotal']    = $recordsTotal;
        $data['recordsFiltered'] = $recordsFiltered;
        $eachItemData            = array();
        $m = 1;
        foreach ($model as $eachItem) {
            $div = '<div class="btn-wrap text-center">';
            
            if ($eachItem['system_generated'] == 'N') {
                // -----------------------------------------------------------------
                if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_subLedger_type_edit"])) {
                    $div .= '<a href ="#" class="btn btn-theme btn-xs" onclick="loadPopupModal(\'accounts/subledgertype/Create&id=' . $eachItem['id'] . '\',\'Edit Subledger Type \',\'lg\')"><i class="fa fa-edit"></i></a>';
                }
                // -----------------------------------------------------------------
            }
            $div .= '</div>';
            $eachItemData[] = array(
            $eachItem['description'],
            $eachItem['start_serial'],
            $div);
            $m++;
        }
        $data['data'] = $eachItemData;
        echo json_encode($data);
    }



    public function actionCreate()
    {
        $model     = new AccSubledgerType();
        $id        = (int) Yii::app()->request->getParam('id');
        if ($id > 0) {
            $model = $model->findBypk($id);
        }
        Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false, 'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false);
        $this->render('create', array('model' => $model));
    }


    public function actionSave()
    {

        $model = new AccSubledgerType();
        if (isset($_POST['AccSubledgerType'])) {
            $model->created_by           = Yii::app()->user->id;
            $model->created_datetime     = date('Y-m-d h:i:s');
            if ((int) @$_POST['AccSubledgerType']['id'] > 0) {
                $id                      = (int) @$_POST['AccSubledgerType']['id'];
                $model                   = $model->findByPk($id);
                $model->updated_by       = Yii::app()->user->id;
                $model->updated_datetime = date('Y-m-d h:i:s');
            }
            $model->attributes           = $_POST['AccSubledgerType'];
            $model->system_generated    = 'N';
            if ($model->save()) {
                echo json_encode(array('status' => 'success'));
            } else {
                $error1 = json_decode(CActiveForm::validate($model, '', false), true);
                echo CJSON::encode(array_merge_recursive($error1));
            }
        }
    }
}
