<?php

class PdfController extends Controller
{

  public function accessRules()
  {
    return array(
      array(
        'allow', // allow all users to perform 'index' and 'view' actions
        'actions' => array('login', 'error', 'logout'),
        'users' => array('*'),
      ),
      array(
        'allow', // allow authenticated user to perform 'create' and 'update' actions
        'actions' => array(
          'Trial_balance_pdf',
          'Trial_balance_detailed_pdf',
          'Trial_balance_pdf_new',
          'Profit_loss_pdf',
          'Balance_pdf',
          'Balance_ac_pdf',
          'Gl_report_pdf',
          'Gldetailedreportpdf',
          'Statement_pdf',
          'Statement_as_on_pdf',
          'ConsolidatedStatement_pdf',
          'Aging_pdf',
          'vat_summary_pdf',
          'subledger_detail_report_pdf',
          'gl_summary_pdf',
          'Profit_loss_detailed_pdf',
          'Balance_detailed_pdf',
          'statement_pdc_pdf',
          'Auditclose_detailed_pdf',
          'ledger_report_pdf',
          ''
        ),
        'expression' => '$user->isMember()',
      ),
      array(
        'deny', // deny all users
        'users' => array('*'),
      ),
    );
  }


  // --------------------------TrialBalance----Report----------------------------------------


  // public $modelMasCurrency;

  // public function init()
  // {
  //   parent::init();
  //   $this->modelMasCurrency = new MasCurrency();
  // }

  public function actionTrial_balance_pdf()
  {
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];

    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'trial_balance_pdf';
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("TrialBalance" . date("d-m-Y") . ".pdf", 'I');
  }
  
public function actionTrial_balance_pdf_new()
{
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];
    $gl_auditclose_id      = (int) $_REQUEST['gl_auditclose_id'];
    
    $auditclose = AccAuditClose::model()->findByPk($gl_auditclose_id);
    $trialBalanceDetails = AccAccount::model()->getTrialBalanceDetails($from_date, $to_date, $level, $gl_auditclose_id);

    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'trial_balance_pdf_new';
    $param = array(
      'from_date'           => $from_date,
      'to_date'             => $to_date,
      'level'               => $level,
      'type'                => $type,
      'brand'               => $acc_report_brand,
      'outlet_id'           => $outlet_id,
      'department_id'       => $department_id,
      'warehouse_id'        => $warehouse_id,
      'gl_auditclose_id'    => $gl_auditclose_id,
      'auditclose'          => $auditclose,
      'trialBalanceDetails' => $trialBalanceDetails
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("TrialBalance" . date("d-m-Y") . ".pdf", 'I');
}
  
public function actionTrial_balance_detailed_pdf()
{
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $gl_auditclose_id      = $_REQUEST['gl_auditclose_id'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];
    
    $trialBalanceDetails = AccAccount::model()->getTrialBalanceDetails($from_date, $to_date, $level, $gl_auditclose_id);

    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'trial_balance_detailed_pdf';
    $param = array(
      'from_date'           => $from_date,
      'to_date'             => $to_date,
      'level'               => $level,
      'type'                => $type,
      'brand'               => $acc_report_brand,
      'outlet_id'           => $outlet_id,
      'department_id'       => $department_id,
      'warehouse_id'        => $warehouse_id,
      'trialBalanceDetails' => $trialBalanceDetails
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("TrialBalanceDetailed" . date("d-m-Y") . ".pdf", 'I');
}

  public function actionProfit_loss_pdf()
  {
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];

    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'profit_loss_pdf';
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("ProfitLoss" . date("d-m-Y") . ".pdf", 'I');
  }

  public function actionBalance_pdf()
  {
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];

    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'balance_pdf';
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("BalanceReport" . date("d-m-Y") . ".pdf", 'I');
  }

public function actionBalance_ac_pdf()
  {
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level                 = (int) $_REQUEST['level'];
    $gl_auditclose_id       = $_REQUEST['gl_auditclose_id'];
    $type                  = $_REQUEST['type'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];
    
    $balanceSheetDetails = AccAccount::model()->getBalanceSheetDetails($to_date, $level, $gl_auditclose_id);
    
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'balance_ac_pdf';
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'level'         => $level,
      'gl_auditclose_id'         => $gl_auditclose_id,
      'type'          => $type,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
      'balanceSheetDetails' => $balanceSheetDetails
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("BalanceReport" . date("d-m-Y") . ".pdf", 'I');
  }

  public function actionGl_report_pdf()
  {
    $date_field            = $_REQUEST['date_field'];
    $from_date             = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date               = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger_id             = (int) $_REQUEST['ledger_id'];
    $subledger             = (int) $_REQUEST['subledger_id'];
    $currency              = (int) $_REQUEST['currency'];
    $acc_report_brand      = (int) $_REQUEST['acc_report_brand'];
    $department_id         = (int) $_REQUEST['acc_department_id'];
    $outlet_id             = (int) $_REQUEST['acc_outlet_id'];
    $warehouse_id          = (int) $_REQUEST['acc_warehouse_id'];

    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'gl_report_pdf';
    $param = array(
      'date_field'    => $date_field,
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'currency'      => $currency,
      'ledger_id'     => $ledger_id,
      'subledger'     => $subledger,
      'brand'         => $acc_report_brand,
      'outlet_id'     => $outlet_id,
      'department_id' => $department_id,
      'warehouse_id'  => $warehouse_id,
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("GLReport" . date("d-m-Y") . ".pdf", 'I');
  }

  public function actionGldetailedreportpdf()
  {
    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger_id      = (int) $_REQUEST['ledger_id'];
    $subledger_id   = (int) $_REQUEST['subledger_id'];
    $currency       = (int) $_REQUEST['currency'];
    $date_field     = $_REQUEST['date_field'];
    $acc_order_by   = $_REQUEST['acc_order_by'];
    $amount_type    = $_REQUEST['amount_type'];
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'gl_detailed_report_pdf';
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
      'ledger_id'    => $ledger_id,
      'subledger'    => $subledger_id,
      'currency'     => $currency,
      'date_field'   => $date_field,
      'order_by' => $acc_order_by,
      'amount_type'  => $amount_type

    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("GLDetailedReport" . date("d-m-Y") . ".pdf", 'I');
  }

  public function actionStatement_pdf()
  {
    $from      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');
    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $layout    = (int) Yii::app()->request->getParam('layout');
    $type      = Yii::app()->request->getParam('type');
    $currency  = Yii::app()->request->getParam('currency');
    $cur                = MasCurrency::model()->findByPk($currency);
    $exchange_rate      = (float)$cur->exchange_rate;


    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
      'exchange_rate' => $exchange_rate,
    );
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $view = $layout == 1 ? 'pdf_statement_base' : 'pdf_statement_voucher';
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $view, $param, true));
    // $mpdf->WriteHTML($this->renderPartial($view, $param, true));
    $mpdf->Output("statement" . date("d-m-Y") . ".pdf", 'I');
  }



  public function actionStatement_as_on_pdf()
  {
    $from          = '202-01-01';
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');


    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $layout    = (int) Yii::app()->request->getParam('layout');
    $type      = Yii::app()->request->getParam('type');
    $currency  = Yii::app()->request->getParam('currency');


    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
    );
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $view = 'statement_as_on_pdf';
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $view, $param, true));
    // $mpdf->WriteHTML($this->renderPartial($view, $param, true));
    $mpdf->Output("statement" . date("d-m-Y") . ".pdf", 'I');
  }

  public function actionConsolidatedStatement_pdf()
  {
    $from      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');
    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $layout    = (int) Yii::app()->request->getParam('layout');
    $type      = Yii::app()->request->getParam('type');
    $currency  = Yii::app()->request->getParam('currency');
    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
    );
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $view =  'pdf_statement_consolidated';
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $view, $param, true));
    // $mpdf->WriteHTML($this->renderPartial($view, $param, true));
    $mpdf->Output("statement" . date("d-m-Y") . ".pdf", 'I');
  }


  public function actionAging_pdf()
  {
    $from_date    = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-d');
    $to_date      = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger       = (int) Yii::app()->request->getParam('ledger_id');
    $subledger_id = (int) Yii::app()->request->getParam('subledger_id');
    $category     = (Yii::app()->request->getParam('category') == 'RECEIVABLE') ? 'RECEIVABLE' : 'PAYABLE';
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'aging_pdf';
    $param = array(
      'from_date'     => $from_date,
      'to_date'       => $to_date,
      'ledger'        => $ledger,
      'subledger_id'  => $subledger_id,
      'category'      => $category,
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("AgingReport" . date("d-m-Y") . ".pdf", 'I');
  }



  public function actionVat_summary_pdf()
  {
    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');

    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'vat_summary_pdf';
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("VAT_SUMMARY" . date("d-m-Y") . ".pdf", 'I');
  }



  public function actionSubledger_detail_report_pdf()
  {
    $from_date     = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date       = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-t');
    $ledger_id     = (int) $_REQUEST['ledger_id'];
    $subledger     = (int) $_REQUEST['subledger'];
    $warehouse_id  = (int) $_REQUEST['warehouse_id'];
    $outlet_id  = (int) $_REQUEST['outlet_id'];

    $currency      = 1;
    $cur           = MasCurrency::model()->findByPk(1);
    $exchange_rate = $cur->exchange_rate;
    $currency_code = $cur->currency_code;
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'subledger_detail_report_pdf';
    $param = array(
      'from_date'      => $from_date,
      'to_date'        => $to_date,
      'currency'       => $currency,
      'ledger_id'      => $ledger_id,
      'subledger'      => $subledger,
      'exchange_rate'  => $exchange_rate,
      'currency_code'  => $currency_code,
      'warehouse_id'   => $warehouse_id,
      'outlet_id'     => $outlet_id,

    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("SubledgerDetailReport" . date("d-m-Y") . ".pdf", 'I');
  }


  public function actionGl_summary_pdf()
  {

    $ledger        = (int) $_GET['ledger'];
    $from_date      = (count(explode('/', $_GET['from_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['from_date']))) : date('Y-m-d');
    $to_date        = (count(explode('/', $_GET['to_date'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_GET['to_date']))) : date('Y-m-d');
    $brand          = (int) $_GET['brand'];
    $condition      = 'VI.ledger_id="' . $ledger . '" AND V.is_posted = "Y" AND V.voucher_date >= "' . $from_date . '" AND V.voucher_date <= "' . $to_date . '"';
    $glSummaryquery = 'CREATE OR REPLACE VIEW {{acc_view_gl_summary}} AS SELECT
                                        SL.id AS subledger_id,
                                        L.ledger_acc_no AS ledger_no,
        								IFNULL(SL.subledger_name, "No Subledger") AS subledger_name,
                                        ROUND(SUM( CASE WHEN VI.amount > 0 THEN VI.amount*VI.exchange_rate ELSE 0 END ), 4) AS debit,
                                        ROUND(SUM( CASE WHEN VI.amount < 0 THEN ABS(VI.amount*VI.exchange_rate) ELSE 0 END ), 4) AS credit,
        								ROUND(SUM(VI.amount*VI.exchange_rate), 4) AS balance,
                                        L.id AS ledger_id,VI.subledger_id AS voucher_sub_id
        							FROM {{acc_voucher_items}} VI
                                    LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
        							LEFT JOIN {{acc_ledger}} L ON L.id = VI.ledger_id
        							LEFT JOIN {{acc_subledger}} SL ON SL.id = VI.subledger_id
        							WHERE ' . $condition . '
        							GROUP BY  VI.ledger_id, VI.subledger_id';
    Yii::app()->db->createCommand($glSummaryquery)->execute();

    $param = array(
      'to_date'   => $to_date,
      'from_date' => $from_date,
      'ledger'    => $ledger,
    );
    $page_name  = 'gl_summary_report_pdf';
    $mpdf       = Yii::app()->ePdf->mpdf('', 'A4');
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("gl_summary" . date("d-m-Y"), 'I');
  }



  public function actionProfit_loss_detailed_pdf()
  {
    set_time_limit(0);
    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level          = (int) $_REQUEST['level'];
    $type           = $_REQUEST['type'];

    /*$mode = 'A4';
        $mpdf = Yii::app()->ePdf->mpdf('', $mode);
        $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
        $mpdf->WriteHTML($stylesheet, 1);*/


    $mpdf = Yii::app()->ePdf->mpdf('', 'A4');
    $mpdf->AddPage('L'); // Set orientation to landscape
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);


    $page_name = 'profit_loss_detailed_pdf';
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
      'level'        => $level,
      'type'         => $type,
    );


    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));


    $mpdf->Output("ProfitLossReport" . date("d-m-Y") . ".pdf", 'I');
  }


  public function actionBalance_detailed_pdf()
  {
    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level          = (int) $_REQUEST['level'];
    $type           = $_REQUEST['type'];
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'balance_detailed_pdf';
    $param = array(
      'from_date'    => $from_date,
      'to_date'      => $to_date,
      'level'        => $level,
      'type'         => $type,

    );
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("BalanceDetailedReport" . date("d-m-Y") . ".pdf", 'I');
  }

  public function actionstatement_pdc_pdf()
  {
    $from      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $ledger    = (int) Yii::app()->request->getParam('ledger_id');


    $subledger = (int) Yii::app()->request->getParam('subledger_id');
    $layout    = (int) Yii::app()->request->getParam('layout');
    $type      = Yii::app()->request->getParam('type');

    $currency  = Yii::app()->request->getParam('currency');


    $param     = array(
      'ledger_id'    => $ledger,
      'subledger_id' => $subledger,
      'type'         => $type,
      'from_date'    => $from,
      'to_date'      => $to,
      'currency'     => $currency,
    );
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $view = 'statement_pdc_pdf';
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $view, $param, true));
    // $mpdf->WriteHTML($this->renderPartial($view, $param, true));
    $mpdf->Output("statement" . date("d-m-Y") . ".pdf", 'I');
  }


  public function actionAuditclose_detailed_pdf()
  {
    $auditclose_id = (int) $_REQUEST['ac_id'];
    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'auditclose_detailed_pdf';
    $auditclose = AccAuditClose::model()->findByPk($auditclose_id);
    $auditCloseLedgerResults = AccAuditCloseDetails::model()->getAllLedgerWithAuditCloseDetails($auditclose_id);
    $param = array('auditclose'    => $auditclose, 'auditCloseLedgerResults' => $auditCloseLedgerResults);
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    $mpdf->Output("AuditcloseDetailedReport" . date("d-m-Y") . ".pdf", 'I');
  }

  public function actionledger_report_pdf()
  {
    $from_date      = (count(explode('/', $_REQUEST['from'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['from']))) : date('Y-m-01');
    $to_date        = (count(explode('/', $_REQUEST['to'])) == 3) ? date("Y-m-d", strtotime(str_replace('/', '-', $_REQUEST['to']))) : date('Y-m-d');
    $level          = (int) $_REQUEST['level'];
    $year           = (int)$_REQUEST['year'];
    $company        = (int) $_REQUEST['company'];
    $branch         = (int) $_REQUEST['branch'];
    $salesgroup     = (int) $_REQUEST['salesgroup'];
    $brand          = (int) $_REQUEST['brand'];
    $employee       = (int) $_REQUEST['employee'];
    $dep            = (int) $_REQUEST['dep'];
    $costcenter     = (int) $_REQUEST['costcenter'];
    $cate           = (int) $_REQUEST['cate'];
    $project        = (int) $_REQUEST['project'];
    $item           = (int) $_REQUEST['item'];
    $ledger_id      = (int) $_REQUEST['ledger_id'];
    $subledger_id   = (int) $_REQUEST['subledger_id'];
    $currency       = (int) $_REQUEST['currency'];
    $warehouse_id   = (int) $_REQUEST['warehouse_id'];
    $date_field     = $_REQUEST['date_field'];
    $outlet_id     = $_REQUEST['acc_outlet_id'];



    $mode = 'A4';
    $mpdf = Yii::app()->ePdf->mpdf('', $mode);
    $stylesheet = file_get_contents(Yii::getPathOfAlias('webroot.css') . '/pdf_style.css');
    $mpdf->WriteHTML($stylesheet, 1);
    $page_name = 'ledger_report_pdf';
    $param = array(
        'from_date'    => $from_date,
        'to_date'      => $to_date,
        'level'        => $level,
        'year'         => $year,
        'company'      => $company,
        'branch'       => $branch,
        'salesgroup'   => $salesgroup,
        'brand'        => $brand,
        'employee'     => $employee,
        'department'   => $dep,
        'costcenter'   => $costcenter,
        'category'     => $cate,
        'project'      => $project,
        'item'         => $item,
        'ledger_id'    => $ledger_id,
        'subledger'    => $subledger_id,
        'currency'     => $currency,
        'warehouse_id' => $warehouse_id,
        'date_field'   => $date_field,

        'outlet_id'   => $outlet_id,
    );   
    $mpdf->WriteHTML($this->renderPartial('application.modules.accounts.views.reports.pdf.' . $page_name, $param, true));
    // $mpdf->WriteHTML($this->renderPartial($view, $param, true));
    $mpdf->Output("GLReport" . date("d-m-Y") . ".pdf", 'I');
  }

  //end
}
