<?php
/*master for Cost center 
created by rahul on 27-09-2022
tables used - mas_cost_center
 */
class MascostcenterController extends Controller
{
	public function accessRules() {
        return array(
                array('allow', // allow all users to perform 'index' and 'view' actions
                    'actions' => array('login', 'error', 'logout'),
                    'users' => array('*'),
                    ),
                array('allow', // allow authenticated user to perform 'create' and 'update' actions
                    'actions' => array('Index','Create','GetList','Save','DirectAdd','Disable'),
                    'expression' => '$user->isMember()',
                    ),
                array('deny', // deny all users
                    'users' => array('*'),
                    ),
                );
    }
    public function filters()
    {
        return array(
            'accessControl', // perform access control for CRUD operations
            );
    }
    /**
     * This is the default 'index' action that is invoked
     * when an action is not explicitly requested by users.
     */
    public function actionIndex() {
        $this->render('index');
    }

    public function actionCreate()
    {
        $model=new MasCostCenter();
        $id = (int) Yii::app()->request->getParam('id');
        $from =  Yii::app()->request->getParam('from');
        if($id>0){
            $model=$model->findByPk($id);
        }
     Yii::app()->clientScript->scriptMap = array('*jquery.js' => false, '*jquery.min.js' => false,'jquery.min.js' => false, '*jquery-ui.js' => false, '*jquery-ui.min.js' => false , 'jquery-2.1.4.min.js' => false);   
    $this->render('create', array('model' => $model,'from' =>$from), false, true);
    }

    public function actionGetList()
        {
            
                $model=new MasCostCenter();
                $draw    = $_POST['draw'];
                $offset = $_POST['start'];
                $limit  = $_POST['length'];
                $columns = array(
                // datatable column index  => database column name
                   0 =>'t.id',
                  
                   1 =>'cost_center_name',
                   );
                $filterColumn = $columns[$_POST['order'][0]['column']];
                $filterOrder  = $_POST['order'][0]['dir'];
                $orderBy   = $filterColumn." ".$filterOrder;
                $condition = 't.isActive="Y"';
                if(isset($_POST['search']['value']) && $_POST['search']['value']!="")
                {
                  $searchString = $_POST['search']['value'];
                  $condition ="  (cost_center_name LIKE '%".$searchString."%')";
                }
                $count = $model->count(array('condition'=>$condition));
                $model=$model->findAll(array('condition'=>$condition,'limit'=>$limit,'offset'=>$offset,'order'=>$orderBy));
                $recordsTotal = $count;
                $recordsFiltered = $count;
                $data['draw'] = $draw;
                $data['recordsTotal'] = $recordsTotal;
                $data['recordsFiltered'] = $recordsFiltered;
                $rowData=array();
                $m=1;
                foreach ($model as $row)
                {
                    $rowData[]=array($m,
                      
                        $row['cost_center_name'],
                      
                        array('id' => $row['id'],'cost_center_name'=>$row['cost_center_name'],'status' => $row->isActive),
                         $row['isDefault']);

                    $m++;
                }
                $data['data'] = $rowData;
                echo json_encode($data);
      
    }
    public function actionSave()
    {
    $model = new MasCostCenter();
        if (isset($_POST['MasCostCenter']))
        {
            
            if ((int) @$_POST['MasCostCenter']['id'] > 0)
            {   $model->updated_by = Yii::app()->user->id;
                $model->updated_datetime =date('Y-m-d h:i:s');
                $id= (int) @$_POST['MasCostCenter']['id'];
                $model=$model->findByPk($id);
                $audit_type = 'UPDATED';
            }else{
                $audit_type = 'CREATED';
                $model->created_by = Yii::app()->user->id;
                $model->created_datetime =date('Y-m-d h:i:s');
            }
             if($_POST['MasCostCenter']['isDefault'] == "Y"){
                	MasCostCenter::model()->updateAll(array( 'isDefault' => 'N' ), 'isDefault = "Y"' );
            	}
            $model->attributes=$_POST['MasCostCenter'];
            if($model->validate())
               
            {
                 $model->save();
                  // inserting to audit log
            /*      AuditLog::saveAuditLogs(
                    'SALES_GROUPS',
                    Yii::app()->user->id,
                    $audit_type,
                    " with name: - {$model->group_name}  "
                );*/
                // end audit log
                $jsonData['status'] = 'success';
                $jsonData['frm'] = $_POST['cost_center-form'];
                $jsonData['from'] = $_POST['from'];
                $jsonData['id'] = $model->id;
                echo CJSON::encode($jsonData);
            }
            else
            {
                $error = CActiveForm::validate($model, '', false);
                if ($error != '[]')
            echo $error;
            }
        }
    }
   
      public function actionDisable() {
        $id = Yii::app()->request->getparam('id');
        $status = Yii::app()->request->getparam('status');
        $model = new MasCostCenter();
        $model = $model->findByPk($id);
        $model->isActive = ($status == "Y" ) ? "N" : "Y";
        $model->save();
        echo json_encode(array("status" => "success"));
    }
}