<?php
$cs = Yii::app()->getClientScript();
$cs->registerScript(
    "loadledger",
    '$(document).ready(function() {
                    var table_id ="#acc_vouchers";
                    CheckBalnce();
                    var table = $(table_id).on("preXhr.dt", function (e, settings, data) {
                        data.voucher_date_from = $("#voucher_date_from").val();
                        data.voucher_date_to   = $("#voucher_date_to").val();
                        data.voucher_type      = $("#voucher_type").val();
                        data.post_status       = $("#post_status").val();
                        data.import            = $("#import").val();
                        data.warehouse_id      = $("#warehouse_id").val();
                        data.search_value      = $("#acc_search_value").val();
                        return data;
                    }).DataTable({
                     searching: false, // Disable default search 
                     scrollY         : "450px",
                    pageLength      : 100,
                     columns: [
                            {className:""},
                            {className:""},
                            {className:""},
                            {className:""},
                            {className:""},
                            {className:""},
                            {className:""},
                            {className:"text-center "},
                            {className:"sl col-max-5 text-left "},
                            {className:"sl col-max-5 text-left "},
                            {className: ""},
                            {className: ""},
                            ],
                              "order": [[ 10, "desc" ]],
                    "aoColumnDefs": [
                          { "bSortable": false, "aTargets": [11] },
                          {
                             "targets": [12,6],
                             "visible": false,
                          },
                    ],        
                  
                    ajax: {
                        url: "' . Yii::app()->createUrl('accounts/voucher/GetList') . '",
                        type: "POST",
                        cache : false,
                    },
                    serverSide:     true,
                    fixedColumns:   true,
                    processing: true,
                });
                $(".dataTables_scrollFoot").hide();
            });',
    CClientScript::POS_HEAD
);

$cs->registerScript("updatevoucher", "function updatevoucher(id, type) {
    var type1 = type;
    if(type1==1){
        var typex= 'Posting';
     }else{
         var typex= 'Un Posting';
     }

    jConfirm('', 'Confirm  '+typex+' ?', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    
                    'data'  : {'id' : id, 'type' : type},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/voucher/updatevoucher') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Done!');  
                            reloadTable('#acc_vouchers'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error(val); 
                            }); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD);


$cs->registerScript("deleteAccount", "function deleteAccount(id,voucherno) {

    jConfirm('', 'Delete Voucher:-  '+voucherno+' ?', function(r) {
        if (r == true) {
                jQuery.ajax({
                    'dataType':'json',
                    'data'  : {'id' : id},
                    'type':'post',
                    'url': '" . Yii::app()->createUrl('accounts/voucher/DeleteVoucher') . "',
                    'cache': false,
                    'success': function(data) {
                        if(data.status=='success'){
                            t8.success('Deleted Successfully!');  
                            reloadTable('#acc_vouchers'); 
                        }else{
                            $.each(data, function(key, val) { 
                                t8.error(val); 
                            }); 
                            reloadTable('#acc_vouchers'); 
                        }
                    }, 
                    'beforeSend':function(){
                        $('#loader').show();
                    },
                    'complete':function(){
                        $('#loader').hide();   
                    }
                });     
            }
        }); 
};", CClientScript::POS_HEAD);



$cs->registerScript("CheckBalnce",  "function CheckBalnce(id){
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('accounts/voucher/Gettotalcheck') . "',
                'data' : {'currency' : 'check'},
                'success': function(data) {
                    if(data == 'fail')
                    {
                      //  t8.error('Please check the GL table.</br> Amounts not matching!');
                    }
                }

            });
            };", CClientScript::POS_HEAD);

?>

<script>
    function Search() {
        reloadTable($("#acc_vouchers"));
    }
</script>

<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <!------------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_vouchers_add"])) { ?>
            <button class="btn btn-sm btn-theme" onclick="loadPopupModal('accounts/voucher/Create','New Voucher','xl')"><i class="fa fa-plus"></i>New</button>
        <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_payment_menu_view"])) { ?>
            <button class="btn btn-sm btn-theme" title="Add new payment" onclick="loadPopupModal('accounts/voucher/add_payment','New Payment','xl')"><i class="fa fa-file"></i>Payment</button>
        <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_receipt_menu_view"])) { ?>
            <button class="btn btn-sm btn-theme" title="Add new receipt" onclick="loadPopupModal('accounts/voucher/add_receipt','New Receipt','xl')"><i class="fa fa-file"></i>Receipt</button>
        <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_commission_menu_view"])) { ?>
            <!--<button class="btn btn-sm btn-theme" title="Add new Commission" onclick="loadPopupModal('accounts/voucher/add_commission','Commission','xl')"><i class="fa fa-file"></i>Commission</button>-->
        <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_import_menu_view"])) { ?>
            <button class="btn btn-sm btn-theme" title="Import Vouchers" onclick="loadPopupModal('accounts/voucher/importvouchers','Import','xl')"><i class="fa fa-download"></i> Import</button>
        <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <?php if (Yii::app()->user->authorised_user == 1 || ((int) Yii::app()->user->havePermissionOn["acc_receipt_menu_view"])) { ?>
            <button class="btn btn-sm btn-theme" title="Add new Multi Vouchers" onclick="loadPopupModal('accounts/voucher/add_multi_receipt','New Multi Receipt','xl')"><i class="fa fa-file"></i> Multi Receipt</button>
            <!-- <button class="btn btn-sm btn-theme" title="Add new Multi Vouchers" onclick="loadPopupModal('accounts/voucher/add_multi_receipt','New Multi Receipt<br><span style=\'color: red;\'>Before starting this posting, you should ensure that there are no ongoing processes in your browser as well as in your company.</span>','xl')"><i class="fa fa-file"></i> Multi Receipt</button> -->
            <?php } ?>
        <!-- ----------------------------------------------------------------------------------- -->
        <div class="pull-right" style="display:flex;">
            <?php
            $startDate = date("d/m/Y");
            $endDate = date("d/m/Y");
            ?>
            <?php echo CHtml::textField('voucher_date_from', $startDate, array('class' => 'form-control datepicker', 'prompt' => 'Date From')); ?>
            <!----------------------------------->
            <?php echo CHtml::textField('voucher_date_to', $endDate, array('class' => 'form-control datepicker', 'prompt' => 'Date To')); ?>
            <!------------------------------------>
            <?php
            $modelAccVoucherType = new AccVoucherType();
            $modelAccVoucherType_array = $modelAccVoucherType->getVouchertypes();
            echo CHtml::dropdownlist('voucher_type', '', $modelAccVoucherType_array, array('class' => 'form-control', 'prompt' => '--All--')); ?>

            <!------------------------------------>
            <?php
            $modelMasInventoryWarehouse = new MasInventoryWarehouse();
           // echo CHtml::dropdownlist('warehouse_id', '', $modelMasInventoryWarehouse->getWarehouse(), array('class' => 'form-control', 'prompt' => '--All Branch--')); ?>
            <!------------------------------------>
            <button class="btn btn-sm btn-theme" id="add_popup" onclick="reloadTable('#acc_vouchers');"><i class="fa fa-refresh"></i> LOAD</button>
            <!------------------------------------>
        </div>
    </header>
    <div class="panel-body">
        <div class="custom-data-table">
            <div class="row" style="height: 0;">
                <div class="col-md-1" style="float: right;">
                    <button class="btn btn-sm btn-theme" style="padding: 8px 9px;position: relative;top: -5px;float: right;" onclick="reloadTable('#acc_vouchers');"><i class="fa fa-refresh">Search</i></button>
                </div>
             <div class="col-md-2" style="float: right;position: relative;top: -5px;">
            <input class="form-control mr-sm-2" type="search" name="search[value]" id="acc_search_value" data-label="Search" placeholder="Search" aria-label="Search" style="position: relative;left: 50px;">
            </div>
            </div>
            <table class="table table-hover table-bordered personal-task" id="acc_vouchers" style="font-size:13px;">
                <thead>
                    <tr>
                        <td colspan="7"></td>

                        <td style="width: 100px">
                            <?php
                            $array_status = array('Y' => 'Yes', 'N' => 'No');
                            $voucherArray = ["onchange" => "Search()", 'style' => 'width:100px', 'empty' => '-Import-'];
                            echo CHtml::dropDownList("import", "", $array_status, $voucherArray);
                            ?>
                        </td>
                        <td colspan="3"></td>

                        <td style="width: 100px">
                            <?php
                            $array_status = array('Y' => 'Posted', 'N' => 'UnPosted');
                            $voucherArray = ["onchange" => "Search()", 'style' => 'width:150px', 'empty' => '-Status-'];
                            echo CHtml::dropDownList("post_status", "", $array_status, $voucherArray);
                            ?>
                        </td>
                    </tr>
                    
                    <tr>
                        <th>Voucher No</th>
                        <th>File</th>
                        <th>Transaction No</th>
                        <th>Reference</th>
                        <th>Date</th>
                        <th>Voucher Type</th>
                        <th>Branch</th>
                        <th>Imported</th>
                        <th>Ledgers</th>
                        <th>Sub Ledgers</th>
                        <th>Amount</th>
                        <th>Actions</th>
                    </tr>
                </thead>

            </table>
        </div>
    </div>
</section>