<?php
$cs = Yii::app()->getClientScript();
$baseUrl = Yii::app()->baseUrl;

$model_voucher_type = new AccVoucherType();
$model_voucher_type_si = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
$model_voucher_type_pi = $model_voucher_type->find(array('condition' => 'code="PI"'))->id;
$model_voucher_type_cn = $model_voucher_type->find(array('condition' => 'code="CN"'))->id;
$model_voucher_type_dn = $model_voucher_type->find(array('condition' => 'code="DN"'))->id;
$model_voucher_type_gi = $model_voucher_type->find(array('condition' => 'code="GI"'))->id;
$model_voucher_type_gr = $model_voucher_type->find(array('condition' => 'code="GR"'))->id;

?>
<section class="panel">
    <header class="panel-heading clearfix panel-theame">
        <i class="fa fa-copy"></i><span style="font-size: 18px; font-weight: bold;">Duplicate Voucher</span>
        <a href="<?php echo $baseUrl; ?>/index.php?r=accounts/settings/index" class="btn btn-secondary" style="float: right; margin-right: 10px;">
            <i class="fa fa-arrow-left" style="margin-right: 5px;"></i>Back
        </a>
    </header>
    <div class="panel-body" style="padding: 20px;">
        <table class="table table-fixed table-bordered table-primary" id="tbl_alloc_mismatch">
            <thead>
                <tr>
                    <th>No</th>
                    <th>ID</th>
                    <th>Transaction ID</th>
                    <th>Voucher No</th>
                    <th>Voucher Type</th>

                </tr>
            </thead>
            <?php
            $sql_combined = "
            SELECT V.*,VT.*
            FROM erp_invoice INV
            LEFT JOIN {{acc_voucher}} V ON V.transaction_id = INV.id
            LEFT JOIN erp_acc_voucher_type VT ON VT.id = V.voucher_type
            WHERE V.voucher_type = '" . $model_voucher_type_si . "'
            AND V.transaction_id IN (
                SELECT V.transaction_id
                FROM erp_acc_voucher V
                WHERE V.voucher_type = '" . $model_voucher_type_si . "'
                GROUP BY V.transaction_id
                HAVING COUNT(*) > 1
            )
            UNION ALL
            SELECT V.*,VT.*
            FROM erp_purchasinginvoice PNV
            LEFT JOIN erp_acc_voucher V ON V.transaction_id = PNV.id
            LEFT JOIN erp_acc_voucher_type VT ON VT.id = V.voucher_type
            WHERE V.voucher_type = '" . $model_voucher_type_pi . "'
            AND V.transaction_id IN (
                SELECT V.transaction_id
                FROM erp_acc_voucher V
                WHERE V.voucher_type = '" . $model_voucher_type_pi . "'
                GROUP BY V.transaction_id
                HAVING COUNT(*) > 1
            )

            UNION ALL
            SELECT V.*,VT.*
            FROM erp_creditnote PNV
            LEFT JOIN erp_acc_voucher V ON V.transaction_id = PNV.id
            LEFT JOIN erp_acc_voucher_type VT ON VT.id = V.voucher_type
            WHERE V.voucher_type = '" . $model_voucher_type_cn . "'
            AND V.transaction_id IN (
                SELECT V.transaction_id
                FROM erp_acc_voucher V
                WHERE V.voucher_type = '" . $model_voucher_type_cn . "'
                GROUP BY V.transaction_id
                HAVING COUNT(*) > 1
            )
            UNION ALL
            SELECT V.*,VT.*
            FROM erp_purchasing_debit_note PNV
            LEFT JOIN erp_acc_voucher V ON V.transaction_id = PNV.id
            LEFT JOIN erp_acc_voucher_type VT ON VT.id = V.voucher_type
            WHERE V.voucher_type = '" . $model_voucher_type_dn . "'
            AND V.transaction_id IN (
                SELECT V.transaction_id
                FROM erp_acc_voucher V
                WHERE V.voucher_type = '" . $model_voucher_type_dn . "'
                GROUP BY V.transaction_id
                HAVING COUNT(*) > 1
            )
            UNION ALL
            SELECT V.*,VT.*
            FROM erp_inventory_goods_issue PNV
            LEFT JOIN erp_acc_voucher V ON V.transaction_id = PNV.id
            LEFT JOIN erp_acc_voucher_type VT ON VT.id = V.voucher_type
            WHERE V.voucher_type = '" . $model_voucher_type_gi . "'
            AND V.transaction_id IN (
                SELECT V.transaction_id
                FROM erp_acc_voucher V
                WHERE V.voucher_type = '" . $model_voucher_type_gi . "'
                GROUP BY V.transaction_id
                HAVING COUNT(*) > 1
            )
            UNION ALL
            SELECT V.*,VT.*
            FROM erp_inventory_goods_receipt PNV
            LEFT JOIN erp_acc_voucher V ON V.transaction_id = PNV.id
            LEFT JOIN erp_acc_voucher_type VT ON VT.id = V.voucher_type
            WHERE V.voucher_type = '" . $model_voucher_type_gr . "'
            AND V.transaction_id IN (
                SELECT V.transaction_id
                FROM erp_acc_voucher V
                WHERE V.voucher_type = '" . $model_voucher_type_gr . "'
                GROUP BY V.transaction_id
                HAVING COUNT(*) > 1
            )
        ";

            $model_combined = Yii::app()->db->createCommand($sql_combined)->queryAll();
            if (!empty($model_combined)) {
                foreach ($model_combined as $i => $each) {
            ?>
                    <tr>
                        <td><?php echo $i + 1; ?></td>
                        <td><?php echo $each['id']; ?></td>
                        <td><?php echo $each['transaction_id']; ?></td>
                        <td><?php echo $each['voucher_no']; ?></td>
                        <td><?php echo $each['code']; ?></td>
                    </tr>
                <?php }
            } else { ?>
                <tr>
                    <td colspan="5" class="text-center">No data available in table</td>
                </tr>
            <?php } ?>
        </table>
    </div>
</section>