<!--
chart of accounts
Sataement  report
Date 28-12-2022
author -Indhu 
main setup
-->
<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }

    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }

    .to {
        background: rgb(31 103 178);
        color: White;
    }

    .tol1 {
        font-size: 16px !important;
    }

    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }

    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }

    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }

    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }

    .level-5 {
        padding-left: 267px !important;
    }

    .l1 {
        font-size: 17px !important;
    }

    .l2 {
        font-size: 16px !important;
    }

    .l3 {
        font-size: 15px !important;
    }

    .l4 {
        font-size: 14px !important;
    }

    .l5 {
        font-size: 14px !important;
    }

    .txt-right {
        text-align: right !important;
    }
</style>


<?php
function generateUrlx($childModel)
{
    $url = '#'; // Default URL in case of errors
    // Check if $childModel, $childModel->parent, and $childModel->parent->vtype exist
    if (!$childModel || !$childModel->parent || !$childModel->parent->vtype) {
        return $url;
    }
    $code = $childModel->parent->vtype->code;
    $imported = $childModel->parent->imported;
    $baseUrl = "$('#liveSite').val() + 'index.php?r='"; // Base URL

    // If not imported
    if ($imported == 'N') {
        return "window.open($baseUrl + 'accounts/voucher/PrintvoucherPdf&id=" . $childModel->acc_voucher_id . "', '_blank');";
    }

    // Switch case for different voucher types
    switch ($code) {
        case 'SI':
            $headModel = $childModel->parent->vtype->header_table;

            // Simulate tax logic (replace with actual logic if needed)
            $tax = 1; // Default tax value
            $taxType = ($tax > 0) ? 'tax' : 'taxnil';
            return "window.open($baseUrl + 'invoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . "&frm=" . $taxType . "&type=1', '_blank');";
        case 'PI':
            return "window.open($baseUrl + 'purchaseinvoice/PrintInvoiceReportPDF&id=" . $childModel->parent->transaction_id . "', '_blank');";
        case 'DN':
            return "window.open($baseUrl + 'debitnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
        case 'CN':
            return "window.open($baseUrl + 'creditnote/printfile&id=" . $childModel->parent->transaction_id . "', '_blank');";
        default:
            // Default to voucher print if no matching code is found
            return "window.open($baseUrl + 'accounts/voucher/PrintvoucherPdf&id=" . $childModel->acc_voucher_id . "', '_blank');";
    }
}
?>

<table class="table table-hover table-fixed table-bordered" id="gl_table" style="font-size:13px;">
    <thead>
        <tr>
            <th style="width:10%">Date</th>
            <th style="width:10%">Invoice No</th>
            <th style="width:10%">Inv Ref No</th>
            <th style="width:10%">Voucher Type</th>
            <th style="width:10%">DO</th>
            <th style="width:10%">LPO</th>
            <th style="width:10%">Due Date</th>
            <th style="width:10%">Invoice value</th>
            <th style="width:10%">Paid</th>
            <th style="width:10%">Balance</th>
        </tr>
    </thead>
    <?php
    $items = array();



    /*$amountType         = 'VI.amount < 0';
    $paidType           = 'VI.amount > 0';
    if ($_POST['type'] == 'customer') {
        $amountType     = 'VI.amount > 0';
        $paidType       = 'VI.amount < 0';
    }
        $query = 'CREATE OR REPLACE VIEW view_acc_statement AS (SELECT
            V.id AS voucher_id,
            V.voucher_date AS voucher_date,
            V.due_date AS due_date,
            V.reference_no AS reference_no,
            VI.narration AS narration,
            VI.id AS voucher_item_id,
            V.voucher_no,
            ROUND(ABS(VI.amount*VI.exchange_rate), 4) AS amount,
            ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
            ((ROUND(ABS(VI.amount*VI.exchange_rate), 2))- ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 2)) AS balance
            FROM {{acc_voucher_items}} VI
            LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
            LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
            WHERE V.is_posted ="Y" AND V.voucher_date<="' . $to_date . '"  AND ' . $amountType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
            GROUP BY VI.id)

            UNION ALL
            (SELECT
            V.id AS voucher_id,
            V.voucher_date AS voucher_date,
            V.due_date AS due_date,
            V.reference_no AS reference_no,
            VI.narration AS narration,
            VI.id AS voucher_item_id,
            V.voucher_no,
            -(ROUND(ABS(VI.amount*VI.exchange_rate), 2)) AS amount,
            -(ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 2)) AS allocated,
            -((ROUND(ABS(VI.amount*VI.exchange_rate), 2))- ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 2)) AS balance
            FROM {{acc_voucher_items}} VI
            LEFT JOIN {{acc_voucher}} V ON V.id = VI.acc_voucher_id
            LEFT JOIN {{acc_allocation_items}} AI ON AI.voucher_item_id = VI.id
            WHERE V.is_posted ="Y" AND V.voucher_date<="' . $to_date . '"  AND ' . $paidType . ' AND VI.ledger_id = ' . $ledger_id . ' AND VI.subledger_id = ' . $subledger_id . '
            GROUP BY VI.id)
            ';*/




    $query = "
        CREATE OR REPLACE VIEW view_acc_statement AS
        
        SELECT
            V.id AS voucher_id,
            V.voucher_date,
            V.due_date,
            V.reference_no,
            VI.narration,
            VI.id AS voucher_item_id,
            V.voucher_no,
            V.imported,
            SIGN(VI.amount) * ROUND(ABS(VI.amount * VI.exchange_rate), 4) AS amount,
            SIGN(VI.amount) * ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4) AS allocated,
            SIGN(VI.amount) * (ROUND(ABS(VI.amount * VI.exchange_rate), 4) - ROUND(IFNULL(ABS(SUM(AI.amount)), 0), 4)) AS balance
        FROM
            erp_acc_voucher_items VI
        LEFT JOIN erp_acc_voucher V ON V.id = VI.acc_voucher_id
        LEFT JOIN erp_acc_allocation_items AI ON AI.voucher_item_id = VI.id
        WHERE
            V.is_posted = 'Y'
            AND V.voucher_date <='" . $to_date . "'
            AND VI.ledger_id = " . $ledger_id . "
            AND VI.subledger_id = " . $subledger_id . "
            AND VI.amount <> 0
        GROUP BY
            VI.id";



    // --------------------------------------------------------------------


    $opening_bal = '0.00';
    if ($ledger_id > 0 && $subledger_id > 0) {

        Yii::app()->db->createCommand($query)->execute();
        $opening_bal = '0.00';
        if ($from_date != '') {
            $opening_bal = Yii::app()->db->createCommand('SELECT SUM(balance) FROM view_acc_statement where balance!=0 and voucher_date<"' . $from_date . '" order by voucher_date')->queryScalar();
            $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement where balance!=0 and voucher_date>="' . $from_date . '" order by voucher_date')->queryAll();
        } else {
            $items = Yii::app()->db->createCommand('SELECT * FROM view_acc_statement  where balance!=0  order by voucher_date')->queryAll();
        }
    }
    $amount = 0;
    $allocated = 0;
    $balanced = 0;   
    ?>
    <tbody>
        <?php if ($from_date != '') { ?>
            <tr style=" background: #c3c8d1">
                <td colspan="7" class="text-center" style="text-align:center !important;"><b>Opening Balance</b></td>
                <td style="text-align:right !important;"><?php echo number_format(($opening_bal / $exchange_rate), 2); ?></td>
                <td style="text-align:right !important;"><?php echo  number_format((0 / $exchange_rate)); ?></td>
                <td class="text-right" style="text-align:right !important;"><?php echo number_format(($opening_bal / $exchange_rate)); ?></td>
            </tr>
        <?php } ?>
        <?php
        $amount += $opening_bal;
        $allocated += 0;
        $balanced += $opening_bal;
        ?>
        <?php if (!empty($items)) {

            $model_voucher_type = new AccVoucherType();
            foreach ($items as $each) {
                if (round($each['balance'], 2) != 0) {
                    $do = '';
                    $lpo = '';

                    $do = '-';
                    $lpo = '-';
                    $inv_ref_no = '';
                    $ref = '';

                    $head = AccVoucher::model()->findByPk($each['voucher_id']);

                    $model_voucher_type_si = $model_voucher_type->find(array('condition' => 'code="SI"'))->id;
                    $model_voucher_type_pi = $model_voucher_type->find(array('condition' => 'code="PI"'))->id;
                    if ($type == 'customer') {
                        if (((int)$head->voucher_type == (int)$model_voucher_type_si) && $each['imported'] == 'Y') {
                            $inv = Invoice::model()->findByPk($head->transaction_id);
                            if ($inv) {
                                $do = $inv->delivery_ids;
                                $lpo = $inv->order_id;
                                $inv_ref_no = $inv->file_id;
                                $ref = $inv->id;
                            }
                        }
                    } else {

                        if (((int)$head->voucher_type == (int)$model_voucher_type_pi) && $each['imported'] == 'Y') {
                            $purchasingInvoice = PurchasingInvoice::model()->findByPk($head->transaction_id);
                            if ($purchasingInvoice) {
                                $inv_ref_no = $purchasingInvoice->invoice_no;
                                $ref = $purchasingInvoice->id;
                            }
                        }
                    }
                    $ref = empty($ref) ? $head->voucher_no : $ref;
                    // Format the voucher link
                    $vouchreformat = '<a href="#" onclick="' . generateUrlx(AccVoucherItems::model()->findByPk((int)$each['voucher_item_id'])) . '">' . $ref . '</a>';
                    // Ensure $inv_ref_no has a value
                    $inv_ref_no = empty($inv_ref_no) ? $head->voucher_no : $inv_ref_no;
                    $head = AccVoucher::model()->findByPk($each['voucher_id']);
                    $AccVoucherType = AccVoucherType::model()->findByPk($head->voucher_type)->description;
        ?>
                    <tr>
                        <td>
                            <?php echo  date("d/m/Y", strtotime($each['voucher_date'])) ?>
                        </td>
                        <td><?php echo $vouchreformat; ?></td>
                        <td><?php echo $inv_ref_no; ?></td>
                        <td><?php echo $AccVoucherType; ?></td>
                        <td><?php echo $do; ?></td>
                        <td><?php echo $lpo; ?></td>
                        <td>
                            <?php echo ($each['voucher_date'] == '0000-00-00') ? '' : date("d/m/Y", timestamp: strtotime($each['voucher_date'])); ?>
                        </td>
                        <td style="text-align:right !important;"><?php echo number_format(($each['amount'] / $exchange_rate), 2); ?></td>
                        <td style="text-align:right !important;"><?php echo number_format(($each['allocated'] / $exchange_rate), 2); ?></td>
                        <td style="text-align:right !important;"><?php echo number_format(($each['balance'] / $exchange_rate), 2); ?></td>
                    </tr>
            <?php
                    $amount += $each['amount'] / $exchange_rate;
                    $allocated += $each['allocated'] / $exchange_rate;
                    $balanced += $each['balance'] / $exchange_rate;
                }
            } ?>
            <tr>
                <td colspan="7"></td>
                <td style="text-align:right !important;"><?php echo number_format(($amount / $exchange_rate), 2); ?></td>
                <td style="text-align:right !important;"><?php echo number_format(($allocated / $exchange_rate), 2); ?></td>
                <td style="text-align:right !important;"><?php echo number_format(($balanced / $exchange_rate), 2); ?></td>
            </tr>
        <?php } else { ?>
            <tr>
                <td colspan="10" style="text-align:center !important;">No Data</td>
            </tr>

        <?php } ?>

    </tbody>
</table>