<!--
chart of accounts
Profit and loss report
date 03-10-2022
updated- date 16-12-2022
author -Jisha Ver 2
main setup
-->

<style>
    .level1 {
        background: #b4c6e7;
        color: black;
    }

    .levelnet {
        background: #a8d08d;
        color: black;
    }

    .levelnetloss {
        background: #e87b7b;
        color: black;
    }

    .to {
        background: rgb(31 103 178);
        color: White;
    }

    .tol1 {
        font-size: 16px !important;
    }

    .level-1 {
        padding-left: 5px !important;
        font-weight: bold;
    }

    .level-2 {
        padding-left: 50px !important;
        font-weight: bold;
    }

    .level-3 {
        padding-left: 104px !important;
        font-weight: bold;
    }

    .level-4 {
        padding-left: 197px !important;
        font-weight: bold;
    }

    .level-5 {
        padding-left: 267px !important;
    }

    .l1 {
        font-size: 17px !important;
    }

    .l2 {
        font-size: 16px !important;
    }

    .l3 {
        font-size: 15px !important;
    }

    .l4 {
        font-size: 14px !important;
    }

    .l5 {
        font-size: 14px !important;
    }

    .txt-right {
        text-align: right !important;
    }
</style>
<script>
    function showhideOpening() {
        $('#div_opening_closing').show();
    }
</script>
<table class="table-tree">
    <thead>
        <tr class="to tol1">
            <th class="cell-left">Account No.</th>
            <th class="cell-left">Description</th>
            <th>Debit</th>
            <th>Credit</th>
        </tr>
    </thead>
    <?php
    /* filter conditions  ----start---- */
    $condition = ' is_posted="Y" ';
    if ($gl_auditclose_id) {
        $auditClose = AccAuditClose::model()->findByPk($gl_auditclose_id);
        $from_date = $auditClose->close_date;
    }
    if (!empty($from_date)) {
        $from_date = str_replace('/', '-', $from_date);
        $from_date = date('Y-m-d', strtotime($from_date));
        $condition .= ' AND voucher_date >="' . $from_date . '"';
    }
    if (!empty($to_date)) {
        $to_date = str_replace('/', '-', $to_date);
        $to_date = date('Y-m-d', strtotime($to_date));
        $condition .= ' AND voucher_date <="' . $to_date . '"';
    }
    if (!empty($company)) {
        $condition .= " AND company_id = '{$company}'";
    }
    if (!empty($branch)) {
        $condition .= " AND warehouse_id = '{$branch}'";
    }
    if (!empty($salesgroup)) {
        $condition .= " AND salegroup_id = '{$salesgroup}'";
    }
    if (!empty($brand)) {
        $condition .= " AND brand_id = '{$brand}'";
    }
    if (!empty($costcenter)) {
        $condition .= " AND costcenter_id = '{$costcenter}'";
    }
    if (!empty($department)) {
        $condition .= " AND department_id = '{$department}'";
    }
    if (!empty($project)) {
        $condition .= " AND project_id = '{$project}'";
    }
    if (!empty($employee)) {
        $condition .= " AND employee_id = '{$employee}'";
    }
    if (!empty($warehouse_id)) {
        $condition .= " AND warehouse_id = '{$warehouse_id}'";
    }
    if (!empty($outlet_id)) {
        $condition .= " AND outlet_id = '{$outlet_id}'";
    }
    $maincondition = '';
    if ($level > 0) {
        $maincondition .= " AND level <= '{$level}'";
    }
    /* if (!empty($category)) {
      $condition .= " AND  generic_id = '" . $category . "'";
      } */
    /* if (!empty($item)) {
      $condition .= " AND  generic_id = '" . $item . "'";
      } */
    /* filter conditions  ----end---- */
    /*merged query for all ledger List In Profit AND LOSS*/
    $pl_transactions_query = "
                CREATE OR REPLACE VIEW view_acc_transactions_pl AS (
                        SELECT
                            ledger_id,root,
                            ledger_acc_no,
                            ledger_acc_name,
                            level,
                            is_parent,
                            ledger_main_acc,
                            IFNULL(SUM(debit + credit),
                            0) AS amount,COUNT(ledger_id) AS transaction_count,ledger_parent_acc
                        FROM
                            view_account_voucher_items
                        WHERE
                            {$condition}
                        GROUP BY
                            ledger_id
                    )
                    UNION ALL
                    (
                        SELECT
                            id AS ledger_id,root,
                            ledger_acc_no,
                            ledger_acc_name,
                            level,
                            is_parent,
                            ledger_main_acc,
                            0 AS amount,0 AS transaction_count,ledger_parent_acc
                        FROM
                            erp_acc_ledger
                        WHERE 1=1 {$maincondition}
                    )
    ";
    Yii::app()->db->createCommand($pl_transactions_query)->execute();



    $pl_query = "
            CREATE OR REPLACE VIEW view_profit_and_loss AS
            SELECT
                ledger_id,root,
                ledger_acc_no,
                ledger_acc_name,
                level,
                is_parent,
                ledger_main_acc,
                IFNULL(SUM(amount), 0) AS amount,IFNULL(SUM(transaction_count),
                0) AS transaction_count,ledger_parent_acc
            FROM
               view_acc_transactions_pl
            WHERE 1=1 AND ledger_main_acc IN ('I','E','GP','NP','EB','CO') {$maincondition}
            GROUP BY
                ledger_id";
    Yii::app()->db->createCommand($pl_query)->execute();

    // ---------------------------------------------------------------------------------
    // ---------------------------------------------------------------------------------
    $modelMasCurrency =  new MasCurrency();
    $modelAccSystemAccountsMapping = new AccSystemAccountsMapping();
    $closing_stock                 = $modelAccSystemAccountsMapping->getSystemdefault('closing_stock');
    $opening_stock                 = $modelAccSystemAccountsMapping->getSystemdefault('opening_stock');

    $closing_stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_closing_stock_state_as_of AS
                                        (SELECT S.id AS product_id, S.part_number, S.description ,
                                        S.bar_code, S.brand_class_id AS brand_id,B.product_class AS brand,L.warehouse_id,SUM(L.quantity * unit_factor) AS quantity,
                                        SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate,
                                         S.generic_id, G.generic_name 
                                        FROM erp_stock_ledger L
                                        LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id
                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        WHERE S.inventory_item_type IN (1,3) 
                                        AND L.transaction_date <= "' . $to_date . '" AND stock_updated="Y" 
                                        GROUP BY L.warehouse_id,S.id)
                                        UNION ALL 
                                        (SELECT S.id AS product_id,S.part_number,S.description,S.bar_code,S.brand_class_id AS brand_id,B.product_class AS brand,"0" AS warehouse_id,
                                        "0" AS quantity ,S.rate,S.generic_id,G.generic_name
                                        FROM erp_store S 
                                        LEFT JOIN erp_product_class B ON B.id = S.brand_class_id 
                                        LEFT JOIN  erp_inventory_generic_name G ON  G.id = S.generic_id
                                        LEFT JOIN erp_unit_of_measurement U ON U.product_id = S.id)
                                        ORDER BY part_number ';
    Yii::app()->db->createCommand($closing_stock_state_as_of_query)->execute();

    $opening_stock_state_as_of_query = 'CREATE OR REPLACE VIEW view_opening_stock_state_as_of AS
                                        (SELECT S.id AS product_id, S.part_number, S.description ,
                                        S.bar_code, S.brand_class_id AS brand_id,B.product_class AS brand,L.warehouse_id,SUM(L.quantity * unit_factor) AS quantity,
                                        SUBSTRING_INDEX( GROUP_CONCAT(CAST(L.cost_price AS CHAR) ORDER BY L.transaction_date DESC), ",", 1 ) AS rate,
                                         S.generic_id, G.generic_name 
                                        FROM erp_stock_ledger L
                                        LEFT JOIN erp_store S ON S.id = L.product_id LEFT JOIN erp_product_class B ON S.brand_class_id = B.id
                                        LEFT JOIN erp_inventory_generic_name G ON S.generic_id = G.id 
                                        WHERE S.inventory_item_type IN (1,3) 
                                        AND L.transaction_date <= "' . $from_date . '" AND stock_updated="Y" 
                                        GROUP BY L.warehouse_id,S.id)
                                        UNION ALL 
                                        (SELECT S.id AS product_id,S.part_number,S.description,S.bar_code,S.brand_class_id AS brand_id,B.product_class AS brand,"0" AS warehouse_id,
                                        "0" AS quantity ,S.rate,S.generic_id,G.generic_name
                                        FROM erp_store S 
                                        LEFT JOIN erp_product_class B ON B.id = S.brand_class_id 
                                        LEFT JOIN  erp_inventory_generic_name G ON  G.id = S.generic_id
                                        LEFT JOIN erp_unit_of_measurement U ON U.product_id = S.id)
                                        ORDER BY part_number ';
    Yii::app()->db->createCommand($opening_stock_state_as_of_query)->execute();



    $closing_balance_amt = -1 * Yii::app()->db->createCommand("SELECT IFNULL(SUM(rate*quantity),0) FROM view_closing_stock_state_as_of ")->queryScalar();
    $opening_balance_amt = Yii::app()->db->createCommand("SELECT IFNULL(SUM(rate*quantity),0) FROM view_opening_stock_state_as_of ")->queryScalar();
    // ---------------------------------------------------------------------------------
    // ---------------------------------------------------------------------------------
    $pb_sql = "SELECT * FROM view_profit_and_loss ORDER BY  level DESC";
    $arr_plledgers = Yii::app()->db->createCommand($pb_sql)->queryAll();
    $led_sql = "SELECT * FROM erp_acc_ledger WHERE 1=1 AND ledger_main_acc IN ('I','E','GP','NP','EB','CO'){$maincondition} ORDER BY  ledger_acc_no ASC";
    $arr_ledgers = Yii::app()->db->createCommand($led_sql)->queryAll();
    $arr_tb = [];
    foreach ($arr_ledgers as $eachledger) {
        $arr_tb[$eachledger['id']]['amount'] = 0;
        $arr_tb[$eachledger['id']]['transaction_count'] = 0;
    }
    foreach ($arr_plledgers as $eachledger) {
        $arr_tb[$eachledger['ledger_id']]['transaction_count'] = $eachledger['transaction_count'];
        $arr_tb[$eachledger['ledger_id']]['amount'] += $eachledger['amount'];
        if ((int)$eachledger['ledger_parent_acc'] > 0) {
            $arr_tb[(int)$eachledger['ledger_parent_acc']]['amount'] += $arr_tb[$eachledger['ledger_id']]['amount'];
        }
        // -------------------------------------------------------
        if ($eachledger['ledger_id'] == $closing_stock) {
            $arr_tb[$closing_stock]['amount'] += $closing_balance_amt;
            if ((int)$eachledger['ledger_parent_acc'] > 0) {
                $arr_tb[(int)$eachledger['ledger_parent_acc']]['amount'] +=  $closing_balance_amt;
            }
        }
        if ($eachledger['ledger_id'] == $opening_stock) {
            $arr_tb[$opening_stock]['amount'] += $opening_balance_amt;
            if ((int)$eachledger['ledger_parent_acc'] > 0) {
                $arr_tb[(int)$eachledger['ledger_parent_acc']]['amount'] += $opening_balance_amt;
            }
        }
        // -------------------------------------------------------

    }



    foreach ($arr_ledgers as $eachledger) {
        $style_tr = '';
        $debit = 0.00;
        $credit = 0.00;
        $netamount = 0.00;

        //Net Profit
        if (in_array($eachledger['ledger_main_acc'], ['NP', 'GP', 'EB'])) {
            $sqlVI = "SELECT IFNULL(SUM(amount),0) FROM view_profit_and_loss WHERE ledger_main_acc IN ('I','E','CO') AND  ledger_acc_no<=" . $eachledger['ledger_acc_no'];
            $netamount = Yii::app()->db->createCommand($sqlVI)->queryScalar();

            $opening_stock = $arr_tb[$opening_stock]['amount'];
            $closing_stock = $arr_tb[$closing_stock]['amount'];
            $netamount = $netamount + $opening_stock + $closing_stock;

            if ($netamount > 0) {
                $debit = $netamount;
                $style_tr = ' levelnetloss';
            } else {
                $credit = $netamount;
                $style_tr = ' levelnet';
            }
        } else {
            if ($arr_tb[$eachledger['id']]['amount'] > 0) {
                $debit = $arr_tb[$eachledger['id']]['amount'];
            } else {
                $credit = $arr_tb[$eachledger['id']]['amount'];
            }
        }

    ?>
        <?php
        if ($company < 0 || $company == '') {
            $company = 0;
        }
        if ($eachledger['is_parent'] == 'N') {
            $count = $arr_tb[$eachledger['id']]['transaction_count'];
            if ($eachledger['have_subledger'] == 'Y') {
                $link = 'js:load_pl_summary_pl(' . $eachledger['id'] . ', \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\');';
            } else {
                if ($count < 300) {
                    $link = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
                    $link = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' . date('d/m/Y', strtotime($from_date)) . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }
            if ($eachledger['id'] == $closing_stock) {
                if ($count < 300) {
                    $linkop = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('31/12/2020') . '\', \'' . date('d/m/Y', strtotime($from_date)) . '\')';
                    $linkcl = 'js:Load_pl_gl_report(' . $eachledger['id'] . ',0, 0, \'' . date('31/12/2020') . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                } else {
                    $linkop = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' .  date('31/12/2020') . '\', \'' . date('d/m/Y', strtotime($from_date)) . '\')';
                    $linkcl = 'js:load_pl_gl_summary_tab_excel(' . $eachledger['id'] . ',0,\'' .  date('31/12/2020') . '\', \'' . date('d/m/Y', strtotime($to_date)) . '\')';
                }
            }
            $accountName = '<a href="#" onclick="' . $link . '">' . $eachledger['ledger_acc_name'] . '</a>';
        } else {
            $link = '';
            $accountName = '' . $eachledger['ledger_acc_name'] . '';
        }
        if ($type != 'NZ' || abs($debit) > 0 || abs($credit) > 0 || $eachledger['level'] == 1) { ?>
            <tr class="l<?php echo $eachledger['level'] . $style_tr; ?> level<?php echo $eachledger['level']; ?>">
                <td class="l1"><?php echo $eachledger['ledger_acc_no']; ?></td>
                <td class="level-<?php echo $eachledger['level']; ?> l<?php echo $eachledger['level']; ?>"><b><?php echo $accountName; ?></b>
                    <?php if ($eachledger['id'] == $closing_stock) {
                        // echo '(<a href="#" onclick="' . $linkop . '" style="color:blueviolet;">Opening Stock - '. $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($opening_balance_amt)).'</a> ,
                        //  <a href="#" onclick="' . $linkcl . '" style="color:blueviolet;">Closing Stock - '.$modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($closing_balance_amt)).'</a>)';
                    } ?>
                </td>
                <td class="txt-right l<?php echo $eachledger['level']; ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat($debit);  ?></td>
                <td class="txt-right l<?php echo $eachledger['level']; ?>"><?php echo $modelMasCurrency->baseCurrencyDecimalNumberFormat(abs($credit)); ?></td>
            </tr>
    <?php
        }
    }
    ?>
</table>