<!-- // chart of accounts 
//  general ledger report
// date 01-11-2022
// author -Indhu 
// main setup -->

<?php
$cs = Yii::app()->getClientScript();

$cs->registerScript("loadPage", "function loadPage(){
    var ledger_id = $('#ledger_id').val();
    if(ledger_id==''){
        t8.error('Please Select Ledger');
    }else{
            $('#loader').show();
           
          
            jQuery.ajax({
                'type': 'post',
                'url': '" . Yii::app()->createUrl('accounts/reports/gl_html') . "',
                'data' : {
                      'date_field'            : $('#date_field').val(),
                      'from'                  : $('#acc_report_from').val() ,
                      'to'                    : $('#acc_report_to').val() ,
                      'ledger_id'             : $('#ledger_id').val(),
                      'subledger_id'          : $('#subledger_id').val(),
                      'currency'              : $('#currency').val(),
                      'acc_warehouse_id'      : $('#acc_warehouse_id').val(),
                      'acc_department_id'     : $('#acc_department_id').val() ,
                      'acc_outlet_id'         : $('#acc_outlet_id').val() ,
                      'acc_report_brand'      : $('#acc_report_brand').val() ,
                     
                 },
                'success': function(data) {
                    $('#data_div').show();
                    $('.main-li-data').html(data);
                    $('#loader').hide();

                    $('#gl_table').aCollapTable({
                        startCollapsed: true,
                        addColumn: false,
                        plusButton: '<i class=\"fa fa-plus\"></i>&nbsp;', 
                        minusButton: '<i class=\"fa fa-minus\"></i>&nbsp;' 
                    });
                }
            });
        }
        }", CClientScript::POS_HEAD);
$cs->registerScript("showHide", "function showHide(){
        }", CClientScript::POS_HEAD);


$cs->registerScript("getSublegders", "function getSublegders(field_id)
        {
           account_id = $('#ledger_id').val();
           $('#subledger_id').val(0);
           if( account_id > 0 ){
                var url = '" . Yii::app()->createUrl('accounts/subledgers/subledgerlist') . "&ledger='+account_id;
                $('#'+field_id).autocomplete({
                    minLength   : 1,
                    source      : function (request, response) { autoCompleteSource(request, response, url) },
                    focus       : function( event, ui ) {},
                    select          : function( event, ui ) {
                        event.preventDefault();
                        $('#subledger_name').val(ui.item.label);
                        $('#subledger_id').val(ui.item.value);
                    }
                })
            }else{
                t8.error('Choose Ledger First!');
                $('#subledger_name').val('');
                return false;
            }
        }", CClientScript::POS_HEAD);

$cs->registerScript("autoCompleteLedger", "function autoCompleteLedger(field_id,frm)

        {
            $('#ledger_id').val('');
            var url = '" . Yii::app()->createUrl('accounts/accounts/GetLedgerDetails') . "'+'&frm='+frm;
        
                $('#'+field_id).autocomplete({
        
                    minLength   : 1,
        
                    source      : function (request, response) { autoCompleteSource(request, response,url) },
        
                    focus       : function( event, ui ) { $(this).val((ui.item.label)); return false;},
        
                    select          : function( event, ui ) {
        
                        event.preventDefault();
            
                        trigger_target_id  	=   $(event.target).attr('id');
            
                        var ledger_id=ui.item.value; 

                    $('#ledger_id').val(ledger_id);

                        jQuery.ajax({
                            'data' :{'ledger_id':ledger_id},
                            'type':'post',
                            'url': '" . Yii::app()->createUrl('accounts/accounts/GetLedgersSubledger') . "',
                            'success': function(data) {
                                $('#li_subledger_div').html(data);
                    
                            }
                        });
                    }
            
                });
        
        
        
                }", CClientScript::POS_HEAD);

?>

<style>
  table {
    font-family: arial, sans-serif !important;
    border-collapse: collapse !important;
    width: 100% !important;
  }

  td,
  th {
    border: 1px solid #dddddd !important;
    text-align: left !important;
    padding: 8px !important;
  }

  table th {
    padding-top: 12px;
    padding-bottom: 12px;
    text-align: left;
    background-color: #1f67b2;
    color: white;
  }

  /* tr:nth-child(even) {
  background-color: #f2f2f2 !important;
} */
</style>
<div class="row">
  <div class="col-sm-12">
    <section class="panel">
      <header class="panel-heading clearfix">
        <!--<span class="rpt-sub-panel-title" id="span_sales_title">General Ledger Report</span> <br>-->
        <?php

        /* $fin_month = Yii::app()->user->fin_year;

                $year = date('Y');
                $year_next = $year + 1;
                if ($fin_month == 1) {
                    $from_date = $year . '-01-01';
                    $end_date = $year . '-12-31';
                } else {
                    $from_date = $year . '-04-01';
                    $end_date = $year_next . '-03-31';
                }
                $startDate = date("d-m-Y", strtotime($from_date));

                $endDate = date("d-m-Y", strtotime($end_date));*/

        $startDate = date("d/m/Y");
        $endDate = date("d/m/Y");

        ?>

      </header>
      <header class="panel-heading clearfix selct-comn-wrp">
        <ul class="clearfix form-ul material">

          <li class="col-sm-2">

            <?php
            echo CHtml::dropDownList("date_field", '', array('voucher_date' => 'Voucher Date', 'posted_date' => 'Posted Date'), array('class' => 'tooltipster', 'title' => 'Date Field', 'data-label' => 'Date Field'));
            ?>

          </li>

          <li class="col-sm-2">
            <?php echo CHtml::textField('acc_report_from', $startDate, array('class' => 'datepicker tooltipster', 'data-label' => 'From')); ?>
          </li>
          <li class="col-sm-2">
            <?php echo CHtml::textField('acc_report_to', $endDate, array('class' => 'datepicker tooltipster', 'data-label' => 'To')); ?>
          </li>
          <li class="col-sm-2">

            <?php echo CHtml::textField('ledger_name', '', array('class' => 'tooltipster', 'placeholder' => 'Type & Select', 'data-label' => 'Ledger', 'onKeyup' => 'js:autoCompleteLedger(this.id,"AccVoucherTypeDetails");')); ?>
            <?php echo CHtml::hiddenField('ledger_id'); ?>

          </li>
          <!-- <li class="col-sm-3">
                        <?php //echo CHtml::hiddenField("subledger_id"); 
                        ?>
                        <?php //echo CHtml::textField("subledger_name", '', array('data-label' => 'Subledger', 'class' => 'tooltipster', 'onKeyup' => 'js:getSublegders(this.id);', 'data-label' => 'Sub ledger')); 
                        ?>
                    </li> -->
          <li id="li_subledger_div" class="col-sm-2">
            <div class="material">
              <?php
              echo CHtml::dropDownList("subledger_id", '', array(), array('class' => 'tooltipster', 'empty' => 'Select', 'title' => 'Subledger', 'data-label' => 'Subledger'));
              ?>
            </div>
          </li>





          <li class="col-sm-2">
            <?php
            $modelMasCurrency = new MasCurrency();
            $modelMasCurrency_array = $modelMasCurrency->getCurrency();
            echo CHtml::dropDownList("currency", '', $modelMasCurrency_array, array('class' => 'tooltipster', 'title' => 'Currency', 'data-label' => 'Currency', 'value' => MasCurrency::base_currency_id()));
            ?>
          </li>
       

       



          <?php
          $costcenter_1 = $costcenter_2 = 'N';

          // Check if the table exists
          $tableExists = Yii::app()->db->createCommand("SHOW TABLES LIKE '{{acc_general_settings}}'")->queryScalar();
          if ($tableExists) {
            $acc_settings = Yii::app()->db->createCommand("SELECT costcenter_1, costcenter_2 FROM {{acc_general_settings}}")->queryRow();
            $costcenter_1 = $acc_settings['costcenter_1'] ?? 'N';
            $costcenter_2 = $acc_settings['costcenter_2'] ?? 'N';
          }

          // Define a function to get the necessary data based on cost center
          function getCostCenterData($costcenter)
          {
            switch ($costcenter) {
              case 'BRANCH':
                $id_name = 'warehouse';
                $fieldname = 'acc_warehouse_id';
                $label = 'Warehouse';
                $model = new MasInventoryWarehouse();
                $array = $model->getWarehouse();
                break;
              case 'OUTLET':
                $id_name = 'outlet';
                $fieldname = 'acc_outlet_id';
                $label = 'Outlet';
                $model = new MasOutlet();
                $array = $model->getOutlet();
                break;
              case 'DEPARTMENT':
                $id_name = 'department';
                $fieldname = 'acc_department_id';
                $label = 'Department';
                $model = new MasDepartment();
                $array = $model->getDepartment();
                break;
              default:
                $id_name = $fieldname = $label = '';
                $array = [];
            }
            return compact('id_name', 'fieldname', 'label', 'array');
          }



          // Get data for both cost centers
          $data_1 = getCostCenterData($costcenter_1);
          $data_2 = getCostCenterData($costcenter_2);
          ?>

          <li class="col-sm-3 clshide" id="<?php echo $data_1['id_name']; ?>" style="display: none">
            <?php echo CHtml::dropDownList($data_1['fieldname'], '', $data_1['array'], array('data-label' => $data_1['label'], 'data-search' => 'true', 'empty' => 'Select')); ?>
          </li>

          <li class="col-sm-3 clshide" id="<?php echo $data_2['id_name']; ?>" style="display: none">
            <?php echo CHtml::dropDownList($data_2['fieldname'], '', $data_2['array'], array('data-label' => $data_2['label'], 'data-search' => 'true', 'empty' => 'Select')); ?>
          </li>




          <br>
          <br>
          <div class="btn-wrap text-center">
            <!--<a type="button" class="btn btn-sm btn-theme edit_about">Additional Details</a>-->

            <a type="button" class="btn btn-sm btn-theme" onclick="loadPage();">HTML</a>
           
            <a type="button" class="btn btn-sm btn-theme" 
                onclick="if ($('#ledger_id').val() !== '') {
                      window.open(
                         $('#liveSite').val() + 'index.php?r=accounts/pdf/gl_report_pdf' +
                         '&date_field=' + $('#date_field').val() +
                         '&from=' + $('#acc_report_from').val() +
                         '&to=' + $('#acc_report_to').val() +
                         '&ledger_id=' + $('#ledger_id').val() +
                         '&subledger_id=' + $('#subledger_id').val() +
                         '&currency=' + $('#currency').val() +
                         '&acc_outlet_id=' + $('#acc_outlet_id').val() +
                         '&acc_department_id=' + $('#acc_department_id').val() +
                         '&acc_warehouse_id=' + $('#acc_warehouse_id').val()+
                         '&acc_report_brand=' + $('#acc_report_brand').val(),
                         '_blank'
                      );
                   } else {
                      alert('Choose Ledger!');
                   }">
                   PDF
            </a>
            <a type="button" class="btn btn-sm btn-theme" 
                onclick="if ($('#ledger_id').val() !== '') {
                      window.open(
                         $('#liveSite').val() + 'index.php?r=accounts/excel/gl_report_Excel' +
                         '&date_field=' + $('#date_field').val() +
                         '&from=' + $('#acc_report_from').val() +
                         '&to=' + $('#acc_report_to').val() +
                         '&ledger_id=' + $('#ledger_id').val() +
                         '&subledger_id=' + $('#subledger_id').val() +
                         '&currency=' + $('#currency').val() +
                         '&acc_outlet_id=' + $('#acc_outlet_id').val() +
                         '&acc_department_id=' + $('#acc_department_id').val() +
                         '&acc_warehouse_id=' + $('#acc_warehouse_id').val()+
                         '&acc_report_brand=' + $('#acc_report_brand').val(),
                         '_blank'
                      );
                   } else {
                      alert('Choose Ledger!');
                   }">
                   XLS
            </a>
        

          </div>



        </ul>
      </header>
      <div class="panel-body" id="data_div" style="display:none;">
        <!-- <ul class="nav nav-tabs company-nav-tabs nav-tab-theme">
                    <li class="main-li active"><a href="#gl_tab" data-toggle="tab">General Ledger</a></li>
                </ul> -->
        <div class="tab-content">
          <div class="tab-pane main-li-data active" id="gl_tab">
          </div>
        </div>
    </section>
  </div>
</div>
<script>
  $(document).ready(function() {

    $(".edit_about").click(function() {
      $("#company").show();
      $("#costcenter").show();
      $("#salesgroup").show();
      $("#brand").show();
      $("#department").show();
      $("#outlet").show();
      $("#warehouse").show();
    });
  });
</script>